(ns js.BigInt
  "BigInt is a built-in object that provides a way to represent
  numbers larger than 253 - 1, which is the largest number JavaScript
  reliably represent with the `js.Number` primitive. BigInt can
  used for arbitrarily large integers."
  (:refer-clojure :exclude []))

(defn as-int-n
  "Method.

  The BigInt.asIntN static method is used to wrap a BigInt value
  a signed integer between -2width-1 and 2width-1-1.

  `BigInt.asIntN(width, bigint);`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/BigInt/asIntN`"
  [this width bigint]
  (-> this (.asIntN width bigint)))

(defn prototype
  "Property.

  The BigInt.prototype property represents the prototype for the
  constructor.

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/BigInt/prototype`"
  [this]
  (-> this (.prototype)))

(defn set-prototype!
  "Property.

  The BigInt.prototype property represents the prototype for the
  constructor.

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/BigInt/prototype`"
  [this val]
  (aset this "prototype" val))

