(ns js.Atomics
  "The Atomics object provides atomic operations as static methods.
  are used with `js.SharedArrayBuffer` objects."
  (:refer-clojure :exclude [load]))

(defn add
  "Method.

  The static Atomics.add() method adds a given value at a given
  in the array and returns the old value at that position. This
  operation guarantees that no other write happens until the modified
  is written back.

  `Atomics.add(typedArray, index, value)`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Atomics/add`"
  [this typed-array index value]
  (-> this (.add typed-array index value)))

(defn load
  "Method.

  The static Atomics.load() method returns a value at a given position
  the array.

  `Atomics.load(typedArray, index)`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Atomics/load`"
  [this typed-array index]
  (-> this (.load typed-array index)))

(defn wait
  "Method.

  The static Atomics.wait() method verifies that a given position
  an `js.Int32Array` still contains a given value and if so sleeps,
  a wakeup or a timeout. It returns a string which is either \\\"ok\\\",
  or \\\"timed-out\\\".

  `Atomics.wait(typedArray, index, value[, timeout])`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Atomics/wait`"
  [this & args]
  (apply (-> this .-wait) (concat [this] args)))

