(ns js.ArrayBuffer
  "The ArrayBuffer object is used to represent a generic, fixed-length
  binary data buffer."
  (:refer-clojure :exclude []))

(defn is-view
  "Method.

  The ArrayBuffer.isView() method returns true if arg is one of
  ArrayBuffer views, such as typed array objects or a `js.DataView`;
  otherwise.

  `ArrayBuffer.isView(arg)`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/ArrayBuffer/isView`"
  [this arg]
  (-> this (.isView arg)))

(defn length
  "Property.

  The ArrayBuffer constructor's length property whose value is"
  [this]
  (-> this (.length)))

(defn set-length!
  "Property.

  The ArrayBuffer constructor's length property whose value is"
  [this val]
  (aset this "length" val))

