(ns js.Array
  "The JavaScript Array object is a global object that is used in
  construction of arrays; which are high-level, list-like objects."
  (:refer-clojure :exclude []))

(defn from
  "Method.

  The Array.from() method creates a new, shallow-copied Array instance
  an array-like or iterable object.

  `Array.from(arrayLike[, mapFn[, thisArg]])`

  See also: `https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/from`"
  [this & args]
  (apply (-> this .-from) (concat [this] args)))

(defn length
  "Property.

  The Array constructor's length property whose value is 1."
  [this]
  (-> this (.length)))

(defn set-length!
  "Property.

  The Array constructor's length property whose value is 1."
  [this val]
  (aset this "length" val))

