(ns performance.PerformanceObserverEntryList
  "The PerformanceObserverEntryList interface is a list of peformance
  that were explicitly observed via the `web.observe()` method."
  (:refer-clojure :exclude []))

(defn get-entries
  "Method.

  The getEntries() method of the `performance.PerformanceObserverEntryList`
  returns a list of explicitly observed performance entry objects
  a given filter. The list's members are determined by the set
  entry types specified in the call to the `web.observe()` method.
  list is available in the observer's callback function (as the
  parameter in the callback).

  `General syntax:



  entries = list.getEntries();
  entries = list.getEntries(PerformanceEntryFilterOptions);

  Specific usage:



  entries = list.getEntries({name: \\\"entry_name\\\", entryType: \\\"mark\\\"});`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/PerformanceObserverEntryList/getEntries`"
  [this & args]
  (apply (-> this .-getEntries) (concat [this] args)))

(defn get-entries-by-name
  "Method.

  The getEntriesByName() method of the `performance.PerformanceObserverEntryList`
  returns a list of explicitly observed performance entry objects
  a given `web.name` and `web.entry type`. The list's members are
  by the set of entry types specified in the call to the `web.observe()`
  The list is available in the observer's callback function (as
  first parameter in the callback).

  `entries = list.getEntriesByName(name, type);`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/PerformanceObserverEntryList/getEntriesByName`"
  [this name type]
  (-> this (.getEntriesByName name type)))

(defn get-entries-by-type
  "Method.

  The getEntriesByType() method of the `performance.PerformanceObserverEntryList`
  a list of explicitly observed performance entry objects for a
  performance entry type. The list's members are determined by
  set of entry types specified in the call to the `web.observe()`
  The list is available in the observer's callback function (as
  first parameter in the callback).

  `entries = list.getEntriesByType(type);`

  See also: `https://developer.mozilla.org/en-US/docs/Web/API/PerformanceObserverEntryList/getEntriesByType`"
  [this type]
  (-> this (.getEntriesByType type)))

