(ns com.microsoft.azure.storage.Constants$QueryConstants
  "Defines constants for use with query strings."
  (:refer-clojure :only [require comment defn ->])
  (:import [com.microsoft.azure.storage Constants$QueryConstants]))

(defn ->constants.-query-constants
  "Constructor."
  (^Constants$QueryConstants []
    (new Constants$QueryConstants )))

(def *-api-version
  "Static Constant.

  The query component for the api version.

  type: java.lang.String"
  Constants$QueryConstants/API_VERSION)

(def *-cache-control
  "Static Constant.

  Query component for SAS cache control.

  type: java.lang.String"
  Constants$QueryConstants/CACHE_CONTROL)

(def *-content-type
  "Static Constant.

  Query component for SAS content type.

  type: java.lang.String"
  Constants$QueryConstants/CONTENT_TYPE)

(def *-content-encoding
  "Static Constant.

  Query component for SAS content encoding.

  type: java.lang.String"
  Constants$QueryConstants/CONTENT_ENCODING)

(def *-content-language
  "Static Constant.

  Query component for SAS content language.

  type: java.lang.String"
  Constants$QueryConstants/CONTENT_LANGUAGE)

(def *-content-disposition
  "Static Constant.

  Query component for SAS content disposition.

  type: java.lang.String"
  Constants$QueryConstants/CONTENT_DISPOSITION)

(def *-component
  "Static Constant.

  Query component for the operation (component) to access.

  type: java.lang.String"
  Constants$QueryConstants/COMPONENT)

(def *-copy
  "Static Constant.

  Query component for copy.

  type: java.lang.String"
  Constants$QueryConstants/COPY)

(def *-copy-id
  "Static Constant.

  Query component for the copy ID.

  type: java.lang.String"
  Constants$QueryConstants/COPY_ID)

(def *-end-partition-key
  "Static Constant.

  The query component for the SAS end partition key.

  type: java.lang.String"
  Constants$QueryConstants/END_PARTITION_KEY)

(def *-end-row-key
  "Static Constant.

  The query component for the SAS end row key.

  type: java.lang.String"
  Constants$QueryConstants/END_ROW_KEY)

(def *-list
  "Static Constant.

  Query component value for list.

  type: java.lang.String"
  Constants$QueryConstants/LIST)

(def *-properties
  "Static Constant.

  Query component value for properties.

  type: java.lang.String"
  Constants$QueryConstants/PROPERTIES)

(def *-resourcetype
  "Static Constant.

  Query component for resource type.

  type: java.lang.String"
  Constants$QueryConstants/RESOURCETYPE)

(def *-sas-table-name
  "Static Constant.

  The query component for the SAS table name.

  type: java.lang.String"
  Constants$QueryConstants/SAS_TABLE_NAME)

(def *-signature
  "Static Constant.

  The query component for the SAS signature.

  type: java.lang.String"
  Constants$QueryConstants/SIGNATURE)

(def *-signed-expiry
  "Static Constant.

  The query component for the signed SAS expiry time.

  type: java.lang.String"
  Constants$QueryConstants/SIGNED_EXPIRY)

(def *-signed-identifier
  "Static Constant.

  The query component for the signed SAS identifier.

  type: java.lang.String"
  Constants$QueryConstants/SIGNED_IDENTIFIER)

(def *-signed-ip
  "Static Constant.

  The query component for the signed SAS IP address.

  type: java.lang.String"
  Constants$QueryConstants/SIGNED_IP)

(def *-signed-key
  "Static Constant.

  The query component for the signing SAS key.

  type: java.lang.String"
  Constants$QueryConstants/SIGNED_KEY)

(def *-signed-permissions
  "Static Constant.

  The query component for the signed SAS permissions.

  type: java.lang.String"
  Constants$QueryConstants/SIGNED_PERMISSIONS)

(def *-signed-protocols
  "Static Constant.

  The query component for the signed SAS Internet protocols.

  type: java.lang.String"
  Constants$QueryConstants/SIGNED_PROTOCOLS)

(def *-signed-resource
  "Static Constant.

  The query component for the signed SAS resource.

  type: java.lang.String"
  Constants$QueryConstants/SIGNED_RESOURCE)

(def *-signed-resource-type
  "Static Constant.

  The query component for the signed SAS resource type.

  type: java.lang.String"
  Constants$QueryConstants/SIGNED_RESOURCE_TYPE)

(def *-signed-service
  "Static Constant.

  The query component for the signed SAS service.

  type: java.lang.String"
  Constants$QueryConstants/SIGNED_SERVICE)

(def *-signed-start
  "Static Constant.

  The query component for the signed SAS start time.

  type: java.lang.String"
  Constants$QueryConstants/SIGNED_START)

(def *-signed-version
  "Static Constant.

  The query component for the signed SAS version.

  type: java.lang.String"
  Constants$QueryConstants/SIGNED_VERSION)

(def *-snapshot
  "Static Constant.

  The query component for snapshot time.

  type: java.lang.String"
  Constants$QueryConstants/SNAPSHOT)

(def *-share-snapshot
  "Static Constant.

  The query component for snapshot time.

  type: java.lang.String"
  Constants$QueryConstants/SHARE_SNAPSHOT)

(def *-undelete
  "Static Constant.

  The query component for un-delete operation.

  type: java.lang.String"
  Constants$QueryConstants/UNDELETE)

(def *-start-partition-key
  "Static Constant.

  The query component for the SAS start partition key.

  type: java.lang.String"
  Constants$QueryConstants/START_PARTITION_KEY)

(def *-start-row-key
  "Static Constant.

  The query component for the SAS start row key.

  type: java.lang.String"
  Constants$QueryConstants/START_ROW_KEY)

(def *-stats
  "Static Constant.

  The query component for stats.

  type: java.lang.String"
  Constants$QueryConstants/STATS)

(def *-delimiter
  "Static Constant.

  The query component for delimiter.

  type: java.lang.String"
  Constants$QueryConstants/DELIMITER)

(def *-include
  "Static Constant.

  The query component for include.

  type: java.lang.String"
  Constants$QueryConstants/INCLUDE)

(def *-marker
  "Static Constant.

  The query component for marker.

  type: java.lang.String"
  Constants$QueryConstants/MARKER)

(def *-max-results
  "Static Constant.

  The query component for max results.

  type: java.lang.String"
  Constants$QueryConstants/MAX_RESULTS)

(def *-metadata
  "Static Constant.

  The query component for metadata.

  type: java.lang.String"
  Constants$QueryConstants/METADATA)

(def *-prefix
  "Static Constant.

  The query component for prefix.

  type: java.lang.String"
  Constants$QueryConstants/PREFIX)

(def *-acl
  "Static Constant.

  The query component for acl.

  type: java.lang.String"
  Constants$QueryConstants/ACL)

