/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.java2d;

import java.awt.geom.GeneralPath;
import org.postgis.Geometry;
import org.postgis.binary.ByteGetter;
import org.postgis.binary.ValueGetter;

public class ShapeBinaryParser {
    public static ValueGetter valueGetterForEndian(ByteGetter bytes) {
        if (bytes.get(0) == 0) {
            return new ValueGetter.XDR(bytes);
        }
        if (bytes.get(0) == 1) {
            return new ValueGetter.NDR(bytes);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + bytes.get(0));
    }

    public synchronized int parse(String value, GeneralPath path) {
        ByteGetter.StringByteGetter bytes = new ByteGetter.StringByteGetter(value);
        return this.parseGeometry(ShapeBinaryParser.valueGetterForEndian(bytes), path);
    }

    public synchronized int parse(byte[] value, GeneralPath path) {
        ByteGetter.BinaryByteGetter bytes = new ByteGetter.BinaryByteGetter(value);
        return this.parseGeometry(ShapeBinaryParser.valueGetterForEndian(bytes), path);
    }

    protected int parseGeometry(ValueGetter data, GeneralPath path) {
        byte endian = data.getByte();
        if (endian != data.endian) {
            throw new IllegalArgumentException("Endian inconsistency!");
        }
        int typeword = data.getInt();
        int realtype = typeword & 0x1FFFFFFF;
        boolean haveZ = (typeword & Integer.MIN_VALUE) != 0;
        boolean haveM = (typeword & 0x40000000) != 0;
        boolean haveS = (typeword & 0x20000000) != 0;
        int srid = 0;
        if (haveS) {
            srid = Geometry.parseSRID(data.getInt());
        }
        switch (realtype) {
            case 1: {
                this.parsePoint(data, haveZ, haveM, path);
                break;
            }
            case 2: {
                this.parseLineString(data, haveZ, haveM, path);
                break;
            }
            case 3: {
                this.parsePolygon(data, haveZ, haveM, path);
                break;
            }
            case 4: {
                this.parseMultiPoint(data, path);
                break;
            }
            case 5: {
                this.parseMultiLineString(data, path);
                break;
            }
            case 6: {
                this.parseMultiPolygon(data, path);
                break;
            }
            case 7: {
                this.parseCollection(data, path);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type!");
            }
        }
        return srid;
    }

    private void parsePoint(ValueGetter data, boolean haveZ, boolean haveM, GeneralPath path) {
        path.moveTo((float)data.getDouble(), (float)data.getDouble());
        path.closePath();
        this.skipZM(data, haveZ, haveM);
    }

    private void skipZM(ValueGetter data, boolean haveZ, boolean haveM) {
        if (haveZ) {
            data.getDouble();
        }
        if (haveM) {
            data.getDouble();
        }
    }

    private void parseGeometryArray(ValueGetter data, int count, GeneralPath path) {
        for (int i = 0; i < count; ++i) {
            this.parseGeometry(data, path);
        }
    }

    private void parseCS(ValueGetter data, boolean haveZ, boolean haveM, GeneralPath path) {
        int count = data.getInt();
        if (count > 0) {
            path.moveTo((float)data.getDouble(), (float)data.getDouble());
            this.skipZM(data, haveZ, haveM);
            for (int i = 1; i < count; ++i) {
                path.lineTo((float)data.getDouble(), (float)data.getDouble());
                this.skipZM(data, haveZ, haveM);
            }
        }
    }

    private void parseMultiPoint(ValueGetter data, GeneralPath path) {
        this.parseGeometryArray(data, data.getInt(), path);
    }

    private void parseLineString(ValueGetter data, boolean haveZ, boolean haveM, GeneralPath path) {
        this.parseCS(data, haveZ, haveM, path);
    }

    private void parseLinearRing(ValueGetter data, boolean haveZ, boolean haveM, GeneralPath path) {
        this.parseCS(data, haveZ, haveM, path);
        path.closePath();
    }

    private void parsePolygon(ValueGetter data, boolean haveZ, boolean haveM, GeneralPath path) {
        int holecount = data.getInt() - 1;
        this.parseLinearRing(data, haveZ, haveM, path);
        for (int i = 0; i < holecount; ++i) {
            this.parseLinearRing(data, haveZ, haveM, path);
        }
    }

    private void parseMultiLineString(ValueGetter data, GeneralPath path) {
        int count = data.getInt();
        this.parseGeometryArray(data, count, path);
    }

    private void parseMultiPolygon(ValueGetter data, GeneralPath path) {
        int count = data.getInt();
        this.parseGeometryArray(data, count, path);
    }

    private void parseCollection(ValueGetter data, GeneralPath path) {
        int count = data.getInt();
        this.parseGeometryArray(data, count, path);
    }
}

