(ns zhang.agent.process-table.impl
  "Implementation of the process-tracking table for the Zhang agent."
  (:require [clojure.pprint :as pprint]))

(defn table-printer
  ""
  [data]
  (pprint/print-table ["ID" "Function" "Channel"] data))

(defprotocol IProcessTable
  "The process table interface for Zhang."
  (add-process
    [process]
    [this process]
    "Add a process to the process table.")
  (lookup-process
    [id]
    [this id]
    "Lookup a process by id.")
  (list-processes
    [this]
    "List all processes.")
  (remove-process
    [id]
    [this id]
    "Remove the process with the given id from the process table."))

(defrecord ZhangProcessTable [chan data])

(defn list-processes
  [this]
  (table-printer (vals this)))

(defn add-process
  [this process]
  (reset! this
          (assoc this (:id process) process))
  process)

(defn lookup-process
  [this id]
  (get this id))

(defn remove-process
  [this id]
  (reset! this
          (dissoc this id)))

(def process-table-behaviour
  {:add-process add-process
   :lookup-process lookup-process
   :list-processes list-processes
   :remove-process remove-process})

(extend ZhangProcessTable
        IProcessTable
        process-table-behaviour)
