(ns leiningen.new.cljsr
  (:require
   [leiningen.new.templates :refer [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "cljsr"))

(defn cljsr
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized-path (name-to-path name)
              :sanitized-name (sanitize name)}]
    (->files data
             ["project.clj" (render "project.clj" data)]
             [".gitignore" (render "gitignore" data)]
             ["src/{{sanitized-path}}/core.cljs" (render "core.cljs" data)]
             ["dev/clj/repl.clj" (render "dev/clj/repl.clj")]
             ["dev/cljs/repl.cljs" (render "dev/cljs/repl.cljs")]
             ["resources/public/index.html" (render "resources/public/index.html" data)]
             )))
