THREE.ToneMapShader={uniforms:{tDiffuse:{value:null},averageLuminance:{value:1},luminanceMap:{value:null},maxLuminance:{value:16},minLuminance:{value:.01},middleGrey:{value:.6}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv \x3d uv;\ngl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform sampler2D tDiffuse;\nvarying vec2 vUv;\nuniform float middleGrey;\nuniform float minLuminance;\nuniform float maxLuminance;\n#ifdef ADAPTED_LUMINANCE\nuniform sampler2D luminanceMap;\n#else\nuniform float averageLuminance;\n#endif\nconst vec3 LUM_CONVERT \x3d vec3(0.299, 0.587, 0.114);\nvec3 ToneMap( vec3 vColor ) {\n#ifdef ADAPTED_LUMINANCE\nfloat fLumAvg \x3d texture2D(luminanceMap, vec2(0.5, 0.5)).r;\n#else\nfloat fLumAvg \x3d averageLuminance;\n#endif\nfloat fLumPixel \x3d dot(vColor, LUM_CONVERT);\nfloat fLumScaled \x3d (fLumPixel * middleGrey) / max( minLuminance, fLumAvg );\nfloat fLumCompressed \x3d (fLumScaled * (1.0 + (fLumScaled / (maxLuminance * maxLuminance)))) / (1.0 + fLumScaled);\nreturn fLumCompressed * vColor;\n}\nvoid main() {\nvec4 texel \x3d texture2D( tDiffuse, vUv );\ngl_FragColor \x3d vec4( ToneMap( texel.xyz ), texel.w );\n}"};