THREE.SSAOShader={uniforms:{tDiffuse:{value:null},tDepth:{value:null},size:{value:new THREE.Vector2(512,512)},cameraNear:{value:1},cameraFar:{value:100},radius:{value:32},onlyAO:{value:0},aoClamp:{value:.25},lumInfluence:{value:.7}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv \x3d uv;\ngl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform float cameraNear;\nuniform float cameraFar;\n#ifdef USE_LOGDEPTHBUF\nuniform float logDepthBufFC;\n#endif\nuniform float radius;\nuniform bool onlyAO;\nuniform vec2 size;\nuniform float aoClamp;\nuniform float lumInfluence;\nuniform sampler2D tDiffuse;\nuniform sampler2D tDepth;\nvarying vec2 vUv;\n#define DL 2.399963229728653\n#define EULER 2.718281828459045\nconst int samples \x3d 64;\nconst bool useNoise \x3d true;\nconst float noiseAmount \x3d 0.0004;\nconst float diffArea \x3d 0.4;\nconst float gDisplace \x3d 0.4;\n#include \x3cpacking\x3e\nvec2 rand( const vec2 coord ) {\nvec2 noise;\nif ( useNoise ) {\nfloat nx \x3d dot ( coord, vec2( 12.9898, 78.233 ) );\nfloat ny \x3d dot ( coord, vec2( 12.9898, 78.233 ) * 2.0 );\nnoise \x3d clamp( fract ( 43758.5453 * sin( vec2( nx, ny ) ) ), 0.0, 1.0 );\n} else {\nfloat ff \x3d fract( 1.0 - coord.s * ( size.x / 2.0 ) );\nfloat gg \x3d fract( coord.t * ( size.y / 2.0 ) );\nnoise \x3d vec2( 0.25, 0.75 ) * vec2( ff ) + vec2( 0.75, 0.25 ) * gg;\n}\nreturn ( noise * 2.0  - 1.0 ) * noiseAmount;\n}\nfloat readDepth( const in vec2 coord ) {\nfloat cameraFarPlusNear \x3d cameraFar + cameraNear;\nfloat cameraFarMinusNear \x3d cameraFar - cameraNear;\nfloat cameraCoef \x3d 2.0 * cameraNear;\n#ifdef USE_LOGDEPTHBUF\nfloat logz \x3d unpackRGBAToDepth( texture2D( tDepth, coord ) );\nfloat w \x3d pow(2.0, (logz / logDepthBufFC)) - 1.0;\nfloat z \x3d (logz / w) + 1.0;\n#else\nfloat z \x3d unpackRGBAToDepth( texture2D( tDepth, coord ) );\n#endif\nreturn cameraCoef / ( cameraFarPlusNear - z * cameraFarMinusNear );\n}\nfloat compareDepths( const in float depth1, const in float depth2, inout int far ) {\nfloat garea \x3d 8.0;\nfloat diff \x3d ( depth1 - depth2 ) * 100.0;\nif ( diff \x3c gDisplace ) {\ngarea \x3d diffArea;\n} else {\nfar \x3d 1;\n}\nfloat dd \x3d diff - gDisplace;\nfloat gauss \x3d pow( EULER, -2.0 * ( dd * dd ) / ( garea * garea ) );\nreturn gauss;\n}\nfloat calcAO( float depth, float dw, float dh ) {\nvec2 vv \x3d vec2( dw, dh );\nvec2 coord1 \x3d vUv + radius * vv;\nvec2 coord2 \x3d vUv - radius * vv;\nfloat temp1 \x3d 0.0;\nfloat temp2 \x3d 0.0;\nint far \x3d 0;\ntemp1 \x3d compareDepths( depth, readDepth( coord1 ), far );\nif ( far \x3e 0 ) {\ntemp2 \x3d compareDepths( readDepth( coord2 ), depth, far );\ntemp1 +\x3d ( 1.0 - temp1 ) * temp2;\n}\nreturn temp1;\n}\nvoid main() {\nvec2 noise \x3d rand( vUv );\nfloat depth \x3d readDepth( vUv );\nfloat tt \x3d clamp( depth, aoClamp, 1.0 );\nfloat w \x3d ( 1.0 / size.x ) / tt + ( noise.x * ( 1.0 - noise.x ) );\nfloat h \x3d ( 1.0 / size.y ) / tt + ( noise.y * ( 1.0 - noise.y ) );\nfloat ao \x3d 0.0;\nfloat dz \x3d 1.0 / float( samples );\nfloat l \x3d 0.0;\nfloat z \x3d 1.0 - dz / 2.0;\nfor ( int i \x3d 0; i \x3c\x3d samples; i ++ ) {\nfloat r \x3d sqrt( 1.0 - z );\nfloat pw \x3d cos( l ) * r;\nfloat ph \x3d sin( l ) * r;\nao +\x3d calcAO( depth, pw * w, ph * h );\nz \x3d z - dz;\nl \x3d l + DL;\n}\nao /\x3d float( samples );\nao \x3d 1.0 - ao;\nvec3 color \x3d texture2D( tDiffuse, vUv ).rgb;\nvec3 lumcoeff \x3d vec3( 0.299, 0.587, 0.114 );\nfloat lum \x3d dot( color.rgb, lumcoeff );\nvec3 luminance \x3d vec3( lum );\nvec3 final \x3d vec3( color * mix( vec3( ao ), vec3( 1.0 ), luminance * lumInfluence ) );\nif ( onlyAO ) {\nfinal \x3d vec3( mix( vec3( ao ), vec3( 1.0 ), luminance * lumInfluence ) );\n}\ngl_FragColor \x3d vec4( final, 1.0 );\n}"};