THREE.SMAAShader=[{defines:{SMAA_THRESHOLD:"0.1"},uniforms:{tDiffuse:{value:null},resolution:{value:new THREE.Vector2(1/1024,1/512)}},vertexShader:"uniform vec2 resolution;\nvarying vec2 vUv;\nvarying vec4 vOffset[ 3 ];\nvoid SMAAEdgeDetectionVS( vec2 texcoord ) {\nvOffset[ 0 ] \x3d texcoord.xyxy + resolution.xyxy * vec4( -1.0, 0.0, 0.0,  1.0 );\nvOffset[ 1 ] \x3d texcoord.xyxy + resolution.xyxy * vec4(  1.0, 0.0, 0.0, -1.0 );\nvOffset[ 2 ] \x3d texcoord.xyxy + resolution.xyxy * vec4( -2.0, 0.0, 0.0,  2.0 );\n}\nvoid main() {\nvUv \x3d uv;\nSMAAEdgeDetectionVS( vUv );\ngl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"uniform sampler2D tDiffuse;\nvarying vec2 vUv;\nvarying vec4 vOffset[ 3 ];\nvec4 SMAAColorEdgeDetectionPS( vec2 texcoord, vec4 offset[3], sampler2D colorTex ) {\nvec2 threshold \x3d vec2( SMAA_THRESHOLD, SMAA_THRESHOLD );\nvec4 delta;\nvec3 C \x3d texture2D( colorTex, texcoord ).rgb;\nvec3 Cleft \x3d texture2D( colorTex, offset[0].xy ).rgb;\nvec3 t \x3d abs( C - Cleft );\ndelta.x \x3d max( max( t.r, t.g ), t.b );\nvec3 Ctop \x3d texture2D( colorTex, offset[0].zw ).rgb;\nt \x3d abs( C - Ctop );\ndelta.y \x3d max( max( t.r, t.g ), t.b );\nvec2 edges \x3d step( threshold, delta.xy );\nif ( dot( edges, vec2( 1.0, 1.0 ) ) \x3d\x3d 0.0 )\ndiscard;\nvec3 Cright \x3d texture2D( colorTex, offset[1].xy ).rgb;\nt \x3d abs( C - Cright );\ndelta.z \x3d max( max( t.r, t.g ), t.b );\nvec3 Cbottom  \x3d texture2D( colorTex, offset[1].zw ).rgb;\nt \x3d abs( C - Cbottom );\ndelta.w \x3d max( max( t.r, t.g ), t.b );\nfloat maxDelta \x3d max( max( max( delta.x, delta.y ), delta.z ), delta.w );\nvec3 Cleftleft  \x3d texture2D( colorTex, offset[2].xy ).rgb;\nt \x3d abs( C - Cleftleft );\ndelta.z \x3d max( max( t.r, t.g ), t.b );\nvec3 Ctoptop \x3d texture2D( colorTex, offset[2].zw ).rgb;\nt \x3d abs( C - Ctoptop );\ndelta.w \x3d max( max( t.r, t.g ), t.b );\nmaxDelta \x3d max( max( maxDelta, delta.z ), delta.w );\nedges.xy *\x3d step( 0.5 * maxDelta, delta.xy );\nreturn vec4( edges, 0.0, 0.0 );\n}\nvoid main() {\ngl_FragColor \x3d SMAAColorEdgeDetectionPS( vUv, vOffset, tDiffuse );\n}"},
{defines:{SMAA_MAX_SEARCH_STEPS:"8",SMAA_AREATEX_MAX_DISTANCE:"16",SMAA_AREATEX_PIXEL_SIZE:"( 1.0 / vec2( 160.0, 560.0 ) )",SMAA_AREATEX_SUBTEX_SIZE:"( 1.0 / 7.0 )"},uniforms:{tDiffuse:{value:null},tArea:{value:null},tSearch:{value:null},resolution:{value:new THREE.Vector2(1/1024,1/512)}},vertexShader:"uniform vec2 resolution;\nvarying vec2 vUv;\nvarying vec4 vOffset[ 3 ];\nvarying vec2 vPixcoord;\nvoid SMAABlendingWeightCalculationVS( vec2 texcoord ) {\nvPixcoord \x3d texcoord / resolution;\nvOffset[ 0 ] \x3d texcoord.xyxy + resolution.xyxy * vec4( -0.25, 0.125, 1.25, 0.125 );\nvOffset[ 1 ] \x3d texcoord.xyxy + resolution.xyxy * vec4( -0.125, 0.25, -0.125, -1.25 );\nvOffset[ 2 ] \x3d vec4( vOffset[ 0 ].xz, vOffset[ 1 ].yw ) + vec4( -2.0, 2.0, -2.0, 2.0 ) * resolution.xxyy * float( SMAA_MAX_SEARCH_STEPS );\n}\nvoid main() {\nvUv \x3d uv;\nSMAABlendingWeightCalculationVS( vUv );\ngl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"#define SMAASampleLevelZeroOffset( tex, coord, offset ) texture2D( tex, coord + float( offset ) * resolution, 0.0 )\nuniform sampler2D tDiffuse;\nuniform sampler2D tArea;\nuniform sampler2D tSearch;\nuniform vec2 resolution;\nvarying vec2 vUv;\nvarying vec4 vOffset[3];\nvarying vec2 vPixcoord;\nvec2 round( vec2 x ) {\nreturn sign( x ) * floor( abs( x ) + 0.5 );\n}\nfloat SMAASearchLength( sampler2D searchTex, vec2 e, float bias, float scale ) {\ne.r \x3d bias + e.r * scale;\nreturn 255.0 * texture2D( searchTex, e, 0.0 ).r;\n}\nfloat SMAASearchXLeft( sampler2D edgesTex, sampler2D searchTex, vec2 texcoord, float end ) {\nvec2 e \x3d vec2( 0.0, 1.0 );\nfor ( int i \x3d 0; i \x3c SMAA_MAX_SEARCH_STEPS; i ++ ) {\ne \x3d texture2D( edgesTex, texcoord, 0.0 ).rg;\ntexcoord -\x3d vec2( 2.0, 0.0 ) * resolution;\nif ( ! ( texcoord.x \x3e end \x26\x26 e.g \x3e 0.8281 \x26\x26 e.r \x3d\x3d 0.0 ) ) break;\n}\ntexcoord.x +\x3d 0.25 * resolution.x;\ntexcoord.x +\x3d resolution.x;\ntexcoord.x +\x3d 2.0 * resolution.x;\ntexcoord.x -\x3d resolution.x * SMAASearchLength(searchTex, e, 0.0, 0.5);\nreturn texcoord.x;\n}\nfloat SMAASearchXRight( sampler2D edgesTex, sampler2D searchTex, vec2 texcoord, float end ) {\nvec2 e \x3d vec2( 0.0, 1.0 );\nfor ( int i \x3d 0; i \x3c SMAA_MAX_SEARCH_STEPS; i ++ ) {\ne \x3d texture2D( edgesTex, texcoord, 0.0 ).rg;\ntexcoord +\x3d vec2( 2.0, 0.0 ) * resolution;\nif ( ! ( texcoord.x \x3c end \x26\x26 e.g \x3e 0.8281 \x26\x26 e.r \x3d\x3d 0.0 ) ) break;\n}\ntexcoord.x -\x3d 0.25 * resolution.x;\ntexcoord.x -\x3d resolution.x;\ntexcoord.x -\x3d 2.0 * resolution.x;\ntexcoord.x +\x3d resolution.x * SMAASearchLength( searchTex, e, 0.5, 0.5 );\nreturn texcoord.x;\n}\nfloat SMAASearchYUp( sampler2D edgesTex, sampler2D searchTex, vec2 texcoord, float end ) {\nvec2 e \x3d vec2( 1.0, 0.0 );\nfor ( int i \x3d 0; i \x3c SMAA_MAX_SEARCH_STEPS; i ++ ) {\ne \x3d texture2D( edgesTex, texcoord, 0.0 ).rg;\ntexcoord +\x3d vec2( 0.0, 2.0 ) * resolution;\nif ( ! ( texcoord.y \x3e end \x26\x26 e.r \x3e 0.8281 \x26\x26 e.g \x3d\x3d 0.0 ) ) break;\n}\ntexcoord.y -\x3d 0.25 * resolution.y;\ntexcoord.y -\x3d resolution.y;\ntexcoord.y -\x3d 2.0 * resolution.y;\ntexcoord.y +\x3d resolution.y * SMAASearchLength( searchTex, e.gr, 0.0, 0.5 );\nreturn texcoord.y;\n}\nfloat SMAASearchYDown( sampler2D edgesTex, sampler2D searchTex, vec2 texcoord, float end ) {\nvec2 e \x3d vec2( 1.0, 0.0 );\nfor ( int i \x3d 0; i \x3c SMAA_MAX_SEARCH_STEPS; i ++ ) {\ne \x3d texture2D( edgesTex, texcoord, 0.0 ).rg;\ntexcoord -\x3d vec2( 0.0, 2.0 ) * resolution;\nif ( ! ( texcoord.y \x3c end \x26\x26 e.r \x3e 0.8281 \x26\x26 e.g \x3d\x3d 0.0 ) ) break;\n}\ntexcoord.y +\x3d 0.25 * resolution.y;\ntexcoord.y +\x3d resolution.y;\ntexcoord.y +\x3d 2.0 * resolution.y;\ntexcoord.y -\x3d resolution.y * SMAASearchLength( searchTex, e.gr, 0.5, 0.5 );\nreturn texcoord.y;\n}\nvec2 SMAAArea( sampler2D areaTex, vec2 dist, float e1, float e2, float offset ) {\nvec2 texcoord \x3d float( SMAA_AREATEX_MAX_DISTANCE ) * round( 4.0 * vec2( e1, e2 ) ) + dist;\ntexcoord \x3d SMAA_AREATEX_PIXEL_SIZE * texcoord + ( 0.5 * SMAA_AREATEX_PIXEL_SIZE );\ntexcoord.y +\x3d SMAA_AREATEX_SUBTEX_SIZE * offset;\nreturn texture2D( areaTex, texcoord, 0.0 ).rg;\n}\nvec4 SMAABlendingWeightCalculationPS( vec2 texcoord, vec2 pixcoord, vec4 offset[ 3 ], sampler2D edgesTex, sampler2D areaTex, sampler2D searchTex, ivec4 subsampleIndices ) {\nvec4 weights \x3d vec4( 0.0, 0.0, 0.0, 0.0 );\nvec2 e \x3d texture2D( edgesTex, texcoord ).rg;\nif ( e.g \x3e 0.0 ) {\nvec2 d;\nvec2 coords;\ncoords.x \x3d SMAASearchXLeft( edgesTex, searchTex, offset[ 0 ].xy, offset[ 2 ].x );\ncoords.y \x3d offset[ 1 ].y;\nd.x \x3d coords.x;\nfloat e1 \x3d texture2D( edgesTex, coords, 0.0 ).r;\ncoords.x \x3d SMAASearchXRight( edgesTex, searchTex, offset[ 0 ].zw, offset[ 2 ].y );\nd.y \x3d coords.x;\nd \x3d d / resolution.x - pixcoord.x;\nvec2 sqrt_d \x3d sqrt( abs( d ) );\ncoords.y -\x3d 1.0 * resolution.y;\nfloat e2 \x3d SMAASampleLevelZeroOffset( edgesTex, coords, ivec2( 1, 0 ) ).r;\nweights.rg \x3d SMAAArea( areaTex, sqrt_d, e1, e2, float( subsampleIndices.y ) );\n}\nif ( e.r \x3e 0.0 ) {\nvec2 d;\nvec2 coords;\ncoords.y \x3d SMAASearchYUp( edgesTex, searchTex, offset[ 1 ].xy, offset[ 2 ].z );\ncoords.x \x3d offset[ 0 ].x;\nd.x \x3d coords.y;\nfloat e1 \x3d texture2D( edgesTex, coords, 0.0 ).g;\ncoords.y \x3d SMAASearchYDown( edgesTex, searchTex, offset[ 1 ].zw, offset[ 2 ].w );\nd.y \x3d coords.y;\nd \x3d d / resolution.y - pixcoord.y;\nvec2 sqrt_d \x3d sqrt( abs( d ) );\ncoords.y -\x3d 1.0 * resolution.y;\nfloat e2 \x3d SMAASampleLevelZeroOffset( edgesTex, coords, ivec2( 0, 1 ) ).g;\nweights.ba \x3d SMAAArea( areaTex, sqrt_d, e1, e2, float( subsampleIndices.x ) );\n}\nreturn weights;\n}\nvoid main() {\ngl_FragColor \x3d SMAABlendingWeightCalculationPS( vUv, vPixcoord, vOffset, tDiffuse, tArea, tSearch, ivec4( 0.0 ) );\n}"},
{uniforms:{tDiffuse:{value:null},tColor:{value:null},resolution:{value:new THREE.Vector2(1/1024,1/512)}},vertexShader:"uniform vec2 resolution;\nvarying vec2 vUv;\nvarying vec4 vOffset[ 2 ];\nvoid SMAANeighborhoodBlendingVS( vec2 texcoord ) {\nvOffset[ 0 ] \x3d texcoord.xyxy + resolution.xyxy * vec4( -1.0, 0.0, 0.0, 1.0 );\nvOffset[ 1 ] \x3d texcoord.xyxy + resolution.xyxy * vec4( 1.0, 0.0, 0.0, -1.0 );\n}\nvoid main() {\nvUv \x3d uv;\nSMAANeighborhoodBlendingVS( vUv );\ngl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"uniform sampler2D tDiffuse;\nuniform sampler2D tColor;\nuniform vec2 resolution;\nvarying vec2 vUv;\nvarying vec4 vOffset[ 2 ];\nvec4 SMAANeighborhoodBlendingPS( vec2 texcoord, vec4 offset[ 2 ], sampler2D colorTex, sampler2D blendTex ) {\nvec4 a;\na.xz \x3d texture2D( blendTex, texcoord ).xz;\na.y \x3d texture2D( blendTex, offset[ 1 ].zw ).g;\na.w \x3d texture2D( blendTex, offset[ 1 ].xy ).a;\nif ( dot(a, vec4( 1.0, 1.0, 1.0, 1.0 )) \x3c 1e-5 ) {\nreturn texture2D( colorTex, texcoord, 0.0 );\n} else {\nvec2 offset;\noffset.x \x3d a.a \x3e a.b ? a.a : -a.b;\noffset.y \x3d a.g \x3e a.r ? -a.g : a.r;\nif ( abs( offset.x ) \x3e abs( offset.y )) {\noffset.y \x3d 0.0;\n} else {\noffset.x \x3d 0.0;\n}\nvec4 C \x3d texture2D( colorTex, texcoord, 0.0 );\ntexcoord +\x3d sign( offset ) * resolution;\nvec4 Cop \x3d texture2D( colorTex, texcoord, 0.0 );\nfloat s \x3d abs( offset.x ) \x3e abs( offset.y ) ? abs( offset.x ) : abs( offset.y );\nC.xyz \x3d pow(C.xyz, vec3(2.2));\nCop.xyz \x3d pow(Cop.xyz, vec3(2.2));\nvec4 mixed \x3d mix(C, Cop, s);\nmixed.xyz \x3d pow(mixed.xyz, vec3(1.0 / 2.2));\nreturn mixed;\n}\n}\nvoid main() {\ngl_FragColor \x3d SMAANeighborhoodBlendingPS( vUv, vOffset, tColor, tDiffuse );\n}"}];