THREE.SAOShader={defines:{NUM_SAMPLES:7,NUM_RINGS:4,NORMAL_TEXTURE:0,DIFFUSE_TEXTURE:0,DEPTH_PACKING:1,PERSPECTIVE_CAMERA:1},uniforms:{tDepth:{type:"t",value:null},tDiffuse:{type:"t",value:null},tNormal:{type:"t",value:null},size:{type:"v2",value:new THREE.Vector2(512,512)},cameraNear:{type:"f",value:1},cameraFar:{type:"f",value:100},cameraProjectionMatrix:{type:"m4",value:new THREE.Matrix4},cameraInverseProjectionMatrix:{type:"m4",value:new THREE.Matrix4},scale:{type:"f",value:1},intensity:{type:"f",
value:.1},bias:{type:"f",value:.5},minResolution:{type:"f",value:0},kernelRadius:{type:"f",value:100},randomSeed:{type:"f",value:0}},vertexShader:"varying vec2 vUv;\nvoid main() {\n\tvUv \x3d uv;\n\tgl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"#include \x3ccommon\x3e\nvarying vec2 vUv;\n#if DIFFUSE_TEXTURE \x3d\x3d 1\nuniform sampler2D tDiffuse;\n#endif\nuniform sampler2D tDepth;\n#if NORMAL_TEXTURE \x3d\x3d 1\nuniform sampler2D tNormal;\n#endif\nuniform float cameraNear;\nuniform float cameraFar;\nuniform mat4 cameraProjectionMatrix;\nuniform mat4 cameraInverseProjectionMatrix;\nuniform float scale;\nuniform float intensity;\nuniform float bias;\nuniform float kernelRadius;\nuniform float minResolution;\nuniform vec2 size;\nuniform float randomSeed;\n// RGBA depth\n#include \x3cpacking\x3e\nvec4 getDefaultColor( const in vec2 screenPosition ) {\n\t#if DIFFUSE_TEXTURE \x3d\x3d 1\n\treturn texture2D( tDiffuse, vUv );\n\t#else\n\treturn vec4( 1.0 );\n\t#endif\n}\nfloat getDepth( const in vec2 screenPosition ) {\n\t#if DEPTH_PACKING \x3d\x3d 1\n\treturn unpackRGBAToDepth( texture2D( tDepth, screenPosition ) );\n\t#else\n\treturn texture2D( tDepth, screenPosition ).x;\n\t#endif\n}\nfloat getViewZ( const in float depth ) {\n\t#if PERSPECTIVE_CAMERA \x3d\x3d 1\n\treturn perspectiveDepthToViewZ( depth, cameraNear, cameraFar );\n\t#else\n\treturn orthoDepthToViewZ( depth, cameraNear, cameraFar );\n\t#endif\n}\nvec3 getViewPosition( const in vec2 screenPosition, const in float depth, const in float viewZ ) {\n\tfloat clipW \x3d cameraProjectionMatrix[2][3] * viewZ + cameraProjectionMatrix[3][3];\n\tvec4 clipPosition \x3d vec4( ( vec3( screenPosition, depth ) - 0.5 ) * 2.0, 1.0 );\n\tclipPosition *\x3d clipW; // unprojection.\n\treturn ( cameraInverseProjectionMatrix * clipPosition ).xyz;\n}\nvec3 getViewNormal( const in vec3 viewPosition, const in vec2 screenPosition ) {\n\t#if NORMAL_TEXTURE \x3d\x3d 1\n\treturn -unpackRGBToNormal( texture2D( tNormal, screenPosition ).xyz );\n\t#else\n\treturn normalize( cross( dFdx( viewPosition ), dFdy( viewPosition ) ) );\n\t#endif\n}\nfloat scaleDividedByCameraFar;\nfloat minResolutionMultipliedByCameraFar;\nfloat getOcclusion( const in vec3 centerViewPosition, const in vec3 centerViewNormal, const in vec3 sampleViewPosition ) {\n\tvec3 viewDelta \x3d sampleViewPosition - centerViewPosition;\n\tfloat viewDistance \x3d length( viewDelta );\n\tfloat scaledScreenDistance \x3d scaleDividedByCameraFar * viewDistance;\n\treturn max(0.0, (dot(centerViewNormal, viewDelta) - minResolutionMultipliedByCameraFar) / scaledScreenDistance - bias) / (1.0 + pow2( scaledScreenDistance ) );\n}\n// moving costly divides into consts\nconst float ANGLE_STEP \x3d PI2 * float( NUM_RINGS ) / float( NUM_SAMPLES );\nconst float INV_NUM_SAMPLES \x3d 1.0 / float( NUM_SAMPLES );\nfloat getAmbientOcclusion( const in vec3 centerViewPosition ) {\n\t// precompute some variables require in getOcclusion.\n\tscaleDividedByCameraFar \x3d scale / cameraFar;\n\tminResolutionMultipliedByCameraFar \x3d minResolution * cameraFar;\n\tvec3 centerViewNormal \x3d getViewNormal( centerViewPosition, vUv );\n\t// jsfiddle that shows sample pattern: https://jsfiddle.net/a16ff1p7/\n\tfloat angle \x3d rand( vUv + randomSeed ) * PI2;\n\tvec2 radius \x3d vec2( kernelRadius * INV_NUM_SAMPLES ) / size;\n\tvec2 radiusStep \x3d radius;\n\tfloat occlusionSum \x3d 0.0;\n\tfloat weightSum \x3d 0.0;\n\tfor( int i \x3d 0; i \x3c NUM_SAMPLES; i ++ ) {\n\t\tvec2 sampleUv \x3d vUv + vec2( cos( angle ), sin( angle ) ) * radius;\n\t\tradius +\x3d radiusStep;\n\t\tangle +\x3d ANGLE_STEP;\n\t\tfloat sampleDepth \x3d getDepth( sampleUv );\n\t\tif( sampleDepth \x3e\x3d ( 1.0 - EPSILON ) ) {\n\t\t\tcontinue;\n\t\t}\n\t\tfloat sampleViewZ \x3d getViewZ( sampleDepth );\n\t\tvec3 sampleViewPosition \x3d getViewPosition( sampleUv, sampleDepth, sampleViewZ );\n\t\tocclusionSum +\x3d getOcclusion( centerViewPosition, centerViewNormal, sampleViewPosition );\n\t\tweightSum +\x3d 1.0;\n\t}\n\tif( weightSum \x3d\x3d 0.0 ) discard;\n\treturn occlusionSum * ( intensity / weightSum );\n}\nvoid main() {\n\tfloat centerDepth \x3d getDepth( vUv );\n\tif( centerDepth \x3e\x3d ( 1.0 - EPSILON ) ) {\n\t\tdiscard;\n\t}\n\tfloat centerViewZ \x3d getViewZ( centerDepth );\n\tvec3 viewPosition \x3d getViewPosition( vUv, centerDepth, centerViewZ );\n\tfloat ambientOcclusion \x3d getAmbientOcclusion( viewPosition );\n\tgl_FragColor \x3d getDefaultColor( vUv );\n\tgl_FragColor.xyz *\x3d  1.0 - ambientOcclusion;\n}"};