THREE.ParallaxShader={modes:{none:"NO_PARALLAX",basic:"USE_BASIC_PARALLAX",steep:"USE_STEEP_PARALLAX",occlusion:"USE_OCLUSION_PARALLAX",relief:"USE_RELIEF_PARALLAX"},uniforms:{bumpMap:{value:null},map:{value:null},parallaxScale:{value:null},parallaxMinLayers:{value:null},parallaxMaxLayers:{value:null}},vertexShader:"varying vec2 vUv;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;\nvoid main() {\nvUv \x3d uv;\nvec4 mvPosition \x3d modelViewMatrix * vec4( position, 1.0 );\nvViewPosition \x3d -mvPosition.xyz;\nvNormal \x3d normalize( normalMatrix * normal );\ngl_Position \x3d projectionMatrix * mvPosition;\n}",
fragmentShader:"uniform sampler2D bumpMap;\nuniform sampler2D map;\nuniform float parallaxScale;\nuniform float parallaxMinLayers;\nuniform float parallaxMaxLayers;\nvarying vec2 vUv;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;\n#ifdef USE_BASIC_PARALLAX\nvec2 parallaxMap( in vec3 V ) {\nfloat initialHeight \x3d texture2D( bumpMap, vUv ).r;\nvec2 texCoordOffset \x3d parallaxScale * V.xy * initialHeight;\nreturn vUv - texCoordOffset;\n}\n#else\nvec2 parallaxMap( in vec3 V ) {\nfloat numLayers \x3d mix( parallaxMaxLayers, parallaxMinLayers, abs( dot( vec3( 0.0, 0.0, 1.0 ), V ) ) );\nfloat layerHeight \x3d 1.0 / numLayers;\nfloat currentLayerHeight \x3d 0.0;\nvec2 dtex \x3d parallaxScale * V.xy / V.z / numLayers;\nvec2 currentTextureCoords \x3d vUv;\nfloat heightFromTexture \x3d texture2D( bumpMap, currentTextureCoords ).r;\nfor ( int i \x3d 0; i \x3c 30; i +\x3d 1 ) {\nif ( heightFromTexture \x3c\x3d currentLayerHeight ) {\nbreak;\n}\ncurrentLayerHeight +\x3d layerHeight;\ncurrentTextureCoords -\x3d dtex;\nheightFromTexture \x3d texture2D( bumpMap, currentTextureCoords ).r;\n}\n#ifdef USE_STEEP_PARALLAX\nreturn currentTextureCoords;\n#elif defined( USE_RELIEF_PARALLAX )\nvec2 deltaTexCoord \x3d dtex / 2.0;\nfloat deltaHeight \x3d layerHeight / 2.0;\ncurrentTextureCoords +\x3d deltaTexCoord;\ncurrentLayerHeight -\x3d deltaHeight;\nconst int numSearches \x3d 5;\nfor ( int i \x3d 0; i \x3c numSearches; i +\x3d 1 ) {\ndeltaTexCoord /\x3d 2.0;\ndeltaHeight /\x3d 2.0;\nheightFromTexture \x3d texture2D( bumpMap, currentTextureCoords ).r;\nif( heightFromTexture \x3e currentLayerHeight ) {\ncurrentTextureCoords -\x3d deltaTexCoord;\ncurrentLayerHeight +\x3d deltaHeight;\n} else {\ncurrentTextureCoords +\x3d deltaTexCoord;\ncurrentLayerHeight -\x3d deltaHeight;\n}\n}\nreturn currentTextureCoords;\n#elif defined( USE_OCLUSION_PARALLAX )\nvec2 prevTCoords \x3d currentTextureCoords + dtex;\nfloat nextH \x3d heightFromTexture - currentLayerHeight;\nfloat prevH \x3d texture2D( bumpMap, prevTCoords ).r - currentLayerHeight + layerHeight;\nfloat weight \x3d nextH / ( nextH - prevH );\nreturn prevTCoords * weight + currentTextureCoords * ( 1.0 - weight );\n#else\nreturn vUv;\n#endif\n}\n#endif\nvec2 perturbUv( vec3 surfPosition, vec3 surfNormal, vec3 viewPosition ) {\nvec2 texDx \x3d dFdx( vUv );\nvec2 texDy \x3d dFdy( vUv );\nvec3 vSigmaX \x3d dFdx( surfPosition );\nvec3 vSigmaY \x3d dFdy( surfPosition );\nvec3 vR1 \x3d cross( vSigmaY, surfNormal );\nvec3 vR2 \x3d cross( surfNormal, vSigmaX );\nfloat fDet \x3d dot( vSigmaX, vR1 );\nvec2 vProjVscr \x3d ( 1.0 / fDet ) * vec2( dot( vR1, viewPosition ), dot( vR2, viewPosition ) );\nvec3 vProjVtex;\nvProjVtex.xy \x3d texDx * vProjVscr.x + texDy * vProjVscr.y;\nvProjVtex.z \x3d dot( surfNormal, viewPosition );\nreturn parallaxMap( vProjVtex );\n}\nvoid main() {\nvec2 mapUv \x3d perturbUv( -vViewPosition, normalize( vNormal ), normalize( vViewPosition ) );\ngl_FragColor \x3d texture2D( map, mapUv );\n}"};