THREE.ShaderLib.ocean_sim_vertex={vertexShader:"varying vec2 vUV;\nvoid main (void) {\nvUV \x3d position.xy * 0.5 + 0.5;\ngl_Position \x3d vec4(position, 1.0 );\n}"};THREE.ShaderLib.ocean_subtransform={uniforms:{u_input:{value:null},u_transformSize:{value:512},u_subtransformSize:{value:250}},fragmentShader:"precision highp float;\n#include \x3ccommon\x3e\nuniform sampler2D u_input;\nuniform float u_transformSize;\nuniform float u_subtransformSize;\nvarying vec2 vUV;\nvec2 multiplyComplex (vec2 a, vec2 b) {\nreturn vec2(a[0] * b[0] - a[1] * b[1], a[1] * b[0] + a[0] * b[1]);\n}\nvoid main (void) {\n#ifdef HORIZONTAL\nfloat index \x3d vUV.x * u_transformSize - 0.5;\n#else\nfloat index \x3d vUV.y * u_transformSize - 0.5;\n#endif\nfloat evenIndex \x3d floor(index / u_subtransformSize) * (u_subtransformSize * 0.5) + mod(index, u_subtransformSize * 0.5);\n#ifdef HORIZONTAL\nvec4 even \x3d texture2D(u_input, vec2(evenIndex + 0.5, gl_FragCoord.y) / u_transformSize).rgba;\nvec4 odd \x3d texture2D(u_input, vec2(evenIndex + u_transformSize * 0.5 + 0.5, gl_FragCoord.y) / u_transformSize).rgba;\n#else\nvec4 even \x3d texture2D(u_input, vec2(gl_FragCoord.x, evenIndex + 0.5) / u_transformSize).rgba;\nvec4 odd \x3d texture2D(u_input, vec2(gl_FragCoord.x, evenIndex + u_transformSize * 0.5 + 0.5) / u_transformSize).rgba;\n#endif\nfloat twiddleArgument \x3d -2.0 * PI * (index / u_subtransformSize);\nvec2 twiddle \x3d vec2(cos(twiddleArgument), sin(twiddleArgument));\nvec2 outputA \x3d even.xy + multiplyComplex(twiddle, odd.xy);\nvec2 outputB \x3d even.zw + multiplyComplex(twiddle, odd.zw);\ngl_FragColor \x3d vec4(outputA, outputB);\n}"};
THREE.ShaderLib.ocean_initial_spectrum={uniforms:{u_wind:{value:new THREE.Vector2(10,10)},u_resolution:{value:512},u_size:{value:250}},fragmentShader:"precision highp float;\n#include \x3ccommon\x3e\nconst float G \x3d 9.81;\nconst float KM \x3d 370.0;\nconst float CM \x3d 0.23;\nuniform vec2 u_wind;\nuniform float u_resolution;\nuniform float u_size;\nfloat omega (float k) {\nreturn sqrt(G * k * (1.0 + pow2(k / KM)));\n}\nfloat tanh (float x) {\nreturn (1.0 - exp(-2.0 * x)) / (1.0 + exp(-2.0 * x));\n}\nvoid main (void) {\nvec2 coordinates \x3d gl_FragCoord.xy - 0.5;\nfloat n \x3d (coordinates.x \x3c u_resolution * 0.5) ? coordinates.x : coordinates.x - u_resolution;\nfloat m \x3d (coordinates.y \x3c u_resolution * 0.5) ? coordinates.y : coordinates.y - u_resolution;\nvec2 K \x3d (2.0 * PI * vec2(n, m)) / u_size;\nfloat k \x3d length(K);\nfloat l_wind \x3d length(u_wind);\nfloat Omega \x3d 0.84;\nfloat kp \x3d G * pow2(Omega / l_wind);\nfloat c \x3d omega(k) / k;\nfloat cp \x3d omega(kp) / kp;\nfloat Lpm \x3d exp(-1.25 * pow2(kp / k));\nfloat gamma \x3d 1.7;\nfloat sigma \x3d 0.08 * (1.0 + 4.0 * pow(Omega, -3.0));\nfloat Gamma \x3d exp(-pow2(sqrt(k / kp) - 1.0) / 2.0 * pow2(sigma));\nfloat Jp \x3d pow(gamma, Gamma);\nfloat Fp \x3d Lpm * Jp * exp(-Omega / sqrt(10.0) * (sqrt(k / kp) - 1.0));\nfloat alphap \x3d 0.006 * sqrt(Omega);\nfloat Bl \x3d 0.5 * alphap * cp / c * Fp;\nfloat z0 \x3d 0.000037 * pow2(l_wind) / G * pow(l_wind / cp, 0.9);\nfloat uStar \x3d 0.41 * l_wind / log(10.0 / z0);\nfloat alpham \x3d 0.01 * ((uStar \x3c CM) ? (1.0 + log(uStar / CM)) : (1.0 + 3.0 * log(uStar / CM)));\nfloat Fm \x3d exp(-0.25 * pow2(k / KM - 1.0));\nfloat Bh \x3d 0.5 * alpham * CM / c * Fm * Lpm;\nfloat a0 \x3d log(2.0) / 4.0;\nfloat am \x3d 0.13 * uStar / CM;\nfloat Delta \x3d tanh(a0 + 4.0 * pow(c / cp, 2.5) + am * pow(CM / c, 2.5));\nfloat cosPhi \x3d dot(normalize(u_wind), normalize(K));\nfloat S \x3d (1.0 / (2.0 * PI)) * pow(k, -4.0) * (Bl + Bh) * (1.0 + Delta * (2.0 * cosPhi * cosPhi - 1.0));\nfloat dk \x3d 2.0 * PI / u_size;\nfloat h \x3d sqrt(S / 2.0) * dk;\nif (K.x \x3d\x3d 0.0 \x26\x26 K.y \x3d\x3d 0.0) {\nh \x3d 0.0;\n}\ngl_FragColor \x3d vec4(h, 0.0, 0.0, 0.0);\n}"};
THREE.ShaderLib.ocean_phase={uniforms:{u_phases:{value:null},u_deltaTime:{value:null},u_resolution:{value:null},u_size:{value:null}},fragmentShader:"precision highp float;\n#include \x3ccommon\x3e\nconst float G \x3d 9.81;\nconst float KM \x3d 370.0;\nvarying vec2 vUV;\nuniform sampler2D u_phases;\nuniform float u_deltaTime;\nuniform float u_resolution;\nuniform float u_size;\nfloat omega (float k) {\nreturn sqrt(G * k * (1.0 + k * k / KM * KM));\n}\nvoid main (void) {\nfloat deltaTime \x3d 1.0 / 60.0;\nvec2 coordinates \x3d gl_FragCoord.xy - 0.5;\nfloat n \x3d (coordinates.x \x3c u_resolution * 0.5) ? coordinates.x : coordinates.x - u_resolution;\nfloat m \x3d (coordinates.y \x3c u_resolution * 0.5) ? coordinates.y : coordinates.y - u_resolution;\nvec2 waveVector \x3d (2.0 * PI * vec2(n, m)) / u_size;\nfloat phase \x3d texture2D(u_phases, vUV).r;\nfloat deltaPhase \x3d omega(length(waveVector)) * u_deltaTime;\nphase \x3d mod(phase + deltaPhase, 2.0 * PI);\ngl_FragColor \x3d vec4(phase, 0.0, 0.0, 0.0);\n}"};
THREE.ShaderLib.ocean_spectrum={uniforms:{u_size:{value:null},u_resolution:{value:null},u_choppiness:{value:null},u_phases:{value:null},u_initialSpectrum:{value:null}},fragmentShader:"precision highp float;\n#include \x3ccommon\x3e\nconst float G \x3d 9.81;\nconst float KM \x3d 370.0;\nvarying vec2 vUV;\nuniform float u_size;\nuniform float u_resolution;\nuniform float u_choppiness;\nuniform sampler2D u_phases;\nuniform sampler2D u_initialSpectrum;\nvec2 multiplyComplex (vec2 a, vec2 b) {\nreturn vec2(a[0] * b[0] - a[1] * b[1], a[1] * b[0] + a[0] * b[1]);\n}\nvec2 multiplyByI (vec2 z) {\nreturn vec2(-z[1], z[0]);\n}\nfloat omega (float k) {\nreturn sqrt(G * k * (1.0 + k * k / KM * KM));\n}\nvoid main (void) {\nvec2 coordinates \x3d gl_FragCoord.xy - 0.5;\nfloat n \x3d (coordinates.x \x3c u_resolution * 0.5) ? coordinates.x : coordinates.x - u_resolution;\nfloat m \x3d (coordinates.y \x3c u_resolution * 0.5) ? coordinates.y : coordinates.y - u_resolution;\nvec2 waveVector \x3d (2.0 * PI * vec2(n, m)) / u_size;\nfloat phase \x3d texture2D(u_phases, vUV).r;\nvec2 phaseVector \x3d vec2(cos(phase), sin(phase));\nvec2 h0 \x3d texture2D(u_initialSpectrum, vUV).rg;\nvec2 h0Star \x3d texture2D(u_initialSpectrum, vec2(1.0 - vUV + 1.0 / u_resolution)).rg;\nh0Star.y *\x3d -1.0;\nvec2 h \x3d multiplyComplex(h0, phaseVector) + multiplyComplex(h0Star, vec2(phaseVector.x, -phaseVector.y));\nvec2 hX \x3d -multiplyByI(h * (waveVector.x / length(waveVector))) * u_choppiness;\nvec2 hZ \x3d -multiplyByI(h * (waveVector.y / length(waveVector))) * u_choppiness;\nif (waveVector.x \x3d\x3d 0.0 \x26\x26 waveVector.y \x3d\x3d 0.0) {\nh \x3d vec2(0.0);\nhX \x3d vec2(0.0);\nhZ \x3d vec2(0.0);\n}\ngl_FragColor \x3d vec4(hX + multiplyByI(h), hZ);\n}"};
THREE.ShaderLib.ocean_normals={uniforms:{u_displacementMap:{value:null},u_resolution:{value:null},u_size:{value:null}},fragmentShader:"precision highp float;\nvarying vec2 vUV;\nuniform sampler2D u_displacementMap;\nuniform float u_resolution;\nuniform float u_size;\nvoid main (void) {\nfloat texel \x3d 1.0 / u_resolution;\nfloat texelSize \x3d u_size / u_resolution;\nvec3 center \x3d texture2D(u_displacementMap, vUV).rgb;\nvec3 right \x3d vec3(texelSize, 0.0, 0.0) + texture2D(u_displacementMap, vUV + vec2(texel, 0.0)).rgb - center;\nvec3 left \x3d vec3(-texelSize, 0.0, 0.0) + texture2D(u_displacementMap, vUV + vec2(-texel, 0.0)).rgb - center;\nvec3 top \x3d vec3(0.0, 0.0, -texelSize) + texture2D(u_displacementMap, vUV + vec2(0.0, -texel)).rgb - center;\nvec3 bottom \x3d vec3(0.0, 0.0, texelSize) + texture2D(u_displacementMap, vUV + vec2(0.0, texel)).rgb - center;\nvec3 topRight \x3d cross(right, top);\nvec3 topLeft \x3d cross(top, left);\nvec3 bottomLeft \x3d cross(left, bottom);\nvec3 bottomRight \x3d cross(bottom, right);\ngl_FragColor \x3d vec4(normalize(topRight + topLeft + bottomLeft + bottomRight), 1.0);\n}"};
THREE.ShaderLib.ocean_main={uniforms:{u_displacementMap:{value:null},u_normalMap:{value:null},u_geometrySize:{value:null},u_size:{value:null},u_projectionMatrix:{value:null},u_viewMatrix:{value:null},u_cameraPosition:{value:null},u_skyColor:{value:null},u_oceanColor:{value:null},u_sunDirection:{value:null},u_exposure:{value:null}},vertexShader:"precision highp float;\nvarying vec3 vPos;\nvarying vec2 vUV;\nuniform mat4 u_projectionMatrix;\nuniform mat4 u_viewMatrix;\nuniform float u_size;\nuniform float u_geometrySize;\nuniform sampler2D u_displacementMap;\nvoid main (void) {\nvec3 newPos \x3d position + texture2D(u_displacementMap, uv).rgb * (u_geometrySize / u_size);\nvPos \x3d newPos;\nvUV \x3d uv;\ngl_Position \x3d u_projectionMatrix * u_viewMatrix * vec4(newPos, 1.0);\n}",
fragmentShader:"precision highp float;\nvarying vec3 vPos;\nvarying vec2 vUV;\nuniform sampler2D u_displacementMap;\nuniform sampler2D u_normalMap;\nuniform vec3 u_cameraPosition;\nuniform vec3 u_oceanColor;\nuniform vec3 u_skyColor;\nuniform vec3 u_sunDirection;\nuniform float u_exposure;\nvec3 hdr (vec3 color, float exposure) {\nreturn 1.0 - exp(-color * exposure);\n}\nvoid main (void) {\nvec3 normal \x3d texture2D(u_normalMap, vUV).rgb;\nvec3 view \x3d normalize(u_cameraPosition - vPos);\nfloat fresnel \x3d 0.02 + 0.98 * pow(1.0 - dot(normal, view), 5.0);\nvec3 sky \x3d fresnel * u_skyColor;\nfloat diffuse \x3d clamp(dot(normal, normalize(u_sunDirection)), 0.0, 1.0);\nvec3 water \x3d (1.0 - fresnel) * u_oceanColor * u_skyColor * diffuse;\nvec3 color \x3d sky + water;\ngl_FragColor \x3d vec4(hdr(color, u_exposure), 1.0);\n}"};