THREE.FresnelShader={uniforms:{mRefractionRatio:{value:1.02},mFresnelBias:{value:.1},mFresnelPower:{value:2},mFresnelScale:{value:1},tCube:{value:null}},vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition \x3d modelViewMatrix * vec4( position, 1.0 );\nvec4 worldPosition \x3d modelMatrix * vec4( position, 1.0 );\nvec3 worldNormal \x3d normalize( mat3( modelMatrix[0].xyz, modelMatrix[1].xyz, modelMatrix[2].xyz ) * normal );\nvec3 I \x3d worldPosition.xyz - cameraPosition;\nvReflect \x3d reflect( I, worldNormal );\nvRefract[0] \x3d refract( normalize( I ), worldNormal, mRefractionRatio );\nvRefract[1] \x3d refract( normalize( I ), worldNormal, mRefractionRatio * 0.99 );\nvRefract[2] \x3d refract( normalize( I ), worldNormal, mRefractionRatio * 0.98 );\nvReflectionFactor \x3d mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), worldNormal ), mFresnelPower );\ngl_Position \x3d projectionMatrix * mvPosition;\n}",
fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor \x3d textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor \x3d vec4( 1.0 );\nrefractedColor.r \x3d textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g \x3d textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b \x3d textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\ngl_FragColor \x3d mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}"};