THREE.FXAAShader={uniforms:{tDiffuse:{value:null},resolution:{value:new THREE.Vector2(1/1024,1/512)}},vertexShader:"void main() {\ngl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform sampler2D tDiffuse;\nuniform vec2 resolution;\n#define FXAA_REDUCE_MIN   (1.0/128.0)\n#define FXAA_REDUCE_MUL   (1.0/8.0)\n#define FXAA_SPAN_MAX     8.0\nvoid main() {\nvec3 rgbNW \x3d texture2D( tDiffuse, ( gl_FragCoord.xy + vec2( -1.0, -1.0 ) ) * resolution ).xyz;\nvec3 rgbNE \x3d texture2D( tDiffuse, ( gl_FragCoord.xy + vec2( 1.0, -1.0 ) ) * resolution ).xyz;\nvec3 rgbSW \x3d texture2D( tDiffuse, ( gl_FragCoord.xy + vec2( -1.0, 1.0 ) ) * resolution ).xyz;\nvec3 rgbSE \x3d texture2D( tDiffuse, ( gl_FragCoord.xy + vec2( 1.0, 1.0 ) ) * resolution ).xyz;\nvec4 rgbaM  \x3d texture2D( tDiffuse,  gl_FragCoord.xy  * resolution );\nvec3 rgbM  \x3d rgbaM.xyz;\nvec3 luma \x3d vec3( 0.299, 0.587, 0.114 );\nfloat lumaNW \x3d dot( rgbNW, luma );\nfloat lumaNE \x3d dot( rgbNE, luma );\nfloat lumaSW \x3d dot( rgbSW, luma );\nfloat lumaSE \x3d dot( rgbSE, luma );\nfloat lumaM  \x3d dot( rgbM,  luma );\nfloat lumaMin \x3d min( lumaM, min( min( lumaNW, lumaNE ), min( lumaSW, lumaSE ) ) );\nfloat lumaMax \x3d max( lumaM, max( max( lumaNW, lumaNE) , max( lumaSW, lumaSE ) ) );\nvec2 dir;\ndir.x \x3d -((lumaNW + lumaNE) - (lumaSW + lumaSE));\ndir.y \x3d  ((lumaNW + lumaSW) - (lumaNE + lumaSE));\nfloat dirReduce \x3d max( ( lumaNW + lumaNE + lumaSW + lumaSE ) * ( 0.25 * FXAA_REDUCE_MUL ), FXAA_REDUCE_MIN );\nfloat rcpDirMin \x3d 1.0 / ( min( abs( dir.x ), abs( dir.y ) ) + dirReduce );\ndir \x3d min( vec2( FXAA_SPAN_MAX,  FXAA_SPAN_MAX),\nmax( vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX),\ndir * rcpDirMin)) * resolution;\nvec4 rgbA \x3d (1.0/2.0) * (\ntexture2D(tDiffuse,  gl_FragCoord.xy  * resolution + dir * (1.0/3.0 - 0.5)) +\ntexture2D(tDiffuse,  gl_FragCoord.xy  * resolution + dir * (2.0/3.0 - 0.5)));\nvec4 rgbB \x3d rgbA * (1.0/2.0) + (1.0/4.0) * (\ntexture2D(tDiffuse,  gl_FragCoord.xy  * resolution + dir * (0.0/3.0 - 0.5)) +\ntexture2D(tDiffuse,  gl_FragCoord.xy  * resolution + dir * (3.0/3.0 - 0.5)));\nfloat lumaB \x3d dot(rgbB, vec4(luma, 0.0));\nif ( ( lumaB \x3c lumaMin ) || ( lumaB \x3e lumaMax ) ) {\ngl_FragColor \x3d rgbA;\n} else {\ngl_FragColor \x3d rgbB;\n}\n}"};