THREE.DepthLimitedBlurShader={defines:{KERNEL_RADIUS:4,DEPTH_PACKING:1,PERSPECTIVE_CAMERA:1},uniforms:{tDiffuse:{type:"t",value:null},size:{type:"v2",value:new THREE.Vector2(512,512)},sampleUvOffsets:{type:"v2v",value:[new THREE.Vector2(0,0)]},sampleWeights:{type:"1fv",value:[1]},tDepth:{type:"t",value:null},cameraNear:{type:"f",value:10},cameraFar:{type:"f",value:1E3},depthCutoff:{type:"f",value:10}},vertexShader:"#include \x3ccommon\x3e\nuniform vec2 size;\nvarying vec2 vUv;\nvarying vec2 vInvSize;\nvoid main() {\n\tvUv \x3d uv;\n\tvInvSize \x3d 1.0 / size;\n\tgl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"#include \x3ccommon\x3e\n#include \x3cpacking\x3e\nuniform sampler2D tDiffuse;\nuniform sampler2D tDepth;\nuniform float cameraNear;\nuniform float cameraFar;\nuniform float depthCutoff;\nuniform vec2 sampleUvOffsets[ KERNEL_RADIUS + 1 ];\nuniform float sampleWeights[ KERNEL_RADIUS + 1 ];\nvarying vec2 vUv;\nvarying vec2 vInvSize;\nfloat getDepth( const in vec2 screenPosition ) {\n\t#if DEPTH_PACKING \x3d\x3d 1\n\treturn unpackRGBAToDepth( texture2D( tDepth, screenPosition ) );\n\t#else\n\treturn texture2D( tDepth, screenPosition ).x;\n\t#endif\n}\nfloat getViewZ( const in float depth ) {\n\t#if PERSPECTIVE_CAMERA \x3d\x3d 1\n\treturn perspectiveDepthToViewZ( depth, cameraNear, cameraFar );\n\t#else\n\treturn orthoDepthToViewZ( depth, cameraNear, cameraFar );\n\t#endif\n}\nvoid main() {\n\tfloat depth \x3d getDepth( vUv );\n\tif( depth \x3e\x3d ( 1.0 - EPSILON ) ) {\n\t\tdiscard;\n\t}\n\tfloat centerViewZ \x3d -getViewZ( depth );\n\tbool rBreak \x3d false, lBreak \x3d false;\n\tfloat weightSum \x3d sampleWeights[0];\n\tvec4 diffuseSum \x3d texture2D( tDiffuse, vUv ) * weightSum;\n\tfor( int i \x3d 1; i \x3c\x3d KERNEL_RADIUS; i ++ ) {\n\t\tfloat sampleWeight \x3d sampleWeights[i];\n\t\tvec2 sampleUvOffset \x3d sampleUvOffsets[i] * vInvSize;\n\t\tvec2 sampleUv \x3d vUv + sampleUvOffset;\n\t\tfloat viewZ \x3d -getViewZ( getDepth( sampleUv ) );\n\t\tif( abs( viewZ - centerViewZ ) \x3e depthCutoff ) rBreak \x3d true;\n\t\tif( ! rBreak ) {\n\t\t\tdiffuseSum +\x3d texture2D( tDiffuse, sampleUv ) * sampleWeight;\n\t\t\tweightSum +\x3d sampleWeight;\n\t\t}\n\t\tsampleUv \x3d vUv - sampleUvOffset;\n\t\tviewZ \x3d -getViewZ( getDepth( sampleUv ) );\n\t\tif( abs( viewZ - centerViewZ ) \x3e depthCutoff ) lBreak \x3d true;\n\t\tif( ! lBreak ) {\n\t\t\tdiffuseSum +\x3d texture2D( tDiffuse, sampleUv ) * sampleWeight;\n\t\t\tweightSum +\x3d sampleWeight;\n\t\t}\n\t}\n\tgl_FragColor \x3d diffuseSum / weightSum;\n}"};
THREE.BlurShaderUtils={createSampleWeights:function(c,b){for(var d=[],a=0;a<=c;a++)d.push(Math.exp(-(a*a)/(2*b*b))/(Math.sqrt(2*Math.PI)*b));return d},createSampleOffsets:function(c,b){for(var d=[],a=0;a<=c;a++)d.push(b.clone().multiplyScalar(a));return d},configure:function(c,b,d,a){c.defines.KERNEL_RADIUS=b;c.uniforms.sampleUvOffsets.value=THREE.BlurShaderUtils.createSampleOffsets(b,a);c.uniforms.sampleWeights.value=THREE.BlurShaderUtils.createSampleWeights(b,d);c.needsUpdate=!0}};