THREE.BokehShader={uniforms:{textureWidth:{value:1},textureHeight:{value:1},focalDepth:{value:1},focalLength:{value:24},fstop:{value:.9},tColor:{value:null},tDepth:{value:null},maxblur:{value:1},showFocus:{value:0},manualdof:{value:0},vignetting:{value:0},depthblur:{value:0},threshold:{value:.5},gain:{value:2},bias:{value:.5},fringe:{value:.7},znear:{value:.1},zfar:{value:100},noise:{value:1},dithering:{value:1E-4},pentagon:{value:0},shaderFocus:{value:1},focusCoords:{value:new THREE.Vector2}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv \x3d uv;\ngl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"#include \x3ccommon\x3e\nvarying vec2 vUv;\nuniform sampler2D tColor;\nuniform sampler2D tDepth;\nuniform float textureWidth;\nuniform float textureHeight;\nuniform float focalDepth;  //focal distance value in meters, but you may use autofocus option below\nuniform float focalLength; //focal length in mm\nuniform float fstop; //f-stop value\nuniform bool showFocus; //show debug focus point and focal range (red \x3d focal point, green \x3d focal range)\n/*\nmake sure that these two values are the same for your camera, otherwise distances will be wrong.\n*/\nuniform float znear; // camera clipping start\nuniform float zfar; // camera clipping end\n//------------------------------------------\n//user variables\nconst int samples \x3d SAMPLES; //samples on the first ring\nconst int rings \x3d RINGS; //ring count\nconst int maxringsamples \x3d rings * samples;\nuniform bool manualdof; // manual dof calculation\nfloat ndofstart \x3d 1.0; // near dof blur start\nfloat ndofdist \x3d 2.0; // near dof blur falloff distance\nfloat fdofstart \x3d 1.0; // far dof blur start\nfloat fdofdist \x3d 3.0; // far dof blur falloff distance\nfloat CoC \x3d 0.03; //circle of confusion size in mm (35mm film \x3d 0.03mm)\nuniform bool vignetting; // use optical lens vignetting\nfloat vignout \x3d 1.3; // vignetting outer border\nfloat vignin \x3d 0.0; // vignetting inner border\nfloat vignfade \x3d 22.0; // f-stops till vignete fades\nuniform bool shaderFocus;\n// disable if you use external focalDepth value\nuniform vec2 focusCoords;\n// autofocus point on screen (0.0,0.0 - left lower corner, 1.0,1.0 - upper right)\n// if center of screen use vec2(0.5, 0.5);\nuniform float maxblur;\n//clamp value of max blur (0.0 \x3d no blur, 1.0 default)\nuniform float threshold; // highlight threshold;\nuniform float gain; // highlight gain;\nuniform float bias; // bokeh edge bias\nuniform float fringe; // bokeh chromatic aberration / fringing\nuniform bool noise; //use noise instead of pattern for sample dithering\nuniform float dithering;\nuniform bool depthblur; // blur the depth buffer\nfloat dbsize \x3d 1.25; // depth blur size\n/*\nnext part is experimental\nnot looking good with small sample and ring count\nlooks okay starting from samples \x3d 4, rings \x3d 4\n*/\nuniform bool pentagon; //use pentagon as bokeh shape?\nfloat feather \x3d 0.4; //pentagon shape feather\n//------------------------------------------\nfloat penta(vec2 coords) {\n//pentagonal shape\nfloat scale \x3d float(rings) - 1.3;\nvec4  HS0 \x3d vec4( 1.0,         0.0,         0.0,  1.0);\nvec4  HS1 \x3d vec4( 0.309016994, 0.951056516, 0.0,  1.0);\nvec4  HS2 \x3d vec4(-0.809016994, 0.587785252, 0.0,  1.0);\nvec4  HS3 \x3d vec4(-0.809016994,-0.587785252, 0.0,  1.0);\nvec4  HS4 \x3d vec4( 0.309016994,-0.951056516, 0.0,  1.0);\nvec4  HS5 \x3d vec4( 0.0        ,0.0         , 1.0,  1.0);\nvec4  one \x3d vec4( 1.0 );\nvec4 P \x3d vec4((coords),vec2(scale, scale));\nvec4 dist \x3d vec4(0.0);\nfloat inorout \x3d -4.0;\ndist.x \x3d dot( P, HS0 );\ndist.y \x3d dot( P, HS1 );\ndist.z \x3d dot( P, HS2 );\ndist.w \x3d dot( P, HS3 );\ndist \x3d smoothstep( -feather, feather, dist );\ninorout +\x3d dot( dist, one );\ndist.x \x3d dot( P, HS4 );\ndist.y \x3d HS5.w - abs( P.z );\ndist \x3d smoothstep( -feather, feather, dist );\ninorout +\x3d dist.x;\nreturn clamp( inorout, 0.0, 1.0 );\n}\nfloat bdepth(vec2 coords) {\n// Depth buffer blur\nfloat d \x3d 0.0;\nfloat kernel[9];\nvec2 offset[9];\nvec2 wh \x3d vec2(1.0/textureWidth,1.0/textureHeight) * dbsize;\noffset[0] \x3d vec2(-wh.x,-wh.y);\noffset[1] \x3d vec2( 0.0, -wh.y);\noffset[2] \x3d vec2( wh.x -wh.y);\noffset[3] \x3d vec2(-wh.x,  0.0);\noffset[4] \x3d vec2( 0.0,   0.0);\noffset[5] \x3d vec2( wh.x,  0.0);\noffset[6] \x3d vec2(-wh.x, wh.y);\noffset[7] \x3d vec2( 0.0,  wh.y);\noffset[8] \x3d vec2( wh.x, wh.y);\nkernel[0] \x3d 1.0/16.0;   kernel[1] \x3d 2.0/16.0;   kernel[2] \x3d 1.0/16.0;\nkernel[3] \x3d 2.0/16.0;   kernel[4] \x3d 4.0/16.0;   kernel[5] \x3d 2.0/16.0;\nkernel[6] \x3d 1.0/16.0;   kernel[7] \x3d 2.0/16.0;   kernel[8] \x3d 1.0/16.0;\nfor( int i\x3d0; i\x3c9; i++ ) {\nfloat tmp \x3d texture2D(tDepth, coords + offset[i]).r;\nd +\x3d tmp * kernel[i];\n}\nreturn d;\n}\nvec3 color(vec2 coords,float blur) {\n//processing the sample\nvec3 col \x3d vec3(0.0);\nvec2 texel \x3d vec2(1.0/textureWidth,1.0/textureHeight);\ncol.r \x3d texture2D(tColor,coords + vec2(0.0,1.0)*texel*fringe*blur).r;\ncol.g \x3d texture2D(tColor,coords + vec2(-0.866,-0.5)*texel*fringe*blur).g;\ncol.b \x3d texture2D(tColor,coords + vec2(0.866,-0.5)*texel*fringe*blur).b;\nvec3 lumcoeff \x3d vec3(0.299,0.587,0.114);\nfloat lum \x3d dot(col.rgb, lumcoeff);\nfloat thresh \x3d max((lum-threshold)*gain, 0.0);\nreturn col+mix(vec3(0.0),col,thresh*blur);\n}\nvec3 debugFocus(vec3 col, float blur, float depth) {\nfloat edge \x3d 0.002*depth; //distance based edge smoothing\nfloat m \x3d clamp(smoothstep(0.0,edge,blur),0.0,1.0);\nfloat e \x3d clamp(smoothstep(1.0-edge,1.0,blur),0.0,1.0);\ncol \x3d mix(col,vec3(1.0,0.5,0.0),(1.0-m)*0.6);\ncol \x3d mix(col,vec3(0.0,0.5,1.0),((1.0-e)-(1.0-m))*0.2);\nreturn col;\n}\nfloat linearize(float depth) {\nreturn -zfar * znear / (depth * (zfar - znear) - zfar);\n}\nfloat vignette() {\nfloat dist \x3d distance(vUv.xy, vec2(0.5,0.5));\ndist \x3d smoothstep(vignout+(fstop/vignfade), vignin+(fstop/vignfade), dist);\nreturn clamp(dist,0.0,1.0);\n}\nfloat gather(float i, float j, int ringsamples, inout vec3 col, float w, float h, float blur) {\nfloat rings2 \x3d float(rings);\nfloat step \x3d PI*2.0 / float(ringsamples);\nfloat pw \x3d cos(j*step)*i;\nfloat ph \x3d sin(j*step)*i;\nfloat p \x3d 1.0;\nif (pentagon) {\np \x3d penta(vec2(pw,ph));\n}\ncol +\x3d color(vUv.xy + vec2(pw*w,ph*h), blur) * mix(1.0, i/rings2, bias) * p;\nreturn 1.0 * mix(1.0, i /rings2, bias) * p;\n}\nvoid main() {\n//scene depth calculation\nfloat depth \x3d linearize(texture2D(tDepth,vUv.xy).x);\n// Blur depth?\nif (depthblur) {\ndepth \x3d linearize(bdepth(vUv.xy));\n}\n//focal plane calculation\nfloat fDepth \x3d focalDepth;\nif (shaderFocus) {\nfDepth \x3d linearize(texture2D(tDepth,focusCoords).x);\n}\n// dof blur factor calculation\nfloat blur \x3d 0.0;\nif (manualdof) {\nfloat a \x3d depth-fDepth; // Focal plane\nfloat b \x3d (a-fdofstart)/fdofdist; // Far DoF\nfloat c \x3d (-a-ndofstart)/ndofdist; // Near Dof\nblur \x3d (a\x3e0.0) ? b : c;\n} else {\nfloat f \x3d focalLength; // focal length in mm\nfloat d \x3d fDepth*1000.0; // focal plane in mm\nfloat o \x3d depth*1000.0; // depth in mm\nfloat a \x3d (o*f)/(o-f);\nfloat b \x3d (d*f)/(d-f);\nfloat c \x3d (d-f)/(d*fstop*CoC);\nblur \x3d abs(a-b)*c;\n}\nblur \x3d clamp(blur,0.0,1.0);\n// calculation of pattern for dithering\nvec2 noise \x3d vec2(rand(vUv.xy), rand( vUv.xy + vec2( 0.4, 0.6 ) ) )*dithering*blur;\n// getting blur x and y step factor\nfloat w \x3d (1.0/textureWidth)*blur*maxblur+noise.x;\nfloat h \x3d (1.0/textureHeight)*blur*maxblur+noise.y;\n// calculation of final color\nvec3 col \x3d vec3(0.0);\nif(blur \x3c 0.05) {\n//some optimization thingy\ncol \x3d texture2D(tColor, vUv.xy).rgb;\n} else {\ncol \x3d texture2D(tColor, vUv.xy).rgb;\nfloat s \x3d 1.0;\nint ringsamples;\nfor (int i \x3d 1; i \x3c\x3d rings; i++) {\n/*unboxstart*/\nringsamples \x3d i * samples;\nfor (int j \x3d 0 ; j \x3c maxringsamples ; j++) {\nif (j \x3e\x3d ringsamples) break;\ns +\x3d gather(float(i), float(j), ringsamples, col, w, h, blur);\n}\n/*unboxend*/\n}\ncol /\x3d s; //divide by sample count\n}\nif (showFocus) {\ncol \x3d debugFocus(col, blur, depth);\n}\nif (vignetting) {\ncol *\x3d vignette();\n}\ngl_FragColor.rgb \x3d col;\ngl_FragColor.a \x3d 1.0;\n} "};