THREE.UnrealBloomPass=function(a,e,b,d){THREE.Pass.call(this);this.strength=void 0!==e?e:1;this.radius=b;this.threshold=d;this.resolution=void 0!==a?new THREE.Vector2(a.x,a.y):new THREE.Vector2(256,256);var f={minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,format:THREE.RGBAFormat};this.renderTargetsHorizontal=[];this.renderTargetsVertical=[];this.nMips=5;a=Math.round(this.resolution.x/2);b=Math.round(this.resolution.y/2);this.renderTargetBright=new THREE.WebGLRenderTarget(a,b,f);this.renderTargetBright.texture.name=
"UnrealBloomPass.bright";this.renderTargetBright.texture.generateMipmaps=!1;for(var c=0;c<this.nMips;c++){var g=new THREE.WebGLRenderTarget(a,b,f);g.texture.name="UnrealBloomPass.h"+c;g.texture.generateMipmaps=!1;this.renderTargetsHorizontal.push(g);g=new THREE.WebGLRenderTarget(a,b,f);g.texture.name="UnrealBloomPass.v"+c;g.texture.generateMipmaps=!1;this.renderTargetsVertical.push(g);a=Math.round(a/2);b=Math.round(b/2)}void 0===THREE.LuminosityHighPassShader&&console.error("THREE.UnrealBloomPass relies on THREE.LuminosityHighPassShader");
a=THREE.LuminosityHighPassShader;this.highPassUniforms=THREE.UniformsUtils.clone(a.uniforms);this.highPassUniforms.luminosityThreshold.value=d;this.highPassUniforms.smoothWidth.value=.01;this.materialHighPassFilter=new THREE.ShaderMaterial({uniforms:this.highPassUniforms,vertexShader:a.vertexShader,fragmentShader:a.fragmentShader,defines:{}});this.separableBlurMaterials=[];d=[3,5,7,9,11];a=Math.round(this.resolution.x/2);b=Math.round(this.resolution.y/2);for(c=0;c<this.nMips;c++)this.separableBlurMaterials.push(this.getSeperableBlurMaterial(d[c])),
this.separableBlurMaterials[c].uniforms.texSize.value=new THREE.Vector2(a,b),a=Math.round(a/2),b=Math.round(b/2);this.compositeMaterial=this.getCompositeMaterial(this.nMips);this.compositeMaterial.uniforms.blurTexture1.value=this.renderTargetsVertical[0].texture;this.compositeMaterial.uniforms.blurTexture2.value=this.renderTargetsVertical[1].texture;this.compositeMaterial.uniforms.blurTexture3.value=this.renderTargetsVertical[2].texture;this.compositeMaterial.uniforms.blurTexture4.value=this.renderTargetsVertical[3].texture;
this.compositeMaterial.uniforms.blurTexture5.value=this.renderTargetsVertical[4].texture;this.compositeMaterial.uniforms.bloomStrength.value=e;this.compositeMaterial.uniforms.bloomRadius.value=.1;this.compositeMaterial.needsUpdate=!0;this.compositeMaterial.uniforms.bloomFactors.value=[1,.8,.6,.4,.2];this.bloomTintColors=[new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1)];this.compositeMaterial.uniforms.bloomTintColors.value=
this.bloomTintColors;void 0===THREE.CopyShader&&console.error("THREE.BloomPass relies on THREE.CopyShader");e=THREE.CopyShader;this.copyUniforms=THREE.UniformsUtils.clone(e.uniforms);this.copyUniforms.opacity.value=1;this.materialCopy=new THREE.ShaderMaterial({uniforms:this.copyUniforms,vertexShader:e.vertexShader,fragmentShader:e.fragmentShader,blending:THREE.AdditiveBlending,depthTest:!1,depthWrite:!1,transparent:!0});this.enabled=!0;this.needsSwap=!1;this.oldClearColor=new THREE.Color;this.oldClearAlpha=
1;this.camera=new THREE.OrthographicCamera(-1,1,1,-1,0,1);this.scene=new THREE.Scene;this.quad=new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);this.quad.frustumCulled=!1;this.scene.add(this.quad)};
THREE.UnrealBloomPass.prototype=Object.assign(Object.create(THREE.Pass.prototype),{constructor:THREE.UnrealBloomPass,dispose:function(){for(var a=0;a<this.renderTargetsHorizontal.length;a++)this.renderTargetsHorizontal[a].dispose();for(a=0;a<this.renderTargetsVertical.length;a++)this.renderTargetsVertical[a].dispose();this.renderTargetBright.dispose()},setSize:function(a,e){var b=Math.round(a/2),d=Math.round(e/2);this.renderTargetBright.setSize(b,d);for(var f=0;f<this.nMips;f++)this.renderTargetsHorizontal[f].setSize(b,
d),this.renderTargetsVertical[f].setSize(b,d),this.separableBlurMaterials[f].uniforms.texSize.value=new THREE.Vector2(b,d),b=Math.round(b/2),d=Math.round(d/2)},render:function(a,e,b,d,f){this.oldClearColor.copy(a.getClearColor());this.oldClearAlpha=a.getClearAlpha();e=a.autoClear;a.autoClear=!1;a.setClearColor(new THREE.Color(0,0,0),0);f&&a.context.disable(a.context.STENCIL_TEST);this.highPassUniforms.tDiffuse.value=b.texture;this.highPassUniforms.luminosityThreshold.value=this.threshold;this.quad.material=
this.materialHighPassFilter;a.render(this.scene,this.camera,this.renderTargetBright,!0);d=this.renderTargetBright;for(var c=0;c<this.nMips;c++)this.quad.material=this.separableBlurMaterials[c],this.separableBlurMaterials[c].uniforms.colorTexture.value=d.texture,this.separableBlurMaterials[c].uniforms.direction.value=THREE.UnrealBloomPass.BlurDirectionX,a.render(this.scene,this.camera,this.renderTargetsHorizontal[c],!0),this.separableBlurMaterials[c].uniforms.colorTexture.value=this.renderTargetsHorizontal[c].texture,
this.separableBlurMaterials[c].uniforms.direction.value=THREE.UnrealBloomPass.BlurDirectionY,a.render(this.scene,this.camera,this.renderTargetsVertical[c],!0),d=this.renderTargetsVertical[c];this.quad.material=this.compositeMaterial;this.compositeMaterial.uniforms.bloomStrength.value=this.strength;this.compositeMaterial.uniforms.bloomRadius.value=this.radius;this.compositeMaterial.uniforms.bloomTintColors.value=this.bloomTintColors;a.render(this.scene,this.camera,this.renderTargetsHorizontal[0],!0);
this.quad.material=this.materialCopy;this.copyUniforms.tDiffuse.value=this.renderTargetsHorizontal[0].texture;f&&a.context.enable(a.context.STENCIL_TEST);a.render(this.scene,this.camera,b,!1);a.setClearColor(this.oldClearColor,this.oldClearAlpha);a.autoClear=e},getSeperableBlurMaterial:function(a){return new THREE.ShaderMaterial({defines:{KERNEL_RADIUS:a,SIGMA:a},uniforms:{colorTexture:{value:null},texSize:{value:new THREE.Vector2(.5,.5)},direction:{value:new THREE.Vector2(.5,.5)}},vertexShader:"varying vec2 vUv;\n\t\t\t\tvoid main() {\n\t\t\t\t\tvUv \x3d uv;\n\t\t\t\t\tgl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n\t\t\t\t}",
fragmentShader:"#include \x3ccommon\x3e\t\t\t\tvarying vec2 vUv;\n\t\t\t\tuniform sampler2D colorTexture;\n\t\t\t\tuniform vec2 texSize;\t\t\t\tuniform vec2 direction;\t\t\t\t\t\t\t\tfloat gaussianPdf(in float x, in float sigma) {\t\t\t\t\treturn 0.39894 * exp( -0.5 * x * x/( sigma * sigma))/sigma;\t\t\t\t}\t\t\t\tvoid main() {\n\t\t\t\t\tvec2 invSize \x3d 1.0 / texSize;\t\t\t\t\tfloat fSigma \x3d float(SIGMA);\t\t\t\t\tfloat weightSum \x3d gaussianPdf(0.0, fSigma);\t\t\t\t\tvec3 diffuseSum \x3d texture2D( colorTexture, vUv).rgb * weightSum;\t\t\t\t\tfor( int i \x3d 1; i \x3c KERNEL_RADIUS; i ++ ) {\t\t\t\t\t\tfloat x \x3d float(i);\t\t\t\t\t\tfloat w \x3d gaussianPdf(x, fSigma);\t\t\t\t\t\tvec2 uvOffset \x3d direction * invSize * x;\t\t\t\t\t\tvec3 sample1 \x3d texture2D( colorTexture, vUv + uvOffset).rgb;\t\t\t\t\t\tvec3 sample2 \x3d texture2D( colorTexture, vUv - uvOffset).rgb;\t\t\t\t\t\tdiffuseSum +\x3d (sample1 + sample2) * w;\t\t\t\t\t\tweightSum +\x3d 2.0 * w;\t\t\t\t\t}\t\t\t\t\tgl_FragColor \x3d vec4(diffuseSum/weightSum, 1.0);\n\t\t\t\t}"})},
getCompositeMaterial:function(a){return new THREE.ShaderMaterial({defines:{NUM_MIPS:a},uniforms:{blurTexture1:{value:null},blurTexture2:{value:null},blurTexture3:{value:null},blurTexture4:{value:null},blurTexture5:{value:null},dirtTexture:{value:null},bloomStrength:{value:1},bloomFactors:{value:null},bloomTintColors:{value:null},bloomRadius:{value:0}},vertexShader:"varying vec2 vUv;\n\t\t\t\tvoid main() {\n\t\t\t\t\tvUv \x3d uv;\n\t\t\t\t\tgl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n\t\t\t\t}",
fragmentShader:"varying vec2 vUv;\t\t\t\tuniform sampler2D blurTexture1;\t\t\t\tuniform sampler2D blurTexture2;\t\t\t\tuniform sampler2D blurTexture3;\t\t\t\tuniform sampler2D blurTexture4;\t\t\t\tuniform sampler2D blurTexture5;\t\t\t\tuniform sampler2D dirtTexture;\t\t\t\tuniform float bloomStrength;\t\t\t\tuniform float bloomRadius;\t\t\t\tuniform float bloomFactors[NUM_MIPS];\t\t\t\tuniform vec3 bloomTintColors[NUM_MIPS];\t\t\t\t\t\t\t\tfloat lerpBloomFactor(const in float factor) { \t\t\t\t\tfloat mirrorFactor \x3d 1.2 - factor;\t\t\t\t\treturn mix(factor, mirrorFactor, bloomRadius);\t\t\t\t}\t\t\t\t\t\t\t\tvoid main() {\t\t\t\t\tgl_FragColor \x3d bloomStrength * ( lerpBloomFactor(bloomFactors[0]) * vec4(bloomTintColors[0], 1.0) * texture2D(blurTexture1, vUv) + \t\t\t\t\t\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[1]) * vec4(bloomTintColors[1], 1.0) * texture2D(blurTexture2, vUv) + \t\t\t\t\t\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[2]) * vec4(bloomTintColors[2], 1.0) * texture2D(blurTexture3, vUv) + \t\t\t\t\t\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[3]) * vec4(bloomTintColors[3], 1.0) * texture2D(blurTexture4, vUv) + \t\t\t\t\t\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[4]) * vec4(bloomTintColors[4], 1.0) * texture2D(blurTexture5, vUv) );\t\t\t\t}"})}});
THREE.UnrealBloomPass.BlurDirectionX=new THREE.Vector2(1,0);THREE.UnrealBloomPass.BlurDirectionY=new THREE.Vector2(0,1);