THREE.PMREMGenerator=function(a,c,b){this.sourceTexture=a;this.resolution=void 0!==b?b:256;this.samplesPerLevel=void 0!==c?c:16;a=a.encoding===THREE.LinearEncoding||a.encoding===THREE.GammaEncoding||a.encoding===THREE.sRGBEncoding;this.sourceTexture.minFilter=a?THREE.LinearFilter:THREE.NearestFilter;this.sourceTexture.magFilter=a?THREE.LinearFilter:THREE.NearestFilter;this.sourceTexture.generateMipmaps=this.sourceTexture.generateMipmaps&&a;this.cubeLods=[];a=this.resolution;c={format:this.sourceTexture.format,
magFilter:this.sourceTexture.magFilter,minFilter:this.sourceTexture.minFilter,type:this.sourceTexture.type,generateMipmaps:this.sourceTexture.generateMipmaps,anisotropy:this.sourceTexture.anisotropy,encoding:this.sourceTexture.encoding};this.numLods=Math.log(a)/Math.log(2)-2;for(b=0;b<this.numLods;b++){var e=new THREE.WebGLRenderTargetCube(a,a,c);e.texture.name="PMREMGenerator.cube"+b;this.cubeLods.push(e);a=Math.max(16,a/2)}this.camera=new THREE.OrthographicCamera(-1,1,1,-1,0,1E3);this.shader=this.getShader();
this.shader.defines.SAMPLES_PER_LEVEL=this.samplesPerLevel;this.planeMesh=new THREE.Mesh(new THREE.PlaneGeometry(2,2,0),this.shader);this.planeMesh.material.side=THREE.DoubleSide;this.scene=new THREE.Scene;this.scene.add(this.planeMesh);this.scene.add(this.camera);this.shader.uniforms.envMap.value=this.sourceTexture;this.shader.envMap=this.sourceTexture};
THREE.PMREMGenerator.prototype={constructor:THREE.PMREMGenerator,update:function(a){this.shader.uniforms.envMap.value=this.sourceTexture;this.shader.envMap=this.sourceTexture;var c=a.gammaInput,b=a.gammaOutput,e=a.toneMapping,f=a.toneMappingExposure;a.toneMapping=THREE.LinearToneMapping;a.toneMappingExposure=1;a.gammaInput=!1;a.gammaOutput=!1;for(var d=0;d<this.numLods;d++)this.shader.uniforms.roughness.value=d/(this.numLods-1)*.9,this.shader.uniforms.queryScale.value.x=0==d?-1:1,this.shader.uniforms.mapSize.value=
this.cubeLods[d].width,this.renderToCubeMapTarget(a,this.cubeLods[d]),5>d&&(this.shader.uniforms.envMap.value=this.cubeLods[d].texture);a.toneMapping=e;a.toneMappingExposure=f;a.gammaInput=c;a.gammaOutput=b},renderToCubeMapTarget:function(a,c){for(var b=0;6>b;b++)this.renderToCubeMapTargetFace(a,c,b)},renderToCubeMapTargetFace:function(a,c,b){c.activeCubeFace=b;this.shader.uniforms.faceIndex.value=b;a.render(this.scene,this.camera,c,!0)},getShader:function(){return new THREE.ShaderMaterial({defines:{SAMPLES_PER_LEVEL:20},
uniforms:{faceIndex:{value:0},roughness:{value:.5},mapSize:{value:.5},envMap:{value:null},queryScale:{value:new THREE.Vector3(1,1,1)},testColor:{value:new THREE.Vector3(1,1,1)}},vertexShader:"varying vec2 vUv;\n\t\t\t\tvoid main() {\n\t\t\t\t\tvUv \x3d uv;\n\t\t\t\t\tgl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n\t\t\t\t}",fragmentShader:"#include \x3ccommon\x3e\n\t\t\t\tvarying vec2 vUv;\n\t\t\t\tuniform int faceIndex;\n\t\t\t\tuniform float roughness;\n\t\t\t\tuniform samplerCube envMap;\n\t\t\t\tuniform float mapSize;\n\t\t\t\tuniform vec3 testColor;\n\t\t\t\tuniform vec3 queryScale;\n\t\t\t\t\n\t\t\t\tfloat GGXRoughnessToBlinnExponent( const in float ggxRoughness ) {\n\t\t\t\t\tfloat a \x3d ggxRoughness + 0.0001;\n\t\t\t\t\ta *\x3d a;\n\t\t\t\t\treturn ( 2.0 / a - 2.0 );\n\t\t\t\t}\n\t\t\t\tvec3 ImportanceSamplePhong(vec2 uv, mat3 vecSpace, float specPow) {\n\t\t\t\t\tfloat phi \x3d uv.y * 2.0 * PI;\n\t\t\t\t\tfloat cosTheta \x3d pow(1.0 - uv.x, 1.0 / (specPow + 1.0));\n\t\t\t\t\tfloat sinTheta \x3d sqrt(1.0 - cosTheta * cosTheta);\n\t\t\t\t\tvec3 sampleDir \x3d vec3(cos(phi) * sinTheta, sin(phi) * sinTheta, cosTheta);\n\t\t\t\t\treturn vecSpace * sampleDir;\n\t\t\t\t}\n\t\t\t\tvec3 ImportanceSampleGGX( vec2 uv, mat3 vecSpace, float Roughness )\n\t\t\t\t{\n\t\t\t\t\tfloat a \x3d Roughness * Roughness;\n\t\t\t\t\tfloat Phi \x3d 2.0 * PI * uv.x;\n\t\t\t\t\tfloat CosTheta \x3d sqrt( (1.0 - uv.y) / ( 1.0 + (a*a - 1.0) * uv.y ) );\n\t\t\t\t\tfloat SinTheta \x3d sqrt( 1.0 - CosTheta * CosTheta );\n\t\t\t\t\treturn vecSpace * vec3(SinTheta * cos( Phi ), SinTheta * sin( Phi ), CosTheta);\n\t\t\t\t}\n\t\t\t\tmat3 matrixFromVector(vec3 n) {\n\t\t\t\t\tfloat a \x3d 1.0 / (1.0 + n.z);\n\t\t\t\t\tfloat b \x3d -n.x * n.y * a;\n\t\t\t\t\tvec3 b1 \x3d vec3(1.0 - n.x * n.x * a, b, -n.x);\n\t\t\t\t\tvec3 b2 \x3d vec3(b, 1.0 - n.y * n.y * a, -n.y);\n\t\t\t\t\treturn mat3(b1, b2, n);\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tvec4 testColorMap(float Roughness) {\n\t\t\t\t\tvec4 color;\n\t\t\t\t\tif(faceIndex \x3d\x3d 0)\n\t\t\t\t\t\tcolor \x3d vec4(1.0,0.0,0.0,1.0);\n\t\t\t\t\telse if(faceIndex \x3d\x3d 1)\n\t\t\t\t\t\tcolor \x3d vec4(0.0,1.0,0.0,1.0);\n\t\t\t\t\telse if(faceIndex \x3d\x3d 2)\n\t\t\t\t\t\tcolor \x3d vec4(0.0,0.0,1.0,1.0);\n\t\t\t\t\telse if(faceIndex \x3d\x3d 3)\n\t\t\t\t\t\tcolor \x3d vec4(1.0,1.0,0.0,1.0);\n\t\t\t\t\telse if(faceIndex \x3d\x3d 4)\n\t\t\t\t\t\tcolor \x3d vec4(0.0,1.0,1.0,1.0);\n\t\t\t\t\telse\n\t\t\t\t\t\tcolor \x3d vec4(1.0,0.0,1.0,1.0);\n\t\t\t\t\tcolor *\x3d ( 1.0 - Roughness );\n\t\t\t\t\treturn color;\n\t\t\t\t}\n\t\t\t\tvoid main() {\n\t\t\t\t\tvec3 sampleDirection;\n\t\t\t\t\tvec2 uv \x3d vUv*2.0 - 1.0;\n\t\t\t\t\tfloat offset \x3d -1.0/mapSize;\n\t\t\t\t\tconst float a \x3d -1.0;\n\t\t\t\t\tconst float b \x3d 1.0;\n\t\t\t\t\tfloat c \x3d -1.0 + offset;\n\t\t\t\t\tfloat d \x3d 1.0 - offset;\n\t\t\t\t\tfloat bminusa \x3d b - a;\n\t\t\t\t\tuv.x \x3d (uv.x - a)/bminusa * d - (uv.x - b)/bminusa * c;\n\t\t\t\t\tuv.y \x3d (uv.y - a)/bminusa * d - (uv.y - b)/bminusa * c;\n\t\t\t\t\tif (faceIndex\x3d\x3d0) {\n\t\t\t\t\t\tsampleDirection \x3d vec3(1.0, -uv.y, -uv.x);\n\t\t\t\t\t} else if (faceIndex\x3d\x3d1) {\n\t\t\t\t\t\tsampleDirection \x3d vec3(-1.0, -uv.y, uv.x);\n\t\t\t\t\t} else if (faceIndex\x3d\x3d2) {\n\t\t\t\t\t\tsampleDirection \x3d vec3(uv.x, 1.0, uv.y);\n\t\t\t\t\t} else if (faceIndex\x3d\x3d3) {\n\t\t\t\t\t\tsampleDirection \x3d vec3(uv.x, -1.0, -uv.y);\n\t\t\t\t\t} else if (faceIndex\x3d\x3d4) {\n\t\t\t\t\t\tsampleDirection \x3d vec3(uv.x, -uv.y, 1.0);\n\t\t\t\t\t} else {\n\t\t\t\t\t\tsampleDirection \x3d vec3(-uv.x, -uv.y, -1.0);\n\t\t\t\t\t}\n\t\t\t\t\tmat3 vecSpace \x3d matrixFromVector(normalize(sampleDirection * queryScale));\n\t\t\t\t\tvec3 rgbColor \x3d vec3(0.0);\n\t\t\t\t\tconst int NumSamples \x3d SAMPLES_PER_LEVEL;\n\t\t\t\t\tvec3 vect;\n\t\t\t\t\tfloat weight \x3d 0.0;\n\t\t\t\t\tfor( int i \x3d 0; i \x3c NumSamples; i ++ ) {\n\t\t\t\t\t\tfloat sini \x3d sin(float(i));\n\t\t\t\t\t\tfloat cosi \x3d cos(float(i));\n\t\t\t\t\t\tfloat r \x3d rand(vec2(sini, cosi));\n\t\t\t\t\t\tvect \x3d ImportanceSampleGGX(vec2(float(i) / float(NumSamples), r), vecSpace, roughness);\n\t\t\t\t\t\tfloat dotProd \x3d dot(vect, normalize(sampleDirection));\n\t\t\t\t\t\tweight +\x3d dotProd;\n\t\t\t\t\t\tvec3 color \x3d envMapTexelToLinear(textureCube(envMap,vect)).rgb;\n\t\t\t\t\t\trgbColor.rgb +\x3d color;\n\t\t\t\t\t}\n\t\t\t\t\trgbColor /\x3d float(NumSamples);\n\t\t\t\t\t//rgbColor \x3d testColorMap( roughness ).rgb;\n\t\t\t\t\tgl_FragColor \x3d linearToOutputTexel( vec4( rgbColor, 1.0 ) );\n\t\t\t\t}",
blending:THREE.CustomBlending,blendSrc:THREE.OneFactor,blendDst:THREE.ZeroFactor,blendSrcAlpha:THREE.OneFactor,blendDstAlpha:THREE.ZeroFactor,blendEquation:THREE.AddEquation})}};