var SEA3D={VERSION:18100,getVersion:function(){var b=SEA3D.VERSION.toString(),a=b.length;return b.substring(0,a-4)+"."+b.substring(a-4,a-3)+"."+b.substring(a-3,a-2)+"."+parseFloat(b.substring(a-2,a)).toString()}};console.log("SEA3D "+SEA3D.getVersion());SEA3D.Stream=function(b){this.position=0;this.buffer=b||new ArrayBuffer};SEA3D.Stream.NONE=0;SEA3D.Stream.BOOLEAN=1;SEA3D.Stream.BYTE=2;SEA3D.Stream.UBYTE=3;SEA3D.Stream.SHORT=4;SEA3D.Stream.USHORT=5;SEA3D.Stream.INT24=6;SEA3D.Stream.UINT24=7;
SEA3D.Stream.INT=8;SEA3D.Stream.UINT=9;SEA3D.Stream.FLOAT=10;SEA3D.Stream.DOUBLE=11;SEA3D.Stream.DECIMAL=12;SEA3D.Stream.VECTOR3D=74;SEA3D.Stream.VECTOR4D=106;SEA3D.Stream.STRING_TINY=128;SEA3D.Stream.STRING_SHORT=129;SEA3D.Stream.STRING_LONG=130;SEA3D.Stream.ASSET=200;SEA3D.Stream.GROUP=255;SEA3D.Stream.BLEND_MODE="normal add subtract multiply dividing mix alpha screen darken overlay colorburn linearburn lighten colordodge lineardodge softlight hardlight pinlight spotlight spotlightblend hardmix average difference exclusion hue saturation color value linearlight grainextract reflect glow darkercolor lightercolor phoenix negation".split(" ");
SEA3D.Stream.INTERPOLATION_TABLE="normal linear sine.in sine.out sine.inout cubic.in cubic.out cubic.inout quint.in quint.out quint.inout circ.in circ.out circ.inout back.in back.out back.inout quad.in quad.out quad.inout quart.in quart.out quart.inout expo.in expo.out expo.inout elastic.in elastic.out elastic.inout bounce.in bounce.out bounce.inout".split(" ");SEA3D.Stream.sizeOf=function(b){return 0==b?0:1<=b&&31>=b?1:32<=b&&63>=b?2:64<=b&&95>=b?3:96<=b&&125>=b?4:-1};
SEA3D.Stream.prototype={constructor:SEA3D.Stream,set buffer(b){this.buf=b;this.length=b.byteLength;this.data=new DataView(b)},get buffer(){return this.buf},get bytesAvailable(){return this.length-this.position}};SEA3D.Stream.prototype.getByte=function(b){return this.data.getInt8(b)};SEA3D.Stream.prototype.readBytes=function(b){var a=this.buf.slice(this.position,this.position+b);this.position+=b;return a};SEA3D.Stream.prototype.readByte=function(){return this.data.getInt8(this.position++)};
SEA3D.Stream.prototype.readUByte=function(){return this.data.getUint8(this.position++)};SEA3D.Stream.prototype.readBool=function(){return 0!=this.data.getInt8(this.position++)};SEA3D.Stream.prototype.readShort=function(){var b=this.data.getInt16(this.position,!0);this.position+=2;return b};SEA3D.Stream.prototype.readUShort=function(){var b=this.data.getUint16(this.position,!0);this.position+=2;return b};
SEA3D.Stream.prototype.readUInt24=function(){var b=this.data.getUint32(this.position,!0)&16777215;this.position+=3;return b};SEA3D.Stream.prototype.readUInt24F=function(){return this.readUShort()|this.readUByte()<<16};SEA3D.Stream.prototype.readInt=function(){var b=this.data.getInt32(this.position,!0);this.position+=4;return b};SEA3D.Stream.prototype.readUInt=function(){var b=this.data.getUint32(this.position,!0);this.position+=4;return b};
SEA3D.Stream.prototype.readFloat=function(){var b=this.data.getFloat32(this.position,!0);this.position+=4;return b};SEA3D.Stream.prototype.readUInteger=function(){var b=this.readUByte(),a=b&127;0!=(b&128)&&(b=this.readUByte(),a|=(b&127)<<7,0!=(b&128)&&(b=this.readUByte(),a|=(b&127)<<13));return a};SEA3D.Stream.prototype.readVector2=function(){return{x:this.readFloat(),y:this.readFloat()}};SEA3D.Stream.prototype.readVector3=function(){return{x:this.readFloat(),y:this.readFloat(),z:this.readFloat()}};
SEA3D.Stream.prototype.readVector4=function(){return{x:this.readFloat(),y:this.readFloat(),z:this.readFloat(),w:this.readFloat()}};
SEA3D.Stream.prototype.readMatrix=function(){var b=new Float32Array(16);b[0]=this.readFloat();b[1]=this.readFloat();b[2]=this.readFloat();b[3]=0;b[4]=this.readFloat();b[5]=this.readFloat();b[6]=this.readFloat();b[7]=0;b[8]=this.readFloat();b[9]=this.readFloat();b[10]=this.readFloat();b[11]=0;b[12]=this.readFloat();b[13]=this.readFloat();b[14]=this.readFloat();b[15]=1;return b};
SEA3D.Stream.prototype.readUTF8=function(b){b=this.readBytes(b);return window.TextDecoder?(new TextDecoder).decode(b):decodeURIComponent(escape(String.fromCharCode.apply(null,new Uint8Array(b))))};SEA3D.Stream.prototype.readExt=function(){return this.readUTF8(4).replace(/\0/g,"")};SEA3D.Stream.prototype.readUTF8Tiny=function(){return this.readUTF8(this.readUByte())};SEA3D.Stream.prototype.readUTF8Short=function(){return this.readUTF8(this.readUShort())};SEA3D.Stream.prototype.readUTF8Long=function(){return this.readUTF8(this.readUInt())};
SEA3D.Stream.prototype.readUByteArray=function(b){var a=new Uint8Array(b);SEA3D.Stream.memcpy(a.buffer,0,this.buffer,this.position,b);this.position+=b;return a};SEA3D.Stream.prototype.readUShortArray=function(b){var a=new Uint16Array(b);b*=2;SEA3D.Stream.memcpy(a.buffer,0,this.buffer,this.position,b);this.position+=b;return a};SEA3D.Stream.prototype.readUInt24Array=function(b){for(var a=new Uint32Array(b),c=0;c<b;c++)a[c]=this.readUInt24();return a};
SEA3D.Stream.prototype.readUIntArray=function(b){var a=new Uint32Array(b);b*=4;SEA3D.Stream.memcpy(a.buffer,0,this.buffer,this.position,b);this.position+=b;return a};SEA3D.Stream.prototype.readFloatArray=function(b){var a=new Float32Array(b);b*=4;SEA3D.Stream.memcpy(a.buffer,0,this.buffer,this.position,b);this.position+=b;return a};SEA3D.Stream.prototype.readBlendMode=function(){return SEA3D.Stream.BLEND_MODE[this.readUByte()]};SEA3D.Stream.prototype.readInterpolation=function(){return SEA3D.Stream.INTERPOLATION_TABLE[this.readUByte()]};
SEA3D.Stream.prototype.readTags=function(b){for(var a=this.readUByte(),c=0;c<a;++c){var d=this.readUShort(),f=this.readUInt(),g=this.position;b(d,this,f);this.position=g+f}};SEA3D.Stream.prototype.readProperties=function(b){var a=this.readUByte(),c={},d={};c.__type=d;for(var f=0;f<a;f++){var g=this.readUTF8Tiny(),h=this.readUByte();d[g]=h;c[g]=h==SEA3D.Stream.GROUP?this.readProperties(b):this.readToken(h,b)}return c};
SEA3D.Stream.prototype.readAnimationList=function(b){for(var a=[],c=this.readUByte(),d=0;d<c;){var f=this.readUByte(),g={};g.relative=0!=(f&1);f&2&&(g.timeScale=this.readFloat());g.tag=b.getObject(this.readUInt());a[d++]=g}return a};
SEA3D.Stream.prototype.readScriptList=function(b){for(var a=[],c=this.readUByte(),d=0;d<c;){var f=this.readUByte(),g={};g.priority=f&1|f&2;if(f&4){var h=this.readUByte();g.params={};for(var e=0;e<h;e++){var k=this.readUTF8Tiny();g.params[k]=this.readObject(b)}}f&8&&(g.method=this.readUTF8Tiny());g.tag=b.getObject(this.readUInt());a[d++]=g}return a};SEA3D.Stream.prototype.readObject=function(b){return this.readToken(this.readUByte(),b)};
SEA3D.Stream.prototype.readToken=function(b,a){switch(b){case SEA3D.Stream.BOOLEAN:return this.readBool();case SEA3D.Stream.UBYTE:return this.readUByte();case SEA3D.Stream.USHORT:return this.readUShort();case SEA3D.Stream.UINT24:return this.readUInt24();case SEA3D.Stream.INT:return this.readInt();case SEA3D.Stream.UINT:return this.readUInt();case SEA3D.Stream.FLOAT:return this.readFloat();case SEA3D.Stream.VECTOR3D:return this.readVector3();case SEA3D.Stream.VECTOR4D:return this.readVector4();case SEA3D.Stream.STRING_TINY:return this.readUTF8Tiny();
case SEA3D.Stream.STRING_SHORT:return this.readUTF8Short();case SEA3D.Stream.STRING_LONG:return this.readUTF8Long();case SEA3D.Stream.ASSET:var c=this.readUInt();return 0<c?a.getObject(c-1).tag:null;default:console.error("DataType not found!")}return null};
SEA3D.Stream.prototype.readVector=function(b,a,c){var d=SEA3D.Stream.sizeOf(b);a=c*d+a*d;switch(b){case SEA3D.Stream.BOOLEAN:return this.readUByteArray(a);case SEA3D.Stream.UBYTE:return this.readUByteArray(a);case SEA3D.Stream.USHORT:return this.readUShortArray(a);case SEA3D.Stream.UINT24:return this.readUInt24Array(a);case SEA3D.Stream.UINT:return this.readUIntArray(a);case SEA3D.Stream.FLOAT:return this.readFloatArray(a);case SEA3D.Stream.VECTOR3D:return this.readFloatArray(a);case SEA3D.Stream.VECTOR4D:return this.readFloatArray(a)}};
SEA3D.Stream.prototype.append=function(b){var a=new ArrayBuffer(this.data.byteLength+b.byteLength);a.set(new ArrayBuffer(this.data),0);a.set(new ArrayBuffer(b),this.data.byteLength);this.data=a};SEA3D.Stream.prototype.concat=function(b,a){return new SEA3D.Stream(this.buffer.slice(b,b+a))};SEA3D.Stream.memcpy=function(b,a,c,d,f){b=new Uint8Array(b,a,f);c=new Uint8Array(c,d,f);b.set(c)};SEA3D.UByteArray=function(){this.ubytes=[];this.length=0};
SEA3D.UByteArray.prototype={constructor:SEA3D.UByteArray,add:function(b){this.ubytes.push(b);this.length+=b.byteLength},toBuffer:function(){for(var b=new Uint8Array(this.length),a=0,c=0;a<this.ubytes.length;a++)b.set(this.ubytes[a],c),c+=this.ubytes[a].byteLength;return b.buffer}};SEA3D.Math={DEGREES:180/Math.PI,RADIANS:Math.PI/180};SEA3D.Math.angle=function(b){var a=0>b;b=(a?-b:b)%360;180<b&&(b=-180+(b-180));return a?-b:b};
SEA3D.Math.lerpAngle=function(b,a,c){180<Math.abs(b-a)&&(a=b>a?a+360:a-360);return SEA3D.Math.angle(b+(a-b)*c)};SEA3D.Math.lerpColor=function(b,a,c){var d=b>>24&255,f=b>>16&255,g=b>>8&255;b&=255;f+=((a>>16&255)-f)*c;g+=((a>>8&255)-g)*c;b+=((a&255)-b)*c;return d+((a>>24&255)-d)*c<<24|f<<16|g<<8|b};SEA3D.Math.lerp=function(b,a,c){return b+(a-b)*c};SEA3D.Math.lerp1x=function(b,a,c){b[0]+=(a[0]-b[0])*c};SEA3D.Math.lerp3x=function(b,a,c){b[0]+=(a[0]-b[0])*c;b[1]+=(a[1]-b[1])*c;b[2]+=(a[2]-b[2])*c};
SEA3D.Math.lerpAng1x=function(b,a,c){b[0]=SEA3D.Math.lerpAngle(b[0],a[0],c)};SEA3D.Math.lerpColor1x=function(b,a,c){b[0]=SEA3D.Math.lerpColor(b[0],a[0],c)};SEA3D.Math.lerpQuat4x=function(b,a,c){var d=b[0],f=b[1],g=b[2],h=b[3],e=a[0],k=a[1],l=a[2];a=a[3];0>d*e+f*k+g*l+h*a&&(e=-e,k=-k,l=-l,a=-a);d+=c*(e-d);f+=c*(k-f);g+=c*(l-g);c=h+c*(a-h);h=1/Math.sqrt(c*c+d*d+f*f+g*g);b[0]=d*h;b[1]=f*h;b[2]=g*h;b[3]=c*h};SEA3D.Timer=function(){this.time=this.start=Date.now()};
SEA3D.Timer.prototype={constructor:SEA3D.Timer,get now(){return Date.now()},get deltaTime(){return Date.now()-this.time},get elapsedTime(){return Date.now()-this.start},update:function(){this.time=Date.now()}};SEA3D.Object=function(b,a,c,d){this.name=b;this.data=a;this.type=c;this.sea3d=d};
SEA3D.GeometryBase=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.attrib=a.readUShort();this.isBig=0!=(this.attrib&1);a.readVInt=this.isBig?a.readUInt:a.readUShort;this.numVertex=a.readVInt();this.length=3*this.numVertex};
SEA3D.Geometry=function(b,a,c){SEA3D.GeometryBase.call(this,b,a,c);var d;this.attrib&4&&(this.normal=a.readFloatArray(this.length));this.attrib&8&&(this.tangent=a.readFloatArray(this.length));if(this.attrib&32)for(this.uv=[],this.uv.length=a.readUByte(),d=2*this.numVertex,b=0;b<this.uv.length;)this.uv[b++]=a.readFloatArray(d);this.attrib&64&&(this.jointPerVertex=a.readUByte(),b=this.numVertex*this.jointPerVertex,this.joint=a.readUShortArray(b),this.weight=a.readFloatArray(b));if(this.attrib&128)for(c=
a.readUByte(),this.numColor=((c&64)>>6|(c&128)>>6)+1,this.color=[],b=0,d=c&15;b<d;b++)this.color.push(a.readFloatArray(this.numVertex*this.numColor));this.vertex=a.readFloatArray(this.length);var f=a.readUByte();this.groups=[];if(this.attrib&1024){for(d=b=0;b<f;b++)c=3*a.readVInt(),this.groups.push({start:d,count:c}),d+=c;this.indexes=this.isBig?a.readUIntArray(d):a.readUShortArray(d)}else{var g=this.isBig?4:2,h=new SEA3D.UByteArray;for(c=b=0;b<f;b++)d=3*a.readVInt(),this.groups.push({start:c,count:d}),
c+=d,h.add(a.readUByteArray(d*g));this.indexes=this.isBig?new Uint32Array(h.toBuffer()):new Uint16Array(h.toBuffer())}};SEA3D.Geometry.prototype=Object.create(SEA3D.GeometryBase.prototype);SEA3D.Geometry.prototype.constructor=SEA3D.Geometry;SEA3D.Geometry.prototype.type="geo";
SEA3D.Object3D=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.isStatic=!1;this.visible=!0;this.attrib=a.readUShort();this.attrib&1&&(this.parent=c.getObject(a.readUInt()));this.attrib&2&&(this.animations=a.readAnimationList(c));this.attrib&4&&(this.scripts=a.readScriptList(c));this.attrib&16&&(this.attributes=c.getObject(a.readUInt()));this.attrib&32&&(b=a.readUByte(),this.isStatic=0!=(b&1),this.visible=0==(b&2))};SEA3D.Object3D.prototype.readTag=function(b,a,c){};
SEA3D.Entity3D=function(b,a,c){SEA3D.Object3D.call(this,b,a,c);this.castShadows=!0;this.attrib&64&&(this.castShadows=0==(a.readUByte()&1))};SEA3D.Entity3D.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Entity3D.prototype.constructor=SEA3D.Entity3D;SEA3D.Sound3D=function(b,a,c){SEA3D.Object3D.call(this,b,a,c);this.autoPlay=0!=(this.attrib&64);this.attrib&128&&(this.mixer=c.getObject(a.readUInt()));this.sound=c.getObject(a.readUInt());this.volume=a.readFloat()};SEA3D.Sound3D.prototype=Object.create(SEA3D.Object3D.prototype);
SEA3D.Sound3D.prototype.constructor=SEA3D.Sound3D;SEA3D.SoundPoint=function(b,a,c){SEA3D.Sound3D.call(this,b,a,c);this.position=a.readVector3();this.distance=a.readFloat();a.readTags(this.readTag.bind(this))};SEA3D.SoundPoint.prototype=Object.create(SEA3D.Sound3D.prototype);SEA3D.SoundPoint.prototype.constructor=SEA3D.SoundPoint;SEA3D.SoundPoint.prototype.type="sp";SEA3D.Container3D=function(b,a,c){SEA3D.Object3D.call(this,b,a,c);this.transform=a.readMatrix();a.readTags(this.readTag.bind(this))};
SEA3D.Container3D.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Container3D.prototype.constructor=SEA3D.Container3D;SEA3D.Container3D.prototype.type="c3d";SEA3D.ScriptURL=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.url=a.readUTF8(a.length)};SEA3D.ScriptURL.prototype.type="src";SEA3D.TextureURL=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.url=a.readUTF8(a.length)};SEA3D.TextureURL.prototype.type="urlT";
SEA3D.CubeMapURL=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.faces=[];for(b=0;6>b;b++)this.faces[b]=a.readUTF8Tiny()};SEA3D.CubeMapURL.prototype.type="cURL";
SEA3D.Actions=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.count=a.readUInt();this.actions=[];for(b=0;b<this.count;b++){var d=a.readUByte(),f=a.readUShort(),g=a.readUShort(),h=a.position,e=this.actions[b]={kind:f};d&1&&(e.range=[a.readUInt(),a.readUInt()]);d&2&&(e.time=a.readUInt());d&4&&(e.intrpl=a.readInterpolation(),0==e.intrpl.indexOf("back.")?e.intrplParam0=a.readFloat():0==e.intrpl.indexOf("elastic.")&&(e.intrplParam0=a.readFloat(),e.intrplParam1=a.readFloat()));switch(f){case SEA3D.Actions.RTT_TARGET:e.source=
c.getObject(a.readUInt());e.target=c.getObject(a.readUInt());break;case SEA3D.Actions.LOOK_AT:e.source=c.getObject(a.readUInt());e.target=c.getObject(a.readUInt());break;case SEA3D.Actions.PLAY_SOUND:e.sound=c.getObject(a.readUInt());e.offset=a.readUInt();break;case SEA3D.Actions.PLAY_ANIMATION:e.object=c.getObject(a.readUInt());e.name=a.readUTF8Tiny();break;case SEA3D.Actions.FOG:e.color=a.readUInt24();e.min=a.readFloat();e.max=a.readFloat();break;case SEA3D.Actions.ENVIRONMENT:e.texture=c.getObject(a.readUInt());
break;case SEA3D.Actions.ENVIRONMENT_COLOR:e.color=a.readUInt24F();break;case SEA3D.Actions.CAMERA:e.camera=c.getObject(a.readUInt());break;case SEA3D.Actions.SCRIPTS:e.scripts=a.readScriptList(c);break;case SEA3D.Actions.CLASS_OF:e.classof=c.getObject(a.readUInt());break;case SEA3D.Actions.ATTRIBUTES:e.attributes=c.getObject(a.readUInt());break;default:console.log('Action "'+f+'" not found.')}a.position=h+g}};SEA3D.Actions.SCENE=0;SEA3D.Actions.ENVIRONMENT_COLOR=1;SEA3D.Actions.ENVIRONMENT=2;
SEA3D.Actions.FOG=3;SEA3D.Actions.PLAY_ANIMATION=4;SEA3D.Actions.PLAY_SOUND=5;SEA3D.Actions.ANIMATION_AUDIO_SYNC=6;SEA3D.Actions.LOOK_AT=7;SEA3D.Actions.RTT_TARGET=8;SEA3D.Actions.CAMERA=9;SEA3D.Actions.SCRIPTS=10;SEA3D.Actions.CLASS_OF=11;SEA3D.Actions.ATTRIBUTES=12;SEA3D.Actions.prototype.type="act";SEA3D.Properties=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.tag=a.readProperties(c);this.tag.__name=b};SEA3D.Properties.prototype.type="prop";
SEA3D.FileInfo=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.tag=a.readProperties(c);this.tag.__name=b;c.info=this.tag};SEA3D.FileInfo.prototype.type="info";SEA3D.JavaScript=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.src=a.readUTF8(a.length)};SEA3D.JavaScript.prototype.type="js";SEA3D.JavaScriptMethod=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;b=a.readUShort();this.methods={};for(c=0;c<b;c++){a.readUByte();var d=a.readUTF8Tiny();this.methods[d]={src:a.readUTF8Long()}}};
SEA3D.JavaScriptMethod.prototype.type="jsm";SEA3D.GLSL=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.src=a.readUTF8(a.length)};SEA3D.GLSL.prototype.type="glsl";SEA3D.Dummy=function(b,a,c){SEA3D.Object3D.call(this,b,a,c);this.transform=a.readMatrix();this.width=a.readFloat();this.height=a.readFloat();this.depth=a.readFloat();a.readTags(this.readTag.bind(this))};SEA3D.Dummy.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Dummy.prototype.constructor=SEA3D.Dummy;
SEA3D.Dummy.prototype.type="dmy";SEA3D.Line=function(b,a,c){SEA3D.Object3D.call(this,b,a,c);this.count=3*(this.attrib&64?a.readUInt():a.readUShort());this.closed=0!=(this.attrib&128);this.transform=a.readMatrix();this.vertex=[];for(b=0;b<this.count;)this.vertex[b++]=a.readFloat();a.readTags(this.readTag.bind(this))};SEA3D.Line.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Line.prototype.constructor=SEA3D.Line;SEA3D.Line.prototype.type="line";
SEA3D.Sprite=function(b,a,c){SEA3D.Object3D.call(this,b,a,c);this.attrib&256&&(this.material=c.getObject(a.readUInt()));this.position=a.readVector3();this.width=a.readFloat();this.height=a.readFloat();a.readTags(this.readTag.bind(this))};SEA3D.Sprite.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Sprite.prototype.constructor=SEA3D.Sprite;SEA3D.Sprite.prototype.type="m2d";
SEA3D.Mesh=function(b,a,c){SEA3D.Entity3D.call(this,b,a,c);if(this.attrib&256)if(this.material=[],b=a.readUByte(),1==b)this.material[0]=c.getObject(a.readUInt());else for(var d=0;d<b;){var f=a.readUInt();0<f?this.material[d++]=c.getObject(f-1):this.material[d++]=void 0}if(this.attrib&512)for(this.modifiers=[],b=a.readUByte(),d=0;d<b;d++)this.modifiers[d]=c.getObject(a.readUInt());this.attrib&1024&&(this.reference={type:a.readUByte(),ref:c.getObject(a.readUInt())});this.transform=a.readMatrix();this.geometry=
c.getObject(a.readUInt());a.readTags(this.readTag.bind(this))};SEA3D.Mesh.prototype=Object.create(SEA3D.Entity3D.prototype);SEA3D.Mesh.prototype.constructor=SEA3D.Mesh;SEA3D.Mesh.prototype.type="m3d";SEA3D.Skeleton=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;b=a.readUShort();this.joint=[];for(c=0;c<b;c++)this.joint[c]={name:a.readUTF8Tiny(),parentIndex:a.readUShort()-1,inverseBindMatrix:a.readMatrix()}};SEA3D.Skeleton.prototype.type="skl";
SEA3D.SkeletonLocal=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;b=a.readUShort();this.joint=[];for(c=0;c<b;c++)this.joint[c]={name:a.readUTF8Tiny(),parentIndex:a.readUShort()-1,x:a.readFloat(),y:a.readFloat(),z:a.readFloat(),qx:a.readFloat(),qy:a.readFloat(),qz:a.readFloat(),qw:a.readFloat()}};SEA3D.SkeletonLocal.prototype.type="sklq";
SEA3D.AnimationBase=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;b=a.readUByte();this.sequence=[];if(b&1){c=a.readUShort();for(var d=0;d<c;d++)b=a.readUByte(),this.sequence[d]={name:a.readUTF8Tiny(),start:a.readUInt(),count:a.readUInt(),repeat:0!=(b&1),intrpl:0==(b&2)}}this.frameRate=a.readUByte();this.numFrames=a.readUInt();0==this.sequence.length&&(this.sequence[0]={name:"root",start:0,count:this.numFrames,repeat:!0,intrpl:!0})};
SEA3D.Animation=function(b,a,c){SEA3D.AnimationBase.call(this,b,a,c);this.dataList=[];b=0;for(c=a.readUByte();b<c;b++){var d=a.readUShort(),f=a.readUByte(),g=a.readVector(f,this.numFrames,0);this.dataList.push({kind:d,type:f,blockSize:SEA3D.Stream.sizeOf(f),data:g})}};SEA3D.Animation.POSITION=0;SEA3D.Animation.ROTATION=1;SEA3D.Animation.SCALE=2;SEA3D.Animation.COLOR=3;SEA3D.Animation.MULTIPLIER=4;SEA3D.Animation.ATTENUATION_START=5;SEA3D.Animation.ATTENUATION_END=6;SEA3D.Animation.FOV=7;
SEA3D.Animation.OFFSET_U=8;SEA3D.Animation.OFFSET_V=9;SEA3D.Animation.SCALE_U=10;SEA3D.Animation.SCALE_V=11;SEA3D.Animation.ANGLE=12;SEA3D.Animation.ALPHA=13;SEA3D.Animation.VOLUME=14;SEA3D.Animation.DefaultLerpFuncs=[SEA3D.Math.lerp3x,SEA3D.Math.lerpQuat4x,SEA3D.Math.lerp3x,SEA3D.Math.lerpColor1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerpAng1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x];
SEA3D.Animation.prototype=Object.create(SEA3D.AnimationBase.prototype);SEA3D.Animation.prototype.constructor=SEA3D.Animation;SEA3D.Animation.prototype.type="anm";SEA3D.SkeletonAnimation=function(b,a,c){SEA3D.AnimationBase.call(this,b,a,c);this.name=b;this.data=a;this.sea3d=c;this.numJoints=a.readUShort();this.raw=a.readFloatArray(this.numFrames*this.numJoints*7)};SEA3D.SkeletonAnimation.prototype.type="skla";
SEA3D.Morph=function(b,a,c){SEA3D.GeometryBase.call(this,b,a,c);b=0!=(this.attrib&2);c=0!=(this.attrib&4);var d=a.readUShort();this.node=[];for(var f=0;f<d;f++){var g=a.readUTF8Tiny(),h,e;b&&(h=a.readFloatArray(this.length));c&&(e=a.readFloatArray(this.length));this.node[f]={vertex:h,normal:e,name:g}}};SEA3D.Morph.prototype=Object.create(SEA3D.GeometryBase.prototype);SEA3D.Morph.prototype.constructor=SEA3D.Morph;SEA3D.Morph.prototype.type="mph";
SEA3D.VertexAnimation=function(b,a,c){SEA3D.AnimationBase.call(this,b,a,c);c=a.readUByte();this.isBig=0!=(c&1);a.readVInt=this.isBig?a.readUInt:a.readUShort;this.numVertex=a.readVInt();this.length=3*this.numVertex;b=0!=(c&2);c=0!=(c&4);this.frame=[];var d,f,g;for(d=0;d<this.numFrames;d++)b&&(f=a.readFloatArray(this.length)),c&&(g=a.readFloatArray(this.length)),this.frame[d]={vertex:f,normal:g}};SEA3D.VertexAnimation.prototype=Object.create(SEA3D.AnimationBase.prototype);
SEA3D.VertexAnimation.prototype.constructor=SEA3D.VertexAnimation;SEA3D.VertexAnimation.prototype.type="vtxa";SEA3D.Camera=function(b,a,c){SEA3D.Object3D.call(this,b,a,c);this.attrib&64&&(this.dof={distance:a.readFloat(),range:a.readFloat()});this.transform=a.readMatrix();this.fov=a.readFloat();a.readTags(this.readTag.bind(this))};SEA3D.Camera.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Camera.prototype.constructor=SEA3D.Camera;SEA3D.Camera.prototype.type="cam";
SEA3D.OrthographicCamera=function(b,a,c){SEA3D.Object3D.call(this,b,a,c);this.transform=a.readMatrix();this.height=a.readFloat();a.readTags(this.readTag.bind(this))};SEA3D.OrthographicCamera.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.OrthographicCamera.prototype.constructor=SEA3D.OrthographicCamera;SEA3D.OrthographicCamera.prototype.type="camo";SEA3D.JointObject=function(b,a,c){SEA3D.Object3D.call(this,b,a,c);this.target=c.getObject(a.readUInt());this.joint=a.readUShort();a.readTags(this.readTag.bind(this))};
SEA3D.JointObject.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.JointObject.prototype.constructor=SEA3D.JointObject;SEA3D.JointObject.prototype.type="jnt";
SEA3D.Light=function(b,a,c){SEA3D.Object3D.call(this,b,a,c);this.attenEnd=this.attenStart=Number.MAX_VALUE;this.attrib&64&&(b=a.readUByte(),this.shadow={},this.shadow.opacity=b&1?a.readFloat():1,this.shadow.color=b&2?a.readUInt24():0);this.attrib&512&&(this.attenStart=a.readFloat(),this.attenEnd=a.readFloat());this.color=a.readUInt24();this.multiplier=a.readFloat()};SEA3D.Light.prototype=Object.create(SEA3D.Object3D.prototype);SEA3D.Light.prototype.constructor=SEA3D.Light;
SEA3D.PointLight=function(b,a,c){SEA3D.Light.call(this,b,a,c);this.attrib&128&&(this.attenuation={start:a.readFloat(),end:a.readFloat()});this.position=a.readVector3();a.readTags(this.readTag.bind(this))};SEA3D.PointLight.prototype=Object.create(SEA3D.Light.prototype);SEA3D.PointLight.prototype.constructor=SEA3D.PointLight;SEA3D.PointLight.prototype.type="plht";
SEA3D.HemisphereLight=function(b,a,c){SEA3D.Light.call(this,b,a,c);this.attrib&128&&(this.attenuation={start:a.readFloat(),end:a.readFloat()});this.secondColor=a.readUInt24();a.readTags(this.readTag.bind(this))};SEA3D.HemisphereLight.prototype=Object.create(SEA3D.Light.prototype);SEA3D.HemisphereLight.prototype.constructor=SEA3D.HemisphereLight;SEA3D.HemisphereLight.prototype.type="hlht";SEA3D.AmbientLight=function(b,a,c){SEA3D.Light.call(this,b,a,c);a.readTags(this.readTag.bind(this))};
SEA3D.AmbientLight.prototype=Object.create(SEA3D.Light.prototype);SEA3D.AmbientLight.prototype.constructor=SEA3D.AmbientLight;SEA3D.AmbientLight.prototype.type="alht";SEA3D.DirectionalLight=function(b,a,c){SEA3D.Light.call(this,b,a,c);this.transform=a.readMatrix();a.readTags(this.readTag.bind(this))};SEA3D.DirectionalLight.prototype=Object.create(SEA3D.Light.prototype);SEA3D.DirectionalLight.prototype.constructor=SEA3D.DirectionalLight;SEA3D.DirectionalLight.prototype.type="dlht";
SEA3D.Material=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.technique=[];this.tecniquesDict={};this.attrib=a.readUShort();this.alpha=1;this.blendMode="normal";this.anisotropy=this.physical=!1;this.bothSides=0!=(this.attrib&1);this.receiveLights=0==(this.attrib&2);this.receiveShadows=0==(this.attrib&4);this.receiveFog=0==(this.attrib&8);this.repeat=0==(this.attrib&16);this.attrib&32&&(this.alpha=a.readFloat());this.attrib&64&&(this.blendMode=a.readBlendMode());this.attrib&128&&(this.animations=
a.readAnimationList(c));this.depthWrite=0==(this.attrib&256);this.depthTest=0==(this.attrib&512);this.premultipliedAlpha=0!=(this.attrib&1024);b=a.readUByte();for(var d=0;d<b;++d){var f=a.readUShort(),g=a.readUShort(),h=a.position,e,k;switch(f){case SEA3D.Material.PHONG:e={ambientColor:a.readUInt24(),diffuseColor:a.readUInt24(),specularColor:a.readUInt24(),specular:a.readFloat(),gloss:a.readFloat()};break;case SEA3D.Material.PHYSICAL:e={color:a.readUInt24(),roughness:a.readFloat(),metalness:a.readFloat()};
break;case SEA3D.Material.ANISOTROPIC:break;case SEA3D.Material.COMPOSITE_TEXTURE:e={composite:c.getObject(a.readUInt())};break;case SEA3D.Material.DIFFUSE_MAP:e={texture:c.getObject(a.readUInt())};break;case SEA3D.Material.SPECULAR_MAP:e={texture:c.getObject(a.readUInt())};break;case SEA3D.Material.NORMAL_MAP:e={texture:c.getObject(a.readUInt())};break;case SEA3D.Material.REFLECTION:case SEA3D.Material.FRESNEL_REFLECTION:e={texture:c.getObject(a.readUInt()),alpha:a.readFloat()};f==SEA3D.Material.FRESNEL_REFLECTION&&
(e.power=a.readFloat(),e.normal=a.readFloat());break;case SEA3D.Material.REFRACTION:e={texture:c.getObject(a.readUInt()),alpha:a.readFloat(),ior:a.readFloat()};break;case SEA3D.Material.RIM:e={color:a.readUInt24(),strength:a.readFloat(),power:a.readFloat(),blendMode:a.readBlendMode()};break;case SEA3D.Material.LIGHT_MAP:e={texture:c.getObject(a.readUInt()),channel:a.readUByte(),blendMode:a.readBlendMode()};break;case SEA3D.Material.DETAIL_MAP:e={texture:c.getObject(a.readUInt()),scale:a.readFloat(),
blendMode:a.readBlendMode()};break;case SEA3D.Material.CEL:e={color:a.readUInt24(),levels:a.readUByte(),size:a.readFloat(),specularCutOff:a.readFloat(),smoothness:a.readFloat()};break;case SEA3D.Material.TRANSLUCENT:e={translucency:a.readFloat(),scattering:a.readFloat()};break;case SEA3D.Material.BLEND_NORMAL_MAP:k=a.readUByte();e={texture:c.getObject(a.readUInt()),secondaryTexture:c.getObject(a.readUInt())};k&1?(e.offsetX0=a.readFloat(),e.offsetY0=a.readFloat(),e.offsetX1=a.readFloat(),e.offsetY1=
a.readFloat()):e.offsetX0=e.offsetY0=e.offsetX1=e.offsetY1=0;e.animate=k&2;break;case SEA3D.Material.MIRROR_REFLECTION:e={texture:c.getObject(a.readUInt()),alpha:a.readFloat()};break;case SEA3D.Material.AMBIENT_MAP:e={texture:c.getObject(a.readUInt())};break;case SEA3D.Material.ALPHA_MAP:e={texture:c.getObject(a.readUInt())};break;case SEA3D.Material.EMISSIVE:e={color:a.readUInt24()};break;case SEA3D.Material.EMISSIVE_MAP:e={texture:c.getObject(a.readUInt())};break;case SEA3D.Material.ROUGHNESS_MAP:case SEA3D.Material.METALNESS_MAP:e=
{texture:c.getObject(a.readUInt())};break;case SEA3D.Material.VERTEX_COLOR:e={blendMode:a.readBlendMode()};break;case SEA3D.Material.WRAP_LIGHTING:e={color:a.readUInt24(),strength:a.readFloat()};break;case SEA3D.Material.COLOR_REPLACE:k=a.readUByte();e={red:a.readUInt24(),green:a.readUInt24(),blue:a.readUInt24F()};k&1&&(e.mask=c.getObject(a.readUInt()));k&2&&(e.alpha=a.readFloat());break;case SEA3D.Material.REFLECTION_SPHERICAL:e={texture:c.getObject(a.readUInt()),alpha:a.readFloat()};break;case SEA3D.Material.REFLECTIVITY:k=
a.readUByte();e={strength:a.readFloat()};k&1&&(e.mask=c.getObject(a.readUInt()));break;case SEA3D.Material.CLEAR_COAT:e={strength:a.readFloat(),roughness:a.readFloat()};break;default:console.warn("SEA3D: MaterialTechnique not found:",f.toString(16));a.position=h+g;continue}e.kind=f;this.technique.push(e);this.tecniquesDict[f]=e;a.position=h+g}};SEA3D.Material.PHONG=0;SEA3D.Material.COMPOSITE_TEXTURE=1;SEA3D.Material.DIFFUSE_MAP=2;SEA3D.Material.SPECULAR_MAP=3;SEA3D.Material.REFLECTION=4;
SEA3D.Material.REFRACTION=5;SEA3D.Material.NORMAL_MAP=6;SEA3D.Material.FRESNEL_REFLECTION=7;SEA3D.Material.RIM=8;SEA3D.Material.LIGHT_MAP=9;SEA3D.Material.DETAIL_MAP=10;SEA3D.Material.CEL=11;SEA3D.Material.TRANSLUCENT=12;SEA3D.Material.BLEND_NORMAL_MAP=13;SEA3D.Material.MIRROR_REFLECTION=14;SEA3D.Material.AMBIENT_MAP=15;SEA3D.Material.ALPHA_MAP=16;SEA3D.Material.EMISSIVE_MAP=17;SEA3D.Material.VERTEX_COLOR=18;SEA3D.Material.WRAP_LIGHTING=19;SEA3D.Material.COLOR_REPLACE=20;
SEA3D.Material.REFLECTION_SPHERICAL=21;SEA3D.Material.ANISOTROPIC=22;SEA3D.Material.EMISSIVE=23;SEA3D.Material.PHYSICAL=24;SEA3D.Material.ROUGHNESS_MAP=25;SEA3D.Material.METALNESS_MAP=26;SEA3D.Material.REFLECTIVITY=27;SEA3D.Material.CLEAR_COAT=28;SEA3D.Material.prototype.type="mat";SEA3D.Composite=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;b=a.readUByte();this.layer=[];for(var d=0;d<b;d++)this.layer[d]=new SEA3D.Composite.prototype.Layer(a,c)};
SEA3D.Composite.prototype.getLayerByName=function(b){for(var a=0;a<this.layer.length;a++)if(this.layer[a].name==b)return this.layer[a]};SEA3D.Composite.prototype.Layer=function(b,a){var c=b.readUShort();c&1?this.texture=new SEA3D.Composite.LayerBitmap(b,a):this.color=b.readUInt24();c&2&&(this.mask=new SEA3D.Composite.LayerBitmap(b,a));c&4&&(this.name=b.readUTF8Tiny());this.blendMode=c&8?b.readBlendMode():"normal";this.opacity=c&16?b.readFloat():1};
SEA3D.Composite.LayerBitmap=function(b,a){this.map=a.getObject(b.readUInt());var c=b.readUShort();this.channel=c&1?b.readUByte():0;this.repeat=c&0;this.offsetU=c&4?b.readFloat():0;this.offsetV=c&8?b.readFloat():0;this.scaleU=c&16?b.readFloat():1;this.scaleV=c&32?b.readFloat():1;this.rotation=c&64?b.readFloat():0;c&128&&(this.animation=b.readAnimationList(a))};SEA3D.Composite.prototype.type="ctex";
SEA3D.PlanarRender=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.attrib=a.readUByte();this.quality=this.attrib&1|this.attrib&2;this.transform=a.readMatrix()};SEA3D.PlanarRender.prototype.type="rttp";SEA3D.CubeRender=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.attrib=a.readUByte();this.quality=this.attrib&1|this.attrib&2;this.position=a.readVector3()};SEA3D.CubeRender.prototype.type="rttc";
SEA3D.CubeMap=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.transparent=!1;a.readExt();this.faces=[];for(b=0;6>b;b++)c=a.readUInt(),this.faces[b]=a.concat(a.position,c),a.position+=c};SEA3D.CubeMap.prototype.type="cmap";SEA3D.JPEG=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.transparent=!1};SEA3D.JPEG.prototype.type="jpg";SEA3D.JPEG_XR=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.transparent=!0};SEA3D.JPEG_XR.prototype.type="wdp";
SEA3D.PNG=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.transparent=6==a.getByte(25)};SEA3D.PNG.prototype.type="png";SEA3D.GIF=function(b,a,c){this.name=b;this.data=a;this.sea3d=c;this.transparent=0<a.getByte(11)};SEA3D.GIF.prototype.type="gif";SEA3D.OGG=function(b,a,c){this.name=b;this.data=a;this.sea3d=c};SEA3D.OGG.prototype.type="ogg";SEA3D.MP3=function(b,a,c){this.name=b;this.data=a;this.sea3d=c};SEA3D.MP3.prototype.type="mp3";
SEA3D.File=function(b){this.config={streaming:!0,timeLimit:60};b&&(void 0!==b.streaming&&(this.config.streaming=b.streaming),void 0!==b.timeLimit&&(this.config.timeLimit=b.timeLimit));this.version=SEA3D.VERSION;this.objects=[];this.typeClass={};this.typeRead={};this.typeUnique={};this.position=this.dataPosition=0;this.scope=this;this.addClass(SEA3D.FileInfo,!0);this.addClass(SEA3D.Geometry,!0);this.addClass(SEA3D.Mesh);this.addClass(SEA3D.Sprite);this.addClass(SEA3D.Material);this.addClass(SEA3D.Composite);
this.addClass(SEA3D.PointLight);this.addClass(SEA3D.DirectionalLight);this.addClass(SEA3D.HemisphereLight);this.addClass(SEA3D.AmbientLight);this.addClass(SEA3D.Skeleton,!0);this.addClass(SEA3D.SkeletonLocal,!0);this.addClass(SEA3D.SkeletonAnimation,!0);this.addClass(SEA3D.JointObject);this.addClass(SEA3D.Camera);this.addClass(SEA3D.OrthographicCamera);this.addClass(SEA3D.Morph,!0);this.addClass(SEA3D.VertexAnimation,!0);this.addClass(SEA3D.CubeMap,!0);this.addClass(SEA3D.Animation);this.addClass(SEA3D.Dummy);
this.addClass(SEA3D.Line);this.addClass(SEA3D.SoundPoint);this.addClass(SEA3D.PlanarRender);this.addClass(SEA3D.CubeRender);this.addClass(SEA3D.Actions);this.addClass(SEA3D.Container3D);this.addClass(SEA3D.Properties);this.addClass(SEA3D.ScriptURL,!0);this.addClass(SEA3D.TextureURL,!0);this.addClass(SEA3D.CubeMapURL,!0);this.addClass(SEA3D.JPEG,!0);this.addClass(SEA3D.JPEG_XR,!0);this.addClass(SEA3D.PNG,!0);this.addClass(SEA3D.GIF,!0);this.addClass(SEA3D.OGG,!0);this.addClass(SEA3D.MP3,!0);this.addClass(SEA3D.JavaScript,
!0);this.addClass(SEA3D.JavaScriptMethod,!0);this.addClass(SEA3D.GLSL,!0);for(b=SEA3D.File.Extensions.length;b--;)SEA3D.File.Extensions[b].call(this)};SEA3D.File.Extensions=[];SEA3D.File.CompressionLibs={};SEA3D.File.DecompressionMethod={};SEA3D.File.setExtension=function(b){SEA3D.File.Extensions.push(b)};SEA3D.File.setDecompressionEngine=function(b,a,c){SEA3D.File.CompressionLibs[b]=a;SEA3D.File.DecompressionMethod[b]=c};
SEA3D.File.prototype.addClass=function(b,a){this.typeClass[b.prototype.type]=b;this.typeUnique[b.prototype.type]=!0===a};
SEA3D.File.prototype.readHead=function(){if(16>this.stream.bytesAvailable)return!1;if("SEA"!=this.stream.readUTF8(3))throw Error("Invalid SEA3D format.");this.sign=this.stream.readUTF8(3);this.version=this.stream.readUInt24();if(0!=this.stream.readUByte())throw Error("Protection algorithm not compatible.");this.compressionID=this.stream.readUByte();this.compressionAlgorithm=SEA3D.File.CompressionLibs[this.compressionID];this.decompressionMethod=SEA3D.File.DecompressionMethod[this.compressionID];if(0<
this.compressionID&&!this.decompressionMethod)throw Error("Compression algorithm not compatible.");this.length=this.stream.readUInt();this.dataPosition=this.stream.position;this.objects.length=0;this.state=this.readBody;if(this.onHead)this.onHead({file:this,sign:this.sign});return!0};SEA3D.File.prototype.getObject=function(b){return this.objects[b]};SEA3D.File.prototype.getObjectByName=function(b){return this.objects[b]};
SEA3D.File.prototype.readSEAObject=function(){if(4>this.stream.bytesAvailable)return null;var b=this.stream.readUInt(),a=this.stream.position;if(this.stream.bytesAvailable<b)return null;var c=this.stream.readUByte(),d=this.stream.readExt(),f=null,g=c&1?this.stream.readUTF8Tiny():"",h=0!=(c&2),e=0!=(c&4);c&8&&(f=this.stream.readUShort(),c=this.stream.concat(this.stream.position,f),this.stream.position+=f,h&&this.decompressionMethod&&(c.buffer=this.decompressionMethod(c.buffer)),f=c.readProperties(this));
b-=this.stream.position-a;a=this.stream.position;c=this.stream.concat(a,b);this.typeClass[d]?(h&&this.decompressionMethod&&(c.buffer=this.decompressionMethod(c.buffer)),h=new this.typeClass[d](g,c,this),(this.config.streaming&&e||this.config.forceStreaming)&&this.typeRead[d]&&this.typeRead[d].call(this.scope,h)):(h=new SEA3D.Object(g,c,d,this),console.warn('SEA3D: Unknown format "'+d+'" of file "'+g+'". Add a module referring for this format.'));h.streaming=e;h.metadata=f;this.objects.push(this.objects[h.name+
"."+h.type]=h);this.dataPosition=a+b;++this.position;return h};SEA3D.File.prototype.isDone=function(){return this.position==this.length};SEA3D.File.prototype.readBody=function(){this.timer.update();if(!this.resume)return!1;for(;this.position<this.length;)if(this.timer.deltaTime<this.config.timeLimit){this.stream.position=this.dataPosition;var b=this.readSEAObject();if(b)this.dispatchCompleteObject(b);else return!1}else return!1;this.state=this.readComplete;return!0};
SEA3D.File.prototype.initParse=function(){this.timer=new SEA3D.Timer;this.position=0;this.resume=!0};SEA3D.File.prototype.parse=function(){this.initParse();isFinite(this.config.timeLimit)?setTimeout(this.parseObject.bind(this),10):this.parseObject()};
SEA3D.File.prototype.parseObject=function(){for(this.timer.update();this.position<this.length&&this.timer.deltaTime<this.config.timeLimit;){var b=this.objects[this.position++],a=b.type;this.typeUnique[a]||delete b.tag;(b.streaming||this.config.forceStreaming)&&this.typeRead[a]&&void 0==b.tag&&this.typeRead[a].call(this.scope,b)}if(this.position==this.length)if(b=this.timer.elapsedTime,a=b+"ms, "+this.objects.length+" objects",this.onParseComplete)this.onParseComplete({file:this,timeTotal:b,message:a});
else console.log("SEA3D Parse Complete:",a);else{if(this.onParseProgress)this.onParseProgress({file:this,loaded:this.position,total:this.length});setTimeout(this.parseObject.bind(this),10)}};SEA3D.File.prototype.readComplete=function(){this.stream.position=this.dataPosition;6202321!=this.stream.readUInt24F()&&console.warn("SEA3D file is corrupted.");delete this.state;return!1};
SEA3D.File.prototype.readState=function(){for(;this.state(););this.state?(requestAnimationFrame(this.readState.bind(this)),this.dispatchProgress()):this.dispatchComplete()};SEA3D.File.prototype.read=function(b){if(!b)throw Error("No data found.");this.initParse();this.stream=new SEA3D.Stream(b);this.state=this.readHead;this.readState()};SEA3D.File.prototype.dispatchCompleteObject=function(b){if(this.onCompleteObject)this.onCompleteObject({file:this,object:b})};
SEA3D.File.prototype.dispatchProgress=function(){if(this.onProgress)this.onProgress({file:this,loaded:this.position,total:this.length})};SEA3D.File.prototype.dispatchDownloadProgress=function(b,a){if(this.onDownloadProgress)this.onDownloadProgress({file:this,loaded:b,total:a})};SEA3D.File.prototype.dispatchComplete=function(){var b=this.timer.elapsedTime,a=b+"ms, "+this.objects.length+" objects";if(this.onComplete)this.onComplete({file:this,timeTotal:b,message:a});else console.log("SEA3D:",a)};
SEA3D.File.prototype.dispatchError=function(b,a){if(this.onError)this.onError({file:this,id:b,message:a});else console.error("SEA3D: #"+b,a)};
SEA3D.File.prototype.load=function(b){var a=this,c=new XMLHttpRequest;c.open("GET",b,!0);c.responseType="arraybuffer";c.onprogress=function(b){b.lengthComputable&&a.dispatchDownloadProgress(b.loaded,b.total)};c.onreadystatechange=function(){2!==c.readyState&&3!==c.readyState&&4===c.readyState&&(200===c.status||0===c.status?a.read(this.response):this.dispatchError(1001,"Couldn't load ["+b+"] ["+c.status+"]"))};c.send()};