THREE.MMDLoader=function(a){THREE.Loader.call(this);this.manager=void 0!==a?a:THREE.DefaultLoadingManager;this.parser=new MMDParser.Parser;this.textureCrossOrigin=null};THREE.MMDLoader.prototype=Object.create(THREE.Loader.prototype);THREE.MMDLoader.prototype.constructor=THREE.MMDLoader;THREE.MMDLoader.prototype.defaultToonTextures="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAL0lEQVRYR+3QQREAAAzCsOFfNJPBJ1XQS9r2hsUAAQIECBAgQIAAAQIECBAgsBZ4MUx/ofm2I/kAAAAASUVORK5CYII\x3d data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAN0lEQVRYR+3WQREAMBACsZ5/bWiiMvgEBTt5cW37hjsBBAgQIECAwFwgyfYPCCBAgAABAgTWAh8aBHZBl14e8wAAAABJRU5ErkJggg\x3d\x3d data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAOUlEQVRYR+3WMREAMAwDsYY/yoDI7MLwIiP40+RJklfcCCBAgAABAgTqArfb/QMCCBAgQIAAgbbAB3z/e0F3js2cAAAAAElFTkSuQmCC data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAN0lEQVRYR+3WQREAMBACsZ5/B5ilMvgEBTt5cW37hjsBBAgQIECAwFwgyfYPCCBAgAABAgTWAh81dWyx0gFwKAAAAABJRU5ErkJggg\x3d\x3d data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAOklEQVRYR+3WoREAMAwDsWb/UQtCy9wxTOQJ/oQ8SXKKGwEECBAgQIBAXeDt7f4BAQQIECBAgEBb4AOz8Hzx7WLY4wAAAABJRU5ErkJggg\x3d\x3d data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAABPUlEQVRYR+1XwW7CMAy1+f9fZOMysSEOEweEOPRNdm3HbdOyIhAcklPrOs/PLy9RygBALxzcCDQFmgJNgaZAU6Ap0BR4PwX8gsRMVLssMRH5HcpzJEaWL7EVg9F1IHRlyqQohgVr4FGUlUcMJSjcUlDw0zvjeun70cLWmneoyf7NgBTQSniBTQQSuJAZsOnnaczjIMb5hCiuHKxokCrJfVnrctyZL0PkJAJe1HMil4nxeyi3Ypfn1kX51jpPvo/JeCNC4PhVdHdJw2XjBR8brF8PEIhNVn12AgP7uHsTBguBn53MUZCqv7Lp07Pn5k1Ro+uWmUNn7D+M57rtk7aG0Vo73xyF/fbFf0bPJjDXngnGocDTdFhygZjwUQrMNrDcmZlQT50VJ/g/UwNyHpu778+yW+/ksOz/BFo54P4AsUXMfRq7XWsAAAAASUVORK5CYII\x3d data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAACMElEQVRYR+2Xv4pTQRTGf2dubhLdICiii2KnYKHVolhauKWPoGAnNr6BD6CvIVaihYuI2i1ia0BY0MZGRHQXjZj/mSPnnskfNWiWZUlzJ5k7M2cm833nO5Mziej2DWWJRUoCpQKlAntSQCqgw39/iUWAGmh37jrRnVsKlgpiqmkoGVABA7E57fvY+pJDdgKqF6HzFCSADkDq+F6AHABtQ+UMVE5D7zXod7fFNhTEckTbj5XQgHzNN+5tQvc5NG7C6BNkp6D3EmpXHDR+dQAjFLchW3VS9rlw3JBh+B7ys5Cf9z0GW1C/7P32AyBAOAz1q4jGliIH3YPuBnSfQX4OGreTIgEYQb/pBDtPnEQ4CivXYPAWBk13oHrB54yA9QuSn2H4AcKRpEILDt0BUzj+RLR1V5EqjD66NPRBVpLcQwjHoHYJOhsQv6U4mnzmrIXJCFr4LDwm/xBUoboG9XX4cc9VKdYoSA2yk5NQLJaKDUjTBoveG3Z2TElTxwjNK4M3LEZgUdDdruvcXzKBpStgp2NPiWi3ks9ZXxIoFVi+AvHLdc9TqtjL3/aYjpPlrzOcEnK62Szhimdd7xX232zFDTgtxezOu3WNMRLjiKgjtOhHVMd1loynVHvOgjuIIJMaELEqhJAV/RCSLbWTcfPFakFgFlALTRRvx+ok6Hlp/Q+v3fmx90bMyUzaEAhmM3KvHlXTL5DxnbGf/1M8RNNACLL5MNtPxP/mypJAqcDSFfgFhpYqWUzhTEAAAAAASUVORK5CYII\x3d data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAL0lEQVRYR+3QQREAAAzCsOFfNJPBJ1XQS9r2hsUAAQIECBAgQIAAAQIECBAgsBZ4MUx/ofm2I/kAAAAASUVORK5CYII\x3d data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAL0lEQVRYR+3QQREAAAzCsOFfNJPBJ1XQS9r2hsUAAQIECBAgQIAAAQIECBAgsBZ4MUx/ofm2I/kAAAAASUVORK5CYII\x3d data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAL0lEQVRYR+3QQREAAAzCsOFfNJPBJ1XQS9r2hsUAAQIECBAgQIAAAQIECBAgsBZ4MUx/ofm2I/kAAAAASUVORK5CYII\x3d data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAL0lEQVRYR+3QQREAAAzCsOFfNJPBJ1XQS9r2hsUAAQIECBAgQIAAAQIECBAgsBZ4MUx/ofm2I/kAAAAASUVORK5CYII\x3d".split(" ");
THREE.MMDLoader.prototype.setTextureCrossOrigin=function(a){this.textureCrossOrigin=a};THREE.MMDLoader.prototype.load=function(a,b,c,d,f){var e=this;this.loadModel(a,function(a){e.loadVmds(b,function(b){e.pourVmdIntoModel(a,b);c(a)},d,f)},d,f)};THREE.MMDLoader.prototype.loadModel=function(a,b,c,d){var f=this,e=this.extractUrlBase(a),g=this.extractExtension(a);this.loadFileAsBuffer(a,function(a){b(f.createModel(a,g,e,c,d))},c,d)};
THREE.MMDLoader.prototype.createModel=function(a,b,c,d,f){return this.createMesh(this.parseModel(a,b),c,d,f)};THREE.MMDLoader.prototype.loadVmd=function(a,b,c,d){var f=this;this.loadFileAsBuffer(a,function(a){b(f.parseVmd(a))},c,d)};THREE.MMDLoader.prototype.loadVmds=function(a,b,c,d){function f(){var k=a.shift();e.loadVmd(k,function(c){g.push(c);0<a.length?f():b(e.mergeVmds(g))},c,d)}var e=this,g=[];a=a.slice();f()};
THREE.MMDLoader.prototype.loadAudio=function(a,b,c,d){var f=new THREE.AudioListener,e=new THREE.Audio(f);(new THREE.AudioLoader(this.manager)).load(a,function(a){e.setBuffer(a);b(e,f)},c,d)};THREE.MMDLoader.prototype.loadVpd=function(a,b,c,d,f){var e=this;(f&&"unicode"===f.charcode?this.loadFileAsText:this.loadFileAsShiftJISText).bind(this)(a,function(a){b(e.parseVpd(a))},c,d)};
THREE.MMDLoader.prototype.parseModel=function(a,b){switch(b.toLowerCase()){case "pmd":return this.parsePmd(a);case "pmx":return this.parsePmx(a);default:throw"extension "+b+" is not supported.";}};THREE.MMDLoader.prototype.parsePmd=function(a){return this.parser.parsePmd(a,!0)};THREE.MMDLoader.prototype.parsePmx=function(a){return this.parser.parsePmx(a,!0)};THREE.MMDLoader.prototype.parseVmd=function(a){return this.parser.parseVmd(a,!0)};
THREE.MMDLoader.prototype.parseVpd=function(a){return this.parser.parseVpd(a,!0)};THREE.MMDLoader.prototype.mergeVmds=function(a){return this.parser.mergeVmds(a)};THREE.MMDLoader.prototype.pourVmdIntoModel=function(a,b,c){this.createAnimation(a,b,c)};
THREE.MMDLoader.prototype.pourVmdIntoCamera=function(a,b,c){var d=new THREE.MMDLoader.DataCreationHelper;(function(){for(var f=d.createOrderedMotionArray(b.cameras),e=[],g=[],k=[],n=[],p=[],r=[],t=[],w=[],C=[],A=new THREE.Quaternion,y=new THREE.Euler,q=new THREE.Vector3,D=new THREE.Vector3,B=function(a,b){a.push(b.x);a.push(b.y);a.push(b.z)},u=function(a,b){a.push(b.x);a.push(b.y);a.push(b.z);a.push(b.w)},h=function(a,b,c){a.push(b[4*c+0]/127);a.push(b[4*c+1]/127);a.push(b[4*c+2]/127);a.push(b[4*
c+3]/127)},E=function(a,b,c,e,d){if(2<c.length){c=c.slice();e=e.slice();d=d.slice();for(var f=e.length/c.length,l=3===f?12:4,h=1,y=2,A=c.length;y<A;y++){for(var q=0;q<f;q++)if(e[h*f+q]!==e[(h-1)*f+q]||e[h*f+q]!==e[y*f+q]){h++;break}if(y>h){c[h]=c[y];for(q=0;q<f;q++)e[h*f+q]=e[y*f+q];for(q=0;q<l;q++)d[h*l+q]=d[y*l+q]}}c.length=h+1;e.length=(h+1)*f;d.length=(h+1)*l}return new THREE.MMDLoader[b](a,c,e,d)},x=0;x<f.length;x++){var l=f[x],m=l.frameNum/30,v=l.position,G=l.rotation,z=l.fov,F=l.interpolation;
q.set(0,0,-l.distance);D.set(v[0],v[1],v[2]);y.set(-G[0],-G[1],-G[2]);A.setFromEuler(y);q.add(D);q.applyQuaternion(A);0<e.length&&m<e[e.length-1]+1/30*1.5&&(e[e.length-1]=m-1E-13);e.push(m);B(g,D);u(k,A);B(n,q);p.push(z);for(l=0;3>l;l++)h(r,F,l);h(t,F,3);for(l=0;3>l;l++)h(w,F,4);h(C,F,5)}0!==e.length&&(f=[],f.push(E(".center","VectorKeyframeTrackEx",e,g,r)),f.push(E(".quaternion","QuaternionKeyframeTrackEx",e,k,t)),f.push(E(".position","VectorKeyframeTrackEx",e,n,w)),f.push(E(".fov","NumberKeyframeTrackEx",
e,p,C)),e=new THREE.AnimationClip(void 0===c?THREE.Math.generateUUID():c,-1,f),void 0===a.center&&(a.center=new THREE.Vector3(0,0,0)),void 0===a.animations&&(a.animations=[]),a.animations.push(e))})()};THREE.MMDLoader.prototype.extractExtension=function(a){var b=a.lastIndexOf(".");return 0>b?null:a.slice(b+1)};THREE.MMDLoader.prototype.loadFile=function(a,b,c,d,f,e){var g=new THREE.FileLoader(this.manager);void 0!==e&&g.setMimeType(e);g.setResponseType(f);return g.load(a,function(a){b(a)},c,d)};
THREE.MMDLoader.prototype.loadFileAsBuffer=function(a,b,c,d){this.loadFile(a,b,c,d,"arraybuffer")};THREE.MMDLoader.prototype.loadFileAsText=function(a,b,c,d){this.loadFile(a,b,c,d,"text")};THREE.MMDLoader.prototype.loadFileAsShiftJISText=function(a,b,c,d){this.loadFile(a,b,c,d,"text","text/plain; charset\x3dshift_jis")};
THREE.MMDLoader.prototype.createMesh=function(a,b,c,d){var f=this,e=new THREE.BufferGeometry,g=[];new THREE.MMDLoader.DataCreationHelper;var k,n,p,r,t,w;k=[];n=[];p=[];r=[];t=[];w=[];(function(){for(var b=0;b<a.metadata.vertexCount;b++){for(var c=a.vertices[b],e=0,f=c.position.length;e<f;e++)k.push(c.position[e]);e=0;for(f=c.normal.length;e<f;e++)p.push(c.normal[e]);e=0;for(f=c.uv.length;e<f;e++)n.push(c.uv[e]);for(e=0;4>e;e++)r.push(c.skinIndices.length-1>=e?c.skinIndices[e]:0);for(e=0;4>e;e++)t.push(c.skinWeights.length-
1>=e?c.skinWeights[e]:0)}})();(function(){for(var b=0;b<a.metadata.faceCount;b++)for(var c=a.faces[b],e=0,f=c.indices.length;e<f;e++)w.push(c.indices[e])})();(function(){for(var b=[],c=a.rigidBodies,f={},d=0,g=c.length;d<g;d++){var k=c[d],u=f[k.boneIndex],u=void 0===u?k.type:Math.max(k.type,u);f[k.boneIndex]=u}for(d=0;d<a.metadata.boneCount;d++)c={},g=a.bones[d],c.parent=g.parentIndex,c.name=g.name,c.pos=[g.position[0],g.position[1],g.position[2]],c.rotq=[0,0,0,1],c.scl=[1,1,1],-1!==c.parent&&(c.pos[0]-=
a.bones[c.parent].position[0],c.pos[1]-=a.bones[c.parent].position[1],c.pos[2]-=a.bones[c.parent].position[2]),c.rigidBodyType=void 0!==f[d]?f[d]:-1,b.push(c);e.bones=b})();(function(){var c=[];if("pmd"===a.metadata.format)for(var b=0;b<a.metadata.ikCount;b++){var f=a.iks[b],d={};d.target=f.target;d.effector=f.effector;d.iteration=f.iteration;d.maxAngle=4*f.maxAngle;d.links=[];for(var g=0;g<f.links.length;g++){var k={};k.index=f.links[g].index;0<=a.bones[k.index].name.indexOf("ひざ")&&(k.limitation=
new THREE.Vector3(1,0,0));d.links.push(k)}c.push(d)}else for(b=0;b<a.metadata.boneCount;b++)if(f=a.bones[b].ik,void 0!==f){d={};d.target=b;d.effector=f.effector;d.iteration=f.iteration;d.maxAngle=f.maxAngle;d.links=[];for(g=0;g<f.links.length;g++)k={},k.index=f.links[g].index,k.enabled=!0,1===f.links[g].angleLimitation&&(k.limitation=new THREE.Vector3(1,0,0)),d.links.push(k);c.push(d)}e.iks=c})();(function(){if("pmd"!==a.metadata.format){for(var b=[],c=0;c<a.metadata.boneCount;c++){var f=a.bones[c],
d=f.grant;if(void 0!==d){var g={};g.index=c;g.parentIndex=d.parentIndex;g.ratio=d.ratio;g.isLocal=d.isLocal;g.affectRotation=d.affectRotation;g.affectPosition=d.affectPosition;g.transformationClass=f.transformationClass;b.push(g)}}b.sort(function(a,b){return a.transformationClass-b.transformationClass});e.grants=b}})();(function(){function b(c,e,d){for(var f=0;f<e.elementCount;f++){var g=e.elements[f],h=c,k="pmd"===a.metadata.format?a.morphs[0].elements[g.index].index:g.index,q=d;h.array[3*k+0]+=
g.position[0]*q;h.array[3*k+1]+=g.position[1]*q;h.array[3*k+2]+=g.position[2]*q}}for(var c=[],f=[],d=0;d<a.metadata.morphCount;d++){var g=a.morphs[d],p={name:g.name},u=new THREE.Float32BufferAttribute(3*a.metadata.vertexCount,3);u.name=g.name;for(var h=0;h<3*a.metadata.vertexCount;h++)u.array[h]=k[h];if("pmd"===a.metadata.format)0!==d&&b(u,g,1);else if(0===g.type)for(h=0;h<g.elementCount;h++){var n=a.morphs[g.elements[h].index],r=g.elements[h].ratio;1===n.type&&b(u,n,r)}else 1===g.type&&b(u,g,1);
c.push(p);f.push(u)}e.morphTargets=c;e.morphAttributes.position=f})();(function(){function k(a,e){void 0===e&&(e={});var g;if(!0===e.defaultTexturePath)try{g=f.defaultToonTextures[parseInt(a.match("toon([0-9]{2}).bmp$")[1])]}catch(h){console.warn("THREE.MMDLoader: "+a+" seems like not right default texture path. Using toon00.bmp instead."),g=f.defaultToonTextures[0]}else g=b+a;if(void 0!==n[g])return g;var l=THREE.Loader.Handlers.get(g);null===l&&(l=0<=a.indexOf(".tga")?r:q);var m=l.load(g,function(a){if(!0===
e.isToonTexture){var b=a.image,c=b.width,f=b.height;B.width=c;B.height=f;u.clearRect(0,0,c,f);u.translate(c/2,f/2);u.rotate(.5*Math.PI);u.translate(-c/2,-f/2);u.drawImage(b,0,0);a.image=u.getImageData(0,0,c,f)}a.flipY=!1;a.wrapS=THREE.RepeatWrapping;a.wrapT=THREE.RepeatWrapping;for(a=0;a<m.readyCallbacks.length;a++)m.readyCallbacks[a](m);delete m.readyCallbacks},c,d);!0===e.sphericalReflectionMapping&&(m.mapping=THREE.SphericalReflectionMapping);m.readyCallbacks=[];n[g]=m;return g}function p(a,b){void 0===
b[a]&&console.warn("THREE.MMDLoader: Undefined texture",a);return b[a]}var n={},q=new THREE.TextureLoader(f.manager),r=new THREE.TGALoader(f.manager),B=document.createElement("canvas"),u=B.getContext("2d"),h=0,t=[];null!==f.textureCrossOrigin&&q.setCrossOrigin(f.textureCrossOrigin);for(var x=0;x<a.metadata.materialCount;x++){var l=a.materials[x],m={};m.faceOffset=h;m.faceNum=l.faceCount;h+=l.faceCount;m.name=l.name;m.color=new THREE.Color(l.diffuse[0],l.diffuse[1],l.diffuse[2]);m.opacity=l.diffuse[3];
m.specular=new THREE.Color(l.specular[0],l.specular[1],l.specular[2]);m.shininess=l.shininess;1===m.opacity?(m.side=THREE.FrontSide,m.transparent=!1):(m.side=THREE.DoubleSide,m.transparent=!0);if("pmd"===a.metadata.format){if(l.fileName){var v=l.fileName,w=[],z=v.lastIndexOf("*");0<=z?(w.push(v.slice(0,z)),w.push(v.slice(z+1))):w.push(v);for(v=0;v<w.length;v++)z=w[v],0<=z.indexOf(".sph")||0<=z.indexOf(".spa")?(m.envMap=k(z,{sphericalReflectionMapping:!0}),0<=z.indexOf(".sph")?m.envMapType=THREE.MultiplyOperation:
m.envMapType=THREE.AddOperation):m.map=k(z)}}else-1!==l.textureIndex&&(z=a.textures[l.textureIndex],m.map=k(z)),-1===l.envTextureIndex||1!==l.envFlag&&2!=l.envFlag||(z=a.textures[l.envTextureIndex],m.envMap=k(z,{sphericalReflectionMapping:!0}),m.envMapType=1===l.envFlag?THREE.MultiplyOperation:THREE.AddOperation);v=void 0===m.map?1:.2;m.emissive=new THREE.Color(l.ambient[0]*v,l.ambient[1]*v,l.ambient[2]*v);t.push(m)}for(x=0;x<t.length;x++){h=t[x];m=a.materials[x];l=new THREE.MeshToonMaterial;e.addGroup(3*
h.faceOffset,3*h.faceNum,x);void 0!==h.name&&(l.name=h.name);l.skinning=0<e.bones.length?!0:!1;l.morphTargets=0<e.morphTargets.length?!0:!1;l.lights=!0;l.side="pmx"===a.metadata.format&&1===(m.flag&1)?THREE.DoubleSide:h.side;l.transparent=h.transparent;l.fog=!0;l.blending=THREE.CustomBlending;l.blendSrc=THREE.SrcAlphaFactor;l.blendDst=THREE.OneMinusSrcAlphaFactor;l.blendSrcAlpha=THREE.SrcAlphaFactor;l.blendDstAlpha=THREE.DstAlphaFactor;void 0!==h.map&&(l.faceOffset=h.faceOffset,l.faceNum=h.faceNum,
l.map=p(h.map,n),function(a){a.map.readyCallbacks.push(function(b){function c(a){var b=document.createElement("canvas");b.width=a.width;b.height=a.height;var e=b.getContext("2d");e.drawImage(a,0,0);return e.getImageData(0,0,b.width,b.height)}function f(a,b){var c=a.width,e=a.height,d=Math.round(b.x*c)%c,g=Math.round(b.y*e)%e;0>d&&(d+=c);0>g&&(g+=e);return a.data[4*(g*c+d)+3]}b=void 0!==b.image.data?b.image:c(b.image);var d=e.index.array.slice(3*a.faceOffset,3*a.faceOffset+3*a.faceNum);(function(a,
b,c){if(4!==a.data.length/(a.width*a.height))return!1;for(var e=0;e<c.length;e+=3){for(var d={x:0,y:0},g=0;3>g;g++){var h=c[3*e+g],h={x:b[2*h+0],y:b[2*h+1]};if(253>f(a,h))return!0;d.x+=h.x;d.y+=h.y}d.x/=3;d.y/=3;if(253>f(a,d))return!0}return!1})(b,e.attributes.uv.array,d)&&(a.transparent=!0);delete a.faceOffset;delete a.faceNum})}(l));void 0!==h.envMap&&(l.envMap=p(h.envMap,n),l.combine=h.envMapType);l.opacity=h.opacity;l.color=h.color;void 0!==h.emissive&&(l.emissive=h.emissive);l.specular=h.specular;
l.shininess=Math.max(h.shininess,1E-4);if("pmd"===a.metadata.format)l.outlineParameters={thickness:1===m.edgeFlag?.003:0,color:new THREE.Color(0,0,0),alpha:1},0===l.outlineParameters.thickness&&(l.outlineParameters.visible=!1),m=h=-1===m.toonIndex?"toon00.bmp":a.toonTextures[m.toonIndex].fileName,h=10!==h.length?!1:null===h.match(/toon(10|0[0-9]).bmp/)?!1:!0,h=k(m,{isToonTexture:!0,defaultTexturePath:h});else{l.outlineParameters={thickness:m.edgeSize/300,color:new THREE.Color(m.edgeColor[0],m.edgeColor[1],
m.edgeColor[2]),alpha:m.edgeColor[3]};if(0===(m.flag&16)||0===l.outlineParameters.thickness)l.outlineParameters.visible=!1;-1===m.toonIndex||0!==m.toonFlag?(h=m.toonIndex+1,h="toon"+(10>h?"0"+h:h)+".bmp",m=!0):(h=a.textures[m.toonIndex],m=!1);h=k(h,{isToonTexture:!0,defaultTexturePath:m})}l.gradientMap=p(h,n);g.push(l)}if("pmx"===a.metadata.format)for(t=function(a,b){if(8===a.type)for(var c=0;c<b.length;c++){var e=b[c];if(-1!==e.index){var d=g[e.index];d.opacity!==e.diffuse[3]&&(d.transparent=!0)}}},
x=0;x<a.morphs.length;x++)if(h=a.morphs[x],l=h.elements,0===h.type)for(v=0;v<l.length;v++)h=a.morphs[l[v].index],t(h,h.elements);else t(h,l)})();(function(){for(var b=[],c=[],d=0;d<a.metadata.rigidBodyCount;d++){for(var f=a.rigidBodies[d],g=Object.keys(f),k={},n=0;n<g.length;n++){var h=g[n];k[h]=f[h]}"pmx"===a.metadata.format&&-1!==k.boneIndex&&(g=a.bones[k.boneIndex],k.position[0]-=g.position[0],k.position[1]-=g.position[1],k.position[2]-=g.position[2]);b.push(k)}for(d=0;d<a.metadata.constraintCount;d++){f=
a.constraints[d];g=Object.keys(f);k={};for(n=0;n<g.length;n++)h=g[n],k[h]=f[h];g=b[k.rigidBodyIndex1];n=b[k.rigidBodyIndex2];0!==g.type&&2===n.type&&-1!==g.boneIndex&&-1!==n.boneIndex&&a.bones[n.boneIndex].parentIndex===g.boneIndex&&(n.type=1);c.push(k)}e.rigidBodies=b;e.constraints=c})();e.setIndex(w);e.addAttribute("position",new THREE.Float32BufferAttribute(k,3));e.addAttribute("normal",new THREE.Float32BufferAttribute(p,3));e.addAttribute("uv",new THREE.Float32BufferAttribute(n,2));e.addAttribute("skinIndex",
new THREE.Float32BufferAttribute(r,4));e.addAttribute("skinWeight",new THREE.Float32BufferAttribute(t,4));e.computeBoundingSphere();e.mmdFormat=a.metadata.format;return new THREE.SkinnedMesh(e,g)};
THREE.MMDLoader.prototype.createAnimation=function(a,b,c){var d=new THREE.MMDLoader.DataCreationHelper;(function(){if(0!==b.metadata.motionCount){for(var f=a.geometry.bones,e=d.createOrderedMotionArrays(f,b.motions,"boneName"),g=[],k=function(a,b,c){a.push(b[c+0]/127);a.push(b[c+8]/127);a.push(b[c+4]/127);a.push(b[c+12]/127)},n=0;n<e.length;n++){for(var p=[],r=[],t=[],w=[],C=[],A=f[n],y=e[n],q=0;q<y.length;q++){var D=y[q].position,B=y[q].rotation,u=y[q].interpolation;p.push(y[q].frameNum/30);for(var h=
0;3>h;h++)r.push(A.pos[h]+D[h]);for(h=0;4>h;h++)t.push(B[h]);for(h=0;3>h;h++)k(w,u,h);k(C,u,3)}0!==p.length&&(A=".bones["+A.name+"]",g.push(new THREE.MMDLoader.VectorKeyframeTrackEx(A+".position",p,r,w)),g.push(new THREE.MMDLoader.QuaternionKeyframeTrackEx(A+".quaternion",p,t,C)))}f=new THREE.AnimationClip(void 0===c?THREE.Math.generateUUID():c,-1,g);void 0===a.geometry.animations&&(a.geometry.animations=[]);a.geometry.animations.push(f)}})();(function(){if(0!==b.metadata.morphCount){for(var f=d.createOrderedMotionArrays(a.geometry.morphTargets,
b.morphs,"morphName"),e=[],g=0;g<f.length;g++){for(var k=[],n=[],p=f[g],r=0;r<p.length;r++)k.push(p[r].frameNum/30),n.push(p[r].weight);0!==k.length&&e.push(new THREE.NumberKeyframeTrack(".morphTargetInfluences["+g+"]",k,n))}f=new THREE.AnimationClip(void 0===c?THREE.Math.generateUUID():c+"Morph",-1,e);void 0===a.geometry.animations&&(a.geometry.animations=[]);a.geometry.animations.push(f)}})()};THREE.MMDLoader.DataCreationHelper=function(){};
THREE.MMDLoader.DataCreationHelper.prototype={constructor:THREE.MMDLoader.DataCreationHelper,toCharcodeStrings:function(a){for(var b="",c=0;c<a.length;c++)b+="0x"+("0000"+a[c].charCodeAt().toString(16)).substr(-4);return b},createDictionary:function(a){for(var b={},c=0;c<a.length;c++)b[a[c].name]=c;return b},initializeMotionArrays:function(a){for(var b=[],c=0;c<a.length;c++)b[c]=[];return b},sortMotionArray:function(a){a.sort(function(a,c){return a.frameNum-c.frameNum})},sortMotionArrays:function(a){for(var b=
0;b<a.length;b++)this.sortMotionArray(a[b])},createMotionArray:function(a){for(var b=[],c=0;c<a.length;c++)b.push(a[c]);return b},createMotionArrays:function(a,b,c,d){for(var f=0;f<a.length;f++){var e=a[f],g=c[e[d]];void 0!==g&&b[g].push(e)}},createOrderedMotionArray:function(a){a=this.createMotionArray(a);this.sortMotionArray(a);return a},createOrderedMotionArrays:function(a,b,c){var d=this.createDictionary(a);a=this.initializeMotionArrays(a);this.createMotionArrays(b,a,d,c);this.sortMotionArrays(a);
return a}};THREE.MMDLoader.VectorKeyframeTrackEx=function(a,b,c,d){this.interpolationParameters=new Float32Array(d);THREE.VectorKeyframeTrack.call(this,a,b,c)};THREE.MMDLoader.VectorKeyframeTrackEx.prototype=Object.create(THREE.VectorKeyframeTrack.prototype);THREE.MMDLoader.VectorKeyframeTrackEx.prototype.constructor=THREE.MMDLoader.VectorKeyframeTrackEx;THREE.MMDLoader.VectorKeyframeTrackEx.prototype.TimeBufferType=Float64Array;
THREE.MMDLoader.VectorKeyframeTrackEx.prototype.InterpolantFactoryMethodCubicBezier=function(a){return new THREE.MMDLoader.CubicBezierInterpolation(this.times,this.values,this.getValueSize(),a,this.interpolationParameters)};THREE.MMDLoader.VectorKeyframeTrackEx.prototype.setInterpolation=function(a){this.createInterpolant=this.InterpolantFactoryMethodCubicBezier};
THREE.MMDLoader.QuaternionKeyframeTrackEx=function(a,b,c,d){this.interpolationParameters=new Float32Array(d);THREE.QuaternionKeyframeTrack.call(this,a,b,c)};THREE.MMDLoader.QuaternionKeyframeTrackEx.prototype=Object.create(THREE.QuaternionKeyframeTrack.prototype);THREE.MMDLoader.QuaternionKeyframeTrackEx.prototype.constructor=THREE.MMDLoader.QuaternionKeyframeTrackEx;THREE.MMDLoader.QuaternionKeyframeTrackEx.prototype.TimeBufferType=Float64Array;
THREE.MMDLoader.QuaternionKeyframeTrackEx.prototype.InterpolantFactoryMethodCubicBezier=function(a){return new THREE.MMDLoader.CubicBezierInterpolation(this.times,this.values,this.getValueSize(),a,this.interpolationParameters)};THREE.MMDLoader.QuaternionKeyframeTrackEx.prototype.setInterpolation=function(a){this.createInterpolant=this.InterpolantFactoryMethodCubicBezier};
THREE.MMDLoader.NumberKeyframeTrackEx=function(a,b,c,d){this.interpolationParameters=new Float32Array(d);THREE.NumberKeyframeTrack.call(this,a,b,c)};THREE.MMDLoader.NumberKeyframeTrackEx.prototype=Object.create(THREE.NumberKeyframeTrack.prototype);THREE.MMDLoader.NumberKeyframeTrackEx.prototype.constructor=THREE.MMDLoader.NumberKeyframeTrackEx;THREE.MMDLoader.NumberKeyframeTrackEx.prototype.TimeBufferType=Float64Array;
THREE.MMDLoader.NumberKeyframeTrackEx.prototype.InterpolantFactoryMethodCubicBezier=function(a){return new THREE.MMDLoader.CubicBezierInterpolation(this.times,this.values,this.getValueSize(),a,this.interpolationParameters)};THREE.MMDLoader.NumberKeyframeTrackEx.prototype.setInterpolation=function(a){this.createInterpolant=this.InterpolantFactoryMethodCubicBezier};THREE.MMDLoader.CubicBezierInterpolation=function(a,b,c,d,f){THREE.Interpolant.call(this,a,b,c,d);this.params=f};
THREE.MMDLoader.CubicBezierInterpolation.prototype=Object.create(THREE.LinearInterpolant.prototype);THREE.MMDLoader.CubicBezierInterpolation.prototype.constructor=THREE.MMDLoader.CubicBezierInterpolation;
THREE.MMDLoader.CubicBezierInterpolation.prototype.interpolate_=function(a,b,c,d){var f=this.resultBuffer,e=this.sampleValues,g=this.valueSize,k=a*g,n=k-g;b=(c-b)/(d-b);if(4===g){d=this.params[4*a+0];var p=this.params[4*a+1],r=this.params[4*a+2],t=this.params[4*a+3];d=this._calculate(d,p,r,t,b);THREE.Quaternion.slerpFlat(f,0,e,n,e,k,d)}else if(3===g)for(c=0;c!==g;++c)d=this.params[12*a+4*c+0],p=this.params[12*a+4*c+1],r=this.params[12*a+4*c+2],t=this.params[12*a+4*c+3],d=this._calculate(d,p,r,t,b),
f[c]=e[n+c]*(1-d)+e[k+c]*d;else d=this.params[4*a+0],p=this.params[4*a+1],r=this.params[4*a+2],t=this.params[4*a+3],d=this._calculate(d,p,r,t,b),f[0]=e[n]*(1-d)+e[k]*d;return f};THREE.MMDLoader.CubicBezierInterpolation.prototype._calculate=function(a,b,c,d,f){for(var e=.5,g=e,k=1-g,n=Math,p,r,t,w=0;15>w;w++){p=3*k*k*g;r=3*k*g*g;t=g*g*g;k=p*a+r*b+t-f;if(1E-5>n.abs(k))break;e/=2;g+=0>k?e:-e;k=1-g}return p*c+r*d+t};
THREE.MMDAudioManager=function(a,b,c){c=null===c||void 0===c?{}:c;this.audio=a;this.listener=b;this.currentTime=this.elapsedTime=0;this.delayTime=void 0!==c.delayTime?c.delayTime:0;this.audioDuration=this.audio.buffer.duration;this.duration=this.audioDuration+this.delayTime};
THREE.MMDAudioManager.prototype={constructor:THREE.MMDAudioManager,control:function(a){this.elapsed+=a;this.currentTime+=a;this.checkIfStopAudio()&&this.audio.stop();this.checkIfStartAudio()&&this.audio.play()},checkIfStartAudio:function(){if(this.audio.isPlaying)return!1;for(;this.currentTime>=this.duration;)this.currentTime-=this.duration;if(this.currentTime<this.delayTime)return!1;this.audio.startTime=this.currentTime-this.delayTime;return!0},checkIfStopAudio:function(){return this.audio.isPlaying?
this.currentTime>=this.duration?!0:!1:!1}};THREE.MMDGrantSolver=function(a){this.mesh=a};THREE.MMDGrantSolver.prototype={constructor:THREE.MMDGrantSolver,update:function(){var a=new THREE.Quaternion;return function(){for(var b=0;b<this.mesh.geometry.grants.length;b++){var c=this.mesh.geometry.grants[b],d=this.mesh.skeleton.bones[c.index],f=this.mesh.skeleton.bones[c.parentIndex];!c.isLocal&&c.affectRotation&&(a.set(0,0,0,1),a.slerp(f.quaternion,c.ratio),d.quaternion.multiply(a))}}}()};
THREE.MMDHelper=function(){this.meshes=[];this.doCameraAnimation=this.doPhysics=this.doGrant=this.doIk=this.doAnimation=!0;this.sharedPhysics=!1;this.camera=this.audioManager=this.masterPhysics=null};
THREE.MMDHelper.prototype={constructor:THREE.MMDHelper,add:function(a){if(!(a instanceof THREE.SkinnedMesh))throw Error("THREE.MMDHelper.add() accepts only THREE.SkinnedMesh instance.");void 0===a.mixer&&(a.mixer=null);void 0===a.ikSolver&&(a.ikSolver=null);void 0===a.grantSolver&&(a.grantSolver=null);void 0===a.physics&&(a.physics=null);void 0===a.looped&&(a.looped=!1);this.meshes.push(a);this.initBackupBones(a)},setAudio:function(a,b,c){this.audioManager=new THREE.MMDAudioManager(a,b,c)},setCamera:function(a){a.mixer=
null;this.camera=a},setPhysicses:function(a){for(var b=0;b<this.meshes.length;b++)this.setPhysics(this.meshes[b],a)},setPhysics:function(a,b){b=void 0===b?{}:Object.assign({},b);if(void 0===b.world&&this.sharedPhysics){var c=this.getMasterPhysics();null!==c&&(b.world=c.world)}var c=void 0!==b.warmup?b.warmup:60,d=new THREE.MMDPhysics(a,b);null!==a.mixer&&void 0!==a.mixer&&!0!==b.preventAnimationWarmup&&(this.animateOneMesh(0,a),d.reset());d.warmup(c);this.updateIKParametersDependingOnPhysicsEnabled(a,
!0);a.physics=d},getMasterPhysics:function(){if(null!==this.masterPhysics)return this.masterPhysics;for(var a=0,b=this.meshes.length;a<b;a++){var c=this.meshes[a].physics;if(void 0!==c&&null!==c)return this.masterPhysics=c}return null},enablePhysics:function(a){this.doPhysics=!0===a?!0:!1;for(var b=0,c=this.meshes.length;b<c;b++)this.updateIKParametersDependingOnPhysicsEnabled(this.meshes[b],a)},updateIKParametersDependingOnPhysicsEnabled:function(a,b){for(var c=a.geometry.iks,d=a.geometry.bones,
f=0,e=c.length;f<e;f++)for(var g=c[f].links,k=0,n=g.length;k<n;k++){var p=g[k];p.enabled=!0===b?0<d[p.index].rigidBodyType?!1:!0:!0}},setAnimations:function(){for(var a=0;a<this.meshes.length;a++)this.setAnimation(this.meshes[a])},setAnimation:function(a){if(void 0!==a.geometry.animations){a.mixer=new THREE.AnimationMixer(a);a.mixer.addEventListener("loop",function(a){0<a.action._clip.tracks.length&&0!==a.action._clip.tracks[0].name.indexOf(".bones")||(a.target._root.looped=!0)});for(var b=!1,c=!1,
d=0;d<a.geometry.animations.length;d++){var f=a.geometry.animations[d],e=a.mixer.clipAction(f);0<f.tracks.length&&0===f.tracks[0].name.indexOf(".morphTargetInfluences")?c||(e.play(),c=!0):b||(e.play(),b=!0)}b&&(a.ikSolver=new THREE.CCDIKSolver(a),void 0!==a.geometry.grants&&(a.grantSolver=new THREE.MMDGrantSolver(a)))}},setCameraAnimation:function(a){void 0!==a.animations&&(a.mixer=new THREE.AnimationMixer(a),a.mixer.clipAction(a.animations[0]).play())},unifyAnimationDuration:function(a){a=void 0===
a?{}:a;for(var b=0,c=this.camera,d=this.audioManager,f=0;f<this.meshes.length;f++){var e=this.meshes[f],e=e.mixer;if(null!==e)for(var g=0;g<e._actions.length;g++)var k=e._actions[g],b=Math.max(b,k._clip.duration)}if(null!==c&&null!==c.mixer)for(e=c.mixer,f=0;f<e._actions.length;f++)k=e._actions[f],b=Math.max(b,k._clip.duration);null!==d&&(b=Math.max(b,d.duration));void 0!==a.afterglow&&(b+=a.afterglow);for(f=0;f<this.meshes.length;f++)if(e=this.meshes[f],e=e.mixer,null!==e)for(g=0;g<e._actions.length;g++)k=
e._actions[g],k._clip.duration=b;if(null!==c&&null!==c.mixer)for(e=c.mixer,f=0;f<e._actions.length;f++)k=e._actions[f],k._clip.duration=b;null!==d&&(d.duration=b)},controlAudio:function(a){null!==this.audioManager&&this.audioManager.control(a)},animate:function(a){this.controlAudio(a);for(var b=0;b<this.meshes.length;b++)this.animateOneMesh(a,this.meshes[b]);this.sharedPhysics&&this.updateSharedPhysics(a);this.animateCamera(a)},animateOneMesh:function(a,b){var c=b.mixer,d=b.ikSolver,f=b.grantSolver,
e=b.physics;null!==c&&!0===this.doAnimation&&(this.restoreBones(b),c.update(a),this.backupBones(b));null!==d&&!0===this.doIk&&d.update();null!==f&&!0===this.doGrant&&f.update();!0===b.looped&&(null!==e&&e.reset(),b.looped=!1);null!==e&&this.doPhysics&&!this.sharedPhysics&&e.update(a)},updateSharedPhysics:function(a){if(0!==this.meshes.length&&this.doPhysics&&this.sharedPhysics){var b=this.getMasterPhysics();if(null!==b){for(var c=0,d=this.meshes.length;c<d;c++){var f=this.meshes[c].physics;null!==
f&&void 0!==f&&f.updateRigidBodies()}b.stepSimulation(a);c=0;for(d=this.meshes.length;c<d;c++)f=this.meshes[c].physics,null!==f&&void 0!==f&&f.updateBones()}}},animateCamera:function(a){if(null!==this.camera){var b=this.camera.mixer;null!==b&&void 0!==this.camera.center&&!0===this.doCameraAnimation&&(b.update(a),this.camera.updateProjectionMatrix(),this.camera.up.set(0,1,0),this.camera.up.applyQuaternion(this.camera.quaternion),this.camera.lookAt(this.camera.center))}},poseAsVpd:function(a,b,c){void 0===
c&&(c={});!0!==c.preventResetPose&&a.pose();var d=a.skeleton.bones;b=b.bones;for(var f={},e=0;e<d.length;e++)f[d[e].name]=e;for(var g=new THREE.Vector3,k=new THREE.Quaternion,e=0;e<b.length;e++){var n=b[e],p=f[n.name];if(void 0!==p){var p=d[p],r=n.translation,n=n.quaternion;g.set(r[0],r[1],r[2]);k.set(n[0],n[1],n[2],n[3]);p.position.add(g);p.quaternion.multiply(k)}}a.updateMatrixWorld(!0);!0!==c.preventIk&&(d=new THREE.CCDIKSolver(a),d.update(c.saveOriginalBonesBeforeIK));!0!==c.preventGrant&&void 0!==
a.geometry.grants&&(d=new THREE.MMDGrantSolver(a),d.update())},initBackupBones:function(a){a.skeleton.backupBones=[];for(var b=0;b<a.skeleton.bones.length;b++)a.skeleton.backupBones.push(a.skeleton.bones[b].clone())},backupBones:function(a){a.skeleton.backupBoneIsSaved=!0;for(var b=0;b<a.skeleton.bones.length;b++){var c=a.skeleton.backupBones[b],d=a.skeleton.bones[b];c.position.copy(d.position);c.quaternion.copy(d.quaternion)}},restoreBones:function(a){if(!0===a.skeleton.backupBoneIsSaved){a.skeleton.backupBoneIsSaved=
!1;for(var b=0;b<a.skeleton.bones.length;b++){var c=a.skeleton.bones[b],d=a.skeleton.backupBones[b];c.position.copy(d.position);c.quaternion.copy(d.quaternion)}}}};