THREE.Sky=function(){var a=THREE.Sky.SkyShader,b=THREE.UniformsUtils.clone(a.uniforms),a=new THREE.ShaderMaterial({fragmentShader:a.fragmentShader,vertexShader:a.vertexShader,uniforms:b,side:THREE.BackSide}),c=new THREE.SphereBufferGeometry(45E4,32,15);this.mesh=new THREE.Mesh(c,a);this.uniforms=b};
THREE.Sky.SkyShader={uniforms:{luminance:{value:1},turbidity:{value:2},rayleigh:{value:1},mieCoefficient:{value:.005},mieDirectionalG:{value:.8},sunPosition:{value:new THREE.Vector3}},vertexShader:"uniform vec3 sunPosition;\nuniform float rayleigh;\nuniform float turbidity;\nuniform float mieCoefficient;\nvarying vec3 vWorldPosition;\nvarying vec3 vSunDirection;\nvarying float vSunfade;\nvarying vec3 vBetaR;\nvarying vec3 vBetaM;\nvarying float vSunE;\nconst vec3 up \x3d vec3( 0.0, 1.0, 0.0 );\nconst float e \x3d 2.71828182845904523536028747135266249775724709369995957;\nconst float pi \x3d 3.141592653589793238462643383279502884197169;\nconst vec3 lambda \x3d vec3( 680E-9, 550E-9, 450E-9 );\nconst vec3 totalRayleigh \x3d vec3( 5.804542996261093E-6, 1.3562911419845635E-5, 3.0265902468824876E-5 );\nconst float v \x3d 4.0;\nconst vec3 K \x3d vec3( 0.686, 0.678, 0.666 );\nconst vec3 MieConst \x3d vec3( 1.8399918514433978E14, 2.7798023919660528E14, 4.0790479543861094E14 );\nconst float cutoffAngle \x3d 1.6110731556870734;\nconst float steepness \x3d 1.5;\nconst float EE \x3d 1000.0;\nfloat sunIntensity( float zenithAngleCos ) {\n\tzenithAngleCos \x3d clamp( zenithAngleCos, -1.0, 1.0 );\n\treturn EE * max( 0.0, 1.0 - pow( e, -( ( cutoffAngle - acos( zenithAngleCos ) ) / steepness ) ) );\n}\nvec3 totalMie( float T ) {\n\tfloat c \x3d ( 0.2 * T ) * 10E-18;\n\treturn 0.434 * c * MieConst;\n}\nvoid main() {\n\tvec4 worldPosition \x3d modelMatrix * vec4( position, 1.0 );\n\tvWorldPosition \x3d worldPosition.xyz;\n\tgl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n\tvSunDirection \x3d normalize( sunPosition );\n\tvSunE \x3d sunIntensity( dot( vSunDirection, up ) );\n\tvSunfade \x3d 1.0 - clamp( 1.0 - exp( ( sunPosition.y / 450000.0 ) ), 0.0, 1.0 );\n\tfloat rayleighCoefficient \x3d rayleigh - ( 1.0 * ( 1.0 - vSunfade ) );\n\tvBetaR \x3d totalRayleigh * rayleighCoefficient;\n\tvBetaM \x3d totalMie( turbidity ) * mieCoefficient;\n}",fragmentShader:"varying vec3 vWorldPosition;\nvarying vec3 vSunDirection;\nvarying float vSunfade;\nvarying vec3 vBetaR;\nvarying vec3 vBetaM;\nvarying float vSunE;\nuniform float luminance;\nuniform float mieDirectionalG;\nconst vec3 cameraPos \x3d vec3( 0.0, 0.0, 0.0 );\nconst float pi \x3d 3.141592653589793238462643383279502884197169;\nconst float n \x3d 1.0003;\nconst float N \x3d 2.545E25;\nconst float rayleighZenithLength \x3d 8.4E3;\nconst float mieZenithLength \x3d 1.25E3;\nconst vec3 up \x3d vec3( 0.0, 1.0, 0.0 );\nconst float sunAngularDiameterCos \x3d 0.999956676946448443553574619906976478926848692873900859324;\nconst float THREE_OVER_SIXTEENPI \x3d 0.05968310365946075;\nconst float ONE_OVER_FOURPI \x3d 0.07957747154594767;\nfloat rayleighPhase( float cosTheta ) {\n\treturn THREE_OVER_SIXTEENPI * ( 1.0 + pow( cosTheta, 2.0 ) );\n}\nfloat hgPhase( float cosTheta, float g ) {\n\tfloat g2 \x3d pow( g, 2.0 );\n\tfloat inverse \x3d 1.0 / pow( 1.0 - 2.0 * g * cosTheta + g2, 1.5 );\n\treturn ONE_OVER_FOURPI * ( ( 1.0 - g2 ) * inverse );\n}\nconst float A \x3d 0.15;\nconst float B \x3d 0.50;\nconst float C \x3d 0.10;\nconst float D \x3d 0.20;\nconst float E \x3d 0.02;\nconst float F \x3d 0.30;\nconst float whiteScale \x3d 1.0748724675633854;\nvec3 Uncharted2Tonemap( vec3 x ) {\n\treturn ( ( x * ( A * x + C * B ) + D * E ) / ( x * ( A * x + B ) + D * F ) ) - E / F;\n}\nvoid main() {\n\tfloat zenithAngle \x3d acos( max( 0.0, dot( up, normalize( vWorldPosition - cameraPos ) ) ) );\n\tfloat inverse \x3d 1.0 / ( cos( zenithAngle ) + 0.15 * pow( 93.885 - ( ( zenithAngle * 180.0 ) / pi ), -1.253 ) );\n\tfloat sR \x3d rayleighZenithLength * inverse;\n\tfloat sM \x3d mieZenithLength * inverse;\n\tvec3 Fex \x3d exp( -( vBetaR * sR + vBetaM * sM ) );\n\tfloat cosTheta \x3d dot( normalize( vWorldPosition - cameraPos ), vSunDirection );\n\tfloat rPhase \x3d rayleighPhase( cosTheta * 0.5 + 0.5 );\n\tvec3 betaRTheta \x3d vBetaR * rPhase;\n\tfloat mPhase \x3d hgPhase( cosTheta, mieDirectionalG );\n\tvec3 betaMTheta \x3d vBetaM * mPhase;\n\tvec3 Lin \x3d pow( vSunE * ( ( betaRTheta + betaMTheta ) / ( vBetaR + vBetaM ) ) * ( 1.0 - Fex ), vec3( 1.5 ) );\n\tLin *\x3d mix( vec3( 1.0 ), pow( vSunE * ( ( betaRTheta + betaMTheta ) / ( vBetaR + vBetaM ) ) * Fex, vec3( 1.0 / 2.0 ) ), clamp( pow( 1.0 - dot( up, vSunDirection ), 5.0 ), 0.0, 1.0 ) );\n\tvec3 direction \x3d normalize( vWorldPosition - cameraPos );\n\tfloat theta \x3d acos( direction.y ); // elevation --\x3e y-axis, [-pi/2, pi/2]\n\tfloat phi \x3d atan( direction.z, direction.x ); // azimuth --\x3e x-axis [-pi/2, pi/2]\n\tvec2 uv \x3d vec2( phi, theta ) / vec2( 2.0 * pi, pi ) + vec2( 0.5, 0.0 );\n\tvec3 L0 \x3d vec3( 0.1 ) * Fex;\n\tfloat sundisk \x3d smoothstep( sunAngularDiameterCos, sunAngularDiameterCos + 0.00002, cosTheta );\n\tL0 +\x3d ( vSunE * 19000.0 * Fex ) * sundisk;\n\tvec3 texColor \x3d ( Lin + L0 ) * 0.04 + vec3( 0.0, 0.0003, 0.00075 );\n\tvec3 curr \x3d Uncharted2Tonemap( ( log2( 2.0 / pow( luminance, 4.0 ) ) ) * texColor );\n\tvec3 color \x3d curr * whiteScale;\n\tvec3 retColor \x3d pow( color, vec3( 1.0 / ( 1.2 + ( 1.2 * vSunfade ) ) ) );\n\tgl_FragColor \x3d vec4( retColor, 1.0 );\n}"};