THREE.ShaderToon={toon1:{uniforms:{uDirLightPos:{value:new THREE.Vector3},uDirLightColor:{value:new THREE.Color(15658734)},uAmbientLightColor:{value:new THREE.Color(328965)},uBaseColor:{value:new THREE.Color(16777215)}},vertexShader:"varying vec3 vNormal;\nvarying vec3 vRefract;\nvoid main() {\nvec4 worldPosition \x3d modelMatrix * vec4( position, 1.0 );\nvec4 mvPosition \x3d modelViewMatrix * vec4( position, 1.0 );\nvec3 worldNormal \x3d normalize ( mat3( modelMatrix[0].xyz, modelMatrix[1].xyz, modelMatrix[2].xyz ) * normal );\nvNormal \x3d normalize( normalMatrix * normal );\nvec3 I \x3d worldPosition.xyz - cameraPosition;\nvRefract \x3d refract( normalize( I ), worldNormal, 1.02 );\ngl_Position \x3d projectionMatrix * mvPosition;\n}",
fragmentShader:"uniform vec3 uBaseColor;\nuniform vec3 uDirLightPos;\nuniform vec3 uDirLightColor;\nuniform vec3 uAmbientLightColor;\nvarying vec3 vNormal;\nvarying vec3 vRefract;\nvoid main() {\nfloat directionalLightWeighting \x3d max( dot( normalize( vNormal ), uDirLightPos ), 0.0);\nvec3 lightWeighting \x3d uAmbientLightColor + uDirLightColor * directionalLightWeighting;\nfloat intensity \x3d smoothstep( - 0.5, 1.0, pow( length(lightWeighting), 20.0 ) );\nintensity +\x3d length(lightWeighting) * 0.2;\nfloat cameraWeighting \x3d dot( normalize( vNormal ), vRefract );\nintensity +\x3d pow( 1.0 - length( cameraWeighting ), 6.0 );\nintensity \x3d intensity * 0.2 + 0.3;\nif ( intensity \x3c 0.50 ) {\ngl_FragColor \x3d vec4( 2.0 * intensity * uBaseColor, 1.0 );\n} else {\ngl_FragColor \x3d vec4( 1.0 - 2.0 * ( 1.0 - intensity ) * ( 1.0 - uBaseColor ), 1.0 );\n}\n}"},
toon2:{uniforms:{uDirLightPos:{value:new THREE.Vector3},uDirLightColor:{value:new THREE.Color(15658734)},uAmbientLightColor:{value:new THREE.Color(328965)},uBaseColor:{value:new THREE.Color(15658734)},uLineColor1:{value:new THREE.Color(8421504)},uLineColor2:{value:new THREE.Color(0)},uLineColor3:{value:new THREE.Color(0)},uLineColor4:{value:new THREE.Color(0)}},vertexShader:"varying vec3 vNormal;\nvoid main() {\ngl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\nvNormal \x3d normalize( normalMatrix * normal );\n}",
fragmentShader:"uniform vec3 uBaseColor;\nuniform vec3 uLineColor1;\nuniform vec3 uLineColor2;\nuniform vec3 uLineColor3;\nuniform vec3 uLineColor4;\nuniform vec3 uDirLightPos;\nuniform vec3 uDirLightColor;\nuniform vec3 uAmbientLightColor;\nvarying vec3 vNormal;\nvoid main() {\nfloat camera \x3d max( dot( normalize( vNormal ), vec3( 0.0, 0.0, 1.0 ) ), 0.4);\nfloat light \x3d max( dot( normalize( vNormal ), uDirLightPos ), 0.0);\ngl_FragColor \x3d vec4( uBaseColor, 1.0 );\nif ( length(uAmbientLightColor + uDirLightColor * light) \x3c 1.00 ) {\ngl_FragColor *\x3d vec4( uLineColor1, 1.0 );\n}\nif ( length(uAmbientLightColor + uDirLightColor * camera) \x3c 0.50 ) {\ngl_FragColor *\x3d vec4( uLineColor2, 1.0 );\n}\n}"},
hatching:{uniforms:{uDirLightPos:{value:new THREE.Vector3},uDirLightColor:{value:new THREE.Color(15658734)},uAmbientLightColor:{value:new THREE.Color(328965)},uBaseColor:{value:new THREE.Color(16777215)},uLineColor1:{value:new THREE.Color(0)},uLineColor2:{value:new THREE.Color(0)},uLineColor3:{value:new THREE.Color(0)},uLineColor4:{value:new THREE.Color(0)}},vertexShader:"varying vec3 vNormal;\nvoid main() {\ngl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\nvNormal \x3d normalize( normalMatrix * normal );\n}",
fragmentShader:"uniform vec3 uBaseColor;\nuniform vec3 uLineColor1;\nuniform vec3 uLineColor2;\nuniform vec3 uLineColor3;\nuniform vec3 uLineColor4;\nuniform vec3 uDirLightPos;\nuniform vec3 uDirLightColor;\nuniform vec3 uAmbientLightColor;\nvarying vec3 vNormal;\nvoid main() {\nfloat directionalLightWeighting \x3d max( dot( normalize(vNormal), uDirLightPos ), 0.0);\nvec3 lightWeighting \x3d uAmbientLightColor + uDirLightColor * directionalLightWeighting;\ngl_FragColor \x3d vec4( uBaseColor, 1.0 );\nif ( length(lightWeighting) \x3c 1.00 ) {\nif ( mod(gl_FragCoord.x + gl_FragCoord.y, 10.0) \x3d\x3d 0.0) {\ngl_FragColor \x3d vec4( uLineColor1, 1.0 );\n}\n}\nif ( length(lightWeighting) \x3c 0.75 ) {\nif (mod(gl_FragCoord.x - gl_FragCoord.y, 10.0) \x3d\x3d 0.0) {\ngl_FragColor \x3d vec4( uLineColor2, 1.0 );\n}\n}\nif ( length(lightWeighting) \x3c 0.50 ) {\nif (mod(gl_FragCoord.x + gl_FragCoord.y - 5.0, 10.0) \x3d\x3d 0.0) {\ngl_FragColor \x3d vec4( uLineColor3, 1.0 );\n}\n}\nif ( length(lightWeighting) \x3c 0.3465 ) {\nif (mod(gl_FragCoord.x - gl_FragCoord.y - 5.0, 10.0) \x3d\x3d 0.0) {\ngl_FragColor \x3d vec4( uLineColor4, 1.0 );\n}\n}\n}"},
dotted:{uniforms:{uDirLightPos:{value:new THREE.Vector3},uDirLightColor:{value:new THREE.Color(15658734)},uAmbientLightColor:{value:new THREE.Color(328965)},uBaseColor:{value:new THREE.Color(16777215)},uLineColor1:{value:new THREE.Color(0)}},vertexShader:"varying vec3 vNormal;\nvoid main() {\ngl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\nvNormal \x3d normalize( normalMatrix * normal );\n}",fragmentShader:"uniform vec3 uBaseColor;\nuniform vec3 uLineColor1;\nuniform vec3 uLineColor2;\nuniform vec3 uLineColor3;\nuniform vec3 uLineColor4;\nuniform vec3 uDirLightPos;\nuniform vec3 uDirLightColor;\nuniform vec3 uAmbientLightColor;\nvarying vec3 vNormal;\nvoid main() {\nfloat directionalLightWeighting \x3d max( dot( normalize(vNormal), uDirLightPos ), 0.0);\nvec3 lightWeighting \x3d uAmbientLightColor + uDirLightColor * directionalLightWeighting;\ngl_FragColor \x3d vec4( uBaseColor, 1.0 );\nif ( length(lightWeighting) \x3c 1.00 ) {\nif ( ( mod(gl_FragCoord.x, 4.001) + mod(gl_FragCoord.y, 4.0) ) \x3e 6.00 ) {\ngl_FragColor \x3d vec4( uLineColor1, 1.0 );\n}\n}\nif ( length(lightWeighting) \x3c 0.50 ) {\nif ( ( mod(gl_FragCoord.x + 2.0, 4.001) + mod(gl_FragCoord.y + 2.0, 4.0) ) \x3e 6.00 ) {\ngl_FragColor \x3d vec4( uLineColor1, 1.0 );\n}\n}\n}"}};