THREE.ShaderTerrain={terrain:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.fog,THREE.UniformsLib.lights,{enableDiffuse1:{value:0},enableDiffuse2:{value:0},enableSpecular:{value:0},enableReflection:{value:0},tDiffuse1:{value:null},tDiffuse2:{value:null},tDetail:{value:null},tNormal:{value:null},tSpecular:{value:null},tDisplacement:{value:null},uNormalScale:{value:1},uDisplacementBias:{value:0},uDisplacementScale:{value:1},diffuse:{value:new THREE.Color(15658734)},specular:{value:new THREE.Color(1118481)},
shininess:{value:30},opacity:{value:1},uRepeatBase:{value:new THREE.Vector2(1,1)},uRepeatOverlay:{value:new THREE.Vector2(1,1)},uOffset:{value:new THREE.Vector2(0,0)}}]),fragmentShader:["uniform vec3 diffuse;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\nuniform bool enableDiffuse1;\nuniform bool enableDiffuse2;\nuniform bool enableSpecular;\nuniform sampler2D tDiffuse1;\nuniform sampler2D tDiffuse2;\nuniform sampler2D tDetail;\nuniform sampler2D tNormal;\nuniform sampler2D tSpecular;\nuniform sampler2D tDisplacement;\nuniform float uNormalScale;\nuniform vec2 uRepeatOverlay;\nuniform vec2 uRepeatBase;\nuniform vec2 uOffset;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vViewPosition;",
THREE.ShaderChunk.common,THREE.ShaderChunk.bsdfs,THREE.ShaderChunk.lights_pars,THREE.ShaderChunk.shadowmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"float calcLightAttenuation( float lightDistance, float cutoffDistance, float decayExponent ) {\nif ( decayExponent \x3e 0.0 ) {\nreturn pow( saturate( - lightDistance / cutoffDistance + 1.0 ), decayExponent );\n}\nreturn 1.0;\n}\nvoid main() {\nvec3 outgoingLight \x3d vec3( 0.0 );\nvec4 diffuseColor \x3d vec4( diffuse, opacity );\nvec3 specularTex \x3d vec3( 1.0 );\nvec2 uvOverlay \x3d uRepeatOverlay * vUv + uOffset;\nvec2 uvBase \x3d uRepeatBase * vUv;\nvec3 normalTex \x3d texture2D( tDetail, uvOverlay ).xyz * 2.0 - 1.0;\nnormalTex.xy *\x3d uNormalScale;\nnormalTex \x3d normalize( normalTex );\nif( enableDiffuse1 \x26\x26 enableDiffuse2 ) {\nvec4 colDiffuse1 \x3d texture2D( tDiffuse1, uvOverlay );\nvec4 colDiffuse2 \x3d texture2D( tDiffuse2, uvOverlay );\ncolDiffuse1 \x3d GammaToLinear( colDiffuse1, float( GAMMA_FACTOR ) );\ncolDiffuse2 \x3d GammaToLinear( colDiffuse2, float( GAMMA_FACTOR ) );\ndiffuseColor *\x3d mix ( colDiffuse1, colDiffuse2, 1.0 - texture2D( tDisplacement, uvBase ) );\n } else if( enableDiffuse1 ) {\ndiffuseColor *\x3d texture2D( tDiffuse1, uvOverlay );\n} else if( enableDiffuse2 ) {\ndiffuseColor *\x3d texture2D( tDiffuse2, uvOverlay );\n}\nif( enableSpecular )\nspecularTex \x3d texture2D( tSpecular, uvOverlay ).xyz;\nmat3 tsb \x3d mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal \x3d tsb * normalTex;\nvec3 normal \x3d normalize( finalNormal );\nvec3 viewPosition \x3d normalize( vViewPosition );\nvec3 totalDiffuseLight \x3d vec3( 0.0 );\nvec3 totalSpecularLight \x3d vec3( 0.0 );\n#if NUM_POINT_LIGHTS \x3e 0\nfor ( int i \x3d 0; i \x3c NUM_POINT_LIGHTS; i ++ ) {\nvec3 lVector \x3d pointLights[ i ].position + vViewPosition.xyz;\nfloat attenuation \x3d calcLightAttenuation( length( lVector ), pointLights[ i ].distance, pointLights[ i ].decay );\nlVector \x3d normalize( lVector );\nvec3 pointHalfVector \x3d normalize( lVector + viewPosition );\nfloat pointDotNormalHalf \x3d max( dot( normal, pointHalfVector ), 0.0 );\nfloat pointDiffuseWeight \x3d max( dot( normal, lVector ), 0.0 );\nfloat pointSpecularWeight \x3d specularTex.r * max( pow( pointDotNormalHalf, shininess ), 0.0 );\ntotalDiffuseLight +\x3d attenuation * pointLights[ i ].color * pointDiffuseWeight;\ntotalSpecularLight +\x3d attenuation * pointLights[ i ].color * specular * pointSpecularWeight * pointDiffuseWeight;\n}\n#endif\n#if NUM_DIR_LIGHTS \x3e 0\nvec3 dirDiffuse \x3d vec3( 0.0 );\nvec3 dirSpecular \x3d vec3( 0.0 );\nfor( int i \x3d 0; i \x3c NUM_DIR_LIGHTS; i++ ) {\nvec3 dirVector \x3d directionalLights[ i ].direction;\nvec3 dirHalfVector \x3d normalize( dirVector + viewPosition );\nfloat dirDotNormalHalf \x3d max( dot( normal, dirHalfVector ), 0.0 );\nfloat dirDiffuseWeight \x3d max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight \x3d specularTex.r * max( pow( dirDotNormalHalf, shininess ), 0.0 );\ntotalDiffuseLight +\x3d directionalLights[ i ].color * dirDiffuseWeight;\ntotalSpecularLight +\x3d directionalLights[ i ].color * specular * dirSpecularWeight * dirDiffuseWeight;\n}\n#endif\n#if NUM_HEMI_LIGHTS \x3e 0\nvec3 hemiDiffuse  \x3d vec3( 0.0 );\nvec3 hemiSpecular \x3d vec3( 0.0 );\nfor( int i \x3d 0; i \x3c NUM_HEMI_LIGHTS; i ++ ) {\nvec3 lVector \x3d hemisphereLightDirection[ i ];\nfloat dotProduct \x3d dot( normal, lVector );\nfloat hemiDiffuseWeight \x3d 0.5 * dotProduct + 0.5;\ntotalDiffuseLight +\x3d mix( hemisphereLights[ i ].groundColor, hemisphereLights[ i ].skyColor, hemiDiffuseWeight );\nfloat hemiSpecularWeight \x3d 0.0;\nvec3 hemiHalfVectorSky \x3d normalize( lVector + viewPosition );\nfloat hemiDotNormalHalfSky \x3d 0.5 * dot( normal, hemiHalfVectorSky ) + 0.5;\nhemiSpecularWeight +\x3d specularTex.r * max( pow( hemiDotNormalHalfSky, shininess ), 0.0 );\nvec3 lVectorGround \x3d -lVector;\nvec3 hemiHalfVectorGround \x3d normalize( lVectorGround + viewPosition );\nfloat hemiDotNormalHalfGround \x3d 0.5 * dot( normal, hemiHalfVectorGround ) + 0.5;\nhemiSpecularWeight +\x3d specularTex.r * max( pow( hemiDotNormalHalfGround, shininess ), 0.0 );\ntotalSpecularLight +\x3d specular * mix( hemisphereLights[ i ].groundColor, hemisphereLights[ i ].skyColor, hemiDiffuseWeight ) * hemiSpecularWeight * hemiDiffuseWeight;\n}\n#endif\noutgoingLight +\x3d diffuseColor.xyz * ( totalDiffuseLight + ambientLightColor + totalSpecularLight );\ngl_FragColor \x3d vec4( outgoingLight, diffuseColor.a );",
THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["attribute vec4 tangent;\nuniform vec2 uRepeatBase;\nuniform sampler2D tNormal;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vViewPosition;",THREE.ShaderChunk.shadowmap_pars_vertex,THREE.ShaderChunk.fog_pars_vertex,"void main() {\nvNormal \x3d normalize( normalMatrix * normal );\nvTangent \x3d normalize( normalMatrix * tangent.xyz );\nvBinormal \x3d cross( vNormal, vTangent ) * tangent.w;\nvBinormal \x3d normalize( vBinormal );\nvUv \x3d uv;\nvec2 uvBase \x3d uv * uRepeatBase;\n#ifdef VERTEX_TEXTURES\nvec3 dv \x3d texture2D( tDisplacement, uvBase ).xyz;\nfloat df \x3d uDisplacementScale * dv.x + uDisplacementBias;\nvec3 displacedPosition \x3d normal * df + position;\nvec4 worldPosition \x3d modelMatrix * vec4( displacedPosition, 1.0 );\nvec4 mvPosition \x3d modelViewMatrix * vec4( displacedPosition, 1.0 );\n#else\nvec4 worldPosition \x3d modelMatrix * vec4( position, 1.0 );\nvec4 mvPosition \x3d modelViewMatrix * vec4( position, 1.0 );\n#endif\ngl_Position \x3d projectionMatrix * mvPosition;\nvViewPosition \x3d -mvPosition.xyz;\nvec3 normalTex \x3d texture2D( tNormal, uvBase ).xyz * 2.0 - 1.0;\nvNormal \x3d normalMatrix * normalTex;",
THREE.ShaderChunk.shadowmap_vertex,THREE.ShaderChunk.fog_vertex,"}"].join("\n")}};