THREE.ShaderSkin={skinSimple:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.fog,THREE.UniformsLib.lights,{enableBump:{value:0},enableSpecular:{value:0},tDiffuse:{value:null},tBeckmann:{value:null},diffuse:{value:new THREE.Color(15658734)},specular:{value:new THREE.Color(1118481)},opacity:{value:1},uRoughness:{value:.15},uSpecularBrightness:{value:.75},bumpMap:{value:null},bumpScale:{value:1},specularMap:{value:null},offsetRepeat:{value:new THREE.Vector4(0,0,1,1)},uWrapRGB:{value:new THREE.Vector3(.75,
.375,.1875)}}]),fragmentShader:["#define USE_BUMPMAP\nuniform bool enableBump;\nuniform bool enableSpecular;\nuniform vec3 diffuse;\nuniform vec3 specular;\nuniform float opacity;\nuniform float uRoughness;\nuniform float uSpecularBrightness;\nuniform vec3 uWrapRGB;\nuniform sampler2D tDiffuse;\nuniform sampler2D tBeckmann;\nuniform sampler2D specularMap;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vViewPosition;",THREE.ShaderChunk.common,THREE.ShaderChunk.bsdfs,THREE.ShaderChunk.packing,
THREE.ShaderChunk.lights_pars,THREE.ShaderChunk.shadowmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.bumpmap_pars_fragment,"float fresnelReflectance( vec3 H, vec3 V, float F0 ) {\nfloat base \x3d 1.0 - dot( V, H );\nfloat exponential \x3d pow( base, 5.0 );\nreturn exponential + F0 * ( 1.0 - exponential );\n}\nfloat KS_Skin_Specular( vec3 N,\nvec3 L,\nvec3 V,\nfloat m,\nfloat rho_s\n) {\nfloat result \x3d 0.0;\nfloat ndotl \x3d dot( N, L );\nif( ndotl \x3e 0.0 ) {\nvec3 h \x3d L + V;\nvec3 H \x3d normalize( h );\nfloat ndoth \x3d dot( N, H );\nfloat PH \x3d pow( 2.0 * texture2D( tBeckmann, vec2( ndoth, m ) ).x, 10.0 );\nfloat F \x3d fresnelReflectance( H, V, 0.028 );\nfloat frSpec \x3d max( PH * F / dot( h, h ), 0.0 );\nresult \x3d ndotl * rho_s * frSpec;\n}\nreturn result;\n}\nvoid main() {\nvec3 outgoingLight \x3d vec3( 0.0 );\nvec4 diffuseColor \x3d vec4( diffuse, opacity );\nvec4 colDiffuse \x3d texture2D( tDiffuse, vUv );\ncolDiffuse.rgb *\x3d colDiffuse.rgb;\ndiffuseColor \x3d diffuseColor * colDiffuse;\nvec3 normal \x3d normalize( vNormal );\nvec3 viewerDirection \x3d normalize( vViewPosition );\nfloat specularStrength;\nif ( enableSpecular ) {\nvec4 texelSpecular \x3d texture2D( specularMap, vUv );\nspecularStrength \x3d texelSpecular.r;\n} else {\nspecularStrength \x3d 1.0;\n}\n#ifdef USE_BUMPMAP\nif ( enableBump ) normal \x3d perturbNormalArb( -vViewPosition, normal, dHdxy_fwd() );\n#endif\nvec3 totalSpecularLight \x3d vec3( 0.0 );\nvec3 totalDiffuseLight \x3d vec3( 0.0 );\n#if NUM_POINT_LIGHTS \x3e 0\nfor ( int i \x3d 0; i \x3c NUM_POINT_LIGHTS; i ++ ) {\nvec3 lVector \x3d pointLights[ i ].position + vViewPosition.xyz;\nfloat attenuation \x3d calcLightAttenuation( length( lVector ), pointLights[ i ].distance, pointLights[ i ].decay );\nlVector \x3d normalize( lVector );\nfloat pointDiffuseWeightFull \x3d max( dot( normal, lVector ), 0.0 );\nfloat pointDiffuseWeightHalf \x3d max( 0.5 * dot( normal, lVector ) + 0.5, 0.0 );\nvec3 pointDiffuseWeight \x3d mix( vec3 ( pointDiffuseWeightFull ), vec3( pointDiffuseWeightHalf ), uWrapRGB );\nfloat pointSpecularWeight \x3d KS_Skin_Specular( normal, lVector, viewerDirection, uRoughness, uSpecularBrightness );\ntotalDiffuseLight +\x3d pointLight[ i ].color * ( pointDiffuseWeight * attenuation );\ntotalSpecularLight +\x3d pointLight[ i ].color * specular * ( pointSpecularWeight * specularStrength * attenuation );\n}\n#endif\n#if NUM_DIR_LIGHTS \x3e 0\nfor( int i \x3d 0; i \x3c NUM_DIR_LIGHTS; i++ ) {\nvec3 dirVector \x3d directionalLights[ i ].direction;\nfloat dirDiffuseWeightFull \x3d max( dot( normal, dirVector ), 0.0 );\nfloat dirDiffuseWeightHalf \x3d max( 0.5 * dot( normal, dirVector ) + 0.5, 0.0 );\nvec3 dirDiffuseWeight \x3d mix( vec3 ( dirDiffuseWeightFull ), vec3( dirDiffuseWeightHalf ), uWrapRGB );\nfloat dirSpecularWeight \x3d KS_Skin_Specular( normal, dirVector, viewerDirection, uRoughness, uSpecularBrightness );\ntotalDiffuseLight +\x3d directionalLights[ i ].color * dirDiffuseWeight;\ntotalSpecularLight +\x3d directionalLights[ i ].color * ( dirSpecularWeight * specularStrength );\n}\n#endif\n#if NUM_HEMI_LIGHTS \x3e 0\nfor ( int i \x3d 0; i \x3c NUM_HEMI_LIGHTS; i ++ ) {\nvec3 lVector \x3d hemisphereLightDirection[ i ];\nfloat dotProduct \x3d dot( normal, lVector );\nfloat hemiDiffuseWeight \x3d 0.5 * dotProduct + 0.5;\ntotalDiffuseLight +\x3d mix( hemisphereLightGroundColor[ i ], hemisphereLightSkyColor[ i ], hemiDiffuseWeight );\nfloat hemiSpecularWeight \x3d 0.0;\nhemiSpecularWeight +\x3d KS_Skin_Specular( normal, lVector, viewerDirection, uRoughness, uSpecularBrightness );\nvec3 lVectorGround \x3d -lVector;\nhemiSpecularWeight +\x3d KS_Skin_Specular( normal, lVectorGround, viewerDirection, uRoughness, uSpecularBrightness );\nvec3 hemiSpecularColor \x3d mix( hemisphereLightGroundColor[ i ], hemisphereLightSkyColor[ i ], hemiDiffuseWeight );\ntotalSpecularLight +\x3d hemiSpecularColor * specular * ( hemiSpecularWeight * specularStrength );\n}\n#endif\noutgoingLight +\x3d diffuseColor.xyz * ( totalDiffuseLight + ambientLightColor * diffuse ) + totalSpecularLight;\ngl_FragColor \x3d linearToOutputTexel( vec4( outgoingLight, diffuseColor.a ) );",
THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["uniform vec4 offsetRepeat;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vViewPosition;",THREE.ShaderChunk.common,THREE.ShaderChunk.lights_pars,THREE.ShaderChunk.shadowmap_pars_vertex,THREE.ShaderChunk.fog_pars_vertex,"void main() {\nvec4 mvPosition \x3d modelViewMatrix * vec4( position, 1.0 );\nvec4 worldPosition \x3d modelMatrix * vec4( position, 1.0 );\nvViewPosition \x3d -mvPosition.xyz;\nvNormal \x3d normalize( normalMatrix * normal );\nvUv \x3d uv * offsetRepeat.zw + offsetRepeat.xy;\ngl_Position \x3d projectionMatrix * mvPosition;",
THREE.ShaderChunk.shadowmap_vertex,THREE.ShaderChunk.fog_vertex,"}"].join("\n")},skin:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.fog,THREE.UniformsLib.lights,{passID:{value:0},tDiffuse:{value:null},tNormal:{value:null},tBlur1:{value:null},tBlur2:{value:null},tBlur3:{value:null},tBlur4:{value:null},tBeckmann:{value:null},uNormalScale:{value:1},diffuse:{value:new THREE.Color(15658734)},specular:{value:new THREE.Color(1118481)},opacity:{value:1},uRoughness:{value:.15},uSpecularBrightness:{value:.75}}]),
fragmentShader:["uniform vec3 diffuse;\nuniform vec3 specular;\nuniform float opacity;\nuniform float uRoughness;\nuniform float uSpecularBrightness;\nuniform int passID;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tBlur1;\nuniform sampler2D tBlur2;\nuniform sampler2D tBlur3;\nuniform sampler2D tBlur4;\nuniform sampler2D tBeckmann;\nuniform float uNormalScale;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vViewPosition;",THREE.ShaderChunk.common,THREE.ShaderChunk.lights_pars,
THREE.ShaderChunk.fog_pars_fragment,"float fresnelReflectance( vec3 H, vec3 V, float F0 ) {\nfloat base \x3d 1.0 - dot( V, H );\nfloat exponential \x3d pow( base, 5.0 );\nreturn exponential + F0 * ( 1.0 - exponential );\n}\nfloat KS_Skin_Specular( vec3 N,\nvec3 L,\nvec3 V,\nfloat m,\nfloat rho_s\n) {\nfloat result \x3d 0.0;\nfloat ndotl \x3d dot( N, L );\nif( ndotl \x3e 0.0 ) {\nvec3 h \x3d L + V;\nvec3 H \x3d normalize( h );\nfloat ndoth \x3d dot( N, H );\nfloat PH \x3d pow( 2.0 * texture2D( tBeckmann, vec2( ndoth, m ) ).x, 10.0 );\nfloat F \x3d fresnelReflectance( H, V, 0.028 );\nfloat frSpec \x3d max( PH * F / dot( h, h ), 0.0 );\nresult \x3d ndotl * rho_s * frSpec;\n}\nreturn result;\n}\nvoid main() {\nvec3 outgoingLight \x3d vec3( 0.0 );\nvec4 diffuseColor \x3d vec4( diffuse, opacity );\nvec4 mSpecular \x3d vec4( specular, opacity );\nvec4 colDiffuse \x3d texture2D( tDiffuse, vUv );\ncolDiffuse *\x3d colDiffuse;\ndiffuseColor *\x3d colDiffuse;\nvec4 posAndU \x3d vec4( -vViewPosition, vUv.x );\nvec4 posAndU_dx \x3d dFdx( posAndU ),  posAndU_dy \x3d dFdy( posAndU );\nvec3 tangent \x3d posAndU_dx.w * posAndU_dx.xyz + posAndU_dy.w * posAndU_dy.xyz;\nvec3 normal \x3d normalize( vNormal );\nvec3 binormal \x3d normalize( cross( tangent, normal ) );\ntangent \x3d cross( normal, binormal );\nmat3 tsb \x3d mat3( tangent, binormal, normal );\nvec3 normalTex \x3d texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *\x3d uNormalScale;\nnormalTex \x3d normalize( normalTex );\nvec3 finalNormal \x3d tsb * normalTex;\nnormal \x3d normalize( finalNormal );\nvec3 viewerDirection \x3d normalize( vViewPosition );\nvec3 totalDiffuseLight \x3d vec3( 0.0 );\nvec3 totalSpecularLight \x3d vec3( 0.0 );\n#if NUM_POINT_LIGHTS \x3e 0\nfor ( int i \x3d 0; i \x3c NUM_POINT_LIGHTS; i ++ ) {\nvec3 pointVector \x3d normalize( pointLights[ i ].direction );\nfloat attenuation \x3d calcLightAttenuation( length( lVector ), pointLights[ i ].distance, pointLights[ i ].decay );\nfloat pointDiffuseWeight \x3d max( dot( normal, pointVector ), 0.0 );\ntotalDiffuseLight +\x3d pointLightColor[ i ] * ( pointDiffuseWeight * attenuation );\nif ( passID \x3d\x3d 1 ) {\nfloat pointSpecularWeight \x3d KS_Skin_Specular( normal, pointVector, viewerDirection, uRoughness, uSpecularBrightness );\ntotalSpecularLight +\x3d pointLightColor[ i ] * mSpecular.xyz * ( pointSpecularWeight * attenuation );\n}\n}\n#endif\n#if NUM_DIR_LIGHTS \x3e 0\nfor( int i \x3d 0; i \x3c NUM_DIR_LIGHTS; i++ ) {\nvec3 dirVector \x3d directionalLights[ i ].direction;\nfloat dirDiffuseWeight \x3d max( dot( normal, dirVector ), 0.0 );\ntotalDiffuseLight +\x3d directionalLights[ i ].color * dirDiffuseWeight;\nif ( passID \x3d\x3d 1 ) {\nfloat dirSpecularWeight \x3d KS_Skin_Specular( normal, dirVector, viewerDirection, uRoughness, uSpecularBrightness );\ntotalSpecularLight +\x3d directionalLights[ i ].color * mSpecular.xyz * dirSpecularWeight;\n}\n}\n#endif\noutgoingLight +\x3d diffuseColor.rgb * ( totalDiffuseLight + totalSpecularLight );\nif ( passID \x3d\x3d 0 ) {\noutgoingLight \x3d sqrt( outgoingLight );\n} else if ( passID \x3d\x3d 1 ) {\n#ifdef VERSION1\nvec3 nonblurColor \x3d sqrt(outgoingLight );\n#else\nvec3 nonblurColor \x3d outgoingLight;\n#endif\nvec3 blur1Color \x3d texture2D( tBlur1, vUv ).xyz;\nvec3 blur2Color \x3d texture2D( tBlur2, vUv ).xyz;\nvec3 blur3Color \x3d texture2D( tBlur3, vUv ).xyz;\nvec3 blur4Color \x3d texture2D( tBlur4, vUv ).xyz;\noutgoingLight \x3d vec3( vec3( 0.22,  0.437, 0.635 ) * nonblurColor + \nvec3( 0.101, 0.355, 0.365 ) * blur1Color + \nvec3( 0.119, 0.208, 0.0 )   * blur2Color + \nvec3( 0.114, 0.0,   0.0 )   * blur3Color + \nvec3( 0.444, 0.0,   0.0 )   * blur4Color );\noutgoingLight *\x3d sqrt( colDiffuse.xyz );\noutgoingLight +\x3d ambientLightColor * diffuse * colDiffuse.xyz + totalSpecularLight;\n#ifndef VERSION1\noutgoingLight \x3d sqrt( outgoingLight );\n#endif\n}\ngl_FragColor \x3d vec4( outgoingLight, diffuseColor.a );",
THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vViewPosition;",THREE.ShaderChunk.common,THREE.ShaderChunk.fog_pars_vertex,"void main() {\nvec4 worldPosition \x3d modelMatrix * vec4( position, 1.0 );\nvec4 mvPosition \x3d modelViewMatrix * vec4( position, 1.0 );\nvViewPosition \x3d -mvPosition.xyz;\nvNormal \x3d normalize( normalMatrix * normal );\nvUv \x3d uv;\n#ifdef VERTEX_TEXTURES\nvec3 dv \x3d texture2D( tDisplacement, uv ).xyz;\nfloat df \x3d uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition \x3d vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position \x3d projectionMatrix * displacedPosition;\n#else\ngl_Position \x3d projectionMatrix * mvPosition;\n#endif",
THREE.ShaderChunk.fog_vertex,"}"].join("\n"),vertexShaderUV:["varying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vViewPosition;",THREE.ShaderChunk.common,"void main() {\nvec4 worldPosition \x3d modelMatrix * vec4( position, 1.0 );\nvec4 mvPosition \x3d modelViewMatrix * vec4( position, 1.0 );\nvViewPosition \x3d -mvPosition.xyz;\nvNormal \x3d normalize( normalMatrix * normal );\nvUv \x3d uv;\ngl_Position \x3d vec4( uv.x * 2.0 - 1.0, uv.y * 2.0 - 1.0, 0.0, 1.0 );\n}"].join("\n")},beckmann:{uniforms:{},
vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv \x3d uv;\ngl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nfloat PHBeckmann( float ndoth, float m ) {\nfloat alpha \x3d acos( ndoth );\nfloat ta \x3d tan( alpha );\nfloat val \x3d 1.0 / ( m * m * pow( ndoth, 4.0 ) ) * exp( -( ta * ta ) / ( m * m ) );\nreturn val;\n}\nfloat KSTextureCompute( vec2 tex ) {\nreturn 0.5 * pow( PHBeckmann( tex.x, tex.y ), 0.1 );\n}\nvoid main() {\nfloat x \x3d KSTextureCompute( vUv );\ngl_FragColor \x3d vec4( x, x, x, 1.0 );\n}"}};