THREE.GPUParticleSystem=function(d){THREE.Object3D.apply(this,arguments);d=d||{};this.PARTICLE_COUNT=d.maxParticles||1E6;this.PARTICLE_CONTAINERS=d.containerCount||1;this.PARTICLE_NOISE_TEXTURE=d.particleNoiseTex||null;this.PARTICLE_SPRITE_TEXTURE=d.particleSpriteTex||null;this.PARTICLES_PER_CONTAINER=Math.ceil(this.PARTICLE_COUNT/this.PARTICLE_CONTAINERS);this.time=this.PARTICLE_CURSOR=0;this.particleContainers=[];this.rand=[];var b;for(b=1E5;0<b;b--)this.rand.push(Math.random()-.5);this.random=
function(){return++b>=this.rand.length?this.rand[b=1]:this.rand[b]};var e=new THREE.TextureLoader;this.particleNoiseTex=this.PARTICLE_NOISE_TEXTURE||e.load("textures/perlin-512.png");this.particleNoiseTex.wrapS=this.particleNoiseTex.wrapT=THREE.RepeatWrapping;this.particleSpriteTex=this.PARTICLE_SPRITE_TEXTURE||e.load("textures/particle2.png");this.particleSpriteTex.wrapS=this.particleSpriteTex.wrapT=THREE.RepeatWrapping;this.particleShaderMat=new THREE.ShaderMaterial({transparent:!0,depthWrite:!1,
uniforms:{uTime:{value:0},uScale:{value:1},tNoise:{value:this.particleNoiseTex},tSprite:{value:this.particleSpriteTex}},blending:THREE.AdditiveBlending,vertexShader:"uniform float uTime;\nuniform float uScale;\nuniform sampler2D tNoise;\nattribute vec3 positionStart;\nattribute float startTime;\nattribute vec3 velocity;\nattribute float turbulence;\nattribute vec3 color;\nattribute float size;\nattribute float lifeTime;\nvarying vec4 vColor;\nvarying float lifeLeft;\nvoid main() {\n\tvColor \x3d vec4( color, 1.0 );\n\tvec3 newPosition;\n\tvec3 v;\n\tfloat timeElapsed \x3d uTime - startTime;\n\tlifeLeft \x3d 1.0 - ( timeElapsed / lifeTime );\n\tgl_PointSize \x3d ( uScale * size ) * lifeLeft;\n\tv.x \x3d ( velocity.x - 0.5 ) * 3.0;\n\tv.y \x3d ( velocity.y - 0.5 ) * 3.0;\n\tv.z \x3d ( velocity.z - 0.5 ) * 3.0;\n\tnewPosition \x3d positionStart + ( v * 10.0 ) * timeElapsed;\n\tvec3 noise \x3d texture2D( tNoise, vec2( newPosition.x * 0.015 + ( uTime * 0.05 ), newPosition.y * 0.02 + ( uTime * 0.015 ) ) ).rgb;\n\tvec3 noiseVel \x3d ( noise.rgb - 0.5 ) * 30.0;\n\tnewPosition \x3d mix( newPosition, newPosition + vec3( noiseVel * ( turbulence * 5.0 ) ), ( timeElapsed / lifeTime ) );\n\tif( v.y \x3e 0. \x26\x26 v.y \x3c .05 ) {\n\t\tlifeLeft \x3d 0.0;\n\t}\n\tif( v.x \x3c - 1.45 ) {\n\t\tlifeLeft \x3d 0.0;\n\t}\n\tif( timeElapsed \x3e 0.0 ) {\n\t\tgl_Position \x3d projectionMatrix * modelViewMatrix * vec4( newPosition, 1.0 );\n\t} else {\n\t\tgl_Position \x3d projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n\t\tlifeLeft \x3d 0.0;\n\t\tgl_PointSize \x3d 0.;\n\t}\n}",
fragmentShader:"float scaleLinear( float value, vec2 valueDomain ) {\n\treturn ( value - valueDomain.x ) / ( valueDomain.y - valueDomain.x );\n}\nfloat scaleLinear( float value, vec2 valueDomain, vec2 valueRange ) {\n\treturn mix( valueRange.x, valueRange.y, scaleLinear( value, valueDomain ) );\n}\nvarying vec4 vColor;\nvarying float lifeLeft;\nuniform sampler2D tSprite;\nvoid main() {\n\tfloat alpha \x3d 0.;\n\tif( lifeLeft \x3e 0.995 ) {\n\t\talpha \x3d scaleLinear( lifeLeft, vec2( 1.0, 0.995 ), vec2( 0.0, 1.0 ) );\n\t} else {\n\t\talpha \x3d lifeLeft * 0.75;\n\t}\n\tvec4 tex \x3d texture2D( tSprite, gl_PointCoord );\n\tgl_FragColor \x3d vec4( vColor.rgb * tex.a, alpha * tex.a );\n}"});
this.particleShaderMat.defaultAttributeValues.particlePositionsStartTime=[0,0,0,0];this.particleShaderMat.defaultAttributeValues.particleVelColSizeLife=[0,0,0,0];this.init=function(){for(var b=0;b<this.PARTICLE_CONTAINERS;b++){var c=new THREE.GPUParticleContainer(this.PARTICLES_PER_CONTAINER,this);this.particleContainers.push(c);this.add(c)}};this.spawnParticle=function(b){this.PARTICLE_CURSOR++;this.PARTICLE_CURSOR>=this.PARTICLE_COUNT&&(this.PARTICLE_CURSOR=1);this.particleContainers[Math.floor(this.PARTICLE_CURSOR/
this.PARTICLES_PER_CONTAINER)].spawnParticle(b)};this.update=function(b){for(var c=0;c<this.PARTICLE_CONTAINERS;c++)this.particleContainers[c].update(b)};this.dispose=function(){this.particleShaderMat.dispose();this.particleNoiseTex.dispose();this.particleSpriteTex.dispose();for(var b=0;b<this.PARTICLE_CONTAINERS;b++)this.particleContainers[b].dispose()};this.init()};THREE.GPUParticleSystem.prototype=Object.create(THREE.Object3D.prototype);THREE.GPUParticleSystem.prototype.constructor=THREE.GPUParticleSystem;
THREE.GPUParticleContainer=function(d,b){THREE.Object3D.apply(this,arguments);this.PARTICLE_COUNT=d||1E5;this.count=this.offset=this.time=this.PARTICLE_CURSOR=0;this.DPR=window.devicePixelRatio;this.GPUParticleSystem=b;this.particleUpdate=!1;this.particleShaderGeo=new THREE.BufferGeometry;this.particleShaderGeo.addAttribute("position",(new THREE.BufferAttribute(new Float32Array(3*this.PARTICLE_COUNT),3)).setDynamic(!0));this.particleShaderGeo.addAttribute("positionStart",(new THREE.BufferAttribute(new Float32Array(3*
this.PARTICLE_COUNT),3)).setDynamic(!0));this.particleShaderGeo.addAttribute("startTime",(new THREE.BufferAttribute(new Float32Array(this.PARTICLE_COUNT),1)).setDynamic(!0));this.particleShaderGeo.addAttribute("velocity",(new THREE.BufferAttribute(new Float32Array(3*this.PARTICLE_COUNT),3)).setDynamic(!0));this.particleShaderGeo.addAttribute("turbulence",(new THREE.BufferAttribute(new Float32Array(this.PARTICLE_COUNT),1)).setDynamic(!0));this.particleShaderGeo.addAttribute("color",(new THREE.BufferAttribute(new Float32Array(3*
this.PARTICLE_COUNT),3)).setDynamic(!0));this.particleShaderGeo.addAttribute("size",(new THREE.BufferAttribute(new Float32Array(this.PARTICLE_COUNT),1)).setDynamic(!0));this.particleShaderGeo.addAttribute("lifeTime",(new THREE.BufferAttribute(new Float32Array(this.PARTICLE_COUNT),1)).setDynamic(!0));this.particleShaderMat=this.GPUParticleSystem.particleShaderMat;var e=new THREE.Vector3,k=new THREE.Vector3,c=new THREE.Color;this.spawnParticle=function(a){var f=this.particleShaderGeo.getAttribute("positionStart"),
q=this.particleShaderGeo.getAttribute("startTime"),g=this.particleShaderGeo.getAttribute("velocity"),r=this.particleShaderGeo.getAttribute("turbulence"),h=this.particleShaderGeo.getAttribute("color"),t=this.particleShaderGeo.getAttribute("size"),d=this.particleShaderGeo.getAttribute("lifeTime");a=a||{};e=void 0!==a.position?e.copy(a.position):e.set(0,0,0);k=void 0!==a.velocity?k.copy(a.velocity):k.set(0,0,0);c=void 0!==a.color?c.set(a.color):c.set(16777215);var l=void 0!==a.positionRandomness?a.positionRandomness:
0,m=void 0!==a.velocityRandomness?a.velocityRandomness:0,n=void 0!==a.colorRandomness?a.colorRandomness:1,u=void 0!==a.turbulence?a.turbulence:1,v=void 0!==a.lifetime?a.lifetime:5,p=void 0!==a.size?a.size:10,w=void 0!==a.sizeRandomness?a.sizeRandomness:0,x=void 0!==a.smoothPosition?a.smoothPosition:!1;void 0!==this.DPR&&(p*=this.DPR);a=this.PARTICLE_CURSOR;f.array[3*a+0]=e.x+b.random()*l;f.array[3*a+1]=e.y+b.random()*l;f.array[3*a+2]=e.z+b.random()*l;!0===x&&(f.array[3*a+0]+=-(k.x*b.random()),f.array[3*
a+1]+=-(k.y*b.random()),f.array[3*a+2]+=-(k.z*b.random()));f=k.x+b.random()*m;l=k.y+b.random()*m;m=k.z+b.random()*m;f=THREE.Math.clamp((f- -2)/4,0,1);l=THREE.Math.clamp((l- -2)/4,0,1);m=THREE.Math.clamp((m- -2)/4,0,1);g.array[3*a+0]=f;g.array[3*a+1]=l;g.array[3*a+2]=m;c.r=THREE.Math.clamp(c.r+b.random()*n,0,1);c.g=THREE.Math.clamp(c.g+b.random()*n,0,1);c.b=THREE.Math.clamp(c.b+b.random()*n,0,1);h.array[3*a+0]=c.r;h.array[3*a+1]=c.g;h.array[3*a+2]=c.b;r.array[a]=u;t.array[a]=p+b.random()*w;d.array[a]=
v;q.array[a]=this.time+.02*b.random();0===this.offset&&(this.offset=this.PARTICLE_CURSOR);this.count++;this.PARTICLE_CURSOR++;this.PARTICLE_CURSOR>=this.PARTICLE_COUNT&&(this.PARTICLE_CURSOR=0);this.particleUpdate=!0};this.init=function(){this.particleSystem=new THREE.Points(this.particleShaderGeo,this.particleShaderMat);this.particleSystem.frustumCulled=!1;this.add(this.particleSystem)};this.update=function(a){this.time=a;this.particleShaderMat.uniforms.uTime.value=a;this.geometryUpdate()};this.geometryUpdate=
function(){if(!0===this.particleUpdate){this.particleUpdate=!1;var a=this.particleShaderGeo.getAttribute("positionStart"),b=this.particleShaderGeo.getAttribute("startTime"),c=this.particleShaderGeo.getAttribute("velocity"),g=this.particleShaderGeo.getAttribute("turbulence"),d=this.particleShaderGeo.getAttribute("color"),h=this.particleShaderGeo.getAttribute("size"),e=this.particleShaderGeo.getAttribute("lifeTime");this.offset+this.count<this.PARTICLE_COUNT?(a.updateRange.offset=this.offset*a.itemSize,
b.updateRange.offset=this.offset*b.itemSize,c.updateRange.offset=this.offset*c.itemSize,g.updateRange.offset=this.offset*g.itemSize,d.updateRange.offset=this.offset*d.itemSize,h.updateRange.offset=this.offset*h.itemSize,e.updateRange.offset=this.offset*e.itemSize,a.updateRange.count=this.count*a.itemSize,b.updateRange.count=this.count*b.itemSize,c.updateRange.count=this.count*c.itemSize,g.updateRange.count=this.count*g.itemSize,d.updateRange.count=this.count*d.itemSize,h.updateRange.count=this.count*
h.itemSize,e.updateRange.count=this.count*e.itemSize):(a.updateRange.offset=0,b.updateRange.offset=0,c.updateRange.offset=0,g.updateRange.offset=0,d.updateRange.offset=0,h.updateRange.offset=0,e.updateRange.offset=0,a.updateRange.count=-1,b.updateRange.count=-1,c.updateRange.count=-1,g.updateRange.count=-1,d.updateRange.count=-1,h.updateRange.count=-1,e.updateRange.count=-1);a.needsUpdate=!0;b.needsUpdate=!0;c.needsUpdate=!0;g.needsUpdate=!0;d.needsUpdate=!0;h.needsUpdate=!0;e.needsUpdate=!0;this.count=
this.offset=0}};this.dispose=function(){this.particleShaderGeo.dispose()};this.init()};THREE.GPUParticleContainer.prototype=Object.create(THREE.Object3D.prototype);THREE.GPUParticleContainer.prototype.constructor=THREE.GPUParticleContainer;