/*
* Methodology for generating this extern:
* Pulled typescript type annotations from the DefinitelyTyped repository:
* https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/stripe-v3
* 
* Then used tsickle to convert those annotations into Google Closure externs:
* https://github.com/angular/tsickle
*
* With the following basic command:
* `tsickle --externs externs.js index.d.ts`
*/

/**
 * @externs
 * @suppress {duplicate,checkTypes}
 */
// NOTE: generated by tsickle, do not edit.
// externs from index.d.ts:
 /** @type {!stripe.StripeStatic} */
 var Stripe;
 /** @const */
 var stripe = {};
 /**
  * @record
  * @struct
  */
 stripe.StripeStatic = function() {};
 
 /* TODO: CallSignature: stripe */
  /** @type {number} */
 stripe.StripeStatic.prototype.version;
 /**
  * @record
  * @struct
  */
 stripe.Stripe = function() {};
 
 /**
  * @param {(undefined|!stripe.elements.ElementsCreateOptions)=} options
  * @return {!stripe.elements.Elements}
  */
 stripe.Stripe.prototype.elements = function(options) {};
 
 /**
  * @param {!stripe.elements.Element|string} element_or_name
  * @param {(undefined|!stripe.TokenOptions)|!stripe.BankAccountTokenOptions|!stripe.PiiTokenOptions=} options
  * @return {!Promise<!stripe.TokenResponse>}
  */
 stripe.Stripe.prototype.createToken = function(element_or_name, options) {};
 
 /**
  * @param {!stripe.elements.Element|!stripe.SourceOptions} element_or_options
  * @param {(undefined|{owner: (undefined|!stripe.OwnerInfo)})=} options
  * @return {!Promise<!stripe.SourceResponse>}
  */
 stripe.Stripe.prototype.createSource = function(element_or_options, options) {};
 
 /**
  * @param {!stripe.RetrieveSourceOptions} options
  * @return {!Promise<!stripe.SourceResponse>}
  */
 stripe.Stripe.prototype.retrieveSource = function(options) {};
 
 /**
  * @param {!stripe.paymentRequest.StripePaymentRequestOptions} options
  * @return {!stripe.paymentRequest.StripePaymentRequest}
  */
 stripe.Stripe.prototype.paymentRequest = function(options) {};
 /**
  * @record
  * @struct
  */
 stripe.StripeOptions = function() {};
  /** @type {(undefined|string)} */
 stripe.StripeOptions.prototype.stripeAccount;
 /**
  * @record
  * @struct
  */
 stripe.TokenOptions = function() {};
  /** @type {(undefined|string)} */
 stripe.TokenOptions.prototype.name;
  /** @type {(undefined|string)} */
 stripe.TokenOptions.prototype.address_line1;
  /** @type {(undefined|string)} */
 stripe.TokenOptions.prototype.address_line2;
  /** @type {(undefined|string)} */
 stripe.TokenOptions.prototype.address_city;
  /** @type {(undefined|string)} */
 stripe.TokenOptions.prototype.address_state;
  /** @type {(undefined|string)} */
 stripe.TokenOptions.prototype.address_zip;
  /** @type {(undefined|string)} */
 stripe.TokenOptions.prototype.address_country;
  /** @type {(undefined|string)} */
 stripe.TokenOptions.prototype.currency;
 /**
  * @record
  * @struct
  */
 stripe.BankAccountTokenOptions = function() {};
  /** @type {string} */
 stripe.BankAccountTokenOptions.prototype.country;
  /** @type {string} */
 stripe.BankAccountTokenOptions.prototype.currency;
  /** @type {string} */
 stripe.BankAccountTokenOptions.prototype.routing_number;
  /** @type {string} */
 stripe.BankAccountTokenOptions.prototype.account_number;
  /** @type {string} */
 stripe.BankAccountTokenOptions.prototype.account_holder_name;
  /** @type {string} */
 stripe.BankAccountTokenOptions.prototype.account_holder_type;
 /**
  * @record
  * @struct
  */
 stripe.PiiTokenOptions = function() {};
  /** @type {string} */
 stripe.PiiTokenOptions.prototype.personal_id_number;
 /**
  * @record
  * @struct
  */
 stripe.OwnerInfo = function() {};
  /** @type {(undefined|{city: (undefined|string), country: (undefined|string), line1: (undefined|string), line2: (undefined|string), postal_code: (undefined|string), state: (undefined|string)})} */
 stripe.OwnerInfo.prototype.address;
  /** @type {(undefined|string)} */
 stripe.OwnerInfo.prototype.name;
  /** @type {(undefined|string)} */
 stripe.OwnerInfo.prototype.email;
  /** @type {(undefined|string)} */
 stripe.OwnerInfo.prototype.phone;
 /**
  * @record
  * @struct
  */
 stripe.SourceOptions = function() {};
  /** @type {string} */
 stripe.SourceOptions.prototype.type;
  /** @type {(undefined|string)} */
 stripe.SourceOptions.prototype.flow;
  /** @type {(undefined|{iban: string})} */
 stripe.SourceOptions.prototype.sepa_debit;
  /** @type {(undefined|string)} */
 stripe.SourceOptions.prototype.currency;
  /** @type {(undefined|number)} */
 stripe.SourceOptions.prototype.amount;
  /** @type {(undefined|!stripe.OwnerInfo)} */
 stripe.SourceOptions.prototype.owner;
  /** @type {(undefined|!Object)} */
 stripe.SourceOptions.prototype.metadata;
  /** @type {(undefined|string)} */
 stripe.SourceOptions.prototype.statement_descriptor;
  /** @type {(undefined|{return_url: string})} */
 stripe.SourceOptions.prototype.redirect;
  /** @type {(undefined|string)} */
 stripe.SourceOptions.prototype.token;
  /** @type {(undefined|string)} */
 stripe.SourceOptions.prototype.usage;
  /** @type {(undefined|{card: string})} */
 stripe.SourceOptions.prototype.three_d_secure;
 /**
  * @record
  * @struct
  */
 stripe.Token = function() {};
  /** @type {string} */
 stripe.Token.prototype.id;
  /** @type {string} */
 stripe.Token.prototype.object;
  /** @type {(undefined|!stripe.BankAccount)} */
 stripe.Token.prototype.bank_account;
  /** @type {(undefined|!stripe.Card)} */
 stripe.Token.prototype.card;
  /** @type {string} */
 stripe.Token.prototype.client_ip;
  /** @type {number} */
 stripe.Token.prototype.created;
  /** @type {boolean} */
 stripe.Token.prototype.livemode;
  /** @type {string} */
 stripe.Token.prototype.type;
  /** @type {boolean} */
 stripe.Token.prototype.used;
 /**
  * @record
  * @struct
  */
 stripe.TokenResponse = function() {};
  /** @type {(undefined|!stripe.Token)} */
 stripe.TokenResponse.prototype.token;
  /** @type {(undefined|!stripe.Error)} */
 stripe.TokenResponse.prototype.error;
 /**
  * @record
  * @struct
  */
 stripe.Source = function() {};
  /** @type {string} */
 stripe.Source.prototype.client_secret;
  /** @type {number} */
 stripe.Source.prototype.created;
  /** @type {string} */
 stripe.Source.prototype.currency;
  /** @type {string} */
 stripe.Source.prototype.id;
  /** @type {{address: (null|string), email: (null|string), name: (null|string), phone: (null|string), verified_address: (null|string), verified_email: (null|string), verified_name: (null|string), verified_phone: (null|string)}} */
 stripe.Source.prototype.owner;
  /** @type {(undefined|{bank_code: (null|string), country: (null|string), fingerprint: string, last4: string, mandate_reference: string})} */
 stripe.Source.prototype.sepa_debit;
  /** @type {(undefined|!stripe.Card)} */
 stripe.Source.prototype.card;
  /** @type {(undefined|string)} */
 stripe.Source.prototype.status;
  /** @type {(undefined|{status: string, url: string})} */
 stripe.Source.prototype.redirect;
  /** @type {(undefined|{authenticated: boolean})} */
 stripe.Source.prototype.three_d_secure;
 /**
  * @record
  * @struct
  */
 stripe.SourceResponse = function() {};
  /** @type {(undefined|!stripe.Source)} */
 stripe.SourceResponse.prototype.source;
  /** @type {(undefined|!stripe.Error)} */
 stripe.SourceResponse.prototype.error;
 /**
  * @record
  * @struct
  */
 stripe.Error = function() {};
  /** @type {string} */
 stripe.Error.prototype.type;
  /** @type {string} */
 stripe.Error.prototype.charge;
  /** @type {(undefined|string)} */
 stripe.Error.prototype.message;
  /** @type {(undefined|string)} */
 stripe.Error.prototype.code;
  /** @type {(undefined|string)} */
 stripe.Error.prototype.decline_code;
  /** @type {(undefined|string)} */
 stripe.Error.prototype.param;
 
 /** @typedef {string} */
 stripe.statusType;
 /**
  * @record
  * @struct
  */
 stripe.BankAccount = function() {};
  /** @type {string} */
 stripe.BankAccount.prototype.id;
  /** @type {string} */
 stripe.BankAccount.prototype.object;
  /** @type {string} */
 stripe.BankAccount.prototype.account_holder_name;
  /** @type {string} */
 stripe.BankAccount.prototype.account_holder_type;
  /** @type {string} */
 stripe.BankAccount.prototype.bank_name;
  /** @type {string} */
 stripe.BankAccount.prototype.country;
  /** @type {string} */
 stripe.BankAccount.prototype.currency;
  /** @type {string} */
 stripe.BankAccount.prototype.fingerprint;
  /** @type {string} */
 stripe.BankAccount.prototype.last4;
  /** @type {string} */
 stripe.BankAccount.prototype.routing_number;
  /** @type {stripe.statusType} */
 stripe.BankAccount.prototype.status;
 
 /** @typedef {string} */
 stripe.brandType;
 
 /** @typedef {string} */
 stripe.checkType;
 
 /** @typedef {string} */
 stripe.fundingType;
 
 /** @typedef {string} */
 stripe.tokenizationType;
 /**
  * @record
  * @struct
  */
 stripe.Card = function() {};
  /** @type {string} */
 stripe.Card.prototype.id;
  /** @type {string} */
 stripe.Card.prototype.object;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.address_city;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.address_country;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.address_line1;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.address_line1_check;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.address_line2;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.address_state;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.address_zip;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.address_zip_check;
  /** @type {stripe.brandType} */
 stripe.Card.prototype.brand;
  /** @type {string} */
 stripe.Card.prototype.country;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.currency;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.cvc_check;
  /** @type {string} */
 stripe.Card.prototype.dynamic_last4;
  /** @type {number} */
 stripe.Card.prototype.exp_month;
  /** @type {number} */
 stripe.Card.prototype.exp_year;
  /** @type {string} */
 stripe.Card.prototype.fingerprint;
  /** @type {stripe.fundingType} */
 stripe.Card.prototype.funding;
  /** @type {string} */
 stripe.Card.prototype.last4;
  /** @type {?} */
 stripe.Card.prototype.metadata;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.name;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.tokenization_method;
  /** @type {(undefined|string)} */
 stripe.Card.prototype.three_d_secure;
 /**
  * @record
  * @struct
  */
 stripe.RetrieveSourceOptions = function() {};
  /** @type {string} */
 stripe.RetrieveSourceOptions.prototype.id;
  /** @type {string} */
 stripe.RetrieveSourceOptions.prototype.client_secret;
 /** @const */
 stripe.paymentRequest = {};
 /**
  * @record
  * @struct
  */
 stripe.paymentRequest.DisplayItem = function() {};
  /** @type {number} */
 stripe.paymentRequest.DisplayItem.prototype.amount;
  /** @type {string} */
 stripe.paymentRequest.DisplayItem.prototype.label;
  /** @type {(undefined|boolean)} */
 stripe.paymentRequest.DisplayItem.prototype.pending;
 /**
  * @record
  * @struct
  */
 stripe.paymentRequest.StripePaymentRequestUpdateOptions = function() {};
  /** @type {string} */
 stripe.paymentRequest.StripePaymentRequestUpdateOptions.prototype.currency;
  /** @type {!stripe.paymentRequest.DisplayItem} */
 stripe.paymentRequest.StripePaymentRequestUpdateOptions.prototype.total;
  /** @type {(undefined|!Array<!stripe.paymentRequest.DisplayItem>)} */
 stripe.paymentRequest.StripePaymentRequestUpdateOptions.prototype.displayItems;
  /** @type {(undefined|!Array<!stripe.paymentRequest.ShippingOption>)} */
 stripe.paymentRequest.StripePaymentRequestUpdateOptions.prototype.shippingOptions;
 /**
  * @extends {stripe.paymentRequest.StripePaymentRequestUpdateOptions}
  * @record
  * @struct
  */
 stripe.paymentRequest.StripePaymentRequestOptions = function() {};
  /** @type {string} */
 stripe.paymentRequest.StripePaymentRequestOptions.prototype.country;
  /** @type {(undefined|boolean)} */
 stripe.paymentRequest.StripePaymentRequestOptions.prototype.requestPayerName;
  /** @type {(undefined|boolean)} */
 stripe.paymentRequest.StripePaymentRequestOptions.prototype.requestPayerEmail;
  /** @type {(undefined|boolean)} */
 stripe.paymentRequest.StripePaymentRequestOptions.prototype.requestPayerPhone;
  /** @type {(undefined|boolean)} */
 stripe.paymentRequest.StripePaymentRequestOptions.prototype.requestShipping;
 /**
  * @record
  * @struct
  */
 stripe.paymentRequest.UpdateDetails = function() {};
  /** @type {string} */
 stripe.paymentRequest.UpdateDetails.prototype.status;
  /** @type {(undefined|!stripe.paymentRequest.DisplayItem)} */
 stripe.paymentRequest.UpdateDetails.prototype.total;
  /** @type {(undefined|!Array<!stripe.paymentRequest.DisplayItem>)} */
 stripe.paymentRequest.UpdateDetails.prototype.displayItems;
  /** @type {(undefined|!Array<!stripe.paymentRequest.ShippingOption>)} */
 stripe.paymentRequest.UpdateDetails.prototype.shippingOptions;
 /**
  * @record
  * @struct
  */
 stripe.paymentRequest.ShippingOption = function() {};
  /** @type {string} */
 stripe.paymentRequest.ShippingOption.prototype.id;
  /** @type {string} */
 stripe.paymentRequest.ShippingOption.prototype.label;
  /** @type {(undefined|string)} */
 stripe.paymentRequest.ShippingOption.prototype.detail;
  /** @type {number} */
 stripe.paymentRequest.ShippingOption.prototype.amount;
 /**
  * @record
  * @struct
  */
 stripe.paymentRequest.ShippingAddress = function() {};
  /** @type {string} */
 stripe.paymentRequest.ShippingAddress.prototype.country;
  /** @type {!Array<string>} */
 stripe.paymentRequest.ShippingAddress.prototype.addressLine;
  /** @type {string} */
 stripe.paymentRequest.ShippingAddress.prototype.region;
  /** @type {string} */
 stripe.paymentRequest.ShippingAddress.prototype.city;
  /** @type {string} */
 stripe.paymentRequest.ShippingAddress.prototype.postalCode;
  /** @type {string} */
 stripe.paymentRequest.ShippingAddress.prototype.recipient;
  /** @type {string} */
 stripe.paymentRequest.ShippingAddress.prototype.phone;
  /** @type {(undefined|string)} */
 stripe.paymentRequest.ShippingAddress.prototype.sortingCode;
  /** @type {(undefined|string)} */
 stripe.paymentRequest.ShippingAddress.prototype.dependentLocality;
 /**
  * @record
  * @struct
  */
 stripe.paymentRequest.StripePaymentResponse = function() {};
  /** @type {(undefined|!stripe.Token)} */
 stripe.paymentRequest.StripePaymentResponse.prototype.token;
  /** @type {(undefined|!stripe.Source)} */
 stripe.paymentRequest.StripePaymentResponse.prototype.source;
  /** @type {function(string): void} */
 stripe.paymentRequest.StripePaymentResponse.prototype.complete;
  /** @type {(undefined|string)} */
 stripe.paymentRequest.StripePaymentResponse.prototype.payerName;
  /** @type {(undefined|string)} */
 stripe.paymentRequest.StripePaymentResponse.prototype.payerEmail;
  /** @type {(undefined|string)} */
 stripe.paymentRequest.StripePaymentResponse.prototype.payerPhone;
  /** @type {(undefined|!stripe.paymentRequest.ShippingAddress)} */
 stripe.paymentRequest.StripePaymentResponse.prototype.shippingAddress;
  /** @type {(undefined|!stripe.paymentRequest.ShippingOption)} */
 stripe.paymentRequest.StripePaymentResponse.prototype.shippingOption;
  /** @type {string} */
 stripe.paymentRequest.StripePaymentResponse.prototype.methodName;
 /**
  * @record
  * @struct
  */
 stripe.paymentRequest.StripePaymentRequest = function() {};
 
 /**
  * @return {!Promise<(null|{applePay: (undefined|boolean)})>}
  */
 stripe.paymentRequest.StripePaymentRequest.prototype.canMakePayment = function() {};
 
 /**
  * @return {void}
  */
 stripe.paymentRequest.StripePaymentRequest.prototype.show = function() {};
 
 /**
  * @param {!stripe.paymentRequest.StripePaymentRequestUpdateOptions} options
  * @return {void}
  */
 stripe.paymentRequest.StripePaymentRequest.prototype.update = function(options) {};
 
 /**
  * @param {string} event
  * @param {function(!stripe.paymentRequest.StripePaymentResponse): void|function(): void|function({updateWith: function(!stripe.paymentRequest.UpdateDetails): void, shippingAddress: !stripe.paymentRequest.ShippingAddress}): void|function({updateWith: function(!stripe.paymentRequest.UpdateDetails): void, shippingOption: !stripe.paymentRequest.ShippingOption}): void} handler
  * @return {void}
  */
 stripe.paymentRequest.StripePaymentRequest.prototype.on = function(event, handler) {};
 /** @const */
 stripe.elements = {};
 /**
  * @record
  * @struct
  */
 stripe.elements.ElementsCreateOptions = function() {};
  /** @type {(undefined|!Array<!stripe.elements.Font>)} */
 stripe.elements.ElementsCreateOptions.prototype.fonts;
  /** @type {(undefined|string)} */
 stripe.elements.ElementsCreateOptions.prototype.locale;
 
 /** @typedef {function((undefined|!stripe.elements.ElementChangeResponse)=): void} */
 stripe.elements.handler;
 
 /** @typedef {string} */
 stripe.elements.eventTypes;
 /**
  * @record
  * @struct
  */
 stripe.elements.Element = function() {};
 
 /**
  * @param {?} domElement
  * @return {void}
  */
 stripe.elements.Element.prototype.mount = function(domElement) {};
 
 /**
  * @param {stripe.elements.eventTypes|string} event
  * @param {stripe.elements.handler|function({preventDefault: function(): void}): void} handler
  * @return {void}
  */
 stripe.elements.Element.prototype.on = function(event, handler) {};
 
 /**
  * @return {void}
  */
 stripe.elements.Element.prototype.focus = function() {};
 
 /**
  * @return {void}
  */
 stripe.elements.Element.prototype.blur = function() {};
 
 /**
  * @return {void}
  */
 stripe.elements.Element.prototype.clear = function() {};
 
 /**
  * @return {void}
  */
 stripe.elements.Element.prototype.unmount = function() {};
 
 /**
  * @return {void}
  */
 stripe.elements.Element.prototype.destroy = function() {};
 
 /**
  * @param {!stripe.elements.ElementsOptions} options
  * @return {void}
  */
 stripe.elements.Element.prototype.update = function(options) {};
 /**
  * @record
  * @struct
  */
 stripe.elements.ElementChangeResponse = function() {};
  /** @type {string} */
 stripe.elements.ElementChangeResponse.prototype.brand;
  /** @type {boolean} */
 stripe.elements.ElementChangeResponse.prototype.complete;
  /** @type {boolean} */
 stripe.elements.ElementChangeResponse.prototype.empty;
  /** @type {(undefined|{postalCode: (string|number)})} */
 stripe.elements.ElementChangeResponse.prototype.value;
  /** @type {(undefined|!stripe.Error)} */
 stripe.elements.ElementChangeResponse.prototype.error;
 /**
  * @record
  * @struct
  */
 stripe.elements.ElementOptions = function() {};
  /** @type {(undefined|!Array<!stripe.elements.Font>)} */
 stripe.elements.ElementOptions.prototype.fonts;
  /** @type {(undefined|string)} */
 stripe.elements.ElementOptions.prototype.locale;
 
 /** @typedef {string} */
 stripe.elements.elementsType;
 /**
  * @record
  * @struct
  */
 stripe.elements.Elements = function() {};
 
 /**
  * @param {stripe.elements.elementsType} type
  * @param {(undefined|!stripe.elements.ElementsOptions)=} options
  * @return {!stripe.elements.Element}
  */
 stripe.elements.Elements.prototype.create = function(type, options) {};
 /**
  * @record
  * @struct
  */
 stripe.elements.ElementsOptions = function() {};
  /** @type {(undefined|{base: (undefined|string), complete: (undefined|string), empty: (undefined|string), focus: (undefined|string), invalid: (undefined|string), webkitAutofill: (undefined|string)})} */
 stripe.elements.ElementsOptions.prototype.classes;
  /** @type {(undefined|boolean)} */
 stripe.elements.ElementsOptions.prototype.hidePostalCode;
  /** @type {(undefined|boolean)} */
 stripe.elements.ElementsOptions.prototype.hideIcon;
  /** @type {(undefined|string)} */
 stripe.elements.ElementsOptions.prototype.iconStyle;
  /** @type {(undefined|string)} */
 stripe.elements.ElementsOptions.prototype.placeholder;
  /** @type {(undefined|{base: (undefined|!stripe.elements.Style), complete: (undefined|!stripe.elements.Style), empty: (undefined|!stripe.elements.Style), invalid: (undefined|!stripe.elements.Style), paymentRequestButton: (undefined|!stripe.elements.PaymentRequestButtonStyleOptions)})} */
 stripe.elements.ElementsOptions.prototype.style;
  /** @type {(undefined|string|!Object<string,string>)} */
 stripe.elements.ElementsOptions.prototype.value;
  /** @type {(undefined|!stripe.paymentRequest.StripePaymentRequest)} */
 stripe.elements.ElementsOptions.prototype.paymentRequest;
 /**
  * @extends {stripe.elements.StyleOptions}
  * @record
  * @struct
  */
 stripe.elements.Style = function() {};
 
 /* TODO: PropertySignature: stripe.elements.':hover' */
 
 /* TODO: PropertySignature: stripe.elements.':focus' */
 
 /* TODO: PropertySignature: stripe.elements.'::placeholder' */
 
 /* TODO: PropertySignature: stripe.elements.'::selection' */
 
 /* TODO: PropertySignature: stripe.elements.':-webkit-autofill' */
 
 /* TODO: PropertySignature: stripe.elements.'::-ms-clear' */
 /**
  * @record
  * @struct
  */
 stripe.elements.Font = function() {};
  /** @type {(undefined|string)} */
 stripe.elements.Font.prototype.family;
  /** @type {(undefined|string)} */
 stripe.elements.Font.prototype.src;
  /** @type {(undefined|string)} */
 stripe.elements.Font.prototype.display;
  /** @type {(undefined|string)} */
 stripe.elements.Font.prototype.style;
  /** @type {(undefined|string)} */
 stripe.elements.Font.prototype.unicodeRange;
  /** @type {(undefined|string)} */
 stripe.elements.Font.prototype.weight;
  /** @type {(undefined|string)} */
 stripe.elements.Font.prototype.cssSrc;
 /**
  * @record
  * @struct
  */
 stripe.elements.StyleOptions = function() {};
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.color;
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.fontFamily;
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.fontSize;
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.fontSmoothing;
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.fontStyle;
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.fontVariant;
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.iconColor;
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.lineHeight;
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.letterSpacing;
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.textAlign;
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.textDecoration;
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.textShadow;
  /** @type {(undefined|string)} */
 stripe.elements.StyleOptions.prototype.textTransform;
 /**
  * @record
  * @struct
  */
 stripe.elements.PaymentRequestButtonStyleOptions = function() {};
  /** @type {(undefined|string)} */
 stripe.elements.PaymentRequestButtonStyleOptions.prototype.type;
  /** @type {string} */
 stripe.elements.PaymentRequestButtonStyleOptions.prototype.theme;
  /** @type {string} */
 stripe.elements.PaymentRequestButtonStyleOptions.prototype.height; 