/*! JointJS v2.2.1 (2018-11-12) - JavaScript diagramming library


This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
*/
(function(root, factory) {

    if (typeof define === 'function' && define.amd) {

        // For AMD.

        define(['backbone', 'lodash', 'jquery'], function(Backbone, _, $) {

            Backbone.$ = $;

            return factory(root, Backbone, _, $);
        });

    } else if (typeof exports !== 'undefined') {

        // For Node.js or CommonJS.

        var Backbone = require('backbone');
        var _ = require('lodash');
        var $ = Backbone.$ = require('jquery');

        module.exports = factory(root, Backbone, _, $);

    } else {

        // As a browser global.

        var Backbone = root.Backbone;
        var _ = root._;
        var $ = Backbone.$ = root.jQuery || root.$;

        root.joint = factory(root, Backbone, _, $);
        root.g = root.joint.g;
        root.V = root.Vectorizer = root.joint.V;
    }

}(this, function(root, Backbone, _, $) {

!function(){var t="undefined"!=typeof exports?exports:this,f="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";function u(t){this.message=t}(u.prototype=new Error).name="InvalidCharacterError",t.btoa||(t.btoa=function(t){for(var r,e,n=String(t),o=0,i=f,a="";n.charAt(0|o)||(i="=",o%1);a+=i.charAt(63&r>>8-o%1*8)){if(255<(e=n.charCodeAt(o+=.75)))throw new u("'btoa' failed: The string to be encoded contains characters outside of the Latin1 range.");r=r<<8|e}return a}),t.atob||(t.atob=function(t){var r=String(t).replace(/=+$/,"");if(r.length%4==1)throw new u("'atob' failed: The string to be decoded is not correctly encoded.");for(var e,n,o=0,i=0,a="";n=r.charAt(i++);~n&&(e=o%4?64*e+n:n,o++%4)?a+=String.fromCharCode(255&e>>(-2*o&6)):0)n=f.indexOf(n);return a})}(),function(){function n(t,r){return this.slice(t,r)}function o(t,r){arguments.length<2&&(r=0);for(var e=0,n=t.length;e<n;++e,++r)this[r]=255&t[e]}function t(t){var r;if("number"==typeof t){r=new Array(t);for(var e=0;e<t;++e)r[e]=0}else r=t.slice(0);return r.subarray=n,(r.buffer=r).byteLength=r.length,r.set=o,"object"==typeof t&&t.buffer&&(r.buffer=t.buffer),r}"undefined"==typeof Uint8Array&&"undefined"!=typeof window&&(window.Uint8Array=t,window.Uint32Array=t,window.Int32Array=t)}(),"undefined"!=typeof XMLHttpRequest&&("response"in XMLHttpRequest.prototype||"mozResponseArrayBuffer"in XMLHttpRequest.prototype||"mozResponse"in XMLHttpRequest.prototype||"responseArrayBuffer"in XMLHttpRequest.prototype||Object.defineProperty(XMLHttpRequest.prototype,"response",{get:function(){return new Uint8Array(new VBArray(this.responseBody).toArray())}})),Array.prototype.includes||Object.defineProperty(Array.prototype,"includes",{value:function(t,r){if(null==this)throw new TypeError('"this" is null or not defined');var e=Object(this),n=e.length>>>0;if(0===n)return!1;var o,i,a=0|r,f=Math.max(0<=a?a:n-Math.abs(a),0);for(;f<n;){if((o=e[f])===(i=t)||"number"==typeof o&&"number"==typeof i&&isNaN(o)&&isNaN(i))return!0;f++}return!1}}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(t){if(null==this)throw new TypeError('"this" is null or not defined');var r=Object(this),e=r.length>>>0;if("function"!=typeof t)throw new TypeError("predicate must be a function");for(var n=arguments[1],o=0;o<e;){var i=r[o];if(t.call(n,i,o,r))return i;o++}}}),Array.from||(Array.from=function(){var r=Object.prototype.toString,u=function(t){return"function"==typeof t||"[object Function]"===r.call(t)},n=Math.pow(2,53)-1,s=function(t){var r,e=(r=Number(t),isNaN(r)?0:0!==r&&isFinite(r)?(0<r?1:-1)*Math.floor(Math.abs(r)):r);return Math.min(Math.max(e,0),n)};return function(t){var r=Object(t);if(null==t)throw new TypeError("Array.from requires an array-like object - not null or undefined");var e,n=1<arguments.length?arguments[1]:void 0;if(void 0!==n){if(!u(n))throw new TypeError("Array.from: when provided, the second argument must be a function");2<arguments.length&&(e=arguments[2])}for(var o,i=s(r.length),a=u(this)?Object(new this(i)):new Array(i),f=0;f<i;)o=r[f],a[f]=n?void 0===e?n(o,f):n.call(e,o,f):o,f+=1;return a.length=i,a}}()),Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIndex",{value:function(t){if(null==this)throw new TypeError('"this" is null or not defined');var r=Object(this),e=r.length>>>0;if("function"!=typeof t)throw new TypeError("predicate must be a function");for(var n=arguments[1],o=0;o<e;){var i=r[o];if(t.call(n,i,o,r))return o;o++}return-1}}),String.prototype.includes||(String.prototype.includes=function(t,r){"use strict";return"number"!=typeof r&&(r=0),!(r+t.length>this.length)&&-1!==this.indexOf(t,r)}),String.prototype.startsWith||(String.prototype.startsWith=function(t,r){return this.substr(r||0,t.length)===t}),Number.isFinite=Number.isFinite||function(t){return"number"==typeof t&&isFinite(t)},Number.isNaN=Number.isNaN||function(t){return t!=t};
var g={};!function(o){var t=Math,R=t.abs,u=t.cos,a=t.sin,q=t.sqrt,z=t.min,j=t.max,c=t.atan2,e=t.round,r=t.floor,s=t.PI,h=t.random,E=t.pow;o.bezier={curveThroughPoints:function(t){return console.warn("deprecated"),new l(g.throughPoints(t)).serialize()},getCurveControlPoints:function(t){console.warn("deprecated");var n,e=[],i=[],r=t.length-1;if(1==r)return e[0]=new y((2*t[0].x+t[1].x)/3,(2*t[0].y+t[1].y)/3),i[0]=new y(2*e[0].x-t[0].x,2*e[0].y-t[0].y),[e,i];var s=[];for(n=1;n<r-1;n++)s[n]=4*t[n].x+2*t[n+1].x;s[0]=t[0].x+2*t[1].x,s[r-1]=(8*t[r-1].x+t[r].x)/2;var o=this.getFirstControlPoints(s);for(n=1;n<r-1;++n)s[n]=4*t[n].y+2*t[n+1].y;s[0]=t[0].y+2*t[1].y,s[r-1]=(8*t[r-1].y+t[r].y)/2;var h=this.getFirstControlPoints(s);for(n=0;n<r;n++)e.push(new y(o[n],h[n])),n<r-1?i.push(new y(2*t[n+1].x-o[n+1],2*t[n+1].y-h[n+1])):i.push(new y((t[r].x+o[r-1])/2,(t[r].y+h[r-1])/2));return[e,i]},getCurveDivider:function(t,n,e,i){console.warn("deprecated");var r=new g(t,n,e,i);return function(t){var n=r.divide(t);return[{p0:n[0].start,p1:n[0].controlPoint1,p2:n[0].controlPoint2,p3:n[0].end},{p0:n[1].start,p1:n[1].controlPoint1,p2:n[1].controlPoint2,p3:n[1].end}]}},getFirstControlPoints:function(t){console.warn("deprecated");var n=t.length,e=[],i=[],r=2;e[0]=t[0]/r;for(var s=1;s<n;s++)i[s]=1/r,r=(s<n-1?4:3.5)-i[s],e[s]=(t[s]-e[s-1])/r;for(s=1;s<n;s++)e[n-s-1]-=i[n-s]*e[n-s];return e},getInversionSolver:function(t,n,e,i){console.warn("deprecated");var r=new g(t,n,e,i);return function(t){return r.closestPointT(t)}}};var g=o.Curve=function(t,n,e,i){return this instanceof g?t instanceof g?new g(t.start,t.controlPoint1,t.controlPoint2,t.end):(this.start=new y(t),this.controlPoint1=new y(n),this.controlPoint2=new y(e),void(this.end=new y(i))):new g(t,n,e,i)};g.throughPoints=function(){function u(t){var n=t.length,e=[],i=[],r=2;e[0]=t[0]/r;for(var s=1;s<n;s++)i[s]=1/r,r=(s<n-1?4:3.5)-i[s],e[s]=(t[s]-e[s-1])/r;for(s=1;s<n;s++)e[n-s-1]-=i[n-s]*e[n-s];return e}return function(t){if(!t||Array.isArray(t)&&t.length<2)throw new Error("At least 2 points are required");for(var n=function(t){var n,e=[],i=[],r=t.length-1;if(1==r)return e[0]=new y((2*t[0].x+t[1].x)/3,(2*t[0].y+t[1].y)/3),i[0]=new y(2*e[0].x-t[0].x,2*e[0].y-t[0].y),[e,i];var s=[];for(n=1;n<r-1;n++)s[n]=4*t[n].x+2*t[n+1].x;s[0]=t[0].x+2*t[1].x,s[r-1]=(8*t[r-1].x+t[r].x)/2;var o=u(s);for(n=1;n<r-1;++n)s[n]=4*t[n].y+2*t[n+1].y;s[0]=t[0].y+2*t[1].y,s[r-1]=(8*t[r-1].y+t[r].y)/2;var h=u(s);for(n=0;n<r;n++)e.push(new y(o[n],h[n])),n<r-1?i.push(new y(2*t[n+1].x-o[n+1],2*t[n+1].y-h[n+1])):i.push(new y((t[r].x+o[r-1])/2,(t[r].y+h[r-1])/2));return[e,i]}(t),e=[],i=n[0].length,r=0;r<i;r++){var s=new y(n[0][r].x,n[0][r].y),o=new y(n[1][r].x,n[1][r].y);e.push(new g(t[r],s,o,t[r+1]))}return e}}(),g.prototype={bbox:function(){for(var t,n,e,i,r,s,o,h,u=this.start,a=this.controlPoint1,c=this.controlPoint2,l=this.end,f=u.x,g=u.y,p=a.x,d=a.y,v=c.x,y=c.y,w=l.x,m=l.y,x=new Array,b=new Array,S=[new Array,new Array],P=0;P<2;++P)if(e=0===P?(n=6*f-12*p+6*v,t=-3*f+9*p-9*v+3*w,3*p-3*f):(n=6*g-12*d+6*y,t=-3*g+9*d-9*y+3*m,3*d-3*g),R(t)<1e-12){if(R(n)<1e-12)continue;0<(i=-e/n)&&i<1&&b.push(i)}else h=q(o=n*n-4*e*t),o<0||(0<(r=(-n+h)/(2*t))&&r<1&&b.push(r),0<(s=(-n-h)/(2*t))&&s<1&&b.push(s));for(var A,L,E,T=b.length,I=T;T--;)L=(A=1-(i=b[T]))*A*A*f+3*A*A*i*p+3*A*i*i*v+i*i*i*w,S[0][T]=L,E=A*A*A*g+3*A*A*i*d+3*A*i*i*y+i*i*i*m,S[1][T]=E,x[T]={X:L,Y:E};b[I]=0,b[I+1]=1,x[I]={X:f,Y:g},x[I+1]={X:w,Y:m},S[0][I]=f,S[1][I]=g,S[0][I+1]=w,S[1][I+1]=m,b.length=I+2,S[0].length=I+2,S[1].length=I+2,x.length=I+2;var C=z.apply(null,S[0]),N=z.apply(null,S[1]),O=j.apply(null,S[0]),D=j.apply(null,S[1]);return new M(C,N,O-C,D-N)},clone:function(){return new g(this.start,this.controlPoint1,this.controlPoint2,this.end)},closestPoint:function(t,n){return this.pointAtT(this.closestPointT(t,n))},closestPointLength:function(t,n){var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,subdivisions:void 0===n.subdivisions?this.getSubdivisions({precision:e}):n.subdivisions};return this.lengthAtT(this.closestPointT(t,i),i)},closestPointNormalizedLength:function(t,n){var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,subdivisions:void 0===n.subdivisions?this.getSubdivisions({precision:e}):n.subdivisions},r=this.closestPointLength(t,i);if(!r)return 0;var s=this.length(i);return 0===s?0:r/s},closestPointT:function(t,n){for(var e,i,r,s,o,h,u=void 0===(n=n||{}).precision?this.PRECISION:n.precision,a=void 0===n.subdivisions?this.getSubdivisions({precision:u}):n.subdivisions,c=a.length,l=c?1/c:0,f=0;f<c;f++){var g=a[f],p=g.start.distance(t),d=g.end.distance(t),v=p+d;(!h||v<h)&&(e=g,i=f*l,r=(f+1)*l,s=p,o=d,h=v)}for(var y=E(10,-u);;){var w,m;if(w=s?R(s-o)/s:0,m=o?R(s-o)/o:0,w<y||m<y)return s<=o?i:r;var x=e.divide(.5);l/=2;var b=x[0].start.distance(t),S=x[0].end.distance(t),P=b+S,A=x[1].start.distance(t),L=x[1].end.distance(t);o=P<=A+L?(e=x[0],r-=l,s=b,S):(e=x[1],i+=l,s=A,L)}},closestPointTangent:function(t,n){return this.tangentAtT(this.closestPointT(t,n))},divide:function(t){var n=this.start,e=this.controlPoint1,i=this.controlPoint2,r=this.end;if(t<=0)return[new g(n,n,n,n),new g(n,e,i,r)];if(1<=t)return[new g(n,e,i,r),new g(r,r,r,r)];var s=this.getSkeletonPoints(t),o=s.startControlPoint1,h=s.startControlPoint2,u=s.divider,a=s.dividerControlPoint1,c=s.dividerControlPoint2;return[new g(n,o,h,u),new g(u,a,c,r)]},endpointDistance:function(){return this.start.distance(this.end)},equals:function(t){return!!t&&this.start.x===t.start.x&&this.start.y===t.start.y&&this.controlPoint1.x===t.controlPoint1.x&&this.controlPoint1.y===t.controlPoint1.y&&this.controlPoint2.x===t.controlPoint2.x&&this.controlPoint2.y===t.controlPoint2.y&&this.end.x===t.end.x&&this.end.y===t.end.y},getSkeletonPoints:function(t){var n=this.start,e=this.controlPoint1,i=this.controlPoint2,r=this.end;if(t<=0)return{startControlPoint1:n.clone(),startControlPoint2:n.clone(),divider:n.clone(),dividerControlPoint1:e.clone(),dividerControlPoint2:i.clone()};if(1<=t)return{startControlPoint1:e.clone(),startControlPoint2:i.clone(),divider:r.clone(),dividerControlPoint1:r.clone(),dividerControlPoint2:r.clone()};var s=new p(n,e).pointAt(t),o=new p(e,i).pointAt(t),h=new p(i,r).pointAt(t),u=new p(s,o).pointAt(t),a=new p(o,h).pointAt(t);return{startControlPoint1:s,startControlPoint2:u,divider:new p(u,a).pointAt(t),dividerControlPoint1:a,dividerControlPoint2:h}},getSubdivisions:function(t){var n=void 0===(t=t||{}).precision?this.PRECISION:t.precision,e=[new g(this.start,this.controlPoint1,this.controlPoint2,this.end)];if(0===n)return e;for(var i=this.endpointDistance(),r=E(10,-n),s=0;;){s+=1;for(var o=[],h=e.length,u=0;u<h;u++){var a=e[u].divide(.5);o.push(a[0],a[1])}for(var c=0,l=o.length,f=0;f<l;f++){c+=o[f].endpointDistance()}if(1<s&&(0!==c?(c-i)/c:0)<r)return o;e=o,i=c}},isDifferentiable:function(){var t=this.start,n=this.controlPoint1,e=this.controlPoint2,i=this.end;return!(t.equals(n)&&n.equals(e)&&e.equals(i))},length:function(t){for(var n=void 0===(t=t||{}).precision?this.PRECISION:t.precision,e=void 0===t.subdivisions?this.getSubdivisions({precision:n}):t.subdivisions,i=0,r=e.length,s=0;s<r;s++){i+=e[s].endpointDistance()}return i},lengthAtT:function(t,n){if(t<=0)return 0;var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision;return this.divide(t)[0].length({precision:e})},pointAt:function(t,n){if(t<=0)return this.start.clone();if(1<=t)return this.end.clone();var e=this.tAt(t,n);return this.pointAtT(e)},pointAtLength:function(t,n){var e=this.tAtLength(t,n);return this.pointAtT(e)},pointAtT:function(t){return t<=0?this.start.clone():1<=t?this.end.clone():this.getSkeletonPoints(t).divider},PRECISION:3,scale:function(t,n,e){return this.start.scale(t,n,e),this.controlPoint1.scale(t,n,e),this.controlPoint2.scale(t,n,e),this.end.scale(t,n,e),this},tangentAt:function(t,n){if(!this.isDifferentiable())return null;t<0?t=0:1<t&&(t=1);var e=this.tAt(t,n);return this.tangentAtT(e)},tangentAtLength:function(t,n){if(!this.isDifferentiable())return null;var e=this.tAtLength(t,n);return this.tangentAtT(e)},tangentAtT:function(t){if(!this.isDifferentiable())return null;t<0?t=0:1<t&&(t=1);var n=this.getSkeletonPoints(t),e=n.startControlPoint2,i=n.dividerControlPoint1,r=n.divider,s=new p(e,i);return s.translate(r.x-e.x,r.y-e.y),s},tAt:function(t,n){if(t<=0)return 0;if(1<=t)return 1;var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,subdivisions:void 0===n.subdivisions?this.getSubdivisions({precision:e}):n.subdivisions},r=this.length(i)*t;return this.tAtLength(r,i)},tAtLength:function(t,n){var e=!0;t<0&&(e=!1,t=-t);for(var i,r,s,o,h,u=void 0===(n=n||{}).precision?this.PRECISION:n.precision,a=void 0===n.subdivisions?this.getSubdivisions({precision:u}):n.subdivisions,c={precision:u,subdivisions:a},l=0,f=a.length,g=1/f,p=e?0:f-1;e?p<f:0<=p;e?p++:p--){var d=a[p],v=d.endpointDistance();if(t<=l+v){i=d,r=p*g,s=(p+1)*g,o=e?t-l:v+l-t,h=e?v+l-t:t-l;break}l+=v}if(!i)return e?1:0;for(var y=this.length(c),w=E(10,-u);;){var m,x;if((0!==y?o/y:0)<w)return r;if((0!==y?h/y:0)<w)return s;var b=i.divide(.5);g/=2;var S=b[0].endpointDistance(),P=b[1].endpointDistance();x=o<=S?(i=b[0],s-=g,S-(m=o)):(i=b[1],r+=g,P-(m=o-S)),o=m,h=x}},toPoints:function(t){for(var n=void 0===(t=t||{}).precision?this.PRECISION:t.precision,e=void 0===t.subdivisions?this.getSubdivisions({precision:n}):t.subdivisions,i=[e[0].start.clone()],r=e.length,s=0;s<r;s++){var o=e[s];i.push(o.end.clone())}return i},toPolyline:function(t){return new T(this.toPoints(t))},toString:function(){return this.start+" "+this.controlPoint1+" "+this.controlPoint2+" "+this.end},translate:function(t,n){return this.start.translate(t,n),this.controlPoint1.translate(t,n),this.controlPoint2.translate(t,n),this.end.translate(t,n),this}};var i=o.Ellipse=function(t,n,e){return this instanceof i?t instanceof i?new i(new y(t.x,t.y),t.a,t.b):(t=new y(t),this.x=t.x,this.y=t.y,this.a=n,void(this.b=e)):new i(t,n,e)};i.fromRect=function(t){return t=new M(t),new i(t.center(),t.width/2,t.height/2)},i.prototype={bbox:function(){return new M(this.x-this.a,this.y-this.b,2*this.a,2*this.b)},center:function(){return new y(this.x,this.y)},clone:function(){return new i(this)},containsPoint:function(t){return this.normalizedDistance(t)<=1},equals:function(t){return!!t&&t.x===this.x&&t.y===this.y&&t.a===this.a&&t.b===this.b},inflate:function(t,n){return void 0===t&&(t=0),void 0===n&&(n=t),this.a+=2*t,this.b+=2*n,this},intersectionWithLine:function(t){var n=[],e=t.start,i=t.end,r=this.a,s=this.b,o=t.vector(),h=e.difference(new y(this)),u=new y(o.x/(r*r),o.y/(s*s)),a=new y(h.x/(r*r),h.y/(s*s)),c=o.dot(u),l=o.dot(a),f=l*l-c*(h.dot(a)-1);if(f<0)return null;if(0<f){var g=q(f),p=(-l-g)/c,d=(-l+g)/c;if((p<0||1<p)&&(d<0||1<d))return null;0<=p&&p<=1&&n.push(e.lerp(i,p)),0<=d&&d<=1&&n.push(e.lerp(i,d))}else{var v=-l/c;if(!(0<=v&&v<=1))return null;n.push(e.lerp(i,v))}return n},intersectionWithLineFromCenterToPoint:function(t,n){t=new y(t),n&&t.rotate(new y(this.x,this.y),n);var e,i=t.x-this.x,r=t.y-this.y;if(0===i)return e=this.bbox().pointNearestToPoint(t),n?e.rotate(new y(this.x,this.y),-n):e;var s=r/i,o=s*s,h=this.a*this.a,u=this.b*this.b,a=q(1/(1/h+o/u)),c=s*(a=i<0?-a:a);return e=new y(this.x+a,this.y+c),n?e.rotate(new y(this.x,this.y),-n):e},normalizedDistance:function(t){var n=t.x,e=t.y,i=this.a,r=this.b,s=this.x,o=this.y;return(n-s)*(n-s)/(i*i)+(e-o)*(e-o)/(r*r)},tangentTheta:function(t){var n,e,i=t.x,r=t.y,s=this.a,o=this.b,h=this.bbox().center(),u=h.x,a=h.y,c=i>h.x+s/2,l=i<h.x-s/2;return c||l?e=s*s/(i-u)-s*s*(r-a)*((n=i>h.x?r-30:r+30)-a)/(o*o*(i-u))+u:n=o*o/(r-a)-o*o*(i-u)*((e=r>h.y?i+30:i-30)-u)/(s*s*(r-a))+a,new y(e,n).theta(t)},toString:function(){return new y(this.x,this.y).toString()+" "+this.a+" "+this.b}};var p=o.Line=function(t,n){return this instanceof p?t instanceof p?new p(t.start,t.end):(this.start=new y(t),void(this.end=new y(n))):new p(t,n)};p.prototype={bbox:function(){var t=z(this.start.x,this.end.x),n=z(this.start.y,this.end.y),e=j(this.start.x,this.end.x),i=j(this.start.y,this.end.y);return new M(t,n,e-t,i-n)},bearing:function(){var t=w(this.start.y),n=w(this.end.y),e=this.start.x,i=this.end.x,r=w(i-e),s=a(r)*u(n),o=u(t)*a(n)-a(t)*u(n)*u(r),h=v(c(s,o))-22.5;return h<0&&(h+=360),["NE","E","SE","S","SW","W","NW","N"][h=parseInt(h/45)]},clone:function(){return new p(this.start,this.end)},closestPoint:function(t){return this.pointAt(this.closestPointNormalizedLength(t))},closestPointLength:function(t){return this.closestPointNormalizedLength(t)*this.length()},closestPointNormalizedLength:function(t){var n=this.vector().dot(new p(this.start,t).vector()),e=z(1,j(0,n/this.squaredLength()));return e!=e?0:e},closestPointTangent:function(t){return this.tangentAt(this.closestPointNormalizedLength(t))},equals:function(t){return!!t&&this.start.x===t.start.x&&this.start.y===t.start.y&&this.end.x===t.end.x&&this.end.y===t.end.y},intersect:function(t,n){if(t instanceof p||t instanceof M||t instanceof T||t instanceof i||t instanceof l){var e=t.intersectionWithLine(this,n);return e&&t instanceof p&&(e=e[0]),e}return null},intersectionWithLine:function(t){var n=new y(this.end.x-this.start.x,this.end.y-this.start.y),e=new y(t.end.x-t.start.x,t.end.y-t.start.y),i=n.x*e.y-n.y*e.x,r=new y(t.start.x-this.start.x,t.start.y-this.start.y),s=r.x*e.y-r.y*e.x,o=r.x*n.y-r.y*n.x;if(0===i||s*i<0||o*i<0)return null;if(0<i){if(i<s||i<o)return null}else if(s<i||o<i)return null;return[new y(this.start.x+s*n.x/i,this.start.y+s*n.y/i)]},isDifferentiable:function(){return!this.start.equals(this.end)},length:function(){return q(this.squaredLength())},midpoint:function(){return new y((this.start.x+this.end.x)/2,(this.start.y+this.end.y)/2)},pointAt:function(t){var n=this.start,e=this.end;return t<=0?n.clone():1<=t?e.clone():n.lerp(e,t)},pointAtLength:function(t){var n=this.start,e=this.end,i=!0;t<0&&(i=!1,t=-t);var r=this.length();return r<=t?i?e.clone():n.clone():this.pointAt((i?t:r-t)/r)},pointOffset:function(t){t=new o.Point(t);var n=this.start,e=this.end;return((e.x-n.x)*(t.y-n.y)-(e.y-n.y)*(t.x-n.x))/this.length()},rotate:function(t,n){return this.start.rotate(t,n),this.end.rotate(t,n),this},round:function(t){var n=E(10,t||0);return this.start.x=e(this.start.x*n)/n,this.start.y=e(this.start.y*n)/n,this.end.x=e(this.end.x*n)/n,this.end.y=e(this.end.y*n)/n,this},scale:function(t,n,e){return this.start.scale(t,n,e),this.end.scale(t,n,e),this},setLength:function(t){var n=this.length();if(!n)return this;var e=t/n;return this.scale(e,e,this.start)},squaredLength:function(){var t=this.start.x,n=this.start.y;return(t-=this.end.x)*t+(n-=this.end.y)*n},tangentAt:function(t){if(!this.isDifferentiable())return null;var n=this.start,e=this.end,i=this.pointAt(t),r=new p(n,e);return r.translate(i.x-n.x,i.y-n.y),r},tangentAtLength:function(t){if(!this.isDifferentiable())return null;var n=this.start,e=this.end,i=this.pointAtLength(t),r=new p(n,e);return r.translate(i.x-n.x,i.y-n.y),r},toString:function(){return this.start.toString()+" "+this.end.toString()},translate:function(t,n){return this.start.translate(t,n),this.end.translate(t,n),this},vector:function(){return new y(this.end.x-this.start.x,this.end.y-this.start.y)}},p.prototype.intersection=p.prototype.intersect;var l=o.Path=function(t){if(!(this instanceof l))return new l(t);if("string"==typeof t)return new l.parse(t);var n,e;if(this.segments=[],t){if(Array.isArray(t)&&0!==t.length)if(e=t.length,t[0].isSegment)for(n=0;n<e;n++){var i=t[n];this.appendSegment(i)}else{var r=null;for(n=0;n<e;n++){var s=t[n];if(!(s instanceof p||s instanceof g))throw new Error("Cannot construct a path segment from the provided object.");0===n&&this.appendSegment(l.createSegment("M",s.start)),r&&!r.end.equals(s.start)&&this.appendSegment(l.createSegment("M",s.start)),s instanceof p?this.appendSegment(l.createSegment("L",s.end)):s instanceof g&&this.appendSegment(l.createSegment("C",s.controlPoint1,s.controlPoint2,s.end)),r=s}}else if(t.isSegment)this.appendSegment(t);else if(t instanceof p)this.appendSegment(l.createSegment("M",t.start)),this.appendSegment(l.createSegment("L",t.end));else if(t instanceof g)this.appendSegment(l.createSegment("M",t.start)),this.appendSegment(l.createSegment("C",t.controlPoint1,t.controlPoint2,t.end));else if(t instanceof T&&t.points&&0!==t.points.length)for(e=t.points.length,n=0;n<e;n++){var o=t.points[n];0===n?this.appendSegment(l.createSegment("M",o)):this.appendSegment(l.createSegment("L",o))}}else;};l.parse=function(t){if(!t)return new l;for(var n=new l,e=t.match(/(?:[a-zA-Z] *)(?:(?:-?\d+(?:\.\d+)? *,? *)|(?:-?\.\d+ *,? *))+|(?:[a-zA-Z] *)(?! |\d|-|\.)/g),i=e.length,r=0;r<i;r++){var s=e[r].match(/(?:[a-zA-Z])|(?:(?:-?\d+(?:\.\d+)?))|(?:(?:-?\.\d+))/g),o=l.createSegment.apply(this,s);n.appendSegment(o)}return n},l.createSegment=function(t){if(!t)throw new Error("Type must be provided.");var n=l.segmentTypes[t];if(!n)throw new Error(t+" is not a recognized path segment type.");for(var e=[],i=arguments.length,r=1;r<i;r++)e.push(arguments[r]);return m(n,e)},l.prototype={appendSegment:function(t){var n,e=this.segments,i=e.length,r=0!==i?e[i-1]:null;if(Array.isArray(t)){if(!t[0].isSegment)throw new Error("Segments required.");for(var s=t.length,o=0;o<s;o++){var h=t[o];n=this.prepareSegment(h,r,null),e.push(n),r=n}}else{if(!t||!t.isSegment)throw new Error("Segment required.");n=this.prepareSegment(t,r,null),e.push(n)}},bbox:function(){var t,n=this.segments,e=n.length;if(0===e)return null;for(var i=0;i<e;i++){var r=n[i];if(r.isVisible){var s=r.bbox();t=t?t.union(s):s}}if(t)return t;var o=n[e-1];return new M(o.end.x,o.end.y,0,0)},clone:function(){for(var t=this.segments,n=t.length,e=new l,i=0;i<n;i++){var r=t[i].clone();e.appendSegment(r)}return e},closestPoint:function(t,n){var e=this.closestPointT(t,n);return e?this.pointAtT(e):null},closestPointLength:function(t,n){var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.closestPointT(t,i);return r?this.lengthAtT(r,i):0},closestPointNormalizedLength:function(t,n){var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.closestPointLength(t,i);if(0===r)return 0;var s=this.length(i);return 0===s?0:r/s},closestPointT:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;for(var r,s=void 0===(n=n||{}).precision?this.PRECISION:n.precision,o=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:s}):n.segmentSubdivisions,h=1/0,u=0;u<i;u++){var a=e[u],c=o[u];if(a.isVisible){var l=a.closestPointT(t,{precision:s,subdivisions:c}),f=a.pointAtT(l),g=new p(f,t).squaredLength();g<h&&(r={segmentIndex:u,value:l},h=g)}}return r||{segmentIndex:i-1,value:1}},closestPointTangent:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;for(var r,s=void 0===(n=n||{}).precision?this.PRECISION:n.precision,o=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:s}):n.segmentSubdivisions,h=1/0,u=0;u<i;u++){var a=e[u],c=o[u];if(a.isDifferentiable()){var l=a.closestPointT(t,{precision:s,subdivisions:c}),f=a.pointAtT(l),g=new p(f,t).squaredLength();g<h&&(r=a.tangentAtT(l),h=g)}}return r||null},equals:function(t){if(!t)return!1;var n=this.segments,e=t.segments,i=n.length;if(e.length!==i)return!1;for(var r=0;r<i;r++){var s=n[r],o=e[r];if(s.type!==o.type||!s.equals(o))return!1}return!0},getSegment:function(t){var n=this.segments,e=n.length;if(0===e)throw new Error("Path has no segments.");if(t<0&&(t=e+t),e<=t||t<0)throw new Error("Index out of range.");return n[t]},getSegmentSubdivisions:function(t){for(var n=this.segments,e=n.length,i=void 0===(t=t||{}).precision?this.PRECISION:t.precision,r=[],s=0;s<e;s++){var o=n[s].getSubdivisions({precision:i});r.push(o)}return r},insertSegment:function(t,n){var e,i=this.segments,r=i.length;if(t<0&&(t=r+t+1),r<t||t<0)throw new Error("Index out of range.");var s=null,o=null;if(0!==r&&(o=1<=t?(s=i[t-1]).nextSegment:i[0]),Array.isArray(n)){if(!n[0].isSegment)throw new Error("Segments required.");for(var h=n.length,u=0;u<h;u++){var a=n[u];e=this.prepareSegment(a,s,o),i.splice(t+u,0,e),s=e}}else{if(!n||!n.isSegment)throw new Error("Segment required.");e=this.prepareSegment(n,s,o),i.splice(t,0,e)}},intersectionWithLine:function(t,n){var e=null,i=this.toPolylines(n);if(!i)return null;for(var r=0,s=i.length;r<s;r++){var o=i[r],h=t.intersect(o);h&&(e||(e=[]),Array.isArray(h)?Array.prototype.push.apply(e,h):e.push(h))}return e},isDifferentiable:function(){for(var t=this.segments,n=t.length,e=0;e<n;e++){if(t[e].isDifferentiable())return!0}return!1},isValid:function(){var t=this.segments;return 0===t.length||"M"===t[0].type},length:function(t){var n=this.segments,e=n.length;if(0===e)return 0;for(var i=void 0===(t=t||{}).precision?this.PRECISION:t.precision,r=void 0===t.segmentSubdivisions?this.getSegmentSubdivisions({precision:i}):t.segmentSubdivisions,s=0,o=0;o<e;o++){var h=n[o],u=r[o];s+=h.length({subdivisions:u})}return s},lengthAtT:function(t,n){var e=this.segments,i=e.length;if(0===i)return 0;var r=t.segmentIndex;if(r<0)return 0;var s=t.value;i<=r?(r=i-1,s=1):s<0?s=0:1<s&&(s=1);for(var o,h=void 0===(n=n||{}).precision?this.PRECISION:n.precision,u=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:h}):n.segmentSubdivisions,a=0,c=0;c<r;c++){var l=e[c];o=u[c],a+=l.length({precisison:h,subdivisions:o})}return l=e[r],o=u[r],a+=l.lengthAtT(s,{precisison:h,subdivisions:o})},pointAt:function(t,n){if(0===this.segments.length)return null;if(t<=0)return this.start.clone();if(1<=t)return this.end.clone();var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.length(i)*t;return this.pointAtLength(r,i)},pointAtLength:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;if(0===t)return this.start.clone();var r=!0;t<0&&(r=!1,t=-t);for(var s,o=void 0===(n=n||{}).precision?this.PRECISION:n.precision,h=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:o}):n.segmentSubdivisions,u=0,a=r?0:i-1;r?a<i:0<=a;r?a++:a--){var c=e[a],l=h[a],f=c.length({precision:o,subdivisions:l});if(c.isVisible){if(t<=u+f)return c.pointAtLength((r?1:-1)*(t-u),{precision:o,subdivisions:l});s=c}u+=f}return s?r?s.end:s.start:e[i-1].end.clone()},pointAtT:function(t){var n=this.segments,e=n.length;if(0===e)return null;var i=t.segmentIndex;if(i<0)return n[0].pointAtT(0);if(e<=i)return n[e-1].pointAtT(1);var r=t.value;return r<0?r=0:1<r&&(r=1),n[i].pointAtT(r)},PRECISION:3,prepareSegment:function(t,n,e){t.previousSegment=n,t.nextSegment=e,n&&(n.nextSegment=t),e&&(e.previousSegment=t);var i=t;return t.isSubpathStart&&(t.subpathStartSegment=t,i=e),i&&this.updateSubpathStartSegment(i),t},removeSegment:function(t){var n=this.segments,e=n.length;if(0===e)throw new Error("Path has no segments.");if(t<0&&(t=e+t),e<=t||t<0)throw new Error("Index out of range.");var i=n.splice(t,1)[0],r=i.previousSegment,s=i.nextSegment;r&&(r.nextSegment=s),s&&(s.previousSegment=r),i.isSubpathStart&&s&&this.updateSubpathStartSegment(s)},replaceSegment:function(t,n){var e,i=this.segments,r=i.length;if(0===r)throw new Error("Path has no segments.");if(t<0&&(t=r+t),r<=t||t<0)throw new Error("Index out of range.");var s=i[t],o=s.previousSegment,h=s.nextSegment,u=s.isSubpathStart;if(Array.isArray(n)){if(!n[0].isSegment)throw new Error("Segments required.");i.splice(t,1);for(var a=n.length,c=0;c<a;c++){var l=n[c];e=this.prepareSegment(l,o,h),i.splice(t+c,0,e),o=e,u&&e.isSubpathStart&&(u=!1)}}else{if(!n||!n.isSegment)throw new Error("Segment required.");e=this.prepareSegment(n,o,h),i.splice(t,1,e),u&&e.isSubpathStart&&(u=!1)}u&&h&&this.updateSubpathStartSegment(h)},scale:function(t,n,e){for(var i=this.segments,r=i.length,s=0;s<r;s++){i[s].scale(t,n,e)}return this},segmentAt:function(t,n){var e=this.segmentIndexAt(t,n);return e?this.getSegment(e):null},segmentAtLength:function(t,n){var e=this.segmentIndexAtLength(t,n);return e?this.getSegment(e):null},segmentIndexAt:function(t,n){if(0===this.segments.length)return null;t<0&&(t=0),1<t&&(t=1);var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.length(i)*t;return this.segmentIndexAtLength(r,i)},segmentIndexAtLength:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;var r=!0;t<0&&(r=!1,t=-t);for(var s=void 0===(n=n||{}).precision?this.PRECISION:n.precision,o=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:s}):n.segmentSubdivisions,h=null,u=0,a=r?0:i-1;r?a<i:0<=a;r?a++:a--){var c=e[a],l=o[a],f=c.length({precision:s,subdivisions:l});if(c.isVisible){if(t<=u+f)return a;h=a}u+=f}return h},serialize:function(){if(!this.isValid())throw new Error("Invalid path segments.");return this.toString()},tangentAt:function(t,n){if(0===this.segments.length)return null;t<0&&(t=0),1<t&&(t=1);var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.length(i)*t;return this.tangentAtLength(r,i)},tangentAtLength:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;var r=!0;t<0&&(r=!1,t=-t);for(var s,o=void 0===(n=n||{}).precision?this.PRECISION:n.precision,h=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:o}):n.segmentSubdivisions,u=0,a=r?0:i-1;r?a<i:0<=a;r?a++:a--){var c=e[a],l=h[a],f=c.length({precision:o,subdivisions:l});if(c.isDifferentiable()){if(t<=u+f)return c.tangentAtLength((r?1:-1)*(t-u),{precision:o,subdivisions:l});s=c}u+=f}if(s){var g=r?1:0;return s.tangentAtT(g)}return null},tangentAtT:function(t){var n=this.segments,e=n.length;if(0===e)return null;var i=t.segmentIndex;if(i<0)return n[0].tangentAtT(0);if(e<=i)return n[e-1].tangentAtT(1);var r=t.value;return r<0?r=0:1<r&&(r=1),n[i].tangentAtT(r)},toPoints:function(t){var n=this.segments,e=n.length;if(0===e)return null;for(var i=void 0===(t=t||{}).precision?this.PRECISION:t.precision,r=void 0===t.segmentSubdivisions?this.getSegmentSubdivisions({precision:i}):t.segmentSubdivisions,s=[],o=[],h=0;h<e;h++){var u=n[h];if(u.isVisible){var a=r[h];if(0<a.length){var c=a.map(function(t){return t.start});Array.prototype.push.apply(o,c)}else o.push(u.start)}else 0<o.length&&(o.push(n[h-1].end),s.push(o),o=[])}return 0<o.length&&(o.push(this.end),s.push(o)),s},toPolylines:function(t){var n=[],e=this.toPoints(t);if(!e)return null;for(var i=0,r=e.length;i<r;i++)n.push(new T(e[i]));return n},toString:function(){for(var t=this.segments,n=t.length,e="",i=0;i<n;i++){e+=t[i].serialize()+" "}return e.trim()},translate:function(t,n){for(var e=this.segments,i=e.length,r=0;r<i;r++){e[r].translate(t,n)}return this},updateSubpathStartSegment:function(t){for(var n=t.previousSegment;t&&!t.isSubpathStart;)t.subpathStartSegment=n?n.subpathStartSegment:null,t=(n=t).nextSegment}},Object.defineProperty(l.prototype,"start",{configurable:!0,enumerable:!0,get:function(){var t=this.segments,n=t.length;if(0===n)return null;for(var e=0;e<n;e++){var i=t[e];if(i.isVisible)return i.start}return t[n-1].end}}),Object.defineProperty(l.prototype,"end",{configurable:!0,enumerable:!0,get:function(){var t=this.segments,n=t.length;if(0===n)return null;for(var e=n-1;0<=e;e--){var i=t[e];if(i.isVisible)return i.end}return t[n-1].end}});var y=o.Point=function(t,n){if(!(this instanceof y))return new y(t,n);if("string"==typeof t){var e=t.split(-1===t.indexOf("@")?" ":"@");t=parseFloat(e[0]),n=parseFloat(e[1])}else Object(t)===t&&(n=t.y,t=t.x);this.x=void 0===t?0:t,this.y=void 0===n?0:n};y.fromPolar=function(t,n,e){e=e&&new y(e)||new y(0,0);var i=R(t*u(n)),r=R(t*a(n)),s=f(v(n));return s<90?r=-r:s<180?(i=-i,r=-r):s<270&&(i=-i),new y(e.x+i,e.y+r)},y.random=function(t,n,e,i){return new y(r(h()*(n-t+1)+t),r(h()*(i-e+1)+e))},y.prototype={adhereToRect:function(t){return t.containsPoint(this)||(this.x=z(j(this.x,t.x),t.x+t.width),this.y=z(j(this.y,t.y),t.y+t.height)),this},angleBetween:function(t,n){var e=this.equals(t)||this.equals(n)?NaN:this.theta(n)-this.theta(t);return e<0&&(e+=360),e},bearing:function(t){return new p(this,t).bearing()},changeInAngle:function(t,n,e){return this.clone().offset(-t,-n).theta(e)-this.theta(e)},clone:function(){return new y(this)},cross:function(t,n){return t&&n?(n.x-this.x)*(t.y-this.y)-(n.y-this.y)*(t.x-this.x):NaN},difference:function(t,n){return Object(t)===t&&(n=t.y,t=t.x),new y(this.x-(t||0),this.y-(n||0))},distance:function(t){return new p(this,t).length()},dot:function(t){return t?this.x*t.x+this.y*t.y:NaN},equals:function(t){return!!t&&this.x===t.x&&this.y===t.y},lerp:function(t,n){var e=this.x,i=this.y;return new y((1-n)*e+n*t.x,(1-n)*i+n*t.y)},magnitude:function(){return q(this.x*this.x+this.y*this.y)||.01},manhattanDistance:function(t){return R(t.x-this.x)+R(t.y-this.y)},move:function(t,n){var e=w(new y(t).theta(this));return this.offset(u(e)*n,-a(e)*n)},normalize:function(t){var n=(t||1)/this.magnitude();return this.scale(n,n)},offset:function(t,n){return Object(t)===t&&(n=t.y,t=t.x),this.x+=t||0,this.y+=n||0,this},reflection:function(t){return new y(t).move(this,this.distance(t))},rotate:function(t,n){t=t||new o.Point(0,0),n=w(f(-n));var e=u(n),i=a(n),r=e*(this.x-t.x)-i*(this.y-t.y)+t.x,s=i*(this.x-t.x)+e*(this.y-t.y)+t.y;return this.x=r,this.y=s,this},round:function(t){var n=E(10,t||0);return this.x=e(this.x*n)/n,this.y=e(this.y*n)/n,this},scale:function(t,n,e){return e=e&&new y(e)||new y(0,0),this.x=e.x+t*(this.x-e.x),this.y=e.y+n*(this.y-e.y),this},snapToGrid:function(t,n){return this.x=d(this.x,t),this.y=d(this.y,n||t),this},squaredDistance:function(t){return new p(this,t).squaredLength()},theta:function(t){var n=-((t=new y(t)).y-this.y),e=t.x-this.x,i=c(n,e);return i<0&&(i=2*s+i),180*i/s},toJSON:function(){return{x:this.x,y:this.y}},toPolar:function(t){t=t&&new y(t)||new y(0,0);var n=this.x,e=this.y;return this.x=q((n-t.x)*(n-t.x)+(e-t.y)*(e-t.y)),this.y=w(t.theta(new y(n,e))),this},toString:function(){return this.x+"@"+this.y},update:function(t,n){return this.x=t||0,this.y=n||0,this},vectorAngle:function(t){return new y(0,0).angleBetween(this,t)}},y.prototype.translate=y.prototype.offset;var T=o.Polyline=function(t){return this instanceof T?"string"==typeof t?new T.parse(t):void(this.points=Array.isArray(t)?t.map(y):[]):new T(t)};T.parse=function(t){if(""===(t=t.trim()))return new T;for(var n=[],e=t.split(/\s*,\s*|\s+/),i=e.length,r=0;r<i;r+=2)n.push({x:+e[r],y:+e[r+1]});return new T(n)},T.prototype={bbox:function(){var t=1/0,n=-1/0,e=1/0,i=-1/0,r=this.points,s=r.length;if(0===s)return null;for(var o=0;o<s;o++){var h=r[o],u=h.x,a=h.y;u<t&&(t=u),n<u&&(n=u),a<e&&(e=a),i<a&&(i=a)}return new M(t,e,n-t,i-e)},clone:function(){var t=this.points,n=t.length;if(0===n)return new T;for(var e=[],i=0;i<n;i++){var r=t[i].clone();e.push(r)}return new T(e)},closestPoint:function(t){var n=this.closestPointLength(t);return this.pointAtLength(n)},closestPointLength:function(t){var n,e=this.points,i=e.length;if(0===i)return 0;if(1===i)return 0;for(var r=1/0,s=0,o=i-1,h=0;h<o;h++){var u=new p(e[h],e[h+1]),a=u.length(),c=u.closestPointNormalizedLength(t),l=u.pointAt(c).squaredDistance(t);l<r&&(r=l,n=s+c*a),s+=a}return n},closestPointNormalizedLength:function(t){var n=this.closestPointLength(t);if(0===n)return 0;var e=this.length();return 0===e?0:n/e},closestPointTangent:function(t){var n=this.closestPointLength(t);return this.tangentAtLength(n)},convexHull:function(){var t,n,e,i=this.points,r=i.length;if(0===r)return new T;for(t=0;t<r;t++)void 0===e?e=i[t]:i[t].y<e.y?e=i[t]:i[t].y===e.y&&i[t].x>e.x&&(e=i[t]);var s=[];for(t=0;t<r;t++){var o=e.theta(i[t]);0===o&&(o=360);var h=[i[t],t,o];s.push(h)}if(s.sort(function(t,n){var e=t[2]-n[2];return 0===e&&(e=n[1]-t[1]),e}),2<s.length){var u=s[s.length-1];s.unshift(u)}for(var a,c,l,f,g,p,d,v={},y=[];0!==s.length;)if(c=(a=s.pop())[0],!v.hasOwnProperty(a[0]+"@@"+a[1]))for(var w=!1;!w;)if(y.length<2)y.push(a),w=!0;else{f=(l=y.pop())[0];var m=(p=(g=y.pop())[0]).cross(f,c);if(m<0)y.push(g),y.push(l),y.push(a),w=!0;else if(0===m){var x=f.angleBetween(p,c);R(x-180)<1e-10?(v[l[0]+"@@"+l[1]]=f,y.push(g)):f.equals(c)||p.equals(f)?(v[l[0]+"@@"+l[1]]=f,y.push(g)):R((x+1)%360-1)<1e-10&&(y.push(g),s.push(l))}else v[l[0]+"@@"+l[1]]=f,y.push(g)}2<y.length&&y.pop();var b=-1;for(n=y.length,t=0;t<n;t++){var S=y[t][1];(void 0===d||S<d)&&(d=S,b=t)}var P=[];if(0<b){var A=y.slice(b),L=y.slice(0,b);P=A.concat(L)}else P=y;var E=[];for(n=P.length,t=0;t<n;t++)E.push(P[t][0]);return new T(E)},equals:function(t){if(!t)return!1;var n=this.points,e=t.points,i=n.length;if(e.length!==i)return!1;for(var r=0;r<i;r++){var s=n[r],o=t.points[r];if(!s.equals(o))return!1}return!0},intersectionWithLine:function(t){for(var n=new p(t),e=[],i=this.points,r=0,s=i.length-1;r<s;r++){var o=i[r],h=i[r+1],u=new p(o,h),a=n.intersectionWithLine(u);a&&e.push(a[0])}return 0<e.length?e:null},isDifferentiable:function(){var t=this.points,n=t.length;if(0===n)return!1;for(var e=n-1,i=0;i<e;i++){var r=t[i],s=t[i+1];if(new p(r,s).isDifferentiable())return!0}return!1},length:function(){var t=this.points,n=t.length;if(0===n)return 0;for(var e=0,i=n-1,r=0;r<i;r++)e+=t[r].distance(t[r+1]);return e},pointAt:function(t){var n=this.points,e=n.length;if(0===e)return null;if(1===e)return n[0].clone();if(t<=0)return n[0].clone();if(1<=t)return n[e-1].clone();var i=this.length()*t;return this.pointAtLength(i)},pointAtLength:function(t){var n=this.points,e=n.length;if(0===e)return null;if(1===e)return n[0].clone();var i=!0;t<0&&(i=!1,t=-t);for(var r=0,s=e-1,o=i?0:s-1;i?o<s:0<=o;i?o++:o--){var h=n[o],u=n[o+1],a=new p(h,u),c=h.distance(u);if(t<=r+c)return a.pointAtLength((i?1:-1)*(t-r));r+=c}return(i?n[e-1]:n[0]).clone()},scale:function(t,n,e){var i=this.points,r=i.length;if(0===r)return this;for(var s=0;s<r;s++)i[s].scale(t,n,e);return this},tangentAt:function(t){var n=this.points.length;if(0===n)return null;if(1===n)return null;t<0&&(t=0),1<t&&(t=1);var e=this.length()*t;return this.tangentAtLength(e)},tangentAtLength:function(t){var n=this.points,e=n.length;if(0===e)return null;if(1===e)return null;var i,r=!0;t<0&&(r=!1,t=-t);for(var s=0,o=e-1,h=r?0:o-1;r?h<o:0<=h;r?h++:h--){var u=n[h],a=n[h+1],c=new p(u,a),l=u.distance(a);if(c.isDifferentiable()){if(t<=s+l)return c.tangentAtLength((r?1:-1)*(t-s));i=c}s+=l}if(i){var f=r?1:0;return i.tangentAt(f)}return null},toString:function(){return this.points+""},translate:function(t,n){var e=this.points,i=e.length;if(0===i)return this;for(var r=0;r<i;r++)e[r].translate(t,n);return this},serialize:function(){var t=this.points,n=t.length;if(0===n)return"";for(var e="",i=0;i<n;i++){var r=t[i];e+=r.x+","+r.y+" "}return e.trim()}},Object.defineProperty(T.prototype,"start",{configurable:!0,enumerable:!0,get:function(){return 0===this.points.length?null:this.points[0]}}),Object.defineProperty(T.prototype,"end",{configurable:!0,enumerable:!0,get:function(){var t=this.points.length;return 0===t?null:this.points[t-1]}});var M=o.Rect=function(t,n,e,i){if(!(this instanceof M))return new M(t,n,e,i);Object(t)===t&&(n=t.y,e=t.width,i=t.height,t=t.x),this.x=void 0===t?0:t,this.y=void 0===n?0:n,this.width=void 0===e?0:e,this.height=void 0===i?0:i};M.fromEllipse=function(t){return t=new i(t),new M(t.x-t.a,t.y-t.b,2*t.a,2*t.b)},M.prototype={bbox:function(t){if(!t)return this.clone();var n=w(t),e=R(a(n)),i=R(u(n)),r=this.width*i+this.height*e,s=this.width*e+this.height*i;return new M(this.x+(this.width-r)/2,this.y+(this.height-s)/2,r,s)},bottomLeft:function(){return new y(this.x,this.y+this.height)},bottomLine:function(){return new p(this.bottomLeft(),this.bottomRight())},bottomMiddle:function(){return new y(this.x+this.width/2,this.y+this.height)},center:function(){return new y(this.x+this.width/2,this.y+this.height/2)},clone:function(){return new M(this)},containsPoint:function(t){return(t=new y(t)).x>=this.x&&t.x<=this.x+this.width&&t.y>=this.y&&t.y<=this.y+this.height},containsRect:function(t){var n=new M(this).normalize(),e=new M(t).normalize(),i=n.width,r=n.height,s=e.width,o=e.height;if(!(i&&r&&s&&o))return!1;var h=n.x,u=n.y,a=e.x,c=e.y;return s+=a,i+=h,o+=c,r+=u,h<=a&&s<=i&&u<=c&&o<=r},corner:function(){return new y(this.x+this.width,this.y+this.height)},equals:function(t){var n=new M(this).normalize(),e=new M(t).normalize();return n.x===e.x&&n.y===e.y&&n.width===e.width&&n.height===e.height},inflate:function(t,n){return void 0===t&&(t=0),void 0===n&&(n=t),this.x-=t,this.y-=n,this.width+=2*t,this.height+=2*n,this},intersect:function(t){var n=this.origin(),e=this.corner(),i=t.origin(),r=t.corner();if(r.x<=n.x||r.y<=n.y||i.x>=e.x||i.y>=e.y)return null;var s=j(n.x,i.x),o=j(n.y,i.y);return new M(s,o,z(e.x,r.x)-s,z(e.y,r.y)-o)},intersectionWithLine:function(t){var n,e,i=[this.topLine(),this.rightLine(),this.bottomLine(),this.leftLine()],r=[],s=[],o=i.length;for(e=0;e<o;e++)null!==(n=t.intersect(i[e]))&&s.indexOf(n.toString())<0&&(r.push(n),s.push(n.toString()));return 0<r.length?r:null},intersectionWithLineFromCenterToPoint:function(t,n){t=new y(t);var e,i=new y(this.x+this.width/2,this.y+this.height/2);n&&t.rotate(i,n);for(var r=[this.topLine(),this.rightLine(),this.bottomLine(),this.leftLine()],s=new p(i,t),o=r.length-1;0<=o;--o){var h=r[o].intersection(s);if(null!==h){e=h;break}}return e&&n&&e.rotate(i,-n),e},leftLine:function(){return new p(this.topLeft(),this.bottomLeft())},leftMiddle:function(){return new y(this.x,this.y+this.height/2)},maxRectScaleToFit:function(t,n){var e,i,r,s,o,h,u,a;t=new M(t),n||(n=t.center());var c=n.x,l=n.y;e=i=r=s=o=h=u=a=1/0;var f=t.topLeft();f.x<c&&(e=(this.x-c)/(f.x-c)),f.y<l&&(o=(this.y-l)/(f.y-l));var g=t.bottomRight();g.x>c&&(i=(this.x+this.width-c)/(g.x-c)),g.y>l&&(h=(this.y+this.height-l)/(g.y-l));var p=t.topRight();p.x>c&&(r=(this.x+this.width-c)/(p.x-c)),p.y<l&&(u=(this.y-l)/(p.y-l));var d=t.bottomLeft();return d.x<c&&(s=(this.x-c)/(d.x-c)),d.y>l&&(a=(this.y+this.height-l)/(d.y-l)),{sx:z(e,i,r,s),sy:z(o,h,u,a)}},maxRectUniformScaleToFit:function(t,n){var e=this.maxRectScaleToFit(t,n);return z(e.sx,e.sy)},moveAndExpand:function(t){return this.x+=t.x||0,this.y+=t.y||0,this.width+=t.width||0,this.height+=t.height||0,this},normalize:function(){var t=this.x,n=this.y,e=this.width,i=this.height;return this.width<0&&(t=this.x+this.width,e=-this.width),this.height<0&&(n=this.y+this.height,i=-this.height),this.x=t,this.y=n,this.width=e,this.height=i,this},offset:function(t,n){return y.prototype.offset.call(this,t,n)},origin:function(){return new y(this.x,this.y)},pointNearestToPoint:function(t){if(t=new y(t),this.containsPoint(t))switch(this.sideNearestToPoint(t)){case"right":return new y(this.x+this.width,t.y);case"left":return new y(this.x,t.y);case"bottom":return new y(t.x,this.y+this.height);case"top":return new y(t.x,this.y)}return t.adhereToRect(this)},rightLine:function(){return new p(this.topRight(),this.bottomRight())},rightMiddle:function(){return new y(this.x+this.width,this.y+this.height/2)},round:function(t){var n=E(10,t||0);return this.x=e(this.x*n)/n,this.y=e(this.y*n)/n,this.width=e(this.width*n)/n,this.height=e(this.height*n)/n,this},scale:function(t,n,e){return e=this.origin().scale(t,n,e),this.x=e.x,this.y=e.y,this.width*=t,this.height*=n,this},sideNearestToPoint:function(t){var n=(t=new y(t)).x-this.x,e=this.x+this.width-t.x,i=t.y-this.y,r=n,s="left";return e<r&&(r=e,s="right"),i<r&&(r=i,s="top"),this.y+this.height-t.y<r&&(s="bottom"),s},snapToGrid:function(t,n){var e=this.origin().snapToGrid(t,n),i=this.corner().snapToGrid(t,n);return this.x=e.x,this.y=e.y,this.width=i.x-e.x,this.height=i.y-e.y,this},toJSON:function(){return{x:this.x,y:this.y,width:this.width,height:this.height}},topLine:function(){return new p(this.topLeft(),this.topRight())},topMiddle:function(){return new y(this.x+this.width/2,this.y)},topRight:function(){return new y(this.x+this.width,this.y)},toString:function(){return this.origin().toString()+" "+this.corner().toString()},union:function(t){t=new M(t);var n=this.origin(),e=this.corner(),i=t.origin(),r=t.corner(),s=z(n.x,i.x),o=z(n.y,i.y),h=j(e.x,r.x),u=j(e.y,r.y);return new M(s,o,h-s,u-o)}},M.prototype.bottomRight=M.prototype.corner,M.prototype.topLeft=M.prototype.origin,M.prototype.translate=M.prototype.offset,o.scale={linear:function(t,n,e){var i=t[1]-t[0],r=n[1]-n[0];return(e-t[0])/i*r+n[0]||0}};var f=o.normalizeAngle=function(t){return t%360+(t<0?360:0)},d=o.snapToGrid=function(t,n){return n*e(t/n)},v=o.toDeg=function(t){return 180*t/s%360},w=o.toRad=function(t,n){return(t=(n=n||!1)?t:t%360)*s/180};function m(t,n){return n.unshift(null),new(Function.prototype.bind.apply(t,n))}function n(t){var n,e,i=[];for(e=arguments.length,n=1;n<e;n++)i.push(arguments[n]);if(!t)throw new Error("Missing a parent object.");var r=Object.create(t);for(e=i.length,n=0;n<e;n++){var s,o,h=i[n];for(o in h)h.hasOwnProperty(o)&&(delete r[o],s=Object.getOwnPropertyDescriptor(h,o),Object.defineProperty(r,o,s))}return r}o.ellipse=o.Ellipse,o.line=o.Line,o.point=o.Point,o.rect=o.Rect;var x={bbox:function(){throw new Error("Declaration missing for virtual function.")},clone:function(){throw new Error("Declaration missing for virtual function.")},closestPoint:function(){throw new Error("Declaration missing for virtual function.")},closestPointLength:function(){throw new Error("Declaration missing for virtual function.")},closestPointNormalizedLength:function(){throw new Error("Declaration missing for virtual function.")},closestPointT:function(t){if(this.closestPointNormalizedLength)return this.closestPointNormalizedLength(t);throw new Error("Neither closestPointT() nor closestPointNormalizedLength() function is implemented.")},closestPointTangent:function(){throw new Error("Declaration missing for virtual function.")},equals:function(){throw new Error("Declaration missing for virtual function.")},getSubdivisions:function(){throw new Error("Declaration missing for virtual function.")},isDifferentiable:function(){throw new Error("Declaration missing for virtual function.")},isSegment:!0,isSubpathStart:!1,isVisible:!0,length:function(){throw new Error("Declaration missing for virtual function.")},lengthAtT:function(t){if(t<=0)return 0;var n=this.length();return 1<=t?n:n*t},nextSegment:null,pointAt:function(){throw new Error("Declaration missing for virtual function.")},pointAtLength:function(){throw new Error("Declaration missing for virtual function.")},pointAtT:function(t){if(this.pointAt)return this.pointAt(t);throw new Error("Neither pointAtT() nor pointAt() function is implemented.")},previousSegment:null,subpathStartSegment:null,scale:function(){throw new Error("Declaration missing for virtual function.")},serialize:function(){throw new Error("Declaration missing for virtual function.")},tangentAt:function(){throw new Error("Declaration missing for virtual function.")},tangentAtLength:function(){throw new Error("Declaration missing for virtual function.")},tangentAtT:function(t){if(this.tangentAt)return this.tangentAt(t);throw new Error("Neither tangentAtT() nor tangentAt() function is implemented.")},toString:function(){throw new Error("Declaration missing for virtual function.")},translate:function(){throw new Error("Declaration missing for virtual function.")}};Object.defineProperty(x,"end",{configurable:!0,enumerable:!0,writable:!0}),Object.defineProperty(x,"start",{configurable:!0,enumerable:!0,get:function(){if(!this.previousSegment)throw new Error("Missing previous segment. (This segment cannot be the first segment of a path; OR segment has not yet been added to a path.)");return this.previousSegment.end}}),Object.defineProperty(x,"type",{configurable:!0,enumerable:!0,get:function(){throw new Error("Bad segment declaration. No type specified.")}});var b=function(){for(var t,n,e=[],i=arguments.length,r=0;r<i;r++)e.push(arguments[r]);if(!(this instanceof b))return m(b,e);if(0===i)throw new Error("Lineto constructor expects 1 point or 2 coordinates (none provided).");if("string"==typeof e[0]||"number"==typeof e[0]){if(2===i)return this.end=new y(+e[0],+e[1]),this;if(i<2)throw new Error("Lineto constructor expects 1 point or 2 coordinates ("+i+" coordinates provided).");var s;for(t=[],r=0;r<i;r+=2)s=e.slice(r,r+2),t.push(m(b,s));return t}if(1===i)return this.end=new y(e[0]),this;for(t=[],r=0;r<i;r+=1)n=e[r],t.push(new b(n));return t},S={clone:function(){return new b(this.end)},getSubdivisions:function(){return[]},isDifferentiable:function(){return!!this.previousSegment&&!this.start.equals(this.end)},scale:function(t,n,e){return this.end.scale(t,n,e),this},serialize:function(){var t=this.end;return this.type+" "+t.x+" "+t.y},toString:function(){return this.type+" "+this.start+" "+this.end},translate:function(t,n){return this.end.translate(t,n),this}};Object.defineProperty(S,"type",{configurable:!0,enumerable:!0,value:"L"}),b.prototype=n(x,p.prototype,S);var P=function(){for(var t,n,e=[],i=arguments.length,r=0;r<i;r++)e.push(arguments[r]);if(!(this instanceof P))return m(P,e);if(0===i)throw new Error("Curveto constructor expects 3 points or 6 coordinates (none provided).");if("string"==typeof e[0]||"number"==typeof e[0]){if(6===i)return this.controlPoint1=new y(+e[0],+e[1]),this.controlPoint2=new y(+e[2],+e[3]),this.end=new y(+e[4],+e[5]),this;if(i<6)throw new Error("Curveto constructor expects 3 points or 6 coordinates ("+i+" coordinates provided).");var s;for(t=[],r=0;r<i;r+=6)s=e.slice(r,r+6),t.push(m(P,s));return t}if(3===i)return this.controlPoint1=new y(e[0]),this.controlPoint2=new y(e[1]),this.end=new y(e[2]),this;if(i<3)throw new Error("Curveto constructor expects 3 points or 6 coordinates ("+i+" points provided).");for(t=[],r=0;r<i;r+=3)n=e.slice(r,r+3),t.push(m(P,n));return t},A={clone:function(){return new P(this.controlPoint1,this.controlPoint2,this.end)},isDifferentiable:function(){if(!this.previousSegment)return!1;var t=this.start,n=this.controlPoint1,e=this.controlPoint2,i=this.end;return!(t.equals(n)&&n.equals(e)&&e.equals(i))},scale:function(t,n,e){return this.controlPoint1.scale(t,n,e),this.controlPoint2.scale(t,n,e),this.end.scale(t,n,e),this},serialize:function(){var t=this.controlPoint1,n=this.controlPoint2,e=this.end;return this.type+" "+t.x+" "+t.y+" "+n.x+" "+n.y+" "+e.x+" "+e.y},toString:function(){return this.type+" "+this.start+" "+this.controlPoint1+" "+this.controlPoint2+" "+this.end},translate:function(t,n){return this.controlPoint1.translate(t,n),this.controlPoint2.translate(t,n),this.end.translate(t,n),this}};Object.defineProperty(A,"type",{configurable:!0,enumerable:!0,value:"C"}),P.prototype=n(x,g.prototype,A);var L=function(){for(var t,n,e=[],i=arguments.length,r=0;r<i;r++)e.push(arguments[r]);if(!(this instanceof L))return m(L,e);if(0===i)throw new Error("Moveto constructor expects 1 point or 2 coordinates (none provided).");if("string"==typeof e[0]||"number"==typeof e[0]){if(2===i)return this.end=new y(+e[0],+e[1]),this;if(i<2)throw new Error("Moveto constructor expects 1 point or 2 coordinates ("+i+" coordinates provided).");var s;for(t=[],r=0;r<i;r+=2)s=e.slice(r,r+2),0===r?t.push(m(L,s)):t.push(m(b,s));return t}if(1===i)return this.end=new y(e[0]),this;for(t=[],r=0;r<i;r+=1)n=e[r],0===r?t.push(new L(n)):t.push(new b(n));return t},I={bbox:function(){return null},clone:function(){return new L(this.end)},closestPoint:function(){return this.end.clone()},closestPointNormalizedLength:function(){return 0},closestPointLength:function(){return 0},closestPointT:function(){return 1},closestPointTangent:function(){return null},equals:function(t){return this.end.equals(t.end)},getSubdivisions:function(){return[]},isDifferentiable:function(){return!1},isSubpathStart:!0,isVisible:!1,length:function(){return 0},lengthAtT:function(){return 0},pointAt:function(){return this.end.clone()},pointAtLength:function(){return this.end.clone()},pointAtT:function(){return this.end.clone()},scale:function(t,n,e){return this.end.scale(t,n,e),this},serialize:function(){var t=this.end;return this.type+" "+t.x+" "+t.y},tangentAt:function(){return null},tangentAtLength:function(){return null},tangentAtT:function(){return null},toString:function(){return this.type+" "+this.end},translate:function(t,n){return this.end.translate(t,n),this}};Object.defineProperty(I,"start",{configurable:!0,enumerable:!0,get:function(){throw new Error("Illegal access. Moveto segments should not need a start property.")}}),Object.defineProperty(I,"type",{configurable:!0,enumerable:!0,value:"M"}),L.prototype=n(x,I);var C=function(){for(var t=[],n=arguments.length,e=0;e<n;e++)t.push(arguments[e]);if(!(this instanceof C))return m(C,t);if(0<n)throw new Error("Closepath constructor expects no arguments.");return this},N={clone:function(){return new C},getSubdivisions:function(){return[]},isDifferentiable:function(){return!(!this.previousSegment||!this.subpathStartSegment)&&!this.start.equals(this.end)},scale:function(){return this},serialize:function(){return this.type},toString:function(){return this.type+" "+this.start+" "+this.end},translate:function(){return this}};Object.defineProperty(N,"end",{configurable:!0,enumerable:!0,get:function(){if(!this.subpathStartSegment)throw new Error("Missing subpath start segment. (This segment needs a subpath start segment (e.g. Moveto); OR segment has not yet been added to a path.)");return this.subpathStartSegment.end}}),Object.defineProperty(N,"type",{configurable:!0,enumerable:!0,value:"Z"}),C.prototype=n(x,p.prototype,N);var O=l.segmentTypes={L:b,C:P,M:L,Z:C,z:C};l.regexSupportedData=new RegExp("^[\\s\\d"+Object.keys(O).join("")+",.]*$"),l.isDataSupported=function(t){return"string"==typeof t&&this.regexSupportedData.test(t)}}(g);
var V,Vectorizer;V=Vectorizer=function(){"use strict";if(!("object"==typeof window&&!(!window.SVGAngle&&!document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1"))))return function(){throw new Error("SVG is required to use Vectorizer.")};var c={xmlns:"http://www.w3.org/2000/svg",xml:"http://www.w3.org/XML/1998/namespace",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml"},t=Math,v=t.PI,i=t.atan2,s=t.sqrt,h=t.min,f=t.max,p=t.cos,x=t.sin,N=function(t,e,r){if(!(this instanceof N))return N.apply(Object.create(N.prototype),arguments);if(t){if(N.isV(t)&&(t=t.node),e=e||{},N.isString(t)){if("svg"===t.toLowerCase())t=N.createSvgDocument();else if("<"===t[0]){var n=N.createSvgDocument(t);if(1<n.childNodes.length){var a,i,s=[];for(a=0,i=n.childNodes.length;a<i;a++){var o=n.childNodes[a];s.push(new N(document.importNode(o,!0)))}return s}t=document.importNode(n.firstChild,!0)}else t=document.createElementNS(c.xmlns,t);N.ensureId(t)}return this.node=t,this.setAttributes(e),r&&this.append(r),this}},e=N.prototype;function V(t,e,r){r||(r={});for(var n=r.includeAnnotationIndices,a=r.eol,i=r.lineHeight,s=r.baseSize,o=0,c={},l=e.length-1,u=0;u<=l;u++){var h=e[u],f=null;if(N.isObject(h)){var d=h.attrs,m=N("tspan",d),v=m.node,g=h.t;a&&u===l&&(g+=a),v.textContent=g;var p=d.class;p&&m.addClass(p),n&&m.attr("annotations",h.annotations),void 0===(f=parseFloat(d["font-size"]))&&(f=s),f&&o<f&&(o=f)}else a&&u===l&&(h+=a),v=document.createTextNode(h||" "),s&&o<s&&(o=s);t.appendChild(v)}return o&&(c.maxFontSize=o),i?c.lineHeight=i:o&&(c.lineHeight=1.2*o),c}Object.defineProperty(e,"id",{enumerable:!0,get:function(){return this.node.id},set:function(t){this.node.id=t}}),e.getTransformToElement=function(t){var e=this.node;if(N.isSVGGraphicsElement(t)&&N.isSVGGraphicsElement(e)){var r=N.toNode(t).getScreenCTM(),n=e.getScreenCTM();if(r&&n)return r.inverse().multiply(n)}return N.createSVGMatrix()},e.transform=function(t,e){var r=this.node;if(N.isUndefined(t))return N.transformStringToMatrix(this.attr("transform"));if(e&&e.absolute)return this.attr("transform",N.matrixToTransformString(t));var n=N.createSVGTransform(t);return r.transform.baseVal.appendItem(n),this},e.translate=function(t,e,r){r=r||{},e=e||0;var n=this.attr("transform")||"",a=N.parseTransformString(n);if(n=a.value,N.isUndefined(t))return a.translate;n=n.replace(/translate\([^)]*\)/g,"").trim();var i="translate("+(r.absolute?t:a.translate.tx+t)+","+(r.absolute?e:a.translate.ty+e)+")";return this.attr("transform",(i+" "+n).trim()),this},e.rotate=function(t,e,r,n){n=n||{};var a=this.attr("transform")||"",i=N.parseTransformString(a);if(a=i.value,N.isUndefined(t))return i.rotate;a=a.replace(/rotate\([^)]*\)/g,"").trim(),t%=360;var s="rotate("+(n.absolute?t:i.rotate.angle+t)+(void 0!==e&&void 0!==r?","+e+","+r:"")+")";return this.attr("transform",(a+" "+s).trim()),this},e.scale=function(t,e){e=N.isUndefined(e)?t:e;var r=this.attr("transform")||"",n=N.parseTransformString(r);if(r=n.value,N.isUndefined(t))return n.scale;r=r.replace(/scale\([^)]*\)/g,"").trim();var a="scale("+t+","+e+")";return this.attr("transform",(r+" "+a).trim()),this},e.bbox=function(t,e){var r,n=this.node,a=n.ownerSVGElement;if(!a)return new g.Rect(0,0,0,0);try{r=n.getBBox()}catch(t){r={x:n.clientLeft,y:n.clientTop,width:n.clientWidth,height:n.clientHeight}}if(t)return new g.Rect(r);var i=this.getTransformToElement(e||a);return N.transformRect(r,i)},e.getBBox=function(t){var e,r={},n=this.node;if(!n.ownerSVGElement||!N.isSVGGraphicsElement(n))return new g.Rect(0,0,0,0);if(t&&(t.target&&(r.target=N.toNode(t.target)),t.recursive&&(r.recursive=t.recursive)),r.recursive){var a=this.children(),i=a.length;if(0===i)return this.getBBox({target:r.target,recursive:!1});r.target||(r.target=this);for(var s=0;s<i;s++){var o,c=a[s];o=0===c.children().length?c.getBBox({target:r.target,recursive:!1}):c.getBBox({target:r.target,recursive:!0}),e=e?e.union(o):o}return e}try{e=n.getBBox()}catch(t){e={x:n.clientLeft,y:n.clientTop,width:n.clientWidth,height:n.clientHeight}}if(r.target){var l=this.getTransformToElement(r.target);return N.transformRect(e,l)}return new g.Rect(e)};var L=/em$/;function M(t,e){var r=parseFloat(t);return L.test(t)?r*e:r}e.text=function(t,e){if(t&&"string"!=typeof t)throw new Error("Vectorizer: text() expects the first argument to be a string.");t=N.sanitizeText(t),e||(e={});var r=e.eol,n=e.textPath,a=e.textVerticalAnchor,i="middle"===a||"bottom"===a||"top"===a,s=e.x;void 0===s&&(s=this.attr("x")||0);var o=e.includeAnnotationIndices,c=e.annotations;c&&!N.isArray(c)&&(c=[c]);var l=e.lineHeight,u="auto"===l,h=u?"1.5em":l||"1em";this.empty(),this.attr({"xml:space":"preserve",display:t?null:"none"});var f=parseFloat(this.attr("font-size"));f||(f=16,(i||c)&&this.attr("font-size",f));var d,m=document;d=n?("string"==typeof n&&(n={d:n}),function(t,e){t||(t={});var r=N("textPath"),n=t.d;if(n&&void 0===t["xlink:href"]){var a=N("path").attr("d",n).appendTo(e.defs());r.attr("xlink:href","#"+a.id)}return N.isObject(t)&&r.attr(t),r.node}(n,this)):m.createDocumentFragment();for(var v,g=0,p=t.split("\n"),x=[],y=0,T=p.length-1;y<=T;y++){var b,P=h,w="v-line",A=m.createElementNS(N.namespace.xmlns,"tspan"),S=p[y];if(S)if(c){var F=(b=V(A,N.annotateString(S,c,{offset:-g,includeAnnotationIndices:o}),{includeAnnotationIndices:o,eol:y!==T&&r,lineHeight:u?null:h,baseSize:f})).lineHeight;F&&u&&0!==y&&(P=F),0===y&&(v=.8*b.maxFontSize)}else r&&y!==T&&(S+=r),A.textContent=S;else{A.textContent="-",w+=" v-empty-line";var C=A.style;C.fillOpacity=0,C.strokeOpacity=0,c&&(b={})}b&&x.push(b),0<y&&A.setAttribute("dy",P),(0<y||n)&&A.setAttribute("x",s),A.className.baseVal=w,d.appendChild(A),g+=S.length+1}if(i)if(c)P=function(t,e,r,n){if(!Array.isArray(e))return 0;var a=e.length;if(!a)return 0;for(var i=e[0],s=M(i.maxFontSize,r)||r,o=0,c=M(n,r),l=1;l<a;l++)o+=M((i=e[l]).lineHeight,r)||c;var u,h=M(i.maxFontSize,r)||r;switch(t){case"middle":u=s/2-.15*h-o/2;break;case"bottom":u=-.25*h-o;break;default:case"top":u=.8*s}return u}(a,x,f,h);else if("top"===a)P="0.8em";else{var E;switch(0<T?(E=parseFloat(h)||1,E*=T,L.test(h)||(E/=f)):E=0,a){case"middle":P=.3-E/2+"em";break;case"bottom":P=-E-.3+"em"}}else 0===a?P="0em":a?P=a:(P=0,null===this.attr("y")&&this.attr("y",v||"0.8em"));return d.firstChild.setAttribute("dy",P),this.append(d),this},e.removeAttr=function(t){var e=N.qualifyAttr(t),r=this.node;return e.ns?r.hasAttributeNS(e.ns,e.local)&&r.removeAttributeNS(e.ns,e.local):r.hasAttribute(t)&&r.removeAttribute(t),this},e.attr=function(t,e){if(N.isUndefined(t)){for(var r=this.node.attributes,n={},a=0;a<r.length;a++)n[r[a].name]=r[a].value;return n}if(N.isString(t)&&N.isUndefined(e))return this.node.getAttribute(t);if("object"==typeof t)for(var i in t)t.hasOwnProperty(i)&&this.setAttribute(i,t[i]);else this.setAttribute(t,e);return this},e.normalizePath=function(){return"PATH"===this.tagName()&&this.attr("d",N.normalizePathData(this.attr("d"))),this},e.remove=function(){return this.node.parentNode&&this.node.parentNode.removeChild(this.node),this},e.empty=function(){for(;this.node.firstChild;)this.node.removeChild(this.node.firstChild);return this},e.setAttributes=function(t){for(var e in t)t.hasOwnProperty(e)&&this.setAttribute(e,t[e]);return this},e.append=function(t){N.isArray(t)||(t=[t]);for(var e=0,r=t.length;e<r;e++)this.node.appendChild(N.toNode(t[e]));return this},e.prepend=function(t){var e=this.node.firstChild;return e?N(e).before(t):this.append(t)},e.before=function(t){var e=this.node,r=e.parentNode;if(r){N.isArray(t)||(t=[t]);for(var n=0,a=t.length;n<a;n++)r.insertBefore(N.toNode(t[n]),e)}return this},e.appendTo=function(t){return N.toNode(t).appendChild(this.node),this},e.svg=function(){return this.node instanceof window.SVGSVGElement?this:N(this.node.ownerSVGElement)},e.tagName=function(){return this.node.tagName.toUpperCase()},e.defs=function(){var t=this.svg()||this,e=t.node.getElementsByTagName("defs")[0];return e?N(e):N("defs").appendTo(t)},e.clone=function(){var t=N(this.node.cloneNode(!0));return t.node.id=N.uniqueId(),t},e.findOne=function(t){var e=this.node.querySelector(t);return e?N(e):void 0},e.find=function(t){var e=[],r=this.node.querySelectorAll(t);if(r)for(var n=0;n<r.length;n++)e.push(N(r[n]));return e},e.children=function(){for(var t=this.node.childNodes,e=[],r=0;r<t.length;r++){1===t[r].nodeType&&e.push(N(t[r]))}return e},e.index=function(){for(var t=0,e=this.node.previousSibling;e;)1===e.nodeType&&t++,e=e.previousSibling;return t},e.findParentByClass=function(t,e){for(var r=this.node.ownerSVGElement,n=this.node.parentNode;n&&n!==e&&n!==r;){var a=N(n);if(a.hasClass(t))return a;n=n.parentNode}return null},e.contains=function(t){var e=this.node,r=N.toNode(t),n=r&&r.parentNode;return e===n||!!(n&&1===n.nodeType&&16&e.compareDocumentPosition(n))},e.toLocalPoint=function(t,e){var r=this.svg().node,n=r.createSVGPoint();n.x=t,n.y=e;try{var a=n.matrixTransform(r.getScreenCTM().inverse()),i=this.getTransformToElement(r).inverse()}catch(t){return n}return a.matrixTransform(i)},e.translateCenterToPoint=function(t){var e=this.getBBox({target:this.svg()}).center();return this.translate(t.x-e.x,t.y-e.y),this},e.translateAndAutoOrient=function(t,e,r){var n=this.scale();this.attr("transform",""),this.scale(n.sx,n.sy);var a=this.svg().node,i=this.getBBox({target:r||a}),s=a.createSVGTransform();s.setTranslate(-i.x-i.width/2,-i.y-i.height/2);var o=a.createSVGTransform(),c=new g.Point(t).changeInAngle(t.x-e.x,t.y-e.y,e);o.setRotate(c,0,0);var l=a.createSVGTransform(),u=new g.Point(t).move(e,i.width/2);l.setTranslate(t.x+(t.x-u.x),t.y+(t.y-u.y));var h=this.getTransformToElement(r||a),f=a.createSVGTransform();f.setMatrix(l.matrix.multiply(o.matrix.multiply(s.matrix.multiply(h))));var d=N.decomposeMatrix(f.matrix);return this.translate(d.translateX,d.translateY),this.rotate(d.rotation),this},e.animateAlongPath=function(t,e){e=N.toNode(e);var r=N.ensureId(e),n=N("animateMotion",t),a=N("mpath",{"xlink:href":"#"+r});n.append(a),this.append(n);try{n.node.beginElement()}catch(t){if("fake"===document.documentElement.getAttribute("smiling")){var i=n.node;i.animators=[];var s=i.getAttribute("id");s&&(id2anim[s]=i);for(var o=getTargets(i),c=0,l=o.length;c<l;c++){var u=o[c],h=new Animator(i,u,c);animators.push(h),(i.animators[c]=h).register()}}}return this},e.hasClass=function(t){return new RegExp("(\\s|^)"+t+"(\\s|$)").test(this.node.getAttribute("class"))},e.addClass=function(t){if(t&&!this.hasClass(t)){var e=this.node.getAttribute("class")||"";this.node.setAttribute("class",(e+" "+t).trim())}return this},e.removeClass=function(t){if(t&&this.hasClass(t)){var e=this.node.getAttribute("class").replace(new RegExp("(\\s|^)"+t+"(\\s|$)","g"),"$2");this.node.setAttribute("class",e)}return this},e.toggleClass=function(t,e){return(N.isUndefined(e)?this.hasClass(t):!e)?this.removeClass(t):this.addClass(t),this},e.sample=function(t){t=t||1;for(var e,r=this.node,n=r.getTotalLength(),a=[],i=0;i<n;)e=r.getPointAtLength(i),a.push({x:e.x,y:e.y,distance:i}),i+=t;return a},e.convertToPath=function(){var t=N("path");t.attr(this.attr());var e=this.convertToPathData();return e&&t.attr("d",e),t},e.convertToPathData=function(){var t=this.tagName();switch(t){case"PATH":return this.attr("d");case"LINE":return N.convertLineToPathData(this.node);case"POLYGON":return N.convertPolygonToPathData(this.node);case"POLYLINE":return N.convertPolylineToPathData(this.node);case"ELLIPSE":return N.convertEllipseToPathData(this.node);case"CIRCLE":return N.convertCircleToPathData(this.node);case"RECT":return N.convertRectToPathData(this.node)}throw new Error(t+" cannot be converted to PATH.")},N.prototype.toGeometryShape=function(){var t,e,r,n,a,i,s,o,c,l,u,h,f,d,m;switch(this.tagName()){case"RECT":return t=parseFloat(this.attr("x"))||0,e=parseFloat(this.attr("y"))||0,r=parseFloat(this.attr("width"))||0,n=parseFloat(this.attr("height"))||0,new g.Rect(t,e,r,n);case"CIRCLE":return a=parseFloat(this.attr("cx"))||0,i=parseFloat(this.attr("cy"))||0,s=parseFloat(this.attr("r"))||0,new g.Ellipse({x:a,y:i},s,s);case"ELLIPSE":return a=parseFloat(this.attr("cx"))||0,i=parseFloat(this.attr("cy"))||0,o=parseFloat(this.attr("rx"))||0,c=parseFloat(this.attr("ry"))||0,new g.Ellipse({x:a,y:i},o,c);case"POLYLINE":return l=N.getPointsFromSvgNode(this),new g.Polyline(l);case"POLYGON":return 1<(l=N.getPointsFromSvgNode(this)).length&&l.push(l[0]),new g.Polyline(l);case"PATH":return u=this.attr("d"),g.Path.isDataSupported(u)||(u=N.normalizePathData(u)),new g.Path(u);case"LINE":return h=parseFloat(this.attr("x1"))||0,d=parseFloat(this.attr("y1"))||0,f=parseFloat(this.attr("x2"))||0,m=parseFloat(this.attr("y2"))||0,new g.Line({x:h,y:d},{x:f,y:m})}return this.getBBox()},e.findIntersection=function(t,e){var r=this.svg().node;e=e||r;var n=this.getBBox({target:e}),a=n.center();if(n.intersectionWithLineFromCenterToPoint(t)){var i,s=this.tagName();if("RECT"===s){var o=new g.Rect(parseFloat(this.attr("x")||0),parseFloat(this.attr("y")||0),parseFloat(this.attr("width")),parseFloat(this.attr("height"))),c=this.getTransformToElement(e),l=N.decomposeMatrix(c),u=r.createSVGTransform();u.setRotate(-l.rotation,a.x,a.y);var h=N.transformRect(o,u.matrix.multiply(c));i=new g.Rect(h).intersectionWithLineFromCenterToPoint(t,l.rotation)}else if("PATH"===s||"POLYGON"===s||"POLYLINE"===s||"CIRCLE"===s||"ELLIPSE"===s){var f,d,m,v,p,x=("PATH"===s?this:this.convertToPath()).sample(),y=1/0,T=[];for(f=0;f<x.length;f++)d=x[f],m=(m=N.createSVGPoint(d.x,d.y)).matrixTransform(this.getTransformToElement(e)),(p=(d=new g.Point(m)).distance(a)+(v=1.1*d.distance(t)))<y?(y=p,T=[{sample:d,refDistance:v}]):p<y+1&&T.push({sample:d,refDistance:v});T.sort(function(t,e){return t.refDistance-e.refDistance}),T[0]&&(i=T[0].sample)}return i}},e.setAttribute=function(t,e){var r=this.node;if(null===e)return this.removeAttr(t),this;var n=N.qualifyAttr(t);return n.ns?r.setAttributeNS(n.ns,t,e):"id"===t?r.id=e:r.setAttribute(t,e),this},N.createSvgDocument=function(t){var e='<svg xmlns="'+c.xmlns+'" xmlns:xlink="'+c.xlink+'" version="1.1">'+(t||"")+"</svg>";return N.parseXML(e,{async:!1}).documentElement},N.idCounter=0,N.uniqueId=function(){return"v-"+ ++N.idCounter},N.toNode=function(t){return N.isV(t)?t.node:t.nodeName&&t||t[0]},N.ensureId=function(t){return(t=N.toNode(t)).id||(t.id=N.uniqueId())},N.sanitizeText=function(t){return(t||"").replace(/ /g," ")},N.isUndefined=function(t){return void 0===t},N.isString=function(t){return"string"==typeof t},N.isObject=function(t){return t&&"object"==typeof t},N.isArray=Array.isArray,N.parseXML=function(t,e){var r;e=e||{};try{var n=new DOMParser;N.isUndefined(e.async)||(n.async=e.async),r=n.parseFromString(t,"text/xml")}catch(t){r=void 0}if(!r||r.getElementsByTagName("parsererror").length)throw new Error("Invalid XML: "+t);return r},N.qualifyAttr=function(t){if(-1===t.indexOf(":"))return{ns:null,local:t};var e=t.split(":");return{ns:c[e[0]],local:e[1]}},N.transformRegex=/(\w+)\(([^,)]+),?([^)]+)?\)/gi,N.transformSeparatorRegex=/[ ,]+/,N.transformationListRegex=/^(\w+)\((.*)\)/,N.transformStringToMatrix=function(t){var e=N.createSVGMatrix(),r=t&&t.match(N.transformRegex);if(!r)return e;for(var n=0,a=r.length;n<a;n++){var i=r[n].match(N.transformationListRegex);if(i){var s,o,c,l,u,h=N.createSVGMatrix(),f=i[2].split(N.transformSeparatorRegex);switch(i[1].toLowerCase()){case"scale":s=parseFloat(f[0]),o=void 0===f[1]?s:parseFloat(f[1]),h=h.scaleNonUniform(s,o);break;case"translate":c=parseFloat(f[0]),l=parseFloat(f[1]),h=h.translate(c,l);break;case"rotate":u=parseFloat(f[0]),c=parseFloat(f[1])||0,l=parseFloat(f[2])||0,h=0!==c||0!==l?h.translate(c,l).rotate(u).translate(-c,-l):h.rotate(u);break;case"skewx":u=parseFloat(f[0]),h=h.skewX(u);break;case"skewy":u=parseFloat(f[0]),h=h.skewY(u);break;case"matrix":h.a=parseFloat(f[0]),h.b=parseFloat(f[1]),h.c=parseFloat(f[2]),h.d=parseFloat(f[3]),h.e=parseFloat(f[4]),h.f=parseFloat(f[5]);break;default:continue}e=e.multiply(h)}}return e},N.matrixToTransformString=function(t){return t||(t=!0),"matrix("+(void 0!==t.a?t.a:1)+","+(void 0!==t.b?t.b:0)+","+(void 0!==t.c?t.c:0)+","+(void 0!==t.d?t.d:1)+","+(void 0!==t.e?t.e:0)+","+(void 0!==t.f?t.f:0)+")"},N.parseTransformString=function(t){var e,r,n;if(t){var a=N.transformSeparatorRegex;if(0<=t.trim().indexOf("matrix")){var i=N.transformStringToMatrix(t),s=N.decomposeMatrix(i);e=[s.translateX,s.translateY],n=[s.scaleX,s.scaleY],r=[s.rotation];var o=[];0===e[0]&&0===e[1]||o.push("translate("+e+")"),1===n[0]&&1===n[1]||o.push("scale("+n+")"),0!==r[0]&&o.push("rotate("+r+")"),t=o.join(" ")}else{var c=t.match(/translate\((.*?)\)/);c&&(e=c[1].split(a));var l=t.match(/rotate\((.*?)\)/);l&&(r=l[1].split(a));var u=t.match(/scale\((.*?)\)/);u&&(n=u[1].split(a))}}var h=n&&n[0]?parseFloat(n[0]):1;return{value:t,translate:{tx:e&&e[0]?parseInt(e[0],10):0,ty:e&&e[1]?parseInt(e[1],10):0},rotate:{angle:r&&r[0]?parseInt(r[0],10):0,cx:r&&r[1]?parseInt(r[1],10):void 0,cy:r&&r[2]?parseInt(r[2],10):void 0},scale:{sx:h,sy:n&&n[1]?parseFloat(n[1]):h}}},N.deltaTransformPoint=function(t,e){return{x:e.x*t.a+e.y*t.c+0,y:e.x*t.b+e.y*t.d+0}},N.decomposeMatrix=function(t){var e=N.deltaTransformPoint(t,{x:0,y:1}),r=N.deltaTransformPoint(t,{x:1,y:0}),n=180/v*i(e.y,e.x)-90,a=180/v*i(r.y,r.x);return{translateX:t.e,translateY:t.f,scaleX:s(t.a*t.a+t.b*t.b),scaleY:s(t.c*t.c+t.d*t.d),skewX:n,skewY:a,rotation:n}},N.matrixToScale=function(t){var e,r,n,a;return t?(e=N.isUndefined(t.a)?1:t.a,a=N.isUndefined(t.d)?1:t.d,r=t.b,n=t.c):e=a=1,{sx:r?s(e*e+r*r):e,sy:n?s(n*n+a*a):a}},N.matrixToRotate=function(t){var e={x:0,y:1};return t&&(e=N.deltaTransformPoint(t,e)),{angle:g.normalizeAngle(g.toDeg(i(e.y,e.x))-90)}},N.matrixToTranslate=function(t){return{tx:t&&t.e||0,ty:t&&t.f||0}},N.isV=function(t){return t instanceof N},N.isVElement=N.isV,N.isSVGGraphicsElement=function(t){return!!t&&((t=N.toNode(t))instanceof SVGElement&&"function"==typeof t.getScreenCTM)};var d=N("svg").node;return N.createSVGMatrix=function(t){var e=d.createSVGMatrix();for(var r in t)e[r]=t[r];return e},N.createSVGTransform=function(t){return N.isUndefined(t)?d.createSVGTransform():(t instanceof SVGMatrix||(t=N.createSVGMatrix(t)),d.createSVGTransformFromMatrix(t))},N.createSVGPoint=function(t,e){var r=d.createSVGPoint();return r.x=t,r.y=e,r},N.transformRect=function(t,e){var r=d.createSVGPoint();r.x=t.x,r.y=t.y;var n=r.matrixTransform(e);r.x=t.x+t.width,r.y=t.y;var a=r.matrixTransform(e);r.x=t.x+t.width,r.y=t.y+t.height;var i=r.matrixTransform(e);r.x=t.x,r.y=t.y+t.height;var s=r.matrixTransform(e),o=h(n.x,a.x,i.x,s.x),c=f(n.x,a.x,i.x,s.x),l=h(n.y,a.y,i.y,s.y),u=f(n.y,a.y,i.y,s.y);return new g.Rect(o,l,c-o,u-l)},N.transformPoint=function(t,e){return new g.Point(N.createSVGPoint(t.x,t.y).matrixTransform(e))},N.transformLine=function(t,e){return new g.Line(N.transformPoint(t.start,e),N.transformPoint(t.end,e))},N.transformPolyline=function(t,e){var r=t instanceof g.Polyline?t.points:t;N.isArray(r)||(r=[]);for(var n=[],a=0,i=r.length;a<i;a++)n[a]=N.transformPoint(r[a],e);return new g.Polyline(n)},N.styleToObject=function(t){for(var e={},r=t.split(";"),n=0;n<r.length;n++){var a=r[n].split("=");e[a[0].trim()]=a[1].trim()}return e},N.createSlicePathData=function(t,e,r,n){var a=2*v-1e-6,i=t,s=e,o=r,c=n,l=(c<o&&(l=o,o=c,c=l),c-o),u=l<v?"0":"1",h=p(o),f=x(o),d=p(c),m=x(c);return a<=l?i?"M0,"+s+"A"+s+","+s+" 0 1,1 0,"+-s+"A"+s+","+s+" 0 1,1 0,"+s+"M0,"+i+"A"+i+","+i+" 0 1,0 0,"+-i+"A"+i+","+i+" 0 1,0 0,"+i+"Z":"M0,"+s+"A"+s+","+s+" 0 1,1 0,"+-s+"A"+s+","+s+" 0 1,1 0,"+s+"Z":i?"M"+s*h+","+s*f+"A"+s+","+s+" 0 "+u+",1 "+s*d+","+s*m+"L"+i*d+","+i*m+"A"+i+","+i+" 0 "+u+",0 "+i*h+","+i*f+"Z":"M"+s*h+","+s*f+"A"+s+","+s+" 0 "+u+",1 "+s*d+","+s*m+"L0,0Z"},N.mergeAttrs=function(t,e){for(var r in e)"class"===r?t[r]=t[r]?t[r]+" "+e[r]:e[r]:"style"===r?N.isObject(t[r])&&N.isObject(e[r])?t[r]=N.mergeAttrs(t[r],e[r]):N.isObject(t[r])?t[r]=N.mergeAttrs(t[r],N.styleToObject(e[r])):N.isObject(e[r])?t[r]=N.mergeAttrs(N.styleToObject(t[r]),e[r]):t[r]=N.mergeAttrs(N.styleToObject(t[r]),N.styleToObject(e[r])):t[r]=e[r];return t},N.annotateString=function(t,e,r){e=e||[];for(var n,a,i,s=(r=r||{}).offset||0,o=[],c=[],l=0;l<t.length;l++){a=c[l]=t[l];for(var u=0;u<e.length;u++){var h=e[u],f=h.start+s,d=h.end+s;f<=l&&l<d&&(N.isObject(a)?a.attrs=N.mergeAttrs(N.mergeAttrs({},a.attrs),h.attrs):a=c[l]={t:t[l],attrs:h.attrs},r.includeAnnotationIndices&&(a.annotations||(a.annotations=[])).push(u))}(i=c[l-1])?N.isObject(a)&&N.isObject(i)?JSON.stringify(a.attrs)===JSON.stringify(i.attrs)?n.t+=a.t:(o.push(n),n=a):n=N.isObject(a)?(o.push(n),a):N.isObject(i)?(o.push(n),a):(n||"")+a:n=a}return n&&o.push(n),o},N.findAnnotationsAtIndex=function(t,e){var r=[];return t&&t.forEach(function(t){t.start<e&&e<=t.end&&r.push(t)}),r},N.findAnnotationsBetweenIndexes=function(t,e,r){var n=[];return t&&t.forEach(function(t){(e>=t.start&&e<t.end||r>t.start&&r<=t.end||t.start>=e&&t.end<r)&&n.push(t)}),n},N.shiftAnnotations=function(t,e,r){return t&&t.forEach(function(t){t.start<e&&t.end>=e?t.end+=r:t.start>=e&&(t.start+=r,t.end+=r)}),t},N.convertLineToPathData=function(t){return["M",(t=N(t)).attr("x1"),t.attr("y1"),"L",t.attr("x2"),t.attr("y2")].join(" ")},N.convertPolygonToPathData=function(t){var e=N.getPointsFromSvgNode(t);return 0===e.length?null:N.svgPointsToPath(e)+" Z"},N.convertPolylineToPathData=function(t){var e=N.getPointsFromSvgNode(t);return 0===e.length?null:N.svgPointsToPath(e)},N.svgPointsToPath=function(t){for(var e=0,r=t.length;e<r;e++)t[e]=t[e].x+" "+t[e].y;return"M "+t.join(" L")},N.getPointsFromSvgNode=function(t){var e=[],r=(t=N.toNode(t)).points;if(r)for(var n=0,a=r.numberOfItems;n<a;n++)e.push(r.getItem(n));return e},N.KAPPA=.551784,N.convertCircleToPathData=function(t){t=N(t);var e=parseFloat(t.attr("cx"))||0,r=parseFloat(t.attr("cy"))||0,n=parseFloat(t.attr("r")),a=n*N.KAPPA;return["M",e,r-n,"C",e+a,r-n,e+n,r-a,e+n,r,"C",e+n,r+a,e+a,r+n,e,r+n,"C",e-a,r+n,e-n,r+a,e-n,r,"C",e-n,r-a,e-a,r-n,e,r-n,"Z"].join(" ")},N.convertEllipseToPathData=function(t){t=N(t);var e=parseFloat(t.attr("cx"))||0,r=parseFloat(t.attr("cy"))||0,n=parseFloat(t.attr("rx")),a=parseFloat(t.attr("ry"))||n,i=n*N.KAPPA,s=a*N.KAPPA;return["M",e,r-a,"C",e+i,r-a,e+n,r-s,e+n,r,"C",e+n,r+s,e+i,r+a,e,r+a,"C",e-i,r+a,e-n,r+s,e-n,r,"C",e-n,r-s,e-i,r-a,e,r-a,"Z"].join(" ")},N.convertRectToPathData=function(t){return t=N(t),N.rectToPath({x:parseFloat(t.attr("x"))||0,y:parseFloat(t.attr("y"))||0,width:parseFloat(t.attr("width"))||0,height:parseFloat(t.attr("height"))||0,rx:parseFloat(t.attr("rx"))||0,ry:parseFloat(t.attr("ry"))||0})},N.rectToPath=function(t){var e=t.x,r=t.y,n=t.width,a=t.height,i=h(t.rx||t["top-rx"]||0,n/2),s=h(t.rx||t["bottom-rx"]||0,n/2),o=h(t.ry||t["top-ry"]||0,a/2),c=h(t.ry||t["bottom-ry"]||0,a/2);return(i||s||o||c?["M",e,r+o,"v",a-o-c,"a",s,c,0,0,0,s,c,"h",n-2*s,"a",s,c,0,0,0,s,-c,"v",-(a-c-o),"a",i,o,0,0,0,-i,-o,"h",-(n-2*i),"a",i,o,0,0,0,-i,o,"Z"]:["M",e,r,"H",e+n,"V",r+a,"H",e,"V",r,"Z"]).join(" ")},N.normalizePathData=function(){var t="\t\n\v\f\r   ᠎             　\u2028\u2029",v=new RegExp("([a-z])["+t+",]*((-?\\d*\\.?\\d*(?:e[\\-+]?\\d+)?["+t+"]*,?["+t+"]*)+)","ig"),g=new RegExp("(-?\\d*\\.?\\d*(?:e[\\-+]?\\d+)?)["+t+"]*,?["+t+"]*","ig"),e=Math,U=e.PI,Y=e.sin,X=e.cos,Z=e.tan,K=e.asin,W=e.sqrt,$=e.abs;function f(t,e,r,n,a,i){return[1/3*t+2/3*r,1/3*e+2/3*n,1/3*a+2/3*r,1/3*i+2/3*n,a,i]}function d(t){if(Array.isArray(t)&&Array.isArray(t&&t[0])||(t=function(t){if(!t)return null;var i={a:7,c:6,h:1,l:2,m:2,q:4,s:4,t:2,v:1,z:0},s=[];return String(t).replace(v,function(t,e,r){var n=[],a=e.toLowerCase();for(r.replace(g,function(t,e){e&&n.push(+e)}),"m"===a&&2<n.length&&(s.push([e].concat(n.splice(0,2))),a="l",e="m"===e?"l":"L");n.length>=i[a]&&(s.push([e].concat(n.splice(0,i[a]))),i[a]););}),s}(t)),!t||!t.length)return[["M",0,0]];for(var e,r=[],n=0,a=0,i=0,s=0,o=t.length,c=0;c<o;c++){var l=[];r.push(l);var u,h,f=t[c];if((e=f[0])!=e.toUpperCase())switch(l[0]=e.toUpperCase(),l[0]){case"A":l[1]=f[1],l[2]=f[2],l[3]=f[3],l[4]=f[4],l[5]=f[5],l[6]=+f[6]+n,l[7]=+f[7]+a;break;case"V":l[1]=+f[1]+a;break;case"H":l[1]=+f[1]+n;break;case"M":for(i=+f[1]+n,s=+f[2]+a,u=f.length,h=1;h<u;h++)l[h]=+f[h]+(h%2?n:a);break;default:for(u=f.length,h=1;h<u;h++)l[h]=+f[h]+(h%2?n:a)}else for(var d=f.length,m=0;m<d;m++)l[m]=f[m];switch(l[0]){case"Z":n=+i,a=+s;break;case"H":n=l[1];break;case"V":a=l[1];break;case"M":i=l[l.length-2],s=l[l.length-1],n=l[l.length-2],a=l[l.length-1];break;default:n=l[l.length-2],a=l[l.length-1]}}return r}function r(t){var n=d(t),e={x:0,y:0,bx:0,by:0,X:0,Y:0,qx:null,qy:null};function r(t,e,r){var n,a;if(!t)return["C",e.x,e.y,e.x,e.y,e.x,e.y];switch(t[0]in{T:1,Q:1}||(e.qx=null,e.qy=null),t[0]){case"M":e.X=t[1],e.Y=t[2];break;case"A":t=["C"].concat(function t(e,r,n,a,i,s,o,c,l,u){var h,f=120*U/180,d=U/180*(+i||0),m=[],v=function(t,e,r){return{x:t*X(r)-e*Y(r),y:t*Y(r)+e*X(r)}};if(u)A=u[0],S=u[1],P=u[2],w=u[3];else{e=(h=v(e,r,-d)).x,r=h.y;var g=(e-(c=(h=v(c,l,-d)).x))/2,p=(r-(l=h.y))/2,x=g*g/(n*n)+p*p/(a*a);1<x&&(n*=x=W(x),a*=x);var y=n*n,T=a*a,b=(s==o?-1:1)*W($((y*T-y*p*p-T*g*g)/(y*p*p+T*g*g))),P=b*n*p/a+(e+c)/2,w=b*-a*g/n+(r+l)/2,A=K(((r-w)/a).toFixed(9)),S=K(((l-w)/a).toFixed(9));(A=e<P?U-A:A)<0&&(A=2*U+A),(S=c<P?U-S:S)<0&&(S=2*U+S),S<(o&&A)&&(A-=2*U),A<(!o&&S)&&(S-=2*U)}var F=S-A;if($(F)>f){var C=S,E=c,N=l;m=t(c=P+n*X(S=A+f*(A<(o&&S)?1:-1)),l=w+a*Y(S),n,a,i,0,o,E,N,[S,C,P,w])}F=S-A;var V=X(A),L=Y(A),M=X(S),G=Y(S),O=Z(F/4),k=4/3*(n*O),I=4/3*(a*O),R=[e,r],j=[e+k*L,r-I*V],D=[c+k*G,l-I*M],B=[c,l];if(j[0]=2*R[0]-j[0],j[1]=2*R[1]-j[1],u)return[j,D,B].concat(m);for(var q=[],z=(m=[j,D,B].concat(m).join().split(",")).length,H=0;H<z;H++)q[H]=H%2?v(m[H-1],m[H],d).y:v(m[H],m[H+1],d).x;return q}.apply(0,[e.x,e.y].concat(t.slice(1))));break;case"S":a="C"===r||"S"===r?(n=2*e.x-e.bx,2*e.y-e.by):(n=e.x,e.y),t=["C",n,a].concat(t.slice(1));break;case"T":e.qy="Q"===r||"T"===r?(e.qx=2*e.x-e.qx,2*e.y-e.qy):(e.qx=e.x,e.y),t=["C"].concat(f(e.x,e.y,e.qx,e.qy,t[1],t[2]));break;case"Q":e.qx=t[1],e.qy=t[2],t=["C"].concat(f(e.x,e.y,t[1],t[2],t[3],t[4]));break;case"H":t=["L"].concat(t[1],e.y);break;case"V":t=["L"].concat(e.x,t[1])}return t}function a(t,e){if(7<t[e].length){t[e].shift();for(var r=t[e];r.length;)i[e]="A",t.splice(e++,0,["C"].concat(r.splice(0,6)));t.splice(e,1),c=n.length}}for(var i=[],s="",o="",c=n.length,l=0;l<c;l++){n[l]&&(s=n[l][0]),"C"!==s&&(i[l]=s,0<l&&(o=i[l-1])),n[l]=r(n[l],e,o),"A"!==i[l]&&"C"===s&&(i[l]="C"),a(n,l);var u=n[l],h=u.length;e.x=u[h-2],e.y=u[h-1],e.bx=parseFloat(u[h-4])||e.x,e.by=parseFloat(u[h-3])||e.y}return n[0][0]&&"M"===n[0][0]||n.unshift(["M",0,0]),n}return function(t){return r(t).join(",").split(",").join(" ")}}(),N.namespace=c,N}();
var joint={version:"2.2.1",config:{classNamePrefix:"joint-",defaultTheme:"default"},dia:{},ui:{},layout:{},shapes:{},format:{},connectors:{},highlighters:{},routers:{},anchors:{},connectionPoints:{},connectionStrategies:{},linkTools:{},mvc:{views:{}},setTheme:function(t,e){e=e||{},joint.util.invoke(joint.mvc.views,"setTheme",t,e),joint.mvc.View.prototype.defaultTheme=t},env:{_results:{},_tests:{svgforeignobject:function(){return!!document.createElementNS&&/SVGForeignObject/.test({}.toString.call(document.createElementNS("http://www.w3.org/2000/svg","foreignObject")))}},addTest:function(t,e){return joint.env._tests[t]=e},test:function(t){var e=joint.env._tests[t];if(!e)throw new Error('Test not defined ("'+t+'"). Use `joint.env.addTest(name, fn) to add a new test.`');var i=joint.env._results[t];if(void 0!==i)return i;try{i=e()}catch(t){i=!1}return joint.env._results[t]=i}},util:{hashCode:function(t){var e=0;if(0==t.length)return e;for(var i=0;i<t.length;i++){e=(e<<5)-e+t.charCodeAt(i),e&=e}return e},getByPath:function(t,e,i){for(var n,r=Array.isArray(e)?e.slice():e.split(i||"/");r.length;){if(n=r.shift(),!(Object(t)===t&&n in t))return;t=t[n]}return t},setByPath:function(t,e,i,n){for(var r=Array.isArray(e)?e:e.split(n||"/"),o=t,s=0,a=r.length;s<a-1;s++)o=o[r[s]]||(o[r[s]]={});return o[r[a-1]]=i,t},unsetByPath:function(t,e,i){i=i||"/";var n=Array.isArray(e)?e.slice():e.split(i),r=n.pop();if(0<n.length){var o=joint.util.getByPath(t,n,i);o&&delete o[r]}else delete t[r];return t},flattenObject:function(t,e,i){e=e||"/";var n={};for(var r in t)if(t.hasOwnProperty(r)){var o="object"==typeof t[r];if(o&&i&&i(t[r])&&(o=!1),o){var s=this.flattenObject(t[r],e,i);for(var a in s)s.hasOwnProperty(a)&&(n[r+e+a]=s[a])}else n[r]=t[r]}return n},uuid:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(t){var e=16*Math.random()|0;return("x"===t?e:3&e|8).toString(16)})},guid:function(t){return this.guid.id=this.guid.id||1,t.id=void 0===t.id?"j_"+this.guid.id++:t.id,t.id},toKebabCase:function(t){return t.replace(/[A-Z]/g,"-$&").toLowerCase()},normalizeEvent:function(t){var e=t,i=t.originalEvent&&t.originalEvent.changedTouches&&t.originalEvent.changedTouches[0];if(i){for(var n in t)void 0===i[n]&&(i[n]=t[n]);e=i}var r=e.target;if(r){var o=r.correspondingUseElement;o&&(e.target=o)}return e},nextFrame:function(){var i;if("undefined"!=typeof window&&(i=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame),!i){var r=0;i=function(t){var e=(new Date).getTime(),i=Math.max(0,16-(e-r)),n=setTimeout(function(){t(e+i)},i);return r=e+i,n}}return function(t,e){return i(e?t.bind(e):t)}}(),cancelFrame:function(){var t,e="undefined"!=typeof window;return e&&(t=window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.webkitCancelRequestAnimationFrame||window.msCancelAnimationFrame||window.msCancelRequestAnimationFrame||window.oCancelAnimationFrame||window.oCancelRequestAnimationFrame||window.mozCancelAnimationFrame||window.mozCancelRequestAnimationFrame),t=t||clearTimeout,e?t.bind(window):t}(),shapePerimeterConnectionPoint:function(t,e,i,n){var r,o;if(!i){var s=e.$(".scalable")[0],a=e.$(".rotatable")[0];s&&s.firstChild?i=s.firstChild:a&&a.firstChild&&(i=a.firstChild)}return i?(o=V(i).findIntersection(n,t.paper.viewport))||(r=V(i).getBBox({target:t.paper.viewport})):o=(r=e.model.getBBox()).intersectionWithLineFromCenterToPoint(n),o||r.center()},isPercentage:function(t){return joint.util.isString(t)&&"%"===t.slice(-1)},parseCssNumeric:function(t,e){var i=parseFloat(t);if(Number.isNaN(i))return null;var n,r={};if(r.value=i,null==e)n="[A-Za-z]*";else if(Array.isArray(e)){if(0===e.length)return null;n=e.join("|")}else joint.util.isString(e)&&(n=e);var o,s=(o=new RegExp("(?:\\d+(?:\\.\\d+)*)("+n+")$").exec(t))?o[1]:null;return null===s?null:(r.unit=s,r)},breakText:function(t,e,i,n){n=n||{},i=i||{};var r=e.width,o=e.height,s=n.svgDocument||V("svg").node,a=V("tspan").node,l=V("text").attr(i).append(a).node,h=document.createTextNode("");l.style.opacity=0,l.style.display="block",a.style.display="block",a.appendChild(h),s.appendChild(l),n.svgDocument||document.body.appendChild(s);for(var u,c,d=n.separator||" ",f=n.eol||"\n",g=t.split(d),p=[],m=[],v=0,y=0,b=g.length;v<b;v++){var w=g[v];if(w)if(f&&0<=w.indexOf(f))if(1<w.length){for(var x=w.split(f),k=0,A=x.length-1;k<A;k++)x.splice(2*k+1,0,f);Array.prototype.splice.apply(g,[v,1].concat(x)),v--,b+=x.length-1}else y++;else{if(h.data=m[y]?m[y]+" "+w:w,a.getComputedTextLength()<=r)m[y]=h.data,u&&(p[y++]=!0,u=0);else{if(!m[y]||u){var j=!!u;if(u=w.length-1,j||!u){if(!u){if(!m[y]){m=[];break}g.splice(v,2,w+g[v+1]),b--,p[y++]=!0,v--;continue}g[v]=w.substring(0,u),g[v+1]=w.substring(u)+g[v+1]}else g.splice(v,1,w.substring(0,u),w.substring(u)),b++,y&&!p[y-1]&&y--;v--;continue}y++,v--}if(void 0!==o){var P;if(void 0===c)c=(P="auto"===i.lineHeight?{value:1.5,unit:"em"}:joint.util.parseCssNumeric(i.lineHeight,["em"])||{value:1,unit:"em"}).value,"em"===P.unit&&(c*=l.getBBox().height);if(c*m.length>o){var C=Math.floor(o/c)-1;m.splice(C+1);var E=n.ellipsis;if(!E||C<0)break;"string"!=typeof E&&(E="…");var M,_,S=m[C],B=S.length;do{if(_=S[B],M=S.substring(0,B),_?_.match(d)&&(M+=_):M+="string"==typeof d?d:" ",M+=E,h.data=M,a.getComputedTextLength()<=r){m[C]=M;break}B--}while(0<=B);break}}}}return n.svgDocument?s.removeChild(l):document.body.removeChild(s),m.join(f)},sanitizeHTML:function(t){var e=$($.parseHTML("<div>"+t+"</div>",null,!1));return e.find("*").each(function(){var i=this;$.each(i.attributes,function(){var t=this.name,e=this.value;0!==t.indexOf("on")&&0!==e.indexOf("javascript:")||$(i).removeAttr(t)})}),e.html()},downloadBlob:function(t,e){if(window.navigator.msSaveBlob)window.navigator.msSaveBlob(t,e);else{var i=window.URL.createObjectURL(t),n=document.createElement("a");n.href=i,n.download=e,document.body.appendChild(n),n.click(),document.body.removeChild(n),window.URL.revokeObjectURL(i)}},downloadDataUri:function(t,e){var i=joint.util.dataUriToBlob(t);joint.util.downloadBlob(i,e)},dataUriToBlob:function(t){t=t.replace(/\s/g,"");var e,i=(t=decodeURIComponent(t)).indexOf(","),n=t.slice(0,i),r=n.split(":")[1].split(";")[0],o=t.slice(i+1);e=0<=n.indexOf("base64")?atob(o):unescape(encodeURIComponent(o));for(var s=new Uint8Array(e.length),a=0;a<e.length;a++)s[a]=e.charCodeAt(a);return new Blob([s],{type:r})},imageToDataUri:function(r,t){if(!r||"data:"===r.substr(0,"data:".length))return setTimeout(function(){t(null,r)},0);var e=new XMLHttpRequest;e.open("GET",r,!0),e.addEventListener("error",function(){t(new Error("Failed to load image "+r))}),e.responseType=window.FileReader?"blob":"arraybuffer",e.addEventListener("load",function(){window.FileReader?function(t,i){if(200===t.status){var e=new FileReader;e.onload=function(t){var e=t.target.result;i(null,e)},e.onerror=function(){i(new Error("Failed to load image "+r))},e.readAsDataURL(t.response)}else i(new Error("Failed to load image "+r))}(e,t):function(t,e){if(200===t.status){var i=new Uint8Array(t.response),n=r.split(".").pop()||"png";e(null,"data:image/"+({svg:"svg+xml"}[n]||n)+";base64,"+btoa(function(t){for(var e=[],i=0;i<t.length;i+=32768)e.push(String.fromCharCode.apply(null,t.subarray(i,i+32768)));return e.join("")}(i)))}else e(new Error("Failed to load image "+r))}(e,t)}),e.send()},getElementBBox:function(t){var e=$(t);if(0===e.length)throw new Error("Element not found");var i=e[0],n=i.ownerDocument,r=i.getBoundingClientRect(),o=0,s=0;if(i.ownerSVGElement){var a=V(i),l=a.getBBox({target:a.svg()});o=r.width-l.width,s=r.height-l.height}return{x:r.left+window.pageXOffset-n.documentElement.offsetLeft+o/2,y:r.top+window.pageYOffset-n.documentElement.offsetTop+s/2,width:r.width-o,height:r.height-s}},sortElements:function(t,e){var i=$(t),n=i.map(function(){var t=this.parentNode,e=t.insertBefore(document.createTextNode(""),this.nextSibling);return function(){if(t===this)throw new Error("You can't sort elements if any one is a descendant of another.");t.insertBefore(this,e),t.removeChild(e)}});return Array.prototype.sort.call(i,e).each(function(t){n[t].call(this)})},setAttributesBySelector:function(t,e){var n=$(t);joint.util.forIn(e,function(t,e){var i=n.find(e).addBack().filter(e);joint.util.has(t,"class")&&(i.addClass(t.class),t=joint.util.omit(t,"class")),i.attr(t)})},normalizeSides:function(t){if(Object(t)===t)return e=i=n=r=0,isFinite(t.vertical)&&(e=n=+t.vertical),isFinite(t.horizontal)&&(i=r=+t.horizontal),isFinite(t.top)&&(e=+t.top),isFinite(t.right)&&(i=+t.right),isFinite(t.bottom)&&(n=+t.bottom),isFinite(t.left)&&(r=+t.left),{top:e,right:i,bottom:n,left:r};var e,i,n,r,o=0;return isFinite(t)&&(o=+t),{top:o,right:o,bottom:o,left:o}},timing:{linear:function(t){return t},quad:function(t){return t*t},cubic:function(t){return t*t*t},inout:function(t){if(t<=0)return 0;if(1<=t)return 1;var e=t*t,i=e*t;return 4*(t<.5?i:3*(t-e)+i-.75)},exponential:function(t){return Math.pow(2,10*(t-1))},bounce:function(t){for(var e=0,i=1;;e+=i,i/=2)if((7-4*e)/11<=t){var n=(11-6*e-11*t)/4;return-n*n+i*i}},reverse:function(e){return function(t){return 1-e(1-t)}},reflect:function(e){return function(t){return.5*(t<.5?e(2*t):2-e(2-2*t))}},clamp:function(i,n,r){return n=n||0,r=r||1,function(t){var e=i(t);return e<n?n:r<e?r:e}},back:function(e){return e||(e=1.70158),function(t){return t*t*((e+1)*t-e)}},elastic:function(e){return e||(e=1.5),function(t){return Math.pow(2,10*(t-1))*Math.cos(20*Math.PI*e/3*t)}}},interpolate:{number:function(e,t){var i=t-e;return function(t){return e+i*t}},object:function(r,o){var s=Object.keys(r);return function(t){var e,i,n={};for(e=s.length-1;-1!=e;e--)n[i=s[e]]=r[i]+(o[i]-r[i])*t;return n}},hexColor:function(t,e){var i=parseInt(t.slice(1),16),n=parseInt(e.slice(1),16),r=255&i,o=(255&n)-r,s=65280&i,a=(65280&n)-s,l=16711680&i,h=(16711680&n)-l;return function(t){return"#"+(1<<24|r+o*t&255|s+a*t&65280|l+h*t&16711680).toString(16).slice(1)}},unit:function(e,t){var i=/(-?[0-9]*.[0-9]*)(px|em|cm|mm|in|pt|pc|%)/,n=i.exec(e),r=i.exec(t),o=r[1].indexOf("."),s=0<o?r[1].length-o-1:0;e=+n[1];var a=+r[1]-e,l=n[2];return function(t){return(e+a*t).toFixed(s)+l}}},filter:{outline:function(t){var e=Number.isFinite(t.margin)?t.margin:2,i=Number.isFinite(t.width)?t.width:1;return joint.util.template('<filter><feFlood flood-color="${color}" flood-opacity="${opacity}" result="colored"/><feMorphology in="SourceAlpha" result="morphedOuter" operator="dilate" radius="${outerRadius}" /><feMorphology in="SourceAlpha" result="morphedInner" operator="dilate" radius="${innerRadius}" /><feComposite result="morphedOuterColored" in="colored" in2="morphedOuter" operator="in"/><feComposite operator="xor" in="morphedOuterColored" in2="morphedInner" result="outline"/><feMerge><feMergeNode in="outline"/><feMergeNode in="SourceGraphic"/></feMerge></filter>')({color:t.color||"blue",opacity:Number.isFinite(t.opacity)?t.opacity:1,outerRadius:e+i,innerRadius:e})},highlight:function(t){return joint.util.template('<filter><feFlood flood-color="${color}" flood-opacity="${opacity}" result="colored"/><feMorphology result="morphed" in="SourceGraphic" operator="dilate" radius="${width}"/><feComposite result="composed" in="colored" in2="morphed" operator="in"/><feGaussianBlur result="blured" in="composed" stdDeviation="${blur}"/><feBlend in="SourceGraphic" in2="blured" mode="normal"/></filter>')({color:t.color||"red",width:Number.isFinite(t.width)?t.width:1,blur:Number.isFinite(t.blur)?t.blur:0,opacity:Number.isFinite(t.opacity)?t.opacity:1})},blur:function(t){var e=Number.isFinite(t.x)?t.x:2;return joint.util.template('<filter><feGaussianBlur stdDeviation="${stdDeviation}"/></filter>')({stdDeviation:Number.isFinite(t.y)?[e,t.y]:e})},dropShadow:function(t){var e="SVGFEDropShadowElement"in window?'<filter><feDropShadow stdDeviation="${blur}" dx="${dx}" dy="${dy}" flood-color="${color}" flood-opacity="${opacity}"/></filter>':'<filter><feGaussianBlur in="SourceAlpha" stdDeviation="${blur}"/><feOffset dx="${dx}" dy="${dy}" result="offsetblur"/><feFlood flood-color="${color}"/><feComposite in2="offsetblur" operator="in"/><feComponentTransfer><feFuncA type="linear" slope="${opacity}"/></feComponentTransfer><feMerge><feMergeNode/><feMergeNode in="SourceGraphic"/></feMerge></filter>';return joint.util.template(e)({dx:t.dx||0,dy:t.dy||0,opacity:Number.isFinite(t.opacity)?t.opacity:1,color:t.color||"black",blur:Number.isFinite(t.blur)?t.blur:4})},grayscale:function(t){var e=Number.isFinite(t.amount)?t.amount:1;return joint.util.template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 0 ${d} ${e} ${f} 0 0 ${g} ${b} ${h} 0 0 0 0 0 1 0"/></filter>')({a:.2126+.7874*(1-e),b:.7152-.7152*(1-e),c:.0722-.0722*(1-e),d:.2126-.2126*(1-e),e:.7152+.2848*(1-e),f:.0722-.0722*(1-e),g:.2126-.2126*(1-e),h:.0722+.9278*(1-e)})},sepia:function(t){var e=Number.isFinite(t.amount)?t.amount:1;return joint.util.template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 0 ${d} ${e} ${f} 0 0 ${g} ${h} ${i} 0 0 0 0 0 1 0"/></filter>')({a:.393+.607*(1-e),b:.769-.769*(1-e),c:.189-.189*(1-e),d:.349-.349*(1-e),e:.686+.314*(1-e),f:.168-.168*(1-e),g:.272-.272*(1-e),h:.534-.534*(1-e),i:.131+.869*(1-e)})},saturate:function(t){var e=Number.isFinite(t.amount)?t.amount:1;return joint.util.template('<filter><feColorMatrix type="saturate" values="${amount}"/></filter>')({amount:1-e})},hueRotate:function(t){return joint.util.template('<filter><feColorMatrix type="hueRotate" values="${angle}"/></filter>')({angle:t.angle||0})},invert:function(t){var e=Number.isFinite(t.amount)?t.amount:1;return joint.util.template('<filter><feComponentTransfer><feFuncR type="table" tableValues="${amount} ${amount2}"/><feFuncG type="table" tableValues="${amount} ${amount2}"/><feFuncB type="table" tableValues="${amount} ${amount2}"/></feComponentTransfer></filter>')({amount:e,amount2:1-e})},brightness:function(t){return joint.util.template('<filter><feComponentTransfer><feFuncR type="linear" slope="${amount}"/><feFuncG type="linear" slope="${amount}"/><feFuncB type="linear" slope="${amount}"/></feComponentTransfer></filter>')({amount:Number.isFinite(t.amount)?t.amount:1})},contrast:function(t){var e=Number.isFinite(t.amount)?t.amount:1;return joint.util.template('<filter><feComponentTransfer><feFuncR type="linear" slope="${amount}" intercept="${amount2}"/><feFuncG type="linear" slope="${amount}" intercept="${amount2}"/><feFuncB type="linear" slope="${amount}" intercept="${amount2}"/></feComponentTransfer></filter>')({amount:e,amount2:.5-e/2})}},format:{number:function(t,e,o){o=o||{currency:["$",""],decimal:".",thousands:",",grouping:[3]};var i=/(?:([^{])?([<>=^]))?([+\- ])?([$#])?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i.exec(t),n=i[1]||" ",r=i[2]||">",s=i[3]||"",a=i[4]||"",l=i[5],h=+i[6],u=i[7],c=i[8],d=i[9],f=1,g="",p="",m=!1;switch(c&&(c=+c.substring(1)),(l||"0"===n&&"="===r)&&(l=n="0",r="=",u&&(h-=Math.floor((h-1)/4))),d){case"n":u=!0,d="g";break;case"%":f=100,p="%",d="f";break;case"p":f=100,p="%",d="r";break;case"b":case"o":case"x":case"X":"#"===a&&(g="0"+d.toLowerCase());break;case"c":case"d":m=!0,c=0;break;case"s":f=-1,d="r"}"$"===a&&(g=o.currency[0],p=o.currency[1]),"r"!=d||c||(d="g"),null!=c&&("g"==d?c=Math.max(1,Math.min(21,c)):"e"!=d&&"f"!=d||(c=Math.max(0,Math.min(20,c))));var v=l&&u;if(m&&e%1)return"";var y=e<0||0===e&&1/e<0?(e=-e,"-"):s,b=p;if(f<0){var w=this.prefix(e,c);e=w.scale(e),b=w.symbol+p}else e*=f;var x=(e=this.convert(d,e,c)).lastIndexOf("."),k=x<0?e:e.substring(0,x),A=x<0?"":o.decimal+e.substring(x+1);function j(t){for(var e=t.length,i=[],n=0,r=o.grouping[0];0<e&&0<r;)i.push(t.substring(e-=r,e+r)),r=o.grouping[n=(n+1)%o.grouping.length];return i.reverse().join(o.thousands)}!l&&u&&o.grouping&&(k=j(k));var P=g.length+k.length+A.length+(v?0:y.length),C=P<h?new Array(P=h-P+1).join(n):"";return v&&(k=j(C+k)),y+=g,e=k+A,("<"===r?y+e+C:">"===r?C+y+e:"^"===r?C.substring(0,P>>=1)+y+e+C.substring(P):y+(v?e:C+e))+b},string:function(t,e){for(var i,n="{",r=!1,o=[];-1!==(i=t.indexOf(n));){var s,a,l;if(s=t.slice(0,i),r){l=(a=s.split(":")).shift().split("."),s=e;for(var h=0;h<l.length;h++)s=s[l[h]];a.length&&(s=this.number(a,s))}o.push(s),t=t.slice(i+1),n=(r=!r)?"}":"{"}return o.push(t),o.join("")},convert:function(t,e,i){switch(t){case"b":return e.toString(2);case"c":return String.fromCharCode(e);case"o":return e.toString(8);case"x":return e.toString(16);case"X":return e.toString(16).toUpperCase();case"g":return e.toPrecision(i);case"e":return e.toExponential(i);case"f":return e.toFixed(i);case"r":return(e=this.round(e,this.precision(e,i))).toFixed(Math.max(0,Math.min(20,this.precision(e*(1+1e-15),i))));default:return e+""}},round:function(t,e){return e?Math.round(t*(e=Math.pow(10,e)))/e:Math.round(t)},precision:function(t,e){return e-(t?Math.ceil(Math.log(t)/Math.LN10):1)},prefix:function(t,e){var i=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"].map(function(t,e){var i=Math.pow(10,3*Math.abs(8-e));return{scale:8<e?function(t){return t/i}:function(t){return t*i},symbol:t}}),n=0;return t&&(t<0&&(t*=-1),e&&(t=this.round(t,this.precision(t,e))),n=1+Math.floor(1e-12+Math.log(t)/Math.LN10),n=Math.max(-24,Math.min(24,3*Math.floor((n<=0?n+1:n-1)/3)))),i[8+n/3]}},template:function(t){var e=/<%= ([^ ]+) %>|\$\{ ?([^{} ]+) ?\}|\{\{([^{} ]+)\}\}/g;return function(n){return n=n||{},t.replace(e,function(t){for(var e=Array.from(arguments).slice(1,4).find(function(t){return!!t}).split("."),i=n[e.shift()];void 0!==i&&e.length;)i=i[e.shift()];return void 0!==i?i:""})}},toggleFullScreen:function(t){var e=window.top.document;function i(t,e){for(var i=["webkit","moz","ms","o",""],n=0;n<i.length;n++){var r=i[n],o=r?r+e:e.substr(0,1).toLowerCase()+e.substr(1);if(void 0!==t[o])return joint.util.isFunction(t[o])?t[o]():t[o]}}t=t||e.body,i(e,"FullscreenElement")||i(e,"FullScreenElement")?i(e,"ExitFullscreen")||i(e,"CancelFullScreen"):i(t,"RequestFullscreen")||i(t,"RequestFullScreen")},addClassNamePrefix:function(t){return t?t.toString().split(" ").map(function(t){return t.substr(0,joint.config.classNamePrefix.length)!==joint.config.classNamePrefix&&(t=joint.config.classNamePrefix+t),t}).join(" "):t},removeClassNamePrefix:function(t){return t?t.toString().split(" ").map(function(t){return t.substr(0,joint.config.classNamePrefix.length)===joint.config.classNamePrefix&&(t=t.substr(joint.config.classNamePrefix.length)),t}).join(" "):t},wrapWith:function(e,t,i){if(joint.util.isString(i)){if(!joint.util.wrappers[i])throw new Error('Unknown wrapper: "'+i+'"');i=joint.util.wrappers[i]}if(!joint.util.isFunction(i))throw new Error("Wrapper must be a function.");this.toArray(t).forEach(function(t){e[t]=i(e[t])})},wrappers:{cells:function(r){return function(){var t=Array.from(arguments),e=t.length,i=0<e&&t[0]||[],n=1<e&&t[e-1]||{};return Array.isArray(i)||(n instanceof joint.dia.Cell?i=t:i instanceof joint.dia.Cell&&(1<t.length&&t.pop(),i=t)),n instanceof joint.dia.Cell&&(n={}),r.call(this,i,n)}}},parseDOMJSON:function(t,e){for(var i={},n={},r=V.namespace.xmlns,o=e||r,s=document.createDocumentFragment(),a=[t,s,o];0<a.length;){o=a.pop();for(var l=a.pop(),h=a.pop(),u=0,c=h.length;u<c;u++){var d=h[u];if(!d.hasOwnProperty("tagName"))throw new Error("json-dom-parser: missing tagName");var f=d.tagName;d.hasOwnProperty("namespaceURI")&&(o=d.namespaceURI);var g=document.createElementNS(o,f),p=o===r,m=p?V:$,v=d.attributes;v&&m(g).attr(v);var y=d.style;if(y&&$(g).css(y),d.hasOwnProperty("className")){var b=d.className;p?g.className.baseVal=b:g.className=b}if(d.hasOwnProperty("textContent")&&(g.textContent=d.textContent),d.hasOwnProperty("selector")){var w=d.selector;if(i[w])throw new Error("json-dom-parser: selector must be unique");m(i[w]=g).attr("joint-selector",w)}if(d.hasOwnProperty("groupSelector")){var x=d.groupSelector;Array.isArray(x)||(x=[x]);for(var k=0,A=x.length;k<A;k++){var j=x[k],P=n[j];P||(P=n[j]=[]),P.push(g)}}l.appendChild(g);var C=d.children;Array.isArray(C)&&a.push(C,g,o)}}return{fragment:s,selectors:i,groupSelectors:n}},mixin:_.assign,supplement:_.defaults,deepMixin:_.mixin,deepSupplement:_.defaultsDeep,assign:_.assign,defaults:_.defaults,defaultsDeep:_.defaultsDeep,invoke:_.invokeMap||_.invoke,sortedIndex:_.sortedIndexBy||_.sortedIndex,uniq:_.uniqBy||_.uniq,clone:_.clone,cloneDeep:_.cloneDeep,isEmpty:_.isEmpty,isEqual:_.isEqual,isFunction:_.isFunction,isPlainObject:_.isPlainObject,toArray:_.toArray,debounce:_.debounce,groupBy:_.groupBy,sortBy:_.sortBy,flattenDeep:_.flattenDeep,without:_.without,difference:_.difference,intersection:_.intersection,union:_.union,has:_.has,result:_.result,omit:_.omit,pick:_.pick,bindAll:_.bindAll,forIn:_.forIn,camelCase:_.camelCase,uniqueId:_.uniqueId,merge:function(){if(_.mergeWith){var t=Array.from(arguments),e=t[t.length-1],n=this.isFunction(e)?e:this.noop;return t.push(function(t,e){var i=n(t,e);return void 0!==i?i:Array.isArray(t)&&!Array.isArray(e)?e:void 0}),_.mergeWith.apply(this,t)}return _.merge.apply(this,arguments)},isBoolean:function(t){var e=Object.prototype.toString;return!0===t||!1===t||!!t&&"object"==typeof t&&"[object Boolean]"===e.call(t)},isObject:function(t){return!!t&&("object"==typeof t||"function"==typeof t)},isNumber:function(t){var e=Object.prototype.toString;return"number"==typeof t||!!t&&"object"==typeof t&&"[object Number]"===e.call(t)},isString:function(t){var e=Object.prototype.toString;return"string"==typeof t||!!t&&"object"==typeof t&&"[object String]"===e.call(t)},noop:function(){}}};joint.mvc.View=Backbone.View.extend({options:{},theme:null,themeClassNamePrefix:joint.util.addClassNamePrefix("theme-"),requireSetThemeOverride:!1,defaultTheme:joint.config.defaultTheme,children:null,childNodes:null,constructor:function(t){this.requireSetThemeOverride=t&&!!t.theme,this.options=joint.util.assign({},this.options,t),Backbone.View.call(this,t)},initialize:function(t){joint.util.bindAll(this,"setTheme","onSetTheme","remove","onRemove"),(joint.mvc.views[this.cid]=this).setTheme(this.options.theme||this.defaultTheme),this.init()},renderChildren:function(t){if(t||(t=this.children),t){var e=V.namespace[this.svgElement?"xmlns":"xhtml"],i=joint.util.parseDOMJSON(t,e);this.vel.empty().append(i.fragment),this.childNodes=i.selectors}return this},findAttribute:function(t,e){for(var i=e;i&&1===i.nodeType;){var n=i.getAttribute(t);if(n)return n;if(i===this.el)return null;i=i.parentNode}return null},_ensureElement:function(){if(this.el)this.setElement(joint.util.result(this,"el"));else{var t=joint.util.result(this,"tagName"),e=joint.util.assign({},joint.util.result(this,"attributes"));this.id&&(e.id=joint.util.result(this,"id")),this.setElement(this._createElement(t)),this._setAttributes(e)}this._ensureElClassName()},_setAttributes:function(t){this.svgElement?this.vel.attr(t):this.$el.attr(t)},_createElement:function(t){return this.svgElement?document.createElementNS(V.namespace.xmlns,t):document.createElement(t)},_setElement:function(t){this.$el=t instanceof Backbone.$?t:Backbone.$(t),this.el=this.$el[0],this.svgElement&&(this.vel=V(this.el))},_ensureElClassName:function(){var t=joint.util.result(this,"className");if(t){var e=joint.util.addClassNamePrefix(t);this.svgElement?this.vel.removeClass(t).addClass(e):this.$el.removeClass(t).addClass(e)}},init:function(){},onRender:function(){},setTheme:function(t,e){return e=e||{},this.theme&&this.requireSetThemeOverride&&!e.override||(this.removeThemeClassName(),this.addThemeClassName(t),this.onSetTheme(this.theme,t),this.theme=t),this},addThemeClassName:function(t){t=t||this.theme;var e=this.themeClassNamePrefix+t;return this.svgElement?this.vel.addClass(e):this.$el.addClass(e),this},removeThemeClassName:function(t){t=t||this.theme;var e=this.themeClassNamePrefix+t;return this.svgElement?this.vel.removeClass(e):this.$el.removeClass(e),this},onSetTheme:function(t,e){},remove:function(){return this.onRemove(),this.undelegateDocumentEvents(),joint.mvc.views[this.cid]=null,Backbone.View.prototype.remove.apply(this,arguments),this},onRemove:function(){},getEventNamespace:function(){return".joint-event-ns-"+this.cid},delegateElementEvents:function(t,e,i){if(!e)return this;i||(i={});var n=this.getEventNamespace();for(var r in e){var o=e[r];"function"!=typeof o&&(o=this[o]),o&&$(t).on(r+n,i,o.bind(this))}return this},undelegateElementEvents:function(t){return $(t).off(this.getEventNamespace()),this},delegateDocumentEvents:function(t,e){return t||(t=joint.util.result(this,"documentEvents")),this.delegateElementEvents(document,t,e)},undelegateDocumentEvents:function(){return this.undelegateElementEvents(document)},eventData:function(t,e){if(!t)throw new Error("eventData(): event object required.");var i=t.data,n="__"+this.cid+"__";return void 0===e?i&&i[n]||{}:(i||(i=t.data={}),i[n]||(i[n]={}),joint.util.assign(i[n],e),this)},stopPropagation:function(t){return this.eventData(t,{propagationStopped:!0}),this},isPropagationStopped:function(t){return!!this.eventData(t).propagationStopped}},{extend:function(){var t=Array.from(arguments),e=t[0]&&joint.util.assign({},t[0])||{},i=t[1]&&joint.util.assign({},t[1])||{},n=e.render||this.prototype&&this.prototype.render||null;return e.render=function(){return"function"==typeof n&&n.apply(this,arguments),this.render.__render__===n&&this.onRender(),this},e.render.__render__=n,Backbone.View.extend.call(this,e,i)}}),joint.dia.GraphCells=Backbone.Collection.extend({cellNamespace:joint.shapes,initialize:function(t,e){e.cellNamespace&&(this.cellNamespace=e.cellNamespace),this.graph=e.graph},model:function(t,e){var i=e.collection,n=i.cellNamespace,r=new("link"===t.type?joint.dia.Link:joint.util.getByPath(n,t.type,".")||joint.dia.Element)(t,e);return e.dry||(r.graph=i.graph),r},comparator:function(t){return t.get("z")||0}}),joint.dia.Graph=Backbone.Model.extend({_batches:{},initialize:function(t,e){e=e||{};var i=new joint.dia.GraphCells([],{model:e.cellModel,cellNamespace:e.cellNamespace,graph:this});Backbone.Model.prototype.set.call(this,"cells",i),i.on("all",this.trigger,this),this.on("change:z",this._sortOnChangeZ,this),this._out={},this._in={},this._nodes={},this._edges={},i.on("add",this._restructureOnAdd,this),i.on("remove",this._restructureOnRemove,this),i.on("reset",this._restructureOnReset,this),i.on("change:source",this._restructureOnChangeSource,this),i.on("change:target",this._restructureOnChangeTarget,this),i.on("remove",this._removeCell,this)},_sortOnChangeZ:function(){this.get("cells").sort()},_restructureOnAdd:function(t){if(t.isLink()){this._edges[t.id]=!0;var e=t.source(),i=t.target();e.id&&((this._out[e.id]||(this._out[e.id]={}))[t.id]=!0),i.id&&((this._in[i.id]||(this._in[i.id]={}))[t.id]=!0)}else this._nodes[t.id]=!0},_restructureOnRemove:function(t){if(t.isLink()){delete this._edges[t.id];var e=t.source(),i=t.target();e.id&&this._out[e.id]&&this._out[e.id][t.id]&&delete this._out[e.id][t.id],i.id&&this._in[i.id]&&this._in[i.id][t.id]&&delete this._in[i.id][t.id]}else delete this._nodes[t.id]},_restructureOnReset:function(t){t=t.models,this._out={},this._in={},this._nodes={},this._edges={},t.forEach(this._restructureOnAdd,this)},_restructureOnChangeSource:function(t){var e=t.previous("source");e.id&&this._out[e.id]&&delete this._out[e.id][t.id];var i=t.source();i.id&&((this._out[i.id]||(this._out[i.id]={}))[t.id]=!0)},_restructureOnChangeTarget:function(t){var e=t.previous("target");e.id&&this._in[e.id]&&delete this._in[e.id][t.id];var i=t.get("target");i.id&&((this._in[i.id]||(this._in[i.id]={}))[t.id]=!0)},getOutboundEdges:function(t){return this._out&&this._out[t]||{}},getInboundEdges:function(t){return this._in&&this._in[t]||{}},toJSON:function(){var t=Backbone.Model.prototype.toJSON.apply(this,arguments);return t.cells=this.get("cells").toJSON(),t},fromJSON:function(t,e){if(!t.cells)throw new Error("Graph JSON must contain cells array.");return this.set(t,e)},set:function(t,e,i){var n;return"object"==typeof t?(n=t,i=e):(n={})[t]=e,n.hasOwnProperty("cells")&&(this.resetCells(n.cells,i),n=joint.util.omit(n,"cells")),Backbone.Model.prototype.set.call(this,n,i)},clear:function(t){t=joint.util.assign({},t,{clear:!0});var e=this.get("cells");if(0===e.length)return this;this.startBatch("clear",t);for(var i=e.sortBy(function(t){return t.isLink()?1:2});i.shift().remove(t),0<i.length;);return this.stopBatch("clear"),this},_prepareCell:function(t,e){var i;if(t instanceof Backbone.Model?(i=t.attributes,t.graph||e&&e.dry||(t.graph=this)):i=t,!joint.util.isString(i.type))throw new TypeError("dia.Graph: cell type must be a string.");return t},minZIndex:function(){var t=this.get("cells").first();return t&&t.get("z")||0},maxZIndex:function(){var t=this.get("cells").last();return t&&t.get("z")||0},addCell:function(t,e){return Array.isArray(t)?this.addCells(t,e):(t instanceof Backbone.Model?t.has("z")||t.set("z",this.maxZIndex()+1):void 0===t.z&&(t.z=this.maxZIndex()+1),this.get("cells").add(this._prepareCell(t,e),e||{}),this)},addCells:function(t,e){return t.length&&(t=joint.util.flattenDeep(t),e.position=t.length,this.startBatch("add"),t.forEach(function(t){e.position--,this.addCell(t,e)},this),this.stopBatch("add")),this},resetCells:function(t,e){var i=joint.util.toArray(t).map(function(t){return this._prepareCell(t,e)},this);return this.get("cells").reset(i,e),this},removeCells:function(t,e){return t.length&&(this.startBatch("remove"),joint.util.invoke(t,"remove",e),this.stopBatch("remove")),this},_removeCell:function(t,e,i){(i=i||{}).clear||(i.disconnectLinks?this.disconnectLinks(t,i):this.removeLinks(t,i)),this.get("cells").remove(t,{silent:!0}),t.graph===this&&(t.graph=null)},getCell:function(t){return this.get("cells").get(t)},getCells:function(){return this.get("cells").toArray()},getElements:function(){return Object.keys(this._nodes).map(this.getCell,this)},getLinks:function(){return Object.keys(this._edges).map(this.getCell,this)},getFirstCell:function(){return this.get("cells").first()},getLastCell:function(){return this.get("cells").last()},getConnectedLinks:function(t,o){var e=(o=o||{}).inbound,i=o.outbound;void 0===e&&void 0===i&&(e=i=!0);var s=[],a={};if(i&&joint.util.forIn(this.getOutboundEdges(t.id),function(t,e){a[e]||(s.push(this.getCell(e)),a[e]=!0)}.bind(this)),e&&joint.util.forIn(this.getInboundEdges(t.id),function(t,e){a[e]||(s.push(this.getCell(e)),a[e]=!0)}.bind(this)),o.deep){var n=t.getEmbeddedCells({deep:!0}),l={};n.forEach(function(t){t.isElement()&&(l[t.id]=!0)}),n.forEach(function(t){t.isLink()||(i&&joint.util.forIn(this.getOutboundEdges(t.id),function(t,e){if(!a[e]){var i=this.getCell(e),n=i.source().id,r=i.target().id;if(!o.includeEnclosed&&n&&l[n]&&r&&l[r])return;s.push(this.getCell(e)),a[e]=!0}}.bind(this)),e&&joint.util.forIn(this.getInboundEdges(t.id),function(t,e){if(!a[e]){var i=this.getCell(e),n=i.source().id,r=i.target().id;if(!o.includeEnclosed&&n&&l[n]&&r&&l[r])return;s.push(this.getCell(e)),a[e]=!0}}.bind(this)))},this)}return s},getNeighbors:function(a,l){var h=(l=l||{}).inbound,u=l.outbound;void 0===h&&void 0===u&&(h=u=!0);var t=this.getConnectedLinks(a,l).reduce(function(t,e){var i=e.source(),n=e.target(),r=e.hasLoop(l);if(h&&joint.util.has(i,"id")&&!t[i.id]){var o=this.getCell(i.id);!r&&(!o||o===a||l.deep&&o.isEmbeddedIn(a))||(t[i.id]=o)}if(u&&joint.util.has(n,"id")&&!t[n.id]){var s=this.getCell(n.id);!r&&(!s||s===a||l.deep&&s.isEmbeddedIn(a))||(t[n.id]=s)}return t}.bind(this),{});return joint.util.toArray(t)},getCommonAncestor:function(){var t=Array.from(arguments).map(function(t){for(var e=[],i=t.get("parent");i;)e.push(i),i=this.getCell(i).get("parent");return e},this);t=t.sort(function(t,e){return t.length-e.length});var e=joint.util.toArray(t.shift()).find(function(e){return t.every(function(t){return t.includes(e)})});return this.getCell(e)},getSuccessors:function(e,t){t=t||{};var i=[];return this.search(e,function(t){t!==e&&i.push(t)},joint.util.assign({},t,{outbound:!0})),i},cloneCells:function(t){t=joint.util.uniq(t);var s=joint.util.toArray(t).reduce(function(t,e){return t[e.id]=e.clone(),t},{});return joint.util.toArray(t).forEach(function(t){var e=s[t.id];if(e.isLink()){var i=e.source(),n=e.target();i.id&&s[i.id]&&e.prop("source/id",s[i.id].id),n.id&&s[n.id]&&e.prop("target/id",s[n.id].id)}var r=t.get("parent");r&&s[r]&&e.set("parent",s[r].id);var o=joint.util.toArray(t.get("embeds")).reduce(function(t,e){return s[e]&&t.push(s[e].id),t},[]);joint.util.isEmpty(o)||e.set("embeds",o)}),s},cloneSubgraph:function(t,e){var i=this.getSubgraph(t,e);return this.cloneCells(i)},getSubgraph:function(t,e){e=e||{};var o=[],s={},a=[],i=[];return joint.util.toArray(t).forEach(function(t){(s[t.id]||(o.push(t),(s[t.id]=t).isLink()?i.push(t):a.push(t)),e.deep)&&t.getEmbeddedCells({deep:!0}).forEach(function(t){s[t.id]||(o.push(t),(s[t.id]=t).isLink()?i.push(t):a.push(t))})}),i.forEach(function(t){var e=t.source(),i=t.target();if(e.id&&!s[e.id]){var n=this.getCell(e.id);o.push(n),s[n.id]=n,a.push(n)}if(i.id&&!s[i.id]){var r=this.getCell(i.id);o.push(this.getCell(i.id)),s[r.id]=r,a.push(r)}},this),a.forEach(function(t){this.getConnectedLinks(t,e).forEach(function(t){var e=t.source(),i=t.target();!s[t.id]&&e.id&&s[e.id]&&i.id&&s[i.id]&&(o.push(t),s[t.id]=t)})},this),o},getPredecessors:function(e,t){t=t||{};var i=[];return this.search(e,function(t){t!==e&&i.push(t)},joint.util.assign({},t,{inbound:!0})),i},search:function(t,e,i){(i=i||{}).breadthFirst?this.bfs(t,e,i):this.dfs(t,e,i)},bfs:function(t,e,i){i=i||{};var n={},r={},o=[];for(o.push(t),r[t.id]=0;0<o.length;){var s=o.shift();if(!n[s.id]){if(!(n[s.id]=!0)===e(s,r[s.id]))return;this.getNeighbors(s,i).forEach(function(t){r[t.id]=r[s.id]+1,o.push(t)})}}},dfs:function(t,e,i,n,r){i=i||{};var o=n||{},s=r||0;!1!==e(t,s)&&(o[t.id]=!0,this.getNeighbors(t,i).forEach(function(t){o[t.id]||this.dfs(t,e,i,o,s+1)},this))},getSources:function(){var i=[];return joint.util.forIn(this._nodes,function(t,e){this._in[e]&&!joint.util.isEmpty(this._in[e])||i.push(this.getCell(e))}.bind(this)),i},getSinks:function(){var i=[];return joint.util.forIn(this._nodes,function(t,e){this._out[e]&&!joint.util.isEmpty(this._out[e])||i.push(this.getCell(e))}.bind(this)),i},isSource:function(t){return!this._in[t.id]||joint.util.isEmpty(this._in[t.id])},isSink:function(t){return!this._out[t.id]||joint.util.isEmpty(this._out[t.id])},isSuccessor:function(e,i){var n=!1;return this.search(e,function(t){if(t===i&&t!==e)return!(n=!0)},{outbound:!0}),n},isPredecessor:function(e,i){var n=!1;return this.search(e,function(t){if(t===i&&t!==e)return!(n=!0)},{inbound:!0}),n},isNeighbor:function(t,n,e){var r=(e=e||{}).inbound,o=e.outbound;void 0===r&&void 0===o&&(r=o=!0);var s=!1;return this.getConnectedLinks(t,e).forEach(function(t){var e=t.source(),i=t.target();return r&&joint.util.has(e,"id")&&e.id===n.id?!(s=!0):o&&joint.util.has(i,"id")&&i.id===n.id?!(s=!0):void 0}),s},disconnectLinks:function(e,i){this.getConnectedLinks(e).forEach(function(t){t.set(t.source().id===e.id?"source":"target",{x:0,y:0},i)})},removeLinks:function(t,e){joint.util.invoke(this.getConnectedLinks(t),"remove",e)},findModelsFromPoint:function(e){return this.getElements().filter(function(t){return t.getBBox().containsPoint(e)})},findModelsInArea:function(e,t){e=g.rect(e);var i=(t=joint.util.defaults(t||{},{strict:!1})).strict?"containsRect":"intersect";return this.getElements().filter(function(t){return e[i](t.getBBox())})},findModelsUnderElement:function(e,t){t=joint.util.defaults(t||{},{searchBy:"bbox"});var i=e.getBBox();return("bbox"===t.searchBy?this.findModelsInArea(i):this.findModelsFromPoint(i[t.searchBy]())).filter(function(t){return e.id!==t.id&&!t.isEmbeddedIn(e)})},getBBox:function(t,e){return this.getCellsBBox(t||this.getElements(),e)},getCellsBBox:function(t,r){return joint.util.toArray(t).reduce(function(t,e){if(e.isLink())return t;var i=e.getBBox(r),n=e.angle();return n&&(i=i.bbox(n)),t?t.union(i):i},null)},translate:function(t,e,i){var n=this.getCells().filter(function(t){return!t.isEmbedded()});return joint.util.invoke(n,"translate",t,e,i),this},resize:function(t,e,i){return this.resizeCells(t,e,this.getCells(),i)},resizeCells:function(t,e,i,n){var r=this.getCellsBBox(i);if(r){var o=Math.max(t/r.width,0),s=Math.max(e/r.height,0);joint.util.invoke(i,"scale",o,s,r.origin(),n)}return this},startBatch:function(t,e){return e=e||{},this._batches[t]=(this._batches[t]||0)+1,this.trigger("batch:start",joint.util.assign({},e,{batchName:t}))},stopBatch:function(t,e){return e=e||{},this._batches[t]=(this._batches[t]||0)-1,this.trigger("batch:stop",joint.util.assign({},e,{batchName:t}))},hasActiveBatch:function(t){return 0===arguments.length?joint.util.toArray(this._batches).some(function(t){return 0<t}):Array.isArray(t)?t.some(function(t){return!!this._batches[t]},this):!!this._batches[t]}},{validations:{multiLinks:function(t,e){var n=e.source(),r=e.target();if(n.id&&r.id){var i=e.getSourceElement();if(i)if(1<t.getConnectedLinks(i,{outbound:!0}).filter(function(t){var e=t.source(),i=t.target();return e&&e.id===n.id&&(!e.port||e.port===n.port)&&i&&i.id===r.id&&(!i.port||i.port===r.port)}).length)return!1}return!0},linkPinning:function(t,e){return e.source().id&&e.target().id}}}),joint.util.wrapWith(joint.dia.Graph.prototype,["resetCells","addCells","removeCells"],"cells"),function(l,f,h,m,g){function t(o,s){return function(t,e){var i=g.isPercentage(t);t=parseFloat(t),i&&(t/=100);var n={};if(isFinite(t)){var r=i||0<=t&&t<=1?t*e[s]:Math.max(t+e[s],0);n[o]=r}return n}}function e(s,a,l){return function(t,e){var i,n=g.isPercentage(t);if(t=parseFloat(t),n&&(t/=100),isFinite(t)){var r=e[l]();i=n||0<t&&t<1?r[s]+e[a]*t:r[s]+t}var o=h.Point();return o[s]=i||0,o}}function i(r,o,s){return function(t,e){var i;i="middle"===t?e[o]/2:t===s?e[o]:isFinite(t)?-1<t&&t<1?-e[o]*t:-t:g.isPercentage(t)?e[o]*parseFloat(t)/100:0;var n=h.Point();return n[r]=-(e[r]+i),n}}function r(f,t){var g="joint-shape",p=t&&t.resetOffset;return function(t,e,i){var n=m(i),r=n.data(g);if(!r||r.value!==t){var o=f(t);r={value:t,shape:o,shapeBBox:o.bbox()},n.data(g,r)}var s=r.shape.clone(),a=r.shapeBBox.clone(),l=a.origin(),h=e.origin();a.x=h.x,a.y=h.y;var u=e.maxRectScaleToFit(a,h),c=0===a.width||0===e.width?1:u.sx,d=0===a.height||0===e.height?1:u.sy;return s.scale(c,d,l),p&&s.translate(-l.x,-l.y),s}}function n(t){var n=r(function(t){return new h.Path(f.normalizePathData(t))},t);return function(t,e,i){return{d:n(t,e,i).serialize()}}}function o(t){var n=r(h.Polyline,t);return function(t,e,i){return{points:n(t,e,i).serialize()}}}function s(r,o){var s=new h.Point(1,0);return function(t){var e,i,n=this[r](t);return n?(i=o.rotate?n.vector().vectorAngle(s):0,e=n.start):(e=this.path.start,i=0),0===i?{transform:"translate("+e.x+","+e.y+")"}:{transform:"translate("+e.x+","+e.y+") rotate("+i+")"}}}function a(t,e,i){return void 0!==i.text}function u(){return this instanceof l.dia.LinkView}function c(t){var e={},i=t.stroke;"string"==typeof i&&(e.stroke=i,e.fill=i);var n=t.strokeOpacity;return void 0===n&&(n=t["stroke-opacity"]),void 0===n&&(n=t.opacity),void 0!==n&&(e["stroke-opacity"]=n,e["fill-opacity"]=n),e}var d,p,v=l.dia.attributes={xlinkHref:{set:"xlink:href"},xlinkShow:{set:"xlink:show"},xlinkRole:{set:"xlink:role"},xlinkType:{set:"xlink:type"},xlinkArcrole:{set:"xlink:arcrole"},xlinkTitle:{set:"xlink:title"},xlinkActuate:{set:"xlink:actuate"},xmlSpace:{set:"xml:space"},xmlBase:{set:"xml:base"},xmlLang:{set:"xml:lang"},preserveAspectRatio:{set:"preserveAspectRatio"},requiredExtension:{set:"requiredExtension"},requiredFeatures:{set:"requiredFeatures"},systemLanguage:{set:"systemLanguage"},externalResourcesRequired:{set:"externalResourceRequired"},filter:{qualify:g.isPlainObject,set:function(t){return"url(#"+this.paper.defineFilter(t)+")"}},fill:{qualify:g.isPlainObject,set:function(t){return"url(#"+this.paper.defineGradient(t)+")"}},stroke:{qualify:g.isPlainObject,set:function(t){return"url(#"+this.paper.defineGradient(t)+")"}},sourceMarker:{qualify:g.isPlainObject,set:function(t,e,i,n){return t=g.assign(c(n),t),{"marker-start":"url(#"+this.paper.defineMarker(t)+")"}}},targetMarker:{qualify:g.isPlainObject,set:function(t,e,i,n){return t=g.assign(c(n),{transform:"rotate(180)"},t),{"marker-end":"url(#"+this.paper.defineMarker(t)+")"}}},vertexMarker:{qualify:g.isPlainObject,set:function(t,e,i,n){return t=g.assign(c(n),t),{"marker-mid":"url(#"+this.paper.defineMarker(t)+")"}}},text:{qualify:function(t,e,i){return!i.textWrap||!g.isPlainObject(i.textWrap)},set:function(t,e,i,n){var r=m(i),o="joint-text",s=r.data(o),a=g.pick(n,"lineHeight","annotations","textPath","x","textVerticalAnchor","eol"),l=a.fontSize=n["font-size"]||n.fontSize,h=JSON.stringify([t,a]);if(void 0===s||s!==h){l&&i.setAttribute("font-size",l);var u=a.textPath;if(g.isObject(u)){var c=u.selector;if("string"==typeof c){var d=this.findBySelector(c)[0];d instanceof SVGPathElement&&(a.textPath=g.assign({"xlink:href":"#"+d.id},u))}}f(i).text(""+t,a),r.data(o,h)}}},textWrap:{qualify:g.isPlainObject,set:function(t,e,i,n){var r=t.width||0;g.isPercentage(r)?e.width*=parseFloat(r)/100:r<=0?e.width+=r:e.width=r;var o,s=t.height||0;g.isPercentage(s)?e.height*=parseFloat(s)/100:s<=0?e.height+=s:e.height=s;var a=t.text;void 0===a&&(a=n.text),o=void 0!==a?g.breakText(""+a,e,{"font-weight":n["font-weight"]||n.fontWeight,"font-size":n["font-size"]||n.fontSize,"font-family":n["font-family"]||n.fontFamily,lineHeight:n.lineHeight},{svgDocument:this.paper.svg,ellipsis:t.ellipsis}):"",l.dia.attributes.text.set.call(this,o,e,i,n)}},title:{qualify:function(t,e){return e instanceof SVGElement},set:function(t,e,i){var n=m(i),r="joint-title",o=n.data(r);if(void 0===o||o!==t){n.data(r,t);var s=i.firstChild;if(s&&"TITLE"===s.tagName.toUpperCase())s.textContent=t;else{var a=document.createElementNS(i.namespaceURI,"title");a.textContent=t,i.insertBefore(a,s)}}}},lineHeight:{qualify:a},textVerticalAnchor:{qualify:a},textPath:{qualify:a},annotations:{qualify:a},port:{set:function(t){return null===t||void 0===t.id?t:t.id}},style:{qualify:g.isPlainObject,set:function(t,e,i){m(i).css(t)}},html:{set:function(t,e,i){m(i).html(t+"")}},ref:{},refX:{position:e("x","width","origin")},refY:{position:e("y","height","origin")},refDx:{position:e("x","width","corner")},refDy:{position:e("y","height","corner")},refWidth:{set:t("width","width")},refHeight:{set:t("height","height")},refRx:{set:t("rx","width")},refRy:{set:t("ry","height")},refRInscribed:{set:(d=t("r","width"),p=t("r","height"),function(t,e){return(e.height>e.width?d:p)(t,e)})},refRCircumscribed:{set:function(t,e){var i=g.isPercentage(t);t=parseFloat(t),i&&(t/=100);var n,r=Math.sqrt(e.height*e.height+e.width*e.width);return isFinite(t)&&(n=i||0<=t&&t<=1?t*r:Math.max(t+r,0)),{r:n}}},refCx:{set:t("cx","width")},refCy:{set:t("cy","height")},xAlignment:{offset:i("x","width","right")},yAlignment:{offset:i("y","height","bottom")},resetOffset:{offset:function(t,e){return t?{x:-e.x,y:-e.y}:{x:0,y:0}}},refDResetOffset:{set:n({resetOffset:!0})},refDKeepOffset:{set:n({resetOffset:!1})},refPointsResetOffset:{set:o({resetOffset:!0})},refPointsKeepOffset:{set:o({resetOffset:!1})},connection:{qualify:u,set:function(){return{d:this.getSerializedConnection()}}},atConnectionLengthKeepGradient:{qualify:u,set:s("getTangentAtLength",{rotate:!0})},atConnectionLengthIgnoreGradient:{qualify:u,set:s("getTangentAtLength",{rotate:!1})},atConnectionRatioKeepGradient:{qualify:u,set:s("getTangentAtRatio",{rotate:!0})},atConnectionRatioIgnoreGradient:{qualify:u,set:s("getTangentAtRatio",{rotate:!1})}};v.refR=v.refRInscribed,v.refD=v.refDResetOffset,v.refPoints=v.refPointsResetOffset,v.atConnectionLength=v.atConnectionLengthKeepGradient,v.atConnectionRatio=v.atConnectionRatioKeepGradient,v.refX2=v.refX,v.refY2=v.refY,v.refWidth2=v.refWidth,v.refHeight2=v.refHeight,v["ref-x"]=v.refX,v["ref-y"]=v.refY,v["ref-dy"]=v.refDy,v["ref-dx"]=v.refDx,v["ref-width"]=v.refWidth,v["ref-height"]=v.refHeight,v["x-alignment"]=v.xAlignment,v["y-alignment"]=v.yAlignment}(joint,V,g,$,joint.util),function(a,l){var h=a.mvc.View.extend({name:null,tagName:"g",className:"tool",svgElement:!0,_visible:!0,init:function(){var t=this.name;t&&this.vel.attr("data-tool-name",t)},configure:function(t,e){return this.relatedView=t,this.paper=t.paper,this.parentView=e,this.simulateRelatedView(this.el),this},simulateRelatedView:function(t){t&&t.setAttribute("model-id",this.relatedView.model.id)},getName:function(){return this.name},show:function(){this.el.style.display="",this._visible=!0},hide:function(){this.el.style.display="none",this._visible=!1},isVisible:function(){return!!this._visible},focus:function(){var t=this.options.focusOpacity;isFinite(t)&&(this.el.style.opacity=t),this.parentView.focusTool(this)},blur:function(){this.el.style.opacity="",this.parentView.blurTool(this)},update:function(){}}),t=a.mvc.View.extend({tagName:"g",className:"tools",svgElement:!0,tools:null,options:{tools:null,relatedView:null,name:null,component:!1},configure:function(t){var e=(t=l.assign(this.options,t)).tools;if(!Array.isArray(e))return this;var i=t.relatedView;if(!(i instanceof a.dia.CellView))return this;for(var n=this.tools=[],r=0,o=e.length;r<o;r++){var s=e[r];s instanceof h&&(s.configure(i,this),s.render(),this.vel.append(s.el),n.push(s))}return this},getName:function(){return this.options.name},update:function(t){t||(t={});var e=this.tools;if(e){for(var i=0,n=e.length;i<n;i++){var r=e[i];t.tool!==r.cid&&r.isVisible()&&r.update()}return this}},focusTool:function(t){var e=this.tools;if(!e)return this;for(var i=0,n=e.length;i<n;i++){var r=e[i];t===r?r.show():r.hide()}return this},blurTool:function(t){var e=this.tools;if(!e)return this;for(var i=0,n=e.length;i<n;i++){var r=e[i];r===t||r.isVisible()||(r.show(),r.update())}return this},hide:function(){return this.focusTool(null)},show:function(){return this.blurTool(null)},onRemove:function(){var t=this.tools;if(!t)return this;for(var e=0,i=t.length;e<i;e++)t[e].remove();this.tools=null},mount:function(){var t=this.options,e=t.relatedView;e&&(t.component?e.el:e.paper.tools).appendChild(this.el);return this}});a.dia.ToolsView=t,a.dia.ToolView=h}(joint,joint.util),joint.dia.Cell=Backbone.Model.extend({constructor:function(t,e){var i,n=t||{};this.cid=joint.util.uniqueId("c"),this.attributes={},e&&e.collection&&(this.collection=e.collection),e&&e.parse&&(n=this.parse(n,e)||{}),(i=joint.util.result(this,"defaults"))&&(n=joint.util.merge({},i,n)),this.set(n,e),this.changed={},this.initialize.apply(this,arguments)},translate:function(t,e,i){throw new Error("Must define a translate() method.")},toJSON:function(){var e=this.constructor.prototype.defaults.attrs||{},t=this.attributes.attrs,o={};joint.util.forIn(t,function(t,n){var r=e[n];joint.util.forIn(t,function(t,i){joint.util.isObject(t)&&!Array.isArray(t)?joint.util.forIn(t,function(t,e){r&&r[i]&&joint.util.isEqual(r[i][e],t)||(o[n]=o[n]||{},(o[n][i]||(o[n][i]={}))[e]=t)}):r&&joint.util.isEqual(r[i],t)||(o[n]=o[n]||{},o[n][i]=t)})});var i=joint.util.cloneDeep(joint.util.omit(this.attributes,"attrs"));return i.attrs=o,i},initialize:function(t){t&&t.id||this.set("id",joint.util.uuid(),{silent:!0}),this._transitionIds={},this.processPorts(),this.on("change:attrs",this.processPorts,this)},processPorts:function(){var t=this.ports,i={};joint.util.forIn(this.get("attrs"),function(t,e){t&&t.port&&(void 0!==t.port.id?i[t.port.id]=t.port:i[t.port]={id:t.port})});var n={};(joint.util.forIn(t,function(t,e){i[e]||(n[e]=!0)}),this.graph&&!joint.util.isEmpty(n))&&(this.graph.getConnectedLinks(this,{inbound:!0}).forEach(function(t){n[t.get("target").port]&&t.remove()}),this.graph.getConnectedLinks(this,{outbound:!0}).forEach(function(t){n[t.get("source").port]&&t.remove()}));this.ports=i},remove:function(t){t=t||{};var e=this.graph;if(!e)return this.collection&&this.collection.remove(this,t),this;e.startBatch("remove");var i=this.getParentCell();i&&i.unembed(this);for(var n=this.getEmbeddedCells(),r=0,o=n.length;r<o;r++){var s=n[r];s&&s.remove(t)}return this.trigger("remove",this,e.attributes.cells,t),e.stopBatch("remove"),this},toFront:function(i){var t=this.graph;if(t){i=i||{};var e,n=t.maxZIndex();i.deep?(e=this.getEmbeddedCells({deep:!0,breadthFirst:!0})).unshift(this):e=[this],n=n-e.length+1;var r=t.get("cells"),o=r.indexOf(this)!==r.length-e.length;o||(o=e.some(function(t,e){return t.get("z")!==n+e})),o&&(this.startBatch("to-front"),n+=e.length,e.forEach(function(t,e){t.set("z",n+e,i)}),this.stopBatch("to-front"))}return this},toBack:function(i){var t=this.graph;if(t){i=i||{};var e,n=t.minZIndex();i.deep?(e=this.getEmbeddedCells({deep:!0,breadthFirst:!0})).unshift(this):e=[this];var r=0!==t.get("cells").indexOf(this);r||(r=e.some(function(t,e){return t.get("z")!==n+e})),r&&(this.startBatch("to-back"),n-=e.length,e.forEach(function(t,e){t.set("z",n+e,i)}),this.stopBatch("to-back"))}return this},parent:function(t,e){return void 0===t?this.get("parent"):this.set("parent",t,e)},embed:function(t,e){if(this===t||this.isEmbeddedIn(t))throw new Error("Recursive embedding not allowed.");this.startBatch("embed");var i=joint.util.assign([],this.get("embeds"));return i[t.isLink()?"unshift":"push"](t.id),t.parent(this.id,e),this.set("embeds",joint.util.uniq(i),e),this.stopBatch("embed"),this},unembed:function(t,e){return this.startBatch("unembed"),t.unset("parent",e),this.set("embeds",joint.util.without(this.get("embeds"),t.id),e),this.stopBatch("unembed"),this},getParentCell:function(){var t=this.parent(),e=this.graph;return t&&e&&e.getCell(t)||null},getAncestors:function(){var t=[];if(!this.graph)return t;for(var e=this.getParentCell();e;)t.push(e),e=e.getParentCell();return t},getEmbeddedCells:function(e){if(e=e||{},this.graph){var i;if(e.deep)if(e.breadthFirst){i=[];for(var t=this.getEmbeddedCells();0<t.length;){var n=t.shift();i.push(n),t.push.apply(t,n.getEmbeddedCells())}}else(i=this.getEmbeddedCells()).forEach(function(t){i.push.apply(i,t.getEmbeddedCells(e))});else i=joint.util.toArray(this.get("embeds")).map(this.graph.getCell,this.graph);return i}return[]},isEmbeddedIn:function(t,e){var i=joint.util.isString(t)?t:t.id,n=this.parent();if(e=joint.util.defaults({deep:!0},e),this.graph&&e.deep){for(;n;){if(n===i)return!0;n=this.graph.getCell(n).parent()}return!1}return n===i},isEmbedded:function(){return!!this.parent()},clone:function(t){if((t=t||{}).deep)return joint.util.toArray(joint.dia.Graph.prototype.cloneCells.call(null,[this].concat(this.getEmbeddedCells({deep:!0}))));var e=Backbone.Model.prototype.clone.apply(this,arguments);return e.set("id",joint.util.uuid()),e.unset("embeds"),e.unset("parent"),e},prop:function(t,e,i){var n=joint.util.isString(t);if(n||Array.isArray(t)){if(1<arguments.length){var r,o,s=(o=n?(r=t).split("/"):(r=t.join("/"),t.slice()))[0],a=o.length;if((i=i||{}).propertyPath=r,i.propertyValue=e,i.propertyPathArray=o,1===a)return this.set(s,e,i);for(var l={},h=l,u=s,c=1;c<a;c++){var d=o[c],f=Number.isFinite(n?Number(d):d);h=h[u]=f?[]:{},u=d}l=joint.util.setByPath(l,o,e,"/");var g=joint.util.merge({},this.attributes);i.rewrite&&joint.util.unsetByPath(g,r,"/");var p=joint.util.merge(g,l);return this.set(s,p[s],i)}return joint.util.getByPath(this.attributes,t,"/")}return this.set(joint.util.merge({},this.attributes,t),e)},removeProp:function(t,e){(e=e||{}).dirty=!0;var i=Array.isArray(t)?t:t.split("/");if(1===i.length)return this.unset(t,e);var n=i[0],r=i.slice(1),o=joint.util.cloneDeep(this.get(n));return joint.util.unsetByPath(o,r,"/"),this.set(n,o,e)},attr:function(t,e,i){var n=Array.from(arguments);return 0===n.length?this.get("attrs"):(Array.isArray(t)?n[0]=["attrs"].concat(t):joint.util.isString(t)?n[0]="attrs/"+t:n[0]={attrs:t},this.prop.apply(this,n))},removeAttr:function(t,e){return Array.isArray(t)?this.removeProp(["attrs"].concat(t)):this.removeProp("attrs/"+t,e)},transition:function(r,e,o,i){i=i||"/";var t={duration:100,delay:10,timingFunction:joint.util.timing.linear,valueFunction:joint.util.interpolate.number};o=joint.util.assign(t,o);var s,a=0,l=function(t){var e,i,n;(i=(t-=a=a||t)/o.duration)<1?this._transitionIds[r]=e=joint.util.nextFrame(l):(i=1,delete this._transitionIds[r]),n=s(o.timingFunction(i)),o.transitionId=e,this.prop(r,n,o),e||this.trigger("transition:end",this,r)}.bind(this),n=function(t){this.stopTransitions(r),s=o.valueFunction(joint.util.getByPath(this.attributes,r,i),e),this._transitionIds[r]=joint.util.nextFrame(t),this.trigger("transition:start",this,r)}.bind(this);return setTimeout(n,o.delay,l)},getTransitions:function(){return Object.keys(this._transitionIds)},stopTransitions:function(t,e){e=e||"/";var i=t&&t.split(e);return Object.keys(this._transitionIds).filter(i&&function(t){return joint.util.isEqual(i,t.split(e).slice(0,i.length))}).forEach(function(t){joint.util.cancelFrame(this._transitionIds[t]),delete this._transitionIds[t],this.trigger("transition:end",this,t)},this),this},addTo:function(t,e){return t.addCell(this,e),this},findView:function(t){return t.findViewByModel(this)},isElement:function(){return!1},isLink:function(){return!1},startBatch:function(t,e){return this.graph&&this.graph.startBatch(t,joint.util.assign({},e,{cell:this})),this},stopBatch:function(t,e){return this.graph&&this.graph.stopBatch(t,joint.util.assign({},e,{cell:this})),this}},{getAttributeDefinition:function(t){var e=this.attributes,i=joint.dia.attributes;return e&&e[t]||i[t]},define:function(t,e,i,n){i=joint.util.assign({defaults:joint.util.defaultsDeep({type:t},e,this.prototype.defaults)},i);var r=this.extend(i,n);return joint.util.setByPath(joint.shapes,t,r,"."),r}}),joint.dia.CellView=joint.mvc.View.extend({tagName:"g",svgElement:!0,selector:"root",className:function(){var n=["cell"],t=this.model.get("type");return t&&t.toLowerCase().split(".").forEach(function(t,e,i){n.push("type-"+i.slice(0,e+1).join("-"))}),n.join(" ")},attributes:function(){return{"model-id":this.model.id}},constructor:function(t){t.id=t.id||joint.util.guid(this),joint.mvc.View.call(this,t)},init:function(){joint.util.bindAll(this,"remove","update"),this.$el.data("view",this),this.$el.attr("data-type",this.model.get("type")),this.listenTo(this.model,"change:attrs",this.onChangeAttrs)},parseDOMJSON:function(t,e){var i=joint.util.parseDOMJSON(t),n=i.selectors,r=i.groupSelectors;for(var o in r){if(n[o])throw new Error("dia.CellView: ambigious group selector");n[o]=r[o]}if(e){var s=this.selector;if(n[s])throw new Error("dia.CellView: ambiguous root selector.");n[s]=e}return{fragment:i.fragment,selectors:n}},onChangeAttrs:function(t,e,i){return i.dirty?this.render():this.update(t,e,i)},can:function(t){var e=joint.util.isFunction(this.options.interactive)?this.options.interactive(this):this.options.interactive;return joint.util.isObject(e)&&!1!==e[t]||joint.util.isBoolean(e)&&!1!==e},findBySelector:function(t,e,i){if(e||(e=this.el),i||(i=this.selectors),!t||"."===t)return[e];if(i){var n=i[t];if(n)return Array.isArray(n)?n:[n]}return $(e).find(t).toArray()},notify:function(t){if(this.paper){var e=Array.prototype.slice.call(arguments,1);this.trigger.apply(this,[t].concat(e)),this.paper.trigger.apply(this.paper,[t,this].concat(e))}},getStrokeBBox:function(t){var e=!!t;t=t||this.el;var i,n=V(t).getBBox({target:this.paper.viewport});return i=e?V(t).attr("stroke-width"):this.model.attr("rect/stroke-width")||this.model.attr("circle/stroke-width")||this.model.attr("ellipse/stroke-width")||this.model.attr("path/stroke-width"),i=parseFloat(i)||0,g.rect(n).moveAndExpand({x:-i/2,y:-i/2,width:i,height:i})},getBBox:function(){return this.vel.getBBox({target:this.paper.svg})},highlight:function(t,e){return t=t&&this.$(t)[0]||this.el,(e=e||{}).partial=t!==this.el,this.notify("cell:highlight",t,e),this},unhighlight:function(t,e){return t=t&&this.$(t)[0]||this.el,(e=e||{}).partial=t!=this.el,this.notify("cell:unhighlight",t,e),this},findMagnet:function(t){var e=this.$(t),i=this.$el;0===e.length&&(e=i);do{var n=e.attr("magnet");if((n||e.is(i))&&"false"!==n)return e[0];e=e.parent()}while(0<e.length)},getSelector:function(t,e){var i;if(t===this.el)return"string"==typeof e&&(i="> "+e),i;if(t){var n=V(t).index()+1;i=t.tagName+":nth-child("+n+")",e&&(i+=" > "+e),i=this.getSelector(t.parentNode,i)}return i},getLinkEnd:function(t,e,i,n,r){var o=this.model,s=o.id,a=this.findAttribute("port",t),l=t.getAttribute("joint-selector"),h={id:s};null!=l&&(h.magnet=l),null!=a?(h.port=a,o.hasPort(a)||l||(h.selector=this.getSelector(t))):null==l&&this.el!==t&&(h.selector=this.getSelector(t));var u=this.paper,c=u.options.connectionStrategy;if("function"==typeof c){var d=c.call(u,h,this,t,new g.Point(e,i),n,r);d&&(h=d)}return h},getMagnetFromLinkEnd:function(t){var e=this.el,i=t.port,n=t.magnet;return null!=i&&this.model.hasPort(i)?this.findPortNode(i,n)||e:(n||(n=t.selector),n||null==i||(n='[port="'+i+'"]'),this.findBySelector(n,e,this.selectors)[0])},getAttributeDefinition:function(t){return this.model.constructor.getAttributeDefinition(t)},setNodeAttributes:function(t,e){joint.util.isEmpty(e)||(t instanceof SVGElement?V(t).attr(e):$(t).attr(e))},processNodeAttributes:function(t,e){var i,n,r,o,s,a,l,h,u,c=[];for(i in e)e.hasOwnProperty(i)&&(n=e[i],!(r=this.getAttributeDefinition(i))||joint.util.isFunction(r.qualify)&&!r.qualify.call(this,n,t,e)?(a||(a={}),a[joint.util.toKebabCase(i)]=n):(joint.util.isString(r.set)&&(a||(a={}),a[r.set]=n),null!==n&&c.push(i,r)));for(o=0,s=c.length;o<s;o+=2)i=c[o],r=c[o+1],n=e[i],joint.util.isFunction(r.set)&&(l||(l={}),l[i]=n),joint.util.isFunction(r.position)&&(h||(h={}),h[i]=n),joint.util.isFunction(r.offset)&&(u||(u={}),u[i]=n);return{raw:e,normal:a,set:l,position:h,offset:u}},updateRelativeAttributes:function(t,e,i,n){var r,o;n||(n={});var s=e.raw||{},a=e.normal||{},l=e.set,h=e.position,u=e.offset;for(r in l){o=l[r];var c=this.getAttributeDefinition(r).set.call(this,o,i.clone(),t,s);joint.util.isObject(c)?joint.util.assign(a,c):void 0!==c&&(a[r]=c)}if(t instanceof HTMLElement)this.setNodeAttributes(t,a);else{var d,f,p,m=a.transform,v=V.transformStringToMatrix(m),y=g.Point(v.e,v.f);if(m&&(a=joint.util.omit(a,"transform"),v.e=v.f=0),h||u){var b=this.getNodeScale(t,n.scalableNode);d=b.sx,f=b.sy}var w=!1;for(r in h)o=h[r],(p=this.getAttributeDefinition(r).position.call(this,o,i.clone(),t,s))&&(y.offset(g.Point(p).scale(d,f)),w||(w=!0));this.setNodeAttributes(t,a);var x=!1;if(u){var k=t.getBoundingClientRect();if(0<k.width&&0<k.height){var A=V.transformRect(t.getBBox(),v).scale(1/d,1/f);for(r in u)o=u[r],(p=this.getAttributeDefinition(r).offset.call(this,o,A,t,s))&&(y.offset(g.Point(p).scale(d,f)),x||(x=!0))}}(void 0!==m||w||x)&&(y.round(1),v.e=y.x,v.f=y.y,t.setAttribute("transform",V.matrixToTransformString(v)))}},getNodeScale:function(t,e){var i,n;if(e&&e.contains(t)){var r=e.scale();i=1/r.sx,n=1/r.sy}else n=i=1;return{sx:i,sy:n}},findNodesAttributes:function(t,e,i,n){var r,o,s,a,l=joint.util,h={},u=[];for(var c in t)if(t.hasOwnProperty(c)){var d=i[c]=this.findBySelector(c,e,n);for(r=0,o=d.length;r<o;r++){var f=d[r];a=V.ensureId(f),s=t[c];var g=n&&n[c]===f,p=h[a];if(p){p.array||(u.push(a),p.array=!0,p.attributes=[p.attributes],p.selectedLength=[p.selectedLength]);var m=p.attributes,v=p.selectedLength;if(g)m.unshift(s),v.unshift(-1);else{var y=l.sortedIndex(v,o);m.splice(y,0,s),v.splice(y,0,o)}}else h[a]={attributes:s,selectedLength:g?-1:o,node:f,array:!1}}}for(r=0,o=u.length;r<o;r++)(s=h[a=u[r]]).attributes=l.merge.apply(l,[{}].concat(s.attributes.reverse()));return h},getEventTarget:function(t){var e=t.type;return"touchmove"===e||"touchend"===e?document.elementFromPoint(t.clientX,t.clientY):t.target},updateDOMSubtreeAttributes:function(t,e,i){i||(i={}),i.rootBBox||(i.rootBBox=g.Rect()),i.selectors||(i.selectors=this.selectors);var n,r,o,s,a,l={},h={},u=[],c=i.roAttributes,d=this.findNodesAttributes(c||e,t,l,i.selectors),f=c?this.findNodesAttributes(e,t,l,i.selectors):d;for(var p in d)if(o=(s=d[p]).attributes,r=s.node,(a=this.processNodeAttributes(r,o)).set||a.position||a.offset){var m,v=f[p]&&f[p].attributes,y=v&&void 0===o.ref?v.ref:o.ref;if(y){if(!(m=(l[y]||this.findBySelector(y,t,i.selectors))[0]))throw new Error('dia.ElementView: "'+y+'" reference does not exist.')}else m=null;n={node:r,refNode:m,processedAttributes:a,allAttributes:v};var b=u.findIndex(function(t){return t.refNode===r});-1<b?u.splice(b,0,n):u.push(n)}else this.setNodeAttributes(r,a.normal);for(var w=0,x=u.length;w<x;w++){n=u[w],r=n.node;var k=(m=n.refNode)?V.ensureId(m):"",A=h[k];A||(A=h[k]=m?V(m).getBBox({target:i.rotatableNode||t}):i.rootBBox),c?(a=this.processNodeAttributes(r,n.allAttributes),this.mergeProcessedAttributes(a,n.processedAttributes)):a=n.processedAttributes,this.updateRelativeAttributes(r,a,A,i)}},mergeProcessedAttributes:function(t,e){t.set||(t.set={}),t.position||(t.position={}),t.offset||(t.offset={}),joint.util.assign(t.set,e.set),joint.util.assign(t.position,e.position),joint.util.assign(t.offset,e.offset);var i=t.normal&&t.normal.transform;void 0!==i&&e.normal&&(e.normal.transform=i),t.normal=e.normal},onRemove:function(){this.removeTools()},_toolsView:null,hasTools:function(t){var e=this._toolsView;return!!e&&(!t||e.getName()===t)},addTools:function(t){return this.removeTools(),t instanceof joint.dia.ToolsView&&((this._toolsView=t).configure({relatedView:this}),t.listenTo(this.paper,"tools:event",this.onToolEvent.bind(this)),t.mount()),this},updateTools:function(t){var e=this._toolsView;return e&&e.update(t),this},removeTools:function(){var t=this._toolsView;return t&&(t.remove(),this._toolsView=null),this},hideTools:function(){var t=this._toolsView;return t&&t.hide(),this},showTools:function(){var t=this._toolsView;return t&&t.show(),this},onToolEvent:function(t){switch(t){case"remove":this.removeTools();break;case"hide":this.hideTools();break;case"show":this.showTools()}},pointerdblclick:function(t,e,i){this.notify("cell:pointerdblclick",t,e,i)},pointerclick:function(t,e,i){this.notify("cell:pointerclick",t,e,i)},contextmenu:function(t,e,i){this.notify("cell:contextmenu",t,e,i)},pointerdown:function(t,e,i){this.model.graph&&(this.model.startBatch("pointer"),this._graph=this.model.graph),this.notify("cell:pointerdown",t,e,i)},pointermove:function(t,e,i){this.notify("cell:pointermove",t,e,i)},pointerup:function(t,e,i){this.notify("cell:pointerup",t,e,i),this._graph&&(this._graph.stopBatch("pointer",{cell:this.model}),delete this._graph)},mouseover:function(t){this.notify("cell:mouseover",t)},mouseout:function(t){this.notify("cell:mouseout",t)},mouseenter:function(t){this.notify("cell:mouseenter",t)},mouseleave:function(t){this.notify("cell:mouseleave",t)},mousewheel:function(t,e,i,n){this.notify("cell:mousewheel",t,e,i,n)},onevent:function(t,e,i,n){this.notify(e,t,i,n)},onmagnet:function(){},magnetpointerdblclick:function(){},magnetcontextmenu:function(){},setInteractivity:function(t){this.options.interactive=t}},{dispatchToolsEvent:function(t,e){"string"==typeof e&&t instanceof joint.dia.Paper&&t.trigger("tools:event",e)}}),joint.dia.Element=joint.dia.Cell.extend({defaults:{position:{x:0,y:0},size:{width:1,height:1},angle:0},initialize:function(){this._initializePorts(),joint.dia.Cell.prototype.initialize.apply(this,arguments)},_initializePorts:function(){},isElement:function(){return!0},position:function(t,e,i){var n=joint.util.isNumber(e);if((i=(n?i:t)||{}).parentRelative){if(!this.graph)throw new Error("Element must be part of a graph.");var r=this.getParentCell(),o=r&&!r.isLink()?r.get("position"):{x:0,y:0}}if(n){if(i.parentRelative&&(t+=o.x,e+=o.y),i.deep){var s=this.get("position");this.translate(t-s.x,e-s.y,i)}else this.set("position",{x:t,y:e},i);return this}var a=g.point(this.get("position"));return i.parentRelative?a.difference(o):a},translate:function(t,e,i){if(e=e||0,0===(t=t||0)&&0===e)return this;(i=i||{}).translateBy=i.translateBy||this.id;var n=this.get("position")||{x:0,y:0};if(i.restrictedArea&&i.translateBy===this.id){var r=this.getBBox({deep:!0}),o=i.restrictedArea,s=n.x-r.x,a=n.y-r.y,l=Math.max(o.x+s,Math.min(o.x+o.width+s-r.width,n.x+t)),h=Math.max(o.y+a,Math.min(o.y+o.height+a-r.height,n.y+e));t=l-n.x,e=h-n.y}var u={x:n.x+t,y:n.y+e};return i.tx=t,i.ty=e,i.transition?(joint.util.isObject(i.transition)||(i.transition={}),this.transition("position",u,joint.util.assign({},i.transition,{valueFunction:joint.util.interpolate.object}))):this.set("position",u,i),joint.util.invoke(this.getEmbeddedCells(),"translate",t,e,i),this},size:function(t,e,i){var n=this.get("size");return void 0===t?{width:n.width,height:n.height}:(joint.util.isObject(t)&&(i=e,e=joint.util.isNumber(t.height)?t.height:n.height,t=joint.util.isNumber(t.width)?t.width:n.width),this.resize(t,e,i))},resize:function(t,e,i){if(i=i||{},this.startBatch("resize",i),i.direction){var n=this.get("size");switch(i.direction){case"left":case"right":e=n.height;break;case"top":case"bottom":t=n.width}var r=g.normalizeAngle(this.get("angle")||0),o={"top-right":0,right:0,"top-left":1,top:1,"bottom-left":2,left:2,"bottom-right":3,bottom:3}[i.direction];i.absolute&&(o+=Math.floor((r+45)/90),o%=4);var s=this.getBBox(),a=s[["bottomLeft","corner","topRight","origin"][o]](),l=g.point(a).rotate(s.center(),-r),h=Math.sqrt(t*t+e*e)/2,u=o*Math.PI/2;u+=Math.atan(o%2==0?e/t:t/e),u-=g.toRad(r);var c=g.point.fromPolar(h,u,l),d=g.point(c).offset(t/-2,e/-2);this.set("size",{width:t,height:e},i),this.position(d.x,d.y,i)}else this.set("size",{width:t,height:e},i);return this.stopBatch("resize",i),this},scale:function(t,e,i,n){var r=this.getBBox().scale(t,e,i);return this.startBatch("scale",n),this.position(r.x,r.y,n),this.resize(r.width,r.height,n),this.stopBatch("scale"),this},fitEmbeds:function(t){if(t=t||{},!this.graph)throw new Error("Element must be part of a graph.");var e=this.getEmbeddedCells();if(0<e.length){this.startBatch("fit-embeds",t),t.deep&&joint.util.invoke(e,"fitEmbeds",t);var i=this.graph.getCellsBBox(e),n=joint.util.normalizeSides(t.padding);i.moveAndExpand({x:-n.left,y:-n.top,width:n.right+n.left,height:n.bottom+n.top}),this.set({position:{x:i.x,y:i.y},size:{width:i.width,height:i.height}},t),this.stopBatch("fit-embeds")}return this},rotate:function(t,e,i,n){if(i){var r=this.getBBox().center(),o=this.get("size"),s=this.get("position");r.rotate(i,this.get("angle")-t);var a=r.x-o.width/2-s.x,l=r.y-o.height/2-s.y;this.startBatch("rotate",{angle:t,absolute:e,origin:i}),this.position(s.x+a,s.y+l,n),this.rotate(t,e,null,n),this.stopBatch("rotate")}else this.set("angle",e?t:(this.get("angle")+t)%360,n);return this},angle:function(){return g.normalizeAngle(this.get("angle")||0)},getBBox:function(t){if((t=t||{}).deep&&this.graph){var e=this.getEmbeddedCells({deep:!0,breadthFirst:!0});return e.push(this),this.graph.getCellsBBox(e)}var i=this.get("position"),n=this.get("size");return new g.Rect(i.x,i.y,n.width,n.height)}}),joint.dia.ElementView=joint.dia.CellView.extend({_removePorts:function(){},_renderPorts:function(){},className:function(){var t=joint.dia.CellView.prototype.className.apply(this).split(" ");return t.push("element"),t.join(" ")},metrics:null,initialize:function(){joint.dia.CellView.prototype.initialize.apply(this,arguments);var t=this.model;this.listenTo(t,"change:position",this.translate),this.listenTo(t,"change:size",this.resize),this.listenTo(t,"change:angle",this.rotate),this.listenTo(t,"change:markup",this.render),this._initializePorts(),this.metrics={}},_initializePorts:function(){},update:function(t,e){this.metrics={},this._removePorts();var i=this.model,n=i.attr();this.updateDOMSubtreeAttributes(this.el,n,{rootBBox:new g.Rect(i.size()),selectors:this.selectors,scalableNode:this.scalableNode,rotatableNode:this.rotatableNode,roAttributes:e===n?null:e}),this._renderPorts()},rotatableSelector:"rotatable",scalableSelector:"scalable",scalableNode:null,rotatableNode:null,renderMarkup:function(){var t=this.model,e=t.get("markup")||t.markup;if(!e)throw new Error("dia.ElementView: markup required");if(Array.isArray(e))return this.renderJSONMarkup(e);if("string"==typeof e)return this.renderStringMarkup(e);throw new Error("dia.ElementView: invalid markup")},renderJSONMarkup:function(t){var e=this.parseDOMJSON(t,this.el),i=this.selectors=e.selectors;this.rotatableNode=V(i[this.rotatableSelector])||null,this.scalableNode=V(i[this.scalableSelector])||null,this.vel.append(e.fragment)},renderStringMarkup:function(t){var e=this.vel;e.append(V(t)),this.rotatableNode=e.findOne(".rotatable"),this.scalableNode=e.findOne(".scalable"),(this.selectors={})[this.selector]=this.el},render:function(){return this.vel.empty(),this.renderMarkup(),this.scalableNode&&this.update(),this.resize(),this.rotatableNode?(this.rotate(),this.translate()):this.updateTransformation(),this},resize:function(){if(this.scalableNode)return this.sgResize.apply(this,arguments);this.model.attributes.angle&&this.rotate(),this.update()},translate:function(){if(this.rotatableNode)return this.rgTranslate();this.updateTransformation()},rotate:function(){if(this.rotatableNode)return this.rgRotate();this.updateTransformation()},updateTransformation:function(){var t=this.getTranslateString(),e=this.getRotateString();e&&(t+=" "+e),this.vel.attr("transform",t)},getTranslateString:function(){var t=this.model.attributes.position;return"translate("+t.x+","+t.y+")"},getRotateString:function(){var t=this.model.attributes,e=t.angle;if(!e)return null;var i=t.size;return"rotate("+e+","+i.width/2+","+i.height/2+")"},getBBox:function(t){var e;if(t&&t.useModelGeometry){var i=this.model;e=i.getBBox().bbox(i.angle())}else e=this.getNodeBBox(this.el);return this.paper.localToPaperRect(e)},nodeCache:function(t){var e=this.metrics;if(!e)return{};var i=V.ensureId(t),n=e[i];return n||(n=e[i]={}),n},getNodeData:function(t){var e=this.nodeCache(t);return e.data||(e.data={}),e.data},getNodeBBox:function(t){var e=this.getNodeBoundingRect(t),i=this.getNodeMatrix(t),n=this.getRootTranslateMatrix(),r=this.getRootRotateMatrix();return V.transformRect(e,n.multiply(r).multiply(i))},getNodeBoundingRect:function(t){var e=this.nodeCache(t);return void 0===e.boundingRect&&(e.boundingRect=V(t).getBBox()),new g.Rect(e.boundingRect)},getNodeUnrotatedBBox:function(t){var e=this.getNodeBoundingRect(t),i=this.getNodeMatrix(t),n=this.getRootTranslateMatrix();return V.transformRect(e,n.multiply(i))},getNodeShape:function(t){var e=this.nodeCache(t);return void 0===e.geometryShape&&(e.geometryShape=V(t).toGeometryShape()),e.geometryShape.clone()},getNodeMatrix:function(t){var e=this.nodeCache(t);if(void 0===e.magnetMatrix){var i=this.rotatableNode||this.el;e.magnetMatrix=V(t).getTransformToElement(i)}return V.createSVGMatrix(e.magnetMatrix)},getRootTranslateMatrix:function(){var t=this.model.position();return V.createSVGMatrix().translate(t.x,t.y)},getRootRotateMatrix:function(){var t=V.createSVGMatrix(),e=this.model,i=e.angle();if(i){var n=e.getBBox(),r=n.width/2,o=n.height/2;t=t.translate(r,o).rotate(i).translate(-r,-o)}return t},rgRotate:function(){this.rotatableNode.attr("transform",this.getRotateString())},rgTranslate:function(){this.vel.attr("transform",this.getTranslateString())},sgResize:function(t,e,i){var n=this.model,r=n.get("angle")||0,o=n.get("size")||{width:1,height:1},s=this.scalableNode,a=!1;0<s.node.getElementsByTagName("path").length&&(a=!0);var l=s.getBBox({recursive:a}),h=o.width/(l.width||1),u=o.height/(l.height||1);s.attr("transform","scale("+h+","+u+")");var c=this.rotatableNode,d=c&&c.attr("transform");if(d){c.attr("transform",d+" rotate("+-r+","+o.width/2+","+o.height/2+")");var f=s.getBBox({target:this.paper.viewport});n.set("position",{x:f.x,y:f.y},i),this.rotate()}this.update()},prepareEmbedding:function(t){t||(t={});var e=t.model||this.model,i=(t.paper||this.paper).model;e.startBatch("to-front"),e.toFront({deep:!0,ui:!0});var n=i.getElements().reduce(function(t,e){return Math.max(t,e.attributes.z||0)},0);i.getConnectedLinks(e,{deep:!0,includeEnclosed:!0}).forEach(function(t){t.attributes.z<=n&&t.set("z",n+1,{ui:!0})}),e.stopBatch("to-front");var r=e.parent();r&&i.getCell(r).unembed(e,{ui:!0})},processEmbedding:function(t){t||(t={});var e=t.model||this.model,i=t.paper||this.paper,n=i.options,r=[];joint.util.isFunction(n.findParentBy)?r=joint.util.toArray(n.findParentBy.call(i.model,this)).filter(function(t){return t instanceof joint.dia.Cell&&this.model.id!==t.id&&!t.isEmbeddedIn(this.model)}.bind(this)):r=i.model.findModelsUnderElement(e,{searchBy:n.findParentBy});n.frontParentOnly&&(r=r.slice(-1));for(var o=null,s=t.candidateEmbedView,a=r.length-1;0<=a;a--){var l=r[a];if(s&&s.model.id==l.id){o=s;break}var h=l.findView(i);if(n.validateEmbedding.call(i,this,h)){o=h;break}}o&&o!=s&&(this.clearEmbedding(t),t.candidateEmbedView=o.highlight(null,{embedding:!0})),!o&&s&&this.clearEmbedding(t)},clearEmbedding:function(t){t||(t={});var e=t.candidateEmbedView;e&&(e.unhighlight(null,{embedding:!0}),t.candidateEmbedView=null)},finalizeEmbedding:function(t){t||(t={});var e=t.candidateEmbedView,i=t.model||this.model,n=t.paper||this.paper;e&&(e.model.embed(i,{ui:!0}),e.unhighlight(null,{embedding:!0}),t.candidateEmbedView=null),joint.util.invoke(n.model.getConnectedLinks(i,{deep:!0}),"reparent",{ui:!0})},getDelegatedView:function(){for(var t=this,e=t.model,i=t.paper;t&&!e.isLink();){if(!e.isEmbedded()||t.can("stopDelegation"))return t;e=e.getParentCell(),t=i.findViewByModel(e)}return null},pointerdblclick:function(t,e,i){joint.dia.CellView.prototype.pointerdblclick.apply(this,arguments),this.notify("element:pointerdblclick",t,e,i)},pointerclick:function(t,e,i){joint.dia.CellView.prototype.pointerclick.apply(this,arguments),this.notify("element:pointerclick",t,e,i)},contextmenu:function(t,e,i){joint.dia.CellView.prototype.contextmenu.apply(this,arguments),this.notify("element:contextmenu",t,e,i)},pointerdown:function(t,e,i){this.isPropagationStopped(t)||(joint.dia.CellView.prototype.pointerdown.apply(this,arguments),this.notify("element:pointerdown",t,e,i),this.dragStart(t,e,i))},pointermove:function(t,e,i){var n=this.eventData(t);switch(n.action){case"magnet":this.dragMagnet(t,e,i);break;case"move":(n.delegatedView||this).drag(t,e,i);default:joint.dia.CellView.prototype.pointermove.apply(this,arguments),this.notify("element:pointermove",t,e,i)}this.eventData(t,n)},pointerup:function(t,e,i){var n=this.eventData(t);switch(n.action){case"magnet":this.dragMagnetEnd(t,e,i);break;case"move":(n.delegatedView||this).dragEnd(t,e,i);default:this.notify("element:pointerup",t,e,i),joint.dia.CellView.prototype.pointerup.apply(this,arguments)}var r=n.targetMagnet;r&&this.magnetpointerclick(t,r,e,i)},mouseover:function(t){joint.dia.CellView.prototype.mouseover.apply(this,arguments),this.notify("element:mouseover",t)},mouseout:function(t){joint.dia.CellView.prototype.mouseout.apply(this,arguments),this.notify("element:mouseout",t)},mouseenter:function(t){joint.dia.CellView.prototype.mouseenter.apply(this,arguments),this.notify("element:mouseenter",t)},mouseleave:function(t){joint.dia.CellView.prototype.mouseleave.apply(this,arguments),this.notify("element:mouseleave",t)},mousewheel:function(t,e,i,n){joint.dia.CellView.prototype.mousewheel.apply(this,arguments),this.notify("element:mousewheel",t,e,i,n)},onmagnet:function(t,e,i){this.dragMagnetStart(t,e,i)},magnetpointerdblclick:function(t,e,i,n){this.notify("element:magnet:pointerdblclick",t,e,i,n)},magnetcontextmenu:function(t,e,i,n){this.notify("element:magnet:contextmenu",t,e,i,n)},dragStart:function(t,e,i){var n=this.getDelegatedView();n&&n.can("elementMove")&&(this.eventData(t,{action:"move",delegatedView:n}),n.eventData(t,{x:e,y:i,restrictedArea:this.paper.getRestrictedArea(n)}))},dragMagnetStart:function(t,e,i){if(this.can("addLinkFromMagnet")){var n=t.currentTarget,r=this.paper;this.eventData(t,{targetMagnet:n}),t.stopPropagation(),r.options.validateMagnet(this,n)?(r.options.magnetThreshold<=0&&this.dragLinkStart(t,n,e,i),this.eventData(t,{action:"magnet"}),this.stopPropagation(t)):this.pointerdown(t,e,i),r.delegateDragEvents(this,t.data)}},dragLinkStart:function(t,e,i,n){this.model.startBatch("add-link");var r=this.addLinkFromMagnet(e,i,n);joint.dia.CellView.prototype.pointerdown.apply(r,arguments),r.notify("link:pointerdown",t,i,n),r.eventData(t,r.startArrowheadMove("target",{whenNotAllowed:"remove"})),this.eventData(t,{linkView:r})},addLinkFromMagnet:function(t,e,i){var n=this.paper,r=n.model,o=n.getDefaultLink(this,t);return o.set({source:this.getLinkEnd(t,e,i,o,"source"),target:{x:e,y:i}}).addTo(r,{async:!1,ui:!0}),o.findView(n)},drag:function(t,e,i){var n=this.paper,r=n.options.gridSize,o=this.model,s=o.position(),a=this.eventData(t),l=g.snapToGrid(s.x,r)-s.x+g.snapToGrid(e-a.x,r),h=g.snapToGrid(s.y,r)-s.y+g.snapToGrid(i-a.y,r);o.translate(l,h,{restrictedArea:a.restrictedArea,ui:!0});var u=!!a.embedding;n.options.embeddingMode&&(u||(this.prepareEmbedding(a),u=!0),this.processEmbedding(a)),this.eventData(t,{x:g.snapToGrid(e,r),y:g.snapToGrid(i,r),embedding:u})},dragMagnet:function(t,e,i){var n=this.eventData(t),r=n.linkView;if(r)r.pointermove(t,e,i);else{var o=this.paper,s=o.options.magnetThreshold,a=this.getEventTarget(t),l=n.targetMagnet;if("onleave"===s){if(l===a||V(l).contains(a))return}else if(o.eventData(t).mousemoved<=s)return;this.dragLinkStart(t,l,e,i)}},dragEnd:function(t,e,i){var n=this.eventData(t);n.embedding&&this.finalizeEmbedding(n)},dragMagnetEnd:function(t,e,i){var n=this.eventData(t).linkView;n&&(n.pointerup(t,e,i),this.model.stopBatch("add-link"))},magnetpointerclick:function(t,e,i,n){var r=this.paper;r.eventData(t).mousemoved>r.options.clickThreshold||this.notify("element:magnet:pointerclick",t,e,i,n)}}),joint.dia.Link=joint.dia.Cell.extend({markup:['<path class="connection" stroke="black" d="M 0 0 0 0"/>','<path class="marker-source" fill="black" stroke="black" d="M 0 0 0 0"/>','<path class="marker-target" fill="black" stroke="black" d="M 0 0 0 0"/>','<path class="connection-wrap" d="M 0 0 0 0"/>','<g class="labels"/>','<g class="marker-vertices"/>','<g class="marker-arrowheads"/>','<g class="link-tools"/>'].join(""),toolMarkup:['<g class="link-tool">','<g class="tool-remove" event="remove">','<circle r="11" />','<path transform="scale(.8) translate(-16, -16)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z" />',"<title>Remove link.</title>","</g>",'<g class="tool-options" event="link:options">','<circle r="11" transform="translate(25)"/>','<path fill="white" transform="scale(.55) translate(29, -16)" d="M31.229,17.736c0.064-0.571,0.104-1.148,0.104-1.736s-0.04-1.166-0.104-1.737l-4.377-1.557c-0.218-0.716-0.504-1.401-0.851-2.05l1.993-4.192c-0.725-0.91-1.549-1.734-2.458-2.459l-4.193,1.994c-0.647-0.347-1.334-0.632-2.049-0.849l-1.558-4.378C17.165,0.708,16.588,0.667,16,0.667s-1.166,0.041-1.737,0.105L12.707,5.15c-0.716,0.217-1.401,0.502-2.05,0.849L6.464,4.005C5.554,4.73,4.73,5.554,4.005,6.464l1.994,4.192c-0.347,0.648-0.632,1.334-0.849,2.05l-4.378,1.557C0.708,14.834,0.667,15.412,0.667,16s0.041,1.165,0.105,1.736l4.378,1.558c0.217,0.715,0.502,1.401,0.849,2.049l-1.994,4.193c0.725,0.909,1.549,1.733,2.459,2.458l4.192-1.993c0.648,0.347,1.334,0.633,2.05,0.851l1.557,4.377c0.571,0.064,1.148,0.104,1.737,0.104c0.588,0,1.165-0.04,1.736-0.104l1.558-4.377c0.715-0.218,1.399-0.504,2.049-0.851l4.193,1.993c0.909-0.725,1.733-1.549,2.458-2.458l-1.993-4.193c0.347-0.647,0.633-1.334,0.851-2.049L31.229,17.736zM16,20.871c-2.69,0-4.872-2.182-4.872-4.871c0-2.69,2.182-4.872,4.872-4.872c2.689,0,4.871,2.182,4.871,4.872C20.871,18.689,18.689,20.871,16,20.871z"/>',"<title>Link options.</title>","</g>","</g>"].join(""),doubleToolMarkup:void 0,vertexMarkup:['<g class="marker-vertex-group" transform="translate(<%= x %>, <%= y %>)">','<circle class="marker-vertex" idx="<%= idx %>" r="10" />','<path class="marker-vertex-remove-area" idx="<%= idx %>" d="M16,5.333c-7.732,0-14,4.701-14,10.5c0,1.982,0.741,3.833,2.016,5.414L2,25.667l5.613-1.441c2.339,1.317,5.237,2.107,8.387,2.107c7.732,0,14-4.701,14-10.5C30,10.034,23.732,5.333,16,5.333z" transform="translate(5, -33)"/>','<path class="marker-vertex-remove" idx="<%= idx %>" transform="scale(.8) translate(9.5, -37)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z">',"<title>Remove vertex.</title>","</path>","</g>"].join(""),arrowheadMarkup:['<g class="marker-arrowhead-group marker-arrowhead-group-<%= end %>">','<path class="marker-arrowhead" end="<%= end %>" d="M 26 0 L 0 13 L 26 26 z" />',"</g>"].join(""),defaultLabel:void 0,labelMarkup:void 0,_builtins:{defaultLabel:{markup:[{tagName:"rect",selector:"rect"},{tagName:"text",selector:"text"}],attrs:{text:{fill:"#000000",fontSize:14,textAnchor:"middle",yAlignment:"middle",pointerEvents:"none"},rect:{ref:"text",fill:"#ffffff",rx:3,ry:3,refWidth:1,refHeight:1,refX:0,refY:0}},position:{distance:.5}}},defaults:{type:"link",source:{},target:{}},isLink:function(){return!0},disconnect:function(t){return this.set({source:{x:0,y:0},target:{x:0,y:0}},t)},source:function(t,e,i){return void 0===t?joint.util.clone(this.get("source")):(r=t instanceof joint.dia.Cell?((n=joint.util.clone(e)||{}).id=t.id,i):t instanceof g.Point?((n=joint.util.clone(e)||{}).x=t.x,n.y=t.y,i):(n=t,e),this.set("source",n,r));var n,r},target:function(t,e,i){return void 0===t?joint.util.clone(this.get("target")):(r=t instanceof joint.dia.Cell?((n=joint.util.clone(e)||{}).id=t.id,i):t instanceof g.Point?((n=joint.util.clone(e)||{}).x=t.x,n.y=t.y,i):(n=t,e),this.set("target",n,r));var n,r},router:function(t,e,i){if(void 0===t){var n=this.get("router");return n?"object"==typeof n?joint.util.clone(n):n:this.get("manhattan")?{name:"orthogonal"}:null}var r="object"==typeof t||"function"==typeof t,o=r?t:{name:t,args:e},s=r?e:i;return this.set("router",o,s)},connector:function(t,e,i){if(void 0===t){var n=this.get("connector");return n?"object"==typeof n?joint.util.clone(n):n:this.get("smooth")?{name:"smooth"}:null}var r="object"==typeof t||"function"==typeof t,o=r?t:{name:t,args:e},s=r?e:i;return this.set("connector",o,s)},label:function(t,e,i){var n=this.labels();return(t=isFinite(t)&&null!==t?0|t:0)<0&&(t=n.length+t),arguments.length<=1?this.prop(["labels",t]):this.prop(["labels",t],e,i)},labels:function(t,e){return 0===arguments.length?(t=this.get("labels"),Array.isArray(t)?t.slice():[]):(Array.isArray(t)||(t=[]),this.set("labels",t,e))},insertLabel:function(t,e,i){if(!e)throw new Error("dia.Link: no label provided");var n=this.labels(),r=n.length;return(t=isFinite(t)&&null!==t?0|t:r)<0&&(t=r+t+1),n.splice(t,0,e),this.labels(n,i)},appendLabel:function(t,e){return this.insertLabel(-1,t,e)},removeLabel:function(t,e){var i=this.labels();return t=isFinite(t)&&null!==t?0|t:-1,i.splice(t,1),this.labels(i,e)},vertex:function(t,e,i){var n=this.vertices();return(t=isFinite(t)&&null!==t?0|t:0)<0&&(t=n.length+t),arguments.length<=1?this.prop(["vertices",t]):this.prop(["vertices",t],e,i)},vertices:function(t,e){return 0===arguments.length?(t=this.get("vertices"),Array.isArray(t)?t.slice():[]):(Array.isArray(t)||(t=[]),this.set("vertices",t,e))},insertVertex:function(t,e,i){if(!e)throw new Error("dia.Link: no vertex provided");var n=this.vertices(),r=n.length;return(t=isFinite(t)&&null!==t?0|t:r)<0&&(t=r+t+1),n.splice(t,0,e),this.vertices(n,i)},removeVertex:function(t,e){var i=this.vertices();return t=isFinite(t)&&null!==t?0|t:-1,i.splice(t,1),this.vertices(i,e)},translate:function(e,i,t){return(t=t||{}).translateBy=t.translateBy||this.id,t.tx=e,t.ty=i,this.applyToPoints(function(t){return{x:(t.x||0)+e,y:(t.y||0)+i}},t)},scale:function(e,i,n,t){return this.applyToPoints(function(t){return g.point(t).scale(e,i,n).toJSON()},t)},applyToPoints:function(t,e){if(!joint.util.isFunction(t))throw new TypeError("dia.Link: applyToPoints expects its first parameter to be a function.");var i={},n=this.source();n.id||(i.source=t(n));var r=this.target();r.id||(i.target=t(r));var o=this.vertices();return 0<o.length&&(i.vertices=o.map(t)),this.set(i,e)},reparent:function(t){var e;if(this.graph){var i=this.getSourceElement(),n=this.getTargetElement(),r=this.getParentCell();i&&n&&(e=i===n||i.isEmbeddedIn(n)?n:n.isEmbeddedIn(i)?i:this.graph.getCommonAncestor(i,n)),!r||e&&e.id===r.id||r.unembed(this,t),e&&e.embed(this,t)}return e},hasLoop:function(t){t=t||{};var e=this.source().id,i=this.target().id;if(!e||!i)return!1;var n=e===i;if(!n&&t.deep&&this.graph){var r=this.getSourceElement(),o=this.getTargetElement();n=r.isEmbeddedIn(o)||o.isEmbeddedIn(r)}return n},getSourceElement:function(){var t=this.source(),e=this.graph;return t&&t.id&&e&&e.getCell(t.id)||null},getTargetElement:function(){var t=this.target(),e=this.graph;return t&&t.id&&e&&e.getCell(t.id)||null},getRelationshipAncestor:function(){var t;if(this.graph){var e=[this,this.getSourceElement(),this.getTargetElement()].filter(function(t){return!!t});t=this.graph.getCommonAncestor.apply(this.graph,e)}return t||null},isRelationshipEmbeddedIn:function(t){var e=joint.util.isString(t)||joint.util.isNumber(t)?t:t.id,i=this.getRelationshipAncestor();return!!i&&(i.id===e||i.isEmbeddedIn(e))},_getDefaultLabel:function(){var t=this.get("defaultLabel")||this.defaultLabel||{},e={};return e.markup=t.markup||this.get("labelMarkup")||this.labelMarkup,e.position=t.position,e.attrs=t.attrs,e.size=t.size,e}},{endsEqual:function(t,e){var i=t.port===e.port||!t.port&&!e.port;return t.id===e.id&&i}}),joint.dia.LinkView=joint.dia.CellView.extend({className:function(){var t=joint.dia.CellView.prototype.className.apply(this).split(" ");return t.push("link"),t.join(" ")},options:{shortLinkLength:105,doubleLinkTools:!1,longLinkLength:155,linkToolsOffset:40,doubleLinkToolsOffset:65,sampleInterval:50},_labelCache:null,_labelSelectors:null,_markerCache:null,_V:null,_dragData:null,metrics:null,decimalsRounding:2,initialize:function(t){joint.dia.CellView.prototype.initialize.apply(this,arguments),"function"!=typeof this.constructor.prototype.watchSource&&(this.constructor.prototype.watchSource=this.createWatcher("source"),this.constructor.prototype.watchTarget=this.createWatcher("target")),this._labelCache={},this._labelSelectors={},this._markerCache={},this._V={},this.metrics={},this.startListening()},startListening:function(){var t=this.model;this.listenTo(t,"change:markup",this.render),this.listenTo(t,"change:smooth change:manhattan change:router change:connector",this.update),this.listenTo(t,"change:toolMarkup",this.onToolsChange),this.listenTo(t,"change:labels change:labelMarkup",this.onLabelsChange),this.listenTo(t,"change:vertices change:vertexMarkup",this.onVerticesChange),this.listenTo(t,"change:source",this.onSourceChange),this.listenTo(t,"change:target",this.onTargetChange)},onSourceChange:function(t,e,i){this.watchSource(t,e);var n=this.model;i.translateBy&&n.get("target").id&&e.id||this.update(n,null,i)},onTargetChange:function(t,e,i){this.watchTarget(t,e);var n=this.model;(!i.translateBy||n.get("source").id&&!e.id&&joint.util.isEmpty(n.get("vertices")))&&this.update(n,null,i)},onVerticesChange:function(t,e,i){this.renderVertexMarkers(),i.translateBy&&i.translateBy!==this.model.id&&!this.model.hasLoop()||this.update(t,null,i)},onToolsChange:function(){this.renderTools().updateToolsPosition()},onLabelsChange:function(t,e,i){var n=!0,r=this.model.previous("labels");if(r&&"propertyPathArray"in i&&"propertyValue"in i){var o=i.propertyPathArray||[],s=o.length;if(1<s)!!r[o[1]]&&(2===s?n="markup"in Object(i.propertyValue):"markup"!==o[2]&&(n=!1))}n?this.renderLabels():this.updateLabels(),this.updateLabelPositions()},render:function(){this.vel.empty(),this._V={},this.renderMarkup(),this.renderLabels();var t=this.model;return this.watchSource(t,t.source()).watchTarget(t,t.target()).update(),this},renderMarkup:function(){var t=this.model,e=t.get("markup")||t.markup;if(!e)throw new Error("dia.LinkView: markup required");if(Array.isArray(e))return this.renderJSONMarkup(e);if("string"==typeof e)return this.renderStringMarkup(e);throw new Error("dia.LinkView: invalid markup")},renderJSONMarkup:function(t){var e=this.parseDOMJSON(t,this.el);this.selectors=e.selectors,this.vel.append(e.fragment)},renderStringMarkup:function(t){var e=V(t);Array.isArray(e)||(e=[e]);for(var i=this._V,n=0,r=e.length;n<r;n++){var o=e[n],s=o.attr("class");s&&(s=joint.util.removeClassNamePrefix(s),i[$.camelCase(s)]=o)}this.renderTools(),this.renderVertexMarkers(),this.renderArrowheadMarkers(),this.vel.append(e)},_getLabelMarkup:function(t){if(t){if(Array.isArray(t))return this.parseDOMJSON(t,null);if("string"==typeof t)return this._getLabelStringMarkup(t);throw new Error("dia.linkView: invalid label markup")}},_getLabelStringMarkup:function(t){var e=V(t),i=document.createDocumentFragment();if(Array.isArray(e))for(var n=0,r=e.length;n<r;n++){var o=e[n].node;i.appendChild(o)}else i.appendChild(e.node);return{fragment:i,selectors:{}}},_normalizeLabelMarkup:function(t){if(t){var e,i=t.fragment;if(!(t.fragment instanceof DocumentFragment&&t.fragment.hasChildNodes()))throw new Error("dia.LinkView: invalid label markup.");var n=i.childNodes;return(e=1<n.length||"G"!==n[0].nodeName.toUpperCase()?V("g").append(i):V(n[0])).addClass("label"),{node:e.node,selectors:t.selectors}}},renderLabels:function(){var t=this._V,e=t.labels,i=this._labelCache={},n=this._labelSelectors={},r=this.model,o=r.attributes.labels||[],s=o.length;if(0===s)return e&&e.remove(),this;e?e.empty():e=t.labels=V("g").addClass("labels");for(var a=e.node,l=0;l<s;l++){var h,u,c=o[l],d=this._normalizeLabelMarkup(this._getLabelMarkup(c.markup));if(d)h=d.node,u=d.selectors;else{var f=r._builtins.defaultLabel,g=this._normalizeLabelMarkup(this._getLabelMarkup(f.markup)),p=r._getDefaultLabel(),m=this._normalizeLabelMarkup(this._getLabelMarkup(p.markup))||g;h=m.node,u=m.selectors}h.setAttribute("label-idx",l),a.appendChild(h),i[l]=h;var v=this.selector;if(u[v])throw new Error("dia.LinkView: ambiguous label root selector.");u[v]=h,n[l]=u}return a.parentNode||this.el.appendChild(a),this.updateLabels(),this},_mergeLabelAttrs:function(t,e,i,n){return null===e?null:void 0!==e?t?joint.util.merge({},i,e):joint.util.merge({},n,i,e):null===i?null:void 0!==i?t?i:joint.util.merge({},n,i):t?void 0:n},updateLabels:function(){if(!this._V.labels)return this;for(var t=this.model,e=t.get("labels")||[],i=this.can("labelMove"),n=t._builtins.defaultLabel.attrs,r=t._getDefaultLabel(),o=r.markup,s=r.attrs,a=0,l=e.length;a<l;a++){var h=this._labelCache[a];h.setAttribute("cursor",i?"move":"default");var u=this._labelSelectors[a],c=e[a],d=c.markup,f=c.attrs,p=this._mergeLabelAttrs(d||o,f,s,n);this.updateDOMSubtreeAttributes(h,p,{rootBBox:new g.Rect(c.size),selectors:u})}return this},renderTools:function(){if(!this._V.linkTools)return this;var t,e=$(this._V.linkTools.node).empty(),i=joint.util.template(this.model.get("toolMarkup")||this.model.toolMarkup),n=V(i());(e.append(n.node),this._toolCache=n,this.options.doubleLinkTools)&&(t=this.model.get("doubleToolMarkup")||this.model.doubleToolMarkup?(i=joint.util.template(this.model.get("doubleToolMarkup")||this.model.doubleToolMarkup),V(i())):n.clone(),e.append(t.node),this._tool2Cache=t);return this},renderVertexMarkers:function(){if(!this._V.markerVertices)return this;var i=$(this._V.markerVertices.node).empty(),n=joint.util.template(this.model.get("vertexMarkup")||this.model.vertexMarkup);return this.model.vertices().forEach(function(t,e){i.append(V(n(joint.util.assign({idx:e},t))).node)}),this},renderArrowheadMarkers:function(){if(!this._V.markerArrowheads)return this;var t=$(this._V.markerArrowheads.node);t.empty();var e=joint.util.template(this.model.get("arrowheadMarkup")||this.model.arrowheadMarkup);return this._V.sourceArrowhead=V(e({end:"source"})),this._V.targetArrowhead=V(e({end:"target"})),t.append(this._V.sourceArrowhead.node,this._V.targetArrowhead.node),this},update:function(t,e,i){return i||(i={}),this.updateConnection(i),this.updateDOMSubtreeAttributes(this.el,this.model.attr(),{selectors:this.selectors}),this.updateDefaultConnectionPath(),this.updateLabelPositions(),this.updateToolsPosition(),this.updateArrowheadMarkers(),this.updateTools(i),this.options.perpendicular=null,this.updatePostponed=!1,this},removeRedundantLinearVertices:function(t){for(var e=this.model,i=e.vertices(),n=[],r=i.length,o=0,s=0;s<r;s++){var a=new g.Point(i[s]).round(),l=new g.Point(n[o-1]||this.sourceAnchor).round();if(!l.equals(a)){var h=new g.Point(i[s+1]||this.targetAnchor).round();if(!l.equals(h))0!==new g.Line(l,h).pointOffset(a)&&(n.push(i[s]),o++)}}return r===o?0:(e.vertices(n,t),r-o)},updateDefaultConnectionPath:function(){var t=this._V;t.connection&&t.connection.attr("d",this.getSerializedConnection()),t.connectionWrap&&t.connectionWrap.attr("d",this.getSerializedConnection()),t.markerSource&&t.markerTarget&&this._translateAndAutoOrientArrows(t.markerSource,t.markerTarget)},getEndView:function(t){switch(t){case"source":return this.sourceView||null;case"target":return this.targetView||null;default:throw new Error("dia.LinkView: type parameter required.")}},getEndAnchor:function(t){switch(t){case"source":return new g.Point(this.sourceAnchor);case"target":return new g.Point(this.targetAnchor);default:throw new Error("dia.LinkView: type parameter required.")}},getEndMagnet:function(t){switch(t){case"source":var e=this.sourceView;if(!e)break;return this.sourceMagnet||e.el;case"target":var i=this.targetView;if(!i)break;return this.targetMagnet||i.el;default:throw new Error("dia.LinkView: type parameter required.")}return null},updateConnection:function(t){t=t||{};var e,i,n=this.model;if(t.translateBy&&n.isRelationshipEmbeddedIn(t.translateBy)){var r=t.tx||0,o=t.ty||0;e=new g.Polyline(this.route).translate(r,o).points,this._translateConnectionPoints(r,o),(i=this.path).translate(r,o)}else{var s=n.vertices(),a=this.findAnchors(s),l=this.sourceAnchor=a.source,h=this.targetAnchor=a.target;e=this.findRoute(s,t);var u=this.findConnectionPoints(e,l,h),c=this.sourcePoint=u.source,d=this.targetPoint=u.target,f=this.findMarkerPoints(e,c,d);i=this.findPath(e,f.source||c,f.target||d)}this.route=e,this.path=i,this.metrics={}},findMarkerPoints:function(t,e,i){var n,r,o=t[0],s=t[t.length-1],a=this._markerCache;return this._V.markerSource&&(a.sourceBBox=a.sourceBBox||this._V.markerSource.getBBox(),n=g.point(e).move(o||i,a.sourceBBox.width*this._V.markerSource.scale().sx*-1).round()),this._V.markerTarget&&(a.targetBBox=a.targetBBox||this._V.markerTarget.getBBox(),r=g.point(i).move(s||e,a.targetBBox.width*this._V.markerTarget.scale().sx*-1).round()),a.sourcePoint=n||e.clone(),a.targetPoint=r||i.clone(),{source:n,target:r}},findAnchors:function(t){var e,i,n,r,o,s=this.model,a=t[0],l=t[t.length-1],h=s.get("source"),u=s.get("target"),c=this.sourceView,d=this.targetView;c?(e=this.sourceMagnet||c.el,r=a?new g.Point(a):d?this.targetMagnet||d.el:new g.Point(u),n=this.getAnchor(h.anchor,c,e,r,"source")):n=new g.Point(h);if(d){i=this.targetMagnet||d.el;var f=new g.Point(l||n);o=this.getAnchor(u.anchor,d,i,f,"target")}else o=new g.Point(u);return{source:n,target:o}},findConnectionPoints:function(t,e,i){var n,r,o,s,a=t[0],l=t[t.length-1],h=this.model,u=h.get("source"),c=h.get("target"),d=this.sourceView,f=this.targetView,p=this.paper.options;if(d){n=this.sourceMagnet||d.el;var m=u.connectionPoint||p.defaultConnectionPoint,v=a||i,y=new g.Line(v,e);o=this.getConnectionPoint(m,d,n,y,"source")}else o=e;if(f){r=this.targetMagnet||f.el;var b=c.connectionPoint||p.defaultConnectionPoint,w=l||e,x=new g.Line(w,i);s=this.getConnectionPoint(b,f,r,x,"target")}else s=i;return{source:o,target:s}},getAnchor:function(t,e,i,n,r){if(!t){var o=this.paper.options;t=o.perpendicularLinks||this.options.perpendicular?{name:"perpendicular"}:o.defaultAnchor}if(!t)throw new Error("Anchor required.");var s;if("function"==typeof t)s=t;else{var a=t.name;if("function"!=typeof(s=joint.anchors[a]))throw new Error("Unknown anchor: "+a)}var l=s.call(this,e,i,n,t.args||{},r,this);return l?l.round(this.decimalsRounding):new g.Point},getConnectionPoint:function(t,e,i,n,r){var o,s,a=n.end,l=this.paper.options;if("function"==typeof l.linkConnectionPoint){var h=i===e.el?void 0:i;if(o=l.linkConnectionPoint(this,e,h,n.start,r))return o}if(!t)return a;if("function"==typeof t)s=t;else{var u=t.name;if("function"!=typeof(s=joint.connectionPoints[u]))throw new Error("Unknown connection point: "+u)}return(o=s.call(this,n,e,i,t.args||{},r,this))?o.round(this.decimalsRounding):a},_translateConnectionPoints:function(t,e){var i=this._markerCache;i.sourcePoint.offset(t,e),i.targetPoint.offset(t,e),this.sourcePoint.offset(t,e),this.targetPoint.offset(t,e),this.sourceAnchor.offset(t,e),this.targetAnchor.offset(t,e)},_normalizeLabelPosition:function(t){return"number"==typeof t?{distance:t,offset:null,args:null}:t},updateLabelPositions:function(){if(!this._V.labels)return this;if(!this.path)return this;var t=this.model,e=t.get("labels")||[];if(!e.length)return this;for(var i=t._builtins.defaultLabel.position,n=t._getDefaultLabel(),r=this._normalizeLabelPosition(n.position),o=joint.util.merge({},i,r),s=0,a=e.length;s<a;s++){var l=e[s],h=this._normalizeLabelPosition(l.position),u=joint.util.merge({},o,h),c=this.getLabelCoordinates(u);this._labelCache[s].setAttribute("transform","translate("+c.x+", "+c.y+")")}return this},updateToolsPosition:function(){if(!this._V.linkTools)return this;var t="",e=this.options.linkToolsOffset,i=this.getConnectionLength();if(!Number.isNaN(i)){i<this.options.shortLinkLength&&(t="scale(.5)",e/=2);var n=this.getPointAtLength(e);if(this._toolCache.attr("transform","translate("+n.x+", "+n.y+") "+t),this.options.doubleLinkTools&&i>=this.options.longLinkLength){var r=this.options.doubleLinkToolsOffset||e;n=this.getPointAtLength(i-r),this._tool2Cache.attr("transform","translate("+n.x+", "+n.y+") "+t),this._tool2Cache.attr("visibility","visible")}else this.options.doubleLinkTools&&this._tool2Cache.attr("visibility","hidden")}return this},updateArrowheadMarkers:function(){if(!this._V.markerArrowheads)return this;if("none"===$.css(this._V.markerArrowheads.node,"display"))return this;var t=this.getConnectionLength()<this.options.shortLinkLength?.5:1;return this._V.sourceArrowhead.scale(t),this._V.targetArrowhead.scale(t),this._translateAndAutoOrientArrows(this._V.sourceArrowhead,this._V.targetArrowhead),this},createWatcher:function(r){var o=function(t,e){this.onEndModelChange(r,t,e)};return function(t,e){e=e||{};var i=null,n=t.previous(r)||{};return n.id&&this.stopListening(this.paper.getModelById(n.id),"change",o),e.id&&(i=this.paper.getModelById(e.id),this.listenTo(i,"change",o)),o.call(this,i,{cacheOnly:!0}),this}},onEndModelChange:function(t,e,i){var n=!i.cacheOnly,r=this.model,o=r.get(t)||{};if(e){var s=this.constructor.makeSelector(o),a="source"==t?"target":"source",l=r.get(a)||{},h=o.id,u=l.id,c=u&&this.constructor.makeSelector(l);if(i.handleBy===this.cid&&h===u&&s==c)this[t+"View"]=this[a+"View"],this[t+"Magnet"]=this[a+"Magnet"];else if(i.translateBy);else{var d=this.paper.model.getCell(h);if(!d)throw new Error("LinkView: invalid "+t+" cell.");var f=d.findView(this.paper);if(f){var g=f.getMagnetFromLinkEnd(o);g===f.el&&(g=null),this[t+"View"]=f,this[t+"Magnet"]=g}else this[t+"View"]=this[t+"Magnet"]=null}if(i.handleBy===this.cid&&i.translateBy&&r.isEmbeddedIn(e)&&!joint.util.isEmpty(r.get("vertices"))&&(n=!1),!this.updatePostponed&&u){var p=this.paper.getModelById(u);o.id===l.id&&(i.translateBy&&!joint.util.isEmpty(r.get("vertices"))&&r.isEmbeddedIn(i.translateBy)?n=!1:i.handleBy=this.cid),n&&(i.handleBy===this.cid||i.translateBy&&p.isEmbeddedIn(i.translateBy))&&(n=!(this.updatePostponed=!0))}}else this[t+"View"]=this[t+"Magnet"]=null;n&&this.update(r,null,i)},_translateAndAutoOrientArrows:function(t,e){var i=joint.util.toArray(this.route);t&&t.translateAndAutoOrient(this.sourcePoint,i[0]||this.targetPoint,this.paper.viewport),e&&e.translateAndAutoOrient(this.targetPoint,i[i.length-1]||this.sourcePoint,this.paper.viewport)},_getDefaultLabelPositionArgs:function(){return(this.model._getDefaultLabel().position||{}).args},_getLabelPositionArgs:function(t){return(this.model.label(t).position||{}).args},_mergeLabelPositionArgs:function(t,e){return null===t?null:void 0===t?null===e?null:e:joint.util.merge({},e,t)},addLabel:function(t,e,i){var n="number"!=typeof t,r=n?t.x:t,o=n?t.y:e,s=n?e:i,a=this._getDefaultLabelPositionArgs(),l=s,h=this._mergeLabelPositionArgs(l,a),u={position:this.getLabelPosition(r,o,h)};return this.model.insertLabel(-1,u,s),-1},addVertex:function(t,e,i){var n="number"!=typeof t,r=n?t.x:t,o=n?t.y:e,s=n?e:i,a={x:r,y:o},l=this.getVertexIndex(r,o);return this.model.insertVertex(l,a,s),l},sendToken:function(t,e,i){var n,r,o;o=joint.util.isObject(e)?(n=e.duration,r="reverse"===e.direction,e.connection):(n=e,r=!1,null);var s={dur:(n=n||1e3)+"ms",repeatCount:1,calcMode:"linear",fill:"freeze"};r&&(s.keyPoints="1;0",s.keyTimes="0;1");var a,l,h,u=V(t);if("string"==typeof o)a=this.findBySelector(o,this.el,this.selectors)[0];else{var c=this._V;a=c.connection?c.connection.node:this.el.querySelector("path")}if(!(a instanceof SVGPathElement))throw new Error("dia.LinkView: token animation requires a valid connection path.");u.appendTo(this.paper.viewport).animateAlongPath(s,a),setTimeout((l=u,h=i,function(){l.remove(),"function"==typeof h&&h()}),n)},findRoute:function(t){t||(t=[]);var e=joint.routers,i=this.model.router(),n=this.paper.options.defaultRouter;if(!i){if(!n)return t.map(g.Point,g);i=n}var r=joint.util.isFunction(i)?i:e[i.name];if(!joint.util.isFunction(r))throw new Error('dia.LinkView: unknown router: "'+i.name+'".');var o=i.args||{},s=r.call(this,t,o,this);return s||t.map(g.Point,g)},findPath:function(t,e,i){var n=joint.connectors,r=this.model.connector(),o=this.paper.options.defaultConnector;r||(r=o||{});var s=joint.util.isFunction(r)?r:n[r.name];if(!joint.util.isFunction(s))throw new Error('dia.LinkView: unknown connector: "'+r.name+'".');var a=joint.util.clone(r.args||{});a.raw=!0;var l=s.call(this,e,i,t,a,this);return"string"==typeof l&&(l=new g.Path(V.normalizePathData(l))),l},getConnection:function(){var t=this.path;return t?t.clone():null},getSerializedConnection:function(){var t=this.path;if(!t)return null;var e=this.metrics;if(e.hasOwnProperty("data"))return e.data;var i=t.serialize();return e.data=i},getConnectionSubdivisions:function(){var t=this.path;if(!t)return null;var e=this.metrics;if(e.hasOwnProperty("segmentSubdivisions"))return e.segmentSubdivisions;var i=t.getSegmentSubdivisions();return e.segmentSubdivisions=i},getConnectionLength:function(){var t=this.path;if(!t)return 0;var e=this.metrics;if(e.hasOwnProperty("length"))return e.length;var i=t.length({segmentSubdivisions:this.getConnectionSubdivisions()});return e.length=i},getPointAtLength:function(t){var e=this.path;return e?e.pointAtLength(t,{segmentSubdivisions:this.getConnectionSubdivisions()}):null},getPointAtRatio:function(t){var e=this.path;return e?e.pointAt(t,{segmentSubdivisions:this.getConnectionSubdivisions()}):null},getTangentAtLength:function(t){var e=this.path;return e?e.tangentAtLength(t,{segmentSubdivisions:this.getConnectionSubdivisions()}):null},getTangentAtRatio:function(t){var e=this.path;return e?e.tangentAt(t,{segmentSubdivisions:this.getConnectionSubdivisions()}):null},getClosestPoint:function(t){var e=this.path;return e?e.closestPoint(t,{segmentSubdivisions:this.getConnectionSubdivisions()}):null},getClosestPointLength:function(t){var e=this.path;return e?e.closestPointLength(t,{segmentSubdivisions:this.getConnectionSubdivisions()}):null},getClosestPointRatio:function(t){var e=this.path;return e?e.closestPointNormalizedLength(t,{segmentSubdivisions:this.getConnectionSubdivisions()}):null},getLabelPosition:function(t,e,i){var n={},r=i||{};i&&(n.args=i);var o,s,a=!r.absoluteDistance,l=r.absoluteDistance&&r.reverseDistance,h=r.absoluteOffset,u=this.path,c={segmentSubdivisions:this.getConnectionSubdivisions()},d=new g.Point(t,e),f=u.closestPointT(d,c),p=u.lengthAtT(f,c);if(a&&(p=p/this.getConnectionLength()||0),l&&(p=-1*(this.getConnectionLength()-p)||1),n.distance=p,h||(o=u.tangentAtT(f)),o)s=o.pointOffset(d);else{var m=u.pointAtT(f),v=d.difference(m);s={x:v.x,y:v.y}}return n.offset=s,n},getLabelCoordinates:function(t){var e;if("number"==typeof t)e=t;else{if("number"!=typeof t.distance)throw new Error("dia.LinkView: invalid label position distance.");e=t.distance}var i=0<e&&e<=1,n=0,r={x:0,y:0};if(t.offset){var o=t.offset;"number"==typeof o&&(n=o),o.x&&(r.x=o.x),o.y&&(r.y=o.y)}var s,a=0!==r.x||0!==r.y||0===n,l=this.path,h={segmentSubdivisions:this.getConnectionSubdivisions()},u=i?e*this.getConnectionLength():e;if(a)(s=l.pointAtLength(u,h)).offset(r);else{var c=l.tangentAtLength(u,h);s=c?(c.rotate(c.start,-90),c.setLength(n),c.end):l.start}return s},getVertexIndex:function(t,e){for(var i=this.model.vertices(),n=this.getClosestPointLength(new g.Point(t,e)),r=0,o=i.length;r<o;r++){var s=i[r];if(n<this.getClosestPointLength(s))break}return r},pointerdblclick:function(t,e,i){joint.dia.CellView.prototype.pointerdblclick.apply(this,arguments),this.notify("link:pointerdblclick",t,e,i)},pointerclick:function(t,e,i){joint.dia.CellView.prototype.pointerclick.apply(this,arguments),this.notify("link:pointerclick",t,e,i)},contextmenu:function(t,e,i){joint.dia.CellView.prototype.contextmenu.apply(this,arguments),this.notify("link:contextmenu",t,e,i)},pointerdown:function(t,e,i){switch(joint.dia.CellView.prototype.pointerdown.apply(this,arguments),this.notify("link:pointerdown",t,e,i),t.target.getAttribute("class")){case"marker-vertex":return void this.dragVertexStart(t,e,i);case"marker-vertex-remove":case"marker-vertex-remove-area":return void this.dragVertexRemoveStart(t,e,i);case"marker-arrowhead":return void this.dragArrowheadStart(t,e,i);case"connection":case"connection-wrap":return void this.dragConnectionStart(t,e,i);case"marker-source":case"marker-target":return}this.dragStart(t,e,i)},pointermove:function(t,e,i){var n=this._dragData;switch(n&&this.eventData(t,n),this.eventData(t).action){case"vertex-move":this.dragVertex(t,e,i);break;case"label-move":this.dragLabel(t,e,i);break;case"arrowhead-move":this.dragArrowhead(t,e,i);break;case"move":this.drag(t,e,i)}n&&joint.util.assign(n,this.eventData(t)),joint.dia.CellView.prototype.pointermove.apply(this,arguments),this.notify("link:pointermove",t,e,i)},pointerup:function(t,e,i){var n=this._dragData;switch(n&&(this.eventData(t,n),this._dragData=null),this.eventData(t).action){case"vertex-move":this.dragVertexEnd(t,e,i);break;case"label-move":this.dragLabelEnd(t,e,i);break;case"arrowhead-move":this.dragArrowheadEnd(t,e,i);break;case"move":this.dragEnd(t,e,i)}this.notify("link:pointerup",t,e,i),joint.dia.CellView.prototype.pointerup.apply(this,arguments)},mouseover:function(t){joint.dia.CellView.prototype.mouseover.apply(this,arguments),this.notify("link:mouseover",t)},mouseout:function(t){joint.dia.CellView.prototype.mouseout.apply(this,arguments),this.notify("link:mouseout",t)},mouseenter:function(t){joint.dia.CellView.prototype.mouseenter.apply(this,arguments),this.notify("link:mouseenter",t)},mouseleave:function(t){joint.dia.CellView.prototype.mouseleave.apply(this,arguments),this.notify("link:mouseleave",t)},mousewheel:function(t,e,i,n){joint.dia.CellView.prototype.mousewheel.apply(this,arguments),this.notify("link:mousewheel",t,e,i,n)},onevent:function(t,e,i,n){if(V(t.target).findParentByClass("link-tool",this.el)){if(t.stopPropagation(),this.can("useLinkTools")){if("remove"===e)return void this.model.remove({ui:!0});this.notify(e,t,i,n)}joint.dia.CellView.prototype.pointerdown.apply(this,arguments),this.notify("link:pointerdown",t,i,n)}else joint.dia.CellView.prototype.onevent.apply(this,arguments)},onlabel:function(t,e,i){joint.dia.CellView.prototype.pointerdown.apply(this,arguments),this.notify("link:pointerdown",t,e,i),this.dragLabelStart(t,e,i),this.eventData(t).stopPropagation&&t.stopPropagation()},dragConnectionStart:function(t,e,i){if(this.can("vertexAdd")){var n=this.addVertex({x:e,y:i},{ui:!0});this.eventData(t,{action:"vertex-move",vertexIdx:n})}},dragLabelStart:function(t,e,i){if(this.can("labelMove")){var n=t.currentTarget,r=parseInt(n.getAttribute("label-idx"),10),o=this._getDefaultLabelPositionArgs(),s=this._getLabelPositionArgs(r),a=this._mergeLabelPositionArgs(s,o);this.eventData(t,{action:"label-move",labelIdx:r,positionArgs:a,stopPropagation:!0}),this.paper.delegateDragEvents(this,t.data)}else this.eventData(t,{stopPropagation:!0})},dragVertexStart:function(t,e,i){if(this.can("vertexMove")){var n=t.target,r=parseInt(n.getAttribute("idx"),10);this.eventData(t,{action:"vertex-move",vertexIdx:r})}},dragVertexRemoveStart:function(t,e,i){if(this.can("vertexRemove")){var n=t.target,r=parseInt(n.getAttribute("idx"),10);this.model.removeVertex(r)}},dragArrowheadStart:function(t,e,i){if(this.can("arrowheadMove")){var n=t.target.getAttribute("end"),r=this.startArrowheadMove(n,{ignoreBackwardsCompatibility:!0});this.eventData(t,r)}},dragStart:function(t,e,i){this.can("linkMove")&&this.eventData(t,{action:"move",dx:e,dy:i})},dragLabel:function(t,e,i){var n=this.eventData(t),r={position:this.getLabelPosition(e,i,n.positionArgs)};this.model.label(n.labelIdx,r)},dragVertex:function(t,e,i){var n=this.eventData(t);this.model.vertex(n.vertexIdx,{x:e,y:i},{ui:!0})},dragArrowhead:function(t,e,i){var n=this.eventData(t);this.paper.options.snapLinks?this._snapArrowhead(e,i,n):this._connectArrowhead(this.getEventTarget(t),e,i,n)},drag:function(t,e,i){var n=this.eventData(t);this.model.translate(e-n.dx,i-n.dy,{ui:!0}),this.eventData(t,{dx:e,dy:i})},dragLabelEnd:function(){},dragVertexEnd:function(){},dragArrowheadEnd:function(t,e,i){var n=this.eventData(t),r=this.paper;r.options.snapLinks?this._snapArrowheadEnd(n):this._connectArrowheadEnd(n,e,i),r.linkAllowed(this)?(this._finishEmbedding(n),this._notifyConnectEvent(n,t)):this._disallow(n),this._afterArrowheadMove(n),this.vel.contains(t.target)||this.mouseleave(t)},dragEnd:function(){},_disallow:function(t){switch(t.whenNotAllowed){case"remove":this.model.remove({ui:!0});break;case"revert":default:this.model.set(t.arrowhead,t.initialEnd,{ui:!0})}},_finishEmbedding:function(t){this.paper.options.embeddingMode&&this.model.reparent()&&(t.z=null)},_notifyConnectEvent:function(t,e){var i=t.arrowhead,n=t.initialEnd,r=this.model.prop(i);if(r&&!joint.dia.Link.endsEqual(n,r)){var o=this.paper;n.id&&this.notify("link:disconnect",e,o.findViewByModel(n.id),t.initialMagnet,i),r.id&&this.notify("link:connect",e,o.findViewByModel(r.id),t.magnetUnderPointer,i)}},_snapArrowhead:function(t,e,r){var o,s=this.paper.options.snapLinks.radius||50,i=this.paper.findViewsInArea({x:t-s,y:e-s,width:2*s,height:2*s}),n=r.closestView||null,a=r.closestMagnet||null;r.closestView=r.closestMagnet=null;var l,h=Number.MAX_VALUE,u=g.point(t,e),c=this.paper;i.forEach(function(n){"false"!==n.el.getAttribute("magnet")&&(o=n.model.getBBox().center().distance(u))<s&&o<h&&(a===n.el||c.options.validateConnection.apply(c,r.validateConnectionArgs(n,null)))&&(h=o,r.closestView=n,r.closestMagnet=n.el),n.$("[magnet]").each(function(t,e){var i=n.getNodeBBox(e);(o=u.distance({x:i.x+i.width/2,y:i.y+i.height/2}))<s&&o<h&&(a===e||c.options.validateConnection.apply(c,r.validateConnectionArgs(n,e)))&&(h=o,r.closestView=n,r.closestMagnet=e)}.bind(this))},this);var d=r.closestView,f=r.closestMagnet,p=r.arrowhead,m=a!==f;if(n&&m&&n.unhighlight(a,{connecting:!0,snapping:!0}),d){if(!m)return;d.highlight(f,{connecting:!0,snapping:!0}),l=d.getLinkEnd(f,t,e,this.model,p)}else l={x:t,y:e};this.model.set(p,l||{x:t,y:e},{ui:!0})},_snapArrowheadEnd:function(t){var e=t.closestView,i=t.closestMagnet;e&&i&&(e.unhighlight(i,{connecting:!0,snapping:!0}),t.magnetUnderPointer=e.findMagnet(i)),t.closestView=t.closestMagnet=null},_connectArrowhead:function(t,e,i,n){n.eventTarget!==t&&(n.magnetUnderPointer&&n.viewUnderPointer.unhighlight(n.magnetUnderPointer,{connecting:!0}),n.viewUnderPointer=this.paper.findView(t),n.viewUnderPointer?(n.magnetUnderPointer=n.viewUnderPointer.findMagnet(t),n.magnetUnderPointer&&this.paper.options.validateConnection.apply(this.paper,n.validateConnectionArgs(n.viewUnderPointer,n.magnetUnderPointer))?n.magnetUnderPointer&&n.viewUnderPointer.highlight(n.magnetUnderPointer,{connecting:!0}):n.magnetUnderPointer=null):n.magnetUnderPointer=null),n.eventTarget=t,this.model.set(n.arrowhead,{x:e,y:i},{ui:!0})},_connectArrowheadEnd:function(t,e,i){var n=t.viewUnderPointer,r=t.magnetUnderPointer;if(r&&n){n.unhighlight(r,{connecting:!0});var o=t.arrowhead,s=n.getLinkEnd(r,e,i,this.model,o);this.model.set(o,s,{ui:!0})}},_beforeArrowheadMove:function(t){t.z=this.model.get("z"),this.model.toFront(),this.el.style.pointerEvents="none",this.paper.options.markAvailable&&this._markAvailableMagnets(t)},_afterArrowheadMove:function(t){null!==t.z&&(this.model.set("z",t.z,{ui:!0}),t.z=null),this.el.style.pointerEvents="visiblePainted",this.paper.options.markAvailable&&this._unmarkAvailableMagnets(t)},_createValidateConnectionArgs:function(t){var e,i=[];i[4]=t,i[5]=this;var n=0,r=0;e="source"===t?(n=2,"target"):(r=2,"source");var o=this.model.get(e);if(o.id){var s=i[n]=this.paper.findViewByModel(o.id),a=s.getMagnetFromLinkEnd(o);a===s.el&&(a=void 0),i[n+1]=a}return function(t,e){return i[r]=t,i[r+1]=t.el===e?void 0:e,i}},_markAvailableMagnets:function(t){function e(t,e){var i=t.paper;return i.options.validateConnection.apply(i,this.validateConnectionArgs(t,e))}var i=this.paper,n=i.model.getElements();t.marked={};for(var r=0,o=n.length;r<o;r++){var s=n[r].findView(i);if(s){var a=Array.prototype.slice.call(s.el.querySelectorAll("[magnet]"));"false"!==s.el.getAttribute("magnet")&&a.push(s.el);var l=a.filter(e.bind(t,s));if(0<l.length){for(var h=0,u=l.length;h<u;h++)s.highlight(l[h],{magnetAvailability:!0});s.highlight(null,{elementAvailability:!0}),t.marked[s.model.id]=l}}}},_unmarkAvailableMagnets:function(t){for(var e,i,n=Object.keys(t.marked),r=0,o=n.length;r<o;r++){e=n[r],i=t.marked[e];var s=this.paper.findViewByModel(e);if(s){for(var a=0,l=i.length;a<l;a++)s.unhighlight(i[a],{magnetAvailability:!0});s.unhighlight(null,{elementAvailability:!0})}}t.marked=null},startArrowheadMove:function(t,e){e||(e={});var i={action:"arrowhead-move",arrowhead:t,whenNotAllowed:e.whenNotAllowed||"revert",initialMagnet:this[t+"Magnet"]||(this[t+"View"]?this[t+"View"].el:null),initialEnd:joint.util.clone(this.model.get(t)),validateConnectionArgs:this._createValidateConnectionArgs(t)};return this._beforeArrowheadMove(i),!0!==e.ignoreBackwardsCompatibility&&(this._dragData=i),i}},{makeSelector:function(t){var e="";return t.port?e+='[port="'+t.port+'"]':t.selector&&(e+=t.selector),e}}),Object.defineProperty(joint.dia.LinkView.prototype,"sourceBBox",{enumerable:!0,get:function(){var t=this.sourceView,e=this.sourceMagnet;if(t)return e||(e=t.el),t.getNodeBBox(e);var i=this.model.source();return new g.Rect(i.x,i.y,1,1)}}),Object.defineProperty(joint.dia.LinkView.prototype,"targetBBox",{enumerable:!0,get:function(){var t=this.targetView,e=this.targetMagnet;if(t)return e||(e=t.el),t.getNodeBBox(e);var i=this.model.target();return new g.Rect(i.x,i.y,1,1)}}),joint.dia.Paper=joint.mvc.View.extend({className:"paper",options:{width:800,height:600,origin:{x:0,y:0},gridSize:1,drawGrid:!1,background:!1,perpendicularLinks:!1,elementView:joint.dia.ElementView,linkView:joint.dia.LinkView,snapLinks:!1,multiLinks:!0,guard:function(t,e){return!1},highlighting:{default:{name:"stroke",options:{padding:3}},magnetAvailability:{name:"addClass",options:{className:"available-magnet"}},elementAvailability:{name:"addClass",options:{className:"available-cell"}}},preventContextMenu:!0,preventDefaultBlankAction:!0,restrictTranslate:!1,markAvailable:!1,defaultLink:new joint.dia.Link,defaultConnector:{name:"normal"},defaultRouter:{name:"normal"},defaultAnchor:{name:"center"},defaultConnectionPoint:{name:"bbox"},connectionStrategy:null,validateMagnet:function(t,e){return"passive"!==e.getAttribute("magnet")},validateConnection:function(t,e,i,n,r,o){return("target"===r?i:t)instanceof joint.dia.ElementView},embeddingMode:!1,validateEmbedding:function(t,e){return!0},findParentBy:"bbox",frontParentOnly:!0,interactive:{labelMove:!1},linkPinning:!0,allowLink:null,clickThreshold:0,moveThreshold:0,magnetThreshold:0,cellViewNamespace:joint.shapes,highlighterNamespace:joint.highlighters},events:{dblclick:"pointerdblclick",contextmenu:"contextmenu",mousedown:"pointerdown",touchstart:"pointerdown",mouseover:"mouseover",mouseout:"mouseout",mouseenter:"mouseenter",mouseleave:"mouseleave",mousewheel:"mousewheel",DOMMouseScroll:"mousewheel","mouseenter .joint-cell":"mouseenter","mouseleave .joint-cell":"mouseleave","mouseenter .joint-tools":"mouseenter","mouseleave .joint-tools":"mouseleave","mousedown .joint-cell [event]":"onevent","touchstart .joint-cell [event]":"onevent","mousedown .joint-cell [magnet]":"onmagnet","touchstart .joint-cell [magnet]":"onmagnet","dblclick .joint-cell [magnet]":"magnetpointerdblclick","contextmenu .joint-cell [magnet]":"magnetcontextmenu","mousedown .joint-link .label":"onlabel","touchstart .joint-link .label":"onlabel","dragstart .joint-cell image":"onImageDragStart"},documentEvents:{mousemove:"pointermove",touchmove:"pointermove",mouseup:"pointerup",touchend:"pointerup",touchcancel:"pointerup"},_highlights:{},init:function(){joint.util.bindAll(this,"pointerup");var t=this.model=this.options.model||new joint.dia.Graph;this.setGrid(this.options.drawGrid),this.cloneOptions(),this.render(),this.setDimensions(),this.listenTo(t,"add",this.onCellAdded).listenTo(t,"remove",this.removeView).listenTo(t,"reset",this.resetViews).listenTo(t,"sort",this._onSort).listenTo(t,"batch:stop",this._onBatchStop),this.on("cell:highlight",this.onCellHighlight).on("cell:unhighlight",this.onCellUnhighlight).on("scale translate",this.update),this._views={},this.$document=$(this.el.ownerDocument)},cloneOptions:function(){var t=this.options;t.origin=joint.util.assign({},t.origin),t.defaultConnector=joint.util.assign({},t.defaultConnector),t.highlighting=joint.util.defaultsDeep({},t.highlighting,this.constructor.prototype.options.highlighting)},render:function(){return this.$el.empty(),this.svg=V("svg").attr({width:"100%",height:"100%"}).node,this.viewport=V("g").addClass(joint.util.addClassNamePrefix("viewport")).node,this.defs=V("defs").node,this.tools=V("g").addClass(joint.util.addClassNamePrefix("tools-container")).node,V(this.svg).append([this.defs,this.viewport,this.tools]),this.$background=$("<div/>").addClass(joint.util.addClassNamePrefix("paper-background")),this.options.background&&this.drawBackground(this.options.background),this.$grid=$("<div/>").addClass(joint.util.addClassNamePrefix("paper-grid")),this.options.drawGrid&&this.drawGrid(),this.$el.append(this.$background,this.$grid,this.svg),this},update:function(){return this.options.drawGrid&&this.drawGrid(),this._background&&this.updateBackgroundImage(this._background),this},_viewportMatrix:null,_viewportTransformString:null,matrix:function(t){var e=this.viewport;if(void 0===t){var i=e.getAttribute("transform");return(this._viewportTransformString||null)===i?t=this._viewportMatrix:(t=e.getCTM(),this._viewportMatrix=t,this._viewportTransformString=i),V.createSVGMatrix(t)}t=V.createSVGMatrix(t);var n=V.matrixToTransformString(t);return e.setAttribute("transform",n),this.tools.setAttribute("transform",n),this._viewportMatrix=t,this._viewportTransformString=e.getAttribute("transform"),this},clientMatrix:function(){return V.createSVGMatrix(this.viewport.getScreenCTM())},_sortDelayingBatches:["add","to-front","to-back"],_onSort:function(){this.model.hasActiveBatch(this._sortDelayingBatches)||this.sortViews()},_onBatchStop:function(t){var e=t&&t.batchName;this._sortDelayingBatches.includes(e)&&!this.model.hasActiveBatch(this._sortDelayingBatches)&&this.sortViews()},onRemove:function(){this.removeViews()},getComputedSize:function(){var t=joint.util,e=this.options,i=e.width,n=e.height;return t.isNumber(i)||(i=this.el.clientWidth),t.isNumber(n)||(n=this.el.clientHeight),{width:i,height:n}},setDimensions:function(t,e){var i=joint.util,n=this.options,r=void 0===t?n.width:t,o=void 0===e?n.height:e;this.options.width=r,this.options.height=o,i.isNumber(r)&&(r=Math.round(r)),i.isNumber(o)&&(o=Math.round(o)),this.$el.css({width:null===r?"":r,height:null===o?"":o});var s=this.getComputedSize();this.trigger("resize",s.width,s.height)},setOrigin:function(t,e){return this.translate(t||0,e||0,{absolute:!0})},fitToContent:function(t,e,i,n){i=joint.util.isObject(t)?(t=(n=t).gridWidth||1,e=n.gridHeight||1,n.padding||0):(n=n||{},t=t||1,e=e||1,i||0),i=joint.util.normalizeSides(i);var r=V(this.viewport).getBBox(),o=this.scale(),s=this.translate();r.x*=o.sx,r.y*=o.sy,r.width*=o.sx,r.height*=o.sy;var a=Math.max(Math.ceil((r.width+r.x)/t),1)*t,l=Math.max(Math.ceil((r.height+r.y)/e),1)*e,h=0,u=0;("negative"==n.allowNewOrigin&&r.x<0||"positive"==n.allowNewOrigin&&0<=r.x||"any"==n.allowNewOrigin)&&(h=Math.ceil(-r.x/t)*t,a+=h+=i.left),("negative"==n.allowNewOrigin&&r.y<0||"positive"==n.allowNewOrigin&&0<=r.y||"any"==n.allowNewOrigin)&&(u=Math.ceil(-r.y/e)*e,l+=u+=i.top),a+=i.right,l+=i.bottom,a=Math.max(a,n.minWidth||0),l=Math.max(l,n.minHeight||0),a=Math.min(a,n.maxWidth||Number.MAX_VALUE),l=Math.min(l,n.maxHeight||Number.MAX_VALUE);var c=this.getComputedSize(),d=a!=c.width||l!=c.height;(h!=s.tx||u!=s.ty)&&this.translate(h,u),d&&this.setDimensions(a,l)},scaleContentToFit:function(t){var e=this.getContentBBox();if(e.width&&e.height){t=t||{},joint.util.defaults(t,{padding:0,preserveAspectRatio:!0,scaleGrid:null,minScale:0,maxScale:Number.MAX_VALUE});var i,n=t.padding,r=t.minScaleX||t.minScale,o=t.maxScaleX||t.maxScale,s=t.minScaleY||t.minScale,a=t.maxScaleY||t.maxScale;if(t.fittingBBox)i=t.fittingBBox;else{var l=this.translate(),h=this.getComputedSize();i={x:l.tx,y:l.ty,width:h.width,height:h.height}}i=new g.Rect(i).inflate(-n);var u=this.scale(),c=i.width/e.width*u.sx,d=i.height/e.height*u.sy;if(t.preserveAspectRatio&&(c=d=Math.min(c,d)),t.scaleGrid){var f=t.scaleGrid;c=f*Math.floor(c/f),d=f*Math.floor(d/f)}c=Math.min(o,Math.max(r,c)),d=Math.min(a,Math.max(s,d)),this.scale(c,d);var p=this.getContentBBox(),m=i.x-p.x,v=i.y-p.y;this.translate(m,v)}},getContentArea:function(){return V(this.viewport).getBBox()},getContentBBox:function(){var t=this.viewport.getBoundingClientRect(),e=this.clientMatrix(),i=this.translate();return new g.Rect({x:t.left-e.e+i.tx,y:t.top-e.f+i.ty,width:t.width,height:t.height})},getArea:function(){return this.paperToLocalRect(this.getComputedSize())},getRestrictedArea:function(){return joint.util.isFunction(this.options.restrictTranslate)?this.options.restrictTranslate.apply(this,arguments):!0===this.options.restrictTranslate?this.getArea():this.options.restrictTranslate||null},createViewForModel:function(t){var e,i,n=this.options.cellViewNamespace,r=t.get("type")+"View",o=joint.util.getByPath(n,r,".");return i=t.isLink()?(e=this.options.linkView,joint.dia.LinkView):(e=this.options.elementView,joint.dia.ElementView),new(e.prototype instanceof Backbone.View?o||e:e.call(this,t)||o||i)({model:t,interactive:this.options.interactive})},onCellAdded:function(t,e,i){if(this.options.async&&!1!==i.async&&joint.util.isNumber(i.position)){if(this._asyncCells=this._asyncCells||[],this._asyncCells.push(t),0==i.position){if(this._frameId)throw new Error("another asynchronous rendering in progress");this.asyncRenderViews(this._asyncCells,i),delete this._asyncCells}}else this.renderView(t)},removeView:function(t){var e=this._views[t.id];return e&&(e.remove(),delete this._views[t.id]),e},renderView:function(t){var e=this._views[t.id]=this.createViewForModel(t);return this.viewport.appendChild(e.el),e.paper=this,e.render(),e},onImageDragStart:function(){return!1},beforeRenderViews:function(t){return t.sort(function(t){return t.isLink()?1:-1}),t},afterRenderViews:function(){this.sortViews()},resetViews:function(t,e){this.removeViews();var i=t.models.slice();if(i=this.beforeRenderViews(i,e)||i,this.cancelRenderViews(),this.options.async)this.asyncRenderViews(i,e);else{for(var n=0,r=i.length;n<r;n++)this.renderView(i[n]);this.sortViews()}},cancelRenderViews:function(){this._frameId&&(joint.util.cancelFrame(this._frameId),delete this._frameId)},removeViews:function(){joint.util.invoke(this._views,"remove"),this._views={}},asyncBatchAdded:joint.util.noop,asyncRenderViews:function(t,e){if(this._frameId){var i=this.options.async&&this.options.async.batchSize||50;t.splice(0,i).forEach(function(t){t.graph===this.model&&this.renderView(t)},this),this.asyncBatchAdded()}t.length?this._frameId=joint.util.nextFrame(function(){this.asyncRenderViews(t,e)},this):(delete this._frameId,this.afterRenderViews(e),this.trigger("render:done",e))},sortViews:function(){var t=$(this.viewport).children("[model-id]"),r=this.model.get("cells");joint.util.sortElements(t,function(t,e){var i=r.get($(t).attr("model-id")),n=r.get($(e).attr("model-id"));return(i.get("z")||0)>(n.get("z")||0)?1:-1})},MIN_SCALE:1e-6,scale:function(t,e,i,n){if(void 0===t)return V.matrixToScale(this.matrix());void 0===e&&(e=t),void 0===i&&(n=i=0);var r=this.translate();if(i||n||r.tx||r.ty){var o=r.tx-i*(t-1),s=r.ty-n*(e-1);this.translate(o,s)}t=Math.max(t||0,this.MIN_SCALE),e=Math.max(e||0,this.MIN_SCALE);var a=this.matrix();return a.a=t,a.d=e,this.matrix(a),this.trigger("scale",t,e,i,n),this},rotate:function(t,e,i){if(void 0===t)return V.matrixToRotate(this.matrix());if(void 0===e){var n=this.viewport.getBBox();e=n.width/2,i=n.height/2}var r=this.matrix().translate(e,i).rotate(t).translate(-e,-i);return this.matrix(r),this},translate:function(t,e){if(void 0===t)return V.matrixToTranslate(this.matrix());var i=this.matrix();i.e=t||0,i.f=e||0,this.matrix(i);var n=this.translate(),r=this.options.origin;return r.x=n.tx,r.y=n.ty,this.trigger("translate",n.tx,n.ty),this.options.drawGrid&&this.drawGrid(),this},findView:function(t){var e=joint.util.isString(t)?this.viewport.querySelector(t):t instanceof $?t[0]:t,i=this.findAttribute("model-id",e);if(i)return this._views[i]},findViewByModel:function(t){var e=joint.util.isString(t)||joint.util.isNumber(t)?t:t&&t.id;return this._views[e]},findViewsFromPoint:function(e){return e=new g.Point(e),this.model.getElements().map(this.findViewByModel,this).filter(function(t){return t&&t.vel.getBBox({target:this.viewport}).containsPoint(e)},this)},findViewsInArea:function(e,t){t=joint.util.defaults(t||{},{strict:!1}),e=new g.Rect(e);var i=this.model.getElements().map(this.findViewByModel,this),n=t.strict?"containsRect":"intersect";return i.filter(function(t){return t&&e[n](t.vel.getBBox({target:this.viewport}))},this)},removeTools:function(){return joint.dia.CellView.dispatchToolsEvent(this,"remove"),this},hideTools:function(){return joint.dia.CellView.dispatchToolsEvent(this,"hide"),this},showTools:function(){return joint.dia.CellView.dispatchToolsEvent(this,"show"),this},getModelById:function(t){return this.model.getCell(t)},snapToGrid:function(t,e){return this.clientToLocalPoint(t,e).snapToGrid(this.options.gridSize)},localToPaperPoint:function(t,e){var i=new g.Point(t,e);return V.transformPoint(i,this.matrix())},localToPaperRect:function(t,e,i,n){var r=new g.Rect(t,e,i,n);return V.transformRect(r,this.matrix())},paperToLocalPoint:function(t,e){var i=new g.Point(t,e);return V.transformPoint(i,this.matrix().inverse())},paperToLocalRect:function(t,e,i,n){var r=new g.Rect(t,e,i,n);return V.transformRect(r,this.matrix().inverse())},localToClientPoint:function(t,e){var i=new g.Point(t,e);return V.transformPoint(i,this.clientMatrix())},localToClientRect:function(t,e,i,n){var r=new g.Rect(t,e,i,n);return V.transformRect(r,this.clientMatrix())},clientToLocalPoint:function(t,e){var i=new g.Point(t,e);return V.transformPoint(i,this.clientMatrix().inverse())},clientToLocalRect:function(t,e,i,n){var r=new g.Rect(t,e,i,n);return V.transformRect(r,this.clientMatrix().inverse())},localToPagePoint:function(t,e){return this.localToPaperPoint(t,e).offset(this.pageOffset())},localToPageRect:function(t,e,i,n){return this.localToPaperRect(t,e,i,n).offset(this.pageOffset())},pageToLocalPoint:function(t,e){var i=new g.Point(t,e).difference(this.pageOffset());return this.paperToLocalPoint(i)},pageToLocalRect:function(t,e,i,n){var r=this.pageOffset(),o=new g.Rect(t,e,i,n);return o.x-=r.x,o.y-=r.y,this.paperToLocalRect(o)},clientOffset:function(){var t=this.svg.getBoundingClientRect();return new g.Point(t.left,t.top)},pageOffset:function(){return this.clientOffset().offset(window.scrollX,window.scrollY)},linkAllowed:function(t){if(!(t instanceof joint.dia.LinkView))throw new Error("Must provide a linkView.");var e=t.model,i=this.options,n=this.model,r=n.constructor.validations;return!(!i.multiLinks&&!r.multiLinks.call(this,n,e))&&(!(!i.linkPinning&&!r.linkPinning.call(this,n,e))&&!("function"==typeof i.allowLink&&!i.allowLink.call(this,t,this)))},getDefaultLink:function(t,e){return joint.util.isFunction(this.options.defaultLink)?this.options.defaultLink.call(this,t,e):this.options.defaultLink.clone()},resolveHighlighter:function(e){var t=(e=e||{}).highlighter,i=this.options;if(void 0===t){var n=["embedding","connecting","magnetAvailability","elementAvailability"].find(function(t){return!!e[t]});t=n&&i.highlighting[n]||i.highlighting.default}if(!t)return!1;joint.util.isString(t)&&(t={name:t});var r=t.name,o=i.highlighterNamespace[r];if(!o)throw new Error('Unknown highlighter ("'+r+'")');if("function"!=typeof o.highlight)throw new Error('Highlighter ("'+r+'") is missing required highlight() method');if("function"!=typeof o.unhighlight)throw new Error('Highlighter ("'+r+'") is missing required unhighlight() method');return{highlighter:o,options:t.options||{},name:r}},onCellHighlight:function(t,e,i){if(i=this.resolveHighlighter(i)){e.id||(e.id=V.uniqueId());var n=i.name+e.id+JSON.stringify(i.options);if(!this._highlights[n]){var r=i.highlighter;r.highlight(t,e,joint.util.assign({},i.options)),this._highlights[n]={cellView:t,magnetEl:e,opt:i.options,highlighter:r}}}},onCellUnhighlight:function(t,e,i){if(i=this.resolveHighlighter(i)){var n=i.name+e.id+JSON.stringify(i.options),r=this._highlights[n];r&&(r.highlighter.unhighlight(r.cellView,r.magnetEl,r.opt),this._highlights[n]=null)}},pointerdblclick:function(t){t.preventDefault(),t=joint.util.normalizeEvent(t);var e=this.findView(t.target);if(!this.guard(t,e)){var i=this.snapToGrid({x:t.clientX,y:t.clientY});e?e.pointerdblclick(t,i.x,i.y):this.trigger("blank:pointerdblclick",t,i.x,i.y)}},pointerclick:function(t){if(this.eventData(t).mousemoved<=this.options.clickThreshold){t=joint.util.normalizeEvent(t);var e=this.findView(t.target);if(this.guard(t,e))return;var i=this.snapToGrid({x:t.clientX,y:t.clientY});e?e.pointerclick(t,i.x,i.y):this.trigger("blank:pointerclick",t,i.x,i.y)}},contextmenu:function(t){this.options.preventContextMenu&&t.preventDefault(),t=joint.util.normalizeEvent(t);var e=this.findView(t.target);if(!this.guard(t,e)){var i=this.snapToGrid({x:t.clientX,y:t.clientY});e?e.contextmenu(t,i.x,i.y):this.trigger("blank:contextmenu",t,i.x,i.y)}},pointerdown:function(t){t=joint.util.normalizeEvent(t);var e=this.findView(t.target);if(!this.guard(t,e)){var i=this.snapToGrid({x:t.clientX,y:t.clientY});e?(t.preventDefault(),e.pointerdown(t,i.x,i.y)):(this.options.preventDefaultBlankAction&&t.preventDefault(),this.trigger("blank:pointerdown",t,i.x,i.y)),this.delegateDragEvents(e,t.data)}},pointermove:function(t){var e=this.eventData(t);if(e.mousemoved||(e.mousemoved=0),!(++e.mousemoved<=this.options.moveThreshold)){t=joint.util.normalizeEvent(t);var i=this.snapToGrid({x:t.clientX,y:t.clientY}),n=e.sourceView;n?n.pointermove(t,i.x,i.y):this.trigger("blank:pointermove",t,i.x,i.y),this.eventData(t,e)}},pointerup:function(t){this.undelegateDocumentEvents();var e=joint.util.normalizeEvent(t),i=this.snapToGrid({x:e.clientX,y:e.clientY}),n=this.eventData(t).sourceView;n?n.pointerup(e,i.x,i.y):this.trigger("blank:pointerup",e,i.x,i.y),e.isPropagationStopped()||this.pointerclick($.Event(t,{type:"click",data:t.data})),t.stopImmediatePropagation(),this.delegateEvents()},mouseover:function(t){t=joint.util.normalizeEvent(t);var e=this.findView(t.target);if(!this.guard(t,e))if(e)e.mouseover(t);else{if(this.el===t.target)return;this.trigger("blank:mouseover",t)}},mouseout:function(t){t=joint.util.normalizeEvent(t);var e=this.findView(t.target);if(!this.guard(t,e))if(e)e.mouseout(t);else{if(this.el===t.target)return;this.trigger("blank:mouseout",t)}},mouseenter:function(t){t=joint.util.normalizeEvent(t);var e=this.findView(t.target);if(!this.guard(t,e)){var i=this.findView(t.relatedTarget);if(e){if(i===e)return;e.mouseenter(t)}else{if(i)return;this.trigger("paper:mouseenter",t)}}},mouseleave:function(t){t=joint.util.normalizeEvent(t);var e=this.findView(t.target);if(!this.guard(t,e)){var i=this.findView(t.relatedTarget);if(e){if(i===e)return;e.mouseleave(t)}else{if(i)return;this.trigger("paper:mouseleave",t)}}},mousewheel:function(t){t=joint.util.normalizeEvent(t);var e=this.findView(t.target);if(!this.guard(t,e)){var i=t.originalEvent,n=this.snapToGrid({x:i.clientX,y:i.clientY}),r=Math.max(-1,Math.min(1,i.wheelDelta||-i.detail));e?e.mousewheel(t,n.x,n.y,r):this.trigger("blank:mousewheel",t,n.x,n.y,r)}},onevent:function(t){var e=t.currentTarget,i=e.getAttribute("event");if(i){var n=this.findView(e);if(n){if(t=joint.util.normalizeEvent(t),this.guard(t,n))return;var r=this.snapToGrid({x:t.clientX,y:t.clientY});n.onevent(t,i,r.x,r.y)}}},magnetEvent:function(t,e){var i=t.currentTarget;if(i.getAttribute("magnet")){var n=this.findView(i);if(n){if(t=joint.util.normalizeEvent(t),this.guard(t,n))return;var r=this.snapToGrid(t.clientX,t.clientY);e.call(this,n,t,i,r.x,r.y)}}},onmagnet:function(t){this.magnetEvent(t,function(t,e,i,n,r){t.onmagnet(e,n,r)})},magnetpointerdblclick:function(t){this.magnetEvent(t,function(t,e,i,n,r){t.magnetpointerdblclick(e,i,n,r)})},magnetcontextmenu:function(t){this.options.preventContextMenu&&t.preventDefault(),this.magnetEvent(t,function(t,e,i,n,r){t.magnetcontextmenu(e,i,n,r)})},onlabel:function(t){var e=t.currentTarget,i=this.findView(e);if(i){if(t=joint.util.normalizeEvent(t),this.guard(t,i))return;var n=this.snapToGrid(t.clientX,t.clientY);i.onlabel(t,n.x,n.y)}},delegateDragEvents:function(t,e){e||(e={}),this.eventData({data:e},{sourceView:t||null,mousemoved:0}),this.delegateDocumentEvents(null,e),this.undelegateEvents()},guard:function(t,e){return"mousedown"===t.type&&2===t.button||(!(!this.options.guard||!this.options.guard(t,e))||(t.data&&void 0!==t.data.guarded?t.data.guarded:!(e&&e.model&&e.model instanceof joint.dia.Cell)&&(this.svg!==t.target&&this.el!==t.target&&!$.contains(this.svg,t.target))))},setGridSize:function(t){return this.options.gridSize=t,this.options.drawGrid&&this.drawGrid(),this},clearGrid:function(){return this.$grid&&this.$grid.css("backgroundImage","none"),this},_getGriRefs:function(){return this._gridCache||(this._gridCache={root:V("svg",{width:"100%",height:"100%"},V("defs")),patterns:{},add:function(t,e){V(this.root.node.childNodes[0]).append(e),this.patterns[t]=e,this.root.append(V("rect",{width:"100%",height:"100%",fill:"url(#"+t+")"}))},get:function(t){return this.patterns[t]},exist:function(t){return void 0!==this.patterns[t]}}),this._gridCache},setGrid:function(t){return this.clearGrid(),this._gridCache=null,this._gridSettings=[],(Array.isArray(t)?t:[t||{}]).forEach(function(t){this._gridSettings.push.apply(this._gridSettings,this._resolveDrawGridOption(t))},this),this},_resolveDrawGridOption:function(t){var e=this.constructor.gridPatterns;if(joint.util.isString(t)&&Array.isArray(e[t]))return e[t].map(function(t){return joint.util.assign({},t)});var i=t||{args:[{}]},n=Array.isArray(i),r=i.name;if(n||r||i.markup||(r="dot"),r&&Array.isArray(e[r])){var o=e[r].map(function(t){return joint.util.assign({},t)}),s=Array.isArray(i.args)?i.args:[i.args||{}];joint.util.defaults(s[0],joint.util.omit(t,"args"));for(var a=0;a<s.length;a++)o[a]&&joint.util.assign(o[a],s[a]);return o}return n?i:[i]},drawGrid:function(t){var a=this.options.gridSize;if(a<=1)return this.clearGrid();var l=Array.isArray(t)?t:[t],h=this.matrix(),u=this._getGriRefs();this._gridSettings.forEach(function(t,e){var i="pattern_"+e,n=joint.util.merge(t,l[e],{sx:h.a||1,sy:h.d||1,ox:h.e||0,oy:h.f||0});n.width=a*(h.a||1)*(n.scaleFactor||1),n.height=a*(h.d||1)*(n.scaleFactor||1),u.exist(i)||u.add(i,V("pattern",{id:i,patternUnits:"userSpaceOnUse"},V(n.markup)));var r=u.get(i);joint.util.isFunction(n.update)&&n.update(r.node.childNodes[0],n);var o=n.ox%n.width;o<0&&(o+=n.width);var s=n.oy%n.height;s<0&&(s+=n.height),r.attr({x:o,y:s,width:n.width,height:n.height})});var e=(new XMLSerializer).serializeToString(u.root.node);return e="url(data:image/svg+xml;base64,"+btoa(e)+")",this.$grid.css("backgroundImage",e),this},updateBackgroundImage:function(t){var e=(t=t||{}).position||"center",i=t.size||"auto auto",n=this.scale(),r=this.translate();joint.util.isObject(e)&&(e=r.tx+n.sx*(e.x||0)+"px "+(r.ty+n.sy*(e.y||0))+"px");joint.util.isObject(i)&&(i=(i=new g.Rect(i).scale(n.sx,n.sy)).width+"px "+i.height+"px"),this.$background.css({backgroundSize:i,backgroundPosition:e})},drawBackgroundImage:function(t,e){if(t instanceof HTMLImageElement){var i,n=(e=e||{}).size,r=e.repeat||"no-repeat",o=e.opacity||1,s=Math.abs(e.quality)||1,a=this.constructor.backgroundPatterns[joint.util.camelCase(r)];if(joint.util.isFunction(a)){t.width*=s,t.height*=s;var l=a(t,e);if(!(l instanceof HTMLCanvasElement))throw new Error("dia.Paper: background pattern must return an HTML Canvas instance");i=l.toDataURL("image/png"),r="repeat",joint.util.isObject(n)?(n.width*=l.width/t.width,n.height*=l.height/t.height):void 0===n&&(e.size={width:l.width/s,height:l.height/s})}else i=t.src,void 0===n&&(e.size={width:t.width,height:t.height});this.$background.css({opacity:o,backgroundRepeat:r,backgroundImage:"url("+i+")"}),this.updateBackgroundImage(e)}else this.$background.css("backgroundImage","")},updateBackgroundColor:function(t){this.$el.css("backgroundColor",t||"")},drawBackground:function(t){if(t=t||{},this.updateBackgroundColor(t.color),t.image){t=this._background=joint.util.cloneDeep(t);var e=document.createElement("img");e.onload=this.drawBackgroundImage.bind(this,e,t),e.src=t.image}else this.drawBackgroundImage(null),this._background=null;return this},setInteractivity:function(t){this.options.interactive=t,joint.util.invoke(this._views,"setInteractivity",t)},isDefined:function(t){return!!this.svg.getElementById(t)},defineFilter:function(t){if(!joint.util.isObject(t))throw new TypeError("dia.Paper: defineFilter() requires 1. argument to be an object.");var e=t.id,i=t.name;if(e||(e=i+this.svg.id+joint.util.hashCode(JSON.stringify(t))),!this.isDefined(e)){var n=joint.util.filter,r=n[i]&&n[i](t.args||{});if(!r)throw new Error("Non-existing filter "+i);var o=joint.util.assign({filterUnits:"objectBoundingBox",x:-1,y:-1,width:3,height:3},t.attrs,{id:e});V(r,o).appendTo(this.defs)}return e},defineGradient:function(t){if(!joint.util.isObject(t))throw new TypeError("dia.Paper: defineGradient() requires 1. argument to be an object.");var e=t.id,i=t.type,n=t.stops;if(e||(e=i+this.svg.id+joint.util.hashCode(JSON.stringify(t))),!this.isDefined(e)){var r=joint.util.template('<stop offset="${offset}" stop-color="${color}" stop-opacity="${opacity}"/>'),o=["<"+i+">",joint.util.toArray(n).map(function(t){return r({offset:t.offset,color:t.color,opacity:Number.isFinite(t.opacity)?t.opacity:1})}).join(""),"</"+i+">"].join(""),s=joint.util.assign({id:e},t.attrs);V(o,s).appendTo(this.defs)}return e},defineMarker:function(t){if(!joint.util.isObject(t))throw new TypeError("dia.Paper: defineMarker() requires 1. argument to be an object.");var e=t.id;if(e||(e=this.svg.id+joint.util.hashCode(JSON.stringify(t))),!this.isDefined(e)){var i=joint.util.omit(t,"type","userSpaceOnUse");V("marker",{id:e,orient:"auto",overflow:"visible",markerUnits:t.markerUnits||"userSpaceOnUse"},[V(t.type||"path",i)]).appendTo(this.defs)}return e}},{backgroundPatterns:{flipXy:function(t){var e=document.createElement("canvas"),i=t.width,n=t.height;e.width=2*i,e.height=2*n;var r=e.getContext("2d");return r.drawImage(t,0,0,i,n),r.setTransform(-1,0,0,-1,e.width,e.height),r.drawImage(t,0,0,i,n),r.setTransform(-1,0,0,1,e.width,0),r.drawImage(t,0,0,i,n),r.setTransform(1,0,0,-1,0,e.height),r.drawImage(t,0,0,i,n),e},flipX:function(t){var e=document.createElement("canvas"),i=t.width,n=t.height;e.width=2*i,e.height=n;var r=e.getContext("2d");return r.drawImage(t,0,0,i,n),r.translate(2*i,0),r.scale(-1,1),r.drawImage(t,0,0,i,n),e},flipY:function(t){var e=document.createElement("canvas"),i=t.width,n=t.height;e.width=i,e.height=2*n;var r=e.getContext("2d");return r.drawImage(t,0,0,i,n),r.translate(0,2*n),r.scale(1,-1),r.drawImage(t,0,0,i,n),e},watermark:function(t,e){e=e||{};var i=t.width,n=t.height,r=document.createElement("canvas");r.width=3*i,r.height=3*n;for(var o=r.getContext("2d"),s=joint.util.isNumber(e.watermarkAngle)?-e.watermarkAngle:-20,a=g.toRad(s),l=r.width/4,h=r.height/4,u=0;u<4;u++)for(var c=0;c<4;c++)0<(u+c)%2&&(o.setTransform(1,0,0,1,(2*u-1)*l,(2*c-1)*h),o.rotate(a),o.drawImage(t,-i/2,-n/2,i,n));return r}},gridPatterns:{dot:[{color:"#AAAAAA",thickness:1,markup:"rect",update:function(t,e){V(t).attr({width:e.thickness*e.sx,height:e.thickness*e.sy,fill:e.color})}}],fixedDot:[{color:"#AAAAAA",thickness:1,markup:"rect",update:function(t,e){var i=e.sx<=1?e.thickness*e.sx:e.thickness;V(t).attr({width:i,height:i,fill:e.color})}}],mesh:[{color:"#AAAAAA",thickness:1,markup:"path",update:function(t,e){var i,n=e.width,r=e.height,o=e.thickness;i=0<=n-o&&0<=r-o?["M",n,0,"H0 M0 0 V0",r].join(" "):"M 0 0 0 0",V(t).attr({d:i,stroke:e.color,"stroke-width":e.thickness})}}],doubleMesh:[{color:"#AAAAAA",thickness:1,markup:"path",update:function(t,e){var i,n=e.width,r=e.height,o=e.thickness;i=0<=n-o&&0<=r-o?["M",n,0,"H0 M0 0 V0",r].join(" "):"M 0 0 0 0",V(t).attr({d:i,stroke:e.color,"stroke-width":e.thickness})}},{color:"#000000",thickness:3,scaleFactor:4,markup:"path",update:function(t,e){var i,n=e.width,r=e.height,o=e.thickness;i=0<=n-o&&0<=r-o?["M",n,0,"H0 M0 0 V0",r].join(" "):"M 0 0 0 0",V(t).attr({d:i,stroke:e.color,"stroke-width":e.thickness})}}]}}),function(n,p){var o=function(t){var e=p.cloneDeep(t)||{};this.ports=[],this.groups={},this.portLayoutNamespace=n.layout.Port,this.portLabelLayoutNamespace=n.layout.PortLabel,this._init(e)};o.prototype={getPorts:function(){return this.ports},getGroup:function(t){return this.groups[t]||{}},getPortsByGroup:function(e){return this.ports.filter(function(t){return t.group===e})},getGroupPortsMetrics:function(t,r){var e=this.getGroup(t),i=this.getPortsByGroup(t),n=e.position||{},o=n.name,s=this.portLayoutNamespace;s[o]||(o="left");var a=n.args||{},l=i.map(function(t){return t&&t.position&&t.position.args}),h=s[o](l,r,a),u={ports:i,result:[]};return p.toArray(h).reduce(function(t,e,i){var n=t.ports[i];return t.result.push({portId:n.id,portTransformation:e,labelTransformation:this._getPortLabelLayout(n,g.Point(e),r),portAttrs:n.attrs,portSize:n.size,labelSize:n.label.size}),t}.bind(this),u),u.result},_getPortLabelLayout:function(t,e,i){var n=this.portLabelLayoutNamespace,r=t.label.position.name||"left";return n[r]?n[r](e,i,t.label.position.args):null},_init:function(t){if(p.isObject(t.groups))for(var e=Object.keys(t.groups),i=0,n=e.length;i<n;i++){var r=e[i];this.groups[r]=this._evaluateGroup(t.groups[r])}for(var o=p.toArray(t.items),s=0,a=o.length;s<a;s++)this.ports.push(this._evaluatePort(o[s]))},_evaluateGroup:function(t){return p.merge(t,{position:this._getPosition(t.position,!0),label:this._getLabel(t,!0)})},_evaluatePort:function(t){var e=p.assign({},t),i=this.getGroup(t.group);return e.markup=e.markup||i.markup,e.attrs=p.merge({},i.attrs,e.attrs),e.position=this._createPositionNode(i,e),e.label=p.merge({},i.label,this._getLabel(e)),e.z=this._getZIndex(i,e),e.size=p.assign({},i.size,e.size),e},_getZIndex:function(t,e){return p.isNumber(e.z)?e.z:p.isNumber(t.z)||"auto"===t.z?t.z:"auto"},_createPositionNode:function(t,e){return p.merge({name:"left",args:{}},t.position,{args:e.args})},_getPosition:function(t,e){var i,n={};p.isFunction(t)?(i="fn",n.fn=t):p.isString(t)?i=t:void 0===t?i=e?"left":null:Array.isArray(t)?(i="absolute",n.x=t[0],n.y=t[1]):p.isObject(t)&&(i=t.name,p.assign(n,t.args));var r={args:n};return i&&(r.name=i),r},_getLabel:function(t,e){var i=t.label||{},n=i;return n.position=this._getPosition(i.position,e),n}},p.assign(n.dia.Element.prototype,{_initializePorts:function(){this._createPortData(),this.on("change:ports",function(){this._processRemovedPort(),this._createPortData()},this)},_processRemovedPort:function(){var t=this.get("ports")||{},e={};p.toArray(t.items).forEach(function(t){e[t.id]=!0});var i=this.previous("ports")||{},n={};p.toArray(i.items).forEach(function(t){e[t.id]||(n[t.id]=!0)});var r=this.graph;r&&!p.isEmpty(n)&&(r.getConnectedLinks(this,{inbound:!0}).forEach(function(t){n[t.get("target").port]&&t.remove()}),r.getConnectedLinks(this,{outbound:!0}).forEach(function(t){n[t.get("source").port]&&t.remove()}))},hasPorts:function(){var t=this.prop("ports/items");return Array.isArray(t)&&0<t.length},hasPort:function(t){return-1!==this.getPortIndex(t)},getPorts:function(){return p.cloneDeep(this.prop("ports/items"))||[]},getPort:function(e){return p.cloneDeep(p.toArray(this.prop("ports/items")).find(function(t){return t.id&&t.id===e}))},getPortsPositions:function(t){return this._portSettingsData.getGroupPortsMetrics(t,g.Rect(this.size())).reduce(function(t,e){var i=e.portTransformation;return t[e.portId]={x:i.x,y:i.y,angle:i.angle},t},{})},getPortIndex:function(t){var e=p.isObject(t)?t.id:t;return this._isValidPortId(e)?p.toArray(this.prop("ports/items")).findIndex(function(t){return t.id===e}):-1},addPort:function(t,e){if(!p.isObject(t)||Array.isArray(t))throw new Error("Element: addPort requires an object.");var i=p.assign([],this.prop("ports/items"));return i.push(t),this.prop("ports/items",i,e),this},portProp:function(t,e,i,n){var r=this.getPortIndex(t);if(-1===r)throw new Error("Element: unable to find port with id "+t);var o=Array.prototype.slice.call(arguments,1);return Array.isArray(e)?o[0]=["ports","items",r].concat(e):p.isString(e)?o[0]=["ports/items/",r,"/",e].join(""):(o=["ports/items/"+r],p.isPlainObject(e)&&(o.push(e),o.push(i))),this.prop.apply(this,o)},_validatePorts:function(){var t=this.get("ports")||{},e=[];t=t||{};var i=p.toArray(t.items);return i.forEach(function(t){"object"!=typeof t&&e.push("Element: invalid port ",t),this._isValidPortId(t.id)||(t.id=p.uuid())},this),n.util.uniq(i,"id").length!==i.length&&e.push("Element: found id duplicities in ports."),e},_isValidPortId:function(t){return null!=t&&!p.isObject(t)},addPorts:function(t,e){return t.length&&this.prop("ports/items",p.assign([],this.prop("ports/items")).concat(t),e),this},removePort:function(t,e){var i=e||{},n=p.assign([],this.prop("ports/items")),r=this.getPortIndex(t);return-1!==r&&(n.splice(r,1),i.rewrite=!0,this.prop("ports/items",n,i)),this},removePorts:function(t,e){var i;if(Array.isArray(t)){if(i=e||{},t.length){i.rewrite=!0;var n=p.assign([],this.prop("ports/items")).filter(function(i){return!t.some(function(t){var e=p.isObject(t)?t.id:t;return i.id===e})});this.prop("ports/items",n,i)}}else(i=t||{}).rewrite=!0,this.prop("ports/items",[],i);return this},_createPortData:function(){var t,e=this._validatePorts();if(0<e.length)throw this.set("ports",this.previous("ports")),new Error(e.join(" "));this._portSettingsData&&(t=this._portSettingsData.getPorts()),this._portSettingsData=new o(this.get("ports"));var i=this._portSettingsData.getPorts();if(t){var n=i.filter(function(e){if(!t.find(function(t){return t.id===e.id}))return e}),r=t.filter(function(e){if(!i.find(function(t){return t.id===e.id}))return e});0<r.length&&this.trigger("ports:remove",this,r),0<n.length&&this.trigger("ports:add",this,n)}}}),p.assign(n.dia.ElementView.prototype,{portContainerMarkup:"g",portMarkup:[{tagName:"circle",selector:"circle",attributes:{r:10,fill:"#FFFFFF",stroke:"#000000"}}],portLabelMarkup:[{tagName:"text",selector:"text",attributes:{fill:"#000000"}}],_portElementsCache:null,_initializePorts:function(){this._portElementsCache={},this.listenTo(this.model,"change:ports",function(){this._refreshPorts()})},_refreshPorts:function(){this._removePorts(),this._portElementsCache={},this._renderPorts()},_renderPorts:function(){for(var i=[],n=this._getContainerElement(),t=0,e=n.node.childNodes.length;t<e;t++)i.push(n.node.childNodes[t]);var r=p.groupBy(this.model._portSettingsData.getPorts(),"z");p.toArray(r.auto).forEach(function(t){var e=this._getPortElement(t);n.append(e),i.push(e)},this);for(var o=Object.keys(r),s=0;s<o.length;s++){var a=o[s];if("auto"!==a){var l=parseInt(a,10);this._appendPorts(r[a],l,i)}}this._updatePorts()},_getContainerElement:function(){return this.rotatableNode||this.vel},_appendPorts:function(t,e,i){var n=this._getContainerElement(),r=p.toArray(t).map(this._getPortElement,this);i[e]||e<0?V(i[Math.max(e,0)]).before(r):n.append(r)},_getPortElement:function(t){return this._portElementsCache[t.id]?this._portElementsCache[t.id].portElement:this._createPortElement(t)},findPortNode:function(t,e){var i=this._portElementsCache[t];if(!i)return null;var n=i.portContentElement.node,r=i.portContentSelectors;return this.findBySelector(e,n,r)[0]},_updatePorts:function(){this._updatePortGroup(void 0),Object.keys(this.model._portSettingsData.groups).forEach(this._updatePortGroup,this)},_removePorts:function(){p.invoke(this._portElementsCache,"portElement.remove")},_createPortElement:function(t){var e,i,n,r=V(this.portContainerMarkup).addClass("joint-port"),o=this._getPortMarkup(t);if(Array.isArray(o)){var s=this.parseDOMJSON(o,r.node),a=s.fragment;e=1<a.childNodes.length?V("g").append(a):V(a.firstChild),n=s.selectors}else e=V(o),Array.isArray(e)&&(e=V("g").append(e));if(!e)throw new Error("ElementView: Invalid port markup.");e.attr({port:t.id,"port-group":t.group});var l,h,u=this._getPortLabelMarkup(t.label);if(Array.isArray(u)){var c=this.parseDOMJSON(u,r.node),d=c.fragment;i=1<d.childNodes.length?V("g").append(d):V(d.firstChild),l=c.selectors}else i=V(u),Array.isArray(i)&&(i=V("g").append(i));if(!i)throw new Error("ElementView: Invalid port label markup.");if(n&&l){for(var f in l)if(n[f]&&f!==this.selector)throw new Error("ElementView: selectors within port must be unique.");h=p.assign({},n,l)}else h=n||l;return r.append([e.addClass("joint-port-body"),i.addClass("joint-port-label")]),this._portElementsCache[t.id]={portElement:r,portLabelElement:i,portSelectors:h,portLabelSelectors:l,portContentElement:e,portContentSelectors:n},r},_updatePortGroup:function(t){for(var e=g.Rect(this.model.size()),i=this.model._portSettingsData.getGroupPortsMetrics(t,e),n=0,r=i.length;n<r;n++){var o=i[n],s=o.portId,a=this._portElementsCache[s]||{},l=o.portTransformation;this.applyPortTransform(a.portElement,l),this.updateDOMSubtreeAttributes(a.portElement.node,o.portAttrs,{rootBBox:new g.Rect(o.portSize),selectors:a.portSelectors});var h=o.labelTransformation;h&&(this.applyPortTransform(a.portLabelElement,h,-l.angle||0),this.updateDOMSubtreeAttributes(a.portLabelElement.node,h.attrs,{rootBBox:new g.Rect(o.labelSize),selectors:a.portLabelSelectors}))}},applyPortTransform:function(t,e,i){var n=V.createSVGMatrix().rotate(i||0).translate(e.x||0,e.y||0).rotate(e.angle||0);t.transform(n,{absolute:!0})},_getPortMarkup:function(t){return t.markup||this.model.get("portMarkup")||this.model.portMarkup||this.portMarkup},_getPortLabelMarkup:function(t){return t.markup||this.model.get("portLabelMarkup")||this.model.portLabelMarkup||this.portLabelMarkup}})}(joint,joint.util),joint.dia.Element.define("basic.Generic",{attrs:{".":{fill:"#ffffff",stroke:"none"}}}),joint.shapes.basic.Generic.define("basic.Rect",{attrs:{rect:{fill:"#ffffff",stroke:"#000000",width:100,height:60},text:{fill:"#000000",text:"","font-size":14,"ref-x":.5,"ref-y":.5,"text-anchor":"middle","y-alignment":"middle","font-family":"Arial, helvetica, sans-serif"}}},{markup:'<g class="rotatable"><g class="scalable"><rect/></g><text/></g>'}),joint.shapes.basic.TextView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),this.listenTo(this.model,"change:attrs",this.resize)}}),joint.shapes.basic.Generic.define("basic.Text",{attrs:{text:{"font-size":18,fill:"#000000"}}},{markup:'<g class="rotatable"><g class="scalable"><text/></g></g>'}),joint.shapes.basic.Generic.define("basic.Circle",{size:{width:60,height:60},attrs:{circle:{fill:"#ffffff",stroke:"#000000",r:30,cx:30,cy:30},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-y":.5,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},{markup:'<g class="rotatable"><g class="scalable"><circle/></g><text/></g>'}),joint.shapes.basic.Generic.define("basic.Ellipse",{size:{width:60,height:40},attrs:{ellipse:{fill:"#ffffff",stroke:"#000000",rx:30,ry:20,cx:30,cy:20},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-y":.5,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},{markup:'<g class="rotatable"><g class="scalable"><ellipse/></g><text/></g>'}),joint.shapes.basic.Generic.define("basic.Polygon",{size:{width:60,height:40},attrs:{polygon:{fill:"#ffffff",stroke:"#000000"},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},{markup:'<g class="rotatable"><g class="scalable"><polygon/></g><text/></g>'}),joint.shapes.basic.Generic.define("basic.Polyline",{size:{width:60,height:40},attrs:{polyline:{fill:"#ffffff",stroke:"#000000"},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},{markup:'<g class="rotatable"><g class="scalable"><polyline/></g><text/></g>'}),joint.shapes.basic.Generic.define("basic.Image",{attrs:{text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,"y-alignment":"middle",fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},{markup:'<g class="rotatable"><g class="scalable"><image/></g><text/></g>'}),joint.shapes.basic.Generic.define("basic.Path",{size:{width:60,height:60},attrs:{path:{fill:"#ffffff",stroke:"#000000"},text:{"font-size":14,text:"","text-anchor":"middle",ref:"path","ref-x":.5,"ref-dy":10,fill:"#000000","font-family":"Arial, helvetica, sans-serif"}}},{markup:'<g class="rotatable"><g class="scalable"><path/></g><text/></g>'}),joint.shapes.basic.Path.define("basic.Rhombus",{attrs:{path:{d:"M 30 0 L 60 30 30 60 0 30 z"},text:{"ref-y":.5,"ref-dy":null,"y-alignment":"middle"}}}),joint.shapes.basic.PortsModelInterface={initialize:function(){this.updatePortsAttrs(),this.on("change:inPorts change:outPorts",this.updatePortsAttrs,this),this.constructor.__super__.constructor.__super__.initialize.apply(this,arguments)},updatePortsAttrs:function(t){if(this._portSelectors){var e=joint.util.omit(this.get("attrs"),this._portSelectors);this.set("attrs",e,{silent:!0})}this._portSelectors=[];var r={};joint.util.toArray(this.get("inPorts")).forEach(function(t,e,i){var n=this.getPortAttrs(t,e,i.length,".inPorts","in");this._portSelectors=this._portSelectors.concat(Object.keys(n)),joint.util.assign(r,n)},this),joint.util.toArray(this.get("outPorts")).forEach(function(t,e,i){var n=this.getPortAttrs(t,e,i.length,".outPorts","out");this._portSelectors=this._portSelectors.concat(Object.keys(n)),joint.util.assign(r,n)},this),this.attr(r,{silent:!0}),this.processPorts(),this.trigger("process:ports")},getPortSelector:function(t){var e=".inPorts",i=this.get("inPorts").indexOf(t);if(i<0&&(e=".outPorts",(i=this.get("outPorts").indexOf(t))<0))throw new Error("getPortSelector(): Port doesn't exist.");return e+">g:nth-child("+(i+1)+")>.port-body"}},joint.shapes.basic.PortsViewInterface={initialize:function(){this.listenTo(this.model,"process:ports",this.update),joint.dia.ElementView.prototype.initialize.apply(this,arguments)},update:function(){this.renderPorts(),joint.dia.ElementView.prototype.update.apply(this,arguments)},renderPorts:function(){var i=this.$(".inPorts").empty(),n=this.$(".outPorts").empty(),r=joint.util.template(this.model.portMarkup),t=joint.util.toArray(this.model.ports);t.filter(function(t){return"in"===t.type}).forEach(function(t,e){i.append(V(r({id:e,port:t})).node)}),t.filter(function(t){return"out"===t.type}).forEach(function(t,e){n.append(V(r({id:e,port:t})).node)})}},joint.shapes.basic.Generic.define("basic.TextBlock",{attrs:{rect:{fill:"#ffffff",stroke:"#000000",width:80,height:100},text:{fill:"#000000","font-size":14,"font-family":"Arial, helvetica, sans-serif"},".content":{text:"","ref-x":.5,"ref-y":.5,"y-alignment":"middle","x-alignment":"middle"}},content:""},{markup:['<g class="rotatable">','<g class="scalable"><rect/></g>',joint.env.test("svgforeignobject")?'<foreignObject class="fobj"><body xmlns="http://www.w3.org/1999/xhtml"><div class="content"/></body></foreignObject>':'<text class="content"/>',"</g>"].join(""),initialize:function(){this.listenTo(this,"change:size",this.updateSize),this.listenTo(this,"change:content",this.updateContent),this.updateSize(this,this.get("size")),this.updateContent(this,this.get("content")),joint.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},updateSize:function(t,e){this.attr({".fobj":joint.util.assign({},e),div:{style:joint.util.assign({},e)}})},updateContent:function(t,e){joint.env.test("svgforeignobject")?this.attr({".content":{html:joint.util.sanitizeHTML(e)}}):this.attr({".content":{text:e}})},setForeignObjectSize:function(){this.updateSize.apply(this,arguments)},setDivContent:function(){this.updateContent.apply(this,arguments)}}),joint.shapes.basic.TextBlockView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),this.noSVGForeignObjectElement=!joint.env.test("svgforeignobject"),joint.env.test("svgforeignobject")||this.listenTo(this.model,"change:content change:size",function(t){this.updateContent(t)})},update:function(t,e){var i=this.model;if(joint.env.test("svgforeignobject"))joint.dia.ElementView.prototype.update.call(this,i,e);else{var n=joint.util.omit(e||i.get("attrs"),".content");joint.dia.ElementView.prototype.update.call(this,i,n),e&&!joint.util.has(e,".content")||this.updateContent(i,e)}},updateContent:function(t,e){var i=joint.util.merge({},(e||t.get("attrs"))[".content"]);i=joint.util.omit(i,"text");var n=joint.util.breakText(t.get("content"),t.get("size"),i,{svgDocument:this.paper.svg}),r=joint.util.setByPath({},".content",i,"/");r[".content"].text=n,joint.dia.ElementView.prototype.update.call(this,t,r)}}),function(a,y,t,b){"use strict";var e=a.Element;e.define("standard.Rectangle",{attrs:{body:{refWidth:"100%",refHeight:"100%",strokeWidth:2,stroke:"#000000",fill:"#FFFFFF"},label:{textVerticalAnchor:"middle",textAnchor:"middle",refX:"50%",refY:"50%",fontSize:14,fill:"#333333"}}},{markup:[{tagName:"rect",selector:"body"},{tagName:"text",selector:"label"}]}),e.define("standard.Circle",{attrs:{body:{refCx:"50%",refCy:"50%",refR:"50%",strokeWidth:2,stroke:"#333333",fill:"#FFFFFF"},label:{textVerticalAnchor:"middle",textAnchor:"middle",refX:"50%",refY:"50%",fontSize:14,fill:"#333333"}}},{markup:[{tagName:"circle",selector:"body"},{tagName:"text",selector:"label"}]}),e.define("standard.Ellipse",{attrs:{body:{refCx:"50%",refCy:"50%",refRx:"50%",refRy:"50%",strokeWidth:2,stroke:"#333333",fill:"#FFFFFF"},label:{textVerticalAnchor:"middle",textAnchor:"middle",refX:"50%",refY:"50%",fontSize:14,fill:"#333333"}}},{markup:[{tagName:"ellipse",selector:"body"},{tagName:"text",selector:"label"}]}),e.define("standard.Path",{attrs:{body:{refD:"M 0 0 L 10 0 10 10 0 10 Z",strokeWidth:2,stroke:"#333333",fill:"#FFFFFF"},label:{textVerticalAnchor:"middle",textAnchor:"middle",refX:"50%",refY:"50%",fontSize:14,fill:"#333333"}}},{markup:[{tagName:"path",selector:"body"},{tagName:"text",selector:"label"}]}),e.define("standard.Polygon",{attrs:{body:{refPoints:"0 0 10 0 10 10 0 10",strokeWidth:2,stroke:"#333333",fill:"#FFFFFF"},label:{textVerticalAnchor:"middle",textAnchor:"middle",refX:"50%",refY:"50%",fontSize:14,fill:"#333333"}}},{markup:[{tagName:"polygon",selector:"body"},{tagName:"text",selector:"label"}]}),e.define("standard.Polyline",{attrs:{body:{refPoints:"0 0 10 0 10 10 0 10 0 0",strokeWidth:2,stroke:"#333333",fill:"#FFFFFF"},label:{textVerticalAnchor:"middle",textAnchor:"middle",refX:"50%",refY:"50%",fontSize:14,fill:"#333333"}}},{markup:[{tagName:"polyline",selector:"body"},{tagName:"text",selector:"label"}]}),e.define("standard.Image",{attrs:{image:{refWidth:"100%",refHeight:"100%"},label:{textVerticalAnchor:"top",textAnchor:"middle",refX:"50%",refY:"100%",refY2:10,fontSize:14,fill:"#333333"}}},{markup:[{tagName:"image",selector:"image"},{tagName:"text",selector:"label"}]}),e.define("standard.BorderedImage",{attrs:{border:{refWidth:"100%",refHeight:"100%",stroke:"#333333",strokeWidth:2},background:{refWidth:-1,refHeight:-1,x:.5,y:.5,fill:"#FFFFFF"},image:{refWidth:-1,refHeight:-1,x:.5,y:.5},label:{textVerticalAnchor:"top",textAnchor:"middle",refX:"50%",refY:"100%",refY2:10,fontSize:14,fill:"#333333"}}},{markup:[{tagName:"rect",selector:"background",attributes:{stroke:"none"}},{tagName:"image",selector:"image"},{tagName:"rect",selector:"border",attributes:{fill:"none"}},{tagName:"text",selector:"label"}]}),e.define("standard.EmbeddedImage",{attrs:{body:{refWidth:"100%",refHeight:"100%",stroke:"#333333",fill:"#FFFFFF",strokeWidth:2},image:{refWidth:"30%",refHeight:-20,x:10,y:10,preserveAspectRatio:"xMidYMin"},label:{textVerticalAnchor:"top",textAnchor:"left",refX:"30%",refX2:20,refY:10,fontSize:14,fill:"#333333"}}},{markup:[{tagName:"rect",selector:"body"},{tagName:"image",selector:"image"},{tagName:"text",selector:"label"}]}),e.define("standard.InscribedImage",{attrs:{border:{refRx:"50%",refRy:"50%",refCx:"50%",refCy:"50%",stroke:"#333333",strokeWidth:2},background:{refRx:"50%",refRy:"50%",refCx:"50%",refCy:"50%",fill:"#FFFFFF"},image:{refWidth:"68%",refHeight:"68%",refX:"16%",refY:"16%",preserveAspectRatio:"xMidYMid"},label:{textVerticalAnchor:"top",textAnchor:"middle",refX:"50%",refY:"100%",refY2:10,fontSize:14,fill:"#333333"}}},{markup:[{tagName:"ellipse",selector:"background"},{tagName:"image",selector:"image"},{tagName:"ellipse",selector:"border",attributes:{fill:"none"}},{tagName:"text",selector:"label"}]}),e.define("standard.HeaderedRectangle",{attrs:{body:{refWidth:"100%",refHeight:"100%",strokeWidth:2,stroke:"#000000",fill:"#FFFFFF"},header:{refWidth:"100%",height:30,strokeWidth:2,stroke:"#000000",fill:"#FFFFFF"},headerText:{textVerticalAnchor:"middle",textAnchor:"middle",refX:"50%",refY:15,fontSize:16,fill:"#333333"},bodyText:{textVerticalAnchor:"middle",textAnchor:"middle",refX:"50%",refY:"50%",refY2:15,fontSize:14,fill:"#333333"}}},{markup:[{tagName:"rect",selector:"body"},{tagName:"rect",selector:"header"},{tagName:"text",selector:"headerText"},{tagName:"text",selector:"bodyText"}]});joint.dia.Element.define("standard.Cylinder",{attrs:{body:{lateralArea:10,fill:"#FFFFFF",stroke:"#333333",strokeWidth:2},top:{refCx:"50%",cy:10,refRx:"50%",ry:10,fill:"#FFFFFF",stroke:"#333333",strokeWidth:2},label:{textVerticalAnchor:"middle",textAnchor:"middle",refX:"50%",refY:"100%",refY2:15,fontSize:14,fill:"#333333"}}},{markup:[{tagName:"path",selector:"body"},{tagName:"ellipse",selector:"top"},{tagName:"text",selector:"label"}],topRy:function(t,e){if(void 0===t)return this.attr("body/lateralArea");var i={lateralArea:t},n=y.isPercentage(t)?{refCy:t,refRy:t,cy:null,ry:null}:{refCy:null,refRy:null,cy:t,ry:t};return this.attr({body:i,top:n},e)}},{attributes:{lateralArea:{set:function(t,e){var i=y.isPercentage(t);i&&(t=parseFloat(t)/100);var n=e.x,r=e.y,o=e.width,s=e.height,a=o/2,l=i?s*t:t,h=b.KAPPA,u=h*a,c=h*(i?s*t:t),d=n+o/2,f=n+o,g=r+l,p=g-l,m=r+s-l,v=r+s;return{d:["M",n,g,"L",n,m,"C",n,m+c,d-u,v,d,v,"C",d+u,v,f,m+c,f,m,"L",f,g,"C",f,g-c,d+u,p,d,p,"C",d-u,p,n,g-c,n,g,"Z"].join(" ")}}}}});var i=t.test("svgforeignobject")?{tagName:"foreignObject",selector:"foreignObject",attributes:{overflow:"hidden"},children:[{tagName:"div",namespaceURI:"http://www.w3.org/1999/xhtml",selector:"label",style:{width:"100%",height:"100%",position:"static",backgroundColor:"transparent",textAlign:"center",margin:0,padding:"0px 5px",boxSizing:"border-box",display:"flex",alignItems:"center",justifyContent:"center"}}]}:{tagName:"text",selector:"label",attributes:{"text-anchor":"middle"}};e.define("standard.TextBlock",{attrs:{body:{refWidth:"100%",refHeight:"100%",stroke:"#333333",fill:"#ffffff",strokeWidth:2},foreignObject:{refWidth:"100%",refHeight:"100%"},label:{style:{fontSize:14}}}},{markup:[{tagName:"rect",selector:"body"},i]},{attributes:{text:{set:function(t,e,i,n){if(!(i instanceof HTMLElement)){var r=n.style||{},o={text:t,width:-5,height:"100%"},s=y.assign({textVerticalAnchor:"middle"},r);return a.attributes.textWrap.set.call(this,o,e,i,s),{fill:r.color||null}}i.textContent=t},position:function(t,e,i){if(i instanceof SVGElement)return e.center()}}}});var n=a.Link;n.define("standard.Link",{attrs:{line:{connection:!0,stroke:"#333333",strokeWidth:2,strokeLinejoin:"round",targetMarker:{type:"path",d:"M 10 -5 0 0 10 5 z"}},wrapper:{connection:!0,strokeWidth:10,strokeLinejoin:"round"}}},{markup:[{tagName:"path",selector:"wrapper",attributes:{fill:"none",cursor:"pointer",stroke:"transparent"}},{tagName:"path",selector:"line",attributes:{fill:"none","pointer-events":"none"}}]}),n.define("standard.DoubleLink",{attrs:{line:{connection:!0,stroke:"#DDDDDD",strokeWidth:4,strokeLinejoin:"round",targetMarker:{type:"path",stroke:"#000000",d:"M 10 -3 10 -10 -2 0 10 10 10 3"}},outline:{connection:!0,stroke:"#000000",strokeWidth:6,strokeLinejoin:"round"}}},{markup:[{tagName:"path",selector:"outline",attributes:{fill:"none"}},{tagName:"path",selector:"line",attributes:{fill:"none"}}]}),n.define("standard.ShadowLink",{attrs:{line:{connection:!0,stroke:"#FF0000",strokeWidth:20,strokeLinejoin:"round",targetMarker:{type:"path",stroke:"none",d:"M 0 -10 -10 0 0 10 z"},sourceMarker:{type:"path",stroke:"none",d:"M -10 -10 0 0 -10 10 0 10 0 -10 z"}},shadow:{connection:!0,refX:3,refY:6,stroke:"#000000",strokeOpacity:.2,strokeWidth:20,strokeLinejoin:"round",targetMarker:{type:"path",d:"M 0 -10 -10 0 0 10 z",stroke:"none"},sourceMarker:{type:"path",stroke:"none",d:"M -10 -10 0 0 -10 10 0 10 0 -10 z"}}}},{markup:[{tagName:"path",selector:"shadow",attributes:{fill:"none"}},{tagName:"path",selector:"line",attributes:{fill:"none"}}]})}(joint.dia,joint.util,joint.env,V),joint.routers.manhattan=function(X,n,Y){"use strict";var r={step:10,maximumLoops:2e3,precision:1,maxAllowedDirectionChange:90,perpendicular:!0,excludeEnds:[],excludeTypes:["basic.Text"],startDirections:["top","right","bottom","left"],endDirections:["top","right","bottom","left"],directionMap:{top:{x:0,y:-1},right:{x:1,y:0},bottom:{x:0,y:1},left:{x:-1,y:0}},cost:function(){return this.step},directions:function(){var t=this.step,e=this.cost();return[{offsetX:t,offsetY:0,cost:e},{offsetX:0,offsetY:t,cost:e},{offsetX:-t,offsetY:0,cost:e},{offsetX:0,offsetY:-t,cost:e}]},penalties:function(){return{0:0,45:this.step/2,90:this.step/2}},paddingBox:function(){var t=this.step;return{x:-t,y:-t,width:2*t,height:2*t}},fallbackRouter:function(t,e,i){if(!Y.isFunction(n.routers.orthogonal))throw new Error("Manhattan requires the orthogonal router as default fallback.");return n.routers.orthogonal(t,Y.assign({},r,e),i)},fallbackRoute:function(t,e,i){return null},draggingRoute:null};function y(t){this.map={},this.options=t,this.mapGridSize=100}function W(){this.items=[],this.hash={},this.values={},this.OPEN=1,this.CLOSE=2}function b(t,e){return e&&e.paddingBox?t.sourceBBox.clone().moveAndExpand(e.paddingBox):t.sourceBBox.clone()}function J(t,e){return e&&e.paddingBox?t.targetBBox.clone().moveAndExpand(e.paddingBox):t.targetBBox.clone()}function Z(t,e){return t.sourceAnchor?t.sourceAnchor:b(t,e).center()}function K(t,e,i,n,r){var o,s,a,l,h,u,c,d,f,g,p=360/i,m=t.theta((o=t,s=e,a=n,l=r.step,h=s.x-o.x,u=s.y-o.y,c=h/a.x,d=u/a.y,f=c*l,g=d*l,new X.Point(o.x+f,o.y+g))),v=X.normalizeAngle(m+p/2);return p*Math.floor(v/p)}function Q(t,e){var i=Math.abs(t-e);return 180<i?360-i:i}function tt(t,e){if(!t)return e;var i=Math.abs(t),n=Math.round(i/e);return n?e+(i-n*e)/n:i}function et(t,e){return t.round(e)}function it(t,e,i){return et((n=t.clone(),o=(r=e).source,s=X.snapToGrid(n.x-o.x,r.x)+o.x,a=X.snapToGrid(n.y-o.y,r.y)+o.y,new X.Point(s,a)),i);var n,r,o,s,a}function nt(t){return t.clone().toString()}function g(t){return new X.Point(0===t.x?0:Math.abs(t.x)/t.x,0===t.y?0:Math.abs(t.y)/t.y)}function rt(t,e,i,n,r,o,s){for(var a,l=[],h=g(r.difference(i)),u=nt(i),c=t[u];c;){var d=g((a=e[u]).difference(c));d.equals(h)||(l.unshift(a),h=d),c=t[u=nt(c)]}var f=e[u];return g(f.difference(n)).equals(h)||l.unshift(f),l}function ot(t,e){for(var i=1/0,n=0,r=e.length;n<r;n++){var o=t.manhattanDistance(e[n]);o<i&&(i=o)}return i}function st(d,f,t,g,e){var p=e.precision,m=e.directionMap,v=d.difference(f.center()),i=Y.isObject(m)?Object.keys(m):[],y=Y.toArray(t),n=i.reduce(function(t,e){if(y.includes(e)){for(var i,n=m[e],r=new X.Point(d.x+n.x*(Math.abs(v.x)+f.width),d.y+n.y*(Math.abs(v.y)+f.height)),o=new X.Line(d,r).intersect(f)||[],s=o.length,a=null,l=0;l<s;l++){var h=o[l],u=d.squaredDistance(h);(void 0===i||i<u)&&(i=u,a=h)}if(a){var c=it(a,g,p);f.containsPoint(c)&&(c=it(c.offset(n.x*g.x,n.y*g.y),g,p)),t.push(c)}}return t},[]);return f.containsPoint(d)||n.push(it(d,g,p)),n}function w(t,e,i,n){var r,o,s,a,l=n.precision;r=t instanceof X.Rect?et(Z(this,n).clone(),l):et(t.clone(),l),o=e instanceof X.Rect?et((s=this,a=n,s.targetAnchor?s.targetAnchor:J(s,a).center()).clone(),l):et(e.clone(),l);var h,u,c,d,f,g,p,m,v,y,b=(h=n.step,c=o,{source:(u=r).clone(),x:tt(c.x-u.x,h),y:tt(c.y-u.y,h)});if(g=t instanceof X.Rect?st(d=r,t,n.startDirections,b,n):[d=r],p=e instanceof X.Rect?st(f=o,e,n.endDirections,b,n):[f=o],g=g.filter(i.isPointAccessible,i),p=p.filter(i.isPointAccessible,i),0<g.length&&0<p.length){for(var w=new W,x={},k={},A={},j=0,P=g.length;j<P;j++){var C=g[j],V=nt(C);w.add(V,ot(C,p)),x[V]=C,A[V]=0}var E,M,_=n.previousDirectionAngle,S=void 0===_,B=n.directions;m=b,y=(v=n).step,Y.toArray(v.directions).forEach(function(t){t.gridOffsetX=t.offsetX/y*m.x,t.gridOffsetY=t.offsetY/y*m.y});for(var T=B.length,N=Y.toArray(p).reduce(function(t,e){var i=nt(e);return t.push(i),t},[]),L=n.maximumLoops;!w.isEmpty()&&0<L;){var F,R=w.pop(),D=x[R],z=k[R],O=A[R],I=void 0===z,G=D.equals(d);if(F=I?S?G?null:K(d,D,T,b,n):_:K(z,D,T,b,n),0<=N.indexOf(R))return n.previousDirectionAngle=F,rt(k,x,D,d,f);for(j=0;j<T;j++){var $=(E=B[j]).angle;if(M=Q(F,$),S&&G||!(M>n.maxAllowedDirectionChange)){var q=it(D.clone().offset(E.gridOffsetX,E.gridOffsetY),b,l),H=nt(q);if(!w.isClose(H)&&i.isPointAccessible(q)){if(0<=N.indexOf(H))if(!q.equals(f))if(Q($,K(q,f,T,b,n))>n.maxAllowedDirectionChange)continue;var U=O+E.cost+(G?0:n.penalties[M]);(!w.isOpen(H)||U<A[H])&&(x[H]=q,k[H]=D,A[H]=U,w.add(H,U+ot(q,p)))}}}L--}}return n.fallbackRoute.call(this,d,f,n)}function o(t,e,i){!function(t){if(t.directions=Y.result(t,"directions"),t.penalties=Y.result(t,"penalties"),t.paddingBox=Y.result(t,"paddingBox"),t.padding=Y.result(t,"padding"),t.padding){var e=Y.normalizeSides(t.padding);t.paddingBox={x:-e.left,y:-e.top,width:e.left+e.right,height:e.top+e.bottom}}Y.toArray(t.directions).forEach(function(t){var e=new X.Point(0,0),i=new X.Point(t.offsetX,t.offsetY);t.angle=X.normalizeAngle(e.theta(i))})}(e),i.options.perpendicular=!!e.perpendicular;for(var n,r,o=b(i,e),s=J(i,e),a=Z(i,e),l=new y(e).build(i.paper.model,i.model),h=Y.toArray(t).map(X.Point),u=[],c=a,d=0,f=h.length;d<=f;d++){var g=null;if(r=n||o,!(n=h[d]))if(n=s,(!i.model.get("source").id||!i.model.get("target").id)&&Y.isFunction(e.draggingRoute)){var p=r===o?a:r,m=n.origin();g=e.draggingRoute.call(i,p,m,e)}if(null===(g=g||w.call(i,r,n,l,e)))return e.fallbackRouter(t,e,i);var v=g[0];v&&v.equals(c)&&g.shift(),c=g[g.length-1]||c,Array.prototype.push.apply(u,g)}return u}return y.prototype.build=function(r,o){var c=this.options,d=Y.toArray(c.excludeEnds).reduce(function(t,e){var i=o.get(e);if(i){var n=r.getCell(i.id);n&&t.push(n)}return t},[]),f=[],t=r.getCell(o.get("source").id);t&&(f=Y.union(f,t.getAncestors().map(function(t){return t.id})));var e=r.getCell(o.get("target").id);e&&(f=Y.union(f,e.getAncestors().map(function(t){return t.id})));var g=this.mapGridSize;return r.getElements().reduce(function(t,e){var i=Y.toArray(c.excludeTypes).includes(e.get("type")),n=d.find(function(t){return t.id===e.id}),r=f.includes(e.id);if(!(i||n||r))for(var o=e.getBBox().moveAndExpand(c.paddingBox),s=o.origin().snapToGrid(g),a=o.corner().snapToGrid(g),l=s.x;l<=a.x;l+=g)for(var h=s.y;h<=a.y;h+=g){var u=l+"@"+h;t[u]=t[u]||[],t[u].push(o)}return t},this.map),this},y.prototype.isPointAccessible=function(e){var t=e.clone().snapToGrid(this.mapGridSize).toString();return Y.toArray(this.map[t]).every(function(t){return!t.containsPoint(e)})},W.prototype.add=function(t,e){this.hash[t]?this.items.splice(this.items.indexOf(t),1):this.hash[t]=this.OPEN,this.values[t]=e;var i=n.util.sortedIndex(this.items,t,function(t){return this.values[t]}.bind(this));this.items.splice(i,0,t)},W.prototype.remove=function(t){this.hash[t]=this.CLOSE},W.prototype.isOpen=function(t){return this.hash[t]===this.OPEN},W.prototype.isClose=function(t){return this.hash[t]===this.CLOSE},W.prototype.isEmpty=function(){return 0===this.items.length},W.prototype.pop=function(){var t=this.items.shift();return this.remove(t),t},function(t,e,i){return o(t,Y.assign({},r,e),i)}}(g,joint,joint.util),joint.routers.metro=function(n){var r={maxAllowedDirectionChange:45,diagonalCost:function(){var t=this.step;return Math.ceil(Math.sqrt(t*t<<1))},directions:function(){var t=this.step,e=this.cost(),i=this.diagonalCost();return[{offsetX:t,offsetY:0,cost:e},{offsetX:t,offsetY:t,cost:i},{offsetX:0,offsetY:t,cost:e},{offsetX:-t,offsetY:t,cost:i},{offsetX:-t,offsetY:0,cost:e},{offsetX:-t,offsetY:-t,cost:i},{offsetX:0,offsetY:-t,cost:e},{offsetX:t,offsetY:-t,cost:i}]},fallbackRoute:function(t,e,i){var n=t.theta(e),r=[],o={x:e.x,y:t.y},s={x:t.x,y:e.y};if(90<n%180){var a=o;o=s,s=a}var l=n%90<45?o:s,h=new g.Line(t,l),u=90*Math.ceil(n/90),c=g.Point.fromPolar(h.squaredLength(),g.toRad(u+135),l),d=new g.Line(e,c),f=h.intersection(d),p=f||e,m=f?p:t,v=360/i.directions.length,y=m.theta(e),b=g.normalizeAngle(y+v/2),w=v*Math.floor(b/v);return i.previousDirectionAngle=w,p&&r.push(p.round()),r.push(e),r}};return function(t,e,i){if(!n.isFunction(joint.routers.manhattan))throw new Error("Metro requires the manhattan router.");return joint.routers.manhattan(t,n.assign({},r,e),i)}}(joint.util),joint.routers.normal=function(t,e,i){return t},joint.routers.oneSide=function(t,e,i){var n,r,o,s=e.side||"bottom",a=joint.util.normalizeSides(e.padding||40),l=i.sourceBBox,h=i.targetBBox,u=l.center(),c=h.center();switch(s){case"bottom":o=1,n="y",r="height";break;case"top":o=-1,n="y",r="height";break;case"left":o=-1,n="x",r="width";break;case"right":o=1,n="x",r="width";break;default:throw new Error("Router: invalid side")}return u[n]+=o*(l[r]/2+a[s]),c[n]+=o*(h[r]/2+a[s]),0<o*(u[n]-c[n])?c[n]=u[n]:u[n]=c[n],[u].concat(t,c)},joint.routers.orthogonal=function(x){var h={N:"S",S:"N",E:"W",W:"E"},f={N:-Math.PI/2*3,S:-Math.PI/2,E:0,W:Math.PI};function p(t,e,i){var n=new g.Point(t.x,e.y);return i.containsPoint(n)&&(n=new g.Point(e.x,t.y)),n}function d(t,e){return t["W"===e||"E"===e?"width":"height"]}function k(t,e){return t.x===e.x?t.y>e.y?"N":"S":t.y===e.y?t.x>e.x?"W":"E":null}function A(t){return new g.Rect(t.x,t.y,0,0)}function j(t){var e=x.normalizeSides(t.padding||t.elementPadding||20);return{x:-e.left,y:-e.top,width:e.left+e.right,height:e.top+e.bottom}}function P(t,e){return t.sourceBBox.clone().moveAndExpand(j(e))}function C(t,e){return t.targetBBox.clone().moveAndExpand(j(e))}function V(t,e,i){var n=new g.Point(t.x,e.y),r=new g.Point(e.x,t.y),o=k(t,n),s=k(t,r),a=h[i],l=o===i||o!==a&&(s===a||s!==i)?n:r;return{points:[l],direction:k(l,e)}}function E(t,e,i){var n=p(t,e,i);return{points:[n],direction:k(n,e)}}function M(e,t,i,n){var r,o={},s=[new g.Point(e.x,t.y),new g.Point(t.x,e.y)],a=s.filter(function(t){return!i.containsPoint(t)}),l=a.filter(function(t){return k(t,e)!==n});if(0<l.length)r=(r=l.filter(function(t){return k(e,t)===n}).pop())||l[0],o.points=[r],o.direction=k(r,t);else{r=x.difference(s,a)[0];var h=new g.Point(t).move(r,-d(i,n)/2),u=p(h,e,i);o.points=[u,h],o.direction=k(h,t)}return o}function _(t,e,i,n){var r=E(e,t,n),o=r.points[0];if(i.containsPoint(o)){var s=(r=E(t,e,i)).points[0];if(n.containsPoint(s)){var a=new g.Point(t).move(s,-d(i,k(t,s))/2),l=new g.Point(e).move(o,-d(n,k(e,o))/2),h=new g.Line(a,l).midpoint(),u=E(t,h,i),c=V(h,e,u.direction);r.points=[u.points[0],c.points[0]],r.direction=c.direction}}return r}function S(t,e,i,n,r){var o,s,a,l={},h=i.union(n).inflate(1),u=h.center().distance(e)>h.center().distance(t),c=u?e:t,d=u?t:e;return s=p(o=r?(o=g.Point.fromPolar(h.width+h.height,f[r],c),h.pointNearestToPoint(o).move(o,-1)):h.pointNearestToPoint(c).move(c,1),d,h),o.round().equals(s.round())?(s=g.Point.fromPolar(h.width+h.height,g.toRad(o.theta(c))+Math.PI/2,d),a=p(o,s=h.pointNearestToPoint(s).move(d,1).round(),h),l.points=u?[s,a,o]:[o,a,s]):l.points=u?[s,o]:[o,s],l.direction=k(u?o:s,e),l}return function(t,e,i){var n,r,o,s,a,l=P(i,e),h=C(i,e),u=(r=e,(n=i).sourceAnchor?n.sourceAnchor:P(n,r).center()),c=(s=e,(o=i).targetAnchor?o.targetAnchor:C(o,s).center());l=l.union(A(u)),h=h.union(A(c)),(t=x.toArray(t).map(g.Point)).unshift(u),t.push(c);for(var d=[],f=0,p=t.length-1;f<p;f++){var m=null,v=t[f],y=t[f+1],b=!!k(v,y);if(0===f)f+1===p?l.intersect(h.clone().inflate(1))?m=S(v,y,l,h):b||(m=_(v,y,l,h)):l.containsPoint(y)?m=S(v,y,l,A(y).moveAndExpand(j(e))):b||(m=E(v,y,l));else if(f+1===p){var w=b&&k(y,v)===a;h.containsPoint(v)||w?m=S(v,y,A(v).moveAndExpand(j(e)),h,a):b||(m=M(v,y,h,a))}else b||(m=V(v,y,a));a=m?(Array.prototype.push.apply(d,m.points),m.direction):k(v,y),f+1<p&&d.push(y)}return d}}(joint.util),joint.connectors.normal=function(t,e,i,n){var r=n&&n.raw,o=[t].concat(i).concat([e]),s=new g.Polyline(o),a=new g.Path(s);return r?a:a.serialize()},joint.connectors.rounded=function(t,e,i,n){n||(n={});var r,o=n.radius||10,s=n.raw,a=new g.Path;r=g.Path.createSegment("M",t),a.appendSegment(r);for(var l,h,u,c,d,f,p,m,v,y,b,w=0,x=i.length;w<x;w++)l=new g.Point(i[w]),h=i[w-1]||t,u=i[w+1]||e,c=d||l.distance(h)/2,d=l.distance(u)/2,f=-Math.min(o,c),p=-Math.min(o,d),m=l.clone().move(h,f).round(),v=l.clone().move(u,p).round(),y=new g.Point(1/3*m.x+2/3*l.x,2/3*l.y+1/3*m.y),b=new g.Point(1/3*v.x+2/3*l.x,2/3*l.y+1/3*v.y),r=g.Path.createSegment("L",m),a.appendSegment(r),r=g.Path.createSegment("C",y,b,v),a.appendSegment(r);return r=g.Path.createSegment("L",e),a.appendSegment(r),s?a:a.serialize()},joint.connectors.smooth=function(t,e,i,n){var r,o=n&&n.raw;if(i&&0!==i.length){var s=[t].concat(i).concat([e]),a=g.Curve.throughPoints(s);r=new g.Path(a)}else{var l;if(r=new g.Path,l=g.Path.createSegment("M",t),r.appendSegment(l),Math.abs(t.x-e.x)>=Math.abs(t.y-e.y)){var h=(t.x+e.x)/2;l=g.Path.createSegment("C",h,t.y,h,e.y,e.x,e.y),r.appendSegment(l)}else{var u=(t.y+e.y)/2;l=g.Path.createSegment("C",t.x,u,e.x,u,e.x,e.y),r.appendSegment(l)}}return o?r:r.serialize()},joint.connectors.jumpover=function(w,x){var k=["arc","gap","cubic"],A=["smooth"];function j(t,e,i){var r=[].concat(t,i,e);return r.reduce(function(t,e,i){var n=r[i+1];return null!=n&&(t[i]=w.line(e,n)),t},[])}function P(){for(var t=this._jumpOverUpdateList,e=0;e<t.length;e++)t[e].update()}function C(t,e){return w.line(t,e).squaredLength()}function V(t,d,f){var g,p=new w.Path;return g=w.Path.createSegment("M",t[0].start),p.appendSegment(g),joint.util.toArray(t).forEach(function(t,e){var i,n,r,o;if(t.isJump){if("arc"===f){i=-90,n=t.start.difference(t.end);var s=Number(n.x<0||0===n.x&&n.y<0);s&&(i+=180);var a,l=t.midpoint(),h=new w.Line(l,t.end).rotate(l,i);r=(a=new w.Line(t.start,l)).pointAt(2/3).rotate(t.start,i),o=h.pointAt(1/3).rotate(h.end,-i),g=w.Path.createSegment("C",r,o,h.end),p.appendSegment(g),a=new w.Line(l,t.end),r=h.pointAt(1/3).rotate(h.end,i),o=a.pointAt(1/3).rotate(t.end,-i),g=w.Path.createSegment("C",r,o,t.end),p.appendSegment(g)}else if("gap"===f)g=w.Path.createSegment("M",t.end),p.appendSegment(g);else if("cubic"===f){i=t.start.theta(t.end);var u=.6*d,c=1.35*d;n=t.start.difference(t.end),(s=Number(n.x<0||0===n.x&&n.y<0))&&(c*=-1),r=w.Point(t.start.x+u,t.start.y+c).rotate(t.start,i),o=w.Point(t.end.x-u,t.end.y+c).rotate(t.end,i),g=w.Path.createSegment("C",r,o,t.end),p.appendSegment(g)}}else g=w.Path.createSegment("L",t.end),p.appendSegment(g)}),p}return function(t,e,i,n){var r,o;null==(o=(r=this).paper._jumpOverUpdateList)&&(o=r.paper._jumpOverUpdateList=[],r.paper.on("cell:pointerup",P),r.paper.model.on("reset",function(){o=r.paper._jumpOverUpdateList=[]})),o.indexOf(r)<0&&(o.push(r),r.listenToOnce(r.model,"change:connector remove",function(){o.splice(o.indexOf(r),1)}));var s=n.raw,a=n.size||5,l=n.jump&&(""+n.jump).toLowerCase(),h=n.ignoreConnectors||A;-1===k.indexOf(l)&&(l=k[0]);var u=this.paper,c=u.model.getLinks();if(1===c.length)return V(j(t,e,i),a,l);var d=this.model,f=c.indexOf(d),g=u.options.defaultConnector||{},p=c.filter(function(t,e){var i=t.get("connector")||g;return!x.toArray(h).includes(i.name)&&(!(f<e)||"jumpover"!==i.name)}),m=p.map(function(t){return u.findViewByModel(t)}),v=j(t,e,i),y=m.map(function(t){return null==t?[]:t===this?v:j(t.sourcePoint,t.targetPoint,t.route)},this),b=V(v.reduce(function(t,s){var h,u,c,e=p.reduce(function(t,e,i){if(e!==d){var n=(r=s,o=y[i],x.toArray(o).reduce(function(t,e){var i=r.intersection(e);return i&&t.push(i),t},[]));t.push.apply(t,n)}var r,o;return t},[]).sort(function(t,e){return C(s.start,t)-C(s.start,e)});return 0<e.length?t.push.apply(t,(h=s,c=a,(u=e).reduce(function(t,e,i){if(!0===e.skip)return t;var n=t.pop()||h,r=w.point(e).move(n.start,-c),o=w.point(e).move(n.start,+c),s=u[i+1];if(null!=s){var a=o.distance(s);a<=c&&(o=s.move(n.start,a),s.skip=!0)}else if(r.distance(n.end)<2*c+1)return t.push(n),t;if(o.distance(n.start)<2*c+1)return t.push(n),t;var l=w.line(r,o);return l.isJump=!0,t.push(w.line(n.start,r),l,w.line(o,n.end)),t},[]))):t.push(s),t},[]),a,l);return s?b:b.serialize()}}(g,joint.util),function(r,o,s){function d(t,e,i){var n=t.toJSON();return n.angle=e||0,o.util.defaults({},i,n)}function n(t,e,i){return t.map(function(t,e,i){var n=this.pointAt((e+.5)/i.length);return(t.dx||t.dy)&&n.offset(t.dx||0,t.dy||0),d(n.round(),0,t)},r.line(e,i))}function a(t,e,s,a){var l=e.center(),h=e.width/e.height,u=e.topMiddle(),c=r.Ellipse.fromRect(e);return t.map(function(t,e,i){var n=s+a(e,i.length),r=u.clone().rotate(l,-n).scale(h,1,l),o=t.compensateRotation?-c.tangentTheta(r):0;return(t.dx||t.dy)&&r.offset(t.dx||0,t.dy||0),t.dr&&r.move(l,t.dr),d(r.round(),o,t)})}function l(t,e){var i=e.x;s.isString(i)&&(i=parseFloat(i)/100*t.width);var n=e.y;return s.isString(n)&&(n=parseFloat(n)/100*t.height),r.point(i||0,n||0)}o.layout.Port={absolute:function(t,e,i){return t.map(l.bind(null,e))},fn:function(t,e,i){return i.fn(t,e,i)},line:function(t,e,i){return n(t,l(e,i.start||e.origin()),l(e,i.end||e.corner()))},left:function(t,e,i){return n(t,e.origin(),e.bottomLeft())},right:function(t,e,i){return n(t,e.topRight(),e.corner())},top:function(t,e,i){return n(t,e.origin(),e.topRight())},bottom:function(t,e,i){return n(t,e.bottomLeft(),e.corner())},ellipseSpread:function(t,e,i){var n=i.startAngle||0,r=i.step||360/t.length;return a(t,e,n,function(t){return t*r})},ellipse:function(t,e,i){var n=i.startAngle||0,r=i.step||20;return a(t,e,n,function(t,e){return(t+.5-e/2)*r})}}}(g,joint,joint.util),function(u,t,f){function g(t,e){return f.defaultsDeep({},t,e,{x:0,y:0,angle:0,attrs:{".":{y:"0","text-anchor":"start"}}})}function n(t,e,i,n){n=f.defaults({},n,{offset:15});var r,o,s,a,l=e.center().theta(t),h=p(e),u=n.offset,c=0;a=l<h[1]||l>h[2]?(s=".3em",r=u,o=0,"start"):l<h[0]?(s="0",r=0,o=-u,i?(c=-90,"start"):"middle"):l<h[3]?(s=".3em",r=-u,o=0,"end"):(s=".6em",r=0,o=u,i?(c=90,"start"):"middle");var d=Math.round;return g({x:d(r),y:d(o),angle:c,attrs:{".":{y:s,"text-anchor":a}}})}function p(t){var e=t.center(),i=e.theta(t.origin()),n=e.theta(t.bottomLeft()),r=e.theta(t.corner());return[i,e.theta(t.topRight()),r,n]}function r(t,e,i,n){var r,o,s,a,l=e.center().theta(t),h=(n=f.defaults({},n,{offset:15})).offset,u=0,c=p(e);a=l<c[1]||l>c[2]?(s=".3em",r=-h,o=0,"end"):l<c[0]?(s=".6em",r=0,o=h,i?(u=90,"start"):"middle"):l<c[3]?(s=".3em",r=h,o=0,"start"):(s="0em",r=0,o=-h,i?(u=-90,"start"):"middle");var d=Math.round;return g({x:d(r),y:d(o),angle:u,attrs:{".":{y:s,"text-anchor":a}}})}function o(t,e,i){i=f.defaults({},i,{offset:20});var n,r=u.point(0,0),o=-t.theta(r),s=o,a=t.clone().move(r,i.offset).difference(t).round(),l=".3em";(o+90)%180==0?(n=e?"end":"middle",e||-270!==o||(l="0em")):-270<o&&o<-90?(n="start",s=o-180):n="end";var h=Math.round;return g({x:h(a.x),y:h(a.y),angle:e?s:0,attrs:{".":{y:l,"text-anchor":n}}})}t.layout.PortLabel={manual:function(t,e,i){return g(i,e)},left:function(t,e,i){return g(i,{x:-15,attrs:{".":{y:".3em","text-anchor":"end"}}})},right:function(t,e,i){return g(i,{x:15,attrs:{".":{y:".3em","text-anchor":"start"}}})},top:function(t,e,i){return g(i,{y:-15,attrs:{".":{"text-anchor":"middle"}}})},bottom:function(t,e,i){return g(i,{y:15,attrs:{".":{y:".6em","text-anchor":"middle"}}})},outsideOriented:function(t,e,i){return n(t,e,!0,i)},outside:function(t,e,i){return n(t,e,!1,i)},insideOriented:function(t,e,i){return r(t,e,!0,i)},inside:function(t,e,i){return r(t,e,!1,i)},radial:function(t,e,i){return o(t.difference(e.center()),!1,i)},radialOriented:function(t,e,i){return o(t.difference(e.center()),!0,i)}}}(g,joint,joint.util),joint.highlighters.addClass={className:joint.util.addClassNamePrefix("highlighted"),highlight:function(t,e,i){var n=(i||{}).className||this.className;V(e).addClass(n)},unhighlight:function(t,e,i){var n=(i||{}).className||this.className;V(e).removeClass(n)}},joint.highlighters.opacity={highlight:function(t,e){V(e).addClass(joint.util.addClassNamePrefix("highlight-opacity"))},unhighlight:function(t,e){V(e).removeClass(joint.util.addClassNamePrefix("highlight-opacity"))}},joint.highlighters.stroke={defaultOptions:{padding:3,rx:0,ry:0,attrs:{"stroke-width":3,stroke:"#FEB663"}},_views:{},getHighlighterId:function(t,e){return t.id+JSON.stringify(e)},removeHighlighter:function(t){this._views[t]&&(this._views[t].remove(),this._views[t]=null)},highlight:function(t,e,i){var n=this.getHighlighterId(e,i);if(!this._views[n]){var r,o=joint.util.defaults(i||{},this.defaultOptions),s=V(e);try{var a=s.convertToPathData()}catch(t){r=s.bbox(!0),a=V.rectToPath(joint.util.assign({},o,r))}var l=V("path").attr({d:a,"pointer-events":"none","vector-effect":"non-scaling-stroke",fill:"none"}).attr(o.attrs),h=s.getTransformToElement(t.el),u=o.padding;if(u){r||(r=s.bbox(!0));var c=r.x+r.width/2,d=r.y+r.height/2;r=V.transformRect(r,h);var f=Math.max(r.width,1),g=Math.max(r.height,1),p=(f+u)/f,m=(g+u)/g,v=V.createSVGMatrix({a:p,b:0,c:0,d:m,e:c-p*c,f:d-m*d});h=h.multiply(v)}l.transform(h);var y=this._views[n]=new joint.mvc.View({svgElement:!0,className:"highlight-stroke",el:l.node}),b=this.removeHighlighter.bind(this,n),w=t.model;y.listenTo(w,"remove",b),y.listenTo(w.graph,"reset",b),t.vel.append(l)}},unhighlight:function(t,e,i){this.removeHighlighter(this.getHighlighterId(e,i))}},function(t,d){function e(c){return function(t,e,i,n){var r=!!n.rotate,o=r?t.getNodeUnrotatedBBox(e):t.getNodeBBox(e),s=o[c](),a=n.dx;if(a){var l=d.isPercentage(a);a=parseFloat(a),isFinite(a)&&(l&&(a/=100,a*=o.width),s.x+=a)}var h=n.dy;if(h){var u=d.isPercentage(h);h=parseFloat(h),isFinite(h)&&(u&&(h/=100,h*=o.height),s.y+=h)}return r?s.rotate(t.model.getBBox().center(),-t.model.angle()):s}}function i(s){return function(t,e,i,n){if(i instanceof Element){var r=this.paper.findView(i),o=r?r.getNodeBBox(i).center():new g.Point;return s.call(this,t,e,o,n)}return s.apply(this,arguments)}}t.anchors={center:e("center"),top:e("topMiddle"),bottom:e("bottomMiddle"),left:e("leftMiddle"),right:e("rightMiddle"),topLeft:e("origin"),topRight:e("topRight"),bottomLeft:e("bottomLeft"),bottomRight:e("corner"),perpendicular:i(function(t,e,i,n){var r=t.model.angle(),o=t.getNodeBBox(e),s=o.center(),a=o.origin(),l=o.corner(),h=n.padding;if(isFinite(h)||(h=0),a.y+h<=i.y&&i.y<=l.y-h){var u=i.y-s.y;s.x+=0===r||180===r?0:1*u/Math.tan(g.toRad(r)),s.y+=u}else if(a.x+h<=i.x&&i.x<=l.x-h){var c=i.x-s.x;s.y+=90===r||270===r?0:c*Math.tan(g.toRad(r)),s.x+=c}return s}),midSide:i(function(t,e,i,n){var r,o,s,a=!!n.rotate;a?(r=t.getNodeUnrotatedBBox(e),s=t.model.getBBox().center(),o=t.model.angle()):r=t.getNodeBBox(e);var l,h=n.padding;switch(isFinite(h)&&r.inflate(h),a&&i.rotate(s,o),r.sideNearestToPoint(i)){case"left":l=r.leftMiddle();break;case"right":l=r.rightMiddle();break;case"top":l=r.topMiddle();break;case"bottom":l=r.bottomMiddle()}return a?l.rotate(s,-o):l}),modelCenter:function(t,e){var i=t.model,n=i.getBBox(),r=n.center(),o=i.angle(),s=t.findAttribute("port",e);if(s){var a=i.portProp(s,"group"),l=i.getPortsPositions(a),h=new g.Point(l[s]).offset(n.origin());return h.rotate(r,-o),h}return r}}}(joint,joint.util),function(t,x,k,A){function j(t,e){return 1===t.length?t[0]:x.sortBy(t,function(t){return t.squaredDistance(e)})[0]}function P(t,e,i){if(!isFinite(i))return t;var n=t.distance(e);return 0===i&&0<n?t:t.move(e,-Math.min(i,n-1))}function C(t){var e=t.getAttribute("stroke-width");return null===e?0:parseFloat(e)||0}function h(t,e,i,n){var r=e.getNodeBBox(i);n.stroke&&r.inflate(C(i)/2);var o=t.intersect(r);return P(o?j(o,t.start):t.end,t.start,n.offset)}var V="segmentSubdivisons",E="shapeBBox";t.connectionPoints={anchor:function(t,e,i,n){return P(t.end,t.start,n.offset)},bbox:h,rectangle:function(t,e,i,n){var r=e.model.angle();if(0===r)return h(t,e,i,n);var o=e.getNodeUnrotatedBBox(i);n.stroke&&o.inflate(C(i)/2);var s=o.center(),a=t.clone().rotate(s,r),l=a.setLength(1e6).intersect(o);return P(l?j(l,a.start).rotate(s,-r):t.end,t.start,n.offset)},boundary:function(t,e,i,n){var r,o,s=n.selector,a=t.end;if(r="string"==typeof s?e.findBySelector(s)[0]:Array.isArray(s)?x.getByPath(i,s):function(t){if(!t)return null;var e=t;do{var i=e.tagName;if("string"!=typeof i)return null;if("G"===(i=i.toUpperCase()))e=e.firstElementChild;else{if("TITLE"!==i)break;e=e.nextElementSibling}}while(e);return e}(i),!A.isSVGGraphicsElement(r)){if(r===i||!A.isSVGGraphicsElement(i))return a;r=i}var l,h=e.getNodeShape(r),u=e.getNodeMatrix(r),c=e.getRootTranslateMatrix(),d=e.getRootRotateMatrix(),f=c.multiply(d).multiply(u),g=f.inverse(),p=A.transformLine(t,g),m=p.start.clone(),v=e.getNodeData(r);if(!1===n.insideout&&(v[E]||(v[E]=h.bbox()),v[E].containsPoint(m)))return a;if(h instanceof k.Path){var y=n.precision||2;v[V]||(v[V]=h.getSegmentSubdivisions({precision:y})),l={precision:y,segmentSubdivisions:v[V]}}!0===n.extrapolate&&p.setLength(1e6),(o=p.intersect(h,l))?A.isArray(o)&&(o=j(o,m)):!0===n.sticky&&(o=h instanceof k.Rect?h.pointNearestToPoint(m):h instanceof k.Ellipse?h.intersectionWithLineFromCenterToPoint(m):h.closestPoint(m,l));var b=o?A.transformPoint(o,f):a,w=n.offset||0;return n.stroke&&(w+=C(r)/2),P(b,t.start,w)}}}(joint,joint.util,g,V),function(t,e){function u(t,e){return 0===e?"0%":Math.round(t/e*100)+"%"}function i(h){return function(t,e,i,n){var r=e.model.angle(),o=e.getNodeUnrotatedBBox(i),s=e.model.getBBox().center();n.rotate(s,r);var a=n.x-o.x,l=n.y-o.y;return h&&(a=u(a,o.width),l=u(l,o.height)),t.anchor={name:"topLeft",args:{dx:a,dy:l,rotate:!0}},t}}t.connectionStrategies={useDefaults:e.noop,pinAbsolute:i(!1),pinRelative:i(!0)}}(joint,joint.util),function(n,E,l,g){function t(t,e,i){return n.connectionStrategies.pinRelative.call(this.paper,{},e,i,t,this.model).anchor}var e=n.dia.ToolView,i=n.mvc.View.extend({tagName:"circle",svgElement:!0,className:"marker-vertex",events:{mousedown:"onPointerDown",touchstart:"onPointerDown",dblclick:"onDoubleClick"},documentEvents:{mousemove:"onPointerMove",touchmove:"onPointerMove",mouseup:"onPointerUp",touchend:"onPointerUp",touchcancel:"onPointerUp"},attributes:{r:6,fill:"#33334F",stroke:"#FFFFFF","stroke-width":2,cursor:"move"},position:function(t,e){this.vel.attr({cx:t,cy:e})},onPointerDown:function(t){t.stopPropagation(),t.preventDefault(),this.options.paper.undelegateEvents(),this.delegateDocumentEvents(null,t.data),this.trigger("will-change")},onPointerMove:function(t){this.trigger("changing",this,t)},onDoubleClick:function(t){this.trigger("remove",this,t)},onPointerUp:function(t){this.trigger("changed",this,t),this.undelegateDocumentEvents(),this.options.paper.delegateEvents()}}),r=e.extend({name:"vertices",options:{handleClass:i,snapRadius:20,redundancyRemoval:!0,vertexAdding:!0},children:[{tagName:"path",selector:"connection",className:"joint-vertices-path",attributes:{fill:"none",stroke:"transparent","stroke-width":10,cursor:"cell"}}],handles:null,events:{"mousedown .joint-vertices-path":"onPathPointerDown","touchstart .joint-vertices-path":"onPathPointerDown"},onRender:function(){this.resetHandles(),this.options.vertexAdding&&(this.renderChildren(),this.updatePath());for(var t=this.relatedView.model.vertices(),e=0,i=t.length;e<i;e++){var n=t[e],r=new this.options.handleClass({index:e,paper:this.paper});r.render(),r.position(n.x,n.y),this.simulateRelatedView(r.el),r.vel.appendTo(this.el),this.handles.push(r),this.startHandleListening(r)}return this},update:function(){return this.render(),this},updatePath:function(){var t=this.childNodes.connection;t&&t.setAttribute("d",this.relatedView.getConnection().serialize())},startHandleListening:function(t){var e=this.relatedView;e.can("vertexMove")&&(this.listenTo(t,"will-change",this.onHandleWillChange),this.listenTo(t,"changing",this.onHandleChanging),this.listenTo(t,"changed",this.onHandleChanged)),e.can("vertexRemove")&&this.listenTo(t,"remove",this.onHandleRemove)},resetHandles:function(){var t=this.handles;if(this.handles=[],this.stopListening(),Array.isArray(t))for(var e=0,i=t.length;e<i;e++)t[e].remove()},getNeighborPoints:function(t){var e=this.relatedView,i=e.model.vertices(),n=0<t?i[t-1]:e.sourceAnchor,r=t<i.length-1?i[t+1]:e.targetAnchor;return{prev:new g.Point(n),next:new g.Point(r)}},onHandleWillChange:function(t,e){this.focus(),this.relatedView.model.startBatch("vertex-move",{ui:!0,tool:this.cid})},onHandleChanging:function(t,e){var i=this.relatedView,n=i.paper,r=t.options.index,o=E.normalizeEvent(e),s=n.snapToGrid(o.clientX,o.clientY).toJSON();this.snapVertex(s,r),i.model.vertex(r,s,{ui:!0,tool:this.cid}),t.position(s.x,s.y)},snapVertex:function(t,e){var i=this.options.snapRadius;if(0<i){var n=this.getNeighborPoints(e),r=n.prev,o=n.next;Math.abs(t.x-r.x)<i?t.x=r.x:Math.abs(t.x-o.x)<i&&(t.x=o.x),Math.abs(t.y-r.y)<i?t.y=n.prev.y:Math.abs(t.y-o.y)<i&&(t.y=o.y)}},onHandleChanged:function(t,e){if(this.options.vertexAdding&&this.updatePath(),this.options.redundancyRemoval){var i=this.relatedView;i.removeRedundantLinearVertices({ui:!0,tool:this.cid})&&this.render(),this.blur(),i.model.stopBatch("vertex-move",{ui:!0,tool:this.cid}),this.eventData(e).vertexAdded&&i.model.stopBatch("vertex-add",{ui:!0,tool:this.cid})}},onHandleRemove:function(t){var e=t.options.index;this.relatedView.model.removeVertex(e,{ui:!0})},onPathPointerDown:function(t){t.stopPropagation(),t.preventDefault();var e=E.normalizeEvent(t),i=this.paper.snapToGrid(e.clientX,e.clientY).toJSON(),n=this.relatedView;n.model.startBatch("vertex-add",{ui:!0,tool:this.cid});var r=n.getVertexIndex(i.x,i.y);this.snapVertex(i,r),n.model.insertVertex(r,i,{ui:!0,tool:this.cid}),this.render();var o=this.handles[r];this.eventData(t,{vertexAdded:!0}),o.onPointerDown(t)},onRemove:function(){this.resetHandles()}},{VertexHandle:i}),o=n.mvc.View.extend({tagName:"g",svgElement:!0,className:"marker-segment",events:{mousedown:"onPointerDown",touchstart:"onPointerDown"},documentEvents:{mousemove:"onPointerMove",touchmove:"onPointerMove",mouseup:"onPointerUp",touchend:"onPointerUp",touchcancel:"onPointerUp"},children:[{tagName:"line",selector:"line",attributes:{stroke:"#33334F","stroke-width":2,fill:"none","pointer-events":"none"}},{tagName:"rect",selector:"handle",attributes:{width:20,height:8,x:-10,y:-4,rx:4,ry:4,fill:"#33334F",stroke:"#FFFFFF","stroke-width":2}}],onRender:function(){this.renderChildren()},position:function(t,e,i,n){var r=l.createSVGMatrix().translate(t,e).rotate(i),o=this.childNodes.handle;o.setAttribute("transform",l.matrixToTransformString(r)),o.setAttribute("cursor",i%180==0?"row-resize":"col-resize");var s=n.getClosestPoint(new g.Point(t,e)),a=this.childNodes.line;a.setAttribute("x1",t),a.setAttribute("y1",e),a.setAttribute("x2",s.x),a.setAttribute("y2",s.y)},onPointerDown:function(t){this.trigger("change:start",this,t),t.stopPropagation(),t.preventDefault(),this.options.paper.undelegateEvents(),this.delegateDocumentEvents(null,t.data)},onPointerMove:function(t){this.trigger("changing",this,t)},onPointerUp:function(t){this.undelegateDocumentEvents(),this.options.paper.delegateEvents(),this.trigger("change:end",this,t)},show:function(){this.el.style.display=""},hide:function(){this.el.style.display="none"}}),s=e.extend({name:"segments",precision:.5,options:{handleClass:o,segmentLengthThreshold:40,redundancyRemoval:!0,anchor:t,snapRadius:10,snapHandle:!0},handles:null,onRender:function(){this.resetHandles();var t=this.relatedView,e=t.model.vertices();e.unshift(t.sourcePoint),e.push(t.targetPoint);for(var i=0,n=e.length;i<n-1;i++){var r=e[i],o=e[i+1],s=this.renderHandle(r,o);this.simulateRelatedView(s.el),this.handles.push(s),s.options.index=i}return this},renderHandle:function(t,e){var i=new this.options.handleClass({paper:this.paper});return i.render(),this.updateHandle(i,t,e),i.vel.appendTo(this.el),this.startHandleListening(i),i},update:function(){return this.render(),this},startHandleListening:function(t){this.listenTo(t,"change:start",this.onHandleChangeStart),this.listenTo(t,"changing",this.onHandleChanging),this.listenTo(t,"change:end",this.onHandleChangeEnd)},resetHandles:function(){var t=this.handles;if(this.handles=[],this.stopListening(),Array.isArray(t))for(var e=0,i=t.length;e<i;e++)t[e].remove()},shiftHandleIndexes:function(t){for(var e=this.handles,i=0,n=e.length;i<n;i++)e[i].options.index+=t},resetAnchor:function(t,e){var i=this.relatedView.model;e?i.prop([t,"anchor"],e,{rewrite:!0,ui:!0,tool:this.cid}):i.removeProp([t,"anchor"],{ui:!0,tool:this.cid})},snapHandle:function(t,e,i){var n=t.options.index,r=this.relatedView.model.vertices(),o=t.options.axis,s=r[n-2]||i.sourceAnchor,a=r[n+1]||i.targetAnchor,l=this.options.snapRadius;return Math.abs(e[o]-s[o])<l?e[o]=s[o]:Math.abs(e[o]-a[o])<l&&(e[o]=a[o]),e},onHandleChanging:function(t,e){var i=this.eventData(e),n=this.relatedView,r=n.paper,o=t.options.index-1,s=E.normalizeEvent(e),a=r.snapToGrid(s.clientX,s.clientY),l=this.snapHandle(t,a.clone(),i),h=t.options.axis,u=this.options.snapHandle?0:a[h]-l[h],c=n.model,d=E.cloneDeep(c.vertices()),f=d[o],g=d[o+1],p=this.options.anchor;"function"!=typeof p&&(p=null);var m=n.sourceView,v=n.sourceBBox,y=!1,b=!1;if(f?0===o?v.containsPoint(f)?(d.shift(),this.shiftHandleIndexes(-1),y=!0):(f[h]=l[h],b=!0):f[h]=l[h]:((f=n.sourceAnchor.toJSON())[h]=l[h],v.containsPoint(f)?(f[h]=l[h],y=!0):(d.unshift(f),this.shiftHandleIndexes(1),b=!0)),p&&m){if(y){var w=i.sourceAnchor.clone();w[h]=l[h];var x=p.call(n,w,m,n.sourceMagnet||m.el,"source",n);this.resetAnchor("source",x)}b&&this.resetAnchor("source",i.sourceAnchorDef)}var k=n.targetView,A=n.targetBBox,j=!1,P=!1;if(g?o===d.length-2?A.containsPoint(g)?(d.pop(),j=!0):(g[h]=l[h],P=!0):g[h]=l[h]:((g=n.targetAnchor.toJSON())[h]=l[h],A.containsPoint(g)?j=!0:(d.push(g),P=!0)),p&&k){if(j){var C=i.targetAnchor.clone();C[h]=l[h];var V=p.call(n,C,k,n.targetMagnet||k.el,"target",n);this.resetAnchor("target",V)}P&&this.resetAnchor("target",i.targetAnchorDef)}c.vertices(d,{ui:!0,tool:this.cid}),this.updateHandle(t,f,g,u)},onHandleChangeStart:function(t,e){var i=t.options.index,n=this.handles;if(Array.isArray(n)){for(var r=0,o=n.length;r<o;r++)r!==i&&n[r].hide();this.focus();var s=this.relatedView,a=s.model;this.eventData(e,{sourceAnchor:s.sourceAnchor.clone(),targetAnchor:s.targetAnchor.clone(),sourceAnchorDef:E.clone(a.prop(["source","anchor"])),targetAnchorDef:E.clone(a.prop(["target","anchor"]))}),s.model.startBatch("segment-move",{ui:!0,tool:this.cid})}},onHandleChangeEnd:function(t){var e=this.relatedView;this.options.redundancyRemoval&&e.removeRedundantLinearVertices({ui:!0,tool:this.cid}),this.render(),this.blur(),e.model.stopBatch("segment-move",{ui:!0,tool:this.cid})},updateHandle:function(t,e,i,n){var r=Math.abs(e.x-i.x)<this.precision,o=Math.abs(e.y-i.y)<this.precision;if(r||o){var s=new g.Line(e,i);if(s.length()<this.options.segmentLengthThreshold)t.hide();else{var a=s.midpoint(),l=r?"x":"y";a[l]+=n||0;var h=s.vector().vectorAngle(new g.Point(1,0));t.position(a.x,a.y,h,this.relatedView),t.show(),t.options.axis=l}}else t.hide()},onRemove:function(){this.resetHandles()}},{SegmentHandle:o}),a=e.extend({tagName:"path",xAxisVector:new g.Point(1,0),events:{mousedown:"onPointerDown",touchstart:"onPointerDown"},documentEvents:{mousemove:"onPointerMove",touchmove:"onPointerMove",mouseup:"onPointerUp",touchend:"onPointerUp",touchcancel:"onPointerUp"},onRender:function(){this.update()},update:function(){var t,e,i=this.ratio,n=this.relatedView,r=n.getTangentAtRatio(i);e=r?(t=r.start,r.vector().vectorAngle(this.xAxisVector)||0):(t=n.getPointAtRatio(i),0);var o=l.createSVGMatrix().translate(t.x,t.y).rotate(e);return this.vel.transform(o,{absolute:!0}),this},onPointerDown:function(t){t.stopPropagation(),t.preventDefault();var e=this.relatedView;e.model.startBatch("arrowhead-move",{ui:!0,tool:this.cid}),e.can("arrowheadMove")&&(e.startArrowheadMove(this.arrowheadType),this.delegateDocumentEvents(),e.paper.undelegateEvents()),this.focus(),this.el.style.pointerEvents="none"},onPointerMove:function(t){var e=E.normalizeEvent(t),i=this.paper.snapToGrid(e.clientX,e.clientY);this.relatedView.pointermove(e,i.x,i.y)},onPointerUp:function(t){this.undelegateDocumentEvents();var e=this.relatedView,i=e.paper,n=E.normalizeEvent(t),r=i.snapToGrid(n.clientX,n.clientY);e.pointerup(n,r.x,r.y),i.delegateEvents(),this.blur(),this.el.style.pointerEvents="",e.model.stopBatch("arrowhead-move",{ui:!0,tool:this.cid})}}),h=a.extend({name:"target-arrowhead",ratio:1,arrowheadType:"target",attributes:{d:"M -10 -8 10 0 -10 8 Z",fill:"#33334F",stroke:"#FFFFFF","stroke-width":2,cursor:"move",class:"target-arrowhead"}}),u=a.extend({name:"source-arrowhead",ratio:0,arrowheadType:"source",attributes:{d:"M 10 -8 -10 0 10 8 Z",fill:"#33334F",stroke:"#FFFFFF","stroke-width":2,cursor:"move",class:"source-arrowhead"}}),c=e.extend({name:"button",events:{mousedown:"onPointerDown",touchstart:"onPointerDown"},options:{distance:0,offset:0,rotate:!1},onRender:function(){this.renderChildren(this.options.markup),this.update()},update:function(){var t,e,i,n=this.options.distance||0;i=(t=E.isPercentage(n)?this.relatedView.getTangentAtRatio(parseFloat(n)/100):this.relatedView.getTangentAtLength(n))?(e=t.start,t.vector().vectorAngle(new g.Point(1,0))||0):(e=this.relatedView.getConnection().start,0);var r=l.createSVGMatrix().translate(e.x,e.y).rotate(i).translate(0,this.options.offset||0);return this.options.rotate||(r=r.rotate(-i)),this.vel.transform(r,{absolute:!0}),this},onPointerDown:function(t){t.stopPropagation(),t.preventDefault();var e=this.options.action;"function"==typeof e&&e.call(this.relatedView,t,this.relatedView)}}),d=c.extend({children:[{tagName:"circle",selector:"button",attributes:{r:7,fill:"#FF1D00",cursor:"pointer"}},{tagName:"path",selector:"icon",attributes:{d:"M -3 -3 3 3 M -3 3 3 -3",fill:"none",stroke:"#FFFFFF","stroke-width":2,"pointer-events":"none"}}],options:{distance:60,offset:0,action:function(t){this.model.remove({ui:!0,tool:this.cid})}}}),f=e.extend({name:"boundary",tagName:"rect",options:{padding:10},attributes:{fill:"none",stroke:"#33334F","stroke-width":.5,"stroke-dasharray":"5, 5","pointer-events":"none"},onRender:function(){this.update()},update:function(){var t=this.options.padding;isFinite(t)||(t=0);var e=this.relatedView.getConnection().bbox().inflate(t);return this.vel.attr(e.toJSON()),this}}),p=e.extend({tagName:"g",type:null,children:[{tagName:"circle",selector:"anchor",attributes:{cursor:"pointer"}},{tagName:"rect",selector:"area",attributes:{"pointer-events":"none",fill:"none",stroke:"#33334F","stroke-dasharray":"2,4",rx:5,ry:5}}],events:{mousedown:"onPointerDown",touchstart:"onPointerDown",dblclick:"onPointerDblClick"},documentEvents:{mousemove:"onPointerMove",touchmove:"onPointerMove",mouseup:"onPointerUp",touchend:"onPointerUp",touchcancel:"onPointerUp"},options:{snap:function(t,e,i,n,r,o){var s=o.options.snapRadius,a="source"===n,l=a?0:-1,h=this.model.vertex(l)||this.getEndAnchor(a?"target":"source");return h&&(Math.abs(h.x-t.x)<s&&(t.x=h.x),Math.abs(h.y-t.y)<s&&(t.y=h.y)),t},anchor:t,customAnchorAttributes:{"stroke-width":4,stroke:"#33334F",fill:"#FFFFFF",r:5},defaultAnchorAttributes:{"stroke-width":2,stroke:"#FFFFFF",fill:"#33334F",r:6},areaPadding:6,snapRadius:10,restrictArea:!0,redundancyRemoval:!0},onRender:function(){this.renderChildren(),this.toggleArea(!1),this.update()},update:function(){var t=this.type,e=this.relatedView.getEndView(t);return this.el.style.display=e?(this.updateAnchor(),this.updateArea(),""):"none",this},updateAnchor:function(){var t=this.childNodes;if(t){var e=t.anchor;if(e){var i=this.relatedView,n=this.type,r=i.getEndAnchor(n),o=this.options,s=i.model.prop([n,"anchor"]);e.setAttribute("transform","translate("+r.x+","+r.y+")");var a=s?o.customAnchorAttributes:o.defaultAnchorAttributes;for(var l in a)e.setAttribute(l,a[l])}}},updateArea:function(){var t=this.childNodes;if(t){var e=t.area;if(e){var i=this.relatedView,n=this.type,r=i.getEndView(n),o=i.getEndMagnet(n),s=this.options.areaPadding;isFinite(s)||(s=0);var a=r.getNodeUnrotatedBBox(o).inflate(s),l=r.model.angle();e.setAttribute("x",-a.width/2),e.setAttribute("y",-a.height/2),e.setAttribute("width",a.width),e.setAttribute("height",a.height);var h=r.model.getBBox().center(),u=a.center().rotate(h,-l);e.setAttribute("transform","translate("+u.x+","+u.y+") rotate("+l+")")}}},toggleArea:function(t){this.childNodes.area.style.display=t?"":"none"},onPointerDown:function(t){t.stopPropagation(),t.preventDefault(),this.paper.undelegateEvents(),this.delegateDocumentEvents(),this.focus(),this.toggleArea(this.options.restrictArea),this.relatedView.model.startBatch("anchor-move",{ui:!0,tool:this.cid})},resetAnchor:function(t){var e=this.type,i=this.relatedView.model;t?i.prop([e,"anchor"],t,{rewrite:!0,ui:!0,tool:this.cid}):i.removeProp([e,"anchor"],{ui:!0,tool:this.cid})},onPointerMove:function(t){var e,i=this.relatedView,n=this.type,r=i.getEndView(n),o=i.getEndMagnet(n),s=E.normalizeEvent(t),a=this.paper.clientToLocalPoint(s.clientX,s.clientY),l=this.options.snap;if("function"==typeof l&&(a=l.call(i,a,r,o,n,i,this),a=new g.Point(a)),this.options.restrictArea){var h=r.getNodeUnrotatedBBox(o),u=r.model.angle(),c=r.model.getBBox().center(),d=a.clone().rotate(c,u);h.containsPoint(d)||(a=h.pointNearestToPoint(d).rotate(c,-u))}var f=this.options.anchor;"function"==typeof f&&(e=f.call(i,a,r,o,n,i)),this.resetAnchor(e),this.update()},onPointerUp:function(t){this.paper.delegateEvents(),this.undelegateDocumentEvents(),this.blur(),this.toggleArea(!1);var e=this.relatedView;this.options.redundancyRemoval&&e.removeRedundantLinearVertices({ui:!0,tool:this.cid}),e.model.stopBatch("anchor-move",{ui:!0,tool:this.cid})},onPointerDblClick:function(){this.resetAnchor(),this.update()}}),m=p.extend({name:"source-anchor",type:"source"}),v=p.extend({name:"target-anchor",type:"target"});n.linkTools={Vertices:r,Segments:s,SourceArrowhead:u,TargetArrowhead:h,SourceAnchor:m,TargetAnchor:v,Button:c,Remove:d,Boundary:f}}(joint,joint.util,V,g);
joint.dia.Element.define("erd.Entity",{size:{width:150,height:60},attrs:{".outer":{fill:"#2ECC71",stroke:"#27AE60","stroke-width":2,points:"100,0 100,60 0,60 0,0"},".inner":{fill:"#2ECC71",stroke:"#27AE60","stroke-width":2,points:"95,5 95,55 5,55 5,5",display:"none"},text:{text:"Entity","font-family":"Arial","font-size":14,"ref-x":.5,"ref-y":.5,"y-alignment":"middle","text-anchor":"middle"}}},{markup:'<g class="rotatable"><g class="scalable"><polygon class="outer"/><polygon class="inner"/></g><text/></g>'}),joint.shapes.erd.Entity.define("erd.WeakEntity",{attrs:{".inner":{display:"auto"},text:{text:"Weak Entity"}}}),joint.dia.Element.define("erd.Relationship",{size:{width:80,height:80},attrs:{".outer":{fill:"#3498DB",stroke:"#2980B9","stroke-width":2,points:"40,0 80,40 40,80 0,40"},".inner":{fill:"#3498DB",stroke:"#2980B9","stroke-width":2,points:"40,5 75,40 40,75 5,40",display:"none"},text:{text:"Relationship","font-family":"Arial","font-size":12,"ref-x":.5,"ref-y":.5,"y-alignment":"middle","text-anchor":"middle"}}},{markup:'<g class="rotatable"><g class="scalable"><polygon class="outer"/><polygon class="inner"/></g><text/></g>'}),joint.shapes.erd.Relationship.define("erd.IdentifyingRelationship",{attrs:{".inner":{display:"auto"},text:{text:"Identifying"}}}),joint.dia.Element.define("erd.Attribute",{size:{width:100,height:50},attrs:{ellipse:{transform:"translate(50, 25)"},".outer":{stroke:"#D35400","stroke-width":2,cx:0,cy:0,rx:50,ry:25,fill:"#E67E22"},".inner":{stroke:"#D35400","stroke-width":2,cx:0,cy:0,rx:45,ry:20,fill:"#E67E22",display:"none"},text:{"font-family":"Arial","font-size":14,"ref-x":.5,"ref-y":.5,"y-alignment":"middle","text-anchor":"middle"}}},{markup:'<g class="rotatable"><g class="scalable"><ellipse class="outer"/><ellipse class="inner"/></g><text/></g>'}),joint.shapes.erd.Attribute.define("erd.Multivalued",{attrs:{".inner":{display:"block"},text:{text:"multivalued"}}}),joint.shapes.erd.Attribute.define("erd.Derived",{attrs:{".outer":{"stroke-dasharray":"3,5"},text:{text:"derived"}}}),joint.shapes.erd.Attribute.define("erd.Key",{attrs:{ellipse:{"stroke-width":4},text:{text:"key","font-weight":"800","text-decoration":"underline"}}}),joint.shapes.erd.Attribute.define("erd.Normal",{attrs:{text:{text:"Normal"}}}),joint.dia.Element.define("erd.ISA",{type:"erd.ISA",size:{width:100,height:50},attrs:{polygon:{points:"0,0 50,50 100,0",fill:"#F1C40F",stroke:"#F39C12","stroke-width":2},text:{text:"ISA","font-size":18,"ref-x":.5,"ref-y":.3,"y-alignment":"middle","text-anchor":"middle"}}},{markup:'<g class="rotatable"><g class="scalable"><polygon/></g><text/></g>'}),joint.dia.Link.define("erd.Line",{},{cardinality:function(t){this.set("labels",[{position:-20,attrs:{text:{dy:-8,text:t}}}])}});
joint.shapes.basic.Circle.define("fsa.State",{attrs:{circle:{"stroke-width":3},text:{"font-weight":"800"}}}),joint.dia.Element.define("fsa.StartState",{size:{width:20,height:20},attrs:{circle:{transform:"translate(10, 10)",r:10,fill:"#000000"}}},{markup:'<g class="rotatable"><g class="scalable"><circle/></g></g>'}),joint.dia.Element.define("fsa.EndState",{size:{width:20,height:20},attrs:{".outer":{transform:"translate(10, 10)",r:10,fill:"#ffffff",stroke:"#000000"},".inner":{transform:"translate(10, 10)",r:6,fill:"#000000"}}},{markup:'<g class="rotatable"><g class="scalable"><circle class="outer"/><circle class="inner"/></g></g>'}),joint.dia.Link.define("fsa.Arrow",{attrs:{".marker-target":{d:"M 10 0 L 0 5 L 10 10 z"}},smooth:!0});
joint.dia.Element.define("org.Member",{size:{width:180,height:70},attrs:{rect:{width:170,height:60},".card":{fill:"#FFFFFF",stroke:"#000000","stroke-width":2,"pointer-events":"visiblePainted",rx:10,ry:10},image:{width:48,height:48,ref:".card","ref-x":10,"ref-y":5},".rank":{"text-decoration":"underline",ref:".card","ref-x":.9,"ref-y":.2,"font-family":"Courier New","font-size":14,"text-anchor":"end"},".name":{"font-weight":"800",ref:".card","ref-x":.9,"ref-y":.6,"font-family":"Courier New","font-size":14,"text-anchor":"end"}}},{markup:'<g class="rotatable"><g class="scalable"><rect class="card"/><image/></g><text class="rank"/><text class="name"/></g>'}),joint.dia.Link.define("org.Arrow",{source:{selector:".card"},target:{selector:".card"},attrs:{".connection":{stroke:"#585858","stroke-width":3}},z:-1});
joint.shapes.basic.Generic.define("chess.KingWhite",{size:{width:42,height:38}},{markup:'<g class="rotatable"><g class="scalable"><g style="fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;"><path      d="M 22.5,11.63 L 22.5,6"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />    <path      d="M 20,8 L 25,8"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />    <path      d="M 22.5,25 C 22.5,25 27,17.5 25.5,14.5 C 25.5,14.5 24.5,12 22.5,12 C 20.5,12 19.5,14.5 19.5,14.5 C 18,17.5 22.5,25 22.5,25"      style="fill:#ffffff; stroke:#000000; stroke-linecap:butt; stroke-linejoin:miter;" />    <path      d="M 11.5,37 C 17,40.5 27,40.5 32.5,37 L 32.5,30 C 32.5,30 41.5,25.5 38.5,19.5 C 34.5,13 25,16 22.5,23.5 L 22.5,27 L 22.5,23.5 C 19,16 9.5,13 6.5,19.5 C 3.5,25.5 11.5,29.5 11.5,29.5 L 11.5,37 z "      style="fill:#ffffff; stroke:#000000;" />    <path      d="M 11.5,30 C 17,27 27,27 32.5,30"      style="fill:none; stroke:#000000;" />    <path      d="M 11.5,33.5 C 17,30.5 27,30.5 32.5,33.5"      style="fill:none; stroke:#000000;" />    <path      d="M 11.5,37 C 17,34 27,34 32.5,37"      style="fill:none; stroke:#000000;" />  </g></g></g>'}),joint.shapes.basic.Generic.define("chess.KingBlack",{size:{width:42,height:38}},{markup:'<g class="rotatable"><g class="scalable"><g style="fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path       d="M 22.5,11.63 L 22.5,6"       style="fill:none; stroke:#000000; stroke-linejoin:miter;"       id="path6570" />    <path       d="M 22.5,25 C 22.5,25 27,17.5 25.5,14.5 C 25.5,14.5 24.5,12 22.5,12 C 20.5,12 19.5,14.5 19.5,14.5 C 18,17.5 22.5,25 22.5,25"       style="fill:#000000;fill-opacity:1; stroke-linecap:butt; stroke-linejoin:miter;" />    <path       d="M 11.5,37 C 17,40.5 27,40.5 32.5,37 L 32.5,30 C 32.5,30 41.5,25.5 38.5,19.5 C 34.5,13 25,16 22.5,23.5 L 22.5,27 L 22.5,23.5 C 19,16 9.5,13 6.5,19.5 C 3.5,25.5 11.5,29.5 11.5,29.5 L 11.5,37 z "       style="fill:#000000; stroke:#000000;" />    <path       d="M 20,8 L 25,8"       style="fill:none; stroke:#000000; stroke-linejoin:miter;" />    <path       d="M 32,29.5 C 32,29.5 40.5,25.5 38.03,19.85 C 34.15,14 25,18 22.5,24.5 L 22.51,26.6 L 22.5,24.5 C 20,18 9.906,14 6.997,19.85 C 4.5,25.5 11.85,28.85 11.85,28.85"       style="fill:none; stroke:#ffffff;" />    <path       d="M 11.5,30 C 17,27 27,27 32.5,30 M 11.5,33.5 C 17,30.5 27,30.5 32.5,33.5 M 11.5,37 C 17,34 27,34 32.5,37"       style="fill:none; stroke:#ffffff;" />  </g></g></g>'}),joint.shapes.basic.Generic.define("chess.QueenWhite",{size:{width:42,height:38}},{markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#ffffff; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(-1,-1)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(15.5,-5.5)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(32,-1)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(7,-4.5)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(24,-4)" />    <path      d="M 9,26 C 17.5,24.5 30,24.5 36,26 L 38,14 L 31,25 L 31,11 L 25.5,24.5 L 22.5,9.5 L 19.5,24.5 L 14,10.5 L 14,25 L 7,14 L 9,26 z "      style="stroke-linecap:butt;" />    <path      d="M 9,26 C 9,28 10.5,28 11.5,30 C 12.5,31.5 12.5,31 12,33.5 C 10.5,34.5 10.5,36 10.5,36 C 9,37.5 11,38.5 11,38.5 C 17.5,39.5 27.5,39.5 34,38.5 C 34,38.5 35.5,37.5 34,36 C 34,36 34.5,34.5 33,33.5 C 32.5,31 32.5,31.5 33.5,30 C 34.5,28 36,28 36,26 C 27.5,24.5 17.5,24.5 9,26 z "      style="stroke-linecap:butt;" />    <path      d="M 11.5,30 C 15,29 30,29 33.5,30"      style="fill:none;" />    <path      d="M 12,33.5 C 18,32.5 27,32.5 33,33.5"      style="fill:none;" />  </g></g></g>'}),joint.shapes.basic.Generic.define("chess.QueenBlack",{size:{width:42,height:38}},{markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#000000; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <g style="fill:#000000; stroke:none;">      <circle cx="6"    cy="12" r="2.75" />      <circle cx="14"   cy="9"  r="2.75" />      <circle cx="22.5" cy="8"  r="2.75" />      <circle cx="31"   cy="9"  r="2.75" />      <circle cx="39"   cy="12" r="2.75" />    </g>    <path       d="M 9,26 C 17.5,24.5 30,24.5 36,26 L 38.5,13.5 L 31,25 L 30.7,10.9 L 25.5,24.5 L 22.5,10 L 19.5,24.5 L 14.3,10.9 L 14,25 L 6.5,13.5 L 9,26 z"       style="stroke-linecap:butt; stroke:#000000;" />    <path       d="M 9,26 C 9,28 10.5,28 11.5,30 C 12.5,31.5 12.5,31 12,33.5 C 10.5,34.5 10.5,36 10.5,36 C 9,37.5 11,38.5 11,38.5 C 17.5,39.5 27.5,39.5 34,38.5 C 34,38.5 35.5,37.5 34,36 C 34,36 34.5,34.5 33,33.5 C 32.5,31 32.5,31.5 33.5,30 C 34.5,28 36,28 36,26 C 27.5,24.5 17.5,24.5 9,26 z"       style="stroke-linecap:butt;" />    <path       d="M 11,38.5 A 35,35 1 0 0 34,38.5"       style="fill:none; stroke:#000000; stroke-linecap:butt;" />    <path       d="M 11,29 A 35,35 1 0 1 34,29"       style="fill:none; stroke:#ffffff;" />    <path       d="M 12.5,31.5 L 32.5,31.5"       style="fill:none; stroke:#ffffff;" />    <path       d="M 11.5,34.5 A 35,35 1 0 0 33.5,34.5"       style="fill:none; stroke:#ffffff;" />    <path       d="M 10.5,37.5 A 35,35 1 0 0 34.5,37.5"       style="fill:none; stroke:#ffffff;" />  </g></g></g>'}),joint.shapes.basic.Generic.define("chess.RookWhite",{size:{width:32,height:34}},{markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#ffffff; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 9,39 L 36,39 L 36,36 L 9,36 L 9,39 z "      style="stroke-linecap:butt;" />    <path      d="M 12,36 L 12,32 L 33,32 L 33,36 L 12,36 z "      style="stroke-linecap:butt;" />    <path      d="M 11,14 L 11,9 L 15,9 L 15,11 L 20,11 L 20,9 L 25,9 L 25,11 L 30,11 L 30,9 L 34,9 L 34,14"      style="stroke-linecap:butt;" />    <path      d="M 34,14 L 31,17 L 14,17 L 11,14" />    <path      d="M 31,17 L 31,29.5 L 14,29.5 L 14,17"      style="stroke-linecap:butt; stroke-linejoin:miter;" />    <path      d="M 31,29.5 L 32.5,32 L 12.5,32 L 14,29.5" />    <path      d="M 11,14 L 34,14"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />  </g></g></g>'}),joint.shapes.basic.Generic.define("chess.RookBlack",{size:{width:32,height:34}},{markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#000000; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 9,39 L 36,39 L 36,36 L 9,36 L 9,39 z "      style="stroke-linecap:butt;" />    <path      d="M 12.5,32 L 14,29.5 L 31,29.5 L 32.5,32 L 12.5,32 z "      style="stroke-linecap:butt;" />    <path      d="M 12,36 L 12,32 L 33,32 L 33,36 L 12,36 z "      style="stroke-linecap:butt;" />    <path      d="M 14,29.5 L 14,16.5 L 31,16.5 L 31,29.5 L 14,29.5 z "      style="stroke-linecap:butt;stroke-linejoin:miter;" />    <path      d="M 14,16.5 L 11,14 L 34,14 L 31,16.5 L 14,16.5 z "      style="stroke-linecap:butt;" />    <path      d="M 11,14 L 11,9 L 15,9 L 15,11 L 20,11 L 20,9 L 25,9 L 25,11 L 30,11 L 30,9 L 34,9 L 34,14 L 11,14 z "      style="stroke-linecap:butt;" />    <path      d="M 12,35.5 L 33,35.5 L 33,35.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 13,31.5 L 32,31.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 14,29.5 L 31,29.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 14,16.5 L 31,16.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 11,14 L 34,14"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />  </g></g></g>'}),joint.shapes.basic.Generic.define("chess.BishopWhite",{size:{width:38,height:38}},{markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-rule:evenodd; fill-opacity:1; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:round; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <g style="fill:#ffffff; stroke:#000000; stroke-linecap:butt;">       <path        d="M 9,36 C 12.39,35.03 19.11,36.43 22.5,34 C 25.89,36.43 32.61,35.03 36,36 C 36,36 37.65,36.54 39,38 C 38.32,38.97 37.35,38.99 36,38.5 C 32.61,37.53 25.89,38.96 22.5,37.5 C 19.11,38.96 12.39,37.53 9,38.5 C 7.646,38.99 6.677,38.97 6,38 C 7.354,36.06 9,36 9,36 z" />      <path        d="M 15,32 C 17.5,34.5 27.5,34.5 30,32 C 30.5,30.5 30,30 30,30 C 30,27.5 27.5,26 27.5,26 C 33,24.5 33.5,14.5 22.5,10.5 C 11.5,14.5 12,24.5 17.5,26 C 17.5,26 15,27.5 15,30 C 15,30 14.5,30.5 15,32 z" />      <path        d="M 25 8 A 2.5 2.5 0 1 1  20,8 A 2.5 2.5 0 1 1  25 8 z" />    </g>    <path      d="M 17.5,26 L 27.5,26 M 15,30 L 30,30 M 22.5,15.5 L 22.5,20.5 M 20,18 L 25,18"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />  </g></g></g>'}),joint.shapes.basic.Generic.define("chess.BishopBlack",{size:{width:38,height:38}},{markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-rule:evenodd; fill-opacity:1; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:round; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <g style="fill:#000000; stroke:#000000; stroke-linecap:butt;">       <path        d="M 9,36 C 12.39,35.03 19.11,36.43 22.5,34 C 25.89,36.43 32.61,35.03 36,36 C 36,36 37.65,36.54 39,38 C 38.32,38.97 37.35,38.99 36,38.5 C 32.61,37.53 25.89,38.96 22.5,37.5 C 19.11,38.96 12.39,37.53 9,38.5 C 7.646,38.99 6.677,38.97 6,38 C 7.354,36.06 9,36 9,36 z" />      <path        d="M 15,32 C 17.5,34.5 27.5,34.5 30,32 C 30.5,30.5 30,30 30,30 C 30,27.5 27.5,26 27.5,26 C 33,24.5 33.5,14.5 22.5,10.5 C 11.5,14.5 12,24.5 17.5,26 C 17.5,26 15,27.5 15,30 C 15,30 14.5,30.5 15,32 z" />      <path        d="M 25 8 A 2.5 2.5 0 1 1  20,8 A 2.5 2.5 0 1 1  25 8 z" />    </g>    <path       d="M 17.5,26 L 27.5,26 M 15,30 L 30,30 M 22.5,15.5 L 22.5,20.5 M 20,18 L 25,18"       style="fill:none; stroke:#ffffff; stroke-linejoin:miter;" />  </g></g></g>'}),joint.shapes.basic.Generic.define("chess.KnightWhite",{size:{width:38,height:37}},{markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 22,10 C 32.5,11 38.5,18 38,39 L 15,39 C 15,30 25,32.5 23,18"      style="fill:#ffffff; stroke:#000000;" />    <path      d="M 24,18 C 24.38,20.91 18.45,25.37 16,27 C 13,29 13.18,31.34 11,31 C 9.958,30.06 12.41,27.96 11,28 C 10,28 11.19,29.23 10,30 C 9,30 5.997,31 6,26 C 6,24 12,14 12,14 C 12,14 13.89,12.1 14,10.5 C 13.27,9.506 13.5,8.5 13.5,7.5 C 14.5,6.5 16.5,10 16.5,10 L 18.5,10 C 18.5,10 19.28,8.008 21,7 C 22,7 22,10 22,10"      style="fill:#ffffff; stroke:#000000;" />    <path      d="M 9.5 25.5 A 0.5 0.5 0 1 1 8.5,25.5 A 0.5 0.5 0 1 1 9.5 25.5 z"      style="fill:#000000; stroke:#000000;" />    <path      d="M 15 15.5 A 0.5 1.5 0 1 1  14,15.5 A 0.5 1.5 0 1 1  15 15.5 z"      transform="matrix(0.866,0.5,-0.5,0.866,9.693,-5.173)"      style="fill:#000000; stroke:#000000;" />  </g></g></g>'}),joint.shapes.basic.Generic.define("chess.KnightBlack",{size:{width:38,height:37}},{markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 22,10 C 32.5,11 38.5,18 38,39 L 15,39 C 15,30 25,32.5 23,18"      style="fill:#000000; stroke:#000000;" />    <path      d="M 24,18 C 24.38,20.91 18.45,25.37 16,27 C 13,29 13.18,31.34 11,31 C 9.958,30.06 12.41,27.96 11,28 C 10,28 11.19,29.23 10,30 C 9,30 5.997,31 6,26 C 6,24 12,14 12,14 C 12,14 13.89,12.1 14,10.5 C 13.27,9.506 13.5,8.5 13.5,7.5 C 14.5,6.5 16.5,10 16.5,10 L 18.5,10 C 18.5,10 19.28,8.008 21,7 C 22,7 22,10 22,10"      style="fill:#000000; stroke:#000000;" />    <path      d="M 9.5 25.5 A 0.5 0.5 0 1 1 8.5,25.5 A 0.5 0.5 0 1 1 9.5 25.5 z"      style="fill:#ffffff; stroke:#ffffff;" />    <path      d="M 15 15.5 A 0.5 1.5 0 1 1  14,15.5 A 0.5 1.5 0 1 1  15 15.5 z"      transform="matrix(0.866,0.5,-0.5,0.866,9.693,-5.173)"      style="fill:#ffffff; stroke:#ffffff;" />    <path      d="M 24.55,10.4 L 24.1,11.85 L 24.6,12 C 27.75,13 30.25,14.49 32.5,18.75 C 34.75,23.01 35.75,29.06 35.25,39 L 35.2,39.5 L 37.45,39.5 L 37.5,39 C 38,28.94 36.62,22.15 34.25,17.66 C 31.88,13.17 28.46,11.02 25.06,10.5 L 24.55,10.4 z "      style="fill:#ffffff; stroke:none;" />  </g></g></g>'}),joint.shapes.basic.Generic.define("chess.PawnWhite",{size:{width:28,height:33}},{markup:'<g class="rotatable"><g class="scalable"><path d="M 22,9 C 19.79,9 18,10.79 18,13 C 18,13.89 18.29,14.71 18.78,15.38 C 16.83,16.5 15.5,18.59 15.5,21 C 15.5,23.03 16.44,24.84 17.91,26.03 C 14.91,27.09 10.5,31.58 10.5,39.5 L 33.5,39.5 C 33.5,31.58 29.09,27.09 26.09,26.03 C 27.56,24.84 28.5,23.03 28.5,21 C 28.5,18.59 27.17,16.5 25.22,15.38 C 25.71,14.71 26,13.89 26,13 C 26,10.79 24.21,9 22,9 z "  style="opacity:1; fill:#ffffff; fill-opacity:1; fill-rule:nonzero; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:miter; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;" /></g></g>'}),joint.shapes.basic.Generic.define("chess.PawnBlack",{size:{width:28,height:33}},{markup:'<g class="rotatable"><g class="scalable"><path d="M 22,9 C 19.79,9 18,10.79 18,13 C 18,13.89 18.29,14.71 18.78,15.38 C 16.83,16.5 15.5,18.59 15.5,21 C 15.5,23.03 16.44,24.84 17.91,26.03 C 14.91,27.09 10.5,31.58 10.5,39.5 L 33.5,39.5 C 33.5,31.58 29.09,27.09 26.09,26.03 C 27.56,24.84 28.5,23.03 28.5,21 C 28.5,18.59 27.17,16.5 25.22,15.38 C 25.71,14.71 26,13.89 26,13 C 26,10.79 24.21,9 22,9 z "  style="opacity:1; fill:#000000; fill-opacity:1; fill-rule:nonzero; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:miter; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;" /></g></g>'});
joint.shapes.basic.Generic.define("pn.Place",{size:{width:50,height:50},attrs:{".root":{r:25,fill:"#ffffff",stroke:"#000000",transform:"translate(25, 25)"},".label":{"text-anchor":"middle","ref-x":.5,"ref-y":-20,ref:".root",fill:"#000000","font-size":12},".tokens > circle":{fill:"#000000",r:5},".tokens.one > circle":{transform:"translate(25, 25)"},".tokens.two > circle:nth-child(1)":{transform:"translate(19, 25)"},".tokens.two > circle:nth-child(2)":{transform:"translate(31, 25)"},".tokens.three > circle:nth-child(1)":{transform:"translate(18, 29)"},".tokens.three > circle:nth-child(2)":{transform:"translate(25, 19)"},".tokens.three > circle:nth-child(3)":{transform:"translate(32, 29)"},".tokens.alot > text":{transform:"translate(25, 18)","text-anchor":"middle",fill:"#000000"}}},{markup:'<g class="rotatable"><g class="scalable"><circle class="root"/><g class="tokens" /></g><text class="label"/></g>'}),joint.shapes.pn.PlaceView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),this.model.on("change:tokens",function(){this.renderTokens(),this.update()},this)},render:function(){joint.dia.ElementView.prototype.render.apply(this,arguments),this.renderTokens(),this.update()},renderTokens:function(){var e=this.$(".tokens").empty();e[0].className.baseVal="tokens";var t=this.model.get("tokens");if(t)switch(t){case 1:e[0].className.baseVal+=" one",e.append(V("<circle/>").node);break;case 2:e[0].className.baseVal+=" two",e.append(V("<circle/>").node,V("<circle/>").node);break;case 3:e[0].className.baseVal+=" three",e.append(V("<circle/>").node,V("<circle/>").node,V("<circle/>").node);break;default:e[0].className.baseVal+=" alot",e.append(V("<text/>").text(t+"").node)}}}),joint.shapes.basic.Generic.define("pn.Transition",{size:{width:12,height:50},attrs:{rect:{width:12,height:50,fill:"#000000",stroke:"#000000"},".label":{"text-anchor":"middle","ref-x":.5,"ref-y":-20,ref:"rect",fill:"#000000","font-size":12}}},{markup:'<g class="rotatable"><g class="scalable"><rect class="root"/></g></g><text class="label"/>'}),joint.dia.Link.define("pn.Link",{attrs:{".marker-target":{d:"M 10 0 L 0 5 L 10 10 z"}}});
joint.shapes.basic.Generic.define("devs.Model",{inPorts:[],outPorts:[],size:{width:80,height:80},attrs:{".":{magnet:!1},".label":{text:"Model","ref-x":.5,"ref-y":10,"font-size":18,"text-anchor":"middle",fill:"#000"},".body":{"ref-width":"100%","ref-height":"100%",stroke:"#000"}},ports:{groups:{in:{position:{name:"left"},attrs:{".port-label":{fill:"#000"},".port-body":{fill:"#fff",stroke:"#000",r:10,magnet:!0}},label:{position:{name:"left",args:{y:10}}}},out:{position:{name:"right"},attrs:{".port-label":{fill:"#000"},".port-body":{fill:"#fff",stroke:"#000",r:10,magnet:!0}},label:{position:{name:"right",args:{y:10}}}}}}},{markup:'<g class="rotatable"><rect class="body"/><text class="label"/></g>',portMarkup:'<circle class="port-body"/>',portLabelMarkup:'<text class="port-label"/>',initialize:function(){joint.shapes.basic.Generic.prototype.initialize.apply(this,arguments),this.on("change:inPorts change:outPorts",this.updatePortItems,this),this.updatePortItems()},updatePortItems:function(t,e,o){var r=joint.util.uniq(this.get("inPorts")),i=joint.util.difference(joint.util.uniq(this.get("outPorts")),r),n=this.createPortItems("in",r),s=this.createPortItems("out",i);this.prop("ports/items",n.concat(s),joint.util.assign({rewrite:!0},o))},createPortItem:function(t,e){return{id:e,group:t,attrs:{".port-label":{text:e}}}},createPortItems:function(t,e){return joint.util.toArray(e).map(this.createPortItem.bind(this,t))},_addGroupPort:function(t,e,o){var r=this.get(e);return this.set(e,Array.isArray(r)?r.concat(t):[t],o)},addOutPort:function(t,e){return this._addGroupPort(t,"outPorts",e)},addInPort:function(t,e){return this._addGroupPort(t,"inPorts",e)},_removeGroupPort:function(t,e,o){return this.set(e,joint.util.without(this.get(e),t),o)},removeOutPort:function(t,e){return this._removeGroupPort(t,"outPorts",e)},removeInPort:function(t,e){return this._removeGroupPort(t,"inPorts",e)},_changeGroup:function(t,e,o){return this.prop("ports/groups/"+t,joint.util.isObject(e)?e:{},o)},changeInGroup:function(t,e){return this._changeGroup("in",t,e)},changeOutGroup:function(t,e){return this._changeGroup("out",t,e)}}),joint.shapes.devs.Model.define("devs.Atomic",{size:{width:80,height:80},attrs:{".label":{text:"Atomic"}}}),joint.shapes.devs.Model.define("devs.Coupled",{size:{width:200,height:300},attrs:{".label":{text:"Coupled"}}}),joint.dia.Link.define("devs.Link",{attrs:{".connection":{"stroke-width":2}}});
joint.shapes.basic.Generic.define("uml.Class",{attrs:{rect:{width:200},".uml-class-name-rect":{stroke:"black","stroke-width":2,fill:"#3498db"},".uml-class-attrs-rect":{stroke:"black","stroke-width":2,fill:"#2980b9"},".uml-class-methods-rect":{stroke:"black","stroke-width":2,fill:"#2980b9"},".uml-class-name-text":{ref:".uml-class-name-rect","ref-y":.5,"ref-x":.5,"text-anchor":"middle","y-alignment":"middle","font-weight":"bold",fill:"black","font-size":12,"font-family":"Times New Roman"},".uml-class-attrs-text":{ref:".uml-class-attrs-rect","ref-y":5,"ref-x":5,fill:"black","font-size":12,"font-family":"Times New Roman"},".uml-class-methods-text":{ref:".uml-class-methods-rect","ref-y":5,"ref-x":5,fill:"black","font-size":12,"font-family":"Times New Roman"}},name:[],attributes:[],methods:[]},{markup:['<g class="rotatable">','<g class="scalable">','<rect class="uml-class-name-rect"/><rect class="uml-class-attrs-rect"/><rect class="uml-class-methods-rect"/>',"</g>",'<text class="uml-class-name-text"/><text class="uml-class-attrs-text"/><text class="uml-class-methods-text"/>',"</g>"].join(""),initialize:function(){this.on("change:name change:attributes change:methods",function(){this.updateRectangles(),this.trigger("uml-update")},this),this.updateRectangles(),joint.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},getClassName:function(){return this.get("name")},updateRectangles:function(){var a=this.get("attrs"),t=[{type:"name",text:this.getClassName()},{type:"attrs",text:this.get("attributes")},{type:"methods",text:this.get("methods")}],i=0;t.forEach(function(t){var e=Array.isArray(t.text)?t.text:[t.text],s=20*e.length+20;a[".uml-class-"+t.type+"-text"].text=e.join("\n"),a[".uml-class-"+t.type+"-rect"].height=s,a[".uml-class-"+t.type+"-rect"].transform="translate(0,"+i+")",i+=s})}}),joint.shapes.uml.ClassView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),this.listenTo(this.model,"uml-update",function(){this.update(),this.resize()})}}),joint.shapes.uml.Class.define("uml.Abstract",{attrs:{".uml-class-name-rect":{fill:"#e74c3c"},".uml-class-attrs-rect":{fill:"#c0392b"},".uml-class-methods-rect":{fill:"#c0392b"}}},{getClassName:function(){return["<<Abstract>>",this.get("name")]}}),joint.shapes.uml.AbstractView=joint.shapes.uml.ClassView,joint.shapes.uml.Class.define("uml.Interface",{attrs:{".uml-class-name-rect":{fill:"#f1c40f"},".uml-class-attrs-rect":{fill:"#f39c12"},".uml-class-methods-rect":{fill:"#f39c12"}}},{getClassName:function(){return["<<Interface>>",this.get("name")]}}),joint.shapes.uml.InterfaceView=joint.shapes.uml.ClassView,joint.dia.Link.define("uml.Generalization",{attrs:{".marker-target":{d:"M 20 0 L 0 10 L 20 20 z",fill:"white"}}}),joint.dia.Link.define("uml.Implementation",{attrs:{".marker-target":{d:"M 20 0 L 0 10 L 20 20 z",fill:"white"},".connection":{"stroke-dasharray":"3,3"}}}),joint.dia.Link.define("uml.Aggregation",{attrs:{".marker-target":{d:"M 40 10 L 20 20 L 0 10 L 20 0 z",fill:"white"}}}),joint.dia.Link.define("uml.Composition",{attrs:{".marker-target":{d:"M 40 10 L 20 20 L 0 10 L 20 0 z",fill:"black"}}}),joint.dia.Link.define("uml.Association"),joint.shapes.basic.Generic.define("uml.State",{attrs:{".uml-state-body":{width:200,height:200,rx:10,ry:10,fill:"#ecf0f1",stroke:"#bdc3c7","stroke-width":3},".uml-state-separator":{stroke:"#bdc3c7","stroke-width":2},".uml-state-name":{ref:".uml-state-body","ref-x":.5,"ref-y":5,"text-anchor":"middle",fill:"#000000","font-family":"Courier New","font-size":14},".uml-state-events":{ref:".uml-state-separator","ref-x":5,"ref-y":5,fill:"#000000","font-family":"Courier New","font-size":14}},name:"State",events:[]},{markup:['<g class="rotatable">','<g class="scalable">','<rect class="uml-state-body"/>',"</g>",'<path class="uml-state-separator"/>','<text class="uml-state-name"/>','<text class="uml-state-events"/>',"</g>"].join(""),initialize:function(){this.on({"change:name":this.updateName,"change:events":this.updateEvents,"change:size":this.updatePath},this),this.updateName(),this.updateEvents(),this.updatePath(),joint.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},updateName:function(){this.attr(".uml-state-name/text",this.get("name"))},updateEvents:function(){this.attr(".uml-state-events/text",this.get("events").join("\n"))},updatePath:function(){var t="M 0 20 L "+this.get("size").width+" 20";this.attr(".uml-state-separator/d",t,{silent:!0})}}),joint.shapes.basic.Circle.define("uml.StartState",{type:"uml.StartState",attrs:{circle:{fill:"#34495e",stroke:"#2c3e50","stroke-width":2,rx:1}}}),joint.shapes.basic.Generic.define("uml.EndState",{size:{width:20,height:20},attrs:{"circle.outer":{transform:"translate(10, 10)",r:10,fill:"#ffffff",stroke:"#2c3e50"},"circle.inner":{transform:"translate(10, 10)",r:6,fill:"#34495e"}}},{markup:'<g class="rotatable"><g class="scalable"><circle class="outer"/><circle class="inner"/></g></g>'}),joint.dia.Link.define("uml.Transition",{attrs:{".marker-target":{d:"M 10 0 L 0 5 L 10 10 z",fill:"#34495e",stroke:"#2c3e50"},".connection":{stroke:"#2c3e50"}}});
joint.shapes.basic.Generic.define("logic.Gate",{size:{width:80,height:40},attrs:{".":{magnet:!1},".body":{width:100,height:50},circle:{r:7,stroke:"black",fill:"transparent","stroke-width":2}}},{operation:function(){return!0}}),joint.shapes.logic.Gate.define("logic.IO",{size:{width:60,height:30},attrs:{".body":{fill:"white",stroke:"black","stroke-width":2},".wire":{ref:".body","ref-y":.5,stroke:"black"},text:{fill:"black",ref:".body","ref-x":.5,"ref-y":.5,"y-alignment":"middle","text-anchor":"middle","font-weight":"bold","font-variant":"small-caps","text-transform":"capitalize","font-size":"14px"}}},{markup:'<g class="rotatable"><g class="scalable"><rect class="body"/></g><path class="wire"/><circle/><text/></g>'}),joint.shapes.logic.IO.define("logic.Input",{attrs:{".wire":{"ref-dx":0,d:"M 0 0 L 23 0"},circle:{ref:".body","ref-dx":30,"ref-y":.5,magnet:!0,class:"output",port:"out"},text:{text:"input"}}}),joint.shapes.logic.IO.define("logic.Output",{attrs:{".wire":{"ref-x":0,d:"M 0 0 L -23 0"},circle:{ref:".body","ref-x":-30,"ref-y":.5,magnet:"passive",class:"input",port:"in"},text:{text:"output"}}}),joint.shapes.logic.Gate.define("logic.Gate11",{attrs:{".input":{ref:".body","ref-x":-2,"ref-y":.5,magnet:"passive",port:"in"},".output":{ref:".body","ref-dx":2,"ref-y":.5,magnet:!0,port:"out"}}},{markup:'<g class="rotatable"><g class="scalable"><image class="body"/></g><circle class="input"/><circle class="output"/></g>'}),joint.shapes.logic.Gate.define("logic.Gate21",{attrs:{".input1":{ref:".body","ref-x":-2,"ref-y":.3,magnet:"passive",port:"in1"},".input2":{ref:".body","ref-x":-2,"ref-y":.7,magnet:"passive",port:"in2"},".output":{ref:".body","ref-dx":2,"ref-y":.5,magnet:!0,port:"out"}}},{markup:'<g class="rotatable"><g class="scalable"><image class="body"/></g><circle class="input input1"/><circle  class="input input2"/><circle class="output"/></g>'}),joint.shapes.logic.Gate11.define("logic.Repeater",{attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},{operation:function(I){return I}}),joint.shapes.logic.Gate11.define("logic.Not",{attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},{operation:function(I){return!I}}),joint.shapes.logic.Gate21.define("logic.Or",{attrs:{image:{"xlink:href":"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgo8c3ZnCiAgIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIKICAgeG1sbnM6Y2M9Imh0dHA6Ly9jcmVhdGl2ZWNvbW1vbnMub3JnL25zIyIKICAgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIgogICB4bWxuczpzdmc9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogICB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciCiAgIHhtbG5zOnNvZGlwb2RpPSJodHRwOi8vc29kaXBvZGkuc291cmNlZm9yZ2UubmV0L0RURC9zb2RpcG9kaS0wLmR0ZCIKICAgeG1sbnM6aW5rc2NhcGU9Imh0dHA6Ly93d3cuaW5rc2NhcGUub3JnL25hbWVzcGFjZXMvaW5rc2NhcGUiCiAgIHdpZHRoPSIxMDAiCiAgIGhlaWdodD0iNTAiCiAgIGlkPSJzdmcyIgogICBzb2RpcG9kaTp2ZXJzaW9uPSIwLjMyIgogICBpbmtzY2FwZTp2ZXJzaW9uPSIwLjQ2IgogICB2ZXJzaW9uPSIxLjAiCiAgIHNvZGlwb2RpOmRvY25hbWU9Ik9SIEFOU0kuc3ZnIgogICBpbmtzY2FwZTpvdXRwdXRfZXh0ZW5zaW9uPSJvcmcuaW5rc2NhcGUub3V0cHV0LnN2Zy5pbmtzY2FwZSI+CiAgPGRlZnMKICAgICBpZD0iZGVmczQiPgogICAgPGlua3NjYXBlOnBlcnNwZWN0aXZlCiAgICAgICBzb2RpcG9kaTp0eXBlPSJpbmtzY2FwZTpwZXJzcDNkIgogICAgICAgaW5rc2NhcGU6dnBfeD0iMCA6IDE1IDogMSIKICAgICAgIGlua3NjYXBlOnZwX3k9IjAgOiAxMDAwIDogMCIKICAgICAgIGlua3NjYXBlOnZwX3o9IjUwIDogMTUgOiAxIgogICAgICAgaW5rc2NhcGU6cGVyc3AzZC1vcmlnaW49IjI1IDogMTAgOiAxIgogICAgICAgaWQ9InBlcnNwZWN0aXZlMjcxNCIgLz4KICAgIDxpbmtzY2FwZTpwZXJzcGVjdGl2ZQogICAgICAgc29kaXBvZGk6dHlwZT0iaW5rc2NhcGU6cGVyc3AzZCIKICAgICAgIGlua3NjYXBlOnZwX3g9IjAgOiAwLjUgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfeT0iMCA6IDEwMDAgOiAwIgogICAgICAgaW5rc2NhcGU6dnBfej0iMSA6IDAuNSA6IDEiCiAgICAgICBpbmtzY2FwZTpwZXJzcDNkLW9yaWdpbj0iMC41IDogMC4zMzMzMzMzMyA6IDEiCiAgICAgICBpZD0icGVyc3BlY3RpdmUyODA2IiAvPgogICAgPGlua3NjYXBlOnBlcnNwZWN0aXZlCiAgICAgICBpZD0icGVyc3BlY3RpdmUyODE5IgogICAgICAgaW5rc2NhcGU6cGVyc3AzZC1vcmlnaW49IjM3Mi4wNDcyNCA6IDM1MC43ODczOSA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF96PSI3NDQuMDk0NDggOiA1MjYuMTgxMDkgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfeT0iMCA6IDEwMDAgOiAwIgogICAgICAgaW5rc2NhcGU6dnBfeD0iMCA6IDUyNi4xODEwOSA6IDEiCiAgICAgICBzb2RpcG9kaTp0eXBlPSJpbmtzY2FwZTpwZXJzcDNkIiAvPgogICAgPGlua3NjYXBlOnBlcnNwZWN0aXZlCiAgICAgICBpZD0icGVyc3BlY3RpdmUyNzc3IgogICAgICAgaW5rc2NhcGU6cGVyc3AzZC1vcmlnaW49Ijc1IDogNDAgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfej0iMTUwIDogNjAgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfeT0iMCA6IDEwMDAgOiAwIgogICAgICAgaW5rc2NhcGU6dnBfeD0iMCA6IDYwIDogMSIKICAgICAgIHNvZGlwb2RpOnR5cGU9Imlua3NjYXBlOnBlcnNwM2QiIC8+CiAgICA8aW5rc2NhcGU6cGVyc3BlY3RpdmUKICAgICAgIGlkPSJwZXJzcGVjdGl2ZTMyNzUiCiAgICAgICBpbmtzY2FwZTpwZXJzcDNkLW9yaWdpbj0iNTAgOiAzMy4zMzMzMzMgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfej0iMTAwIDogNTAgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfeT0iMCA6IDEwMDAgOiAwIgogICAgICAgaW5rc2NhcGU6dnBfeD0iMCA6IDUwIDogMSIKICAgICAgIHNvZGlwb2RpOnR5cGU9Imlua3NjYXBlOnBlcnNwM2QiIC8+CiAgICA8aW5rc2NhcGU6cGVyc3BlY3RpdmUKICAgICAgIGlkPSJwZXJzcGVjdGl2ZTU1MzMiCiAgICAgICBpbmtzY2FwZTpwZXJzcDNkLW9yaWdpbj0iMzIgOiAyMS4zMzMzMzMgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfej0iNjQgOiAzMiA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogMzIgOiAxIgogICAgICAgc29kaXBvZGk6dHlwZT0iaW5rc2NhcGU6cGVyc3AzZCIgLz4KICAgIDxpbmtzY2FwZTpwZXJzcGVjdGl2ZQogICAgICAgaWQ9InBlcnNwZWN0aXZlMjU1NyIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSIyNSA6IDE2LjY2NjY2NyA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF96PSI1MCA6IDI1IDogMSIKICAgICAgIGlua3NjYXBlOnZwX3k9IjAgOiAxMDAwIDogMCIKICAgICAgIGlua3NjYXBlOnZwX3g9IjAgOiAyNSA6IDEiCiAgICAgICBzb2RpcG9kaTp0eXBlPSJpbmtzY2FwZTpwZXJzcDNkIiAvPgogIDwvZGVmcz4KICA8c29kaXBvZGk6bmFtZWR2aWV3CiAgICAgaWQ9ImJhc2UiCiAgICAgcGFnZWNvbG9yPSIjZmZmZmZmIgogICAgIGJvcmRlcmNvbG9yPSIjNjY2NjY2IgogICAgIGJvcmRlcm9wYWNpdHk9IjEuMCIKICAgICBpbmtzY2FwZTpwYWdlb3BhY2l0eT0iMC4wIgogICAgIGlua3NjYXBlOnBhZ2VzaGFkb3c9IjIiCiAgICAgaW5rc2NhcGU6em9vbT0iNCIKICAgICBpbmtzY2FwZTpjeD0iMTEzLjAwMDM5IgogICAgIGlua3NjYXBlOmN5PSIxMi44OTM3MzEiCiAgICAgaW5rc2NhcGU6ZG9jdW1lbnQtdW5pdHM9InB4IgogICAgIGlua3NjYXBlOmN1cnJlbnQtbGF5ZXI9ImcyNTYwIgogICAgIHNob3dncmlkPSJmYWxzZSIKICAgICBpbmtzY2FwZTpncmlkLWJib3g9InRydWUiCiAgICAgaW5rc2NhcGU6Z3JpZC1wb2ludHM9InRydWUiCiAgICAgZ3JpZHRvbGVyYW5jZT0iMTAwMDAiCiAgICAgaW5rc2NhcGU6d2luZG93LXdpZHRoPSIxMzk5IgogICAgIGlua3NjYXBlOndpbmRvdy1oZWlnaHQ9Ijg3NCIKICAgICBpbmtzY2FwZTp3aW5kb3cteD0iMzciCiAgICAgaW5rc2NhcGU6d2luZG93LXk9Ii00IgogICAgIGlua3NjYXBlOnNuYXAtYmJveD0idHJ1ZSI+CiAgICA8aW5rc2NhcGU6Z3JpZAogICAgICAgaWQ9IkdyaWRGcm9tUHJlMDQ2U2V0dGluZ3MiCiAgICAgICB0eXBlPSJ4eWdyaWQiCiAgICAgICBvcmlnaW54PSIwcHgiCiAgICAgICBvcmlnaW55PSIwcHgiCiAgICAgICBzcGFjaW5neD0iMXB4IgogICAgICAgc3BhY2luZ3k9IjFweCIKICAgICAgIGNvbG9yPSIjMDAwMGZmIgogICAgICAgZW1wY29sb3I9IiMwMDAwZmYiCiAgICAgICBvcGFjaXR5PSIwLjIiCiAgICAgICBlbXBvcGFjaXR5PSIwLjQiCiAgICAgICBlbXBzcGFjaW5nPSI1IgogICAgICAgdmlzaWJsZT0idHJ1ZSIKICAgICAgIGVuYWJsZWQ9InRydWUiIC8+CiAgPC9zb2RpcG9kaTpuYW1lZHZpZXc+CiAgPG1ldGFkYXRhCiAgICAgaWQ9Im1ldGFkYXRhNyI+CiAgICA8cmRmOlJERj4KICAgICAgPGNjOldvcmsKICAgICAgICAgcmRmOmFib3V0PSIiPgogICAgICAgIDxkYzpmb3JtYXQ+aW1hZ2Uvc3ZnK3htbDwvZGM6Zm9ybWF0PgogICAgICAgIDxkYzp0eXBlCiAgICAgICAgICAgcmRmOnJlc291cmNlPSJodHRwOi8vcHVybC5vcmcvZGMvZGNtaXR5cGUvU3RpbGxJbWFnZSIgLz4KICAgICAgPC9jYzpXb3JrPgogICAgPC9yZGY6UkRGPgogIDwvbWV0YWRhdGE+CiAgPGcKICAgICBpbmtzY2FwZTpsYWJlbD0iTGF5ZXIgMSIKICAgICBpbmtzY2FwZTpncm91cG1vZGU9ImxheWVyIgogICAgIGlkPSJsYXllcjEiPgogICAgPHBhdGgKICAgICAgIHN0eWxlPSJmaWxsOm5vbmU7c3Ryb2tlOiMwMDAwMDA7c3Ryb2tlLXdpZHRoOjI7c3Ryb2tlLWxpbmVjYXA6YnV0dDtzdHJva2UtbGluZWpvaW46bWl0ZXI7c3Ryb2tlLW9wYWNpdHk6MSIKICAgICAgIGQ9Im0gNzAsMjUgYyAyMCwwIDI1LDAgMjUsMCIKICAgICAgIGlkPSJwYXRoMzA1OSIKICAgICAgIHNvZGlwb2RpOm5vZGV0eXBlcz0iY2MiIC8+CiAgICA8cGF0aAogICAgICAgc3R5bGU9ImZpbGw6bm9uZTtzdHJva2U6IzAwMDAwMDtzdHJva2Utd2lkdGg6MjtzdHJva2UtbGluZWNhcDpidXR0O3N0cm9rZS1saW5lam9pbjptaXRlcjtzdHJva2Utb3BhY2l0eToxIgogICAgICAgZD0iTSAzMSwxNSA1LDE1IgogICAgICAgaWQ9InBhdGgzMDYxIiAvPgogICAgPHBhdGgKICAgICAgIHN0eWxlPSJmaWxsOm5vbmU7c3Ryb2tlOiMwMDAwMDA7c3Ryb2tlLXdpZHRoOjEuOTk5OTk5ODg7c3Ryb2tlLWxpbmVjYXA6YnV0dDtzdHJva2UtbGluZWpvaW46bWl0ZXI7c3Ryb2tlLW9wYWNpdHk6MSIKICAgICAgIGQ9Ik0gMzIsMzUgNSwzNSIKICAgICAgIGlkPSJwYXRoMzk0NCIgLz4KICAgIDxnCiAgICAgICBpZD0iZzI1NjAiCiAgICAgICBpbmtzY2FwZTpsYWJlbD0iTGF5ZXIgMSIKICAgICAgIHRyYW5zZm9ybT0idHJhbnNsYXRlKDI2LjUsLTM5LjUpIj4KICAgICAgPHBhdGgKICAgICAgICAgc3R5bGU9ImZpbGw6IzAwMDAwMDtmaWxsLW9wYWNpdHk6MTtmaWxsLXJ1bGU6ZXZlbm9kZDtzdHJva2U6bm9uZTtzdHJva2Utd2lkdGg6MztzdHJva2UtbGluZWNhcDpidXR0O3N0cm9rZS1saW5lam9pbjptaXRlcjtzdHJva2Utb3BhY2l0eToxIgogICAgICAgICBkPSJNIC0yLjQwNjI1LDQ0LjUgTCAtMC40MDYyNSw0Ni45Mzc1IEMgLTAuNDA2MjUsNDYuOTM3NSA1LjI1LDUzLjkzNzU0OSA1LjI1LDY0LjUgQyA1LjI1LDc1LjA2MjQ1MSAtMC40MDYyNSw4Mi4wNjI1IC0wLjQwNjI1LDgyLjA2MjUgTCAtMi40MDYyNSw4NC41IEwgMC43NSw4NC41IEwgMTQuNzUsODQuNSBDIDE3LjE1ODA3Niw4NC41MDAwMDEgMjIuNDM5Njk5LDg0LjUyNDUxNCAyOC4zNzUsODIuMDkzNzUgQyAzNC4zMTAzMDEsNzkuNjYyOTg2IDQwLjkxMTUzNiw3NC43NTA0ODQgNDYuMDYyNSw2NS4yMTg3NSBMIDQ0Ljc1LDY0LjUgTCA0Ni4wNjI1LDYzLjc4MTI1IEMgMzUuNzU5Mzg3LDQ0LjcxNTU5IDE5LjUwNjU3NCw0NC41IDE0Ljc1LDQ0LjUgTCAwLjc1LDQ0LjUgTCAtMi40MDYyNSw0NC41IHogTSAzLjQ2ODc1LDQ3LjUgTCAxNC43NSw0Ny41IEMgMTkuNDM0MTczLDQ3LjUgMzMuMDM2ODUsNDcuMzY5NzkzIDQyLjcxODc1LDY0LjUgQyAzNy45NTE5NjQsNzIuOTI5MDc1IDMyLjE5NzQ2OSw3Ny4xODM5MSAyNyw3OS4zMTI1IEMgMjEuNjM5MzM5LDgxLjUwNzkyNCAxNy4xNTgwNzUsODEuNTAwMDAxIDE0Ljc1LDgxLjUgTCAzLjUsODEuNSBDIDUuMzczNTg4NCw3OC4zOTE1NjYgOC4yNSw3Mi40NTA2NSA4LjI1LDY0LjUgQyA4LjI1LDU2LjUyNjY0NiA1LjM0MTQ2ODYsNTAuNTk5ODE1IDMuNDY4NzUsNDcuNSB6IgogICAgICAgICBpZD0icGF0aDQ5NzMiCiAgICAgICAgIHNvZGlwb2RpOm5vZGV0eXBlcz0iY2NzY2NjY3NjY2NjY2NjY2NzY2NzYyIgLz4KICAgIDwvZz4KICA8L2c+Cjwvc3ZnPgo="}}},{operation:function(I,g){return I||g}}),joint.shapes.logic.Gate21.define("logic.And",{attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},{operation:function(I,g){return I&&g}}),joint.shapes.logic.Gate21.define("logic.Nor",{attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},{operation:function(I,g){return!(I||g)}}),joint.shapes.logic.Gate21.define("logic.Nand",{attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},{operation:function(I,g){return!(I&&g)}}),joint.shapes.logic.Gate21.define("logic.Xor",{attrs:{image:{"xlink:href":"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+CjwhLS0gQ3JlYXRlZCB3aXRoIElua3NjYXBlIChodHRwOi8vd3d3Lmlua3NjYXBlLm9yZy8pIC0tPgo8c3ZnCiAgIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIKICAgeG1sbnM6Y2M9Imh0dHA6Ly9jcmVhdGl2ZWNvbW1vbnMub3JnL25zIyIKICAgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIgogICB4bWxuczpzdmc9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIgogICB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciCiAgIHhtbG5zOnNvZGlwb2RpPSJodHRwOi8vc29kaXBvZGkuc291cmNlZm9yZ2UubmV0L0RURC9zb2RpcG9kaS0wLmR0ZCIKICAgeG1sbnM6aW5rc2NhcGU9Imh0dHA6Ly93d3cuaW5rc2NhcGUub3JnL25hbWVzcGFjZXMvaW5rc2NhcGUiCiAgIHdpZHRoPSIxMDAiCiAgIGhlaWdodD0iNTAiCiAgIGlkPSJzdmcyIgogICBzb2RpcG9kaTp2ZXJzaW9uPSIwLjMyIgogICBpbmtzY2FwZTp2ZXJzaW9uPSIwLjQ2IgogICB2ZXJzaW9uPSIxLjAiCiAgIHNvZGlwb2RpOmRvY25hbWU9IlhPUiBBTlNJLnN2ZyIKICAgaW5rc2NhcGU6b3V0cHV0X2V4dGVuc2lvbj0ib3JnLmlua3NjYXBlLm91dHB1dC5zdmcuaW5rc2NhcGUiPgogIDxkZWZzCiAgICAgaWQ9ImRlZnM0Ij4KICAgIDxpbmtzY2FwZTpwZXJzcGVjdGl2ZQogICAgICAgc29kaXBvZGk6dHlwZT0iaW5rc2NhcGU6cGVyc3AzZCIKICAgICAgIGlua3NjYXBlOnZwX3g9IjAgOiAxNSA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF96PSI1MCA6IDE1IDogMSIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSIyNSA6IDEwIDogMSIKICAgICAgIGlkPSJwZXJzcGVjdGl2ZTI3MTQiIC8+CiAgICA8aW5rc2NhcGU6cGVyc3BlY3RpdmUKICAgICAgIHNvZGlwb2RpOnR5cGU9Imlua3NjYXBlOnBlcnNwM2QiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogMC41IDogMSIKICAgICAgIGlua3NjYXBlOnZwX3k9IjAgOiAxMDAwIDogMCIKICAgICAgIGlua3NjYXBlOnZwX3o9IjEgOiAwLjUgOiAxIgogICAgICAgaW5rc2NhcGU6cGVyc3AzZC1vcmlnaW49IjAuNSA6IDAuMzMzMzMzMzMgOiAxIgogICAgICAgaWQ9InBlcnNwZWN0aXZlMjgwNiIgLz4KICAgIDxpbmtzY2FwZTpwZXJzcGVjdGl2ZQogICAgICAgaWQ9InBlcnNwZWN0aXZlMjgxOSIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSIzNzIuMDQ3MjQgOiAzNTAuNzg3MzkgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfej0iNzQ0LjA5NDQ4IDogNTI2LjE4MTA5IDogMSIKICAgICAgIGlua3NjYXBlOnZwX3k9IjAgOiAxMDAwIDogMCIKICAgICAgIGlua3NjYXBlOnZwX3g9IjAgOiA1MjYuMTgxMDkgOiAxIgogICAgICAgc29kaXBvZGk6dHlwZT0iaW5rc2NhcGU6cGVyc3AzZCIgLz4KICAgIDxpbmtzY2FwZTpwZXJzcGVjdGl2ZQogICAgICAgaWQ9InBlcnNwZWN0aXZlMjc3NyIKICAgICAgIGlua3NjYXBlOnBlcnNwM2Qtb3JpZ2luPSI3NSA6IDQwIDogMSIKICAgICAgIGlua3NjYXBlOnZwX3o9IjE1MCA6IDYwIDogMSIKICAgICAgIGlua3NjYXBlOnZwX3k9IjAgOiAxMDAwIDogMCIKICAgICAgIGlua3NjYXBlOnZwX3g9IjAgOiA2MCA6IDEiCiAgICAgICBzb2RpcG9kaTp0eXBlPSJpbmtzY2FwZTpwZXJzcDNkIiAvPgogICAgPGlua3NjYXBlOnBlcnNwZWN0aXZlCiAgICAgICBpZD0icGVyc3BlY3RpdmUzMjc1IgogICAgICAgaW5rc2NhcGU6cGVyc3AzZC1vcmlnaW49IjUwIDogMzMuMzMzMzMzIDogMSIKICAgICAgIGlua3NjYXBlOnZwX3o9IjEwMCA6IDUwIDogMSIKICAgICAgIGlua3NjYXBlOnZwX3k9IjAgOiAxMDAwIDogMCIKICAgICAgIGlua3NjYXBlOnZwX3g9IjAgOiA1MCA6IDEiCiAgICAgICBzb2RpcG9kaTp0eXBlPSJpbmtzY2FwZTpwZXJzcDNkIiAvPgogICAgPGlua3NjYXBlOnBlcnNwZWN0aXZlCiAgICAgICBpZD0icGVyc3BlY3RpdmU1NTMzIgogICAgICAgaW5rc2NhcGU6cGVyc3AzZC1vcmlnaW49IjMyIDogMjEuMzMzMzMzIDogMSIKICAgICAgIGlua3NjYXBlOnZwX3o9IjY0IDogMzIgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfeT0iMCA6IDEwMDAgOiAwIgogICAgICAgaW5rc2NhcGU6dnBfeD0iMCA6IDMyIDogMSIKICAgICAgIHNvZGlwb2RpOnR5cGU9Imlua3NjYXBlOnBlcnNwM2QiIC8+CiAgICA8aW5rc2NhcGU6cGVyc3BlY3RpdmUKICAgICAgIGlkPSJwZXJzcGVjdGl2ZTI1NTciCiAgICAgICBpbmtzY2FwZTpwZXJzcDNkLW9yaWdpbj0iMjUgOiAxNi42NjY2NjcgOiAxIgogICAgICAgaW5rc2NhcGU6dnBfej0iNTAgOiAyNSA6IDEiCiAgICAgICBpbmtzY2FwZTp2cF95PSIwIDogMTAwMCA6IDAiCiAgICAgICBpbmtzY2FwZTp2cF94PSIwIDogMjUgOiAxIgogICAgICAgc29kaXBvZGk6dHlwZT0iaW5rc2NhcGU6cGVyc3AzZCIgLz4KICA8L2RlZnM+CiAgPHNvZGlwb2RpOm5hbWVkdmlldwogICAgIGlkPSJiYXNlIgogICAgIHBhZ2Vjb2xvcj0iI2ZmZmZmZiIKICAgICBib3JkZXJjb2xvcj0iIzY2NjY2NiIKICAgICBib3JkZXJvcGFjaXR5PSIxLjAiCiAgICAgaW5rc2NhcGU6cGFnZW9wYWNpdHk9IjAuMCIKICAgICBpbmtzY2FwZTpwYWdlc2hhZG93PSIyIgogICAgIGlua3NjYXBlOnpvb209IjUuNjU2ODU0MiIKICAgICBpbmtzY2FwZTpjeD0iMjUuOTM4MTE2IgogICAgIGlua3NjYXBlOmN5PSIxNy4yMzAwNSIKICAgICBpbmtzY2FwZTpkb2N1bWVudC11bml0cz0icHgiCiAgICAgaW5rc2NhcGU6Y3VycmVudC1sYXllcj0ibGF5ZXIxIgogICAgIHNob3dncmlkPSJ0cnVlIgogICAgIGlua3NjYXBlOmdyaWQtYmJveD0idHJ1ZSIKICAgICBpbmtzY2FwZTpncmlkLXBvaW50cz0idHJ1ZSIKICAgICBncmlkdG9sZXJhbmNlPSIxMDAwMCIKICAgICBpbmtzY2FwZTp3aW5kb3ctd2lkdGg9IjEzOTkiCiAgICAgaW5rc2NhcGU6d2luZG93LWhlaWdodD0iODc0IgogICAgIGlua3NjYXBlOndpbmRvdy14PSIzMyIKICAgICBpbmtzY2FwZTp3aW5kb3cteT0iMCIKICAgICBpbmtzY2FwZTpzbmFwLWJib3g9InRydWUiPgogICAgPGlua3NjYXBlOmdyaWQKICAgICAgIGlkPSJHcmlkRnJvbVByZTA0NlNldHRpbmdzIgogICAgICAgdHlwZT0ieHlncmlkIgogICAgICAgb3JpZ2lueD0iMHB4IgogICAgICAgb3JpZ2lueT0iMHB4IgogICAgICAgc3BhY2luZ3g9IjFweCIKICAgICAgIHNwYWNpbmd5PSIxcHgiCiAgICAgICBjb2xvcj0iIzAwMDBmZiIKICAgICAgIGVtcGNvbG9yPSIjMDAwMGZmIgogICAgICAgb3BhY2l0eT0iMC4yIgogICAgICAgZW1wb3BhY2l0eT0iMC40IgogICAgICAgZW1wc3BhY2luZz0iNSIKICAgICAgIHZpc2libGU9InRydWUiCiAgICAgICBlbmFibGVkPSJ0cnVlIiAvPgogIDwvc29kaXBvZGk6bmFtZWR2aWV3PgogIDxtZXRhZGF0YQogICAgIGlkPSJtZXRhZGF0YTciPgogICAgPHJkZjpSREY+CiAgICAgIDxjYzpXb3JrCiAgICAgICAgIHJkZjphYm91dD0iIj4KICAgICAgICA8ZGM6Zm9ybWF0PmltYWdlL3N2Zyt4bWw8L2RjOmZvcm1hdD4KICAgICAgICA8ZGM6dHlwZQogICAgICAgICAgIHJkZjpyZXNvdXJjZT0iaHR0cDovL3B1cmwub3JnL2RjL2RjbWl0eXBlL1N0aWxsSW1hZ2UiIC8+CiAgICAgIDwvY2M6V29yaz4KICAgIDwvcmRmOlJERj4KICA8L21ldGFkYXRhPgogIDxnCiAgICAgaW5rc2NhcGU6bGFiZWw9IkxheWVyIDEiCiAgICAgaW5rc2NhcGU6Z3JvdXBtb2RlPSJsYXllciIKICAgICBpZD0ibGF5ZXIxIj4KICAgIDxwYXRoCiAgICAgICBzdHlsZT0iZmlsbDpub25lO3N0cm9rZTojMDAwMDAwO3N0cm9rZS13aWR0aDoyO3N0cm9rZS1saW5lY2FwOmJ1dHQ7c3Ryb2tlLWxpbmVqb2luOm1pdGVyO3N0cm9rZS1vcGFjaXR5OjEiCiAgICAgICBkPSJtIDcwLDI1IGMgMjAsMCAyNSwwIDI1LDAiCiAgICAgICBpZD0icGF0aDMwNTkiCiAgICAgICBzb2RpcG9kaTpub2RldHlwZXM9ImNjIiAvPgogICAgPHBhdGgKICAgICAgIHN0eWxlPSJmaWxsOm5vbmU7c3Ryb2tlOiMwMDAwMDA7c3Ryb2tlLXdpZHRoOjEuOTk5OTk5ODg7c3Ryb2tlLWxpbmVjYXA6YnV0dDtzdHJva2UtbGluZWpvaW46bWl0ZXI7c3Ryb2tlLW9wYWNpdHk6MSIKICAgICAgIGQ9Ik0gMzAuMzg1NzE3LDE1IEwgNC45OTk5OTk4LDE1IgogICAgICAgaWQ9InBhdGgzMDYxIiAvPgogICAgPHBhdGgKICAgICAgIHN0eWxlPSJmaWxsOm5vbmU7c3Ryb2tlOiMwMDAwMDA7c3Ryb2tlLXdpZHRoOjEuOTk5OTk5NzY7c3Ryb2tlLWxpbmVjYXA6YnV0dDtzdHJva2UtbGluZWpvaW46bWl0ZXI7c3Ryb2tlLW9wYWNpdHk6MSIKICAgICAgIGQ9Ik0gMzEuMzYyMDkxLDM1IEwgNC45OTk5OTk4LDM1IgogICAgICAgaWQ9InBhdGgzOTQ0IiAvPgogICAgPGcKICAgICAgIGlkPSJnMjU2MCIKICAgICAgIGlua3NjYXBlOmxhYmVsPSJMYXllciAxIgogICAgICAgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMjYuNSwtMzkuNSkiPgogICAgICA8cGF0aAogICAgICAgICBpZD0icGF0aDM1MTYiCiAgICAgICAgIHN0eWxlPSJmaWxsOiMwMDAwMDA7ZmlsbC1vcGFjaXR5OjE7ZmlsbC1ydWxlOmV2ZW5vZGQ7c3Ryb2tlOm5vbmU7c3Ryb2tlLXdpZHRoOjM7c3Ryb2tlLWxpbmVjYXA6YnV0dDtzdHJva2UtbGluZWpvaW46bWl0ZXI7c3Ryb2tlLW9wYWNpdHk6MSIKICAgICAgICAgZD0iTSAtMi4yNSw4MS41MDAwMDUgQyAtMy44NDczNzQsODQuMTQ0NDA1IC00LjUsODQuNTAwMDA1IC00LjUsODQuNTAwMDA1IEwgLTguMTU2MjUsODQuNTAwMDA1IEwgLTYuMTU2MjUsODIuMDYyNTA1IEMgLTYuMTU2MjUsODIuMDYyNTA1IC0wLjUsNzUuMDYyNDUxIC0wLjUsNjQuNSBDIC0wLjUsNTMuOTM3NTQ5IC02LjE1NjI1LDQ2LjkzNzUgLTYuMTU2MjUsNDYuOTM3NSBMIC04LjE1NjI1LDQ0LjUgTCAtNC41LDQ0LjUgQyAtMy43MTg3NSw0NS40Mzc1IC0zLjA3ODEyNSw0Ni4xNTYyNSAtMi4yODEyNSw0Ny41IEMgLTAuNDA4NTMxLDUwLjU5OTgxNSAyLjUsNTYuNTI2NjQ2IDIuNSw2NC41IEMgMi41LDcyLjQ1MDY1IC0wLjM5NjY5Nyw3OC4zNzk0MjUgLTIuMjUsODEuNTAwMDA1IHoiCiAgICAgICAgIHNvZGlwb2RpOm5vZGV0eXBlcz0iY2NjY3NjY2Njc2MiIC8+CiAgICAgIDxwYXRoCiAgICAgICAgIHN0eWxlPSJmaWxsOiMwMDAwMDA7ZmlsbC1vcGFjaXR5OjE7ZmlsbC1ydWxlOmV2ZW5vZGQ7c3Ryb2tlOm5vbmU7c3Ryb2tlLXdpZHRoOjM7c3Ryb2tlLWxpbmVjYXA6YnV0dDtzdHJva2UtbGluZWpvaW46bWl0ZXI7c3Ryb2tlLW9wYWNpdHk6MSIKICAgICAgICAgZD0iTSAtMi40MDYyNSw0NC41IEwgLTAuNDA2MjUsNDYuOTM3NSBDIC0wLjQwNjI1LDQ2LjkzNzUgNS4yNSw1My45Mzc1NDkgNS4yNSw2NC41IEMgNS4yNSw3NS4wNjI0NTEgLTAuNDA2MjUsODIuMDYyNSAtMC40MDYyNSw4Mi4wNjI1IEwgLTIuNDA2MjUsODQuNSBMIDAuNzUsODQuNSBMIDE0Ljc1LDg0LjUgQyAxNy4xNTgwNzYsODQuNTAwMDAxIDIyLjQzOTY5OSw4NC41MjQ1MTQgMjguMzc1LDgyLjA5Mzc1IEMgMzQuMzEwMzAxLDc5LjY2Mjk4NiA0MC45MTE1MzYsNzQuNzUwNDg0IDQ2LjA2MjUsNjUuMjE4NzUgTCA0NC43NSw2NC41IEwgNDYuMDYyNSw2My43ODEyNSBDIDM1Ljc1OTM4Nyw0NC43MTU1OSAxOS41MDY1NzQsNDQuNSAxNC43NSw0NC41IEwgMC43NSw0NC41IEwgLTIuNDA2MjUsNDQuNSB6IE0gMy40Njg3NSw0Ny41IEwgMTQuNzUsNDcuNSBDIDE5LjQzNDE3Myw0Ny41IDMzLjAzNjg1LDQ3LjM2OTc5MyA0Mi43MTg3NSw2NC41IEMgMzcuOTUxOTY0LDcyLjkyOTA3NSAzMi4xOTc0NjksNzcuMTgzOTEgMjcsNzkuMzEyNSBDIDIxLjYzOTMzOSw4MS41MDc5MjQgMTcuMTU4MDc1LDgxLjUwMDAwMSAxNC43NSw4MS41IEwgMy41LDgxLjUgQyA1LjM3MzU4ODQsNzguMzkxNTY2IDguMjUsNzIuNDUwNjUgOC4yNSw2NC41IEMgOC4yNSw1Ni41MjY2NDYgNS4zNDE0Njg2LDUwLjU5OTgxNSAzLjQ2ODc1LDQ3LjUgeiIKICAgICAgICAgaWQ9InBhdGg0OTczIgogICAgICAgICBzb2RpcG9kaTpub2RldHlwZXM9ImNjc2NjY2NzY2NjY2NjY2Njc2Njc2MiIC8+CiAgICA8L2c+CiAgPC9nPgo8L3N2Zz4K"}}},{operation:function(I,g){return(!I||g)&&(I||!g)}}),joint.shapes.logic.Gate21.define("logic.Xnor",{attrs:{image:{"xlink:href":"data:image/svg+xml;base64,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"}}},{operation:function(I,g){return(!I||!g)&&(I||g)}}),joint.dia.Link.define("logic.Wire",{attrs:{".connection":{"stroke-width":2},".marker-vertex":{r:7}},router:{name:"orthogonal"},connector:{name:"rounded",args:{radius:10}}},{arrowheadMarkup:['<g class="marker-arrowhead-group marker-arrowhead-group-<%= end %>">','<circle class="marker-arrowhead" end="<%= end %>" r="7"/>',"</g>"].join(""),vertexMarkup:['<g class="marker-vertex-group" transform="translate(<%= x %>, <%= y %>)">','<circle class="marker-vertex" idx="<%= idx %>" r="10" />','<g class="marker-vertex-remove-group">','<path class="marker-vertex-remove-area" idx="<%= idx %>" d="M16,5.333c-7.732,0-14,4.701-14,10.5c0,1.982,0.741,3.833,2.016,5.414L2,25.667l5.613-1.441c2.339,1.317,5.237,2.107,8.387,2.107c7.732,0,14-4.701,14-10.5C30,10.034,23.732,5.333,16,5.333z" transform="translate(5, -33)"/>','<path class="marker-vertex-remove" idx="<%= idx %>" transform="scale(.8) translate(9.5, -37)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z">',"<title>Remove vertex.</title>","</path>","</g>","</g>"].join("")});
if("object"==typeof exports)var graphlib=require("graphlib"),dagre=require("dagre");graphlib=graphlib||"undefined"!=typeof window&&window.graphlib,dagre=dagre||"undefined"!=typeof window&&window.dagre,joint.layout.DirectedGraph={exportElement:function(e){return e.size()},exportLink:function(e){var t=e.get("labelSize")||{};return{minLen:e.get("minLen")||1,weight:e.get("weight")||1,labelpos:e.get("labelPosition")||"c",labeloffset:e.get("labelOffset")||0,width:t.width||0,height:t.height||0}},importElement:function(e,t,i){var n=this.getCell(t),r=i.node(t);e.setPosition?e.setPosition(n,r):n.set("position",{x:r.x-r.width/2,y:r.y-r.height/2})},importLink:function(e,t,i){var n=this.getCell(t.name),r=i.edge(t),o=r.points||[];if((e.setVertices||e.setLinkVertices)&&(joint.util.isFunction(e.setVertices)?e.setVertices(n,o):n.set("vertices",o.slice(1,o.length-1))),e.setLabels&&"x"in r&&"y"in r){var a={x:r.x,y:r.y};if(joint.util.isFunction(e.setLabels))e.setLabels(n,a,o);else{var s=g.Polyline(o),l=s.closestPointLength(a),d=s.pointAtLength(l),p=l/s.length();n.label(0,{position:{distance:p,offset:g.Point(a).difference(d).toJSON()}})}}},layout:function(e,t){var i;i=e instanceof joint.dia.Graph?e:(new joint.dia.Graph).resetCells(e,{dry:!0,sort:!1}),e=null,t=joint.util.defaults(t||{},{resizeClusters:!0,clusterPadding:10,exportElement:this.exportElement,exportLink:this.exportLink});var n=i.toGraphLib({directed:!0,multigraph:!0,compound:!0,setNodeLabel:t.exportElement,setEdgeLabel:t.exportLink,setEdgeName:function(e){return e.id}}),r={},o=t.marginX||0,a=t.marginY||0;if(t.rankDir&&(r.rankdir=t.rankDir),t.align&&(r.align=t.align),t.nodeSep&&(r.nodesep=t.nodeSep),t.edgeSep&&(r.edgesep=t.edgeSep),t.rankSep&&(r.ranksep=t.rankSep),t.ranker&&(r.ranker=t.ranker),o&&(r.marginx=o),a&&(r.marginy=a),n.setGraph(r),dagre.layout(n,{debugTiming:!!t.debugTiming}),i.startBatch("layout"),i.fromGraphLib(n,{importNode:this.importElement.bind(i,t),importEdge:this.importLink.bind(i,t)}),t.resizeClusters){var s=n.nodes().filter(function(e){return 0<n.children(e).length}).map(i.getCell.bind(i)).sort(function(e,t){return t.getAncestors().length-e.getAncestors().length});joint.util.invoke(s,"fitEmbeds",{padding:t.clusterPadding})}i.stopBatch("layout");var l=n.graph();return g.Rect(o,a,Math.abs(l.width-2*o),Math.abs(l.height-2*a))},fromGraphLib:function(t,i){var n=(i=i||{}).importNode||joint.util.noop,r=i.importEdge||joint.util.noop,o=this instanceof joint.dia.Graph?this:new joint.dia.Graph;return t.nodes().forEach(function(e){n.call(o,e,t,o,i)}),t.edges().forEach(function(e){r.call(o,e,t,o,i)}),o},toGraphLib:function(e,t){t=t||{};for(var i=joint.util.pick(t,"directed","compound","multigraph"),n=new graphlib.Graph(i),r=t.setNodeLabel||joint.util.noop,o=t.setEdgeLabel||joint.util.noop,a=t.setEdgeName||joint.util.noop,s=e.get("cells"),l=0,d=s.length;l<d;l++){var p=s.at(l);if(p.isLink()){var g=p.get("source"),h=p.get("target");if(!g.id||!h.id)break;n.setEdge(g.id,h.id,o(p),a(p))}else if(n.setNode(p.id,r(p)),n.isCompound()&&p.has("parent")){var u=p.get("parent");s.has(u)&&n.setParent(p.id,u)}}return n}},joint.dia.Graph.prototype.toGraphLib=function(e){return joint.layout.DirectedGraph.toGraphLib(this,e)},joint.dia.Graph.prototype.fromGraphLib=function(e,t){return joint.layout.DirectedGraph.fromGraphLib.call(this,e,t)};

    joint.g = g;
    joint.V = joint.Vectorizer = V;

    return joint;

}));
