/*
 Highcharts JS v8.2.2 (2020-10-22)

 Annotations module

 (c) 2009-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/modules/annotations-advanced",["highcharts"],function(u){c(u);c.Highcharts=u;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function u(f,c,m,q){f.hasOwnProperty(c)||(f[c]=q.apply(null,m))}c=c?c._modules:{};u(c,"Extensions/Annotations/Mixins/EventEmitterMixin.js",[c["Core/Globals.js"],c["Core/Utilities.js"]],function(f,c){var h=
c.addEvent,q=c.fireEvent,l=c.objectEach,r=c.pick,e=c.removeEvent;return{addEvents:function(){var b=this,a=function(a){h(a,f.isTouchDevice?"touchstart":"mousedown",function(a){b.onMouseDown(a)})};a(this.graphic.element);(b.labels||[]).forEach(function(d){d.options.useHTML&&d.graphic.text&&a(d.graphic.text.element)});l(b.options.events,function(a,d){var g=function(g){"click"===d&&b.cancelClick||a.call(b,b.chart.pointer.normalize(g),b.target)};if(-1===(b.nonDOMEvents||[]).indexOf(d))b.graphic.on(d,g);
else h(b,d,g)});if(b.options.draggable&&(h(b,"drag",b.onDrag),!b.graphic.renderer.styledMode)){var d={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[b.options.draggable]};b.graphic.css(d);(b.labels||[]).forEach(function(a){a.options.useHTML&&a.graphic.text&&a.graphic.text.css(d)})}b.isUpdating||q(b,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag());this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(b){var a=this,d=a.chart.pointer;
b.preventDefault&&b.preventDefault();if(2!==b.button){b=d.normalize(b);var g=b.chartX;var k=b.chartY;a.cancelClick=!1;a.chart.hasDraggedAnnotation=!0;a.removeDrag=h(f.doc,f.isTouchDevice?"touchmove":"mousemove",function(b){a.hasDragged=!0;b=d.normalize(b);b.prevChartX=g;b.prevChartY=k;q(a,"drag",b);g=b.chartX;k=b.chartY});a.removeMouseUp=h(f.doc,f.isTouchDevice?"touchend":"mouseup",function(d){a.cancelClick=a.hasDragged;a.hasDragged=!1;a.chart.hasDraggedAnnotation=!1;q(r(a.target,a),"afterUpdate");
a.onMouseUp(d)})}},onMouseUp:function(b){var a=this.chart;b=this.target||this;var d=a.options.annotations;a=a.annotations.indexOf(b);this.removeDocEvents();d[a]=b.options},onDrag:function(b){if(this.chart.isInsidePlot(b.chartX-this.chart.plotLeft,b.chartY-this.chart.plotTop)){var a=this.mouseMoveToTranslation(b);"x"===this.options.draggable&&(a.y=0);"y"===this.options.draggable&&(a.x=0);this.points.length?this.translate(a.x,a.y):(this.shapes.forEach(function(d){d.translate(a.x,a.y)}),this.labels.forEach(function(d){d.translate(a.x,
a.y)}));this.redraw(!1)}},mouseMoveToRadians:function(b,a,d){var g=b.prevChartY-d,k=b.prevChartX-a;d=b.chartY-d;b=b.chartX-a;this.chart.inverted&&(a=k,k=g,g=a,a=b,b=d,d=a);return Math.atan2(d,b)-Math.atan2(g,k)},mouseMoveToTranslation:function(b){var a=b.chartX-b.prevChartX;b=b.chartY-b.prevChartY;if(this.chart.inverted){var d=b;b=a;a=d}return{x:a,y:b}},mouseMoveToScale:function(b,a,d){a=(b.chartX-a||1)/(b.prevChartX-a||1);b=(b.chartY-d||1)/(b.prevChartY-d||1);this.chart.inverted&&(d=b,b=a,a=d);return{x:a,
y:b}},destroy:function(){this.removeDocEvents();e(this);this.hcEvents=null}}});u(c,"Extensions/Annotations/ControlPoint.js",[c["Core/Utilities.js"],c["Extensions/Annotations/Mixins/EventEmitterMixin.js"]],function(f,c){var h=f.merge,q=f.pick;return function(){function f(f,e,b,a){this.addEvents=c.addEvents;this.graphic=void 0;this.mouseMoveToRadians=c.mouseMoveToRadians;this.mouseMoveToScale=c.mouseMoveToScale;this.mouseMoveToTranslation=c.mouseMoveToTranslation;this.onDrag=c.onDrag;this.onMouseDown=
c.onMouseDown;this.onMouseUp=c.onMouseUp;this.removeDocEvents=c.removeDocEvents;this.nonDOMEvents=["drag"];this.chart=f;this.target=e;this.options=b;this.index=q(b.index,a)}f.prototype.setVisibility=function(f){this.graphic.attr("visibility",f?"visible":"hidden");this.options.visible=f};f.prototype.render=function(){var f=this.chart,e=this.options;this.graphic=f.renderer.symbol(e.symbol,0,0,e.width,e.height).add(f.controlPointsGroup).css(e.style);this.setVisibility(e.visible);this.addEvents()};f.prototype.redraw=
function(f){this.graphic[f?"animate":"attr"](this.options.positioner.call(this,this.target))};f.prototype.destroy=function(){c.destroy.call(this);this.graphic&&(this.graphic=this.graphic.destroy());this.options=this.target=this.chart=null};f.prototype.update=function(f){var e=this.chart,b=this.target,a=this.index;f=h(!0,this.options,f);this.destroy();this.constructor(e,b,f,a);this.render(e.controlPointsGroup);this.redraw()};return f}()});u(c,"Extensions/Annotations/MockPoint.js",[c["Core/Globals.js"],
c["Core/Utilities.js"],c["Core/Axis/Axis.js"]],function(f,c,m){var h=c.defined,l=c.fireEvent;return function(){function c(e,b,a){this.y=this.x=this.plotY=this.plotX=this.isInside=void 0;this.mock=!0;this.series={visible:!0,chart:e,getPlotBox:f.Series.prototype.getPlotBox};this.target=b||null;this.options=a;this.applyOptions(this.getOptions())}c.fromPoint=function(e){return new c(e.series.chart,null,{x:e.x,y:e.y,xAxis:e.series.xAxis,yAxis:e.series.yAxis})};c.pointToPixels=function(e,b){var a=e.series,
d=a.chart,g=e.plotX,k=e.plotY;d.inverted&&(e.mock?(g=e.plotY,k=e.plotX):(g=d.plotWidth-e.plotY,k=d.plotHeight-e.plotX));a&&!b&&(e=a.getPlotBox(),g+=e.translateX,k+=e.translateY);return{x:g,y:k}};c.pointToOptions=function(e){return{x:e.x,y:e.y,xAxis:e.series.xAxis,yAxis:e.series.yAxis}};c.prototype.hasDynamicOptions=function(){return"function"===typeof this.options};c.prototype.getOptions=function(){return this.hasDynamicOptions()?this.options(this.target):this.options};c.prototype.applyOptions=function(e){this.command=
e.command;this.setAxis(e,"x");this.setAxis(e,"y");this.refresh()};c.prototype.setAxis=function(e,b){b+="Axis";e=e[b];var a=this.series.chart;this.series[b]=e instanceof m?e:h(e)?a[b][e]||a.get(e):null};c.prototype.toAnchor=function(){var e=[this.plotX,this.plotY,0,0];this.series.chart.inverted&&(e[0]=this.plotY,e[1]=this.plotX);return e};c.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}};c.prototype.isInsidePlot=function(){var e=this.plotX,b=this.plotY,a=this.series.xAxis,
d=this.series.yAxis,g={x:e,y:b,isInsidePlot:!0};a&&(g.isInsidePlot=h(e)&&0<=e&&e<=a.len);d&&(g.isInsidePlot=g.isInsidePlot&&h(b)&&0<=b&&b<=d.len);l(this.series.chart,"afterIsInsidePlot",g);return g.isInsidePlot};c.prototype.refresh=function(){var e=this.series,b=e.xAxis;e=e.yAxis;var a=this.getOptions();b?(this.x=a.x,this.plotX=b.toPixels(a.x,!0)):(this.x=null,this.plotX=a.x);e?(this.y=a.y,this.plotY=e.toPixels(a.y,!0)):(this.y=null,this.plotY=a.y);this.isInside=this.isInsidePlot()};c.prototype.translate=
function(e,b,a,d){this.hasDynamicOptions()||(this.plotX+=a,this.plotY+=d,this.refreshOptions())};c.prototype.scale=function(e,b,a,d){if(!this.hasDynamicOptions()){var g=this.plotY*d;this.plotX=(1-a)*e+this.plotX*a;this.plotY=(1-d)*b+g;this.refreshOptions()}};c.prototype.rotate=function(e,b,a){if(!this.hasDynamicOptions()){var d=Math.cos(a);a=Math.sin(a);var g=this.plotX,k=this.plotY;g-=e;k-=b;this.plotX=g*d-k*a+e;this.plotY=g*a+k*d+b;this.refreshOptions()}};c.prototype.refreshOptions=function(){var e=
this.series,b=e.xAxis;e=e.yAxis;this.x=this.options.x=b?this.options.x=b.toValue(this.plotX,!0):this.plotX;this.y=this.options.y=e?e.toValue(this.plotY,!0):this.plotY};return c}()});u(c,"Extensions/Annotations/Mixins/ControllableMixin.js",[c["Extensions/Annotations/ControlPoint.js"],c["Extensions/Annotations/MockPoint.js"],c["Core/Tooltip.js"],c["Core/Utilities.js"]],function(f,c,m,q){var h=q.isObject,r=q.isString,e=q.merge,b=q.splat;return{init:function(a,d,g){this.annotation=a;this.chart=a.chart;
this.options=d;this.points=[];this.controlPoints=[];this.index=g;this.linkPoints();this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var a=this.options;return a.points||a.point&&b(a.point)},attrsFromOptions:function(a){var d=this.constructor.attrsMap,g={},b,e=this.chart.styledMode;for(b in a){var f=d[b];!f||e&&-1!==["fill","stroke","stroke-width"].indexOf(f)||(g[f]=a[b])}return g},anchor:function(a){var d=a.series.getPlotBox(),g=
a.series.chart,b=a.mock?a.toAnchor():m.prototype.getAnchor.call({chart:a.series.chart},a);b={x:b[0]+(this.options.x||0),y:b[1]+(this.options.y||0),height:b[2]||0,width:b[3]||0};return{relativePosition:b,absolutePosition:e(b,{x:b.x+(a.mock?d.translateX:g.plotLeft),y:b.y+(a.mock?d.translateY:g.plotTop)})}},point:function(a,d){if(a&&a.series)return a;d&&null!==d.series||(h(a)?d=new c(this.chart,this,a):r(a)?d=this.chart.get(a)||null:"function"===typeof a&&(d=a.call(d,this),d=d.series?d:new c(this.chart,
this,a)));return d},linkPoints:function(){var a=this.getPointsOptions(),d=this.points,g=a&&a.length||0,b;for(b=0;b<g;b++){var e=this.point(a[b],d[b]);if(!e){d.length=0;return}e.mock&&e.refresh();d[b]=e}return d},addControlPoints:function(){var a=this.options.controlPoints;(a||[]).forEach(function(d,b){d=e(this.options.controlPointOptions,d);d.index||(d.index=b);a[b]=d;this.controlPoints.push(new f(this.chart,this,d))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(a){this.controlPoints.forEach(function(a){a.render()})},
redraw:function(a){this.controlPoints.forEach(function(d){d.redraw(a)})},transform:function(a,d,b,k,e){if(this.chart.inverted){var g=d;d=b;b=g}this.points.forEach(function(g,t){this.transformPoint(a,d,b,k,e,t)},this)},transformPoint:function(a,d,b,k,e,f){var g=this.points[f];g.mock||(g=this.points[f]=c.fromPoint(g));g[a](d,b,k,e)},translate:function(a,d){this.transform("translate",null,null,a,d)},translatePoint:function(a,d,b){this.transformPoint("translate",null,null,a,d,b)},translateShape:function(a,
d){var b=this.annotation.chart,k=this.annotation.userOptions,e=b.annotations.indexOf(this.annotation);b=b.options.annotations[e];this.translatePoint(a,d,0);b[this.collection][this.index].point=this.options.point;k[this.collection][this.index].point=this.options.point},rotate:function(a,d,b){this.transform("rotate",a,d,b)},scale:function(a,d,b,k){this.transform("scale",a,d,b,k)},setControlPointsVisibility:function(a){this.controlPoints.forEach(function(d){d.setVisibility(a)})},destroy:function(){this.graphic&&
(this.graphic=this.graphic.destroy());this.tracker&&(this.tracker=this.tracker.destroy());this.controlPoints.forEach(function(a){a.destroy()});this.options=this.controlPoints=this.points=this.chart=null;this.annotation&&(this.annotation=null)},update:function(a){var d=this.annotation;a=e(!0,this.options,a);var b=this.graphic.parentGroup;this.destroy();this.constructor(d,a);this.render(b);this.redraw()}}});u(c,"Extensions/Annotations/Mixins/MarkerMixin.js",[c["Core/Chart/Chart.js"],c["Core/Renderer/SVG/SVGRenderer.js"],
c["Core/Utilities.js"]],function(f,c,m){function h(a){return function(d){this.attr(a,"url(#"+d+")")}}var l=m.addEvent,r=m.defined,e=m.merge,b=m.objectEach,a=m.uniqueKey,d={arrow:{tagName:"marker",render:!1,id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10,children:[{tagName:"path",d:"M 0 0 L 10 5 L 0 10 Z",strokeWidth:0}]},"reverse-arrow":{tagName:"marker",render:!1,id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10,children:[{tagName:"path",d:"M 0 5 L 10 0 L 10 10 Z",strokeWidth:0}]}};
c.prototype.addMarker=function(a,d){var b={id:a},g={stroke:d.color||"none",fill:d.color||"rgba(0, 0, 0, 0.75)"};b.children=d.children.map(function(a){return e(g,a)});d=this.definition(e(!0,{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"},d,b));d.id=a;return d};c={markerEndSetter:h("marker-end"),markerStartSetter:h("marker-start"),setItemMarkers:function(d){var b=d.options,g=d.chart,f=g.options.defs,n=b.fill,t=r(n)&&"none"!==n?n:b.stroke;["markerStart","markerEnd"].forEach(function(k){var n=
b[k],y;if(n){for(y in f){var c=f[y];if(n===c.id&&"marker"===c.tagName){var v=c;break}}v&&(n=d[k]=g.renderer.addMarker((b.id||a())+"-"+v.id,e(v,{color:t})),d.attr(k,n.attr("id")))}})}};l(f,"afterGetContainer",function(){this.options.defs=e(d,this.options.defs||{});b(this.options.defs,function(a){"marker"===a.tagName&&!1!==a.render&&this.renderer.addMarker(a.id,a)},this)});return c});u(c,"Extensions/Annotations/Controllables/ControllablePath.js",[c["Extensions/Annotations/Mixins/ControllableMixin.js"],
c["Core/Globals.js"],c["Extensions/Annotations/Mixins/MarkerMixin.js"],c["Core/Utilities.js"]],function(f,c,m,q){var h=q.extend,r="rgba(192,192,192,"+(c.svg?.0001:.002)+")";return function(){function e(b,a,d){this.addControlPoints=f.addControlPoints;this.anchor=f.anchor;this.attr=f.attr;this.attrsFromOptions=f.attrsFromOptions;this.destroy=f.destroy;this.getPointsOptions=f.getPointsOptions;this.init=f.init;this.linkPoints=f.linkPoints;this.point=f.point;this.rotate=f.rotate;this.scale=f.scale;this.setControlPointsVisibility=
f.setControlPointsVisibility;this.setMarkers=m.setItemMarkers;this.transform=f.transform;this.transformPoint=f.transformPoint;this.translate=f.translate;this.translatePoint=f.translatePoint;this.translateShape=f.translateShape;this.update=f.update;this.type="path";this.init(b,a,d);this.collection="shapes"}e.prototype.toD=function(){var b=this.options.d;if(b)return"function"===typeof b?b.call(this):b;b=this.points;var a=b.length,d=a,g=b[0],k=d&&this.anchor(g).absolutePosition,e=0,f=[];if(k)for(f.push(["M",
k.x,k.y]);++e<a&&d;)g=b[e],d=g.command||"L",k=this.anchor(g).absolutePosition,"M"===d?f.push([d,k.x,k.y]):"L"===d?f.push([d,k.x,k.y]):"Z"===d&&f.push([d]),d=g.series.visible;return d?this.chart.renderer.crispLine(f,this.graphic.strokeWidth()):null};e.prototype.shouldBeDrawn=function(){return f.shouldBeDrawn.call(this)||!!this.options.d};e.prototype.render=function(b){var a=this.options,d=this.attrsFromOptions(a);this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(d).add(b);a.className&&
this.graphic.addClass(a.className);this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(b);this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:r,fill:r,"stroke-width":this.graphic.strokeWidth()+2*a.snap});f.render.call(this);h(this.graphic,{markerStartSetter:m.markerStartSetter,markerEndSetter:m.markerEndSetter});this.setMarkers(this)};e.prototype.redraw=function(b){var a=this.toD(),d=b?"animate":"attr";
a?(this.graphic[d]({d:a}),this.tracker[d]({d:a})):(this.graphic.attr({d:"M 0 -9000000000"}),this.tracker.attr({d:"M 0 -9000000000"}));this.graphic.placed=this.tracker.placed=!!a;f.redraw.call(this,b)};e.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"};return e}()});u(c,"Extensions/Annotations/Controllables/ControllableRect.js",[c["Extensions/Annotations/Mixins/ControllableMixin.js"],c["Extensions/Annotations/Controllables/ControllablePath.js"],
c["Core/Utilities.js"]],function(f,c,m){var h=m.merge;return function(){function l(c,e,b){this.addControlPoints=f.addControlPoints;this.anchor=f.anchor;this.attr=f.attr;this.attrsFromOptions=f.attrsFromOptions;this.destroy=f.destroy;this.getPointsOptions=f.getPointsOptions;this.init=f.init;this.linkPoints=f.linkPoints;this.point=f.point;this.rotate=f.rotate;this.scale=f.scale;this.setControlPointsVisibility=f.setControlPointsVisibility;this.shouldBeDrawn=f.shouldBeDrawn;this.transform=f.transform;
this.transformPoint=f.transformPoint;this.translatePoint=f.translatePoint;this.translateShape=f.translateShape;this.update=f.update;this.type="rect";this.translate=f.translateShape;this.init(c,e,b);this.collection="shapes"}l.prototype.render=function(c){var e=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9E9,0,0).attr(e).add(c);f.render.call(this)};l.prototype.redraw=function(c){var e=this.anchor(this.points[0]).absolutePosition;if(e)this.graphic[c?"animate":
"attr"]({x:e.x,y:e.y,width:this.options.width,height:this.options.height});else this.attr({x:0,y:-9E9});this.graphic.placed=!!e;f.redraw.call(this,c)};l.attrsMap=h(c.attrsMap,{width:"width",height:"height"});return l}()});u(c,"Extensions/Annotations/Controllables/ControllableCircle.js",[c["Extensions/Annotations/Mixins/ControllableMixin.js"],c["Extensions/Annotations/Controllables/ControllablePath.js"],c["Core/Utilities.js"]],function(f,c,m){var h=m.merge;return function(){function l(c,e,b){this.addControlPoints=
f.addControlPoints;this.anchor=f.anchor;this.attr=f.attr;this.attrsFromOptions=f.attrsFromOptions;this.destroy=f.destroy;this.getPointsOptions=f.getPointsOptions;this.init=f.init;this.linkPoints=f.linkPoints;this.point=f.point;this.rotate=f.rotate;this.scale=f.scale;this.setControlPointsVisibility=f.setControlPointsVisibility;this.shouldBeDrawn=f.shouldBeDrawn;this.transform=f.transform;this.transformPoint=f.transformPoint;this.translatePoint=f.translatePoint;this.translateShape=f.translateShape;
this.update=f.update;this.type="circle";this.translate=f.translateShape;this.init(c,e,b);this.collection="shapes"}l.prototype.render=function(c){var e=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9E9,0).attr(e).add(c);f.render.call(this)};l.prototype.redraw=function(c){var e=this.anchor(this.points[0]).absolutePosition;if(e)this.graphic[c?"animate":"attr"]({x:e.x,y:e.y,r:this.options.r});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!e;f.redraw.call(this,
c)};l.prototype.setRadius=function(c){this.options.r=c};l.attrsMap=h(c.attrsMap,{r:"r"});return l}()});u(c,"Extensions/Annotations/Controllables/ControllableLabel.js",[c["Extensions/Annotations/Mixins/ControllableMixin.js"],c["Extensions/Annotations/MockPoint.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Tooltip.js"],c["Core/Utilities.js"]],function(c,h,m,q,l){var f=l.extend,e=l.format,b=l.isNumber,a=l.pick;l=function(){function d(a,d,b){this.addControlPoints=c.addControlPoints;this.attr=c.attr;
this.attrsFromOptions=c.attrsFromOptions;this.destroy=c.destroy;this.getPointsOptions=c.getPointsOptions;this.init=c.init;this.linkPoints=c.linkPoints;this.point=c.point;this.rotate=c.rotate;this.scale=c.scale;this.setControlPointsVisibility=c.setControlPointsVisibility;this.shouldBeDrawn=c.shouldBeDrawn;this.transform=c.transform;this.transformPoint=c.transformPoint;this.translateShape=c.translateShape;this.update=c.update;this.init(a,d,b);this.collection="labels"}d.alignedPosition=function(a,d){var b=
a.align,g=a.verticalAlign,k=(d.x||0)+(a.x||0),e=(d.y||0)+(a.y||0),c,f;"right"===b?c=1:"center"===b&&(c=2);c&&(k+=(d.width-(a.width||0))/c);"bottom"===g?f=1:"middle"===g&&(f=2);f&&(e+=(d.height-(a.height||0))/f);return{x:Math.round(k),y:Math.round(e)}};d.justifiedOptions=function(a,d,b,e){var g=b.align,k=b.verticalAlign,c=d.box?0:d.padding||0,f=d.getBBox();d={align:g,verticalAlign:k,x:b.x,y:b.y,width:d.width,height:d.height};b=e.x-a.plotLeft;var y=e.y-a.plotTop;e=b+c;0>e&&("right"===g?d.align="left":
d.x=-e);e=b+f.width-c;e>a.plotWidth&&("left"===g?d.align="right":d.x=a.plotWidth-e);e=y+c;0>e&&("bottom"===k?d.verticalAlign="top":d.y=-e);e=y+f.height-c;e>a.plotHeight&&("top"===k?d.verticalAlign="bottom":d.y=a.plotHeight-e);return d};d.prototype.translatePoint=function(a,d){c.translatePoint.call(this,a,d,0)};d.prototype.translate=function(a,d){var b=this.annotation.chart,g=this.annotation.userOptions,k=b.annotations.indexOf(this.annotation);k=b.options.annotations[k];b.inverted&&(b=a,a=d,d=b);this.options.x+=
a;this.options.y+=d;k[this.collection][this.index].x=this.options.x;k[this.collection][this.index].y=this.options.y;g[this.collection][this.index].x=this.options.x;g[this.collection][this.index].y=this.options.y};d.prototype.render=function(a){var b=this.options,g=this.attrsFromOptions(b),e=b.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,b.shape,null,null,b.useHTML,null,"annotation-label").attr(g).add(a);this.annotation.chart.styledMode||("contrast"===e.color&&(e.color=this.annotation.chart.renderer.getContrast(-1<
d.shapesWithoutBackground.indexOf(b.shape)?"#FFFFFF":b.backgroundColor)),this.graphic.css(b.style).shadow(b.shadow));b.className&&this.graphic.addClass(b.className);this.graphic.labelrank=b.labelrank;c.render.call(this)};d.prototype.redraw=function(a){var d=this.options,b=this.text||d.format||d.text,g=this.graphic,n=this.points[0];g.attr({text:b?e(b,n.getLabelConfig(),this.annotation.chart):d.formatter.call(n,this)});d=this.anchor(n);(b=this.position(d))?(g.alignAttr=b,b.anchorX=d.absolutePosition.x,
b.anchorY=d.absolutePosition.y,g[a?"animate":"attr"](b)):g.attr({x:0,y:-9999});g.placed=!!b;c.redraw.call(this,a)};d.prototype.anchor=function(a){var d=c.anchor.apply(this,arguments),b=this.options.x||0,g=this.options.y||0;d.absolutePosition.x-=b;d.absolutePosition.y-=g;d.relativePosition.x-=b;d.relativePosition.y-=g;return d};d.prototype.position=function(b){var g=this.graphic,e=this.annotation.chart,c=this.points[0],n=this.options,t=b.absolutePosition,p=b.relativePosition;if(b=c.series.visible&&
h.prototype.isInsidePlot.call(c)){if(n.distance)var w=q.prototype.getPosition.call({chart:e,distance:a(n.distance,16)},g.width,g.height,{plotX:p.x,plotY:p.y,negative:c.negative,ttBelow:c.ttBelow,h:p.height||p.width});else n.positioner?w=n.positioner.call(this):(c={x:t.x,y:t.y,width:0,height:0},w=d.alignedPosition(f(n,{width:g.width,height:g.height}),c),"justify"===this.options.overflow&&(w=d.alignedPosition(d.justifiedOptions(e,g,n,w),c)));n.crop&&(n=w.x-e.plotLeft,c=w.y-e.plotTop,b=e.isInsidePlot(n,
c)&&e.isInsidePlot(n+g.width,c+g.height))}return b?w:null};d.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"};d.shapesWithoutBackground=["connector"];return d}();m.prototype.symbols.connector=function(d,a,e,c,f){var g=f&&f.anchorX;f=f&&f.anchorY;var k=e/2;if(b(g)&&b(f)){var y=[["M",g,f]];var w=a-f;0>w&&(w=-c-w);w<e&&(k=g<d+e/2?w:e-w);f>a+c?y.push(["L",d+k,a+c]):f<a?y.push(["L",d+k,a]):g<d?y.push(["L",d,a+c/2]):g>d+
e&&y.push(["L",d+e,a+c/2])}return y||[]};return l});u(c,"Extensions/Annotations/Controllables/ControllableImage.js",[c["Extensions/Annotations/Controllables/ControllableLabel.js"],c["Extensions/Annotations/Mixins/ControllableMixin.js"]],function(c,h){return function(){function f(c,f,r){this.addControlPoints=h.addControlPoints;this.anchor=h.anchor;this.attr=h.attr;this.attrsFromOptions=h.attrsFromOptions;this.destroy=h.destroy;this.getPointsOptions=h.getPointsOptions;this.init=h.init;this.linkPoints=
h.linkPoints;this.point=h.point;this.rotate=h.rotate;this.scale=h.scale;this.setControlPointsVisibility=h.setControlPointsVisibility;this.shouldBeDrawn=h.shouldBeDrawn;this.transform=h.transform;this.transformPoint=h.transformPoint;this.translatePoint=h.translatePoint;this.translateShape=h.translateShape;this.update=h.update;this.type="image";this.translate=h.translateShape;this.init(c,f,r);this.collection="shapes"}f.prototype.render=function(c){var f=this.attrsFromOptions(this.options),r=this.options;
this.graphic=this.annotation.chart.renderer.image(r.src,0,-9E9,r.width,r.height).attr(f).add(c);this.graphic.width=r.width;this.graphic.height=r.height;h.render.call(this)};f.prototype.redraw=function(f){var l=this.anchor(this.points[0]);if(l=c.prototype.position.call(this,l))this.graphic[f?"animate":"attr"]({x:l.x,y:l.y});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!l;h.redraw.call(this,f)};f.attrsMap={width:"width",height:"height",zIndex:"zIndex"};return f}()});u(c,"Extensions/Annotations/Annotations.js",
[c["Core/Animation/AnimationUtilities.js"],c["Core/Chart/Chart.js"],c["Extensions/Annotations/Mixins/ControllableMixin.js"],c["Extensions/Annotations/Controllables/ControllableRect.js"],c["Extensions/Annotations/Controllables/ControllableCircle.js"],c["Extensions/Annotations/Controllables/ControllablePath.js"],c["Extensions/Annotations/Controllables/ControllableImage.js"],c["Extensions/Annotations/Controllables/ControllableLabel.js"],c["Extensions/Annotations/ControlPoint.js"],c["Extensions/Annotations/Mixins/EventEmitterMixin.js"],
c["Core/Globals.js"],c["Extensions/Annotations/MockPoint.js"],c["Core/Pointer.js"],c["Core/Utilities.js"]],function(c,h,m,q,l,r,e,b,a,d,g,k,y,v){var n=c.getDeferredAnimation;c=h.prototype;var f=v.addEvent,p=v.defined,w=v.destroyObjectProperties,A=v.erase;h=v.extend;var C=v.find,B=v.fireEvent,x=v.merge,z=v.pick,E=v.splat;v=v.wrap;var D=function(){function g(a,d){this.annotation=void 0;this.coll="annotations";this.shapesGroup=this.labelsGroup=this.labelCollector=this.group=this.graphic=this.animationConfig=
this.collection=void 0;this.chart=a;this.points=[];this.controlPoints=[];this.coll="annotations";this.labels=[];this.shapes=[];this.options=x(this.defaultOptions,d);this.userOptions=d;d=this.getLabelsAndShapesOptions(this.options,d);this.options.labels=d.labels;this.options.shapes=d.shapes;this.init(a,this.options)}g.prototype.init=function(){var a=this.chart,d=this.options.animation;this.linkPoints();this.addControlPoints();this.addShapes();this.addLabels();this.setLabelCollector();this.animationConfig=
n(a,d)};g.prototype.getLabelsAndShapesOptions=function(a,d){var b={};["labels","shapes"].forEach(function(g){a[g]&&(b[g]=E(d[g]).map(function(d,b){return x(a[g][b],d)}))});return b};g.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(a,d){a=this.initShape(a,d);x(!0,this.options.shapes[d],a.options)},this)};g.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(a,d){a=this.initLabel(a,d);x(!0,this.options.labels[d],a.options)},this)};g.prototype.addClipPaths=
function(){this.setClipAxes();this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))};g.prototype.setClipAxes=function(){var a=this.chart.xAxis,d=this.chart.yAxis,b=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(b,g){return[a[g&&g.point&&g.point.xAxis]||b[0],d[g&&g.point&&g.point.yAxis]||b[1]]},[]);this.clipXAxis=b[0];this.clipYAxis=b[1]};g.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,
y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}};g.prototype.setLabelCollector=function(){var a=this;a.labelCollector=function(){return a.labels.reduce(function(a,d){d.options.allowOverlap||a.push(d.graphic);return a},[])};a.chart.labelCollectors.push(a.labelCollector)};g.prototype.setOptions=function(a){this.options=x(this.defaultOptions,a)};g.prototype.redraw=function(a){this.linkPoints();this.graphic||this.render();this.clipRect&&this.clipRect.animate(this.getClipBox());
this.redrawItems(this.shapes,a);this.redrawItems(this.labels,a);m.redraw.call(this,a)};g.prototype.redrawItems=function(a,d){for(var b=a.length;b--;)this.redrawItem(a[b],d)};g.prototype.renderItems=function(a){for(var d=a.length;d--;)this.renderItem(a[d])};g.prototype.render=function(){var a=this.chart.renderer;this.graphic=a.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add();this.shapesGroup=a.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip);
this.labelsGroup=a.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic);this.addClipPaths();this.clipRect&&this.graphic.clip(this.clipRect);this.renderItems(this.shapes);this.renderItems(this.labels);this.addEvents();m.render.call(this)};g.prototype.setVisibility=function(a){var d=this.options;a=z(a,!d.visible);this.graphic.attr("visibility",a?"visible":"hidden");a||this.setControlPointsVisibility(!1);d.visible=a};g.prototype.setControlPointsVisibility=function(a){var d=function(d){d.setControlPointsVisibility(a)};
m.setControlPointsVisibility.call(this,a);this.shapes.forEach(d);this.labels.forEach(d)};g.prototype.destroy=function(){var a=this.chart,b=function(a){a.destroy()};this.labels.forEach(b);this.shapes.forEach(b);this.clipYAxis=this.clipXAxis=null;A(a.labelCollectors,this.labelCollector);d.destroy.call(this);m.destroy.call(this);w(this,a)};g.prototype.remove=function(){return this.chart.removeAnnotation(this)};g.prototype.update=function(a,d){var b=this.chart,g=this.getLabelsAndShapesOptions(this.userOptions,
a),e=b.annotations.indexOf(this);a=x(!0,this.userOptions,a);a.labels=g.labels;a.shapes=g.shapes;this.destroy();this.constructor(b,a);b.options.annotations[e]=a;this.isUpdating=!0;z(d,!0)&&b.redraw();B(this,"afterUpdate");this.isUpdating=!1};g.prototype.initShape=function(a,d){a=x(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},a);d=new g.shapesMap[a.type](this,a,d);d.itemType="shape";this.shapes.push(d);return d};g.prototype.initLabel=function(a,d){a=x(this.options.labelOptions,
{controlPointOptions:this.options.controlPointOptions},a);d=new b(this,a,d);d.itemType="label";this.labels.push(d);return d};g.prototype.redrawItem=function(a,d){a.linkPoints();a.shouldBeDrawn()?(a.graphic||this.renderItem(a),a.redraw(z(d,!0)&&a.graphic.placed),a.points.length&&this.adjustVisibility(a)):this.destroyItem(a)};g.prototype.adjustVisibility=function(a){var d=!1,b=a.graphic;a.points.forEach(function(a){!1!==a.series.visible&&!1!==a.visible&&(d=!0)});d?"hidden"===b.visibility&&b.show():
b.hide()};g.prototype.destroyItem=function(a){A(this[a.itemType+"s"],a);a.destroy()};g.prototype.renderItem=function(a){a.render("label"===a.itemType?this.labelsGroup:this.shapesGroup)};g.ControlPoint=a;g.MockPoint=k;g.shapesMap={rect:q,circle:l,path:r,image:e};g.types={};return g}();x(!0,D.prototype,m,d,x(D.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",
borderColor:"black",borderRadius:3,borderWidth:1,className:"",crop:!1,formatter:function(){return p(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:"black","stroke-width":2,
fill:"white"},visible:!1,events:{}},events:{},zIndex:6}}));g.extendAnnotation=function(a,d,b,g){d=d||D;x(!0,a.prototype,d.prototype,b);a.prototype.defaultOptions=x(a.prototype.defaultOptions,g||{})};h(c,{initAnnotation:function(a){a=new (D.types[a.type]||D)(this,a);this.annotations.push(a);return a},addAnnotation:function(a,d){a=this.initAnnotation(a);this.options.annotations.push(a.options);z(d,!0)&&(a.redraw(),a.graphic.attr({opacity:1}));return a},removeAnnotation:function(a){var d=this.annotations,
b="annotations"===a.coll?a:C(d,function(d){return d.options.id===a});b&&(B(b,"remove"),A(this.options.annotations,b.options),A(d,b),b.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox);this.annotations.forEach(function(a){a.redraw();a.graphic.animate({opacity:1},a.animationConfig)})}});c.collectionsWithUpdate.push("annotations");c.collectionsWithInit.annotations=[c.addAnnotation];c.callbacks.push(function(a){a.annotations=[];a.options.annotations||(a.options.annotations=[]);
a.plotBoxClip=this.renderer.clipRect(this.plotBox);a.controlPointsGroup=a.renderer.g("control-points").attr({zIndex:99}).clip(a.plotBoxClip).add();a.options.annotations.forEach(function(d,b){d=a.initAnnotation(d);a.options.annotations[b]=d.options});a.drawAnnotations();f(a,"redraw",a.drawAnnotations);f(a,"destroy",function(){a.plotBoxClip.destroy();a.controlPointsGroup.destroy()});f(a,"exportData",function(d){var b,g,e,c,k,f,n,t,y=a.annotations,p=(this.options.exporting&&this.options.exporting.csv||
{}).columnHeaderFormatter,x=!d.dataRows[1].xValues,w=null===(g=null===(b=a.options.lang)||void 0===b?void 0:b.exportData)||void 0===g?void 0:g.annotationHeader;b=function(a){if(p){var d=p(a);if(!1!==d)return d}d=w+" "+a;return x?{columnTitle:d,topLevelColumnTitle:d}:d};var B=d.dataRows[0].length,h=null===(k=null===(c=null===(e=a.options.exporting)||void 0===e?void 0:e.csv)||void 0===c?void 0:c.annotations)||void 0===k?void 0:k.itemDelimiter,v=null===(t=null===(n=null===(f=a.options.exporting)||void 0===
f?void 0:f.csv)||void 0===n?void 0:n.annotations)||void 0===t?void 0:t.join;y.forEach(function(a){a.options.labelOptions.includeInDataExport&&a.labels.forEach(function(a){if(a.options.text){var b=a.options.text;a.points.forEach(function(a){var g=a.x,e=a.series.xAxis?a.series.xAxis.options.index:-1,c=!1;if(-1===e){a=d.dataRows[0].length;for(var k=Array(a),f=0;f<a;++f)k[f]="";k.push(b);k.xValues=[];k.xValues[e]=g;d.dataRows.push(k);c=!0}c||d.dataRows.forEach(function(a,d){!c&&a.xValues&&void 0!==e&&
g===a.xValues[e]&&(v&&a.length>B?a[a.length-1]+=h+b:a.push(b),c=!0)});if(!c){a=d.dataRows[0].length;k=Array(a);for(f=0;f<a;++f)k[f]="";k[0]=g;k.push(b);k.xValues=[];void 0!==e&&(k.xValues[e]=g);d.dataRows.push(k)}})}})});var z=0;d.dataRows.forEach(function(a){z=Math.max(z,a.length)});e=z-d.dataRows[0].length;for(c=0;c<e;c++)k=b(c+1),x?(d.dataRows[0].push(k.topLevelColumnTitle),d.dataRows[1].push(k.columnTitle)):d.dataRows[0].push(k)})});v(y.prototype,"onContainerMouseDown",function(a){this.chart.hasDraggedAnnotation||
a.apply(this,Array.prototype.slice.call(arguments,1))});return g.Annotation=D});u(c,"Extensions/Annotations/Types/BasicAnnotation.js",[c["Extensions/Annotations/Annotations.js"],c["Extensions/Annotations/MockPoint.js"],c["Core/Utilities.js"]],function(c,h,m){var f=this&&this.__extends||function(){var c=function(e,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,d){a.__proto__=d}||function(a,d){for(var b in d)d.hasOwnProperty(b)&&(a[b]=d[b])};return c(e,b)};return function(e,
b){function a(){this.constructor=e}c(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}();m=m.merge;var l=function(r){function e(b,a){return r.call(this,b,a)||this}f(e,r);e.prototype.addControlPoints=function(){var b=this.options,a=e.basicControlPoints,d=this.basicType;(b.labels||b.shapes).forEach(function(b){b.controlPoints=a[d]})};e.prototype.init=function(){var b=this.options;b.shapes?(delete b.labelOptions,this.basicType="circle"===b.shapes[0].type?"circle":"rectangle"):
(delete b.shapes,this.basicType="label");c.prototype.init.apply(this,arguments)};e.basicControlPoints={label:[{symbol:"triangle-down",positioner:function(b){if(!b.graphic.placed)return{x:0,y:-9E7};b=h.pointToPixels(b.points[0]);return{x:b.x-this.graphic.width/2,y:b.y-this.graphic.height/2}},events:{drag:function(b,a){b=this.mouseMoveToTranslation(b);a.translatePoint(b.x,b.y);a.annotation.userOptions.labels[0].point=a.options.point;a.redraw(!1)}}},{symbol:"square",positioner:function(b){return b.graphic.placed?
{x:b.graphic.alignAttr.x-this.graphic.width/2,y:b.graphic.alignAttr.y-this.graphic.height/2}:{x:0,y:-9E7}},events:{drag:function(b,a){b=this.mouseMoveToTranslation(b);a.translate(b.x,b.y);a.annotation.userOptions.labels[0].point=a.options.point;a.redraw(!1)}}}],rectangle:[{positioner:function(b){b=h.pointToPixels(b.points[2]);return{x:b.x-4,y:b.y-4}},events:{drag:function(b,a){var d=a.annotation,g=this.chart.pointer.getCoordinates(b);b=g.xAxis[0].value;g=g.yAxis[0].value;var c=a.options.points;c[1].x=
b;c[2].x=b;c[2].y=g;c[3].y=g;d.userOptions.shapes[0].points=a.options.points;d.redraw(!1)}}}],circle:[{positioner:function(b){var a=h.pointToPixels(b.points[0]);b=b.options.r;return{x:a.x+b*Math.cos(Math.PI/4)-this.graphic.width/2,y:a.y+b*Math.sin(Math.PI/4)-this.graphic.height/2}},events:{drag:function(b,a){var d=a.annotation;b=this.mouseMoveToTranslation(b);a.setRadius(Math.max(a.options.r+b.y/Math.sin(Math.PI/4),5));d.userOptions.shapes[0].r=a.options.r;d.userOptions.shapes[0].point=a.options.point;
a.redraw(!1)}}}]};return e}(c);l.prototype.defaultOptions=m(c.prototype.defaultOptions,{});return c.types.basicAnnotation=l});u(c,"Extensions/Annotations/Types/CrookedLine.js",[c["Extensions/Annotations/Annotations.js"],c["Extensions/Annotations/ControlPoint.js"],c["Extensions/Annotations/MockPoint.js"],c["Core/Utilities.js"]],function(c,h,m,q){var f=this&&this.__extends||function(){var c=function(b,a){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,
b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return c(b,a)};return function(b,a){function d(){this.constructor=b}c(b,a);b.prototype=null===a?Object.create(a):(d.prototype=a.prototype,new d)}}(),r=q.merge;q=function(c){function b(a,d){return c.call(this,a,d)||this}f(b,c);b.prototype.setClipAxes=function(){this.clipXAxis=this.chart.xAxis[this.options.typeOptions.xAxis];this.clipYAxis=this.chart.yAxis[this.options.typeOptions.yAxis]};b.prototype.getPointsOptions=function(){var a=this.options.typeOptions;
return(a.points||[]).map(function(d){d.xAxis=a.xAxis;d.yAxis=a.yAxis;return d})};b.prototype.getControlPointsOptions=function(){return this.getPointsOptions()};b.prototype.addControlPoints=function(){this.getControlPointsOptions().forEach(function(a,d){d=new h(this.chart,this,r(this.options.controlPointOptions,a.controlPoint),d);this.controlPoints.push(d);a.controlPoint=d.options},this)};b.prototype.addShapes=function(){var a=this.options.typeOptions,d=this.initShape(r(a.line,{type:"path",points:this.points.map(function(a,
d){return function(a){return a.annotation.points[d]}})}),!1);a.line=d.options};return b}(c);q.prototype.defaultOptions=r(c.prototype.defaultOptions,{typeOptions:{xAxis:0,yAxis:0,line:{fill:"none"}},controlPointOptions:{positioner:function(c){var b=this.graphic;c=m.pointToPixels(c.points[this.index]);return{x:c.x-b.width/2,y:c.y-b.height/2}},events:{drag:function(c,b){b.chart.isInsidePlot(c.chartX-b.chart.plotLeft,c.chartY-b.chart.plotTop)&&(c=this.mouseMoveToTranslation(c),b.translatePoint(c.x,c.y,
this.index),b.options.typeOptions.points[this.index].x=b.points[this.index].x,b.options.typeOptions.points[this.index].y=b.points[this.index].y,b.redraw(!1))}}}});return c.types.crookedLine=q});u(c,"Extensions/Annotations/Types/ElliottWave.js",[c["Extensions/Annotations/Annotations.js"],c["Extensions/Annotations/Types/CrookedLine.js"],c["Core/Utilities.js"]],function(c,h,m){var f=this&&this.__extends||function(){var c=function(e,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,
d){a.__proto__=d}||function(a,d){for(var b in d)d.hasOwnProperty(b)&&(a[b]=d[b])};return c(e,b)};return function(e,b){function a(){this.constructor=e}c(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),l=m.merge;m=function(c){function e(b,a){return c.call(this,b,a)||this}f(e,c);e.prototype.addLabels=function(){this.getPointsOptions().forEach(function(b,a){var d=this.initLabel(l(b.label,{text:this.options.typeOptions.labels[a],point:function(d){return d.annotation.points[a]}}),
!1);b.label=d.options},this)};return e}(h);m.prototype.defaultOptions=l(h.prototype.defaultOptions,{typeOptions:{labels:"(0) (A) (B) (C) (D) (E)".split(" "),line:{strokeWidth:1}},labelOptions:{align:"center",allowOverlap:!0,crop:!0,overflow:"none",type:"rect",backgroundColor:"none",borderWidth:0,y:-5}});return c.types.elliottWave=m});u(c,"Extensions/Annotations/Types/Tunnel.js",[c["Extensions/Annotations/Annotations.js"],c["Extensions/Annotations/ControlPoint.js"],c["Extensions/Annotations/Types/CrookedLine.js"],
c["Extensions/Annotations/MockPoint.js"],c["Core/Utilities.js"]],function(c,h,m,q,l){var f=this&&this.__extends||function(){var b=function(a,d){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,d){a.__proto__=d}||function(a,d){for(var b in d)d.hasOwnProperty(b)&&(a[b]=d[b])};return b(a,d)};return function(a,d){function g(){this.constructor=a}b(a,d);a.prototype=null===d?Object.create(d):(g.prototype=d.prototype,new g)}}(),e=l.merge;l=function(b){function a(a,g){return b.call(this,
a,g)||this}f(a,b);a.prototype.getPointsOptions=function(){var a=m.prototype.getPointsOptions.call(this);a[2]=this.heightPointOptions(a[1]);a[3]=this.heightPointOptions(a[0]);return a};a.prototype.getControlPointsOptions=function(){return this.getPointsOptions().slice(0,2)};a.prototype.heightPointOptions=function(a){a=e(a);a.y+=this.options.typeOptions.height;return a};a.prototype.addControlPoints=function(){m.prototype.addControlPoints.call(this);var a=this.options,b=a.typeOptions;a=new h(this.chart,
this,e(a.controlPointOptions,b.heightControlPoint),2);this.controlPoints.push(a);b.heightControlPoint=a.options};a.prototype.addShapes=function(){this.addLine();this.addBackground()};a.prototype.addLine=function(){var a=this.initShape(e(this.options.typeOptions.line,{type:"path",points:[this.points[0],this.points[1],function(a){a=q.pointToOptions(a.annotation.points[2]);a.command="M";return a},this.points[3]]}),!1);this.options.typeOptions.line=a.options};a.prototype.addBackground=function(){var a=
this.initShape(e(this.options.typeOptions.background,{type:"path",points:this.points.slice()}));this.options.typeOptions.background=a.options};a.prototype.translateSide=function(a,b,c){c=Number(c);var d=0===c?3:2;this.translatePoint(a,b,c);this.translatePoint(a,b,d)};a.prototype.translateHeight=function(a){this.translatePoint(0,a,2);this.translatePoint(0,a,3);this.options.typeOptions.height=this.points[3].y-this.points[0].y};return a}(m);l.prototype.defaultOptions=e(m.prototype.defaultOptions,{typeOptions:{xAxis:0,
yAxis:0,background:{fill:"rgba(130, 170, 255, 0.4)",strokeWidth:0},line:{strokeWidth:1},height:-2,heightControlPoint:{positioner:function(b){var a=q.pointToPixels(b.points[2]);b=q.pointToPixels(b.points[3]);var d=(a.x+b.x)/2;return{x:d-this.graphic.width/2,y:(b.y-a.y)/(b.x-a.x)*(d-a.x)+a.y-this.graphic.height/2}},events:{drag:function(b,a){a.chart.isInsidePlot(b.chartX-a.chart.plotLeft,b.chartY-a.chart.plotTop)&&(a.translateHeight(this.mouseMoveToTranslation(b).y),a.redraw(!1))}}}},controlPointOptions:{events:{drag:function(b,
a){a.chart.isInsidePlot(b.chartX-a.chart.plotLeft,b.chartY-a.chart.plotTop)&&(b=this.mouseMoveToTranslation(b),a.translateSide(b.x,b.y,this.index),a.redraw(!1))}}}});return c.types.tunnel=l});u(c,"Extensions/Annotations/Types/InfinityLine.js",[c["Extensions/Annotations/Annotations.js"],c["Extensions/Annotations/Types/CrookedLine.js"],c["Extensions/Annotations/MockPoint.js"],c["Core/Utilities.js"]],function(c,h,m,q){var f=this&&this.__extends||function(){var c=function(b,a){c=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return c(b,a)};return function(b,a){function d(){this.constructor=b}c(b,a);b.prototype=null===a?Object.create(a):(d.prototype=a.prototype,new d)}}(),r=q.merge;q=function(c){function b(a,d){return c.call(this,a,d)||this}f(b,c);b.edgePoint=function(a,d){return function(g){g=g.annotation;var c=g.points,e=g.options.typeOptions.type;"horizontalLine"===e?c=[c[0],new m(g.chart,c[0].target,
{x:c[0].x+1,y:c[0].y,xAxis:c[0].options.xAxis,yAxis:c[0].options.yAxis})]:"verticalLine"===e&&(c=[c[0],new m(g.chart,c[0].target,{x:c[0].x,y:c[0].y+1,xAxis:c[0].options.xAxis,yAxis:c[0].options.yAxis})]);return b.findEdgePoint(c[a],c[d])}};b.findEdgeCoordinate=function(a,d,b,c){var g="x"===b?"y":"x";return(d[b]-a[b])*(c-a[g])/(d[g]-a[g])+a[b]};b.findEdgePoint=function(a,d){var c=a.series.xAxis,e=d.series.yAxis,f=m.pointToPixels(a),h=m.pointToPixels(d),n=h.x-f.x,t=h.y-f.y;d=c.left;var p=d+c.width;
c=e.top;e=c+e.height;var w=0>n?d:p,l=0>t?c:e;p={x:0===n?f.x:w,y:0===t?f.y:l};0!==n&&0!==t&&(n=b.findEdgeCoordinate(f,h,"y",w),f=b.findEdgeCoordinate(f,h,"x",l),n>=c&&n<=e?(p.x=w,p.y=n):(p.x=f,p.y=l));p.x-=d;p.y-=c;a.series.chart.inverted&&(a=p.x,p.x=p.y,p.y=a);return p};b.prototype.addShapes=function(){var a=this.options.typeOptions,d=[this.points[0],b.endEdgePoint];a.type.match(/Line/g)&&(d[0]=b.startEdgePoint);d=this.initShape(r(a.line,{type:"path",points:d}),!1);a.line=d.options};b.endEdgePoint=
b.edgePoint(0,1);b.startEdgePoint=b.edgePoint(1,0);return b}(h);q.prototype.defaultOptions=r(h.prototype.defaultOptions,{});return c.types.infinityLine=q});u(c,"Extensions/Annotations/Types/Fibonacci.js",[c["Extensions/Annotations/Annotations.js"],c["Extensions/Annotations/MockPoint.js"],c["Extensions/Annotations/Types/Tunnel.js"],c["Core/Utilities.js"]],function(c,h,m,q){var f=this&&this.__extends||function(){var b=function(a,d){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,
d){a.__proto__=d}||function(a,d){for(var b in d)d.hasOwnProperty(b)&&(a[b]=d[b])};return b(a,d)};return function(a,d){function c(){this.constructor=a}b(a,d);a.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),r=q.merge,e=function(b,a){return function(){var d=this.annotation,c=this.anchor(d.startRetracements[b]).absolutePosition,e=this.anchor(d.endRetracements[b]).absolutePosition;c=[["M",Math.round(c.x),Math.round(c.y)],["L",Math.round(e.x),Math.round(e.y)]];a&&(e=this.anchor(d.endRetracements[b-
1]).absolutePosition,d=this.anchor(d.startRetracements[b-1]).absolutePosition,c.push(["L",Math.round(e.x),Math.round(e.y)],["L",Math.round(d.x),Math.round(d.y)]));return c}};q=function(b){function a(a,c){return b.call(this,a,c)||this}f(a,b);a.prototype.linkPoints=function(){b.prototype.linkPoints.call(this);this.linkRetracementsPoints()};a.prototype.linkRetracementsPoints=function(){var d=this.points,b=d[0].y-d[3].y,c=d[1].y-d[2].y,e=d[0].x,f=d[1].x;a.levels.forEach(function(a,g){var k=d[0].y-b*a;
a=d[1].y-c*a;this.startRetracements=this.startRetracements||[];this.endRetracements=this.endRetracements||[];this.linkRetracementPoint(g,e,k,this.startRetracements);this.linkRetracementPoint(g,f,a,this.endRetracements)},this)};a.prototype.linkRetracementPoint=function(a,b,c,e){var d=e[a],g=this.options.typeOptions;d?(d.options.x=b,d.options.y=c,d.refresh()):e[a]=new h(this.chart,this,{x:b,y:c,xAxis:g.xAxis,yAxis:g.yAxis})};a.prototype.addShapes=function(){a.levels.forEach(function(a,b){this.initShape({type:"path",
d:e(b)},!1);0<b&&this.initShape({type:"path",fill:this.options.typeOptions.backgroundColors[b-1],strokeWidth:0,d:e(b,!0)})},this)};a.prototype.addLabels=function(){a.levels.forEach(function(a,b){var d=this.options.typeOptions;a=this.initLabel(r(d.labels[b],{point:function(a){return h.pointToOptions(a.annotation.startRetracements[b])},text:a.toString()}));d.labels[b]=a.options},this)};a.levels=[0,.236,.382,.5,.618,.786,1];return a}(m);q.prototype.defaultOptions=r(m.prototype.defaultOptions,{typeOptions:{height:2,
backgroundColors:"rgba(130, 170, 255, 0.4);rgba(139, 191, 216, 0.4);rgba(150, 216, 192, 0.4);rgba(156, 229, 161, 0.4);rgba(162, 241, 130, 0.4);rgba(169, 255, 101, 0.4)".split(";"),lineColor:"grey",lineColors:[],labels:[]},labelOptions:{allowOverlap:!0,align:"right",backgroundColor:"none",borderWidth:0,crop:!1,overflow:"none",shape:"rect",style:{color:"grey"},verticalAlign:"middle",y:0}});return c.types.fibonacci=q});u(c,"Extensions/Annotations/Types/Pitchfork.js",[c["Extensions/Annotations/Annotations.js"],
c["Extensions/Annotations/Types/InfinityLine.js"],c["Extensions/Annotations/MockPoint.js"],c["Core/Utilities.js"]],function(c,h,m,q){var f=this&&this.__extends||function(){var c=function(b,a){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return c(b,a)};return function(b,a){function d(){this.constructor=b}c(b,a);b.prototype=null===a?Object.create(a):(d.prototype=a.prototype,new d)}}(),r=q.merge;
q=function(c){function b(a,b){return c.call(this,a,b)||this}f(b,c);b.outerLineEdgePoint=function(a){return function(d){var c=d.annotation,e=c.points;return b.findEdgePoint(e[a],e[0],new m(c.chart,d,c.midPointOptions()))}};b.findEdgePoint=function(a,b,c){b=Math.atan2(c.plotY-b.plotY,c.plotX-b.plotX);return{x:a.plotX+1E7*Math.cos(b),y:a.plotY+1E7*Math.sin(b)}};b.middleLineEdgePoint=function(a){var b=a.annotation;return h.findEdgePoint(b.points[0],new m(b.chart,a,b.midPointOptions()))};b.prototype.midPointOptions=
function(){var a=this.points;return{x:(a[1].x+a[2].x)/2,y:(a[1].y+a[2].y)/2,xAxis:a[0].series.xAxis,yAxis:a[0].series.yAxis}};b.prototype.addShapes=function(){this.addLines();this.addBackgrounds()};b.prototype.addLines=function(){this.initShape({type:"path",points:[this.points[0],b.middleLineEdgePoint]},!1);this.initShape({type:"path",points:[this.points[1],b.topLineEdgePoint]},!1);this.initShape({type:"path",points:[this.points[2],b.bottomLineEdgePoint]},!1)};b.prototype.addBackgrounds=function(){var a=
this.shapes,b=this.options.typeOptions,c=this.initShape(r(b.innerBackground,{type:"path",points:[function(a){var b=a.annotation;a=b.points;b=b.midPointOptions();return{x:(a[1].x+b.x)/2,y:(a[1].y+b.y)/2,xAxis:b.xAxis,yAxis:b.yAxis}},a[1].points[1],a[2].points[1],function(a){var b=a.annotation;a=b.points;b=b.midPointOptions();return{x:(b.x+a[2].x)/2,y:(b.y+a[2].y)/2,xAxis:b.xAxis,yAxis:b.yAxis}}]}));a=this.initShape(r(b.outerBackground,{type:"path",points:[this.points[1],a[1].points[1],a[2].points[1],
this.points[2]]}));b.innerBackground=c.options;b.outerBackground=a.options};b.topLineEdgePoint=b.outerLineEdgePoint(1);b.bottomLineEdgePoint=b.outerLineEdgePoint(0);return b}(h);q.prototype.defaultOptions=r(h.prototype.defaultOptions,{typeOptions:{innerBackground:{fill:"rgba(130, 170, 255, 0.4)",strokeWidth:0},outerBackground:{fill:"rgba(156, 229, 161, 0.4)",strokeWidth:0}}});return c.types.pitchfork=q});u(c,"Extensions/Annotations/Types/VerticalLine.js",[c["Extensions/Annotations/Annotations.js"],
c["Extensions/Annotations/MockPoint.js"],c["Core/Utilities.js"]],function(c,h,m){var f=this&&this.__extends||function(){var c=function(e,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return c(e,b)};return function(e,b){function a(){this.constructor=e}c(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),l=m.merge;m=function(c){function e(b,a){return c.call(this,b,a)||
this}f(e,c);e.connectorFirstPoint=function(b){b=b.annotation;var a=b.points[0],d=h.pointToPixels(a,!0),c=d.y,e=b.options.typeOptions.label.offset;b.chart.inverted&&(c=d.x);return{x:a.x,xAxis:a.series.xAxis,y:c+e}};e.connectorSecondPoint=function(b){var a=b.annotation;b=a.options.typeOptions;var d=a.points[0],c=b.yOffset;a=h.pointToPixels(d,!0)[a.chart.inverted?"x":"y"];0>b.label.offset&&(c*=-1);return{x:d.x,xAxis:d.series.xAxis,y:a+c}};e.prototype.getPointsOptions=function(){return[this.options.typeOptions.point]};
e.prototype.addShapes=function(){var b=this.options.typeOptions,a=this.initShape(l(b.connector,{type:"path",points:[e.connectorFirstPoint,e.connectorSecondPoint]}),!1);b.connector=a.options};e.prototype.addLabels=function(){var b=this.options.typeOptions,a=b.label,d=0,c=a.offset,e=0>a.offset?"bottom":"top",f="center";this.chart.inverted&&(d=a.offset,c=0,e="middle",f=0>a.offset?"right":"left");a=this.initLabel(l(a,{verticalAlign:e,align:f,x:d,y:c}));b.label=a.options};return e}(c);m.prototype.defaultOptions=
l(c.prototype.defaultOptions,{typeOptions:{yOffset:10,label:{offset:-40,point:function(c){return c.annotation.points[0]},allowOverlap:!0,backgroundColor:"none",borderWidth:0,crop:!0,overflow:"none",shape:"rect",text:"{y:.2f}"},connector:{strokeWidth:1,markerEnd:"arrow"}}});return c.types.verticalLine=m});u(c,"Extensions/Annotations/Types/Measure.js",[c["Extensions/Annotations/Annotations.js"],c["Extensions/Annotations/ControlPoint.js"],c["Core/Utilities.js"]],function(c,h,m){var f=this&&this.__extends||
function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),l=m.extend,r=m.isNumber,e=m.merge,b=function(a){function b(b,d){return a.call(this,b,d)||this}f(b,a);b.prototype.init=function(a,d,e){c.prototype.init.call(this,a,d,e);this.resizeY=
this.resizeX=this.offsetY=this.offsetX=0;b.calculations.init.call(this);this.addValues();this.addShapes()};b.prototype.setClipAxes=function(){this.clipXAxis=this.chart.xAxis[this.options.typeOptions.xAxis];this.clipYAxis=this.chart.yAxis[this.options.typeOptions.yAxis]};b.prototype.pointsOptions=function(){return this.options.points};b.prototype.shapePointsOptions=function(){var a=this.options.typeOptions,b=a.xAxis;a=a.yAxis;return[{x:this.xAxisMin,y:this.yAxisMin,xAxis:b,yAxis:a},{x:this.xAxisMax,
y:this.yAxisMin,xAxis:b,yAxis:a},{x:this.xAxisMax,y:this.yAxisMax,xAxis:b,yAxis:a},{x:this.xAxisMin,y:this.yAxisMax,xAxis:b,yAxis:a}]};b.prototype.addControlPoints=function(){var a=this.options.typeOptions.selectType;var b=new h(this.chart,this,this.options.controlPointOptions,0);this.controlPoints.push(b);"xy"!==a&&(b=new h(this.chart,this,this.options.controlPointOptions,1),this.controlPoints.push(b))};b.prototype.addValues=function(a){var d=this.options.typeOptions,c=d.label.formatter;b.calculations.recalculate.call(this,
a);d.label.enabled&&(0<this.labels.length?this.labels[0].text=c&&c.call(this)||b.calculations.defaultFormatter.call(this):this.initLabel(l({shape:"rect",backgroundColor:"none",color:"black",borderWidth:0,dashStyle:"dash",overflow:"none",align:"left",vertical:"top",crop:!0,point:function(a){a=a.annotation;var b=a.chart,c=b.inverted,e=b.yAxis[d.yAxis],g=b.plotTop,f=b.plotLeft;return{x:(c?g:10)+b.xAxis[d.xAxis].toPixels(a.xAxisMin,!c),y:(c?-f+10:g)+e.toPixels(a.yAxisMin)}},text:c&&c.call(this)||b.calculations.defaultFormatter.call(this)},
d.label)))};b.prototype.addShapes=function(){this.addCrosshairs();this.addBackground()};b.prototype.addBackground=function(){"undefined"!==typeof this.shapePointsOptions()[0].x&&this.initShape(l({type:"path",points:this.shapePointsOptions()},this.options.typeOptions.background),!1)};b.prototype.addCrosshairs=function(){var a=this.chart,b=this.options.typeOptions,d=this.options.typeOptions.point,c=a.xAxis[b.xAxis],f=a.yAxis[b.yAxis],t=a.inverted;a=c.toPixels(this.xAxisMin);c=c.toPixels(this.xAxisMax);
var p=f.toPixels(this.yAxisMin),h=f.toPixels(this.yAxisMax),A={point:d,type:"path"};d=[];f=[];t&&(t=a,a=p,p=t,t=c,c=h,h=t);b.crosshairX.enabled&&(d=[["M",a,p+(h-p)/2],["L",c,p+(h-p)/2]]);b.crosshairY.enabled&&(f=[["M",a+(c-a)/2,p],["L",a+(c-a)/2,h]]);0<this.shapes.length?(this.shapes[0].options.d=d,this.shapes[1].options.d=f):(a=e(A,b.crosshairX),b=e(A,b.crosshairY),this.initShape(l({d:d},a),!1),this.initShape(l({d:f},b),!1))};b.prototype.onDrag=function(a){var b=this.mouseMoveToTranslation(a),d=
this.options.typeOptions.selectType;a="y"===d?0:b.x;b="x"===d?0:b.y;this.translate(a,b);this.offsetX+=a;this.offsetY+=b;this.redraw(!1,!1,!0)};b.prototype.resize=function(a,d,c,e){var g=this.shapes[2];"x"===e?0===c?(g.translatePoint(a,0,0),g.translatePoint(a,d,3)):(g.translatePoint(a,0,1),g.translatePoint(a,d,2)):"y"===e?0===c?(g.translatePoint(0,d,0),g.translatePoint(0,d,1)):(g.translatePoint(0,d,2),g.translatePoint(0,d,3)):(g.translatePoint(a,0,1),g.translatePoint(a,d,2),g.translatePoint(0,d,3));
b.calculations.updateStartPoints.call(this,!1,!0,c,a,d);this.options.typeOptions.background.height=Math.abs(this.startYMax-this.startYMin);this.options.typeOptions.background.width=Math.abs(this.startXMax-this.startXMin)};b.prototype.redraw=function(a,d,c){this.linkPoints();this.graphic||this.render();c&&b.calculations.updateStartPoints.call(this,!0,!1);this.clipRect&&this.clipRect.animate(this.getClipBox());this.addValues(d);this.addCrosshairs();this.redrawItems(this.shapes,a);this.redrawItems(this.labels,
a);this.controlPoints.forEach(function(a){a.redraw()})};b.prototype.translate=function(a,b){this.shapes.forEach(function(d){d.translate(a,b)});this.options.typeOptions.point.x=this.startXMin;this.options.typeOptions.point.y=this.startYMin};b.calculations={init:function(){var a=this.options.typeOptions,d=this.chart,c=b.calculations.getPointPos,e=d.inverted,f=d.xAxis[a.xAxis];d=d.yAxis[a.yAxis];var t=a.background,p=e?t.height:t.width;t=e?t.width:t.height;var h=a.selectType,l=e?f.left:d.top;e=e?d.top:
f.left;this.startXMin=a.point.x;this.startYMin=a.point.y;r(p)?this.startXMax=this.startXMin+p:this.startXMax=c(f,this.startXMin,parseFloat(p));r(t)?this.startYMax=this.startYMin-t:this.startYMax=c(d,this.startYMin,parseFloat(t));"x"===h?(this.startYMin=d.toValue(l),this.startYMax=d.toValue(l+d.len)):"y"===h&&(this.startXMin=f.toValue(e),this.startXMax=f.toValue(e+f.len))},recalculate:function(a){var d=b.calculations,c=this.options.typeOptions,e=this.chart.xAxis[c.xAxis];c=this.chart.yAxis[c.yAxis];
var g=b.calculations.getPointPos,f=this.offsetX,p=this.offsetY;this.xAxisMin=g(e,this.startXMin,f);this.xAxisMax=g(e,this.startXMax,f);this.yAxisMin=g(c,this.startYMin,p);this.yAxisMax=g(c,this.startYMax,p);this.min=d.min.call(this);this.max=d.max.call(this);this.average=d.average.call(this);this.bins=d.bins.call(this);a&&this.resize(0,0)},getPointPos:function(a,b,d){return a.toValue(a.toPixels(b)+d)},updateStartPoints:function(a,d,c,e,f){var g=this.options.typeOptions,n=g.selectType,h=this.chart.xAxis[g.xAxis];
g=this.chart.yAxis[g.yAxis];var k=b.calculations.getPointPos,l=this.startXMin,B=this.startXMax,x=this.startYMin,z=this.startYMax,E=this.offsetX,m=this.offsetY;d&&("x"===n?0===c?this.startXMin=k(h,l,e):this.startXMax=k(h,B,e):"y"===n?0===c?this.startYMin=k(g,x,f):this.startYMax=k(g,z,f):(this.startXMax=k(h,B,e),this.startYMax=k(g,z,f)));a&&(this.startXMin=k(h,l,E),this.startXMax=k(h,B,E),this.startYMin=k(g,x,m),this.startYMax=k(g,z,m),this.offsetY=this.offsetX=0)},defaultFormatter:function(){return"Min: "+
this.min+"<br>Max: "+this.max+"<br>Average: "+this.average+"<br>Bins: "+this.bins},getExtremes:function(a,b,d,c){return{xAxisMin:Math.min(b,a),xAxisMax:Math.max(b,a),yAxisMin:Math.min(c,d),yAxisMax:Math.max(c,d)}},min:function(){var a=Infinity,d=this.chart.series,c=b.calculations.getExtremes(this.xAxisMin,this.xAxisMax,this.yAxisMin,this.yAxisMax),e=!1;d.forEach(function(b){b.visible&&"highcharts-navigator-series"!==b.options.id&&b.points.forEach(function(b){!b.isNull&&b.y<a&&b.x>c.xAxisMin&&b.x<=
c.xAxisMax&&b.y>c.yAxisMin&&b.y<=c.yAxisMax&&(a=b.y,e=!0)})});e||(a="");return a},max:function(){var a=-Infinity,d=this.chart.series,c=b.calculations.getExtremes(this.xAxisMin,this.xAxisMax,this.yAxisMin,this.yAxisMax),e=!1;d.forEach(function(b){b.visible&&"highcharts-navigator-series"!==b.options.id&&b.points.forEach(function(b){!b.isNull&&b.y>a&&b.x>c.xAxisMin&&b.x<=c.xAxisMax&&b.y>c.yAxisMin&&b.y<=c.yAxisMax&&(a=b.y,e=!0)})});e||(a="");return a},average:function(){var a="";""!==this.max&&""!==
this.min&&(a=(this.max+this.min)/2);return a},bins:function(){var a=0,d=this.chart.series,c=b.calculations.getExtremes(this.xAxisMin,this.xAxisMax,this.yAxisMin,this.yAxisMax),e=!1;d.forEach(function(b){b.visible&&"highcharts-navigator-series"!==b.options.id&&b.points.forEach(function(b){!b.isNull&&b.x>c.xAxisMin&&b.x<=c.xAxisMax&&b.y>c.yAxisMin&&b.y<=c.yAxisMax&&(a++,e=!0)})});e||(a="");return a}};return b}(c);b.prototype.defaultOptions=e(c.prototype.defaultOptions,{typeOptions:{selectType:"xy",
xAxis:0,yAxis:0,background:{fill:"rgba(130, 170, 255, 0.4)",strokeWidth:0,stroke:void 0},crosshairX:{enabled:!0,zIndex:6,dashStyle:"Dash",markerEnd:"arrow"},crosshairY:{enabled:!0,zIndex:6,dashStyle:"Dash",markerEnd:"arrow"},label:{enabled:!0,style:{fontSize:"11px",color:"#666666"},formatter:void 0}},controlPointOptions:{positioner:function(a){var d=this.index,c=a.chart,e=a.options,f=e.typeOptions,h=f.selectType;e=e.controlPointOptions;var n=c.inverted,t=c.xAxis[f.xAxis];c=c.yAxis[f.yAxis];f=a.xAxisMax;
var p=a.yAxisMax,l=b.calculations.getExtremes(a.xAxisMin,a.xAxisMax,a.yAxisMin,a.yAxisMax);"x"===h&&(p=(l.yAxisMax-l.yAxisMin)/2,0===d&&(f=a.xAxisMin));"y"===h&&(f=l.xAxisMin+(l.xAxisMax-l.xAxisMin)/2,0===d&&(p=a.yAxisMin));n?(a=c.toPixels(p),d=t.toPixels(f)):(a=t.toPixels(f),d=c.toPixels(p));return{x:a-e.width/2,y:d-e.height/2}},events:{drag:function(a,b){var d=this.mouseMoveToTranslation(a);a=b.options.typeOptions.selectType;var c="y"===a?0:d.x;d="x"===a?0:d.y;b.resize(c,d,this.index,a);b.resizeX+=
c;b.resizeY+=d;b.redraw(!1,!0)}}}});return c.types.measure=b});u(c,"Mixins/Navigation.js",[],function(){return{initUpdate:function(c){c.navigation||(c.navigation={updates:[],update:function(c,f){this.updates.forEach(function(h){h.update.call(h.context,c,f)})}})},addUpdate:function(c,h){h.navigation||this.initUpdate(h);h.navigation.updates.push({update:c,context:h})}}});u(c,"Extensions/Annotations/NavigationBindings.js",[c["Extensions/Annotations/Annotations.js"],c["Core/Chart/Chart.js"],c["Mixins/Navigation.js"],
c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,h,m,q,l){function f(a){var b=a.prototype.defaultOptions.events&&a.prototype.defaultOptions.events.click;n(!0,a.prototype.defaultOptions.events,{click:function(a){var c=this,e=c.chart.navigationBindings,f=e.activeAnnotation;b&&b.call(c,a);f!==c?(e.deselectAnnotation(),e.activeAnnotation=c,c.setControlPointsVisibility(!0),d(e,"showPopup",{annotation:c,formType:"annotation-toolbar",options:e.annotationToFields(c),onSubmit:function(a){var b={};"remove"===
a.actionType?(e.activeAnnotation=!1,e.chart.removeAnnotation(c)):(e.fieldsToOptions(a.fields,b),e.deselectAnnotation(),a=b.typeOptions,"measure"===c.options.type&&(a.crosshairY.enabled=0!==a.crosshairY.strokeWidth,a.crosshairX.enabled=0!==a.crosshairX.strokeWidth),c.update(b))}})):(e.deselectAnnotation(),d(e,"closePopup"));a.activeAnnotation=!0}})}var e=l.addEvent,b=l.attr,a=l.format,d=l.fireEvent,g=l.isArray,k=l.isFunction,u=l.isNumber,v=l.isObject,n=l.merge,t=l.objectEach,p=l.pick;l=l.setOptions;
var w=q.doc,A=q.win,C=function(){function c(a,b){this.selectedButton=this.boundClassNames=void 0;this.chart=a;this.options=b;this.eventsToUnbind=[];this.container=w.getElementsByClassName(this.options.bindingsClassName||"")}c.prototype.initEvents=function(){var a=this,b=a.chart,d=a.container,c=a.options;a.boundClassNames={};t(c.bindings||{},function(b){a.boundClassNames[b.className]=b});[].forEach.call(d,function(b){a.eventsToUnbind.push(e(b,"click",function(d){var c=a.getButtonEvents(b,d);c&&a.bindingsButtonClick(c.button,
c.events,d)}))});t(c.events||{},function(b,d){k(b)&&a.eventsToUnbind.push(e(a,d,b))});a.eventsToUnbind.push(e(b.container,"click",function(d){!b.cancelClick&&b.isInsidePlot(d.chartX-b.plotLeft,d.chartY-b.plotTop)&&a.bindingsChartClick(this,d)}));a.eventsToUnbind.push(e(b.container,q.isTouchDevice?"touchmove":"mousemove",function(b){a.bindingsContainerMouseMove(this,b)}))};c.prototype.initUpdate=function(){var a=this;m.addUpdate(function(b){a.update(b)},this.chart)};c.prototype.bindingsButtonClick=
function(a,b,c){var e=this.chart;this.selectedButtonElement&&(d(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&"annotations"===this.currentUserDetails.coll&&e.removeAnnotation(this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1));this.selectedButton=b;this.selectedButtonElement=a;d(this,"selectButton",{button:a});b.init&&b.init.call(this,a,c);(b.start||b.steps)&&e.renderer.boxWrapper.addClass("highcharts-draw-mode")};c.prototype.bindingsChartClick=
function(a,b){a=this.chart;var c=this.selectedButton;a=a.renderer.boxWrapper;var e;if(e=this.activeAnnotation&&!b.activeAnnotation&&b.target.parentNode){a:{e=b.target;var f=A.Element.prototype,g=f.matches||f.msMatchesSelector||f.webkitMatchesSelector,n=null;if(f.closest)n=f.closest.call(e,".highcharts-popup");else{do{if(g.call(e,".highcharts-popup"))break a;e=e.parentElement||e.parentNode}while(null!==e&&1===e.nodeType)}e=n}e=!e}e&&(d(this,"closePopup"),this.deselectAnnotation());c&&c.start&&(this.nextEvent?
(this.nextEvent(b,this.currentUserDetails),this.steps&&(this.stepIndex++,c.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=c.steps[this.stepIndex]:(d(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),c.end&&c.end.call(this,b,this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=null))):(this.currentUserDetails=c.start.call(this,b),c.steps?(this.stepIndex=0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=c.steps[this.stepIndex]):
(d(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,c.end&&c.end.call(this,b,this.currentUserDetails))))};c.prototype.bindingsContainerMouseMove=function(a,b){this.mouseMoveEvent&&this.mouseMoveEvent(b,this.currentUserDetails)};c.prototype.fieldsToOptions=function(a,b){t(a,function(a,d){var c=parseFloat(a),e=d.split("."),f=b,g=e.length-1;!u(c)||a.match(/px/g)||d.match(/format/g)||(a=c);""!==a&&"undefined"!==a&&
e.forEach(function(b,d){var c=p(e[d+1],"");g===d?f[b]=a:(f[b]||(f[b]=c.match(/\d/g)?[]:{}),f=f[b])})});return b};c.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)};c.prototype.annotationToFields=function(b){function d(c,e,f,p){if(f&&c&&-1===l.indexOf(e)&&(0<=(f.indexOf&&f.indexOf(e))||f[e]||!0===f))if(g(c))p[e]=[],c.forEach(function(a,b){v(a)?(p[e][b]={},t(a,function(a,c){d(a,c,n[e],p[e][b])})):d(a,0,n[e],
p[e])});else if(v(c)){var k={};g(p)?(p.push(k),k[e]={},k=k[e]):p[e]=k;t(c,function(a,b){d(a,b,0===e?f:n[e],k)})}else"format"===e?p[e]=[a(c,b.labels[0].points[0]).toString(),"text"]:g(p)?p.push([c,h(c)]):p[e]=[c,h(c)]}var e=b.options,f=c.annotationsEditable,n=f.nestedOptions,h=this.utils.getFieldType,k=p(e.type,e.shapes&&e.shapes[0]&&e.shapes[0].type,e.labels&&e.labels[0]&&e.labels[0].itemType,"label"),l=c.annotationsNonEditable[e.langKey]||[],x={langKey:e.langKey,type:k};t(e,function(a,b){"typeOptions"===
b?(x[b]={},t(e[b],function(a,c){d(a,c,n,x[b],!0)})):d(a,b,f[k],x)});return x};c.prototype.getClickedClassNames=function(a,c){var d=c.target;c=[];for(var e;d&&((e=b(d,"class"))&&(c=c.concat(e.split(" ").map(function(a){return[a,d]}))),d=d.parentNode,d!==a););return c};c.prototype.getButtonEvents=function(a,b){var c=this,d;this.getClickedClassNames(a,b).forEach(function(a){c.boundClassNames[a[0]]&&!d&&(d={events:c.boundClassNames[a[0]],button:a[1]})});return d};c.prototype.update=function(a){this.options=
n(!0,this.options,a);this.removeEvents();this.initEvents()};c.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(a){a()})};c.prototype.destroy=function(){this.removeEvents()};c.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill",
"strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]};
c.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]};return c}();C.prototype.utils={updateRectSize:function(a,b){var c=b.chart,d=b.options.typeOptions,e=c.pointer.getCoordinates(a);a=e.xAxis[0].value-d.point.x;d=d.point.y-e.yAxis[0].value;b.update({typeOptions:{background:{width:c.inverted?d:a,height:c.inverted?a:d}}})},getFieldType:function(a){return{string:"text",number:"number","boolean":"checkbox"}[typeof a]}};h.prototype.initNavigationBindings=function(){var a=this.options;
a&&a.navigation&&a.navigation.bindings&&(this.navigationBindings=new C(this,a.navigation),this.navigationBindings.initEvents(),this.navigationBindings.initUpdate())};e(h,"load",function(){this.initNavigationBindings()});e(h,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});e(C,"deselectButton",function(){this.selectedButtonElement=null});e(c,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});q.Annotation&&(f(c),t(c.types,
function(a){f(a)}));l({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",
padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(a){a=this.chart.pointer.getCoordinates(a);var b=this.chart.options.navigation;return this.chart.addAnnotation(n({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{xAxis:0,yAxis:0,x:a.xAxis[0].value,y:a.yAxis[0].value},r:5}]},b.annotationsOptions,
b.bindings.circleAnnotation.annotationsOptions))},steps:[function(a,b){var c=b.options.shapes[0].point,d=this.chart.xAxis[0].toPixels(c.x);c=this.chart.yAxis[0].toPixels(c.y);var e=this.chart.inverted;b.update({shapes:[{r:Math.max(Math.sqrt(Math.pow(e?c-a.chartX:d-a.chartX,2)+Math.pow(e?d-a.chartY:c-a.chartY,2)),5)}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.chart.options.navigation;var c=b.xAxis[0].value;
b=b.yAxis[0].value;return this.chart.addAnnotation(n({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:0,yAxis:0,x:c,y:b},{xAxis:0,yAxis:0,x:c,y:b},{xAxis:0,yAxis:0,x:c,y:b},{xAxis:0,yAxis:0,x:c,y:b}]}]},a.annotationsOptions,a.bindings.rectangleAnnotation.annotationsOptions))},steps:[function(a,b){var c=b.options.shapes[0].points,d=this.chart.pointer.getCoordinates(a);a=d.xAxis[0].value;d=d.yAxis[0].value;c[1].x=a;c[2].x=a;c[2].y=d;c[3].y=d;b.update({shapes:[{points:c}]})}]},
labelAnnotation:{className:"highcharts-label-annotation",start:function(a){a=this.chart.pointer.getCoordinates(a);var b=this.chart.options.navigation;return this.chart.addAnnotation(n({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:0,yAxis:0,x:a.xAxis[0].value,y:a.yAxis[0].value},overflow:"none",crop:!0}]},b.annotationsOptions,b.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});return C});u(c,"Extensions/Annotations/Popup.js",
[c["Core/Globals.js"],c["Extensions/Annotations/NavigationBindings.js"],c["Core/Pointer.js"],c["Core/Utilities.js"]],function(c,h,m,q){var f=q.addEvent,r=q.createElement,e=q.defined,b=q.getOptions,a=q.isArray,d=q.isObject,g=q.isString,k=q.objectEach,u=q.pick;q=q.wrap;var v=/\d/g;q(m.prototype,"onContainerMouseDown",function(a,b){var c=b.target&&b.target.className;g(c)&&0<=c.indexOf("highcharts-popup-field")||a.apply(this,Array.prototype.slice.call(arguments,1))});c.Popup=function(a,b){this.init(a,
b)};c.Popup.prototype={init:function(a,b){this.container=r("div",{className:"highcharts-popup"},null,a);this.lang=this.getLangpack();this.iconsURL=b;this.addCloseBtn()},addCloseBtn:function(){var a=this;var b=r("div",{className:"highcharts-popup-close"},null,this.container);b.style["background-image"]="url("+this.iconsURL+"close.svg)";["click","touchstart"].forEach(function(c){f(b,c,function(){a.closePopup()})})},addColsContainer:function(a){var b=r("div",{className:"highcharts-popup-lhs-col"},null,
a);a=r("div",{className:"highcharts-popup-rhs-col"},null,a);r("div",{className:"highcharts-popup-rhs-col-wrapper"},null,a);return{lhsCol:b,rhsCol:a}},addInput:function(a,b,c,d){var e=a.split(".");e=e[e.length-1];var f=this.lang;b="highcharts-"+b+"-"+e;b.match(v)||r("label",{innerHTML:f[e]||e,htmlFor:b},null,c);r("input",{name:b,value:d[0],type:d[1],className:"highcharts-popup-field"},null,c).setAttribute("highcharts-data-name",a)},addButton:function(a,b,c,d,e){var g=this,n=this.closePopup,t=this.getFields;
var h=r("button",{innerHTML:b},null,a);["click","touchstart"].forEach(function(a){f(h,a,function(){n.call(g);return d(t(e,c))})});return h},getFields:function(a,b){var c=a.querySelectorAll("input"),d=a.querySelectorAll("#highcharts-select-series > option:checked")[0];a=a.querySelectorAll("#highcharts-select-volume > option:checked")[0];var e,f;var g={actionType:b,linkedTo:d&&d.getAttribute("value"),fields:{}};[].forEach.call(c,function(a){f=a.getAttribute("highcharts-data-name");(e=a.getAttribute("highcharts-data-series-id"))?
g.seriesId=a.value:f?g.fields[f]=a.value:g.type=a.value});a&&(g.fields["params.volumeSeriesID"]=a.getAttribute("value"));return g},showPopup:function(){var a=this.container,b=a.querySelectorAll(".highcharts-popup-close")[0];a.innerHTML="";0<=a.className.indexOf("highcharts-annotation-toolbar")&&(a.classList.remove("highcharts-annotation-toolbar"),a.removeAttribute("style"));a.appendChild(b);a.style.display="block"},closePopup:function(){this.popup.container.style.display="none"},showForm:function(a,
b,c,d){this.popup=b.navigationBindings.popup;this.showPopup();"indicators"===a&&this.indicators.addForm.call(this,b,c,d);"annotation-toolbar"===a&&this.annotations.addToolbar.call(this,b,c,d);"annotation-edit"===a&&this.annotations.addForm.call(this,b,c,d);"flag"===a&&this.annotations.addForm.call(this,b,c,d,!0)},getLangpack:function(){return b().lang.navigation.popup},annotations:{addToolbar:function(a,b,c){var d=this,e=this.lang,f=this.popup.container,g=this.showForm;-1===f.className.indexOf("highcharts-annotation-toolbar")&&
(f.className+=" highcharts-annotation-toolbar");f.style.top=a.plotTop+10+"px";r("span",{innerHTML:u(e[b.langKey]||b.langKey,b.shapes&&b.shapes[0].type)},null,f);var h=this.addButton(f,e.removeButton||"remove","remove",c,f);h.className+=" highcharts-annotation-remove-button";h.style["background-image"]="url("+this.iconsURL+"destroy.svg)";h=this.addButton(f,e.editButton||"edit","edit",function(){g.call(d,"annotation-edit",a,b,c)},f);h.className+=" highcharts-annotation-edit-button";h.style["background-image"]=
"url("+this.iconsURL+"edit.svg)"},addForm:function(a,b,c,d){var e=this.popup.container,f=this.lang;r("h2",{innerHTML:f[b.langKey]||b.langKey,className:"highcharts-popup-main-title"},null,e);var g=r("div",{className:"highcharts-popup-lhs-col highcharts-popup-lhs-full"},null,e);var h=r("div",{className:"highcharts-popup-bottom-row"},null,e);this.annotations.addFormFields.call(this,g,a,"",b,[],!0);this.addButton(h,d?f.addButton||"add":f.saveButton||"save",d?"add":"save",c,e)},addFormFields:function(b,
c,e,f,g,h){var n=this,t=this.annotations.addFormFields,p=this.addInput,l=this.lang,m,q;k(f,function(f,h){m=""!==e?e+"."+h:h;d(f)&&(!a(f)||a(f)&&d(f[0])?(q=l[h]||h,q.match(v)||g.push([!0,q,b]),t.call(n,b,c,m,f,g,!1)):g.push([n,m,"annotation",b,f]))});h&&(g=g.sort(function(a){return a[1].match(/format/g)?-1:1}),g.forEach(function(a){!0===a[0]?r("span",{className:"highcharts-annotation-title",innerHTML:a[1]},null,a[2]):p.apply(a[0],a.splice(1))}))}},indicators:{addForm:function(a,b,c){var d=this.indicators,
e=this.lang;this.tabs.init.call(this,a);b=this.popup.container.querySelectorAll(".highcharts-tab-item-content");this.addColsContainer(b[0]);d.addIndicatorList.call(this,a,b[0],"add");var f=b[0].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,e.addButton||"add","add",c,f);this.addColsContainer(b[1]);d.addIndicatorList.call(this,a,b[1],"edit");f=b[1].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,e.saveButton||"save","edit",c,f);this.addButton(f,e.removeButton||
"remove","remove",c,f)},addIndicatorList:function(a,b,c){var d=this,e=b.querySelectorAll(".highcharts-popup-lhs-col")[0];b=b.querySelectorAll(".highcharts-popup-rhs-col")[0];var g="edit"===c,h=g?a.series:a.options.plotOptions,n=this.indicators.addFormFields,p;var t=r("ul",{className:"highcharts-indicator-list"},null,e);var l=b.querySelectorAll(".highcharts-popup-rhs-col-wrapper")[0];k(h,function(b,c){var e=b.options;if(b.params||e&&e.params){var k=d.indicators.getNameType(b,c),m=k.type;p=r("li",{className:"highcharts-indicator-list",
innerHTML:k.name},null,t);["click","touchstart"].forEach(function(c){f(p,c,function(){n.call(d,a,g?b:h[m],k.type,l);g&&b.options&&r("input",{type:"hidden",name:"highcharts-id-"+m,value:b.options.id},null,l).setAttribute("highcharts-data-series-id",b.options.id)})})}});0<t.childNodes.length&&t.childNodes[0].click()},getNameType:function(a,b){var d=a.options,e=c.seriesTypes;e=e[b]&&e[b].prototype.nameBase||b.toUpperCase();d&&d.type&&(b=a.options.type,e=a.name);return{name:e,type:b}},listAllSeries:function(a,
b,c,d,f){a="highcharts-"+b+"-type-"+a;var g;r("label",{innerHTML:this.lang[b]||b,htmlFor:a},null,d);var h=r("select",{name:a,className:"highcharts-popup-field"},null,d);h.setAttribute("id","highcharts-select-"+b);c.series.forEach(function(a){g=a.options;!g.params&&g.id&&"highcharts-navigator-series"!==g.id&&r("option",{innerHTML:g.name||g.id,value:g.id},null,h)});e(f)&&(h.value=f)},addFormFields:function(a,b,c,d){var e=b.params||b.options.params,f=this.indicators.getNameType;d.innerHTML="";r("h3",
{className:"highcharts-indicator-title",innerHTML:f(b,c).name},null,d);r("input",{type:"hidden",name:"highcharts-type-"+c,value:c},null,d);this.indicators.listAllSeries.call(this,c,"series",a,d,b.linkedParent&&e.volumeSeriesID);e.volumeSeriesID&&this.indicators.listAllSeries.call(this,c,"volume",a,d,b.linkedParent&&b.linkedParent.options.id);this.indicators.addParamInputs.call(this,a,"params",e,c,d)},addParamInputs:function(a,b,c,e,f){var g=this,h=this.indicators.addParamInputs,l=this.addInput,n;
k(c,function(c,k){n=b+"."+k;d(c)?h.call(g,a,n,c,e,f):"params.volumeSeriesID"!==n&&l.call(g,n,e,f,[c,"text"])})},getAmount:function(){var a=0;this.series.forEach(function(b){var c=b.options;(b.params||c&&c.params)&&a++});return a}},tabs:{init:function(a){var b=this.tabs;a=this.indicators.getAmount.call(a);var c=b.addMenuItem.call(this,"add");b.addMenuItem.call(this,"edit",a);b.addContentItem.call(this,"add");b.addContentItem.call(this,"edit");b.switchTabs.call(this,a);b.selectTab.call(this,c,0)},addMenuItem:function(a,
b){var c=this.popup.container,d="highcharts-tab-item",e=this.lang;0===b&&(d+=" highcharts-tab-disabled");b=r("span",{innerHTML:e[a+"Button"]||a,className:d},null,c);b.setAttribute("highcharts-data-tab-type",a);return b},addContentItem:function(){return r("div",{className:"highcharts-tab-item-content"},null,this.popup.container)},switchTabs:function(a){var b=this,c;this.popup.container.querySelectorAll(".highcharts-tab-item").forEach(function(d,e){c=d.getAttribute("highcharts-data-tab-type");"edit"===
c&&0===a||["click","touchstart"].forEach(function(a){f(d,a,function(){b.tabs.deselectAll.call(b);b.tabs.selectTab.call(b,this,e)})})})},selectTab:function(a,b){var c=this.popup.container.querySelectorAll(".highcharts-tab-item-content");a.className+=" highcharts-tab-item-active";c[b].className+=" highcharts-tab-item-show"},deselectAll:function(){var a=this.popup.container,b=a.querySelectorAll(".highcharts-tab-item");a=a.querySelectorAll(".highcharts-tab-item-content");var c;for(c=0;c<b.length;c++)b[c].classList.remove("highcharts-tab-item-active"),
a[c].classList.remove("highcharts-tab-item-show")}}};f(h,"showPopup",function(a){this.popup||(this.popup=new c.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/8.2.2/gfx/stock-icons/"));this.popup.showForm(a.formType,this.chart,a.options,a.onSubmit)});f(h,"closePopup",function(){this.popup&&this.popup.closePopup()})});u(c,"masters/modules/annotations-advanced.src.js",[],function(){})});
//# sourceMappingURL=annotations-advanced.js.map