/*
 Highstock JS v8.1.0 (2020-05-05)

 Highstock as a plugin for Highcharts

 (c) 2010-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(k){"object"===typeof module&&module.exports?(k["default"]=k,module.exports=k):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(I){k(I);k.Highcharts=I;return k}):k("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(k){function I(k,e,x,q){k.hasOwnProperty(e)||(k[e]=q.apply(null,x))}k=k?k._modules:{};I(k,"parts/NavigatorAxis.js",[k["parts/Globals.js"],k["parts/Utilities.js"]],function(k,e){var x=k.isTouchDevice,q=e.addEvent,z=e.correctFloat,
r=e.defined,D=e.isNumber,B=e.pick,d=function(){function d(d){this.axis=d}d.prototype.destroy=function(){this.axis=void 0};d.prototype.toFixedRange=function(d,e,y,m){var u=this.axis,w=u.chart;w=w&&w.fixedRange;var b=(u.pointRange||0)/2;d=B(y,u.translate(d,!0,!u.horiz));e=B(m,u.translate(e,!0,!u.horiz));u=w&&(e-d)/w;r(y)||(d=z(d+b));r(m)||(e=z(e-b));.7<u&&1.3>u&&(m?d=e-w:e=d+w);D(d)&&D(e)||(d=e=void 0);return{min:d,max:e}};return d}();return function(){function e(){}e.compose=function(e){e.keepProps.push("navigatorAxis");
q(e,"init",function(){this.navigatorAxis||(this.navigatorAxis=new d(this))});q(e,"zoom",function(d){var y=this.chart.options,m=y.navigator,u=this.navigatorAxis,w=y.chart.pinchType,b=y.rangeSelector;y=y.chart.zoomType;this.isXAxis&&(m&&m.enabled||b&&b.enabled)&&("y"===y?d.zoomed=!1:(!x&&"xy"===y||x&&"xy"===w)&&this.options.range&&(m=u.previousZoom,r(d.newMin)?u.previousZoom=[this.min,this.max]:m&&(d.newMin=m[0],d.newMax=m[1],u.previousZoom=void 0)));"undefined"!==typeof d.zoomed&&d.preventDefault()})};
e.AdditionsClass=d;return e}()});I(k,"parts/ScrollbarAxis.js",[k["parts/Globals.js"],k["parts/Utilities.js"]],function(k,e){var x=e.addEvent,q=e.defined,z=e.pick;return function(){function e(){}e.compose=function(e,r){x(e,"afterInit",function(){var d=this;d.options&&d.options.scrollbar&&d.options.scrollbar.enabled&&(d.options.scrollbar.vertical=!d.horiz,d.options.startOnTick=d.options.endOnTick=!1,d.scrollbar=new r(d.chart.renderer,d.options.scrollbar,d.chart),x(d.scrollbar,"changed",function(e){var r=
z(d.options&&d.options.min,d.min),B=z(d.options&&d.options.max,d.max),y=q(d.dataMin)?Math.min(r,d.min,d.dataMin):r,m=(q(d.dataMax)?Math.max(B,d.max,d.dataMax):B)-y;q(r)&&q(B)&&(d.horiz&&!d.reversed||!d.horiz&&d.reversed?(r=y+m*this.to,y+=m*this.from):(r=y+m*(1-this.from),y+=m*(1-this.to)),z(this.options.liveRedraw,k.svg&&!k.isTouchDevice&&!this.chart.isBoosting)||"mouseup"===e.DOMType||!q(e.DOMType)?d.setExtremes(y,r,!0,"mousemove"!==e.DOMType,e):this.setRange(this.from,this.to))}))});x(e,"afterRender",
function(){var d=Math.min(z(this.options.min,this.min),this.min,z(this.dataMin,this.min)),e=Math.max(z(this.options.max,this.max),this.max,z(this.dataMax,this.max)),r=this.scrollbar,B=this.axisTitleMargin+(this.titleOffset||0),y=this.chart.scrollbarsOffsets,m=this.options.margin||0;r&&(this.horiz?(this.opposite||(y[1]+=B),r.position(this.left,this.top+this.height+2+y[1]-(this.opposite?m:0),this.width,this.height),this.opposite||(y[1]+=m),B=1):(this.opposite&&(y[0]+=B),r.position(this.left+this.width+
2+y[0]-(this.opposite?0:m),this.top,this.width,this.height),this.opposite&&(y[0]+=m),B=0),y[B]+=r.size+r.options.margin,isNaN(d)||isNaN(e)||!q(this.min)||!q(this.max)||this.min===this.max?r.setRange(0,1):(y=(this.min-d)/(e-d),d=(this.max-d)/(e-d),this.horiz&&!this.reversed||!this.horiz&&this.reversed?r.setRange(y,d):r.setRange(1-d,1-y)))});x(e,"afterGetOffset",function(){var d=this.horiz?2:1,e=this.scrollbar;e&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[d]+=e.size+e.options.margin)})};
return e}()});I(k,"parts/Scrollbar.js",[k["parts/Axis.js"],k["parts/Globals.js"],k["parts/ScrollbarAxis.js"],k["parts/Utilities.js"]],function(k,e,x,q){var z=q.addEvent,r=q.correctFloat,D=q.defined,B=q.destroyObjectProperties,d=q.fireEvent,J=q.merge,H=q.pick,E=q.removeEvent;q=e.defaultOptions;var y=e.hasTouch,m=e.isTouchDevice,u=e.swapXY=function(b,c){c&&b.forEach(function(c){for(var a=c.length,b,f=0;f<a;f+=2)b=c[f+1],"number"===typeof b&&(c[f+1]=c[f+2],c[f+2]=b)});return b},w=function(){function b(c,
b,a){this._events=[];this.from=this.chartY=this.chartX=0;this.scrollbar=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=void 0;this.trackBorderWidth=1;this.userOptions={};this.y=this.x=0;this.chart=a;this.options=b;this.renderer=a.renderer;this.init(c,b,a)}b.prototype.addEvents=function(){var c=this.options.inverted?[1,0]:[0,1],b=this.scrollbarButtons,
a=this.scrollbarGroup.element,l=this.track.element,f=this.mouseDownHandler.bind(this),p=this.mouseMoveHandler.bind(this),g=this.mouseUpHandler.bind(this);c=[[b[c[0]].element,"click",this.buttonToMinClick.bind(this)],[b[c[1]].element,"click",this.buttonToMaxClick.bind(this)],[l,"click",this.trackClick.bind(this)],[a,"mousedown",f],[a.ownerDocument,"mousemove",p],[a.ownerDocument,"mouseup",g]];y&&c.push([a,"touchstart",f],[a.ownerDocument,"touchmove",p],[a.ownerDocument,"touchend",g]);c.forEach(function(a){z.apply(null,
a)});this._events=c};b.prototype.buttonToMaxClick=function(c){var b=(this.to-this.from)*H(this.options.step,.2);this.updatePosition(this.from+b,this.to+b);d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:c})};b.prototype.buttonToMinClick=function(c){var b=r(this.to-this.from)*H(this.options.step,.2);this.updatePosition(r(this.from-b),r(this.to-b));d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:c})};b.prototype.cursorToScrollbarPosition=function(c){var b=
this.options;b=b.minWidth>this.calculatedWidth?b.minWidth:0;return{chartX:(c.chartX-this.x-this.xOffset)/(this.barWidth-b),chartY:(c.chartY-this.y-this.yOffset)/(this.barWidth-b)}};b.prototype.destroy=function(){var c=this.chart.scroller;this.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(c){this[c]&&this[c].destroy&&(this[c]=this[c].destroy())},this);c&&this===c.scrollbar&&(c.scrollbar=null,B(c.scrollbarButtons))};b.prototype.drawScrollbarButton=
function(c){var b=this.renderer,a=this.scrollbarButtons,l=this.options,f=this.size;var p=b.g().add(this.group);a.push(p);p=b.rect().addClass("highcharts-scrollbar-button").add(p);this.chart.styledMode||p.attr({stroke:l.buttonBorderColor,"stroke-width":l.buttonBorderWidth,fill:l.buttonBackgroundColor});p.attr(p.crisp({x:-.5,y:-.5,width:f+1,height:f+1,r:l.buttonBorderRadius},p.strokeWidth()));p=b.path(u([["M",f/2+(c?-1:1),f/2-3],["L",f/2+(c?-1:1),f/2+3],["L",f/2+(c?2:-2),f/2]],l.vertical)).addClass("highcharts-scrollbar-arrow").add(a[c]);
this.chart.styledMode||p.attr({fill:l.buttonArrowColor})};b.prototype.init=function(c,C,a){this.scrollbarButtons=[];this.renderer=c;this.userOptions=C;this.options=J(b.defaultOptions,C);this.chart=a;this.size=H(this.options.size,this.options.height);C.enabled&&(this.render(),this.addEvents())};b.prototype.mouseDownHandler=function(c){c=this.chart.pointer.normalize(c);c=this.cursorToScrollbarPosition(c);this.chartX=c.chartX;this.chartY=c.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=
!0};b.prototype.mouseMoveHandler=function(c){var b=this.chart.pointer.normalize(c),a=this.options.vertical?"chartY":"chartX",l=this.initPositions||[];!this.grabbedCenter||c.touches&&0===c.touches[0][a]||(b=this.cursorToScrollbarPosition(b)[a],a=this[a],a=b-a,this.hasDragged=!0,this.updatePosition(l[0]+a,l[1]+a),this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:c.type,DOMEvent:c}))};b.prototype.mouseUpHandler=function(c){this.hasDragged&&d(this,"changed",{from:this.from,
to:this.to,trigger:"scrollbar",DOMType:c.type,DOMEvent:c});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};b.prototype.position=function(c,b,a,l){var f=this.options.vertical,p=0,g=this.rendered?"animate":"attr";this.x=c;this.y=b+this.trackBorderWidth;this.width=a;this.xOffset=this.height=l;this.yOffset=p;f?(this.width=this.yOffset=a=p=this.size,this.xOffset=b=0,this.barWidth=l-2*a,this.x=c+=this.options.margin):(this.height=this.xOffset=l=b=this.size,this.barWidth=a-2*l,this.y+=this.options.margin);
this.group[g]({translateX:c,translateY:this.y});this.track[g]({width:a,height:l});this.scrollbarButtons[1][g]({translateX:f?0:a-b,translateY:f?l-p:0})};b.prototype.removeEvents=function(){this._events.forEach(function(c){E.apply(null,c)});this._events.length=0};b.prototype.render=function(){var c=this.renderer,b=this.options,a=this.size,l=this.chart.styledMode,f;this.group=f=c.g("scrollbar").attr({zIndex:b.zIndex,translateY:-99999}).add();this.track=c.rect().addClass("highcharts-scrollbar-track").attr({x:0,
r:b.trackBorderRadius||0,height:a,width:a}).add(f);l||this.track.attr({fill:b.trackBackgroundColor,stroke:b.trackBorderColor,"stroke-width":b.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=c.g().add(f);this.scrollbar=c.rect().addClass("highcharts-scrollbar-thumb").attr({height:a,width:a,r:b.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=c.path(u([["M",-3,a/4],["L",-3,2*a/3],["M",0,a/4],["L",
0,2*a/3],["M",3,a/4],["L",3,2*a/3]],b.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);l||(this.scrollbar.attr({fill:b.barBackgroundColor,stroke:b.barBorderColor,"stroke-width":b.barBorderWidth}),this.scrollbarRifles.attr({stroke:b.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};b.prototype.setRange=
function(b,d){var a=this.options,c=a.vertical,f=a.minWidth,p=this.barWidth,g,v=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(D(p)){b=Math.max(b,0);var A=Math.ceil(p*b);this.calculatedWidth=g=r(p*Math.min(d,1)-A);g<f&&(A=(p-f+g)*b,g=f);f=Math.floor(A+this.xOffset+this.yOffset);p=g/2-.5;this.from=b;this.to=d;c?(this.scrollbarGroup[v]({translateY:f}),this.scrollbar[v]({height:g}),this.scrollbarRifles[v]({translateY:p}),this.scrollbarTop=f,
this.scrollbarLeft=0):(this.scrollbarGroup[v]({translateX:f}),this.scrollbar[v]({width:g}),this.scrollbarRifles[v]({translateX:p}),this.scrollbarLeft=f,this.scrollbarTop=0);12>=g?this.scrollbarRifles.hide():this.scrollbarRifles.show(!0);!1===a.showFull&&(0>=b&&1<=d?this.group.hide():this.group.show());this.rendered=!0}};b.prototype.trackClick=function(b){var c=this.chart.pointer.normalize(b),a=this.to-this.from,l=this.y+this.scrollbarTop,f=this.x+this.scrollbarLeft;this.options.vertical&&c.chartY>
l||!this.options.vertical&&c.chartX>f?this.updatePosition(this.from+a,this.to+a):this.updatePosition(this.from-a,this.to-a);d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:b})};b.prototype.update=function(b){this.destroy();this.init(this.chart.renderer,J(!0,this.options,b),this.chart)};b.prototype.updatePosition=function(b,d){1<d&&(b=r(1-r(d-b)),d=1);0>b&&(d=r(d-b),b=0);this.from=b;this.to=d};b.defaultOptions={height:m?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,
margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",trackBorderColor:"#f2f2f2",trackBorderWidth:1};return b}();e.Scrollbar||(q.scrollbar=J(!0,w.defaultOptions,q.scrollbar),e.Scrollbar=w,x.compose(k,w));return e.Scrollbar});I(k,"parts/Navigator.js",[k["parts/Axis.js"],k["parts/Color.js"],
k["parts/Globals.js"],k["parts/NavigatorAxis.js"],k["parts/Scrollbar.js"],k["parts/Utilities.js"]],function(k,e,x,q,z,r){e=e.parse;var D=r.addEvent,B=r.clamp,d=r.correctFloat,J=r.defined,H=r.destroyObjectProperties,E=r.erase,y=r.extend,m=r.find,u=r.isArray,w=r.isNumber,b=r.merge,c=r.pick,C=r.removeEvent,a=r.splat;r=x.Chart;var l=x.defaultOptions,f=x.hasTouch,p=x.isTouchDevice,g=x.Series,v=function(a){for(var h=[],t=1;t<arguments.length;t++)h[t-1]=arguments[t];h=[].filter.call(h,w);if(h.length)return Math[a].apply(0,
h)};var A="undefined"===typeof x.seriesTypes.areaspline?"line":"areaspline";y(l,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:e("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:A,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,smoothed:!0,units:[["millisecond",
[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",
style:{color:"#999999"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});x.Renderer.prototype.symbols["navigator-handle"]=function(a,h,t,b,c){a=c.width/2;h=Math.round(a/3)+.5;c=c.height||0;return[["M",-a-1,.5],["L",a,.5],["L",a,c+.5],["L",-a-1,c+.5],["L",-a-1,.5],["M",-h,4],["L",-h,c-3],["M",h-1,4],["L",h-1,c-3]]};var G=function(){function n(h){this.zoomedMin=
this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(h)}n.prototype.drawHandle=function(h,t,a,b){var n=this.navigatorOptions.handles.height;this.handles[t][b](a?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+
parseInt(h,10)+.5-n)}:{translateX:Math.round(this.left+parseInt(h,10)),translateY:Math.round(this.top+this.height/2-n/2-1)})};n.prototype.drawOutline=function(h,t,a,b){var n=this.navigatorOptions.maskInside,c=this.outline.strokeWidth(),f=c/2,g=c%2/2;c=this.outlineHeight;var F=this.scrollbarHeight||0,l=this.size,p=this.left-F,K=this.top;a?(p-=f,a=K+t+g,t=K+h+g,g=[["M",p+c,K-F-g],["L",p+c,a],["L",p,a],["L",p,t],["L",p+c,t],["L",p+c,K+l+F]],n&&g.push(["M",p+c,a-f],["L",p+c,t+f])):(h+=p+F-g,t+=p+F-g,
K+=f,g=[["M",p,K],["L",h,K],["L",h,K+c],["L",t,K+c],["L",t,K],["L",p+l+2*F,K]],n&&g.push(["M",h-f,K],["L",t+f,K]));this.outline[b]({d:g})};n.prototype.drawMasks=function(h,t,a,b){var n=this.left,c=this.top,f=this.height;if(a){var g=[n,n,n];var F=[c,c+h,c+t];var l=[f,f,f];var p=[h,t-h,this.size-t]}else g=[n,n+h,n+t],F=[c,c,c],l=[h,t-h,this.size-t],p=[f,f,f];this.shades.forEach(function(h,t){h[b]({x:g[t],y:F[t],width:l[t],height:p[t]})})};n.prototype.renderElements=function(){var h=this,t=h.navigatorOptions,
a=t.maskInside,b=h.chart,n=b.renderer,c,f={cursor:b.inverted?"ns-resize":"ew-resize"};h.navigatorGroup=c=n.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!a,a,!a].forEach(function(a,g){h.shades[g]=n.rect().addClass("highcharts-navigator-mask"+(1===g?"-inside":"-outside")).add(c);b.styledMode||h.shades[g].attr({fill:a?t.maskFill:"rgba(0,0,0,0)"}).css(1===g&&f)});h.outline=n.path().addClass("highcharts-navigator-outline").add(c);b.styledMode||h.outline.attr({"stroke-width":t.outlineWidth,
stroke:t.outlineColor});t.handles.enabled&&[0,1].forEach(function(a){t.handles.inverted=b.inverted;h.handles[a]=n.symbol(t.handles.symbols[a],-t.handles.width/2-1,0,t.handles.width,t.handles.height,t.handles);h.handles[a].attr({zIndex:7-a}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][a]).add(c);if(!b.styledMode){var g=t.handles;h.handles[a].attr({fill:g.backgroundColor,stroke:g.borderColor,"stroke-width":g.lineWidth}).css(f)}})};n.prototype.update=function(h){(this.series||
[]).forEach(function(h){h.baseSeries&&delete h.baseSeries.navigatorSeries});this.destroy();b(!0,this.chart.options.navigator,this.options,h);this.init(this.chart)};n.prototype.render=function(h,t,a,b){var n=this.chart,f=this.scrollbarHeight,g,l=this.xAxis,p=l.pointRange||0;var F=l.navigatorAxis.fake?n.xAxis[0]:l;var v=this.navigatorEnabled,K,A=this.rendered;var e=n.inverted;var G=n.xAxis[0].minRange,C=n.xAxis[0].options.maxRange;if(!this.hasDragged||J(a)){h=d(h-p/2);t=d(t+p/2);if(!w(h)||!w(t))if(A)a=
0,b=c(l.width,F.width);else return;this.left=c(l.left,n.plotLeft+f+(e?n.plotWidth:0));this.size=K=g=c(l.len,(e?n.plotHeight:n.plotWidth)-2*f);n=e?f:g+2*f;a=c(a,l.toPixels(h,!0));b=c(b,l.toPixels(t,!0));w(a)&&Infinity!==Math.abs(a)||(a=0,b=n);h=l.toValue(a,!0);t=l.toValue(b,!0);var m=Math.abs(d(t-h));m<G?this.grabbedLeft?a=l.toPixels(t-G-p,!0):this.grabbedRight&&(b=l.toPixels(h+G+p,!0)):J(C)&&d(m-p)>C&&(this.grabbedLeft?a=l.toPixels(t-C-p,!0):this.grabbedRight&&(b=l.toPixels(h+C+p,!0)));this.zoomedMax=
B(Math.max(a,b),0,K);this.zoomedMin=B(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(a,b),0,K);this.range=this.zoomedMax-this.zoomedMin;K=Math.round(this.zoomedMax);a=Math.round(this.zoomedMin);v&&(this.navigatorGroup.attr({visibility:"visible"}),A=A&&!this.hasDragged?"animate":"attr",this.drawMasks(a,K,e,A),this.drawOutline(a,K,e,A),this.navigatorOptions.handles.enabled&&(this.drawHandle(a,0,e,A),this.drawHandle(K,1,e,A)));this.scrollbar&&(e?(e=this.top-f,F=this.left-f+(v||!F.opposite?0:
(F.titleOffset||0)+F.axisTitleMargin),f=g+2*f):(e=this.top+(v?this.height:-f),F=this.left-f),this.scrollbar.position(F,e,n,f),this.scrollbar.setRange(this.zoomedMin/(g||1),this.zoomedMax/(g||1)));this.rendered=!0}};n.prototype.addMouseEvents=function(){var h=this,a=h.chart,b=a.container,n=[],c,g;h.mouseMoveHandler=c=function(a){h.onMouseMove(a)};h.mouseUpHandler=g=function(a){h.onMouseUp(a)};n=h.getPartsEvents("mousedown");n.push(D(a.renderTo,"mousemove",c),D(b.ownerDocument,"mouseup",g));f&&(n.push(D(a.renderTo,
"touchmove",c),D(b.ownerDocument,"touchend",g)),n.concat(h.getPartsEvents("touchstart")));h.eventsToUnbind=n;h.series&&h.series[0]&&n.push(D(h.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))};n.prototype.getPartsEvents=function(h){var a=this,b=[];["shades","handles"].forEach(function(t){a[t].forEach(function(n,c){b.push(D(n.element,h,function(h){a[t+"Mousedown"](h,c)}))})});return b};n.prototype.shadesMousedown=function(h,a){h=this.chart.pointer.normalize(h);
var b=this.chart,t=this.xAxis,n=this.zoomedMin,c=this.left,f=this.size,g=this.range,l=h.chartX;b.inverted&&(l=h.chartY,c=this.top);if(1===a)this.grabbedCenter=l,this.fixedWidth=g,this.dragOffset=l-n;else{h=l-c-g/2;if(0===a)h=Math.max(0,h);else if(2===a&&h+g>=f)if(h=f-g,this.reversedExtremes){h-=g;var p=this.getUnionExtremes().dataMin}else var v=this.getUnionExtremes().dataMax;h!==n&&(this.fixedWidth=g,a=t.navigatorAxis.toFixedRange(h,h+g,p,v),J(a.min)&&b.xAxis[0].setExtremes(Math.min(a.min,a.max),
Math.max(a.min,a.max),!0,null,{trigger:"navigator"}))}};n.prototype.handlesMousedown=function(h,a){this.chart.pointer.normalize(h);h=this.chart;var b=h.xAxis[0],t=this.reversedExtremes;0===a?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=t?b.min:b.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=t?b.max:b.min);h.fixedRange=null};n.prototype.onMouseMove=function(h){var a=this,b=a.chart,n=a.left,f=a.navigatorSize,g=a.range,l=a.dragOffset,v=b.inverted;
h.touches&&0===h.touches[0].pageX||(h=b.pointer.normalize(h),b=h.chartX,v&&(n=a.top,b=h.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,b-n,a.otherHandlePos)):a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,b-n)):a.grabbedCenter&&(a.hasDragged=!0,b<l?b=l:b>f+l-g&&(b=f+l-g),a.render(0,0,b-l,b-l+g)),a.hasDragged&&a.scrollbar&&c(a.scrollbar.options.liveRedraw,x.svg&&!p&&!this.chart.isBoosting)&&(h.DOMType=h.type,setTimeout(function(){a.onMouseUp(h)},0)))};n.prototype.onMouseUp=function(a){var h=
this.chart,b=this.xAxis,n=this.scrollbar,c=a.DOMEvent||a,f=h.inverted,g=this.rendered&&!this.hasDragged?"animate":"attr",l=Math.round(this.zoomedMax),p=Math.round(this.zoomedMin);if(this.hasDragged&&(!n||!n.hasDragged)||"scrollbar"===a.trigger){n=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var v=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var d=this.fixedExtreme;this.zoomedMax===this.size&&(d=this.reversedExtremes?n.dataMin:n.dataMax);0===this.zoomedMin&&(v=
this.reversedExtremes?n.dataMax:n.dataMin);b=b.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,v,d);J(b.min)&&h.xAxis[0].setExtremes(Math.min(b.min,b.max),Math.max(b.min,b.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:c})}"mousemove"!==a.DOMType&&"touchmove"!==a.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&(this.shades&&
this.drawMasks(p,l,f,g),this.outline&&this.drawOutline(p,l,f,g),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(p,0,f,g),this.drawHandle(l,1,f,g)))};n.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(a){a()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()};n.prototype.removeBaseSeriesEvents=function(){var a=this.baseSeries||[];this.navigatorEnabled&&a[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&
a.forEach(function(a){C(a,"updatedData",this.updatedDataHandler)},this),a[0].xAxis&&C(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};n.prototype.init=function(a){var h=a.options,n=h.navigator,f=n.enabled,g=h.scrollbar,l=g.enabled;h=f?n.height:0;var p=l?g.height:0;this.handles=[];this.shades=[];this.chart=a;this.setBaseSeries();this.height=h;this.scrollbarHeight=p;this.scrollbarEnabled=l;this.navigatorEnabled=f;this.navigatorOptions=n;this.scrollbarOptions=g;this.outlineHeight=h+p;this.opposite=
c(n.opposite,!(f||!a.inverted));var d=this;f=d.baseSeries;g=a.xAxis.length;l=a.yAxis.length;var A=f&&f[0]&&f[0].xAxis||a.xAxis[0]||{options:{}};a.isDirtyBox=!0;d.navigatorEnabled?(d.xAxis=new k(a,b({breaks:A.options.breaks,ordinal:A.options.ordinal},n.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:g,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},a.inverted?{offsets:[p,0,-p,0],width:h}:{offsets:[0,
-p,0,p],height:h})),d.yAxis=new k(a,b(n.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:l,isInternal:!0,zoomEnabled:!1},a.inverted?{width:h}:{height:h})),f||n.series.data?d.updateNavigatorSeries(!1):0===a.series.length&&(d.unbindRedraw=D(a,"beforeRedraw",function(){0<a.series.length&&!d.series&&(d.setBaseSeries(),d.unbindRedraw())})),d.reversedExtremes=a.inverted&&!d.xAxis.reversed||!a.inverted&&d.xAxis.reversed,d.renderElements(),d.addMouseEvents()):(d.xAxis={chart:a,navigatorAxis:{fake:!0},
translate:function(h,b){var n=a.xAxis[0],f=n.getExtremes(),c=n.len-2*p,g=v("min",n.options.min,f.dataMin);n=v("max",n.options.max,f.dataMax)-g;return b?h*n/c+g:c*(h-g)/n},toPixels:function(a){return this.translate(a)},toValue:function(a){return this.translate(a,!0)}},d.xAxis.navigatorAxis.axis=d.xAxis,d.xAxis.navigatorAxis.toFixedRange=q.AdditionsClass.prototype.toFixedRange.bind(d.xAxis.navigatorAxis));a.options.scrollbar.enabled&&(a.scrollbar=d.scrollbar=new z(a.renderer,b(a.options.scrollbar,{margin:d.navigatorEnabled?
0:10,vertical:a.inverted}),a),D(d.scrollbar,"changed",function(h){var b=d.size,n=b*this.to;b*=this.from;d.hasDragged=d.scrollbar.hasDragged;d.render(0,0,b,n);(a.options.scrollbar.liveRedraw||"mousemove"!==h.DOMType&&"touchmove"!==h.DOMType)&&setTimeout(function(){d.onMouseUp(h)})}));d.addBaseSeriesEvents();d.addChartEvents()};n.prototype.getUnionExtremes=function(a){var h=this.chart.xAxis[0],b=this.xAxis,n=b.options,f=h.options,g;a&&null===h.dataMin||(g={dataMin:c(n&&n.min,v("min",f.min,h.dataMin,
b.dataMin,b.min)),dataMax:c(n&&n.max,v("max",f.max,h.dataMax,b.dataMax,b.max))});return g};n.prototype.setBaseSeries=function(a,b){var h=this.chart,n=this.baseSeries=[];a=a||h.options&&h.options.navigator.baseSeries||(h.series.length?m(h.series,function(a){return!a.options.isInternal}).index:0);(h.series||[]).forEach(function(h,b){h.options.isInternal||!h.options.showInNavigator&&(b!==a&&h.options.id!==a||!1===h.options.showInNavigator)||n.push(h)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,
b)};n.prototype.updateNavigatorSeries=function(h,n){var f=this,g=f.chart,t=f.baseSeries,p,v,d=f.navigatorOptions.series,A,e={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},G=f.series=(f.series||[]).filter(function(a){var h=a.baseSeries;return 0>t.indexOf(h)?(h&&(C(h,"updatedData",f.updatedDataHandler),delete h.navigatorSeries),a.chart&&a.destroy(),
!1):!0});t&&t.length&&t.forEach(function(a){var h=a.navigatorSeries,F=y({color:a.color,visible:a.visible},u(d)?l.navigator.series:d);h&&!1===f.navigatorOptions.adaptToUpdatedData||(e.name="Navigator "+t.length,p=a.options||{},A=p.navigatorOptions||{},v=b(p,e,F,A),v.pointRange=c(F.pointRange,A.pointRange,l.plotOptions[v.type||"line"].pointRange),F=A.data||F.data,f.hasNavigatorData=f.hasNavigatorData||!!F,v.data=F||p.data&&p.data.slice(0),h&&h.options?h.update(v,n):(a.navigatorSeries=g.initSeries(v),
a.navigatorSeries.baseSeries=a,G.push(a.navigatorSeries)))});if(d.data&&(!t||!t.length)||u(d))f.hasNavigatorData=!1,d=a(d),d.forEach(function(a,h){e.name="Navigator "+(G.length+1);v=b(l.navigator.series,{color:g.series[h]&&!g.series[h].options.isInternal&&g.series[h].color||g.options.colors[h]||g.options.colors[0]},e,a);v.data=a.data;v.data&&(f.hasNavigatorData=!0,G.push(g.initSeries(v)))});h&&this.addBaseSeriesEvents()};n.prototype.addBaseSeriesEvents=function(){var a=this,b=a.baseSeries||[];b[0]&&
b[0].xAxis&&D(b[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes);b.forEach(function(h){D(h,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)});D(h,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)});!1!==this.navigatorOptions.adaptToUpdatedData&&h.xAxis&&D(h,"updatedData",this.updatedDataHandler);D(h,"remove",function(){this.navigatorSeries&&(E(a.series,this.navigatorSeries),J(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),
delete this.navigatorSeries)})},this)};n.prototype.getBaseSeriesMin=function(a){return this.baseSeries.reduce(function(a,h){return Math.min(a,h.xData?h.xData[0]:a)},a)};n.prototype.modifyNavigatorAxisExtremes=function(){var a=this.xAxis,b;"undefined"!==typeof a.getExtremes&&(!(b=this.getUnionExtremes(!0))||b.dataMin===a.min&&b.dataMax===a.max||(a.min=b.dataMin,a.max=b.dataMax))};n.prototype.modifyBaseAxisExtremes=function(){var a=this.chart.navigator,b=this.getExtremes(),n=b.dataMin,f=b.dataMax;b=
b.max-b.min;var g=a.stickToMin,l=a.stickToMax,p=c(this.options.overscroll,0),v=a.series&&a.series[0],d=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(g){var A=n;var e=A+b}l&&(e=f+p,g||(A=Math.max(n,e-b,a.getBaseSeriesMin(v&&v.xData?v.xData[0]:-Number.MAX_VALUE))));d&&(g||l)&&w(A)&&(this.min=this.userMin=A,this.max=this.userMax=e)}a.stickToMin=a.stickToMax=null};n.prototype.updatedDataHandler=function(){var a=this.chart.navigator,b=this.navigatorSeries,n=
a.getBaseSeriesMin(this.xData[0]);a.stickToMax=a.reversedExtremes?0===Math.round(a.zoomedMin):Math.round(a.zoomedMax)>=Math.round(a.size);a.stickToMin=w(this.xAxis.min)&&this.xAxis.min<=n&&(!this.chart.fixedRange||!a.stickToMax);b&&!a.hasNavigatorData&&(b.options.pointStart=this.xData[0],b.setData(this.options.data,!1,null,!1))};n.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(D(this.chart,"redraw",function(){var a=this.navigator,b=a&&(a.baseSeries&&
a.baseSeries[0]&&a.baseSeries[0].xAxis||this.xAxis[0]);b&&a.render(b.min,b.max)}),D(this.chart,"getMargins",function(){var a=this.navigator,b=a.opposite?"plotTop":"marginBottom";this.inverted&&(b=a.opposite?"marginRight":"plotLeft");this[b]=(this[b]||0)+(a.navigatorEnabled||!this.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))};n.prototype.destroy=function(){this.removeEvents();this.xAxis&&(E(this.chart.xAxis,this.xAxis),E(this.chart.axes,this.xAxis));this.yAxis&&(E(this.chart.yAxis,this.yAxis),
E(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(a){a.destroy&&a.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(a){this[a]&&this[a].destroy&&this[a].destroy();this[a]=null},this);[this.handles].forEach(function(a){H(a)},this)};return n}();x.Navigator||(x.Navigator=G,q.compose(k),D(r,"beforeShowResetZoom",function(){var a=this.options,b=a.navigator,f=a.rangeSelector;if((b&&
b.enabled||f&&f.enabled)&&(!p&&"x"===a.chart.zoomType||p&&"x"===a.chart.pinchType))return!1}),D(r,"beforeRender",function(){var a=this.options;if(a.navigator.enabled||a.scrollbar.enabled)this.scroller=this.navigator=new G(this)}),D(r,"afterSetChartSize",function(){var a=this.legend,b=this.navigator;if(b){var f=a&&a.options;var g=b.xAxis;var l=b.yAxis;var p=b.scrollbarHeight;this.inverted?(b.left=b.opposite?this.chartWidth-p-b.height:this.spacing[3]+p,b.top=this.plotTop+p):(b.left=this.plotLeft+p,
b.top=b.navigatorOptions.top||this.chartHeight-b.height-p-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(f&&"bottom"===f.verticalAlign&&f.enabled&&!f.floating?a.legendHeight+c(f.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));g&&l&&(this.inverted?g.options.left=l.options.left=b.left:g.options.top=l.options.top=b.top,g.setAxisSize(),l.setAxisSize())}}),D(r,"update",function(a){var n=a.options.navigator||{},f=a.options.scrollbar||{};this.navigator||
this.scroller||!n.enabled&&!f.enabled||(b(!0,this.options.navigator,n),b(!0,this.options.scrollbar,f),delete a.options.navigator,delete a.options.scrollbar)}),D(r,"afterUpdate",function(a){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new G(this),c(a.redraw,!0)&&this.redraw(a.animation))}),D(r,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),D(g,"afterUpdate",function(){this.chart.navigator&&
!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),r.prototype.callbacks.push(function(a){var b=a.navigator;b&&a.xAxis[0]&&(a=a.xAxis[0].getExtremes(),b.render(a.min,a.max))}));x.Navigator=G;return x.Navigator});I(k,"parts/OrdinalAxis.js",[k["parts/Axis.js"],k["parts/Globals.js"],k["parts/Utilities.js"]],function(k,e,x){var q=x.addEvent,z=x.css,r=x.defined,D=x.pick,B=x.timeUnits;x=e.Chart;var d=e.Series,J=function(){function d(d){this.index={};this.axis=d}d.prototype.getExtendedPositions=
function(){var d=this,m=d.axis,u=m.constructor.prototype,w=m.chart,b=m.series[0].currentDataGrouping,c=d.index,C=b?b.count+b.unitName:"raw",a=m.options.overscroll,l=m.getExtremes(),f;c||(c=d.index={});if(!c[C]){var p={series:[],chart:w,getExtremes:function(){return{min:l.dataMin,max:l.dataMax+a}},options:{ordinal:!0},ordinal:{},ordinal2lin:u.ordinal2lin,val2lin:u.val2lin};p.ordinal.axis=p;m.series.forEach(function(a){f={xAxis:p,xData:a.xData.slice(),chart:w,destroyGroupedData:e.noop,getProcessedData:e.Series.prototype.getProcessedData};
f.xData=f.xData.concat(d.getOverscrollPositions());f.options={dataGrouping:b?{enabled:!0,forced:!0,approximation:"open",units:[[b.unitName,[b.count]]]}:{enabled:!1}};a.processData.apply(f);p.series.push(f)});m.beforeSetTickPositions.apply(p);c[C]=p.ordinal.positions}return c[C]};d.prototype.getGroupIntervalFactor=function(d,e,u){u=u.processedXData;var m=u.length,b=[];var c=this.groupIntervalFactor;if(!c){for(c=0;c<m-1;c++)b[c]=u[c+1]-u[c];b.sort(function(b,a){return b-a});b=b[Math.floor(m/2)];d=Math.max(d,
u[0]);e=Math.min(e,u[m-1]);this.groupIntervalFactor=c=m*b/(e-d)}return c};d.prototype.getOverscrollPositions=function(){var d=this.axis,e=d.options.overscroll,u=this.overscrollPointsRange,w=[],b=d.dataMax;if(r(u))for(w.push(b);b<=d.dataMax+e;)b+=u,w.push(b);return w};d.prototype.postProcessTickInterval=function(d){var e=this.axis,u=this.slope;return u?e.options.breaks?e.closestPointRange||d:d/(u/e.closestPointRange):d};return d}(),H=function(){function d(){}d.compose=function(d,e,u){d.keepProps.push("ordinal");
var m=d.prototype;m.beforeSetTickPositions=function(){var b=this.ordinal,c=[],d,a=!1,l=this.getExtremes(),f=l.min,p=l.max,g,v=this.isXAxis&&!!this.options.breaks;l=this.options.ordinal;var A=Number.MAX_VALUE,e=this.chart.options.chart.ignoreHiddenSeries,n;if(l||v){this.series.forEach(function(a,b){d=[];if(!(e&&!1===a.visible||!1===a.takeOrdinalPosition&&!v)&&(c=c.concat(a.processedXData),h=c.length,c.sort(function(a,b){return a-b}),A=Math.min(A,D(a.closestPointRange,A)),h)){for(b=0;b<h-1;)c[b]!==
c[b+1]&&d.push(c[b+1]),b++;d[0]!==c[0]&&d.unshift(c[0]);c=d}a.isSeriesBoosting&&(n=!0)});n&&(c.length=0);var h=c.length;if(2<h){var t=c[1]-c[0];for(g=h-1;g--&&!a;)c[g+1]-c[g]!==t&&(a=!0);!this.options.keepOrdinalPadding&&(c[0]-f>t||p-c[c.length-1]>t)&&(a=!0)}else this.options.overscroll&&(2===h?A=c[1]-c[0]:1===h?(A=this.options.overscroll,c=[c[0],c[0]+A]):A=b.overscrollPointsRange);a?(this.options.overscroll&&(b.overscrollPointsRange=A,c=c.concat(b.getOverscrollPositions())),b.positions=c,t=this.ordinal2lin(Math.max(f,
c[0]),!0),g=Math.max(this.ordinal2lin(Math.min(p,c[c.length-1]),!0),1),b.slope=p=(p-f)/(g-t),b.offset=f-t*p):(b.overscrollPointsRange=D(this.closestPointRange,b.overscrollPointsRange),b.positions=this.ordinal.slope=b.offset=void 0)}this.isOrdinal=l&&a;b.groupIntervalFactor=null};d.prototype.getTimeTicks=function(b,c,d,a,l,f,p){void 0===l&&(l=[]);void 0===f&&(f=0);var g=0,v,e,G={},n=[],h=-Number.MAX_VALUE,t=this.options.tickPixelInterval,F=this.chart.time,K=[];if(!this.options.ordinal&&!this.options.breaks||
!l||3>l.length||"undefined"===typeof c)return F.getTimeTicks.apply(F,arguments);var m=l.length;for(v=0;v<m;v++){var C=v&&l[v-1]>d;l[v]<c&&(g=v);if(v===m-1||l[v+1]-l[v]>5*f||C){if(l[v]>h){for(e=F.getTimeTicks(b,l[g],l[v],a);e.length&&e[0]<=h;)e.shift();e.length&&(h=e[e.length-1]);K.push(n.length);n=n.concat(e)}g=v+1}if(C)break}e=e.info;if(p&&e.unitRange<=B.hour){v=n.length-1;for(g=1;g<v;g++)if(F.dateFormat("%d",n[g])!==F.dateFormat("%d",n[g-1])){G[n[g]]="day";var u=!0}u&&(G[n[0]]="day");e.higherRanks=
G}e.segmentStarts=K;n.info=e;if(p&&r(t)){g=K=n.length;u=[];var w;for(F=[];g--;)v=this.translate(n[g]),w&&(F[g]=w-v),u[g]=w=v;F.sort();F=F[Math.floor(F.length/2)];F<.6*t&&(F=null);g=n[K-1]>d?K-1:K;for(w=void 0;g--;)v=u[g],K=Math.abs(w-v),w&&K<.8*t&&(null===F||K<.8*F)?(G[n[g]]&&!G[n[g+1]]?(K=g+1,w=v):K=g,n.splice(K,1)):w=v}return n};m.lin2val=function(b,c){var d=this.ordinal,a=d.positions;if(a){var l=d.slope,f=d.offset;d=a.length-1;if(c)if(0>b)b=a[0];else if(b>d)b=a[d];else{d=Math.floor(b);var p=b-
d}else for(;d--;)if(c=l*d+f,b>=c){l=l*(d+1)+f;p=(b-c)/(l-c);break}return"undefined"!==typeof p&&"undefined"!==typeof a[d]?a[d]+(p?p*(a[d+1]-a[d]):0):b}return b};m.val2lin=function(b,c){var d=this.ordinal,a=d.positions;if(a){var l=a.length,f;for(f=l;f--;)if(a[f]===b){var p=f;break}for(f=l-1;f--;)if(b>a[f]||0===f){b=(b-a[f])/(a[f+1]-a[f]);p=f+b;break}c=c?p:d.slope*(p||0)+d.offset}else c=b;return c};m.ordinal2lin=m.val2lin;q(d,"afterInit",function(){this.ordinal||(this.ordinal=new J(this))});q(d,"foundExtremes",
function(){this.isXAxis&&r(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&r(this.userMin)&&(this.min+=this.options.overscroll))});q(d,"afterSetScale",function(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)});q(e,"pan",function(b){var c=this.xAxis[0],d=
c.options.overscroll,a=b.originalEvent.chartX,l=this.options.chart&&this.options.chart.panning,f=!1;if(l&&"y"!==l.type&&c.options.ordinal&&c.series.length){var p=this.mouseDownX,g=c.getExtremes(),v=g.dataMax,e=g.min,G=g.max,n=this.hoverPoints,h=c.closestPointRange||c.ordinal&&c.ordinal.overscrollPointsRange;p=(p-a)/(c.translationSlope*(c.ordinal.slope||h));var t={ordinal:{positions:c.ordinal.getExtendedPositions()}};h=c.lin2val;var F=c.val2lin;if(!t.ordinal.positions)f=!0;else if(1<Math.abs(p)){n&&
n.forEach(function(a){a.setState()});if(0>p){n=t;var m=c.ordinal.positions?c:t}else n=c.ordinal.positions?c:t,m=t;t=m.ordinal.positions;v>t[t.length-1]&&t.push(v);this.fixedRange=G-e;p=c.navigatorAxis.toFixedRange(null,null,h.apply(n,[F.apply(n,[e,!0])+p,!0]),h.apply(m,[F.apply(m,[G,!0])+p,!0]));p.min>=Math.min(g.dataMin,e)&&p.max<=Math.max(v,G)+d&&c.setExtremes(p.min,p.max,!0,!1,{trigger:"pan"});this.mouseDownX=a;z(this.container,{cursor:"move"})}}else f=!0;f||l&&/y/.test(l.type)?d&&(c.max=c.dataMax+
d):b.preventDefault()});q(u,"updatedData",function(){var b=this.xAxis;b&&b.options.ordinal&&delete b.ordinal.index})};return d}();H.compose(k,x,d);return H});I(k,"modules/broken-axis.src.js",[k["parts/Axis.js"],k["parts/Globals.js"],k["parts/Utilities.js"],k["parts/Stacking.js"]],function(k,e,x,q){var z=x.addEvent,r=x.find,D=x.fireEvent,B=x.isArray,d=x.isNumber,J=x.pick,H=e.Series,E=function(){function d(d){this.hasBreaks=!1;this.axis=d}d.isInBreak=function(d,e){var m=d.repeat||Infinity,b=d.from,
c=d.to-d.from;e=e>=b?(e-b)%m:m-(b-e)%m;return d.inclusive?e<=c:e<c&&0!==e};d.lin2Val=function(e){var m=this.brokenAxis;m=m&&m.breakArray;if(!m)return e;var w;for(w=0;w<m.length;w++){var b=m[w];if(b.from>=e)break;else b.to<e?e+=b.len:d.isInBreak(b,e)&&(e+=b.len)}return e};d.val2Lin=function(e){var m=this.brokenAxis;m=m&&m.breakArray;if(!m)return e;var w=e,b;for(b=0;b<m.length;b++){var c=m[b];if(c.to<=e)w-=c.len;else if(c.from>=e)break;else if(d.isInBreak(c,e)){w-=e-c.from;break}}return w};d.prototype.findBreakAt=
function(d,e){return r(e,function(e){return e.from<d&&d<e.to})};d.prototype.isInAnyBreak=function(e,r){var m=this.axis,b=m.options.breaks,c=b&&b.length,C;if(c){for(;c--;)if(d.isInBreak(b[c],e)){var a=!0;C||(C=J(b[c].showPoints,!m.isXAxis))}var l=a&&r?a&&!C:a}return l};d.prototype.setBreaks=function(e,r){var m=this,b=m.axis,c=B(e)&&!!e.length;b.isDirty=m.hasBreaks!==c;m.hasBreaks=c;b.options.breaks=b.userOptions.breaks=e;b.forceRedraw=!0;b.series.forEach(function(b){b.isDirty=!0});c||b.val2lin!==d.val2Lin||
(delete b.val2lin,delete b.lin2val);c&&(b.userOptions.ordinal=!1,b.lin2val=d.lin2Val,b.val2lin=d.val2Lin,b.setExtremes=function(b,a,c,f,d){if(m.hasBreaks){for(var g,l=this.options.breaks;g=m.findBreakAt(b,l);)b=g.to;for(;g=m.findBreakAt(a,l);)a=g.from;a<b&&(a=b)}k.prototype.setExtremes.call(this,b,a,c,f,d)},b.setAxisTranslation=function(c){k.prototype.setAxisTranslation.call(this,c);m.unitLength=null;if(m.hasBreaks){c=b.options.breaks||[];var a=[],l=[],f=0,p,g=b.userMin||b.min,e=b.userMax||b.max,
A=J(b.pointRangePadding,0),G;c.forEach(function(a){p=a.repeat||Infinity;d.isInBreak(a,g)&&(g+=a.to%p-g%p);d.isInBreak(a,e)&&(e-=e%p-a.from%p)});c.forEach(function(b){h=b.from;for(p=b.repeat||Infinity;h-p>g;)h-=p;for(;h<g;)h+=p;for(G=h;G<e;G+=p)a.push({value:G,move:"in"}),a.push({value:G+(b.to-b.from),move:"out",size:b.breakSize})});a.sort(function(a,b){return a.value===b.value?("in"===a.move?0:1)-("in"===b.move?0:1):a.value-b.value});var n=0;var h=g;a.forEach(function(a){n+="in"===a.move?1:-1;1===
n&&"in"===a.move&&(h=a.value);0===n&&(l.push({from:h,to:a.value,len:a.value-h-(a.size||0)}),f+=a.value-h-(a.size||0))});b.breakArray=m.breakArray=l;m.unitLength=e-g-f+A;D(b,"afterBreaks");b.staticScale?b.transA=b.staticScale:m.unitLength&&(b.transA*=(e-b.min+A)/m.unitLength);A&&(b.minPixelPadding=b.transA*b.minPointOffset);b.min=g;b.max=e}});J(r,!0)&&b.chart.redraw()};return d}();e=function(){function e(){}e.compose=function(e,r){e.keepProps.push("brokenAxis");var m=H.prototype;m.drawBreaks=function(b,
c){var e=this,a=e.points,l,f,p,g;if(b&&b.brokenAxis&&b.brokenAxis.hasBreaks){var v=b.brokenAxis;c.forEach(function(c){l=v&&v.breakArray||[];f=b.isXAxis?b.min:J(e.options.threshold,b.min);a.forEach(function(a){g=J(a["stack"+c.toUpperCase()],a[c]);l.forEach(function(n){if(d(f)&&d(g)){p=!1;if(f<n.from&&g>n.to||f>n.from&&g<n.from)p="pointBreak";else if(f<n.from&&g>n.from&&g<n.to||f>n.from&&g>n.to&&g<n.from)p="pointInBreak";p&&D(b,p,{point:a,brk:n})}})})})}};m.gappedPath=function(){var b=this.currentDataGrouping,
c=b&&b.gapSize;b=this.options.gapSize;var d=this.points.slice(),a=d.length-1,l=this.yAxis,f;if(b&&0<a)for("value"!==this.options.gapUnit&&(b*=this.basePointRange),c&&c>b&&c>=this.basePointRange&&(b=c),f=void 0;a--;)f&&!1!==f.visible||(f=d[a+1]),c=d[a],!1!==f.visible&&!1!==c.visible&&(f.x-c.x>b&&(f=(c.x+f.x)/2,d.splice(a+1,0,{isNull:!0,x:f}),l.stacking&&this.options.stacking&&(f=l.stacking.stacks[this.stackKey][f]=new q(l,l.options.stackLabels,!1,f,this.stack),f.total=0)),f=c);return this.getGraphPath(d)};
z(e,"init",function(){this.brokenAxis||(this.brokenAxis=new E(this))});z(e,"afterInit",function(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)});z(e,"afterSetTickPositions",function(){var b=this.brokenAxis;if(b&&b.hasBreaks){var c=this.tickPositions,d=this.tickPositions.info,a=[],l;for(l=0;l<c.length;l++)b.isInAnyBreak(c[l])||a.push(c[l]);this.tickPositions=a;this.tickPositions.info=d}});z(e,"afterSetOptions",function(){this.brokenAxis&&this.brokenAxis.hasBreaks&&
(this.options.ordinal=!1)});z(r,"afterGeneratePoints",function(){var b=this.options.connectNulls,c=this.points,d=this.xAxis,a=this.yAxis;if(this.isDirty)for(var l=c.length;l--;){var f=c[l],p=!(null===f.y&&!1===b)&&(d&&d.brokenAxis&&d.brokenAxis.isInAnyBreak(f.x,!0)||a&&a.brokenAxis&&a.brokenAxis.isInAnyBreak(f.y,!0));f.visible=p?!1:!1!==f.options.visible}});z(r,"afterRender",function(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,J(this.pointArrayMap,["y"]))})};return e}();e.compose(k,
H);return e});I(k,"masters/modules/broken-axis.src.js",[],function(){});I(k,"parts/DataGrouping.js",[k["parts/DateTimeAxis.js"],k["parts/Globals.js"],k["parts/Point.js"],k["parts/Tooltip.js"],k["parts/Utilities.js"]],function(k,e,x,q,z){"";var r=z.addEvent,D=z.arrayMax,B=z.arrayMin,d=z.correctFloat,J=z.defined,H=z.error,E=z.extend,y=z.format,m=z.isNumber,u=z.merge,w=z.pick,b=e.Axis,c=e.defaultPlotOptions;z=e.Series;var C=e.approximations={sum:function(a){var b=a.length;if(!b&&a.hasNulls)var f=null;
else if(b)for(f=0;b--;)f+=a[b];return f},average:function(a){var b=a.length;a=C.sum(a);m(a)&&b&&(a=d(a/b));return a},averages:function(){var a=[];[].forEach.call(arguments,function(b){a.push(C.average(b))});return"undefined"===typeof a[0]?void 0:a},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},high:function(a){return a.length?D(a):a.hasNulls?null:void 0},low:function(a){return a.length?B(a):a.hasNulls?null:void 0},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},
ohlc:function(a,b,f,g){a=C.open(a);b=C.high(b);f=C.low(f);g=C.close(g);if(m(a)||m(b)||m(f)||m(g))return[a,b,f,g]},range:function(a,b){a=C.low(a);b=C.high(b);if(m(a)||m(b))return[a,b];if(null===a&&null===b)return null}},a=function(a,b,f,g){var c=this,d=c.data,h=c.options&&c.options.data,n=[],l=[],p=[],e=a.length,t=!!b,v=[],A=c.pointArrayMap,G=A&&A.length,F=["x"].concat(A||["y"]),r=0,w=0,k;g="function"===typeof g?g:C[g]?C[g]:C[c.getDGApproximation&&c.getDGApproximation()||"average"];G?A.forEach(function(){v.push([])}):
v.push([]);var B=G||1;for(k=0;k<=e&&!(a[k]>=f[0]);k++);for(k;k<=e;k++){for(;"undefined"!==typeof f[r+1]&&a[k]>=f[r+1]||k===e;){var q=f[r];c.dataGroupInfo={start:c.cropStart+w,length:v[0].length};var z=g.apply(c,v);c.pointClass&&!J(c.dataGroupInfo.options)&&(c.dataGroupInfo.options=u(c.pointClass.prototype.optionsToObject.call({series:c},c.options.data[c.cropStart+w])),F.forEach(function(a){delete c.dataGroupInfo.options[a]}));"undefined"!==typeof z&&(n.push(q),l.push(z),p.push(c.dataGroupInfo));w=
k;for(q=0;q<B;q++)v[q].length=0,v[q].hasNulls=!1;r+=1;if(k===e)break}if(k===e)break;if(A)for(q=c.cropStart+k,z=d&&d[q]||c.pointClass.prototype.applyOptions.apply({series:c},[h[q]]),q=0;q<G;q++){var y=z[A[q]];m(y)?v[q].push(y):null===y&&(v[q].hasNulls=!0)}else q=t?b[k]:null,m(q)?v[0].push(q):null===q&&(v[0].hasNulls=!0)}return{groupedXData:n,groupedYData:l,groupMap:p}},l={approximations:C,groupData:a},f=z.prototype,p=f.processData,g=f.generatePoints,v={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L",
"%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},A={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},
candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5}},G=e.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];f.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};f.groupData=a;f.processData=function(){var a=this.chart,b=this.options.dataGrouping,c=!1!==this.allowDG&&
b&&w(b.enabled,a.options.isStock),g=this.visible||!a.options.chart.ignoreHiddenSeries,d,l=this.currentDataGrouping,e=!1;this.forceCrop=c;this.groupPixelWidth=null;this.hasProcessed=!0;c&&!this.requireSorting&&(this.requireSorting=e=!0);c=!1===p.apply(this,arguments)||!c;e&&(this.requireSorting=!1);if(!c){this.destroyGroupedData();c=b.groupAll?this.xData:this.processedXData;var v=b.groupAll?this.yData:this.processedYData,A=a.plotSizeX;a=this.xAxis;var m=a.options.ordinal,r=this.groupPixelWidth=a.getGroupPixelWidth&&
a.getGroupPixelWidth();if(r){this.isDirty=d=!0;this.points=null;e=a.getExtremes();var q=e.min;e=e.max;m=m&&a.ordinal&&a.ordinal.getGroupIntervalFactor(q,e,this)||1;r=r*(e-q)/A*m;A=a.getTimeTicks(k.AdditionsClass.prototype.normalizeTimeTickInterval(r,b.units||G),Math.min(q,c[0]),Math.max(e,c[c.length-1]),a.options.startOfWeek,c,this.closestPointRange);v=f.groupData.apply(this,[c,v,A,b.approximation]);c=v.groupedXData;m=v.groupedYData;var B=0;if(b.smoothed&&c.length){var u=c.length-1;for(c[u]=Math.min(c[u],
e);u--&&0<u;)c[u]+=r/2;c[0]=Math.max(c[0],q)}for(u=1;u<A.length;u++)A.info.segmentStarts&&-1!==A.info.segmentStarts.indexOf(u)||(B=Math.max(A[u]-A[u-1],B));q=A.info;q.gapSize=B;this.closestPointRange=A.info.totalRange;this.groupMap=v.groupMap;if(J(c[0])&&c[0]<a.min&&g){if(!J(a.options.min)&&a.min<=a.dataMin||a.min===a.dataMin)a.min=Math.min(c[0],a.min);a.dataMin=Math.min(c[0],a.dataMin)}b.groupAll&&(b=this.cropData(c,m,a.min,a.max,1),c=b.xData,m=b.yData);this.processedXData=c;this.processedYData=
m}else this.groupMap=null;this.hasGroupedData=d;this.currentDataGrouping=q;this.preventGraphAnimation=(l&&l.totalRange)!==(q&&q.totalRange)}};f.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(a,b){a&&(this.groupedData[b]=a.destroy?a.destroy():null)},this),this.groupedData.length=0)};f.generatePoints=function(){g.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null};r(x,"update",function(){if(this.dataGroup)return H(24,!1,this.series.chart),
!1});r(q,"headerFormatter",function(a){var b=this.chart,c=b.time,f=a.labelConfig,g=f.series,d=g.tooltipOptions,l=g.options.dataGrouping,n=d.xDateFormat,e=g.xAxis,p=d[(a.isFooter?"footer":"header")+"Format"];if(e&&"datetime"===e.options.type&&l&&m(f.key)){var A=g.currentDataGrouping;l=l.dateTimeLabelFormats||v.dateTimeLabelFormats;if(A)if(d=l[A.unitName],1===A.count)n=d[0];else{n=d[1];var G=d[2]}else!n&&l&&(n=this.getXDateFormat(f,d,e));n=c.dateFormat(n,f.key);G&&(n+=c.dateFormat(G,f.key+A.totalRange-
1));g.chart.styledMode&&(p=this.styledModeFormat(p));a.text=y(p,{point:E(f.point,{key:n}),series:g},b);a.preventDefault()}});r(z,"destroy",f.destroyGroupedData);r(z,"afterSetOptions",function(a){a=a.options;var b=this.type,f=this.chart.options.plotOptions,g=c[b].dataGrouping,d=this.useCommonDataGrouping&&v;if(A[b]||d)g||(g=u(v,A[b])),a.dataGrouping=u(d,g,f.series&&f.series.dataGrouping,f[b].dataGrouping,this.userOptions.dataGrouping)});r(b,"afterSetScale",function(){this.series.forEach(function(a){a.hasProcessed=
!1})});b.prototype.getGroupPixelWidth=function(){var a=this.series,b=a.length,c,f=0,g=!1,d;for(c=b;c--;)(d=a[c].options.dataGrouping)&&(f=Math.max(f,w(d.groupPixelWidth,v.groupPixelWidth)));for(c=b;c--;)(d=a[c].options.dataGrouping)&&a[c].hasProcessed&&(b=(a[c].processedXData||a[c].data).length,a[c].groupPixelWidth||b>this.chart.plotSizeX/f||b&&d.forced)&&(g=!0);return g?f:0};b.prototype.setDataGrouping=function(a,c){var f;c=w(c,!0);a||(a={forced:!1,units:null});if(this instanceof b)for(f=this.series.length;f--;)this.series[f].update({dataGrouping:a},
!1);else this.chart.options.series.forEach(function(b){b.dataGrouping=a},!1);this.ordinal&&(this.ordinal.slope=void 0);c&&this.chart.redraw()};e.dataGrouping=l;"";return l});I(k,"parts/OHLCSeries.js",[k["parts/Globals.js"],k["parts/Point.js"],k["parts/Utilities.js"]],function(k,e,x){x=x.seriesType;var q=k.seriesTypes;x("ohlc","column",{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},
threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0},{directTouch:!1,pointArrayMap:["open","high","low","close"],toYData:function(e){return[e.open,e.high,e.low,e.close]},pointValKey:"close",pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},init:function(){q.column.prototype.init.apply(this,arguments);this.options.stacking=void 0},pointAttribs:function(e,r){r=q.column.prototype.pointAttribs.call(this,e,r);var k=this.options;delete r.fill;!e.options.color&&k.upColor&&e.open<e.close&&
(r.stroke=k.upColor);return r},translate:function(){var e=this,r=e.yAxis,k=!!e.modifyValue,B=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];q.column.prototype.translate.apply(e);e.points.forEach(function(d){[d.open,d.high,d.low,d.close,d.low].forEach(function(q,z){null!==q&&(k&&(q=e.modifyValue(q)),d[B[z]]=r.toPixels(q,!0))});d.tooltipPos[1]=d.plotHigh+r.pos-e.chart.plotTop})},drawPoints:function(){var e=this,r=e.chart,q=function(e,d,r){var q=e[0];e=e[1];"number"===typeof q[2]&&(q[2]=Math.max(r+
d,q[2]));"number"===typeof e[2]&&(e[2]=Math.min(r-d,e[2]))};e.points.forEach(function(k){var d=k.graphic,B=!d;if("undefined"!==typeof k.plotY){d||(k.graphic=d=r.renderer.path().add(e.group));r.styledMode||d.attr(e.pointAttribs(k,k.selected&&"select"));var z=d.strokeWidth();var x=z%2/2;var y=Math.round(k.plotX)-x;var m=Math.round(k.shapeArgs.width/2);var u=[["M",y,Math.round(k.yBottom)],["L",y,Math.round(k.plotHigh)]];if(null!==k.open){var w=Math.round(k.plotOpen)+x;u.push(["M",y,w],["L",y-m,w]);q(u,
z/2,w)}null!==k.close&&(w=Math.round(k.plotClose)+x,u.push(["M",y,w],["L",y+m,w]),q(u,z/2,w));d[B?"attr":"animate"]({d:u}).addClass(k.getClassName(),!0)}})},animate:null},{getClassName:function(){return e.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")}});""});I(k,"parts/CandlestickSeries.js",[k["parts/Globals.js"],k["parts/Utilities.js"]],function(k,e){var x=e.merge;e=e.seriesType;var q=k.defaultPlotOptions,z=k.seriesTypes;e("candlestick",
"ohlc",x(q.column,{states:{hover:{lineWidth:2}},tooltip:q.ohlc.tooltip,threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}),{pointAttribs:function(e,k){var q=z.column.prototype.pointAttribs.call(this,e,k),d=this.options,r=e.open<e.close,x=d.lineColor||this.color;q["stroke-width"]=d.lineWidth;q.fill=e.options.color||(r?d.upColor||this.color:this.color);q.stroke=e.options.lineColor||(r?d.upLineColor||x:x);k&&(e=d.states[k],q.fill=e.color||q.fill,q.stroke=e.lineColor||
q.stroke,q["stroke-width"]=e.lineWidth||q["stroke-width"]);return q},drawPoints:function(){var e=this,q=e.chart,k=e.yAxis.reversed;e.points.forEach(function(d){var r=d.graphic,z=!r;if("undefined"!==typeof d.plotY){r||(d.graphic=r=q.renderer.path().add(e.group));e.chart.styledMode||r.attr(e.pointAttribs(d,d.selected&&"select")).shadow(e.options.shadow);var x=r.strokeWidth()%2/2;var y=Math.round(d.plotX)-x;var m=d.plotOpen;var u=d.plotClose;var w=Math.min(m,u);m=Math.max(m,u);var b=Math.round(d.shapeArgs.width/
2);u=k?m!==d.yBottom:Math.round(w)!==Math.round(d.plotHigh);var c=k?Math.round(w)!==Math.round(d.plotHigh):m!==d.yBottom;w=Math.round(w)+x;m=Math.round(m)+x;x=[];x.push(["M",y-b,m],["L",y-b,w],["L",y+b,w],["L",y+b,m],["Z"],["M",y,w],["L",y,u?Math.round(k?d.yBottom:d.plotHigh):w],["M",y,m],["L",y,c?Math.round(k?d.plotHigh:d.yBottom):m]);r[z?"attr":"animate"]({d:x}).addClass(d.getClassName(),!0)}})}});""});I(k,"mixins/on-series.js",[k["parts/Globals.js"],k["parts/Utilities.js"]],function(k,e){var x=
e.defined,q=e.stableSort,z=k.seriesTypes;return{getPlotBox:function(){return k.Series.prototype.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){z.column.prototype.translate.apply(this);var e=this,k=e.options,B=e.chart,d=e.points,H=d.length-1,I,E=k.onSeries;E=E&&B.get(E);k=k.onKey||"y";var y=E&&E.options.step,m=E&&E.points,u=m&&m.length,w=B.inverted,b=e.xAxis,c=e.yAxis,C=0,a;if(E&&E.visible&&u){C=(E.pointXOffset||0)+(E.barW||0)/2;B=E.currentDataGrouping;
var l=m[u-1].x+(B?B.totalRange:0);q(d,function(a,b){return a.x-b.x});for(k="plot"+k[0].toUpperCase()+k.substr(1);u--&&d[H];){var f=m[u];B=d[H];B.y=f.y;if(f.x<=B.x&&"undefined"!==typeof f[k]){if(B.x<=l&&(B.plotY=f[k],f.x<B.x&&!y&&(a=m[u+1])&&"undefined"!==typeof a[k])){var p=(B.x-f.x)/(a.x-f.x);B.plotY+=p*(a[k]-f[k]);B.y+=p*(a.y-f.y)}H--;u++;if(0>H)break}}}d.forEach(function(a,f){a.plotX+=C;if("undefined"===typeof a.plotY||w)0<=a.plotX&&a.plotX<=b.len?w?(a.plotY=b.translate(a.x,0,1,0,1),a.plotX=x(a.y)?
c.translate(a.y,0,0,0,1):0):a.plotY=(b.opposite?0:e.yAxis.len)+b.offset:a.shapeArgs={};if((I=d[f-1])&&I.plotX===a.plotX){"undefined"===typeof I.stackIndex&&(I.stackIndex=0);var g=I.stackIndex+1}a.stackIndex=g});this.onSeries=E}}});I(k,"parts/FlagsSeries.js",[k["parts/Globals.js"],k["parts/Utilities.js"],k["mixins/on-series.js"]],function(k,e,x){function q(b){w[b+"pin"]=function(c,d,a,e,f){var l=f&&f.anchorX;f=f&&f.anchorY;"circle"===b&&e>a&&(c-=Math.round((e-a)/2),a=e);var g=w[b](c,d,a,e);if(l&&f){var v=
l;"circle"===b?v=c+a/2:(c=g[0],a=g[1],"M"===c[0]&&"L"===a[0]&&(v=(c[1]+a[1])/2));g.push(["M",v,d>f?d:d+e],["L",l,f]);g=g.concat(w.circle(l-1,f-1,2,2))}return g}}var z=e.addEvent,r=e.defined,D=e.isNumber,B=e.merge,d=e.objectEach,H=e.seriesType,I=e.wrap;e=k.noop;var E=k.Renderer,y=k.Series,m=k.TrackerMixin,u=k.VMLRenderer,w=k.SVGRenderer.prototype.symbols;H("flags","column",{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}<br/>"},threshold:null,
y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd6eb"}},style:{fontSize:"11px",fontWeight:"bold"}},{sorted:!1,noSharedTooltip:!0,allowDG:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],forceCrop:!0,init:y.prototype.init,pointAttribs:function(b,c){var d=this.options,a=b&&b.color||this.color,e=d.lineColor,f=b&&b.lineWidth;b=b&&b.fillColor||d.fillColor;c&&(b=d.states[c].fillColor,e=d.states[c].lineColor,f=d.states[c].lineWidth);return{fill:b||a,stroke:e||
a,"stroke-width":f||d.lineWidth||0}},translate:x.translate,getPlotBox:x.getPlotBox,drawPoints:function(){var b=this.points,c=this.chart,e=c.renderer,a=c.inverted,l=this.options,f=l.y,p,g=this.yAxis,v={},A=[];for(p=b.length;p--;){var m=b[p];var n=(a?m.plotY:m.plotX)>this.xAxis.len;var h=m.plotX;var t=m.stackIndex;var q=m.options.shape||l.shape;var u=m.plotY;"undefined"!==typeof u&&(u=m.plotY+f-("undefined"!==typeof t&&t*l.stackDistance));m.anchorX=t?void 0:m.plotX;var w=t?void 0:m.plotY;var x="flag"!==
q;t=m.graphic;"undefined"!==typeof u&&0<=h&&!n?(t||(t=m.graphic=e.label("",null,null,q,null,null,l.useHTML),c.styledMode||t.attr(this.pointAttribs(m)).css(B(l.style,m.style)),t.attr({align:x?"center":"left",width:l.width,height:l.height,"text-align":l.textAlign}).addClass("highcharts-point").add(this.markerGroup),m.graphic.div&&(m.graphic.div.point=m),c.styledMode||t.shadow(l.shadow),t.isNew=!0),0<h&&(h-=t.strokeWidth()%2),q={y:u,anchorY:w},l.allowOverlapX&&(q.x=h,q.anchorX=m.anchorX),t.attr({text:m.options.title||
l.title||"A"})[t.isNew?"attr":"animate"](q),l.allowOverlapX||(v[m.plotX]?v[m.plotX].size=Math.max(v[m.plotX].size,t.width):v[m.plotX]={align:x?.5:0,size:t.width,target:h,anchorX:h}),m.tooltipPos=[h,u+g.pos-c.plotTop]):t&&(m.graphic=t.destroy())}l.allowOverlapX||(d(v,function(a){a.plotX=a.anchorX;A.push(a)}),k.distribute(A,a?g.len:this.xAxis.len,100),b.forEach(function(a){var b=a.graphic&&v[a.plotX];b&&(a.graphic[a.graphic.isNew?"attr":"animate"]({x:b.pos+b.align*b.size,anchorX:a.anchorX}),r(b.pos)?
a.graphic.isNew=!1:(a.graphic.attr({x:-9999,anchorX:-9999}),a.graphic.isNew=!0))}));l.useHTML&&I(this.markerGroup,"on",function(a){return k.SVGElement.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},drawTracker:function(){var b=this.points;m.drawTrackerPoint.apply(this);b.forEach(function(c){var d=c.graphic;d&&z(d.element,"mouseover",function(){0<c.stackIndex&&!c.raised&&(c._y=d.y,d.attr({y:c._y-8}),c.raised=!0);b.forEach(function(a){a!==c&&a.raised&&a.graphic&&
(a.graphic.attr({y:a._y}),a.raised=!1)})})})},animate:function(b){b&&this.setClip()},setClip:function(){y.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup.clip(this.chart[this.sharedClipKey])},buildKDTree:e,invertGroups:e},{isValid:function(){return D(this.y)||"undefined"===typeof this.y}});w.flag=function(b,c,d,a,e){var f=e&&e.anchorX||b;e=e&&e.anchorY||c;var l=w.circle(f-1,e-1,2,2);l.push(["M",f,e],["L",b,c+a],["L",b,c],["L",b+d,c],["L",b+d,c+
a],["L",b,c+a],["Z"]);return l};q("circle");q("square");E===u&&["circlepin","flag","squarepin"].forEach(function(b){u.prototype.symbols[b]=w[b]});""});I(k,"parts/RangeSelector.js",[k["parts/Globals.js"],k["parts/Utilities.js"]],function(k,e){function x(a){this.init(a)}var q=e.addEvent,z=e.createElement,r=e.css,D=e.defined,B=e.destroyObjectProperties,d=e.discardElement,H=e.extend,I=e.fireEvent,E=e.isNumber,y=e.merge,m=e.objectEach,u=e.pick,w=e.pInt,b=e.splat,c=k.Axis;e=k.Chart;var C=k.defaultOptions;
H(C,{rangeSelector:{verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputPosition:{align:"right",x:0,y:0},buttonPosition:{align:"left",x:0,y:0},labelStyle:{color:"#666666"}}});C.lang=y(C.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"From",rangeSelectorTo:"To"});x.prototype={clickButton:function(a,d){var f=this.chart,e=this.buttonOptions[a],g=f.xAxis[0],l=f.scroller&&f.scroller.getUnionExtremes()||g||{},k=l.dataMin,m=l.dataMax,n=g&&Math.round(Math.min(g.max,
u(m,g.max))),h=e.type;l=e._range;var t,r=e.dataGrouping;if(null!==k&&null!==m){f.fixedRange=l;r&&(this.forcedDataGrouping=!0,c.prototype.setDataGrouping.call(g||{chart:this.chart},r,!1),this.frozenStates=e.preserveDataGrouping);if("month"===h||"year"===h)if(g){h={range:e,max:n,chart:f,dataMin:k,dataMax:m};var w=g.minFromRange.call(h);E(h.newMax)&&(n=h.newMax)}else l=e;else if(l)w=Math.max(n-l,k),n=Math.min(w+l,m);else if("ytd"===h)if(g)"undefined"===typeof m&&(k=Number.MAX_VALUE,m=Number.MIN_VALUE,
f.series.forEach(function(a){a=a.xData;k=Math.min(a[0],k);m=Math.max(a[a.length-1],m)}),d=!1),n=this.getYTDExtremes(m,k,f.time.useUTC),w=t=n.min,n=n.max;else{this.deferredYTDClick=a;return}else"all"===h&&g&&(w=k,n=m);w+=e._offsetMin;n+=e._offsetMax;this.setSelected(a);if(g)g.setExtremes(w,n,u(d,1),null,{trigger:"rangeSelectorButton",rangeSelectorButton:e});else{var x=b(f.options.xAxis)[0];var y=x.range;x.range=l;var z=x.min;x.min=t;q(f,"load",function(){x.range=y;x.min=z})}}},setSelected:function(a){this.selected=
this.options.selected=a},defaultButtons:[{type:"month",count:1,text:"1m"},{type:"month",count:3,text:"3m"},{type:"month",count:6,text:"6m"},{type:"ytd",text:"YTD"},{type:"year",count:1,text:"1y"},{type:"all",text:"All"}],init:function(a){var b=this,c=a.options.rangeSelector,d=c.buttons||[].concat(b.defaultButtons),e=c.selected,v=function(){var a=b.minInput,c=b.maxInput;a&&a.blur&&I(a,"blur");c&&c.blur&&I(c,"blur")};b.chart=a;b.options=c;b.buttons=[];b.buttonOptions=d;this.unMouseDown=q(a.container,
"mousedown",v);this.unResize=q(a,"resize",v);d.forEach(b.computeButtonRange);"undefined"!==typeof e&&d[e]&&this.clickButton(e,!1);q(a,"load",function(){a.xAxis&&a.xAxis[0]&&q(a.xAxis[0],"setExtremes",function(c){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==c.trigger&&"updatedData"!==c.trigger&&b.forcedDataGrouping&&!b.frozenStates&&this.setDataGrouping(!1,!1)})})},updateButtonStates:function(){var a=this,b=this.chart,c=b.xAxis[0],d=Math.round(c.max-c.min),e=!c.hasVisibleSeries,v=b.scroller&&
b.scroller.getUnionExtremes()||c,k=v.dataMin,m=v.dataMax;b=a.getYTDExtremes(m,k,b.time.useUTC);var n=b.min,h=b.max,t=a.selected,q=E(t),r=a.options.allButtonsEnabled,u=a.buttons;a.buttonOptions.forEach(function(b,f){var g=b._range,l=b.type,p=b.count||1,v=u[f],A=0,w=b._offsetMax-b._offsetMin;b=f===t;var G=g>m-k,F=g<c.minRange,x=!1,y=!1;g=g===d;("month"===l||"year"===l)&&d+36E5>=864E5*{month:28,year:365}[l]*p-w&&d-36E5<=864E5*{month:31,year:366}[l]*p+w?g=!0:"ytd"===l?(g=h-n+w===d,x=!b):"all"===l&&(g=
c.max-c.min>=m-k,y=!b&&q&&g);l=!r&&(G||F||y||e);p=b&&g||g&&!q&&!x||b&&a.frozenStates;l?A=3:p&&(q=!0,A=2);v.state!==A&&(v.setState(A),0===A&&t===f&&a.setSelected(null))})},computeButtonRange:function(a){var b=a.type,c=a.count||1,d={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(d[b])a._range=d[b]*c;else if("month"===b||"year"===b)a._range=864E5*{month:30,year:365}[b]*c;a._offsetMin=u(a.offsetMin,0);a._offsetMax=u(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin},setInputValue:function(a,
b){var c=this.chart.options.rangeSelector,d=this.chart.time,e=this[a+"Input"];D(b)&&(e.previousValue=e.HCTime,e.HCTime=b);e.value=d.dateFormat(c.inputEditDateFormat||"%Y-%m-%d",e.HCTime);this[a+"DateBox"].attr({text:d.dateFormat(c.inputDateFormat||"%b %e, %Y",e.HCTime)})},showInput:function(a){var b=this.inputGroup,c=this[a+"DateBox"];r(this[a+"Input"],{left:b.translateX+c.x+"px",top:b.translateY+"px",width:c.width-2+"px",height:c.height-2+"px",border:"2px solid silver"})},hideInput:function(a){r(this[a+
"Input"],{border:0,width:"1px",height:"1px"});this.setInputValue(a)},drawInput:function(a){function b(){var a=h.value,b=(m.inputDateParser||Date.parse)(a),e=d.xAxis[0],f=d.scroller&&d.scroller.xAxis?d.scroller.xAxis:e,g=f.dataMin;f=f.dataMax;b!==h.previousValue&&(h.previousValue=b,E(b)||(b=a.split("-"),b=Date.UTC(w(b[0]),w(b[1])-1,w(b[2]))),E(b)&&(d.time.useUTC||(b+=6E4*(new Date).getTimezoneOffset()),n?b>c.maxInput.HCTime?b=void 0:b<g&&(b=g):b<c.minInput.HCTime?b=void 0:b>f&&(b=f),"undefined"!==
typeof b&&e.setExtremes(n?b:e.min,n?e.max:b,void 0,void 0,{trigger:"rangeSelectorInput"})))}var c=this,d=c.chart,e=d.renderer.style||{},v=d.renderer,m=d.options.rangeSelector,q=c.div,n="min"===a,h,t,u=this.inputGroup;this[a+"Label"]=t=v.label(C.lang[n?"rangeSelectorFrom":"rangeSelectorTo"],this.inputGroup.offset).addClass("highcharts-range-label").attr({padding:2}).add(u);u.offset+=t.width+5;this[a+"DateBox"]=v=v.label("",u.offset).addClass("highcharts-range-input").attr({padding:2,width:m.inputBoxWidth||
90,height:m.inputBoxHeight||17,"text-align":"center"}).on("click",function(){c.showInput(a);c[a+"Input"].focus()});d.styledMode||v.attr({stroke:m.inputBoxBorderColor||"#cccccc","stroke-width":1});v.add(u);u.offset+=v.width+(n?10:0);this[a+"Input"]=h=z("input",{name:a,className:"highcharts-range-selector",type:"text"},{top:d.plotTop+"px"},q);d.styledMode||(t.css(y(e,m.labelStyle)),v.css(y({color:"#333333"},e,m.inputStyle)),r(h,H({position:"absolute",border:0,width:"1px",height:"1px",padding:0,textAlign:"center",
fontSize:e.fontSize,fontFamily:e.fontFamily,top:"-9999em"},m.inputStyle)));h.onfocus=function(){c.showInput(a)};h.onblur=function(){h===k.doc.activeElement&&b();c.hideInput(a);h.blur()};h.onchange=b;h.onkeypress=function(a){13===a.keyCode&&b()}},getPosition:function(){var a=this.chart,b=a.options.rangeSelector;a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}},getYTDExtremes:function(a,b,c){var d=this.chart.time,e=new d.Date(a),
f=d.get("FullYear",e);c=c?d.Date.UTC(f,0,1):+new d.Date(f,0,1);b=Math.max(b||0,c);e=e.getTime();return{max:Math.min(a||e,e),min:b}},render:function(a,b){var c=this,d=c.chart,e=d.renderer,l=d.container,m=d.options,k=m.exporting&&!1!==m.exporting.enabled&&m.navigation&&m.navigation.buttonOptions,n=C.lang,h=c.div,t=m.rangeSelector,q=u(m.chart.style&&m.chart.style.zIndex,0)+1;m=t.floating;var r=c.buttons;h=c.inputGroup;var w=t.buttonTheme,x=t.buttonPosition,y=t.inputPosition,B=t.inputEnabled,D=w&&w.states,
E=d.plotLeft,H=c.buttonGroup,I,J=c.options.verticalAlign,P=d.legend,L=P&&P.options,Q=x.y,O=y.y,R=d.hasLoaded,S=R?"animate":"attr",N=0,M=0;if(!1!==t.enabled){c.rendered||(c.group=I=e.g("range-selector-group").attr({zIndex:7}).add(),c.buttonGroup=H=e.g("range-selector-buttons").add(I),c.zoomText=e.text(n.rangeSelectorZoom,0,15).add(H),d.styledMode||(c.zoomText.css(t.labelStyle),w["stroke-width"]=u(w["stroke-width"],0)),c.buttonOptions.forEach(function(a,b){r[b]=e.button(a.text,0,0,function(d){var e=
a.events&&a.events.click,g;e&&(g=e.call(a,d));!1!==g&&c.clickButton(b);c.isActive=!0},w,D&&D.hover,D&&D.select,D&&D.disabled).attr({"text-align":"center"}).add(H)}),!1!==B&&(c.div=h=z("div",null,{position:"relative",height:0,zIndex:q}),l.parentNode.insertBefore(h,l),c.inputGroup=h=e.g("input-group").add(I),h.offset=0,c.drawInput("min"),c.drawInput("max")));c.zoomText[S]({x:u(E+x.x,E)});var T=u(E+x.x,E)+c.zoomText.getBBox().width+5;c.buttonOptions.forEach(function(a,b){r[b][S]({x:T});T+=r[b].width+
u(t.buttonSpacing,5)});E=d.plotLeft-d.spacing[3];c.updateButtonStates();k&&this.titleCollision(d)&&"top"===J&&"right"===x.align&&x.y+H.getBBox().height-12<(k.y||0)+k.height&&(N=-40);l=x.x-d.spacing[3];"right"===x.align?l+=N-E:"center"===x.align&&(l-=E/2);H.align({y:x.y,width:H.getBBox().width,align:x.align,x:l},!0,d.spacingBox);c.group.placed=R;c.buttonGroup.placed=R;!1!==B&&(N=k&&this.titleCollision(d)&&"top"===J&&"right"===y.align&&y.y-h.getBBox().height-12<(k.y||0)+k.height+d.spacing[0]?-40:0,
"left"===y.align?l=E:"right"===y.align&&(l=-Math.max(d.axisOffset[1],-N)),h.align({y:y.y,width:h.getBBox().width,align:y.align,x:y.x+l-2},!0,d.spacingBox),k=h.alignAttr.translateX+h.alignOptions.x-N+h.getBBox().x+2,l=h.alignOptions.width,n=H.alignAttr.translateX+H.getBBox().x,E=H.getBBox().width+20,(y.align===x.align||n+E>k&&k+l>n&&Q<O+h.getBBox().height)&&h.attr({translateX:h.alignAttr.translateX+(d.axisOffset[1]>=-N?0:-N),translateY:h.alignAttr.translateY+H.getBBox().height+10}),c.setInputValue("min",
a),c.setInputValue("max",b),c.inputGroup.placed=R);c.group.align({verticalAlign:J},!0,d.spacingBox);a=c.group.getBBox().height+20;b=c.group.alignAttr.translateY;"bottom"===J&&(P=L&&"bottom"===L.verticalAlign&&L.enabled&&!L.floating?P.legendHeight+u(L.margin,10):0,a=a+P-20,M=b-a-(m?0:t.y)-(d.titleOffset?d.titleOffset[2]:0)-10);if("top"===J)m&&(M=0),d.titleOffset&&d.titleOffset[0]&&(M=d.titleOffset[0]),M+=d.margin[0]-d.spacing[0]||0;else if("middle"===J)if(O===Q)M=0>O?b+void 0:b;else if(O||Q)M=0>O||
0>Q?M-Math.min(O,Q):b-a+NaN;c.group.translate(t.x,t.y+Math.floor(M));!1!==B&&(c.minInput.style.marginTop=c.group.translateY+"px",c.maxInput.style.marginTop=c.group.translateY+"px");c.rendered=!0}},getHeight:function(){var a=this.options,b=this.group,c=a.y,d=a.buttonPosition.y,e=a.inputPosition.y;if(a.height)return a.height;a=b?b.getBBox(!0).height+13+c:0;b=Math.min(e,d);if(0>e&&0>d||0<e&&0<d)a+=Math.abs(b);return a},titleCollision:function(a){return!(a.options.title.text||a.options.subtitle.text)},
update:function(a){var b=this.chart;y(!0,b.options.rangeSelector,a);this.destroy();this.init(b);b.rangeSelector.render()},destroy:function(){var a=this,b=a.minInput,c=a.maxInput;a.unMouseDown();a.unResize();B(a.buttons);b&&(b.onfocus=b.onblur=b.onchange=null);c&&(c.onfocus=c.onblur=c.onchange=null);m(a,function(b,c){b&&"chart"!==c&&(b.destroy?b.destroy():b.nodeType&&d(this[c]));b!==x.prototype[c]&&(a[c]=null)},this)}};c.prototype.minFromRange=function(){var a=this.range,b=a.type,c=this.max,d=this.chart.time,
e=function(a,c){var e="year"===b?"FullYear":"Month",g=new d.Date(a),f=d.get(e,g);d.set(e,g,f+c);f===d.get(e,g)&&d.set("Date",g,0);return g.getTime()-a};if(E(a)){var m=c-a;var k=a}else m=c+e(c,-a.count),this.chart&&(this.chart.fixedRange=c-m);var q=u(this.dataMin,Number.MIN_VALUE);E(m)||(m=q);m<=q&&(m=q,"undefined"===typeof k&&(k=e(m,a.count)),this.newMax=Math.min(m+k,this.dataMax));E(c)||(m=void 0);return m};k.RangeSelector||(q(e,"afterGetContainer",function(){this.options.rangeSelector.enabled&&
(this.rangeSelector=new x(this))}),q(e,"beforeRender",function(){var a=this.axes,b=this.rangeSelector;b&&(E(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))}),q(e,"update",function(a){var b=a.options.rangeSelector;a=this.rangeSelector;var c=this.extraBottomMargin,
d=this.extraTopMargin;b&&b.enabled&&!D(a)&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=new x(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(a.render(),b=b&&b.verticalAlign||a.options&&a.options.verticalAlign,a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0)),this.extraBottomMargin!==c||this.extraTopMargin!==d)&&(this.isDirtyBox=!0)}),q(e,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,
"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}),q(e,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}),e.prototype.callbacks.push(function(a){function b(){c=a.xAxis[0].getExtremes();e=a.legend;k=null===d||void 0===d?void 0:d.options.verticalAlign;E(c.min)&&d.render(c.min,c.max);d&&e.display&&"top"===k&&k===e.options.verticalAlign&&(m=y(a.spacingBox),m.y="vertical"===
e.options.layout?a.plotTop:m.y+d.getHeight(),e.group.placed=!1,e.align(m))}var c,d=a.rangeSelector,e,m,k;if(d){var r=q(a.xAxis[0],"afterSetExtremes",function(a){d.render(a.min,a.max)});var n=q(a,"redraw",b);b()}q(a,"destroy",function(){d&&(n(),r())})}),k.RangeSelector=x)});I(k,"parts/StockChart.js",[k["parts/Axis.js"],k["parts/Globals.js"],k["parts/Point.js"],k["parts/Utilities.js"]],function(k,e,x,q){var z=q.addEvent,r=q.arrayMax,D=q.arrayMin,B=q.clamp,d=q.defined,H=q.extend,I=q.find,E=q.format,
y=q.isNumber,m=q.isString,u=q.merge,w=q.pick,b=q.splat,c=e.Chart;q=e.Series;var C=e.SVGRenderer,a=q.prototype,l=a.init,f=a.processData,p=x.prototype.tooltipFormatter;e.StockChart=e.stockChart=function(a,d,f){var g=m(a)||a.nodeName,n=arguments[g?1:0],h=n,l=n.series,k=e.getOptions(),v,p=w(n.navigator&&n.navigator.enabled,k.navigator.enabled,!0);n.xAxis=b(n.xAxis||{}).map(function(a,b){return u({minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0},
k.xAxis,k.xAxis&&k.xAxis[b],a,{type:"datetime",categories:null},p?{startOnTick:!1,endOnTick:!1}:null)});n.yAxis=b(n.yAxis||{}).map(function(a,b){v=w(a.opposite,!0);return u({labels:{y:-2},opposite:v,showLastLabel:!(!a.categories&&"category"!==a.type),title:{text:null}},k.yAxis,k.yAxis&&k.yAxis[b],a)});n.series=null;n=u({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:p},scrollbar:{enabled:w(k.scrollbar.enabled,!0)},rangeSelector:{enabled:w(k.rangeSelector.enabled,!0)},title:{text:null},
tooltip:{split:w(k.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},n,{isStock:!0});n.series=h.series=l;return g?new c(a,n,f):new c(n,d)};z(q,"setOptions",function(a){var b;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?b={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(b={marker:{enabled:!1,radius:2}}),b&&(a.plotOptions[this.type]=u(a.plotOptions[this.type],b)))});z(k,"autoLabelAlign",function(a){var b=this.chart,c=this.options;b=b._labelPanes=b._labelPanes||
{};var d=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(c=c.top+","+c.height,!b[c]&&d.enabled&&(15===d.x&&(d.x=0),"undefined"===typeof d.align&&(d.align="right"),b[c]=this,a.align="right",a.preventDefault()))});z(k,"destroy",function(){var a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});z(k,"getPlotLinePath",function(a){function b(a){var b="xAxis"===a?"yAxis":"xAxis";a=c.options[b];return y(a)?
[f[b][a]]:m(a)?[f.get(a)]:e.map(function(a){return a[b]})}var c=this,e=this.isLinked&&!this.series?this.linkedParent.series:this.series,f=c.chart,g=f.renderer,k=c.left,l=c.top,p,q,r,u,x=[],z=[],E=a.translatedValue,D=a.value,C=a.force;if(f.options.isStock&&!1!==a.acrossPanes&&"xAxis"===c.coll||"yAxis"===c.coll){a.preventDefault();z=b(c.coll);var H=c.isXAxis?f.yAxis:f.xAxis;H.forEach(function(a){if(d(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var b=a.isXAxis?"yAxis":"xAxis";b=d(a.options[b])?
f[b][a.options[b]]:f[b][0];c===b&&z.push(a)}});var J=z.length?[]:[c.isXAxis?f.yAxis[0]:f.xAxis[0]];z.forEach(function(a){-1!==J.indexOf(a)||I(J,function(b){return b.pos===a.pos&&b.len===a.len})||J.push(a)});var L=w(E,c.translate(D,null,null,a.old));y(L)&&(c.horiz?J.forEach(function(a){var b;q=a.pos;u=q+a.len;p=r=Math.round(L+c.transB);"pass"!==C&&(p<k||p>k+c.width)&&(C?p=r=B(p,k,k+c.width):b=!0);b||x.push(["M",p,q],["L",r,u])}):J.forEach(function(a){var b;p=a.pos;r=p+a.len;q=u=Math.round(l+c.height-
L);"pass"!==C&&(q<l||q>l+c.height)&&(C?q=u=B(q,l,l+c.height):b=!0);b||x.push(["M",p,q],["L",r,u])}));a.path=0<x.length?g.crispPolyLine(x,a.lineWidth||1):null}});C.prototype.crispPolyLine=function(a,b){for(var c=0;c<a.length;c+=2){var d=a[c],e=a[c+1];d[1]===e[1]&&(d[1]=e[1]=Math.round(d[1])-b%2/2);d[2]===e[2]&&(d[2]=e[2]=Math.round(d[2])+b%2/2)}return a};z(k,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});z(k,"afterDrawCrosshair",function(a){var b,c;if(d(this.crosshair.label)&&
this.crosshair.label.enabled&&this.cross){var e=this.chart,f=this.logarithmic,g=this.options.crosshair.label,k=this.horiz,l=this.opposite,m=this.left,p=this.top,q=this.crossLabel,r=g.format,u="",x="inside"===this.options.tickPosition,y=!1!==this.crosshair.snap,z=0,B=a.e||this.cross&&this.cross.e,C=a.point;a=this.min;var D=this.max;f&&(a=f.lin2log(a),D=f.lin2log(D));f=k?"center":l?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";q||(q=this.crossLabel=e.renderer.label(null,
null,null,g.shape||"callout").addClass("highcharts-crosshair-label"+(this.series[0]&&" highcharts-color-"+this.series[0].colorIndex)).attr({align:g.align||f,padding:w(g.padding,8),r:w(g.borderRadius,3),zIndex:2}).add(this.labelGroup),e.styledMode||q.attr({fill:g.backgroundColor||this.series[0]&&this.series[0].color||"#666666",stroke:g.borderColor||"","stroke-width":g.borderWidth||0}).css(H({color:"#ffffff",fontWeight:"normal",fontSize:"11px",textAlign:"center"},g.style)));k?(f=y?C.plotX+m:B.chartX,
p+=l?0:this.height):(f=l?this.width+m:0,p=y?C.plotY+p:B.chartY);r||g.formatter||(this.dateTime&&(u="%b %d, %Y"),r="{value"+(u?":"+u:"")+"}");u=y?C[this.isXAxis?"x":"y"]:this.toValue(k?B.chartX:B.chartY);q.attr({text:r?E(r,{value:u},e):g.formatter.call(this,u),x:f,y:p,visibility:u<a||u>D?"hidden":"visible"});g=q.getBBox();if(k){if(x&&!l||!x&&l)p=q.y-g.height}else p=q.y-g.height/2;k?(b=m-g.x,c=m+this.width-g.x):(b="left"===this.labelAlign?m:0,c="right"===this.labelAlign?m+this.width:e.chartWidth);q.translateX<
b&&(z=b-q.translateX);q.translateX+g.width>=c&&(z=-(q.translateX+g.width-c));q.attr({x:f+z,y:p,anchorX:k?f:this.opposite?0:e.chartWidth,anchorY:k?this.opposite?e.chartHeight:0:p+g.height/2})}});a.init=function(){l.apply(this,arguments);this.setCompare(this.options.compare)};a.setCompare=function(a){this.modifyValue="value"===a||"percent"===a?function(b,c){var d=this.compareValue;return"undefined"!==typeof b&&"undefined"!==typeof d?(b="value"===a?b-d:b/d*100-(100===this.options.compareBase?0:100),
c&&(c.change=b),b):0}:null;this.userOptions.compare=a;this.chart.hasRendered&&(this.isDirty=!0)};a.processData=function(a){var b,c=-1,d=!0===this.options.compareStart?0:1;f.apply(this,arguments);if(this.xAxis&&this.processedYData){var e=this.processedXData;var g=this.processedYData;var k=g.length;this.pointArrayMap&&(c=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(b=0;b<k-d;b++){var l=g[b]&&-1<c?g[b][c]:g[b];if(y(l)&&e[b+d]>=this.xAxis.min&&0!==l){this.compareValue=
l;break}}}};z(q,"afterGetExtremes",function(a){a=a.dataExtremes;if(this.modifyValue&&a){var b=[this.modifyValue(a.dataMin),this.modifyValue(a.dataMax)];a.dataMin=D(b);a.dataMax=r(b)}});k.prototype.setCompare=function(a,b){this.isXAxis||(this.series.forEach(function(b){b.setCompare(a)}),w(b,!0)&&this.chart.redraw())};x.prototype.tooltipFormatter=function(a){var b=this.series.chart.numberFormatter;a=a.replace("{point.change}",(0<this.change?"+":"")+b(this.change,w(this.series.tooltipOptions.changeDecimals,
2)));return p.apply(this,[a])};z(q,"render",function(){var a=this.chart;if(!(a.is3d&&a.is3d()||a.polar)&&this.xAxis&&!this.xAxis.isRadial){var b=this.yAxis.len;if(this.xAxis.axisLine){var c=a.plotTop+a.plotHeight-this.yAxis.pos-this.yAxis.len,d=Math.floor(this.xAxis.axisLine.strokeWidth()/2);0<=c&&(b-=Math.max(d-c,0))}!this.clipBox&&this.animate?(this.clipBox=u(a.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=b):a[this.sharedClipKey]&&(a[this.sharedClipKey].animate({width:this.xAxis.len,
height:b}),a[this.sharedClipKey+"m"]&&a[this.sharedClipKey+"m"].animate({width:this.xAxis.len}))}});z(c,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(u(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({},!1),delete a.scrollbar)})});I(k,"masters/modules/stock.src.js",[],function(){})});
//# sourceMappingURL=stock.js.map