// Simple wrapper around SJCL's ECC Implementation - v0.3.0 - https://github.com/jpillora/eccjs
// Jaime Pillora <dev@jpillora.com> - MIT/BSD(sljc) Copyright 2014
!function(a,b){"use strict";function c(a){var b=h.ecc[a];if(!b)throw new Error("Missing ECC algorithm: "+a);return{generate:function(a){var c=b.generateKeys(a,1);return c.pub.$curve=a,c.sec.$curve=a,c},importPublic:function(a){var c=d(a);return new b.publicKey(c.curve,h.codec.hex.toBits(c.hex))},importSecret:function(a){var c=d(a);return new b.secretKey(c.curve,new h.bn(c.hex))}}}function d(a){return{curve:h.ecc.curves["c"+a.substr(0,3)],hex:a.substr(3)}}function e(a){var b=a.get();return a.$curve+h.codec.hex.fromBits(b.x)+h.codec.hex.fromBits(b.y)}function f(a){return a.$curve+h.codec.hex.fromBits(a.get())}function g(a){var b=h.hash[a];if(!b)throw new Error("Missing hash algorithm: "+a);return{hash:function(a){return b.hash(a)}}}var h={cipher:{},hash:{},keyexchange:{},mode:{},misc:{},codec:{},exception:{corrupt:function(a){this.toString=function(){return"CORRUPT: "+this.message},this.message=a},invalid:function(a){this.toString=function(){return"INVALID: "+this.message},this.message=a},bug:function(a){this.toString=function(){return"BUG: "+this.message},this.message=a},notReady:function(a){this.toString=function(){return"NOT READY: "+this.message},this.message=a}}};h.cipher.aes=function(a){this._tables[0][0][0]||this._precompute();var b,c,d,e,f,g=this._tables[0][4],i=this._tables[1],j=a.length,k=1;if(4!==j&&6!==j&&8!==j)throw new h.exception.invalid("invalid aes key size");for(this._key=[e=a.slice(0),f=[]],b=j;4*j+28>b;b++)d=e[b-1],(b%j===0||8===j&&b%j===4)&&(d=g[d>>>24]<<24^g[d>>16&255]<<16^g[d>>8&255]<<8^g[255&d],b%j===0&&(d=d<<8^d>>>24^k<<24,k=k<<1^283*(k>>7))),e[b]=e[b-j]^d;for(c=0;b;c++,b--)d=e[3&c?b:b-4],f[c]=4>=b||4>c?d:i[0][g[d>>>24]]^i[1][g[d>>16&255]]^i[2][g[d>>8&255]]^i[3][g[255&d]]},h.cipher.aes.prototype={encrypt:function(a){return this._crypt(a,0)},decrypt:function(a){return this._crypt(a,1)},_tables:[[[],[],[],[],[]],[[],[],[],[],[]]],_precompute:function(){var a,b,c,d,e,f,g,h,i,j=this._tables[0],k=this._tables[1],l=j[4],m=k[4],n=[],o=[];for(a=0;256>a;a++)o[(n[a]=a<<1^283*(a>>7))^a]=a;for(b=c=0;!l[b];b^=d||1,c=o[c]||1)for(g=c^c<<1^c<<2^c<<3^c<<4,g=g>>8^255&g^99,l[b]=g,m[g]=b,f=n[e=n[d=n[b]]],i=16843009*f^65537*e^257*d^16843008*b,h=257*n[g]^16843008*g,a=0;4>a;a++)j[a][b]=h=h<<24^h>>>8,k[a][g]=i=i<<24^i>>>8;for(a=0;5>a;a++)j[a]=j[a].slice(0),k[a]=k[a].slice(0)},_crypt:function(a,b){if(4!==a.length)throw new h.exception.invalid("invalid aes block size");var c,d,e,f,g=this._key[b],i=a[0]^g[0],j=a[b?3:1]^g[1],k=a[2]^g[2],l=a[b?1:3]^g[3],m=g.length/4-2,n=4,o=[0,0,0,0],p=this._tables[b],q=p[0],r=p[1],s=p[2],t=p[3],u=p[4];for(f=0;m>f;f++)c=q[i>>>24]^r[j>>16&255]^s[k>>8&255]^t[255&l]^g[n],d=q[j>>>24]^r[k>>16&255]^s[l>>8&255]^t[255&i]^g[n+1],e=q[k>>>24]^r[l>>16&255]^s[i>>8&255]^t[255&j]^g[n+2],l=q[l>>>24]^r[i>>16&255]^s[j>>8&255]^t[255&k]^g[n+3],n+=4,i=c,j=d,k=e;for(f=0;4>f;f++)o[b?3&-f:f]=u[i>>>24]<<24^u[j>>16&255]<<16^u[k>>8&255]<<8^u[255&l]^g[n++],c=i,i=j,j=k,k=l,l=c;return o}},h.bitArray={bitSlice:function(a,c,d){return a=h.bitArray._shiftRight(a.slice(c/32),32-(31&c)).slice(1),d===b?a:h.bitArray.clamp(a,d-c)},extract:function(a,b,c){var d,e=Math.floor(-b-c&31);return d=-32&(b+c-1^b)?a[b/32|0]<<32-e^a[b/32+1|0]>>>e:a[b/32|0]>>>e,d&(1<<c)-1},concat:function(a,b){if(0===a.length||0===b.length)return a.concat(b);var c=a[a.length-1],d=h.bitArray.getPartial(c);return 32===d?a.concat(b):h.bitArray._shiftRight(b,d,0|c,a.slice(0,a.length-1))},bitLength:function(a){var b,c=a.length;return 0===c?0:(b=a[c-1],32*(c-1)+h.bitArray.getPartial(b))},clamp:function(a,b){if(32*a.length<b)return a;a=a.slice(0,Math.ceil(b/32));var c=a.length;return b=31&b,c>0&&b&&(a[c-1]=h.bitArray.partial(b,a[c-1]&2147483648>>b-1,1)),a},partial:function(a,b,c){return 32===a?b:(c?0|b:b<<32-a)+1099511627776*a},getPartial:function(a){return Math.round(a/1099511627776)||32},equal:function(a,b){if(h.bitArray.bitLength(a)!==h.bitArray.bitLength(b))return!1;var c,d=0;for(c=0;c<a.length;c++)d|=a[c]^b[c];return 0===d},_shiftRight:function(a,c,d,e){var f,g,i=0;for(e===b&&(e=[]);c>=32;c-=32)e.push(d),d=0;if(0===c)return e.concat(a);for(f=0;f<a.length;f++)e.push(d|a[f]>>>c),d=a[f]<<32-c;return i=a.length?a[a.length-1]:0,g=h.bitArray.getPartial(i),e.push(h.bitArray.partial(c+g&31,c+g>32?d:e.pop(),1)),e},_xor4:function(a,b){return[a[0]^b[0],a[1]^b[1],a[2]^b[2],a[3]^b[3]]}},h.codec.utf8String={fromBits:function(a){var b,c,d="",e=h.bitArray.bitLength(a);for(b=0;e/8>b;b++)0===(3&b)&&(c=a[b/4]),d+=String.fromCharCode(c>>>24),c<<=8;return decodeURIComponent(escape(d))},toBits:function(a){a=unescape(encodeURIComponent(a));var b,c=[],d=0;for(b=0;b<a.length;b++)d=d<<8|a.charCodeAt(b),3===(3&b)&&(c.push(d),d=0);return 3&b&&c.push(h.bitArray.partial(8*(3&b),d)),c}},h.codec.hex={fromBits:function(a){var b,c="";for(b=0;b<a.length;b++)c+=((0|a[b])+0xf00000000000).toString(16).substr(4);return c.substr(0,h.bitArray.bitLength(a)/4)},toBits:function(a){var b,c,d=[];for(a=a.replace(/\s|0x/g,""),c=a.length,a+="00000000",b=0;b<a.length;b+=8)d.push(0^parseInt(a.substr(b,8),16));return h.bitArray.clamp(d,4*c)}},h.codec.base64={_chars:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",fromBits:function(a,b,c){var d,e="",f=0,g=h.codec.base64._chars,i=0,j=h.bitArray.bitLength(a);for(c&&(g=g.substr(0,62)+"-_"),d=0;6*e.length<j;)e+=g.charAt((i^a[d]>>>f)>>>26),6>f?(i=a[d]<<6-f,f+=26,d++):(i<<=6,f-=6);for(;3&e.length&&!b;)e+="=";return e},toBits:function(a,b){a=a.replace(/\s|=/g,"");var c,d,e=[],f=0,g=h.codec.base64._chars,i=0;for(b&&(g=g.substr(0,62)+"-_"),c=0;c<a.length;c++){if(d=g.indexOf(a.charAt(c)),0>d)throw new h.exception.invalid("this isn't base64!");f>26?(f-=26,e.push(i^d>>>f),i=d<<32-f):(f+=6,i^=d<<32-f)}return 56&f&&e.push(h.bitArray.partial(56&f,i,1)),e}},h.codec.base64url={fromBits:function(a){return h.codec.base64.fromBits(a,1,1)},toBits:function(a){return h.codec.base64.toBits(a,1)}},h.hash.sha256=function(a){this._key[0]||this._precompute(),a?(this._h=a._h.slice(0),this._buffer=a._buffer.slice(0),this._length=a._length):this.reset()},h.hash.sha256.hash=function(a){return(new h.hash.sha256).update(a).finalize()},h.hash.sha256.prototype={blockSize:512,reset:function(){return this._h=this._init.slice(0),this._buffer=[],this._length=0,this},update:function(a){"string"==typeof a&&(a=h.codec.utf8String.toBits(a));var b,c=this._buffer=h.bitArray.concat(this._buffer,a),d=this._length,e=this._length=d+h.bitArray.bitLength(a);for(b=512+d&-512;e>=b;b+=512)this._block(c.splice(0,16));return this},finalize:function(){var a,b=this._buffer,c=this._h;for(b=h.bitArray.concat(b,[h.bitArray.partial(1,1)]),a=b.length+2;15&a;a++)b.push(0);for(b.push(Math.floor(this._length/4294967296)),b.push(0|this._length);b.length;)this._block(b.splice(0,16));return this.reset(),c},_init:[],_key:[],_precompute:function(){function a(a){return 4294967296*(a-Math.floor(a))|0}var b,c=0,d=2;a:for(;64>c;d++){for(b=2;d>=b*b;b++)if(d%b===0)continue a;8>c&&(this._init[c]=a(Math.pow(d,.5))),this._key[c]=a(Math.pow(d,1/3)),c++}},_block:function(a){var b,c,d,e,f=a.slice(0),g=this._h,h=this._key,i=g[0],j=g[1],k=g[2],l=g[3],m=g[4],n=g[5],o=g[6],p=g[7];for(b=0;64>b;b++)16>b?c=f[b]:(d=f[b+1&15],e=f[b+14&15],c=f[15&b]=(d>>>7^d>>>18^d>>>3^d<<25^d<<14)+(e>>>17^e>>>19^e>>>10^e<<15^e<<13)+f[15&b]+f[b+9&15]|0),c=c+p+(m>>>6^m>>>11^m>>>25^m<<26^m<<21^m<<7)+(o^m&(n^o))+h[b],p=o,o=n,n=m,m=l+c|0,l=k,k=j,j=i,i=c+(j&k^l&(j^k))+(j>>>2^j>>>13^j>>>22^j<<30^j<<19^j<<10)|0;g[0]=g[0]+i|0,g[1]=g[1]+j|0,g[2]=g[2]+k|0,g[3]=g[3]+l|0,g[4]=g[4]+m|0,g[5]=g[5]+n|0,g[6]=g[6]+o|0,g[7]=g[7]+p|0}},h.mode.ccm={name:"ccm",encrypt:function(a,b,c,d,e){var f,g,i=b.slice(0),j=h.bitArray,k=j.bitLength(c)/8,l=j.bitLength(i)/8;if(e=e||64,d=d||[],7>k)throw new h.exception.invalid("ccm: iv must be at least 7 bytes");for(f=2;4>f&&l>>>8*f;f++);return 15-k>f&&(f=15-k),c=j.clamp(c,8*(15-f)),g=h.mode.ccm._computeTag(a,b,c,d,e,f),i=h.mode.ccm._ctrMode(a,i,c,g,e,f),j.concat(i.data,i.tag)},decrypt:function(a,b,c,d,e){e=e||64,d=d||[];var f,g,i=h.bitArray,j=i.bitLength(c)/8,k=i.bitLength(b),l=i.clamp(b,k-e),m=i.bitSlice(b,k-e);if(k=(k-e)/8,7>j)throw new h.exception.invalid("ccm: iv must be at least 7 bytes");for(f=2;4>f&&k>>>8*f;f++);if(15-j>f&&(f=15-j),c=i.clamp(c,8*(15-f)),l=h.mode.ccm._ctrMode(a,l,c,m,e,f),g=h.mode.ccm._computeTag(a,l.data,c,d,e,f),!i.equal(l.tag,g))throw new h.exception.corrupt("ccm: tag doesn't match");return l.data},_computeTag:function(a,b,c,d,e,f){var g,i,j,k=[],l=h.bitArray,m=l._xor4;if(e/=8,e%2||4>e||e>16)throw new h.exception.invalid("ccm: invalid tag length");if(d.length>4294967295||b.length>4294967295)throw new h.exception.bug("ccm: can't deal with 4GiB or more data");if(g=[l.partial(8,(d.length?64:0)|e-2<<2|f-1)],g=l.concat(g,c),g[3]|=l.bitLength(b)/8,g=a.encrypt(g),d.length)for(i=l.bitLength(d)/8,65279>=i?k=[l.partial(16,i)]:4294967295>=i&&(k=l.concat([l.partial(16,65534)],[i])),k=l.concat(k,d),j=0;j<k.length;j+=4)g=a.encrypt(m(g,k.slice(j,j+4).concat([0,0,0])));for(j=0;j<b.length;j+=4)g=a.encrypt(m(g,b.slice(j,j+4).concat([0,0,0])));return l.clamp(g,8*e)},_ctrMode:function(a,b,c,d,e,f){var g,i,j,k=h.bitArray,l=k._xor4,m=b.length,n=k.bitLength(b);if(j=k.concat([k.partial(8,f-1)],c).concat([0,0,0]).slice(0,4),d=k.bitSlice(l(d,a.encrypt(j)),0,e),!m)return{tag:d,data:[]};for(i=0;m>i;i+=4)j[3]++,g=a.encrypt(j),b[i]^=g[0],b[i+1]^=g[1],b[i+2]^=g[2],b[i+3]^=g[3];return{tag:d,data:k.clamp(b,n)}}},h.mode.ocb2={name:"ocb2",encrypt:function(a,b,c,d,e,f){if(128!==h.bitArray.bitLength(c))throw new h.exception.invalid("ocb iv must be 128 bits");var g,i,j,k,l=h.mode.ocb2._times2,m=h.bitArray,n=m._xor4,o=[0,0,0,0],p=l(a.encrypt(c)),q=[];for(d=d||[],e=e||64,g=0;g+4<b.length;g+=4)i=b.slice(g,g+4),o=n(o,i),q=q.concat(n(p,a.encrypt(n(p,i)))),p=l(p);return i=b.slice(g),j=m.bitLength(i),k=a.encrypt(n(p,[0,0,0,j])),i=m.clamp(n(i.concat([0,0,0]),k),j),o=n(o,n(i.concat([0,0,0]),k)),o=a.encrypt(n(o,n(p,l(p)))),d.length&&(o=n(o,f?d:h.mode.ocb2.pmac(a,d))),q.concat(m.concat(i,m.clamp(o,e)))},decrypt:function(a,b,c,d,e,f){if(128!==h.bitArray.bitLength(c))throw new h.exception.invalid("ocb iv must be 128 bits");e=e||64;var g,i,j,k,l=h.mode.ocb2._times2,m=h.bitArray,n=m._xor4,o=[0,0,0,0],p=l(a.encrypt(c)),q=h.bitArray.bitLength(b)-e,r=[];for(d=d||[],g=0;q/32>g+4;g+=4)i=n(p,a.decrypt(n(p,b.slice(g,g+4)))),o=n(o,i),r=r.concat(i),p=l(p);if(j=q-32*g,k=a.encrypt(n(p,[0,0,0,j])),i=n(k,m.clamp(b.slice(g),j).concat([0,0,0])),o=n(o,i),o=a.encrypt(n(o,n(p,l(p)))),d.length&&(o=n(o,f?d:h.mode.ocb2.pmac(a,d))),!m.equal(m.clamp(o,e),m.bitSlice(b,q)))throw new h.exception.corrupt("ocb: tag doesn't match");return r.concat(m.clamp(i,j))},pmac:function(a,b){var c,d,e=h.mode.ocb2._times2,f=h.bitArray,g=f._xor4,i=[0,0,0,0],j=a.encrypt([0,0,0,0]);for(j=g(j,e(e(j))),c=0;c+4<b.length;c+=4)j=e(j),i=g(i,a.encrypt(g(j,b.slice(c,c+4))));return d=b.slice(c),f.bitLength(d)<128&&(j=g(j,e(j)),d=f.concat(d,[-2147483648,0,0,0])),i=g(i,d),a.encrypt(g(e(g(j,e(j))),i))},_times2:function(a){return[a[0]<<1^a[1]>>>31,a[1]<<1^a[2]>>>31,a[2]<<1^a[3]>>>31,a[3]<<1^135*(a[0]>>>31)]}},h.mode.gcm={name:"gcm",encrypt:function(a,b,c,d,e){var f,g=b.slice(0),i=h.bitArray;return e=e||128,d=d||[],f=h.mode.gcm._ctrMode(!0,a,g,d,c,e),i.concat(f.data,f.tag)},decrypt:function(a,b,c,d,e){var f,g,i=b.slice(0),j=h.bitArray,k=j.bitLength(i);if(e=e||128,d=d||[],k>=e?(g=j.bitSlice(i,k-e),i=j.bitSlice(i,0,k-e)):(g=i,i=[]),f=h.mode.gcm._ctrMode(!1,a,i,d,c,e),!j.equal(f.tag,g))throw new h.exception.corrupt("gcm: tag doesn't match");return f.data},_galoisMultiply:function(a,b){var c,d,e,f,g,i,j=h.bitArray,k=j._xor4;for(f=[0,0,0,0],g=b.slice(0),c=0;128>c;c++){for(e=0!==(a[Math.floor(c/32)]&1<<31-c%32),e&&(f=k(f,g)),i=0!==(1&g[3]),d=3;d>0;d--)g[d]=g[d]>>>1|(1&g[d-1])<<31;g[0]=g[0]>>>1,i&&(g[0]=g[0]^225<<24)}return f},_ghash:function(a,b,c){var d,e,f=c.length;for(d=b.slice(0),e=0;f>e;e+=4)d[0]^=4294967295&c[e],d[1]^=4294967295&c[e+1],d[2]^=4294967295&c[e+2],d[3]^=4294967295&c[e+3],d=h.mode.gcm._galoisMultiply(d,a);return d},_ctrMode:function(a,b,c,d,e,f){{var g,i,j,k,l,m,n,o,p,q,r,s,t=h.bitArray;t._xor4}for(p=c.length,q=t.bitLength(c),r=t.bitLength(d),s=t.bitLength(e),g=b.encrypt([0,0,0,0]),96===s?(i=e.slice(0),i=t.concat(i,[1])):(i=h.mode.gcm._ghash(g,[0,0,0,0],e),i=h.mode.gcm._ghash(g,i,[0,0,Math.floor(s/4294967296),4294967295&s])),j=h.mode.gcm._ghash(g,[0,0,0,0],d),m=i.slice(0),n=j.slice(0),a||(n=h.mode.gcm._ghash(g,j,c)),l=0;p>l;l+=4)m[3]++,k=b.encrypt(m),c[l]^=k[0],c[l+1]^=k[1],c[l+2]^=k[2],c[l+3]^=k[3];return c=t.clamp(c,q),a&&(n=h.mode.gcm._ghash(g,j,c)),o=[Math.floor(r/4294967296),4294967295&r,Math.floor(q/4294967296),4294967295&q],n=h.mode.gcm._ghash(g,n,o),k=b.encrypt(i),n[0]^=k[0],n[1]^=k[1],n[2]^=k[2],n[3]^=k[3],{tag:t.bitSlice(n,0,f),data:c}}},h.misc.hmac=function(a,b){this._hash=b=b||h.hash.sha256;var c,d=[[],[]],e=b.prototype.blockSize/32;for(this._baseHash=[new b,new b],a.length>e&&(a=b.hash(a)),c=0;e>c;c++)d[0][c]=909522486^a[c],d[1][c]=1549556828^a[c];this._baseHash[0].update(d[0]),this._baseHash[1].update(d[1]),this._resultHash=new b(this._baseHash[0])},h.misc.hmac.prototype.encrypt=h.misc.hmac.prototype.mac=function(a){if(this._updated)throw new h.exception.invalid("encrypt on already updated hmac called!");return this.update(a),this.digest(a)},h.misc.hmac.prototype.reset=function(){this._resultHash=new this._hash(this._baseHash[0]),this._updated=!1},h.misc.hmac.prototype.update=function(a){this._updated=!0,this._resultHash.update(a)},h.misc.hmac.prototype.digest=function(){var a=this._resultHash.finalize(),b=new this._hash(this._baseHash[1]).update(a).finalize();return this.reset(),b},h.misc.pbkdf2=function(a,b,c,d,e){if(c=c||1e3,0>d||0>c)throw h.exception.invalid("invalid params to pbkdf2");"string"==typeof a&&(a=h.codec.utf8String.toBits(a)),"string"==typeof b&&(b=h.codec.utf8String.toBits(b)),e=e||h.misc.hmac;var f,g,i,j,k,l=new e(a),m=[],n=h.bitArray;for(k=1;32*m.length<(d||1);k++){for(f=g=l.encrypt(n.concat(b,[k])),i=1;c>i;i++)for(g=l.encrypt(g),j=0;j<g.length;j++)f[j]^=g[j];m=m.concat(f)}return d&&(m=n.clamp(m,d)),m},h.prng=function(a){this._pools=[new h.hash.sha256],this._poolEntropy=[0],this._reseedCount=0,this._robins={},this._eventId=0,this._collectorIds={},this._collectorIdNext=0,this._strength=0,this._poolStrength=0,this._nextReseed=0,this._key=[0,0,0,0,0,0,0,0],this._counter=[0,0,0,0],this._cipher=b,this._defaultParanoia=a,this._collectorsStarted=!1,this._callbacks={progress:{},seeded:{}},this._callbackI=0,this._NOT_READY=0,this._READY=1,this._REQUIRES_RESEED=2,this._MAX_WORDS_PER_BURST=65536,this._PARANOIA_LEVELS=[0,48,64,96,128,192,256,384,512,768,1024],this._MILLISECONDS_PER_RESEED=3e4,this._BITS_PER_RESEED=80},h.prng.prototype={randomWords:function(a,b){var c,d,e=[],f=this.isReady(b);if(f===this._NOT_READY)throw new h.exception.notReady("generator isn't seeded");for(f&this._REQUIRES_RESEED&&this._reseedFromPools(!(f&this._READY)),c=0;a>c;c+=4)(c+1)%this._MAX_WORDS_PER_BURST===0&&this._gate(),d=this._gen4words(),e.push(d[0],d[1],d[2],d[3]);return this._gate(),e.slice(0,a)},setDefaultParanoia:function(a,b){if(0===a&&"Setting paranoia=0 will ruin your security; use it only for testing"!==b)throw"Setting paranoia=0 will ruin your security; use it only for testing";this._defaultParanoia=a},addEntropy:function(a,c,d){d=d||"user";var e,f,g,i,j=(new Date).valueOf(),k=this._robins[d],l=this.isReady(),m=0;switch(e=this._collectorIds[d],e===b&&(e=this._collectorIds[d]=this._collectorIdNext++),k===b&&(k=this._robins[d]=0),this._robins[d]=(this._robins[d]+1)%this._pools.length,typeof a){case"number":c===b&&(c=1),this._pools[k].update([e,this._eventId++,1,c,j,1,0|a]);break;case"object":if(i=Object.prototype.toString.call(a),"[object Uint32Array]"===i){for(g=[],f=0;f<a.length;f++)g.push(a[f]);a=g}else for("number"!=typeof a.length&&(m=1),f=0;f<a.length&&!m;f++)"number"!=typeof a[f]&&(m=1);if(!m){if(c===b)for(c=0,f=0;f<a.length;f++)for(g=a[f];g>0;)c++,g>>>=1;this._pools[k].update([e,this._eventId++,2,c,j,a.length].concat(a))}break;case"string":c===b&&(c=a.length),this._pools[k].update([e,this._eventId++,3,c,j,a.length]),this._pools[k].update(a);break;default:m=1}if(m)throw new h.exception.bug("random: addEntropy only supports number, array of numbers or string");this._poolEntropy[k]+=c,this._poolStrength+=c,l===this._NOT_READY&&(this.isReady()!==this._NOT_READY&&this._fireEvent("seeded",Math.max(this._strength,this._poolStrength)),this._fireEvent("progress",this.getProgress()))},isReady:function(a){var c=this._PARANOIA_LEVELS[a!==b?a:this._defaultParanoia];return this._strength&&this._strength>=c?this._poolEntropy[0]>this._BITS_PER_RESEED&&(new Date).valueOf()>this._nextReseed?this._REQUIRES_RESEED|this._READY:this._READY:this._poolStrength>=c?this._REQUIRES_RESEED|this._NOT_READY:this._NOT_READY},getProgress:function(a){var b=this._PARANOIA_LEVELS[a?a:this._defaultParanoia];return this._strength>=b?1:this._poolStrength>b?1:this._poolStrength/b},startCollectors:function(){if(!this._collectorsStarted){if(this._eventListener={loadTimeCollector:this._bind(this._loadTimeCollector),mouseCollector:this._bind(this._mouseCollector),keyboardCollector:this._bind(this._keyboardCollector),accelerometerCollector:this._bind(this._accelerometerCollector)},a.addEventListener)a.addEventListener("load",this._eventListener.loadTimeCollector,!1),a.addEventListener("mousemove",this._eventListener.mouseCollector,!1),a.addEventListener("keypress",this._eventListener.keyboardCollector,!1),a.addEventListener("devicemotion",this._eventListener.accelerometerCollector,!1);else{if(!document.attachEvent)throw new h.exception.bug("can't attach event");document.attachEvent("onload",this._eventListener.loadTimeCollector),document.attachEvent("onmousemove",this._eventListener.mouseCollector),document.attachEvent("keypress",this._eventListener.keyboardCollector)}this._collectorsStarted=!0}},stopCollectors:function(){this._collectorsStarted&&(a.removeEventListener?(a.removeEventListener("load",this._eventListener.loadTimeCollector,!1),a.removeEventListener("mousemove",this._eventListener.mouseCollector,!1),a.removeEventListener("keypress",this._eventListener.keyboardCollector,!1),a.removeEventListener("devicemotion",this._eventListener.accelerometerCollector,!1)):document.detachEvent&&(document.detachEvent("onload",this._eventListener.loadTimeCollector),document.detachEvent("onmousemove",this._eventListener.mouseCollector),document.detachEvent("keypress",this._eventListener.keyboardCollector)),this._collectorsStarted=!1)},addEventListener:function(a,b){this._callbacks[a][this._callbackI++]=b},removeEventListener:function(a,b){var c,d,e=this._callbacks[a],f=[];for(d in e)e.hasOwnProperty(d)&&e[d]===b&&f.push(d);for(c=0;c<f.length;c++)d=f[c],delete e[d]},_bind:function(a){var b=this;return function(){a.apply(b,arguments)}},_gen4words:function(){for(var a=0;4>a&&(this._counter[a]=this._counter[a]+1|0,!this._counter[a]);a++);return this._cipher.encrypt(this._counter)},_gate:function(){this._key=this._gen4words().concat(this._gen4words()),this._cipher=new h.cipher.aes(this._key)},_reseed:function(a){this._key=h.hash.sha256.hash(this._key.concat(a)),this._cipher=new h.cipher.aes(this._key);for(var b=0;4>b&&(this._counter[b]=this._counter[b]+1|0,!this._counter[b]);b++);},_reseedFromPools:function(a){var b,c=[],d=0;for(this._nextReseed=c[0]=(new Date).valueOf()+this._MILLISECONDS_PER_RESEED,b=0;16>b;b++)c.push(4294967296*Math.random()|0);for(b=0;b<this._pools.length&&(c=c.concat(this._pools[b].finalize()),d+=this._poolEntropy[b],this._poolEntropy[b]=0,a||!(this._reseedCount&1<<b));b++);this._reseedCount>=1<<this._pools.length&&(this._pools.push(new h.hash.sha256),this._poolEntropy.push(0)),this._poolStrength-=d,d>this._strength&&(this._strength=d),this._reseedCount++,this._reseed(c)},_keyboardCollector:function(){this._addCurrentTimeToEntropy(1)},_mouseCollector:function(a){var b=a.x||a.clientX||a.offsetX||0,c=a.y||a.clientY||a.offsetY||0;h.random.addEntropy([b,c],2,"mouse"),this._addCurrentTimeToEntropy(0)},_loadTimeCollector:function(){this._addCurrentTimeToEntropy(2)},_addCurrentTimeToEntropy:function(b){a&&a.performance&&"function"==typeof a.performance.now?h.random.addEntropy(a.performance.now(),b,"loadtime"):h.random.addEntropy((new Date).valueOf(),b,"loadtime")},_accelerometerCollector:function(b){var c=b.accelerationIncludingGravity.x||b.accelerationIncludingGravity.y||b.accelerationIncludingGravity.z,d="";a.orientation&&(d=a.orientation),h.random.addEntropy([c,d],3,"accelerometer"),this._addCurrentTimeToEntropy(0)},_fireEvent:function(a,b){var c,d=h.random._callbacks[a],e=[];for(c in d)d.hasOwnProperty(c)&&e.push(d[c]);for(c=0;c<e.length;c++)e[c](b)}},h.random=new h.prng(6),function(){try{var b,c,d;if("undefined"!=typeof module&&module.exports&&(c=require("crypto"))&&c.randomBytes)b=c.randomBytes(128),h.random.addEntropy(b.slice(),1024,"crypto.randomBytes");else if(a&&Uint32Array){if(d=new Uint32Array(32),a.crypto&&a.crypto.getRandomValues)a.crypto.getRandomValues(d);else{if(!a.msCrypto||!a.msCrypto.getRandomValues)return;a.msCrypto.getRandomValues(d)}h.random.addEntropy(d,1024,"crypto.getRandomValues")}}catch(e){console.log("There was an error collecting entropy from the browser:"),console.log(e)}}(),h.json={defaults:{v:1,iter:1e3,ks:128,ts:64,mode:"ccm",adata:"",cipher:"aes"},_encrypt:function(a,b,c,d){c=c||{},d=d||{};var e,f,g,i=h.json,j=i._add({iv:h.random.randomWords(4,0)},i.defaults);if(i._add(j,c),g=j.adata,"string"==typeof j.salt&&(j.salt=h.codec.base64.toBits(j.salt)),"string"==typeof j.iv&&(j.iv=h.codec.base64.toBits(j.iv)),!h.mode[j.mode]||!h.cipher[j.cipher]||"string"==typeof a&&j.iter<=100||64!==j.ts&&96!==j.ts&&128!==j.ts||128!==j.ks&&192!==j.ks&&256!==j.ks||j.iv.length<2||j.iv.length>4)throw new h.exception.invalid("json encrypt: invalid parameters");return"string"==typeof a?(e=h.misc.cachedPbkdf2(a,j),a=e.key.slice(0,j.ks/32),j.salt=e.salt):h.ecc&&a instanceof h.ecc.elGamal.publicKey&&(e=a.kem(),j.kemtag=e.tag,a=e.key.slice(0,j.ks/32)),"string"==typeof b&&(b=h.codec.utf8String.toBits(b)),"string"==typeof g&&(g=h.codec.utf8String.toBits(g)),f=new h.cipher[j.cipher](a),i._add(d,j),d.key=a,j.ct=h.mode[j.mode].encrypt(f,b,j.iv,g,j.ts),j},encrypt:function(){var a=h.json,b=a._encrypt.apply(a,arguments);return a.encode(b)},_decrypt:function(a,b,c,d){c=c||{},d=d||{};var e,f,g,i=h.json,j=i._add(i._add(i._add({},i.defaults),b),c,!0),k=j.adata;if("string"==typeof j.salt&&(j.salt=h.codec.base64.toBits(j.salt)),"string"==typeof j.iv&&(j.iv=h.codec.base64.toBits(j.iv)),!h.mode[j.mode]||!h.cipher[j.cipher]||"string"==typeof a&&j.iter<=100||64!==j.ts&&96!==j.ts&&128!==j.ts||128!==j.ks&&192!==j.ks&&256!==j.ks||!j.iv||j.iv.length<2||j.iv.length>4)throw new h.exception.invalid("json decrypt: invalid parameters");return"string"==typeof a?(f=h.misc.cachedPbkdf2(a,j),a=f.key.slice(0,j.ks/32),j.salt=f.salt):h.ecc&&a instanceof h.ecc.elGamal.secretKey&&(a=a.unkem(h.codec.base64.toBits(j.kemtag)).slice(0,j.ks/32)),"string"==typeof k&&(k=h.codec.utf8String.toBits(k)),g=new h.cipher[j.cipher](a),e=h.mode[j.mode].decrypt(g,j.ct,j.iv,k,j.ts),i._add(d,j),d.key=a,h.codec.utf8String.fromBits(e)},decrypt:function(a,b,c,d){var e=h.json;return e._decrypt(a,e.decode(b),c,d)},encode:function(a){var b,c="{",d="";for(b in a)if(a.hasOwnProperty(b)){if(!b.match(/^[a-z0-9]+$/i))throw new h.exception.invalid("json encode: invalid property name");switch(c+=d+'"'+b+'":',d=",",typeof a[b]){case"number":case"boolean":c+=a[b];break;case"string":c+='"'+escape(a[b])+'"';break;case"object":c+='"'+h.codec.base64.fromBits(a[b],0)+'"';break;default:throw new h.exception.bug("json encode: unsupported type")}}return c+"}"},decode:function(a){if(a=a.replace(/\s/g,""),!a.match(/^\{.*\}$/))throw new h.exception.invalid("json decode: this isn't json!");var b,c,d=a.replace(/^\{|\}$/g,"").split(/,/),e={};for(b=0;b<d.length;b++){if(!(c=d[b].match(/^(?:(["']?)([a-z][a-z0-9]*)\1):(?:(\d+)|"([a-z0-9+\/%*_.@=\-]*)")$/i)))throw new h.exception.invalid("json decode: this isn't json!");e[c[2]]=c[3]?parseInt(c[3],10):c[2].match(/^(ct|salt|iv)$/)?h.codec.base64.toBits(c[4]):unescape(c[4])}return e},_add:function(a,c,d){if(a===b&&(a={}),c===b)return a;var e;for(e in c)if(c.hasOwnProperty(e)){if(d&&a[e]!==b&&a[e]!==c[e])throw new h.exception.invalid("required parameter overridden");a[e]=c[e]}return a},_subtract:function(a,b){var c,d={};for(c in a)a.hasOwnProperty(c)&&a[c]!==b[c]&&(d[c]=a[c]);return d},_filter:function(a,c){var d,e={};for(d=0;d<c.length;d++)a[c[d]]!==b&&(e[c[d]]=a[c[d]]);return e}},h.encrypt=h.json.encrypt,h.decrypt=h.json.decrypt,h.misc._pbkdf2Cache={},h.misc.cachedPbkdf2=function(a,c){var d,e,f,g,i=h.misc._pbkdf2Cache;return c=c||{},g=c.iter||1e3,e=i[a]=i[a]||{},d=e[g]=e[g]||{firstSalt:c.salt&&c.salt.length?c.salt.slice(0):h.random.randomWords(2,0)},f=c.salt===b?d.firstSalt:c.salt,d[f]=d[f]||h.misc.pbkdf2(a,f,c.iter),{key:d[f].slice(0),salt:f.slice(0)}},h.bn=function(a){this.initWith(a)},h.bn.prototype={radix:24,maxMul:8,_class:h.bn,copy:function(){return new this._class(this)},initWith:function(a){var b,c=0;switch(typeof a){case"object":this.limbs=a.limbs.slice(0);break;case"number":this.limbs=[a],this.normalize();break;case"string":for(a=a.replace(/^0x/,""),this.limbs=[],b=this.radix/4,c=0;c<a.length;c+=b)this.limbs.push(parseInt(a.substring(Math.max(a.length-c-b,0),a.length-c),16));break;default:this.limbs=[0]}return this},equals:function(a){"number"==typeof a&&(a=new this._class(a));var b,c=0;for(this.fullReduce(),a.fullReduce(),b=0;b<this.limbs.length||b<a.limbs.length;b++)c|=this.getLimb(b)^a.getLimb(b);return 0===c},getLimb:function(a){return a>=this.limbs.length?0:this.limbs[a]},greaterEquals:function(a){"number"==typeof a&&(a=new this._class(a));var b,c,d,e=0,f=0;for(b=Math.max(this.limbs.length,a.limbs.length)-1;b>=0;b--)c=this.getLimb(b),d=a.getLimb(b),f|=d-c&~e,e|=c-d&~f;return(f|~e)>>>31},toString:function(){this.fullReduce();var a,b,c="",d=this.limbs;for(a=0;a<this.limbs.length;a++){for(b=d[a].toString(16);a<this.limbs.length-1&&b.length<6;)b="0"+b;c=b+c}return"0x"+c},addM:function(a){"object"!=typeof a&&(a=new this._class(a));var b,c=this.limbs,d=a.limbs;for(b=c.length;b<d.length;b++)c[b]=0;for(b=0;b<d.length;b++)c[b]+=d[b];return this},doubleM:function(){var a,b,c=0,d=this.radix,e=this.radixMask,f=this.limbs;for(a=0;a<f.length;a++)b=f[a],b=b+b+c,f[a]=b&e,c=b>>d;return c&&f.push(c),this},halveM:function(){var a,b,c=0,d=this.radix,e=this.limbs;for(a=e.length-1;a>=0;a--)b=e[a],e[a]=b+c>>1,c=(1&b)<<d;return e[e.length-1]||e.pop(),this},subM:function(a){"object"!=typeof a&&(a=new this._class(a));var b,c=this.limbs,d=a.limbs;for(b=c.length;b<d.length;b++)c[b]=0;for(b=0;b<d.length;b++)c[b]-=d[b];return this},mod:function(a){var b=!this.greaterEquals(new h.bn(0));a=new h.bn(a).normalize();var c=new h.bn(this).normalize(),d=0;for(b&&(c=new h.bn(0).subM(c).normalize());c.greaterEquals(a);d++)a.doubleM();for(b&&(c=a.sub(c).normalize());d>0;d--)a.halveM(),c.greaterEquals(a)&&c.subM(a).normalize();return c.trim()},inverseMod:function(a){var b,c,d=new h.bn(1),e=new h.bn(0),f=new h.bn(this),g=new h.bn(a),i=1;if(!(1&a.limbs[0]))throw new h.exception.invalid("inverseMod: p must be odd");do for(1&f.limbs[0]&&(f.greaterEquals(g)||(b=f,f=g,g=b,b=d,d=e,e=b),f.subM(g),f.normalize(),d.greaterEquals(e)||d.addM(a),d.subM(e)),f.halveM(),1&d.limbs[0]&&d.addM(a),d.normalize(),d.halveM(),c=i=0;c<f.limbs.length;c++)i|=f.limbs[c];while(i);if(!g.equals(1))throw new h.exception.invalid("inverseMod: p and x must be relatively prime");return e},add:function(a){return this.copy().addM(a)},sub:function(a){return this.copy().subM(a)},mul:function(a){"number"==typeof a&&(a=new this._class(a));var b,c,d,e=this.limbs,f=a.limbs,g=e.length,h=f.length,i=new this._class,j=i.limbs,k=this.maxMul;for(b=0;b<this.limbs.length+a.limbs.length+1;b++)j[b]=0;for(b=0;g>b;b++){for(d=e[b],c=0;h>c;c++)j[b+c]+=d*f[c];--k||(k=this.maxMul,i.cnormalize())}return i.cnormalize().reduce()},square:function(){return this.mul(this)},power:function(a){"number"==typeof a?a=[a]:a.limbs!==b&&(a=a.normalize().limbs);var c,d,e=new this._class(1),f=this;for(c=0;c<a.length;c++)for(d=0;d<this.radix;d++)a[c]&1<<d&&(e=e.mul(f)),f=f.square();return e},mulmod:function(a,b){return this.mod(b).mul(a.mod(b)).mod(b)},powermod:function(a,b){for(var c=new h.bn(1),d=new h.bn(this),e=new h.bn(a);;){if(1&e.limbs[0]&&(c=c.mulmod(d,b)),e.halveM(),e.equals(0))break;d=d.mulmod(d,b)}return c.normalize().reduce()},trim:function(){var a,b=this.limbs;do a=b.pop();while(b.length&&0===a);return b.push(a),this},reduce:function(){return this},fullReduce:function(){return this.normalize()},normalize:function(){var a,b,c,d=0,e=(this.placeVal,this.ipv),f=this.limbs,g=f.length,h=this.radixMask;for(a=0;g>a||0!==d&&-1!==d;a++)b=(f[a]||0)+d,c=f[a]=b&h,d=(b-c)*e;return-1===d&&(f[a-1]-=this.placeVal),this},cnormalize:function(){var a,b,c,d=0,e=this.ipv,f=this.limbs,g=f.length,h=this.radixMask;for(a=0;g-1>a;a++)b=f[a]+d,c=f[a]=b&h,d=(b-c)*e;return f[a]+=d,this},toBits:function(a){this.fullReduce(),a=a||this.exponent||this.bitLength();var b=Math.floor((a-1)/24),c=h.bitArray,d=(a+7&-8)%this.radix||this.radix,e=[c.partial(d,this.getLimb(b))];for(b--;b>=0;b--)e=c.concat(e,[c.partial(Math.min(this.radix,a),this.getLimb(b))]),a-=this.radix;return e},bitLength:function(){this.fullReduce();for(var a=this.radix*(this.limbs.length-1),b=this.limbs[this.limbs.length-1];b;b>>>=1)a++;return a+7&-8}},h.bn.fromBits=function(a){var b=this,c=new b,d=[],e=h.bitArray,f=this.prototype,g=Math.min(this.bitLength||4294967296,e.bitLength(a)),i=g%f.radix||f.radix;for(d[0]=e.extract(a,0,i);g>i;i+=f.radix)d.unshift(e.extract(a,i,f.radix));return c.limbs=d,c},h.bn.prototype.ipv=1/(h.bn.prototype.placeVal=Math.pow(2,h.bn.prototype.radix)),h.bn.prototype.radixMask=(1<<h.bn.prototype.radix)-1,h.bn.pseudoMersennePrime=function(a,b){function c(a){this.initWith(a)}var d,e,f,g=c.prototype=new h.bn;for(f=g.modOffset=Math.ceil(e=a/g.radix),g.exponent=a,g.offset=[],g.factor=[],g.minOffset=f,g.fullMask=0,g.fullOffset=[],g.fullFactor=[],g.modulus=c.modulus=new h.bn(Math.pow(2,a)),g.fullMask=0|-Math.pow(2,a%g.radix),d=0;d<b.length;d++)g.offset[d]=Math.floor(b[d][0]/g.radix-e),g.fullOffset[d]=Math.ceil(b[d][0]/g.radix-e),g.factor[d]=b[d][1]*Math.pow(.5,a-b[d][0]+g.offset[d]*g.radix),g.fullFactor[d]=b[d][1]*Math.pow(.5,a-b[d][0]+g.fullOffset[d]*g.radix),g.modulus.addM(new h.bn(Math.pow(2,b[d][0])*b[d][1])),g.minOffset=Math.min(g.minOffset,-g.offset[d]);return g._class=c,g.modulus.cnormalize(),g.reduce=function(){var a,b,c,d,e=this.modOffset,f=this.limbs,g=this.offset,h=this.offset.length,i=this.factor;for(a=this.minOffset;f.length>e;){for(c=f.pop(),d=f.length,b=0;h>b;b++)f[d+g[b]]-=i[b]*c;a--,a||(f.push(0),this.cnormalize(),a=this.minOffset)}return this.cnormalize(),this},g._strongReduce=-1===g.fullMask?g.reduce:function(){var a,b,c=this.limbs,d=c.length-1;if(this.reduce(),d===this.modOffset-1){for(b=c[d]&this.fullMask,c[d]-=b,a=0;a<this.fullOffset.length;a++)c[d+this.fullOffset[a]]-=this.fullFactor[a]*b;this.normalize()}},g.fullReduce=function(){var a,b;for(this._strongReduce(),this.addM(this.modulus),this.addM(this.modulus),this.normalize(),this._strongReduce(),b=this.limbs.length;b<this.modOffset;b++)this.limbs[b]=0;for(a=this.greaterEquals(this.modulus),b=0;b<this.limbs.length;b++)this.limbs[b]-=this.modulus.limbs[b]*a;return this.cnormalize(),this},g.inverse=function(){return this.power(this.modulus.sub(2))},c.fromBits=h.bn.fromBits,c};var i=h.bn.pseudoMersennePrime;h.bn.prime={p127:i(127,[[0,-1]]),p25519:i(255,[[0,-19]]),p192k:i(192,[[32,-1],[12,-1],[8,-1],[7,-1],[6,-1],[3,-1],[0,-1]]),p224k:i(224,[[32,-1],[12,-1],[11,-1],[9,-1],[7,-1],[4,-1],[1,-1],[0,-1]]),p256k:i(256,[[32,-1],[9,-1],[8,-1],[7,-1],[6,-1],[4,-1],[0,-1]]),p192:i(192,[[0,-1],[64,-1]]),p224:i(224,[[0,1],[96,-1]]),p256:i(256,[[0,-1],[96,1],[192,1],[224,-1]]),p384:i(384,[[0,-1],[32,1],[96,-1],[128,-1]]),p521:i(521,[[0,-1]])},h.bn.random=function(a,b){"object"!=typeof a&&(a=new h.bn(a));for(var c,d,e=a.limbs.length,f=a.limbs[e-1]+1,g=new h.bn;;){do c=h.random.randomWords(e,b),c[e-1]<0&&(c[e-1]+=4294967296);
while(Math.floor(c[e-1]/f)===Math.floor(4294967296/f));for(c[e-1]%=f,d=0;e-1>d;d++)c[d]&=a.radixMask;if(g.limbs=c,!g.greaterEquals(a))return g}},h.ecc={},h.ecc.point=function(a,c,d){c===b?this.isIdentity=!0:(this.x=c,this.y=d,this.isIdentity=!1),this.curve=a},h.ecc.point.prototype={toJac:function(){return new h.ecc.pointJac(this.curve,this.x,this.y,new this.curve.field(1))},mult:function(a){return this.toJac().mult(a,this).toAffine()},mult2:function(a,b,c){return this.toJac().mult2(a,this,b,c).toAffine()},multiples:function(){var a,c,d;if(this._multiples===b)for(d=this.toJac().doubl(),a=this._multiples=[new h.ecc.point(this.curve),this,d.toAffine()],c=3;16>c;c++)d=d.add(this),a.push(d.toAffine());return this._multiples},isValid:function(){return this.y.square().equals(this.curve.b.add(this.x.mul(this.curve.a.add(this.x.square()))))},toBits:function(){return h.bitArray.concat(this.x.toBits(),this.y.toBits())}},h.ecc.pointJac=function(a,c,d,e){c===b?this.isIdentity=!0:(this.x=c,this.y=d,this.z=e,this.isIdentity=!1),this.curve=a},h.ecc.pointJac.prototype={add:function(a){var b,c,d,e,f,g,i,j,k,l,m,n=this;if(n.curve!==a.curve)throw"sjcl.ecc.add(): Points must be on the same curve to add them!";return n.isIdentity?a.toJac():a.isIdentity?n:(b=n.z.square(),c=a.x.mul(b).subM(n.x),c.equals(0)?n.y.equals(a.y.mul(b.mul(n.z)))?n.doubl():new h.ecc.pointJac(n.curve):(d=a.y.mul(b.mul(n.z)).subM(n.y),e=c.square(),f=d.square(),g=c.square().mul(c).addM(n.x.add(n.x).mul(e)),i=f.subM(g),j=n.x.mul(e).subM(i).mul(d),k=n.y.mul(c.square().mul(c)),l=j.subM(k),m=n.z.mul(c),new h.ecc.pointJac(this.curve,i,l,m)))},doubl:function(){if(this.isIdentity)return this;var a=this.y.square(),b=a.mul(this.x.mul(4)),c=a.square().mul(8),d=this.z.square(),e=this.curve.a.toString()==new h.bn(-3).toString()?this.x.sub(d).mul(3).mul(this.x.add(d)):this.x.square().mul(3).add(d.square().mul(this.curve.a)),f=e.square().subM(b).subM(b),g=b.sub(f).mul(e).subM(c),i=this.y.add(this.y).mul(this.z);return new h.ecc.pointJac(this.curve,f,g,i)},toAffine:function(){if(this.isIdentity||this.z.equals(0))return new h.ecc.point(this.curve);var a=this.z.inverse(),b=a.square();return new h.ecc.point(this.curve,this.x.mul(b).fullReduce(),this.y.mul(b.mul(a)).fullReduce())},mult:function(a,c){"number"==typeof a?a=[a]:a.limbs!==b&&(a=a.normalize().limbs);var d,e,f=new h.ecc.point(this.curve).toJac(),g=c.multiples();for(d=a.length-1;d>=0;d--)for(e=h.bn.prototype.radix-4;e>=0;e-=4)f=f.doubl().doubl().doubl().doubl().add(g[a[d]>>e&15]);return f},mult2:function(a,c,d,e){"number"==typeof a?a=[a]:a.limbs!==b&&(a=a.normalize().limbs),"number"==typeof d?d=[d]:d.limbs!==b&&(d=d.normalize().limbs);var f,g,i,j,k=new h.ecc.point(this.curve).toJac(),l=c.multiples(),m=e.multiples();for(f=Math.max(a.length,d.length)-1;f>=0;f--)for(i=0|a[f],j=0|d[f],g=h.bn.prototype.radix-4;g>=0;g-=4)k=k.doubl().doubl().doubl().doubl().add(l[i>>g&15]).add(m[j>>g&15]);return k},isValid:function(){var a=this.z.square(),b=a.square(),c=b.mul(a);return this.y.square().equals(this.curve.b.mul(c).add(this.x.mul(this.curve.a.mul(b).add(this.x.square()))))}},h.ecc.curve=function(a,b,c,d,e,f){this.field=a,this.r=new h.bn(b),this.a=new a(c),this.b=new a(d),this.G=new h.ecc.point(this,new a(e),new a(f))},h.ecc.curve.prototype.fromBits=function(a){var b=h.bitArray,c=this.field.prototype.exponent+7&-8,d=new h.ecc.point(this,this.field.fromBits(b.bitSlice(a,0,c)),this.field.fromBits(b.bitSlice(a,c,2*c)));if(!d.isValid())throw new h.exception.corrupt("not on the curve!");return d},h.ecc.curves={c192:new h.ecc.curve(h.bn.prime.p192,"0xffffffffffffffffffffffff99def836146bc9b1b4d22831",-3,"0x64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1","0x188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012","0x07192b95ffc8da78631011ed6b24cdd573f977a11e794811"),c224:new h.ecc.curve(h.bn.prime.p224,"0xffffffffffffffffffffffffffff16a2e0b8f03e13dd29455c5c2a3d",-3,"0xb4050a850c04b3abf54132565044b0b7d7bfd8ba270b39432355ffb4","0xb70e0cbd6bb4bf7f321390b94a03c1d356c21122343280d6115c1d21","0xbd376388b5f723fb4c22dfe6cd4375a05a07476444d5819985007e34"),c256:new h.ecc.curve(h.bn.prime.p256,"0xffffffff00000000ffffffffffffffffbce6faada7179e84f3b9cac2fc632551",-3,"0x5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b","0x6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296","0x4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5"),c384:new h.ecc.curve(h.bn.prime.p384,"0xffffffffffffffffffffffffffffffffffffffffffffffffc7634d81f4372ddf581a0db248b0a77aecec196accc52973",-3,"0xb3312fa7e23ee7e4988e056be3f82d19181d9c6efe8141120314088f5013875ac656398d8a2ed19d2a85c8edd3ec2aef","0xaa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7","0x3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f"),k192:new h.ecc.curve(h.bn.prime.p192k,"0xfffffffffffffffffffffffe26f2fc170f69466a74defd8d",0,3,"0xdb4ff10ec057e9ae26b07d0280b7f4341da5d1b1eae06c7d","0x9b2f2f6d9c5628a7844163d015be86344082aa88d95e2f9d"),k224:new h.ecc.curve(h.bn.prime.p224k,"0x010000000000000000000000000001dce8d2ec6184caf0a971769fb1f7",0,5,"0xa1455b334df099df30fc28a169a467e9e47075a90f7e650eb6b7a45c","0x7e089fed7fba344282cafbd6f7e319f7c0b0bd59e2ca4bdb556d61a5"),k256:new h.ecc.curve(h.bn.prime.p256k,"0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141",0,7,"0x79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798","0x483ada7726a3c4655da4fbfc0e1108a8fd17b448a68554199c47d08ffb10d4b8")},h.ecc.basicKey={publicKey:function(a,b){this._curve=a,this._curveBitLength=a.r.bitLength(),this._point=b instanceof Array?a.fromBits(b):b,this.get=function(){var a=this._point.toBits(),b=h.bitArray.bitLength(a),c=h.bitArray.bitSlice(a,0,b/2),d=h.bitArray.bitSlice(a,b/2);return{x:c,y:d}}},secretKey:function(a,b){this._curve=a,this._curveBitLength=a.r.bitLength(),this._exponent=b,this.get=function(){return this._exponent.toBits()}}},h.ecc.basicKey.generateKeys=function(a){return function(c,d,e){if(c=c||256,d=d||0,"number"==typeof c&&(c=h.ecc.curves["c"+c],c===b))throw new h.exception.invalid("no such curve");e=e||h.bn.random(c.r,d);var f=c.G.mult(e);return{pub:new h.ecc[a].publicKey(c,f),sec:new h.ecc[a].secretKey(c,e)}}},h.ecc.elGamal={generateKeys:h.ecc.basicKey.generateKeys("elGamal"),publicKey:function(){h.ecc.basicKey.publicKey.apply(this,arguments)},secretKey:function(){h.ecc.basicKey.secretKey.apply(this,arguments)}},h.ecc.elGamal.publicKey.prototype={kem:function(a){var b=h.bn.random(this._curve.r,a),c=this._curve.G.mult(b).toBits(),d=h.hash.sha256.hash(this._point.mult(b).toBits());return{key:d,tag:c}}},h.ecc.elGamal.secretKey.prototype={unkem:function(a){return h.hash.sha256.hash(this._curve.fromBits(a).mult(this._exponent).toBits())},dh:function(a){return h.hash.sha256.hash(a._point.mult(this._exponent).toBits())}},h.ecc.ecdsa={generateKeys:h.ecc.basicKey.generateKeys("ecdsa")},h.ecc.ecdsa.publicKey=function(){h.ecc.basicKey.publicKey.apply(this,arguments)},h.ecc.ecdsa.publicKey.prototype={verify:function(a,c,d){h.bitArray.bitLength(a)>this._curveBitLength&&(a=h.bitArray.clamp(a,this._curveBitLength));var e=h.bitArray,f=this._curve.r,g=this._curveBitLength,i=h.bn.fromBits(e.bitSlice(c,0,g)),j=h.bn.fromBits(e.bitSlice(c,g,2*g)),k=d?j:j.inverseMod(f),l=h.bn.fromBits(a).mul(k).mod(f),m=i.mul(k).mod(f),n=this._curve.G.mult2(l,m,this._point).x;if(i.equals(0)||j.equals(0)||i.greaterEquals(f)||j.greaterEquals(f)||!n.equals(i)){if(d===b)return this.verify(a,c,!0);throw new h.exception.corrupt("signature didn't check out")}return!0}},h.ecc.ecdsa.secretKey=function(){h.ecc.basicKey.secretKey.apply(this,arguments)},h.ecc.ecdsa.secretKey.prototype={sign:function(a,b,c,d){h.bitArray.bitLength(a)>this._curveBitLength&&(a=h.bitArray.clamp(a,this._curveBitLength));var e=this._curve.r,f=e.bitLength(),g=d||h.bn.random(e.sub(1),b).add(1),i=this._curve.G.mult(g).x.mod(e),j=h.bn.fromBits(a).add(i.mul(this._exponent)),k=c?j.inverseMod(e).mul(g).mod(e):j.mul(g.inverseMod(e)).mod(e);return h.bitArray.concat(i.toBits(f),k.toBits(f))}};var j={},k=192,l=j.ENC_DEC={},m=j.SIG_VER={},n=c("elGamal"),o=c("ecdsa"),p=g("sha256");j.sjcl=h,j.generate=function(a,b){b||(b=k);var c,d,g;if(a===l)d="enc",g="dec",c=n.generate(b);else{if(a!==m)throw"eccjs: generate: Unknown type";d="ver",g="sig",c=o.generate(b)}var h={};return h[d]=e(c.pub),h[g]=f(c.sec),h};var q={enc:{},dec:{},sig:{},ver:{}};j.encrypt=function(a,b){var c=q.enc[a];c||(c=q.enc[a]=n.importPublic(a).kem(),c.tagHex=h.codec.hex.fromBits(c.tag));var d=h.json._encrypt(c.key,b);return d.tag=c.tagHex,JSON.stringify(d)},j.decrypt=function(a,b){var c=JSON.parse(b),d=q.dec[a];d||(d=q.dec[a]=n.importSecret(a),d.$keys={});var e=d.$keys[c.tag];return e||(e=d.$keys[c.tag]=d.unkem(h.codec.hex.toBits(c.tag))),h.json._decrypt(e,c)},j.sign=function(a,b,c){var d=q.sig[a];return d||(d=q.sig[a]=o.importSecret(a)),c!==!1&&(b=p.hash(b)),d.sign(b)},j.verify=function(a,b,c,d){var e=q.ver[a];e||(e=q.ver[a]=o.importPublic(a)),d!==!1&&(c=p.hash(c));try{return e.verify(c,b)}catch(f){return!1}},"undefined"!=typeof module&&module.exports?module.exports=j:a.ecc=j}(this);