(set-env!
  :resource-paths #{"resources"}
  :dependencies '[[adzerk/bootlaces   "0.1.9" :scope "test"]
                  [cljsjs/boot-cljsjs "0.4.6" :scope "test"]])

(require '[adzerk.bootlaces :refer :all]
         '[cljsjs.boot-cljsjs.packaging :refer :all])

(def +version+ "{{version}}-0")

(task-options!
  pom  {:project     'cljsjs/{{name}}
        :version     +version+
        :scm         {:url "https://github.com/cljsjs/packages"}
        :description "{{name}} packaged up with Google Closure externs"

        ;; 1. EDIT LIBRARY HOMEPAGE
        :url         "http://example.com/"

        ;; 2. CHOOSE LICENSE (or add another one)
        ;; :license     {"MIT" "http://opensource.org/licenses/MIT"}
        ;; :license     {"BSD" "http://opensource.org/licenses/BSD-3-Clause"}
        ;; :license     {"Apache" "http://opensource.org/licenses/Apache-2.0"}
        })

(deftask package []
  (comp
    ;; 3. EDIT DOWNLOAD LOCATIONS AND CHECKSUMS (use `md5` or `md5sum` commands for checksums)
    ;;    (add `:unzip true` args if you are downloading a zip)
    (download :url "http://example.com/{{name}}-{{version}}.js"     :checksum "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    (download :url "http://example.com/{{name}}-{{version}}.min.js" :checksum "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")

    ;; 4. MAKE SURE REGEX FINDS THE APPROPRIATE DOWNLOADS
    (sift :move {#"{{name}}-([\d\.]*).js"    "cljsjs/development/{{name}}.inc.js"
                 #"{{name}}-([\d\.]*).min.js" "cljsjs/production/{{name}}.min.inc.js"})

    (sift :include #{#"^cljsjs"})
    (deps-cljs :name "cljsjs.{{name}}")))
