(ns leiningen.new.cljsjs-package
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "cljsjs-package"))

(defn cljsjs-package
  "FIXME: write documentation"
  ([name] (cljsjs-package name nil))
  ([name version]
   (let [data {:name name
               :version (or version "0.0.0")
               :sanitized (name-to-path name)}]
     (main/info "Generating new cljsjs-package.")
     (->files data
              ["build.boot" (render "build.boot" data)]
              ["README.md" (render "README.md" data)]
              ["resources/cljsjs/common/{{name}}.ext.js" (render "ext.js" data)]))))
