(ns to-utf8-unix.core
  (:require [to-utf8-unix.middlewares :as mw]))

(defn convert
  "accepts js/Buffer
  returns buffer_descriptor defined in README.md"
  ([buffer]
   (let [threshold 90]
     (convert buffer threshold)))
  ([buffer confidence_threshold]
   (let [pipeline (comp mw/detect_charset
                       (mw/ensure_confidence confidence_threshold)
                       (mw/encode_charset "UTF-8")
                       mw/remove_carriage_return
                       mw/add_conversion_msg)
        pipeline (pipeline identity)]
    (pipeline {:buffer buffer}))))
