(defproject {{name}} "0.1.0-SNAPSHOT"
  :description "FIXME: write this!"
  :url "http://example.com/FIXME"

  :min-lein-version "2.5.3"

  :dependencies [[org.clojure/clojure "1.7.0"]
                 [org.clojure/clojurescript "1.7.170"]]

  :plugins [[lein-cljsbuild "1.1.1"]
            [lein-figwheel "0.5.0-2"]]

  :source-paths ["src/clj" "src/bin" "src/cljs"]

  :clean-targets ["index.js"
                  "target"
                  "figwheel_server.log"
                  "bin/{{name}}.js"]

  :license {:name ""
            :distribution :repo}

  :profiles {:repl {:dependencies [[com.cemerick/piggieback "0.2.1"]
                                   [figwheel-sidecar "0.5.0-2"]]}}
  :main repl.core

  :cljsbuild {
    :builds [{:id "dev"
              :source-paths ["src/cljs" "src/bin"]
              :figwheel true
              :compiler {;; If you set :main to {{name}}.core,
                         ;; figwheel won't automatically load
                         ;; executable.core because
                         ;; {{name}}.core doesn't include executable.core.
                         :main executable.core
                         :output-to "target/server_dev/{{sanitized}}.js"
                         :output-dir "target/server_dev"
                         :target :nodejs
                         :optimizations :none
                         :source-map true}}
             {:id "lib"
              :source-paths ["src/cljs"]
              :compiler {:main {{name}}.core
                         :output-to "index.js"
                         :output-dir "target/server_prod"
                         :target :nodejs
                         :optimizations :simple}}
             {:id "bin"
              :source-paths ["src/bin" "src/cljs"]
              :compiler {:main executable.core
                         :output-to "bin/{{name}}.js"
                         :output-dir "target/server_bin"
                         :target :nodejs
                         :optimizations :simple}}]})
