(ns {{name}}.core
  "Houses application state and defines actions and the main application component"
  (:require [reagent.core :as reagent]
            [re-frame.core :as re-frame]
            [{{name}}.bootstrap :as bootstrap]
            [{{name}}.util :refer [on-ipc get-url]]
            [{{name}}.settings :as settings]))

(enable-console-print!)

(re-frame/reg-event-db
 ::initialize-db
 (fn  [_ _]
   {:message "{{name}}!"}))

(re-frame/reg-sub
 ::nav-height
 (fn [db _]
   (get db ::nav-height "220px")))

(re-frame/reg-event-db
 ::set-nav-height
 (fn [db _]
   (let [nav-ele (-> (.getElementsByTagName js/document "nav")
                     (.item 0))
         nav-height (if nav-ele
                      (-> (.getComputedStyle js/window nav-ele)
                          (.getPropertyValue "height"))
                      "220px")]
     (assoc db ::nav-height nav-height))))

(re-frame/reg-sub
 ::message
 (fn [db _]
   (get db :message)))

(re-frame/reg-event-db
 ::message
 (fn [db [_ new-msg]]
   (assoc db :message new-msg)))

(defn update-setting
  "Template that shows how to save settings."
  [k v]
  (settings/update-setting k v))

(defn update-message [event new-msg]
  (re-frame/dispatch [::message new-msg]))

;;; Application Component
(defn navigation []
  (let [] ;(re-frame/subscribe [::db/current-page])]
    [:> bootstrap/nav-bar {:collapseOnSelect false :fixedTop true}
     [:> bootstrap/nav-header
      [:> bootstrap/nav-brand "{{name}}"]
      [:> bootstrap/nav-toogle]]
     [:> bootstrap/nav-container {:bsStyle "tabs"
                                  :activeKey :home}
                                   ;:on-select #(handle-nav-click %)}
      [:> bootstrap/nav-item {:eventKey :home} "Home"]
      [:> bootstrap/nav-item {:eventKey :blub} "Test"]]]))

(defn app []
  (let [msg @(re-frame/subscribe [::message])
        nav-height @(re-frame/subscribe [::nav-height])]
    [:div.main {:style {:margin-top nav-height}}
     [navigation]
     [:div.container
      [:> bootstrap/header
       {:on-click #(update-setting :test "test")}
       msg]]]))

(defn ^:export init []
  (re-frame/dispatch-sync [::initialize-db])
  (re-frame/clear-subscription-cache!)
  (aset js/window "onload" #(re-frame/dispatch [::set-nav-height]))
  (aset js/window "onresize" #(re-frame/dispatch [::set-nav-height]))
  (reagent/render
   [app]
   (.getElementById js/document "{{name}}"))
  (.addEventListener js/window "beforeunload" (fn [event]
                                                (worker/close-worker!)))
  (on-ipc "update-message" update-message))

;;; Render {{name}} as node application
(defn -main []
  (init)
  (update-setting :test "test"))

(set! *main-cli-fn* -main)