(ns {{name}}.util
  "A namespace to hide interop details and electron use. Might be
  a library some day"
  (:require [electron :refer [BrowserWindow remote app ipcRenderer ipcMain]]
            [path]
            [clojure.string :refer [includes?]]))

(defn get-app []
  (or app (.-app remote)))

(defn get-path
  [path-id filename]
  (-> (get-app)
      (.getPath path-id)
      (path/join filename)))

(defn- browser-window-ctor []
  (or BrowserWindow (.-BrowserWindow remote)))

(defn browser-window
  [options]
  (let [ctor (browser-window-ctor)]
    (ctor. (clj->js options))))

(defn get-url [filename]
  (let [env     (.. js/process -execPath)
        app-path (.getAppPath (get-app))
        prod? (not (includes? env "node_modules"))
        prefix (if prod?  "/resources/public/" "/../../../../../resources/public/")] ;ugly but works xD
    (println "app-path" app-path)
    (if prod?
      (str "file://" app-path prefix filename)
      (->> (path/join app-path prefix filename)
           (path/resolve)
           (str "file://")))))

(defn load-url
  [window filename]
  (let [file-url (get-url filename)]
    (println "file-url" file-url)
    (.loadURL window file-url)))

(defn on
  [emitter event-name handler]
  (.on emitter event-name handler))

(defn on-app
  [event-name handler]
  (on (get-app) event-name handler))

(defn on-ipc
  "register ipc listener for renderer processes"
  [event-name handler]
  (println "ipcRenderer" ipcRenderer)
  (on ipcRenderer event-name handler))

(defn send-ipc
  ([event-name data]
   (.send ipcRenderer event-name data))
  ([event-name]
   (.send ipcRenderer event-name)))

(defn on-ipc-main
  "register ipc listener for main process - explicitly named as
  it is the exception here"
  [event-name handler]
  (println "ipcMain" ipcMain)
  (on ipcMain event-name handler))

(defn quit []
  (.quit app))

(defn relaunch []
  (.relaunch app))

(defn current-window-id []
  (->> (browser-window-ctor)
       .getFocusedWindow
       .-id))

(defn web-contents
  "Get the webContents of a browser window identified by id"
  [id]
  (->> id
       (.fromId (browser-window-ctor))
       .-webContents))
