(ns leiningen.new.cljs-electron
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "cljs-electron"))

(defn cljs-electron
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' cljs-electron project.")
    (->files data
             ["src/main/{{sanitized}}/core.cljs" (render "main/core.cljs" data)]
             ["src/shared/{{sanitized}}/data.cljs" (render "shared/data.cljs" data)]
             ["src/shared/{{sanitized}}/util.cljs" (render "shared/util.cljs" data)]
             ["src/ui/{{sanitized}}/bootstrap.cljs" (render "ui/bootstrap.cljs" data)]
             ["src/ui/{{sanitized}}/core.cljs" (render "ui/core.cljs" data)]
             ["src/ui/{{sanitized}}/settings.cljs" (render "ui/settings.cljs" data)]
             ["src/ui/{{sanitized}}/worker.cljs" (render "ui/worker.cljs" data)]
             ["src/worker/{{sanitized}}/core.cljs" (render "worker/core.cljs" data)]
             ["src/worker/{{sanitized}}/settings.cljs" (render "worker/settings.cljs" data)]
             ["resources/public/css/bootstrap.css" (render "public/bootstrap.css" data)]
             ["resources/public/css/bootstrap.min.css" (render "public/bootstrap.min.css" data)]
             ["resources/public/css/react-datepicker.min.css" (render "public/react-datepicker.min.css" data)]
             ["resources/public/index.html" (render "public/index.html" data)]
             ["resources/public/worker.html" (render "public/worker.html" data)]
             [".gitignore" (render ".gitignore" data)]
             ["project.clj" (render "project.clj" data)]
             ["build-win64.sh" (render "build-win64.sh" data)]
             ["clean_up.clj" (render "clean_up.clj" data)]
             ["package.json" (render "package.json" data)]
             ["README.md" (render "README.md" data)]))) 
