(ns leiningen.new.cljs-austin
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "cljs-austin"))

(defn cljs-austin
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["src/clj/bcrepl.clj" (render "bcrepl.clj" data)]
["src/cljs/bcrepl.cljs" (render "bcrepl.cljs" data)]
["project.clj" (render "project.clj" data)]
["resources/index.html" (render "index.html")]
)))
