goog.provide('shadow.xhr');
goog.require('cljs.core');
goog.require('goog.result');
goog.require('goog.result.SimpleResult');
goog.require('goog.labs.net.xhr');
goog.require('cljs.reader');
goog.require('goog.uri.utils');
goog.require('goog.json');
goog.require('shadow.object');
goog.require('shadow.dom');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('shadow.util');
shadow.xhr.result_chain = (function shadow$xhr$result_chain(res,handler){
return goog.result.chain(res,handler);
});
shadow.xhr.result_combine = (function shadow$xhr$result_combine(var_args){
var args__6930__auto__ = [];
var len__6920__auto___57259 = arguments.length;
var i__6921__auto___57260 = (0);
while(true){
if((i__6921__auto___57260 < len__6920__auto___57259)){
args__6930__auto__.push((arguments[i__6921__auto___57260]));

var G__57261 = (i__6921__auto___57260 + (1));
i__6921__auto___57260 = G__57261;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((0) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((0)),(0),null)):null);
return shadow.xhr.result_combine.cljs$core$IFn$_invoke$arity$variadic(argseq__6931__auto__);
});

(shadow.xhr.result_combine.cljs$core$IFn$_invoke$arity$variadic = (function (results){
return cljs.core.apply.call(null,goog.result.combine,results);
}));

(shadow.xhr.result_combine.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.xhr.result_combine.cljs$lang$applyTo = (function (seq57161){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq57161));
}));

shadow.xhr.result_wait_on_success = (function shadow$xhr$result_wait_on_success(res,callback){
return goog.result.waitOnSuccess(res,callback);
});
shadow.xhr.result_success_QMARK_ = (function shadow$xhr$result_success_QMARK_(res){
return cljs.core._EQ_.call(null,goog.result.Result.State.SUCCESS,res.getState());
});
shadow.xhr.result_value = (function shadow$xhr$result_value(res){
return res.getValue();
});
shadow.xhr.result_immediate = (function shadow$xhr$result_immediate(value){
return goog.result.successfulResult(value);
});
shadow.xhr.result_error = (function shadow$xhr$result_error(res,callback){
return goog.result.waitOnError(res,callback);
});
shadow.xhr.edn_transform = (function shadow$xhr$edn_transform(body){
return cljs.reader.read_string.call(null,body);
});
shadow.xhr.json_transform = (function shadow$xhr$json_transform(body){
return cljs.core.js__GT_clj.call(null,JSON.parse(body));
});
shadow.xhr.goog_keys = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"timeout","timeout",-318625318),"timeoutMs",new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),"withCredentials",new cljs.core.Keyword(null,"headers","headers",-835030129),"headers",new cljs.core.Keyword(null,"mime-type","mime-type",1058646439),"mimeType"], null);
shadow.xhr.make_request_options = (function shadow$xhr$make_request_options(options){
var obj = ({});
var seq__57168_57262 = cljs.core.seq.call(null,options);
var chunk__57169_57263 = null;
var count__57170_57264 = (0);
var i__57171_57265 = (0);
while(true){
if((i__57171_57265 < count__57170_57264)){
var vec__57178_57266 = cljs.core._nth.call(null,chunk__57169_57263,i__57171_57265);
var k_57267 = cljs.core.nth.call(null,vec__57178_57266,(0),null);
var v_57268 = cljs.core.nth.call(null,vec__57178_57266,(1),null);
(obj[cljs.core.get.call(null,shadow.xhr.goog_keys,k_57267)] = cljs.core.clj__GT_js.call(null,v_57268));


var G__57269 = seq__57168_57262;
var G__57270 = chunk__57169_57263;
var G__57271 = count__57170_57264;
var G__57272 = (i__57171_57265 + (1));
seq__57168_57262 = G__57269;
chunk__57169_57263 = G__57270;
count__57170_57264 = G__57271;
i__57171_57265 = G__57272;
continue;
} else {
var temp__5720__auto___57273 = cljs.core.seq.call(null,seq__57168_57262);
if(temp__5720__auto___57273){
var seq__57168_57274__$1 = temp__5720__auto___57273;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57168_57274__$1)){
var c__6568__auto___57275 = cljs.core.chunk_first.call(null,seq__57168_57274__$1);
var G__57276 = cljs.core.chunk_rest.call(null,seq__57168_57274__$1);
var G__57277 = c__6568__auto___57275;
var G__57278 = cljs.core.count.call(null,c__6568__auto___57275);
var G__57279 = (0);
seq__57168_57262 = G__57276;
chunk__57169_57263 = G__57277;
count__57170_57264 = G__57278;
i__57171_57265 = G__57279;
continue;
} else {
var vec__57181_57280 = cljs.core.first.call(null,seq__57168_57274__$1);
var k_57281 = cljs.core.nth.call(null,vec__57181_57280,(0),null);
var v_57282 = cljs.core.nth.call(null,vec__57181_57280,(1),null);
(obj[cljs.core.get.call(null,shadow.xhr.goog_keys,k_57281)] = cljs.core.clj__GT_js.call(null,v_57282));


var G__57283 = cljs.core.next.call(null,seq__57168_57274__$1);
var G__57284 = null;
var G__57285 = (0);
var G__57286 = (0);
seq__57168_57262 = G__57283;
chunk__57169_57263 = G__57284;
count__57170_57264 = G__57285;
i__57171_57265 = G__57286;
continue;
}
} else {
}
}
break;
}

return obj;
});
shadow.xhr.content_transforms = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 5, ["text/edn",shadow.xhr.edn_transform,"application/edn",shadow.xhr.edn_transform,"application/json",shadow.xhr.json_transform,"text/html",cljs.core.identity,"text/plain",cljs.core.identity], null));
shadow.xhr.register_transform = (function shadow$xhr$register_transform(content_type,transform_fn){
return cljs.core.swap_BANG_.call(null,shadow.xhr.content_transforms,cljs.core.assoc,content_type,transform_fn);
});
shadow.xhr.auto_transform = (function shadow$xhr$auto_transform(req){
var content_type = (function (){var ct = clojure.string.lower_case.call(null,req.getResponseHeader("Content-Type"));
var sep = ct.indexOf(";");
if(cljs.core.not_EQ_.call(null,(-1),sep)){
return ct.substring((0),sep);
} else {
return ct;
}
})();
var transform_fn = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.xhr.content_transforms),content_type);
if((transform_fn == null)){
throw cljs.core.ex_info.call(null,"unsupported content-type",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"req","req",-326448303),req,new cljs.core.Keyword(null,"content-type","content-type",-508222634),content_type], null));
} else {
return transform_fn.call(null,req.responseText);
}
});
shadow.xhr.make_url = (function shadow$xhr$make_url(url,params){
return goog.uri.utils.appendParamsFromMap(url,cljs.core.clj__GT_js.call(null,params));
});
shadow.xhr.transform_request_body = (function shadow$xhr$transform_request_body(data){
if(typeof data === 'string'){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["text/plain; charset=utf-8",data], null);
} else {
if((((!((data == null))))?(((((data.cljs$lang$protocol_mask$partition0$ & (2147483648))) || ((cljs.core.PROTOCOL_SENTINEL === data.cljs$core$IPrintWithWriter$))))?true:(((!data.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IPrintWithWriter,data):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IPrintWithWriter,data))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["text/edn; charset=utf-8",cljs.core.pr_str.call(null,data)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["application/octet-stream",data], null);

}
}
});
shadow.xhr.as_url = (function shadow$xhr$as_url(input){
if(typeof input === 'string'){
return input;
} else {
if(((cljs.core.vector_QMARK_.call(null,input)) && (cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,input))) && (typeof cljs.core.first.call(null,input) === 'string') && (cljs.core.map_QMARK_.call(null,cljs.core.second.call(null,input))))){
var vec__57187 = input;
var url = cljs.core.nth.call(null,vec__57187,(0),null);
var params = cljs.core.nth.call(null,vec__57187,(1),null);
return shadow.xhr.make_url.call(null,url,params);
} else {
throw cljs.core.ex_info.call(null,"doesnt look like an url",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),input], null));

}
}
});
shadow.xhr.e__GT_data = (function shadow$xhr$e__GT_data(e){
return e;
});
shadow.xhr.event_handler = (function shadow$xhr$event_handler(req,events,event_type){
return (function (e){
if(cljs.core.map_QMARK_.call(null,events)){
var temp__5720__auto__ = cljs.core.get.call(null,events,event_type);
if(cljs.core.truth_(temp__5720__auto__)){
var c = temp__5720__auto__;
return cljs.core.async.put_BANG_.call(null,c,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [req,shadow.xhr.e__GT_data.call(null,e)], null));
} else {
return null;
}
} else {
if((!((events == null)))){
return cljs.core.async.put_BANG_.call(null,events,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,req,shadow.xhr.e__GT_data.call(null,e)], null));
} else {
return null;

}
}
});
});
shadow.xhr.request_ok_QMARK_ = (function shadow$xhr$request_ok_QMARK_(status){
return cljs.core._EQ_.call(null,(200),status);
});
shadow.xhr.request_error_QMARK_ = (function shadow$xhr$request_error_QMARK_(status){
return (status >= (400));
});
/**
 * creates a channel and performs xhr request like (chan :GET "/something")
 * 
 * accepts url as string or [url params]
 * 
 * this channel will receive one message [status body req] on load
 * loadend will close the result channel, so you will get nil results on request errors/timeouts
 * 
 * use options hash to pass in extra channels
 * 
 * (chan :POST "/something" some-data {:events chan-or-map
 *                                       :upload chan-or-map})
 * 
 * when given a chan that channels receives messages in form of [event-type event-data req]
 * when given a map a channel is expected for each eventtype and will receive [event-data req]
 * {:timeout some-chan}, if no channel for a given event is present, no message is sent
 * 
 * event types are :loadstart :progress :abort :error :timeout :loadend :load (see xhr spec)
 * only exception is that status >= 500 does not return a result and produces an error event instead
 */
shadow.xhr.chan = (function shadow$xhr$chan(var_args){
var G__57192 = arguments.length;
switch (G__57192) {
case 2:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.xhr.chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.xhr.chan.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return shadow.xhr.chan.call(null,method,url,null,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.xhr.chan.cljs$core$IFn$_invoke$arity$3 = (function (method,url,data){
return shadow.xhr.chan.call(null,method,url,data,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.xhr.chan.cljs$core$IFn$_invoke$arity$4 = (function (method,url,data,p__57197){
var map__57198 = p__57197;
var map__57198__$1 = (((((!((map__57198 == null))))?(((((map__57198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57198.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57198):map__57198);
var options = map__57198__$1;
var events = cljs.core.get.call(null,map__57198__$1,new cljs.core.Keyword(null,"events","events",1792552201));
var upload = cljs.core.get.call(null,map__57198__$1,new cljs.core.Keyword(null,"upload","upload",-255769218));
var body_only = cljs.core.get.call(null,map__57198__$1,new cljs.core.Keyword(null,"body-only","body-only",-698120682));
var req = (new XMLHttpRequest());
var body_QMARK_ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method);
var vec__57200 = ((body_QMARK_)?shadow.xhr.transform_request_body.call(null,data):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null], null));
var content_type = cljs.core.nth.call(null,vec__57200,(0),null);
var body = cljs.core.nth.call(null,vec__57200,(1),null);
var result_chan = cljs.core.async.chan.call(null,(1));
if(cljs.core.truth_(((body_QMARK_)?upload:false))){
shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"progress","progress",244323547),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"progress","progress",244323547)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"abort","abort",521193198),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"abort","abort",521193198)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"error","error",-978969032),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"error","error",-978969032)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"timeout","timeout",-318625318),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"timeout","timeout",-318625318)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564)));

shadow.dom.on.call(null,req.upload,new cljs.core.Keyword(null,"load","load",-1318641184),shadow.xhr.event_handler.call(null,req,upload,new cljs.core.Keyword(null,"loadend","loadend",1430560564)));
} else {
}

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"loadstart","loadstart",1841209333)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"progress","progress",244323547),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"progress","progress",244323547)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"abort","abort",521193198),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"abort","abort",521193198)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"timeout","timeout",-318625318),shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"timeout","timeout",-318625318)));

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"loadend","loadend",1430560564),(function (){var callback = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"loadend","loadend",1430560564));
return (function (e){
callback.call(null,e);

return cljs.core.async.close_BANG_.call(null,result_chan);
});
})());

var error_handler_57302 = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"error","error",-978969032));
shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"error","error",-978969032),error_handler_57302);

shadow.dom.on.call(null,req,new cljs.core.Keyword(null,"load","load",-1318641184),(function (){var callback = shadow.xhr.event_handler.call(null,req,events,new cljs.core.Keyword(null,"load","load",-1318641184));
return (function (e){
var status = req.status;
var body__$1 = (function (){var temp__5718__auto__ = new cljs.core.Keyword(null,"transform","transform",1381301764).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(temp__5718__auto__)){
var transform = temp__5718__auto__;
return transform.call(null,req.responseText,req);
} else {
return shadow.xhr.auto_transform.call(null,req);
}
})();
if(shadow.xhr.request_error_QMARK_.call(null,status)){
return error_handler_57302.call(null,e);
} else {
callback.call(null,e);

if(cljs.core.truth_(body_only)){
return cljs.core.async.put_BANG_.call(null,result_chan,body__$1);
} else {
return cljs.core.async.put_BANG_.call(null,result_chan,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [status,body__$1,req], null));
}
}
});
})());

req.open(cljs.core.name.call(null,method),shadow.xhr.as_url.call(null,url),true);

(req.responseType = "text");

(req.withCredentials = (!(new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235).cljs$core$IFn$_invoke$arity$1(options) === false)));

if(body_QMARK_){
req.setRequestHeader("Content-Type",content_type);
} else {
}

if(body_QMARK_){
req.send(body);
} else {
req.send();
}

return result_chan;
}));

(shadow.xhr.chan.cljs$lang$maxFixedArity = 4);

shadow.xhr.request = (function shadow$xhr$request(var_args){
var G__57204 = arguments.length;
switch (G__57204) {
case 2:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.xhr.request.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.xhr.request.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return shadow.xhr.request.call(null,method,url,null,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.xhr.request.cljs$core$IFn$_invoke$arity$3 = (function (method,url,data){
return shadow.xhr.request.call(null,method,url,data,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.xhr.request.cljs$core$IFn$_invoke$arity$4 = (function (method,url,data,options){
if((((!(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"DELETE","DELETE",1688673772),null,new cljs.core.Keyword(null,"GET","GET",1736591026),null], null), null),method)))) && ((data == null)))){
throw cljs.core.ex_info.call(null,"request needs data",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),method,new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"data","data",-232669377),data,new cljs.core.Keyword(null,"options","options",99638489),options], null));
} else {
}

var body_QMARK_ = (!(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method)) || ((data == null)))));
var vec__57205 = shadow.xhr.transform_request_body.call(null,data);
var content_type = cljs.core.nth.call(null,vec__57205,(0),null);
var body = cljs.core.nth.call(null,vec__57205,(1),null);
var req = goog.labs.net.xhr.send(cljs.core.name.call(null,method),(cljs.core.truth_(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"GET","GET",1736591026),method))?data:false))?shadow.xhr.make_url.call(null,url,data):url),((body_QMARK_)?body:null),shadow.xhr.make_request_options.call(null,((body_QMARK_)?cljs.core.assoc_in.call(null,options,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Content-Type"], null),content_type):options)));
var req__$1 = goog.result.SimpleResult.fromPromise(req);
return goog.result.transform(req__$1,shadow.xhr.auto_transform);
}));

(shadow.xhr.request.cljs$lang$maxFixedArity = 4);

shadow.xhr.upload = (function shadow$xhr$upload(var_args){
var args__6930__auto__ = [];
var len__6920__auto___57306 = arguments.length;
var i__6921__auto___57311 = (0);
while(true){
if((i__6921__auto___57311 < len__6920__auto___57306)){
args__6930__auto__.push((arguments[i__6921__auto___57311]));

var G__57316 = (i__6921__auto___57311 + (1));
i__6921__auto___57311 = G__57316;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((2) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((2)),(0),null)):null);
return shadow.xhr.upload.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6931__auto__);
});

(shadow.xhr.upload.cljs$core$IFn$_invoke$arity$variadic = (function (url,file,events){
var xhr = (new XMLHttpRequest());
var seq__57215_57321 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),events));
var chunk__57217_57322 = null;
var count__57218_57323 = (0);
var i__57219_57324 = (0);
while(true){
if((i__57219_57324 < count__57218_57323)){
var vec__57244_57325 = cljs.core._nth.call(null,chunk__57217_57322,i__57219_57324);
var ev_id_57326 = cljs.core.nth.call(null,vec__57244_57325,(0),null);
var ev_handler_57327 = cljs.core.nth.call(null,vec__57244_57325,(1),null);
var target_57329 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"progress","progress",244323547),ev_id_57326))?(xhr["upload"]):xhr);
target_57329.addEventListener(cljs.core.name.call(null,ev_id_57326),ev_handler_57327);


var G__57330 = seq__57215_57321;
var G__57331 = chunk__57217_57322;
var G__57332 = count__57218_57323;
var G__57333 = (i__57219_57324 + (1));
seq__57215_57321 = G__57330;
chunk__57217_57322 = G__57331;
count__57218_57323 = G__57332;
i__57219_57324 = G__57333;
continue;
} else {
var temp__5720__auto___57334 = cljs.core.seq.call(null,seq__57215_57321);
if(temp__5720__auto___57334){
var seq__57215_57335__$1 = temp__5720__auto___57334;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57215_57335__$1)){
var c__6568__auto___57336 = cljs.core.chunk_first.call(null,seq__57215_57335__$1);
var G__57341 = cljs.core.chunk_rest.call(null,seq__57215_57335__$1);
var G__57342 = c__6568__auto___57336;
var G__57343 = cljs.core.count.call(null,c__6568__auto___57336);
var G__57344 = (0);
seq__57215_57321 = G__57341;
chunk__57217_57322 = G__57342;
count__57218_57323 = G__57343;
i__57219_57324 = G__57344;
continue;
} else {
var vec__57254_57345 = cljs.core.first.call(null,seq__57215_57335__$1);
var ev_id_57346 = cljs.core.nth.call(null,vec__57254_57345,(0),null);
var ev_handler_57347 = cljs.core.nth.call(null,vec__57254_57345,(1),null);
var target_57348 = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"progress","progress",244323547),ev_id_57346))?(xhr["upload"]):xhr);
target_57348.addEventListener(cljs.core.name.call(null,ev_id_57346),ev_handler_57347);


var G__57349 = cljs.core.next.call(null,seq__57215_57335__$1);
var G__57350 = null;
var G__57351 = (0);
var G__57352 = (0);
seq__57215_57321 = G__57349;
chunk__57217_57322 = G__57350;
count__57218_57323 = G__57351;
i__57219_57324 = G__57352;
continue;
}
} else {
}
}
break;
}

var G__57257 = xhr;
G__57257.open("PUT",url);

G__57257.send(file);

return G__57257;
}));

(shadow.xhr.upload.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.xhr.upload.cljs$lang$applyTo = (function (seq57208){
var G__57209 = cljs.core.first.call(null,seq57208);
var seq57208__$1 = cljs.core.next.call(null,seq57208);
var G__57210 = cljs.core.first.call(null,seq57208__$1);
var seq57208__$2 = cljs.core.next.call(null,seq57208__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57209,G__57210,seq57208__$2);
}));


//# sourceMappingURL=shadow.xhr.js.map
