goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_56528 = (function (this$){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (shadow.dom._to_dom[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$);
} else {
var m__6344__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_56528.call(null,this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_56532 = (function (this$){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (shadow.dom._to_svg[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$);
} else {
var m__6344__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_56532.call(null,this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons.call(null,(coll[idx]),shadow.dom.lazy_native_coll_seq.call(null,coll,(idx + (1))));
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5598__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq.call(null,self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return shadow.dom._to_dom.call(null,el);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__55991 = arguments.length;
switch (G__55991) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node.call(null,root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__55996 = arguments.length;
switch (G__55996) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__55998 = arguments.length;
switch (G__55998) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node.call(null,el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__56002 = arguments.length;
switch (G__56002) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.call(null,e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.call(null,e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__56012 = arguments.length;
switch (G__56012) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node.call(null,el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node.call(null,parent),shadow.dom.dom_node.call(null,el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__56016 = arguments.length;
switch (G__56016) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node.call(null,el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class.call(null,el,cls);
} else {
return shadow.dom.remove_class.call(null,el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5598__auto__ = (!((typeof document !== 'undefined')));
if(or__5598__auto__){
return or__5598__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return handler.call(null,e,el);
}));
}catch (e56021){if((e56021 instanceof Object)){
var e = e56021;
return console.log("didnt support attachEvent",el,e);
} else {
throw e56021;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5598__auto__ = (!((typeof document !== 'undefined')));
if(or__5598__auto__){
return or__5598__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__56029 = cljs.core.seq.call(null,shadow.dom.query.call(null,selector,root_el));
var chunk__56030 = null;
var count__56031 = (0);
var i__56032 = (0);
while(true){
if((i__56032 < count__56031)){
var el = cljs.core._nth.call(null,chunk__56030,i__56032);
var handler_56557__$1 = ((function (seq__56029,chunk__56030,count__56031,i__56032,el){
return (function (e){
return handler.call(null,e,el);
});})(seq__56029,chunk__56030,count__56031,i__56032,el))
;
shadow.dom.dom_listen.call(null,el,cljs.core.name.call(null,ev),handler_56557__$1);


var G__56559 = seq__56029;
var G__56560 = chunk__56030;
var G__56561 = count__56031;
var G__56562 = (i__56032 + (1));
seq__56029 = G__56559;
chunk__56030 = G__56560;
count__56031 = G__56561;
i__56032 = G__56562;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__56029);
if(temp__5720__auto__){
var seq__56029__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56029__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__56029__$1);
var G__56563 = cljs.core.chunk_rest.call(null,seq__56029__$1);
var G__56564 = c__6568__auto__;
var G__56565 = cljs.core.count.call(null,c__6568__auto__);
var G__56566 = (0);
seq__56029 = G__56563;
chunk__56030 = G__56564;
count__56031 = G__56565;
i__56032 = G__56566;
continue;
} else {
var el = cljs.core.first.call(null,seq__56029__$1);
var handler_56569__$1 = ((function (seq__56029,chunk__56030,count__56031,i__56032,el,seq__56029__$1,temp__5720__auto__){
return (function (e){
return handler.call(null,e,el);
});})(seq__56029,chunk__56030,count__56031,i__56032,el,seq__56029__$1,temp__5720__auto__))
;
shadow.dom.dom_listen.call(null,el,cljs.core.name.call(null,ev),handler_56569__$1);


var G__56571 = cljs.core.next.call(null,seq__56029__$1);
var G__56572 = null;
var G__56573 = (0);
var G__56574 = (0);
seq__56029 = G__56571;
chunk__56030 = G__56572;
count__56031 = G__56573;
i__56032 = G__56574;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__56041 = arguments.length;
switch (G__56041) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.call(null,el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_.call(null,ev)){
return shadow.dom.on_query.call(null,el,cljs.core.first.call(null,ev),cljs.core.second.call(null,ev),handler);
} else {
var handler__$1 = (function (e){
return handler.call(null,e,el);
});
return shadow.dom.dom_listen.call(null,shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove.call(null,shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__56046 = cljs.core.seq.call(null,events);
var chunk__56047 = null;
var count__56048 = (0);
var i__56049 = (0);
while(true){
if((i__56049 < count__56048)){
var vec__56059 = cljs.core._nth.call(null,chunk__56047,i__56049);
var k = cljs.core.nth.call(null,vec__56059,(0),null);
var v = cljs.core.nth.call(null,vec__56059,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__56579 = seq__56046;
var G__56580 = chunk__56047;
var G__56581 = count__56048;
var G__56582 = (i__56049 + (1));
seq__56046 = G__56579;
chunk__56047 = G__56580;
count__56048 = G__56581;
i__56049 = G__56582;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__56046);
if(temp__5720__auto__){
var seq__56046__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56046__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__56046__$1);
var G__56584 = cljs.core.chunk_rest.call(null,seq__56046__$1);
var G__56585 = c__6568__auto__;
var G__56586 = cljs.core.count.call(null,c__6568__auto__);
var G__56587 = (0);
seq__56046 = G__56584;
chunk__56047 = G__56585;
count__56048 = G__56586;
i__56049 = G__56587;
continue;
} else {
var vec__56064 = cljs.core.first.call(null,seq__56046__$1);
var k = cljs.core.nth.call(null,vec__56064,(0),null);
var v = cljs.core.nth.call(null,vec__56064,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__56592 = cljs.core.next.call(null,seq__56046__$1);
var G__56593 = null;
var G__56594 = (0);
var G__56595 = (0);
seq__56046 = G__56592;
chunk__56047 = G__56593;
count__56048 = G__56594;
i__56049 = G__56595;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node.call(null,el);
var seq__56069 = cljs.core.seq.call(null,styles);
var chunk__56070 = null;
var count__56071 = (0);
var i__56072 = (0);
while(true){
if((i__56072 < count__56071)){
var vec__56083 = cljs.core._nth.call(null,chunk__56070,i__56072);
var k = cljs.core.nth.call(null,vec__56083,(0),null);
var v = cljs.core.nth.call(null,vec__56083,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__56599 = seq__56069;
var G__56600 = chunk__56070;
var G__56601 = count__56071;
var G__56602 = (i__56072 + (1));
seq__56069 = G__56599;
chunk__56070 = G__56600;
count__56071 = G__56601;
i__56072 = G__56602;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__56069);
if(temp__5720__auto__){
var seq__56069__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56069__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__56069__$1);
var G__56605 = cljs.core.chunk_rest.call(null,seq__56069__$1);
var G__56606 = c__6568__auto__;
var G__56607 = cljs.core.count.call(null,c__6568__auto__);
var G__56608 = (0);
seq__56069 = G__56605;
chunk__56070 = G__56606;
count__56071 = G__56607;
i__56072 = G__56608;
continue;
} else {
var vec__56086 = cljs.core.first.call(null,seq__56069__$1);
var k = cljs.core.nth.call(null,vec__56086,(0),null);
var v = cljs.core.nth.call(null,vec__56086,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__56610 = cljs.core.next.call(null,seq__56069__$1);
var G__56611 = null;
var G__56612 = (0);
var G__56613 = (0);
seq__56069 = G__56610;
chunk__56070 = G__56611;
count__56071 = G__56612;
i__56072 = G__56613;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__56091_56615 = key;
var G__56091_56616__$1 = (((G__56091_56615 instanceof cljs.core.Keyword))?G__56091_56615.fqn:null);
switch (G__56091_56616__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners.call(null,el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_.call(null,value)){
shadow.dom.set_style.call(null,el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_56622 = cljs.core.name.call(null,key);
if(cljs.core.truth_((function (){var or__5598__auto__ = goog.string.startsWith(ks_56622,"data-");
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return goog.string.startsWith(ks_56622,"aria-");
}
})())){
el.setAttribute(ks_56622,value);
} else {
(el[ks_56622] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv.call(null,(function (el__$1,key,value){
shadow.dom.set_attr_STAR_.call(null,el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node.call(null,el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_.call(null,shadow.dom.dom_node.call(null,el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq.call(null,current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name.call(null,spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.call(null,(-1),fdot)) && (cljs.core._EQ_.call(null,(-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__56103){
var map__56104 = p__56103;
var map__56104__$1 = (((((!((map__56104 == null))))?(((((map__56104.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56104.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56104):map__56104);
var props = map__56104__$1;
var class$ = cljs.core.get.call(null,map__56104__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__56109 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__56109,(0),null);
var tag_id = cljs.core.nth.call(null,vec__56109,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__56109,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string.call(null,class$,tag_classes));
} else {
}

var G__56114 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs.call(null,G__56114,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__56114;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__56118 = arguments.length;
switch (G__56118) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node.call(null,el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__56124){
var vec__56126 = p__56124;
var seq__56127 = cljs.core.seq.call(null,vec__56126);
var first__56128 = cljs.core.first.call(null,seq__56127);
var seq__56127__$1 = cljs.core.next.call(null,seq__56127);
var nn = first__56128;
var first__56128__$1 = cljs.core.first.call(null,seq__56127__$1);
var seq__56127__$2 = cljs.core.next.call(null,seq__56127__$1);
var np = first__56128__$1;
var nc = seq__56127__$2;
var node = vec__56126;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_.call(null,np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,np),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.conj.call(null,nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__56130 = shadow.dom.destructure_node.call(null,shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.call(null,vec__56130,(0),null);
var node_children = cljs.core.nth.call(null,vec__56130,(1),null);
var seq__56133_56638 = cljs.core.seq.call(null,node_children);
var chunk__56134_56639 = null;
var count__56135_56640 = (0);
var i__56136_56641 = (0);
while(true){
if((i__56136_56641 < count__56135_56640)){
var child_struct_56642 = cljs.core._nth.call(null,chunk__56134_56639,i__56136_56641);
var children_56643 = shadow.dom.dom_node.call(null,child_struct_56642);
if(cljs.core.seq_QMARK_.call(null,children_56643)){
var seq__56161_56644 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_56643));
var chunk__56163_56645 = null;
var count__56164_56646 = (0);
var i__56165_56647 = (0);
while(true){
if((i__56165_56647 < count__56164_56646)){
var child_56648 = cljs.core._nth.call(null,chunk__56163_56645,i__56165_56647);
if(cljs.core.truth_(child_56648)){
shadow.dom.append.call(null,node,child_56648);


var G__56653 = seq__56161_56644;
var G__56654 = chunk__56163_56645;
var G__56655 = count__56164_56646;
var G__56656 = (i__56165_56647 + (1));
seq__56161_56644 = G__56653;
chunk__56163_56645 = G__56654;
count__56164_56646 = G__56655;
i__56165_56647 = G__56656;
continue;
} else {
var G__56657 = seq__56161_56644;
var G__56658 = chunk__56163_56645;
var G__56659 = count__56164_56646;
var G__56660 = (i__56165_56647 + (1));
seq__56161_56644 = G__56657;
chunk__56163_56645 = G__56658;
count__56164_56646 = G__56659;
i__56165_56647 = G__56660;
continue;
}
} else {
var temp__5720__auto___56661 = cljs.core.seq.call(null,seq__56161_56644);
if(temp__5720__auto___56661){
var seq__56161_56662__$1 = temp__5720__auto___56661;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56161_56662__$1)){
var c__6568__auto___56663 = cljs.core.chunk_first.call(null,seq__56161_56662__$1);
var G__56664 = cljs.core.chunk_rest.call(null,seq__56161_56662__$1);
var G__56665 = c__6568__auto___56663;
var G__56666 = cljs.core.count.call(null,c__6568__auto___56663);
var G__56667 = (0);
seq__56161_56644 = G__56664;
chunk__56163_56645 = G__56665;
count__56164_56646 = G__56666;
i__56165_56647 = G__56667;
continue;
} else {
var child_56668 = cljs.core.first.call(null,seq__56161_56662__$1);
if(cljs.core.truth_(child_56668)){
shadow.dom.append.call(null,node,child_56668);


var G__56669 = cljs.core.next.call(null,seq__56161_56662__$1);
var G__56670 = null;
var G__56671 = (0);
var G__56672 = (0);
seq__56161_56644 = G__56669;
chunk__56163_56645 = G__56670;
count__56164_56646 = G__56671;
i__56165_56647 = G__56672;
continue;
} else {
var G__56673 = cljs.core.next.call(null,seq__56161_56662__$1);
var G__56674 = null;
var G__56675 = (0);
var G__56676 = (0);
seq__56161_56644 = G__56673;
chunk__56163_56645 = G__56674;
count__56164_56646 = G__56675;
i__56165_56647 = G__56676;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_56643);
}


var G__56677 = seq__56133_56638;
var G__56678 = chunk__56134_56639;
var G__56679 = count__56135_56640;
var G__56680 = (i__56136_56641 + (1));
seq__56133_56638 = G__56677;
chunk__56134_56639 = G__56678;
count__56135_56640 = G__56679;
i__56136_56641 = G__56680;
continue;
} else {
var temp__5720__auto___56681 = cljs.core.seq.call(null,seq__56133_56638);
if(temp__5720__auto___56681){
var seq__56133_56682__$1 = temp__5720__auto___56681;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56133_56682__$1)){
var c__6568__auto___56683 = cljs.core.chunk_first.call(null,seq__56133_56682__$1);
var G__56684 = cljs.core.chunk_rest.call(null,seq__56133_56682__$1);
var G__56685 = c__6568__auto___56683;
var G__56686 = cljs.core.count.call(null,c__6568__auto___56683);
var G__56687 = (0);
seq__56133_56638 = G__56684;
chunk__56134_56639 = G__56685;
count__56135_56640 = G__56686;
i__56136_56641 = G__56687;
continue;
} else {
var child_struct_56688 = cljs.core.first.call(null,seq__56133_56682__$1);
var children_56689 = shadow.dom.dom_node.call(null,child_struct_56688);
if(cljs.core.seq_QMARK_.call(null,children_56689)){
var seq__56174_56690 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_56689));
var chunk__56176_56691 = null;
var count__56177_56692 = (0);
var i__56178_56693 = (0);
while(true){
if((i__56178_56693 < count__56177_56692)){
var child_56694 = cljs.core._nth.call(null,chunk__56176_56691,i__56178_56693);
if(cljs.core.truth_(child_56694)){
shadow.dom.append.call(null,node,child_56694);


var G__56695 = seq__56174_56690;
var G__56696 = chunk__56176_56691;
var G__56697 = count__56177_56692;
var G__56698 = (i__56178_56693 + (1));
seq__56174_56690 = G__56695;
chunk__56176_56691 = G__56696;
count__56177_56692 = G__56697;
i__56178_56693 = G__56698;
continue;
} else {
var G__56699 = seq__56174_56690;
var G__56700 = chunk__56176_56691;
var G__56701 = count__56177_56692;
var G__56702 = (i__56178_56693 + (1));
seq__56174_56690 = G__56699;
chunk__56176_56691 = G__56700;
count__56177_56692 = G__56701;
i__56178_56693 = G__56702;
continue;
}
} else {
var temp__5720__auto___56707__$1 = cljs.core.seq.call(null,seq__56174_56690);
if(temp__5720__auto___56707__$1){
var seq__56174_56708__$1 = temp__5720__auto___56707__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56174_56708__$1)){
var c__6568__auto___56709 = cljs.core.chunk_first.call(null,seq__56174_56708__$1);
var G__56710 = cljs.core.chunk_rest.call(null,seq__56174_56708__$1);
var G__56711 = c__6568__auto___56709;
var G__56712 = cljs.core.count.call(null,c__6568__auto___56709);
var G__56713 = (0);
seq__56174_56690 = G__56710;
chunk__56176_56691 = G__56711;
count__56177_56692 = G__56712;
i__56178_56693 = G__56713;
continue;
} else {
var child_56715 = cljs.core.first.call(null,seq__56174_56708__$1);
if(cljs.core.truth_(child_56715)){
shadow.dom.append.call(null,node,child_56715);


var G__56716 = cljs.core.next.call(null,seq__56174_56708__$1);
var G__56717 = null;
var G__56718 = (0);
var G__56719 = (0);
seq__56174_56690 = G__56716;
chunk__56176_56691 = G__56717;
count__56177_56692 = G__56718;
i__56178_56693 = G__56719;
continue;
} else {
var G__56720 = cljs.core.next.call(null,seq__56174_56708__$1);
var G__56721 = null;
var G__56722 = (0);
var G__56723 = (0);
seq__56174_56690 = G__56720;
chunk__56176_56691 = G__56721;
count__56177_56692 = G__56722;
i__56178_56693 = G__56723;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_56689);
}


var G__56724 = cljs.core.next.call(null,seq__56133_56682__$1);
var G__56725 = null;
var G__56726 = (0);
var G__56727 = (0);
seq__56133_56638 = G__56724;
chunk__56134_56639 = G__56725;
count__56135_56640 = G__56726;
i__56136_56641 = G__56727;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node.call(null,node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__56193 = cljs.core.seq.call(null,node);
var chunk__56194 = null;
var count__56195 = (0);
var i__56196 = (0);
while(true){
if((i__56196 < count__56195)){
var n = cljs.core._nth.call(null,chunk__56194,i__56196);
shadow.dom.remove.call(null,n);


var G__56733 = seq__56193;
var G__56734 = chunk__56194;
var G__56735 = count__56195;
var G__56736 = (i__56196 + (1));
seq__56193 = G__56733;
chunk__56194 = G__56734;
count__56195 = G__56735;
i__56196 = G__56736;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__56193);
if(temp__5720__auto__){
var seq__56193__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56193__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__56193__$1);
var G__56741 = cljs.core.chunk_rest.call(null,seq__56193__$1);
var G__56742 = c__6568__auto__;
var G__56743 = cljs.core.count.call(null,c__6568__auto__);
var G__56744 = (0);
seq__56193 = G__56741;
chunk__56194 = G__56742;
count__56195 = G__56743;
i__56196 = G__56744;
continue;
} else {
var n = cljs.core.first.call(null,seq__56193__$1);
shadow.dom.remove.call(null,n);


var G__56746 = cljs.core.next.call(null,seq__56193__$1);
var G__56747 = null;
var G__56748 = (0);
var G__56749 = (0);
seq__56193 = G__56746;
chunk__56194 = G__56747;
count__56195 = G__56748;
i__56196 = G__56749;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node.call(null,new$),shadow.dom.dom_node.call(null,old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__56201 = arguments.length;
switch (G__56201) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node.call(null,el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node.call(null,el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__56206 = arguments.length;
switch (G__56206) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.call(null,el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node.call(null,el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node.call(null,el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__56219 = arguments.length;
switch (G__56219) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5598__auto__ = shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node.call(null,el).removeAttribute(cljs.core.name.call(null,key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(["data-",cljs.core.name.call(null,key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node.call(null,el).setAttribute(["data-",cljs.core.name.call(null,key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node.call(null,node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node.call(null,node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__6930__auto__ = [];
var len__6920__auto___56765 = arguments.length;
var i__6921__auto___56766 = (0);
while(true){
if((i__6921__auto___56766 < len__6920__auto___56765)){
args__6930__auto__.push((arguments[i__6921__auto___56766]));

var G__56767 = (i__6921__auto___56766 + (1));
i__6921__auto___56766 = G__56767;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((0) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__6931__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__56227_56768 = cljs.core.seq.call(null,nodes);
var chunk__56228_56769 = null;
var count__56229_56770 = (0);
var i__56230_56771 = (0);
while(true){
if((i__56230_56771 < count__56229_56770)){
var node_56772 = cljs.core._nth.call(null,chunk__56228_56769,i__56230_56771);
fragment.appendChild(shadow.dom._to_dom.call(null,node_56772));


var G__56773 = seq__56227_56768;
var G__56774 = chunk__56228_56769;
var G__56775 = count__56229_56770;
var G__56776 = (i__56230_56771 + (1));
seq__56227_56768 = G__56773;
chunk__56228_56769 = G__56774;
count__56229_56770 = G__56775;
i__56230_56771 = G__56776;
continue;
} else {
var temp__5720__auto___56777 = cljs.core.seq.call(null,seq__56227_56768);
if(temp__5720__auto___56777){
var seq__56227_56778__$1 = temp__5720__auto___56777;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56227_56778__$1)){
var c__6568__auto___56779 = cljs.core.chunk_first.call(null,seq__56227_56778__$1);
var G__56781 = cljs.core.chunk_rest.call(null,seq__56227_56778__$1);
var G__56782 = c__6568__auto___56779;
var G__56783 = cljs.core.count.call(null,c__6568__auto___56779);
var G__56784 = (0);
seq__56227_56768 = G__56781;
chunk__56228_56769 = G__56782;
count__56229_56770 = G__56783;
i__56230_56771 = G__56784;
continue;
} else {
var node_56786 = cljs.core.first.call(null,seq__56227_56778__$1);
fragment.appendChild(shadow.dom._to_dom.call(null,node_56786));


var G__56788 = cljs.core.next.call(null,seq__56227_56778__$1);
var G__56789 = null;
var G__56790 = (0);
var G__56791 = (0);
seq__56227_56768 = G__56788;
chunk__56228_56769 = G__56789;
count__56229_56770 = G__56790;
i__56230_56771 = G__56791;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq56226){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq56226));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq.call(null,/<script[^>]*?>(.+?)<\/script>/,s);
var seq__56235_56792 = cljs.core.seq.call(null,scripts);
var chunk__56236_56793 = null;
var count__56237_56794 = (0);
var i__56238_56795 = (0);
while(true){
if((i__56238_56795 < count__56237_56794)){
var vec__56249_56796 = cljs.core._nth.call(null,chunk__56236_56793,i__56238_56795);
var script_tag_56797 = cljs.core.nth.call(null,vec__56249_56796,(0),null);
var script_body_56798 = cljs.core.nth.call(null,vec__56249_56796,(1),null);
eval(script_body_56798);


var G__56803 = seq__56235_56792;
var G__56804 = chunk__56236_56793;
var G__56805 = count__56237_56794;
var G__56806 = (i__56238_56795 + (1));
seq__56235_56792 = G__56803;
chunk__56236_56793 = G__56804;
count__56237_56794 = G__56805;
i__56238_56795 = G__56806;
continue;
} else {
var temp__5720__auto___56807 = cljs.core.seq.call(null,seq__56235_56792);
if(temp__5720__auto___56807){
var seq__56235_56811__$1 = temp__5720__auto___56807;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56235_56811__$1)){
var c__6568__auto___56812 = cljs.core.chunk_first.call(null,seq__56235_56811__$1);
var G__56813 = cljs.core.chunk_rest.call(null,seq__56235_56811__$1);
var G__56814 = c__6568__auto___56812;
var G__56815 = cljs.core.count.call(null,c__6568__auto___56812);
var G__56816 = (0);
seq__56235_56792 = G__56813;
chunk__56236_56793 = G__56814;
count__56237_56794 = G__56815;
i__56238_56795 = G__56816;
continue;
} else {
var vec__56255_56818 = cljs.core.first.call(null,seq__56235_56811__$1);
var script_tag_56819 = cljs.core.nth.call(null,vec__56255_56818,(0),null);
var script_body_56820 = cljs.core.nth.call(null,vec__56255_56818,(1),null);
eval(script_body_56820);


var G__56821 = cljs.core.next.call(null,seq__56235_56811__$1);
var G__56822 = null;
var G__56823 = (0);
var G__56824 = (0);
seq__56235_56792 = G__56821;
chunk__56236_56793 = G__56822;
count__56237_56794 = G__56823;
i__56238_56795 = G__56824;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.call(null,(function (s__$1,p__56258){
var vec__56259 = p__56258;
var script_tag = cljs.core.nth.call(null,vec__56259,(0),null);
var script_body = cljs.core.nth.call(null,vec__56259,(1),null);
return clojure.string.replace.call(null,s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node.call(null,el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__56268 = arguments.length;
switch (G__56268) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag),cljs.core.name.call(null,cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node.call(null,dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node.call(null,dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name.call(null,style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node.call(null,el);
return shadow.dom.remove_style_STAR_.call(null,el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node.call(null,el);
var seq__56279 = cljs.core.seq.call(null,style_keys);
var chunk__56280 = null;
var count__56281 = (0);
var i__56282 = (0);
while(true){
if((i__56282 < count__56281)){
var it = cljs.core._nth.call(null,chunk__56280,i__56282);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__56848 = seq__56279;
var G__56849 = chunk__56280;
var G__56850 = count__56281;
var G__56851 = (i__56282 + (1));
seq__56279 = G__56848;
chunk__56280 = G__56849;
count__56281 = G__56850;
i__56282 = G__56851;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__56279);
if(temp__5720__auto__){
var seq__56279__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56279__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__56279__$1);
var G__56852 = cljs.core.chunk_rest.call(null,seq__56279__$1);
var G__56853 = c__6568__auto__;
var G__56854 = cljs.core.count.call(null,c__6568__auto__);
var G__56855 = (0);
seq__56279 = G__56852;
chunk__56280 = G__56853;
count__56281 = G__56854;
i__56282 = G__56855;
continue;
} else {
var it = cljs.core.first.call(null,seq__56279__$1);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__56857 = cljs.core.next.call(null,seq__56279__$1);
var G__56858 = null;
var G__56859 = (0);
var G__56860 = (0);
seq__56279 = G__56857;
chunk__56280 = G__56858;
count__56281 = G__56859;
i__56282 = G__56860;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6292__auto__,k__6293__auto__){
var self__ = this;
var this__6292__auto____$1 = this;
return this__6292__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__6293__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6294__auto__,k56291,else__6295__auto__){
var self__ = this;
var this__6294__auto____$1 = this;
var G__56298 = k56291;
var G__56298__$1 = (((G__56298 instanceof cljs.core.Keyword))?G__56298.fqn:null);
switch (G__56298__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k56291,else__6295__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__6311__auto__,f__6312__auto__,init__6313__auto__){
var self__ = this;
var this__6311__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__6314__auto__,p__56302){
var vec__56304 = p__56302;
var k__6315__auto__ = cljs.core.nth.call(null,vec__56304,(0),null);
var v__6316__auto__ = cljs.core.nth.call(null,vec__56304,(1),null);
return f__6312__auto__.call(null,ret__6314__auto__,k__6315__auto__,v__6316__auto__);
}),init__6313__auto__,this__6311__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6306__auto__,writer__6307__auto__,opts__6308__auto__){
var self__ = this;
var this__6306__auto____$1 = this;
var pr_pair__6309__auto__ = (function (keyval__6310__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6307__auto__,cljs.core.pr_writer,""," ","",opts__6308__auto__,keyval__6310__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__6307__auto__,pr_pair__6309__auto__,"#shadow.dom.Coordinate{",", ","}",opts__6308__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__56290){
var self__ = this;
var G__56290__$1 = this;
return (new cljs.core.RecordIter((0),G__56290__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6290__auto__){
var self__ = this;
var this__6290__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6287__auto__){
var self__ = this;
var this__6287__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6296__auto__){
var self__ = this;
var this__6296__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6288__auto__){
var self__ = this;
var this__6288__auto____$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = (function (coll__6289__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll.call(null,coll__6289__auto__));
}).call(null,this__6288__auto____$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this56292,other56293){
var self__ = this;
var this56292__$1 = this;
return (((!((other56293 == null)))) && ((this56292__$1.constructor === other56293.constructor)) && (cljs.core._EQ_.call(null,this56292__$1.x,other56293.x)) && (cljs.core._EQ_.call(null,this56292__$1.y,other56293.y)) && (cljs.core._EQ_.call(null,this56292__$1.__extmap,other56293.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6301__auto__,k__6302__auto__){
var self__ = this;
var this__6301__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__6302__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6301__auto____$1),self__.__meta),k__6302__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6302__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6299__auto__,k__6300__auto__,G__56290){
var self__ = this;
var this__6299__auto____$1 = this;
var pred__56324 = cljs.core.keyword_identical_QMARK_;
var expr__56325 = k__6300__auto__;
if(cljs.core.truth_(pred__56324.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__56325))){
return (new shadow.dom.Coordinate(G__56290,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__56324.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__56325))){
return (new shadow.dom.Coordinate(self__.x,G__56290,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6300__auto__,G__56290),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6304__auto__){
var self__ = this;
var this__6304__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6291__auto__,G__56290){
var self__ = this;
var this__6291__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__56290,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6297__auto__,entry__6298__auto__){
var self__ = this;
var this__6297__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6298__auto__)){
return this__6297__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__6298__auto__,(0)),cljs.core._nth.call(null,entry__6298__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6297__auto____$1,entry__6298__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__6337__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__6337__auto__,writer__6338__auto__){
return cljs.core._write.call(null,writer__6338__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__56295){
var extmap__6333__auto__ = (function (){var G__56331 = cljs.core.dissoc.call(null,G__56295,new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776));
if(cljs.core.record_QMARK_.call(null,G__56295)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__56331);
} else {
return G__56331;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__56295),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__56295),null,cljs.core.not_empty.call(null,extmap__6333__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6292__auto__,k__6293__auto__){
var self__ = this;
var this__6292__auto____$1 = this;
return this__6292__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__6293__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6294__auto__,k56338,else__6295__auto__){
var self__ = this;
var this__6294__auto____$1 = this;
var G__56345 = k56338;
var G__56345__$1 = (((G__56345 instanceof cljs.core.Keyword))?G__56345.fqn:null);
switch (G__56345__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k56338,else__6295__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__6311__auto__,f__6312__auto__,init__6313__auto__){
var self__ = this;
var this__6311__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__6314__auto__,p__56346){
var vec__56347 = p__56346;
var k__6315__auto__ = cljs.core.nth.call(null,vec__56347,(0),null);
var v__6316__auto__ = cljs.core.nth.call(null,vec__56347,(1),null);
return f__6312__auto__.call(null,ret__6314__auto__,k__6315__auto__,v__6316__auto__);
}),init__6313__auto__,this__6311__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6306__auto__,writer__6307__auto__,opts__6308__auto__){
var self__ = this;
var this__6306__auto____$1 = this;
var pr_pair__6309__auto__ = (function (keyval__6310__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6307__auto__,cljs.core.pr_writer,""," ","",opts__6308__auto__,keyval__6310__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__6307__auto__,pr_pair__6309__auto__,"#shadow.dom.Size{",", ","}",opts__6308__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__56337){
var self__ = this;
var G__56337__$1 = this;
return (new cljs.core.RecordIter((0),G__56337__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6290__auto__){
var self__ = this;
var this__6290__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6287__auto__){
var self__ = this;
var this__6287__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6296__auto__){
var self__ = this;
var this__6296__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6288__auto__){
var self__ = this;
var this__6288__auto____$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = (function (coll__6289__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll.call(null,coll__6289__auto__));
}).call(null,this__6288__auto____$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this56339,other56340){
var self__ = this;
var this56339__$1 = this;
return (((!((other56340 == null)))) && ((this56339__$1.constructor === other56340.constructor)) && (cljs.core._EQ_.call(null,this56339__$1.w,other56340.w)) && (cljs.core._EQ_.call(null,this56339__$1.h,other56340.h)) && (cljs.core._EQ_.call(null,this56339__$1.__extmap,other56340.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6301__auto__,k__6302__auto__){
var self__ = this;
var this__6301__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__6302__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6301__auto____$1),self__.__meta),k__6302__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6302__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6299__auto__,k__6300__auto__,G__56337){
var self__ = this;
var this__6299__auto____$1 = this;
var pred__56351 = cljs.core.keyword_identical_QMARK_;
var expr__56352 = k__6300__auto__;
if(cljs.core.truth_(pred__56351.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__56352))){
return (new shadow.dom.Size(G__56337,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__56351.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__56352))){
return (new shadow.dom.Size(self__.w,G__56337,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6300__auto__,G__56337),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6304__auto__){
var self__ = this;
var this__6304__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6291__auto__,G__56337){
var self__ = this;
var this__6291__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__56337,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6297__auto__,entry__6298__auto__){
var self__ = this;
var this__6297__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6298__auto__)){
return this__6297__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__6298__auto__,(0)),cljs.core._nth.call(null,entry__6298__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6297__auto____$1,entry__6298__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__6337__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__6337__auto__,writer__6338__auto__){
return cljs.core._write.call(null,writer__6338__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__56343){
var extmap__6333__auto__ = (function (){var G__56366 = cljs.core.dissoc.call(null,G__56343,new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740));
if(cljs.core.record_QMARK_.call(null,G__56343)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__56366);
} else {
return G__56366;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__56343),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__56343),null,cljs.core.not_empty.call(null,extmap__6333__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj.call(null,goog.style.getSize(shadow.dom.dom_node.call(null,el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size.call(null,el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj.call(null,goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node.call(null,el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node.call(null,el);
var opts = (native$["options"]);
var a__6672__auto__ = opts;
var l__6673__auto__ = a__6672__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__6673__auto__)){
var G__56918 = (i + (1));
var G__56919 = cljs.core.conj.call(null,ret,(opts[i]["value"]));
i = G__56918;
ret = G__56919;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_.call(null,query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p__56385){
var vec__56386 = p__56385;
var k = cljs.core.nth.call(null,vec__56386,(0),null);
var v = cljs.core.nth.call(null,vec__56386,(1),null);
return [cljs.core.name.call(null,k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__56396 = arguments.length;
switch (G__56396) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.call(null,path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url.call(null,path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node.call(null,el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node.call(null,ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before.call(null,child,new$);
} else {
return shadow.dom.append.call(null,ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node.call(null,el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__56927 = ps;
var G__56928 = (i + (1));
el__$1 = G__56927;
i = G__56928;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node.call(null,el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent.call(null,el);
if(cljs.core.truth_(parent)){
return cljs.core.cons.call(null,parent,(new cljs.core.LazySeq(null,(function (){
return shadow.dom.parents.call(null,parent);
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node.call(null,el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.xmlns = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__56413 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__56413,(0),null);
var tag_id = cljs.core.nth.call(null,vec__56413,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__56413,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string.call(null,new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__56417_56934 = cljs.core.seq.call(null,props);
var chunk__56418_56935 = null;
var count__56419_56936 = (0);
var i__56420_56937 = (0);
while(true){
if((i__56420_56937 < count__56419_56936)){
var vec__56428_56939 = cljs.core._nth.call(null,chunk__56418_56935,i__56420_56937);
var k_56940 = cljs.core.nth.call(null,vec__56428_56939,(0),null);
var v_56941 = cljs.core.nth.call(null,vec__56428_56939,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace.call(null,k_56940);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_56940),v_56941);


var G__56945 = seq__56417_56934;
var G__56946 = chunk__56418_56935;
var G__56947 = count__56419_56936;
var G__56948 = (i__56420_56937 + (1));
seq__56417_56934 = G__56945;
chunk__56418_56935 = G__56946;
count__56419_56936 = G__56947;
i__56420_56937 = G__56948;
continue;
} else {
var temp__5720__auto___56950 = cljs.core.seq.call(null,seq__56417_56934);
if(temp__5720__auto___56950){
var seq__56417_56951__$1 = temp__5720__auto___56950;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56417_56951__$1)){
var c__6568__auto___56952 = cljs.core.chunk_first.call(null,seq__56417_56951__$1);
var G__56953 = cljs.core.chunk_rest.call(null,seq__56417_56951__$1);
var G__56954 = c__6568__auto___56952;
var G__56955 = cljs.core.count.call(null,c__6568__auto___56952);
var G__56956 = (0);
seq__56417_56934 = G__56953;
chunk__56418_56935 = G__56954;
count__56419_56936 = G__56955;
i__56420_56937 = G__56956;
continue;
} else {
var vec__56433_56957 = cljs.core.first.call(null,seq__56417_56951__$1);
var k_56958 = cljs.core.nth.call(null,vec__56433_56957,(0),null);
var v_56959 = cljs.core.nth.call(null,vec__56433_56957,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace.call(null,k_56958);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_56958),v_56959);


var G__56963 = cljs.core.next.call(null,seq__56417_56951__$1);
var G__56964 = null;
var G__56965 = (0);
var G__56966 = (0);
seq__56417_56934 = G__56963;
chunk__56418_56935 = G__56964;
count__56419_56936 = G__56965;
i__56420_56937 = G__56966;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return shadow.dom._to_svg.call(null,el);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__56438 = shadow.dom.destructure_node.call(null,shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.call(null,vec__56438,(0),null);
var node_children = cljs.core.nth.call(null,vec__56438,(1),null);
var seq__56442_56970 = cljs.core.seq.call(null,node_children);
var chunk__56444_56971 = null;
var count__56445_56972 = (0);
var i__56446_56973 = (0);
while(true){
if((i__56446_56973 < count__56445_56972)){
var child_struct_56974 = cljs.core._nth.call(null,chunk__56444_56971,i__56446_56973);
if((!((child_struct_56974 == null)))){
if(typeof child_struct_56974 === 'string'){
var text_56975 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_56975),child_struct_56974].join(''));
} else {
var children_56976 = shadow.dom.svg_node.call(null,child_struct_56974);
if(cljs.core.seq_QMARK_.call(null,children_56976)){
var seq__56467_56977 = cljs.core.seq.call(null,children_56976);
var chunk__56469_56978 = null;
var count__56470_56979 = (0);
var i__56471_56980 = (0);
while(true){
if((i__56471_56980 < count__56470_56979)){
var child_56983 = cljs.core._nth.call(null,chunk__56469_56978,i__56471_56980);
if(cljs.core.truth_(child_56983)){
node.appendChild(child_56983);


var G__56985 = seq__56467_56977;
var G__56986 = chunk__56469_56978;
var G__56987 = count__56470_56979;
var G__56988 = (i__56471_56980 + (1));
seq__56467_56977 = G__56985;
chunk__56469_56978 = G__56986;
count__56470_56979 = G__56987;
i__56471_56980 = G__56988;
continue;
} else {
var G__56989 = seq__56467_56977;
var G__56990 = chunk__56469_56978;
var G__56991 = count__56470_56979;
var G__56992 = (i__56471_56980 + (1));
seq__56467_56977 = G__56989;
chunk__56469_56978 = G__56990;
count__56470_56979 = G__56991;
i__56471_56980 = G__56992;
continue;
}
} else {
var temp__5720__auto___56993 = cljs.core.seq.call(null,seq__56467_56977);
if(temp__5720__auto___56993){
var seq__56467_56994__$1 = temp__5720__auto___56993;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56467_56994__$1)){
var c__6568__auto___56995 = cljs.core.chunk_first.call(null,seq__56467_56994__$1);
var G__56996 = cljs.core.chunk_rest.call(null,seq__56467_56994__$1);
var G__56997 = c__6568__auto___56995;
var G__56998 = cljs.core.count.call(null,c__6568__auto___56995);
var G__56999 = (0);
seq__56467_56977 = G__56996;
chunk__56469_56978 = G__56997;
count__56470_56979 = G__56998;
i__56471_56980 = G__56999;
continue;
} else {
var child_57001 = cljs.core.first.call(null,seq__56467_56994__$1);
if(cljs.core.truth_(child_57001)){
node.appendChild(child_57001);


var G__57002 = cljs.core.next.call(null,seq__56467_56994__$1);
var G__57003 = null;
var G__57004 = (0);
var G__57005 = (0);
seq__56467_56977 = G__57002;
chunk__56469_56978 = G__57003;
count__56470_56979 = G__57004;
i__56471_56980 = G__57005;
continue;
} else {
var G__57010 = cljs.core.next.call(null,seq__56467_56994__$1);
var G__57011 = null;
var G__57012 = (0);
var G__57013 = (0);
seq__56467_56977 = G__57010;
chunk__56469_56978 = G__57011;
count__56470_56979 = G__57012;
i__56471_56980 = G__57013;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_56976);
}
}


var G__57014 = seq__56442_56970;
var G__57015 = chunk__56444_56971;
var G__57016 = count__56445_56972;
var G__57017 = (i__56446_56973 + (1));
seq__56442_56970 = G__57014;
chunk__56444_56971 = G__57015;
count__56445_56972 = G__57016;
i__56446_56973 = G__57017;
continue;
} else {
var G__57018 = seq__56442_56970;
var G__57019 = chunk__56444_56971;
var G__57020 = count__56445_56972;
var G__57021 = (i__56446_56973 + (1));
seq__56442_56970 = G__57018;
chunk__56444_56971 = G__57019;
count__56445_56972 = G__57020;
i__56446_56973 = G__57021;
continue;
}
} else {
var temp__5720__auto___57022 = cljs.core.seq.call(null,seq__56442_56970);
if(temp__5720__auto___57022){
var seq__56442_57024__$1 = temp__5720__auto___57022;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56442_57024__$1)){
var c__6568__auto___57025 = cljs.core.chunk_first.call(null,seq__56442_57024__$1);
var G__57026 = cljs.core.chunk_rest.call(null,seq__56442_57024__$1);
var G__57027 = c__6568__auto___57025;
var G__57028 = cljs.core.count.call(null,c__6568__auto___57025);
var G__57029 = (0);
seq__56442_56970 = G__57026;
chunk__56444_56971 = G__57027;
count__56445_56972 = G__57028;
i__56446_56973 = G__57029;
continue;
} else {
var child_struct_57030 = cljs.core.first.call(null,seq__56442_57024__$1);
if((!((child_struct_57030 == null)))){
if(typeof child_struct_57030 === 'string'){
var text_57031 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_57031),child_struct_57030].join(''));
} else {
var children_57032 = shadow.dom.svg_node.call(null,child_struct_57030);
if(cljs.core.seq_QMARK_.call(null,children_57032)){
var seq__56479_57034 = cljs.core.seq.call(null,children_57032);
var chunk__56481_57035 = null;
var count__56482_57036 = (0);
var i__56483_57037 = (0);
while(true){
if((i__56483_57037 < count__56482_57036)){
var child_57038 = cljs.core._nth.call(null,chunk__56481_57035,i__56483_57037);
if(cljs.core.truth_(child_57038)){
node.appendChild(child_57038);


var G__57039 = seq__56479_57034;
var G__57040 = chunk__56481_57035;
var G__57041 = count__56482_57036;
var G__57042 = (i__56483_57037 + (1));
seq__56479_57034 = G__57039;
chunk__56481_57035 = G__57040;
count__56482_57036 = G__57041;
i__56483_57037 = G__57042;
continue;
} else {
var G__57043 = seq__56479_57034;
var G__57044 = chunk__56481_57035;
var G__57045 = count__56482_57036;
var G__57046 = (i__56483_57037 + (1));
seq__56479_57034 = G__57043;
chunk__56481_57035 = G__57044;
count__56482_57036 = G__57045;
i__56483_57037 = G__57046;
continue;
}
} else {
var temp__5720__auto___57047__$1 = cljs.core.seq.call(null,seq__56479_57034);
if(temp__5720__auto___57047__$1){
var seq__56479_57048__$1 = temp__5720__auto___57047__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56479_57048__$1)){
var c__6568__auto___57049 = cljs.core.chunk_first.call(null,seq__56479_57048__$1);
var G__57051 = cljs.core.chunk_rest.call(null,seq__56479_57048__$1);
var G__57052 = c__6568__auto___57049;
var G__57053 = cljs.core.count.call(null,c__6568__auto___57049);
var G__57054 = (0);
seq__56479_57034 = G__57051;
chunk__56481_57035 = G__57052;
count__56482_57036 = G__57053;
i__56483_57037 = G__57054;
continue;
} else {
var child_57056 = cljs.core.first.call(null,seq__56479_57048__$1);
if(cljs.core.truth_(child_57056)){
node.appendChild(child_57056);


var G__57057 = cljs.core.next.call(null,seq__56479_57048__$1);
var G__57058 = null;
var G__57059 = (0);
var G__57060 = (0);
seq__56479_57034 = G__57057;
chunk__56481_57035 = G__57058;
count__56482_57036 = G__57059;
i__56483_57037 = G__57060;
continue;
} else {
var G__57061 = cljs.core.next.call(null,seq__56479_57048__$1);
var G__57062 = null;
var G__57063 = (0);
var G__57064 = (0);
seq__56479_57034 = G__57061;
chunk__56481_57035 = G__57062;
count__56482_57036 = G__57063;
i__56483_57037 = G__57064;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_57032);
}
}


var G__57067 = cljs.core.next.call(null,seq__56442_57024__$1);
var G__57068 = null;
var G__57069 = (0);
var G__57070 = (0);
seq__56442_56970 = G__57067;
chunk__56444_56971 = G__57068;
count__56445_56972 = G__57069;
i__56446_56973 = G__57070;
continue;
} else {
var G__57071 = cljs.core.next.call(null,seq__56442_57024__$1);
var G__57072 = null;
var G__57073 = (0);
var G__57074 = (0);
seq__56442_56970 = G__57071;
chunk__56444_56971 = G__57072;
count__56445_56972 = G__57073;
i__56446_56973 = G__57074;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.call(null,"strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node.call(null,this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__6930__auto__ = [];
var len__6920__auto___57081 = arguments.length;
var i__6921__auto___57082 = (0);
while(true){
if((i__6921__auto___57082 < len__6920__auto___57081)){
args__6930__auto__.push((arguments[i__6921__auto___57082]));

var G__57084 = (i__6921__auto___57082 + (1));
i__6921__auto___57082 = G__57084;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((1) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6931__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg.call(null,cljs.core.vec.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq56497){
var G__56498 = cljs.core.first.call(null,seq56497);
var seq56497__$1 = cljs.core.next.call(null,seq56497);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56498,seq56497__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__56506 = arguments.length;
switch (G__56506) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.call(null,el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.call(null,el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer.call(null,(1));
var chan = cljs.core.async.chan.call(null,buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.call(null,chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler.call(null,el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_.call(null,chan);
} else {
return null;
}
});
shadow.dom.dom_listen.call(null,shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,event),event_fn);

if(cljs.core.truth_((function (){var and__5583__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5583__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5583__auto__;
}
})())){
var c__54378__auto___57098 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_56513){
var state_val_56514 = (state_56513[(1)]);
if((state_val_56514 === (1))){
var state_56513__$1 = state_56513;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56513__$1,(2),once_or_cleanup);
} else {
if((state_val_56514 === (2))){
var inst_56510 = (state_56513[(2)]);
var inst_56511 = shadow.dom.remove_event_handler.call(null,el,event,event_fn);
var state_56513__$1 = (function (){var statearr_56516 = state_56513;
(statearr_56516[(7)] = inst_56510);

return statearr_56516;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56513__$1,inst_56511);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__54295__auto__ = null;
var shadow$dom$state_machine__54295__auto____0 = (function (){
var statearr_56518 = [null,null,null,null,null,null,null,null];
(statearr_56518[(0)] = shadow$dom$state_machine__54295__auto__);

(statearr_56518[(1)] = (1));

return statearr_56518;
});
var shadow$dom$state_machine__54295__auto____1 = (function (state_56513){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_56513);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e56520){if((e56520 instanceof Object)){
var ex__54298__auto__ = e56520;
var statearr_56522_57100 = state_56513;
(statearr_56522_57100[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56513);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56520;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57101 = state_56513;
state_56513 = G__57101;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
shadow$dom$state_machine__54295__auto__ = function(state_56513){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__54295__auto____0.call(this);
case 1:
return shadow$dom$state_machine__54295__auto____1.call(this,state_56513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__54295__auto____0;
shadow$dom$state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__54295__auto____1;
return shadow$dom$state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_56523 = f__54379__auto__.call(null);
(statearr_56523[(6)] = c__54378__auto___57098);

return statearr_56523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
