goog.provide('devtools.formatters.templating');
goog.require('cljs.core');
goog.require('clojure.walk');
goog.require('devtools.util');
goog.require('devtools.protocols');
goog.require('devtools.formatters.helpers');
goog.require('devtools.formatters.state');
goog.require('clojure.string');
devtools.formatters.templating.mark_as_group_BANG_ = (function devtools$formatters$templating$mark_as_group_BANG_(value){
var x47691_47838 = value;
(x47691_47838.devtools$protocols$IGroup$ = cljs.core.PROTOCOL_SENTINEL);


return value;
});
devtools.formatters.templating.group_QMARK_ = (function devtools$formatters$templating$group_QMARK_(value){
if((!((value == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === value.devtools$protocols$IGroup$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,devtools.protocols.IGroup,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,devtools.protocols.IGroup,value);
}
});
devtools.formatters.templating.mark_as_template_BANG_ = (function devtools$formatters$templating$mark_as_template_BANG_(value){
var x47699_47839 = value;
(x47699_47839.devtools$protocols$ITemplate$ = cljs.core.PROTOCOL_SENTINEL);


return value;
});
devtools.formatters.templating.template_QMARK_ = (function devtools$formatters$templating$template_QMARK_(value){
if((!((value == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === value.devtools$protocols$ITemplate$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,devtools.protocols.ITemplate,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,devtools.protocols.ITemplate,value);
}
});
devtools.formatters.templating.mark_as_surrogate_BANG_ = (function devtools$formatters$templating$mark_as_surrogate_BANG_(value){
var x47705_47840 = value;
(x47705_47840.devtools$protocols$ISurrogate$ = cljs.core.PROTOCOL_SENTINEL);


return value;
});
devtools.formatters.templating.surrogate_QMARK_ = (function devtools$formatters$templating$surrogate_QMARK_(value){
if((!((value == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === value.devtools$protocols$ISurrogate$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,devtools.protocols.ISurrogate,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,devtools.protocols.ISurrogate,value);
}
});
devtools.formatters.templating.reference_QMARK_ = (function devtools$formatters$templating$reference_QMARK_(value){
return ((devtools.formatters.templating.group_QMARK_.call(null,value)) && (cljs.core._EQ_.call(null,(value[(0)]),"object")));
});
devtools.formatters.templating.make_group = (function devtools$formatters$templating$make_group(var_args){
var args__6930__auto__ = [];
var len__6920__auto___47841 = arguments.length;
var i__6921__auto___47842 = (0);
while(true){
if((i__6921__auto___47842 < len__6920__auto___47841)){
args__6930__auto__.push((arguments[i__6921__auto___47842]));

var G__47843 = (i__6921__auto___47842 + (1));
i__6921__auto___47842 = G__47843;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((0) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((0)),(0),null)):null);
return devtools.formatters.templating.make_group.cljs$core$IFn$_invoke$arity$variadic(argseq__6931__auto__);
});

(devtools.formatters.templating.make_group.cljs$core$IFn$_invoke$arity$variadic = (function (items){
var group = devtools.formatters.templating.mark_as_group_BANG_.call(null,[]);
var seq__47708_47844 = cljs.core.seq.call(null,items);
var chunk__47709_47845 = null;
var count__47710_47846 = (0);
var i__47711_47847 = (0);
while(true){
if((i__47711_47847 < count__47710_47846)){
var item_47849 = cljs.core._nth.call(null,chunk__47709_47845,i__47711_47847);
if((!((item_47849 == null)))){
if(cljs.core.coll_QMARK_.call(null,item_47849)){
(group["push"]).apply(group,devtools.formatters.templating.mark_as_group_BANG_.call(null,cljs.core.into_array.call(null,item_47849)));
} else {
group.push(devtools.formatters.helpers.pref.call(null,item_47849));
}
} else {
}


var G__47851 = seq__47708_47844;
var G__47852 = chunk__47709_47845;
var G__47853 = count__47710_47846;
var G__47854 = (i__47711_47847 + (1));
seq__47708_47844 = G__47851;
chunk__47709_47845 = G__47852;
count__47710_47846 = G__47853;
i__47711_47847 = G__47854;
continue;
} else {
var temp__5720__auto___47855 = cljs.core.seq.call(null,seq__47708_47844);
if(temp__5720__auto___47855){
var seq__47708_47856__$1 = temp__5720__auto___47855;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47708_47856__$1)){
var c__6568__auto___47858 = cljs.core.chunk_first.call(null,seq__47708_47856__$1);
var G__47859 = cljs.core.chunk_rest.call(null,seq__47708_47856__$1);
var G__47860 = c__6568__auto___47858;
var G__47861 = cljs.core.count.call(null,c__6568__auto___47858);
var G__47862 = (0);
seq__47708_47844 = G__47859;
chunk__47709_47845 = G__47860;
count__47710_47846 = G__47861;
i__47711_47847 = G__47862;
continue;
} else {
var item_47863 = cljs.core.first.call(null,seq__47708_47856__$1);
if((!((item_47863 == null)))){
if(cljs.core.coll_QMARK_.call(null,item_47863)){
(group["push"]).apply(group,devtools.formatters.templating.mark_as_group_BANG_.call(null,cljs.core.into_array.call(null,item_47863)));
} else {
group.push(devtools.formatters.helpers.pref.call(null,item_47863));
}
} else {
}


var G__47864 = cljs.core.next.call(null,seq__47708_47856__$1);
var G__47865 = null;
var G__47866 = (0);
var G__47867 = (0);
seq__47708_47844 = G__47864;
chunk__47709_47845 = G__47865;
count__47710_47846 = G__47866;
i__47711_47847 = G__47867;
continue;
}
} else {
}
}
break;
}

return group;
}));

(devtools.formatters.templating.make_group.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(devtools.formatters.templating.make_group.cljs$lang$applyTo = (function (seq47707){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq47707));
}));

devtools.formatters.templating.make_template = (function devtools$formatters$templating$make_template(var_args){
var args__6930__auto__ = [];
var len__6920__auto___47868 = arguments.length;
var i__6921__auto___47869 = (0);
while(true){
if((i__6921__auto___47869 < len__6920__auto___47868)){
args__6930__auto__.push((arguments[i__6921__auto___47869]));

var G__47870 = (i__6921__auto___47869 + (1));
i__6921__auto___47869 = G__47870;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((2) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((2)),(0),null)):null);
return devtools.formatters.templating.make_template.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6931__auto__);
});

(devtools.formatters.templating.make_template.cljs$core$IFn$_invoke$arity$variadic = (function (tag,style,children){
var tag__$1 = devtools.formatters.helpers.pref.call(null,tag);
var style__$1 = devtools.formatters.helpers.pref.call(null,style);
var template = devtools.formatters.templating.mark_as_template_BANG_.call(null,[tag__$1,((cljs.core.empty_QMARK_.call(null,style__$1))?({}):({"style": style__$1}))]);
var seq__47731_47871 = cljs.core.seq.call(null,children);
var chunk__47732_47872 = null;
var count__47733_47873 = (0);
var i__47734_47874 = (0);
while(true){
if((i__47734_47874 < count__47733_47873)){
var child_47875 = cljs.core._nth.call(null,chunk__47732_47872,i__47734_47874);
if((!((child_47875 == null)))){
if(cljs.core.coll_QMARK_.call(null,child_47875)){
(template["push"]).apply(template,devtools.formatters.templating.mark_as_template_BANG_.call(null,cljs.core.into_array.call(null,cljs.core.keep.call(null,devtools.formatters.helpers.pref,child_47875))));
} else {
var temp__5718__auto___47877 = devtools.formatters.helpers.pref.call(null,child_47875);
if(cljs.core.truth_(temp__5718__auto___47877)){
var child_value_47878 = temp__5718__auto___47877;
template.push(child_value_47878);
} else {
}
}
} else {
}


var G__47879 = seq__47731_47871;
var G__47880 = chunk__47732_47872;
var G__47881 = count__47733_47873;
var G__47882 = (i__47734_47874 + (1));
seq__47731_47871 = G__47879;
chunk__47732_47872 = G__47880;
count__47733_47873 = G__47881;
i__47734_47874 = G__47882;
continue;
} else {
var temp__5720__auto___47883 = cljs.core.seq.call(null,seq__47731_47871);
if(temp__5720__auto___47883){
var seq__47731_47884__$1 = temp__5720__auto___47883;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47731_47884__$1)){
var c__6568__auto___47885 = cljs.core.chunk_first.call(null,seq__47731_47884__$1);
var G__47886 = cljs.core.chunk_rest.call(null,seq__47731_47884__$1);
var G__47887 = c__6568__auto___47885;
var G__47888 = cljs.core.count.call(null,c__6568__auto___47885);
var G__47889 = (0);
seq__47731_47871 = G__47886;
chunk__47732_47872 = G__47887;
count__47733_47873 = G__47888;
i__47734_47874 = G__47889;
continue;
} else {
var child_47890 = cljs.core.first.call(null,seq__47731_47884__$1);
if((!((child_47890 == null)))){
if(cljs.core.coll_QMARK_.call(null,child_47890)){
(template["push"]).apply(template,devtools.formatters.templating.mark_as_template_BANG_.call(null,cljs.core.into_array.call(null,cljs.core.keep.call(null,devtools.formatters.helpers.pref,child_47890))));
} else {
var temp__5718__auto___47891 = devtools.formatters.helpers.pref.call(null,child_47890);
if(cljs.core.truth_(temp__5718__auto___47891)){
var child_value_47892 = temp__5718__auto___47891;
template.push(child_value_47892);
} else {
}
}
} else {
}


var G__47893 = cljs.core.next.call(null,seq__47731_47884__$1);
var G__47894 = null;
var G__47895 = (0);
var G__47896 = (0);
seq__47731_47871 = G__47893;
chunk__47732_47872 = G__47894;
count__47733_47873 = G__47895;
i__47734_47874 = G__47896;
continue;
}
} else {
}
}
break;
}

return template;
}));

(devtools.formatters.templating.make_template.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(devtools.formatters.templating.make_template.cljs$lang$applyTo = (function (seq47720){
var G__47721 = cljs.core.first.call(null,seq47720);
var seq47720__$1 = cljs.core.next.call(null,seq47720);
var G__47722 = cljs.core.first.call(null,seq47720__$1);
var seq47720__$2 = cljs.core.next.call(null,seq47720__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47721,G__47722,seq47720__$2);
}));

devtools.formatters.templating.concat_templates_BANG_ = (function devtools$formatters$templating$concat_templates_BANG_(var_args){
var args__6930__auto__ = [];
var len__6920__auto___47897 = arguments.length;
var i__6921__auto___47898 = (0);
while(true){
if((i__6921__auto___47898 < len__6920__auto___47897)){
args__6930__auto__.push((arguments[i__6921__auto___47898]));

var G__47899 = (i__6921__auto___47898 + (1));
i__6921__auto___47898 = G__47899;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((1) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((1)),(0),null)):null);
return devtools.formatters.templating.concat_templates_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6931__auto__);
});

(devtools.formatters.templating.concat_templates_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (template,templates){
return devtools.formatters.templating.mark_as_template_BANG_.call(null,(template["concat"]).apply(template,cljs.core.into_array.call(null,cljs.core.map.call(null,cljs.core.into_array,cljs.core.keep.call(null,devtools.formatters.helpers.pref,templates)))));
}));

(devtools.formatters.templating.concat_templates_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(devtools.formatters.templating.concat_templates_BANG_.cljs$lang$applyTo = (function (seq47743){
var G__47744 = cljs.core.first.call(null,seq47743);
var seq47743__$1 = cljs.core.next.call(null,seq47743);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47744,seq47743__$1);
}));

devtools.formatters.templating.extend_template_BANG_ = (function devtools$formatters$templating$extend_template_BANG_(var_args){
var args__6930__auto__ = [];
var len__6920__auto___47903 = arguments.length;
var i__6921__auto___47904 = (0);
while(true){
if((i__6921__auto___47904 < len__6920__auto___47903)){
args__6930__auto__.push((arguments[i__6921__auto___47904]));

var G__47907 = (i__6921__auto___47904 + (1));
i__6921__auto___47904 = G__47907;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((1) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((1)),(0),null)):null);
return devtools.formatters.templating.extend_template_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6931__auto__);
});

(devtools.formatters.templating.extend_template_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (template,args){
return devtools.formatters.templating.concat_templates_BANG_.call(null,template,args);
}));

(devtools.formatters.templating.extend_template_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(devtools.formatters.templating.extend_template_BANG_.cljs$lang$applyTo = (function (seq47756){
var G__47757 = cljs.core.first.call(null,seq47756);
var seq47756__$1 = cljs.core.next.call(null,seq47756);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47757,seq47756__$1);
}));

devtools.formatters.templating.make_surrogate = (function devtools$formatters$templating$make_surrogate(var_args){
var G__47769 = arguments.length;
switch (G__47769) {
case 1:
return devtools.formatters.templating.make_surrogate.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return devtools.formatters.templating.make_surrogate.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return devtools.formatters.templating.make_surrogate.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return devtools.formatters.templating.make_surrogate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(devtools.formatters.templating.make_surrogate.cljs$core$IFn$_invoke$arity$1 = (function (object){
return devtools.formatters.templating.make_surrogate.call(null,object,null);
}));

(devtools.formatters.templating.make_surrogate.cljs$core$IFn$_invoke$arity$2 = (function (object,header){
return devtools.formatters.templating.make_surrogate.call(null,object,header,null);
}));

(devtools.formatters.templating.make_surrogate.cljs$core$IFn$_invoke$arity$3 = (function (object,header,body){
return devtools.formatters.templating.make_surrogate.call(null,object,header,body,(0));
}));

(devtools.formatters.templating.make_surrogate.cljs$core$IFn$_invoke$arity$4 = (function (object,header,body,start_index){
return devtools.formatters.templating.mark_as_surrogate_BANG_.call(null,(function (){var obj47771 = ({"target":object,"header":header,"body":body,"startIndex":(function (){var or__5598__auto__ = start_index;
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return (0);
}
})()});
return obj47771;
})());
}));

(devtools.formatters.templating.make_surrogate.cljs$lang$maxFixedArity = 4);

devtools.formatters.templating.get_surrogate_target = (function devtools$formatters$templating$get_surrogate_target(surrogate){
if(devtools.formatters.templating.surrogate_QMARK_.call(null,surrogate)){
} else {
throw (new Error("Assert failed: (surrogate? surrogate)"));
}

return (surrogate["target"]);
});
devtools.formatters.templating.get_surrogate_header = (function devtools$formatters$templating$get_surrogate_header(surrogate){
if(devtools.formatters.templating.surrogate_QMARK_.call(null,surrogate)){
} else {
throw (new Error("Assert failed: (surrogate? surrogate)"));
}

return (surrogate["header"]);
});
devtools.formatters.templating.get_surrogate_body = (function devtools$formatters$templating$get_surrogate_body(surrogate){
if(devtools.formatters.templating.surrogate_QMARK_.call(null,surrogate)){
} else {
throw (new Error("Assert failed: (surrogate? surrogate)"));
}

return (surrogate["body"]);
});
devtools.formatters.templating.get_surrogate_start_index = (function devtools$formatters$templating$get_surrogate_start_index(surrogate){
if(devtools.formatters.templating.surrogate_QMARK_.call(null,surrogate)){
} else {
throw (new Error("Assert failed: (surrogate? surrogate)"));
}

return (surrogate["startIndex"]);
});
devtools.formatters.templating.make_reference = (function devtools$formatters$templating$make_reference(var_args){
var args__6930__auto__ = [];
var len__6920__auto___47918 = arguments.length;
var i__6921__auto___47919 = (0);
while(true){
if((i__6921__auto___47919 < len__6920__auto___47918)){
args__6930__auto__.push((arguments[i__6921__auto___47919]));

var G__47920 = (i__6921__auto___47919 + (1));
i__6921__auto___47919 = G__47920;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((1) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((1)),(0),null)):null);
return devtools.formatters.templating.make_reference.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6931__auto__);
});

(devtools.formatters.templating.make_reference.cljs$core$IFn$_invoke$arity$variadic = (function (object,p__47776){
var vec__47777 = p__47776;
var state_override_fn = cljs.core.nth.call(null,vec__47777,(0),null);
if((((state_override_fn == null)) || (cljs.core.fn_QMARK_.call(null,state_override_fn)))){
} else {
throw (new Error("Assert failed: (or (nil? state-override-fn) (fn? state-override-fn))"));
}

if((object == null)){
return devtools.formatters.templating.make_template.call(null,new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.Keyword(null,"nil-style","nil-style",-1505044832),new cljs.core.Keyword(null,"nil-label","nil-label",-587789203));
} else {
var sub_state = (((!((state_override_fn == null))))?state_override_fn.call(null,devtools.formatters.state.get_current_state.call(null)):devtools.formatters.state.get_current_state.call(null));
return devtools.formatters.templating.make_group.call(null,"object",({"object": object, "config": sub_state}));
}
}));

(devtools.formatters.templating.make_reference.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(devtools.formatters.templating.make_reference.cljs$lang$applyTo = (function (seq47774){
var G__47775 = cljs.core.first.call(null,seq47774);
var seq47774__$1 = cljs.core.next.call(null,seq47774);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47775,seq47774__$1);
}));

devtools.formatters.templating._STAR_current_render_stack_STAR_ = cljs.core.PersistentVector.EMPTY;
devtools.formatters.templating._STAR_current_render_path_STAR_ = cljs.core.PersistentVector.EMPTY;
devtools.formatters.templating.print_preview = (function devtools$formatters$templating$print_preview(markup){
var _STAR_print_level_STAR__orig_val__47782 = cljs.core._STAR_print_level_STAR_;
var _STAR_print_level_STAR__temp_val__47783 = (1);
(cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR__temp_val__47783);

try{return cljs.core.pr_str.call(null,markup);
}finally {(cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR__orig_val__47782);
}});
devtools.formatters.templating.add_stack_separators = (function devtools$formatters$templating$add_stack_separators(stack){
return cljs.core.interpose.call(null,"-------------",stack);
});
devtools.formatters.templating.replace_fns_with_markers = (function devtools$formatters$templating$replace_fns_with_markers(stack){
var f = (function (v){
if(cljs.core.fn_QMARK_.call(null,v)){
return "##fn##";
} else {
return v;
}
});
return clojure.walk.prewalk.call(null,f,stack);
});
devtools.formatters.templating.pprint_render_calls = (function devtools$formatters$templating$pprint_render_calls(stack){
return cljs.core.map.call(null,devtools.util.pprint_str,stack);
});
devtools.formatters.templating.pprint_render_stack = (function devtools$formatters$templating$pprint_render_stack(stack){
return clojure.string.join.call(null,"\n",devtools.formatters.templating.add_stack_separators.call(null,devtools.formatters.templating.pprint_render_calls.call(null,devtools.formatters.templating.replace_fns_with_markers.call(null,cljs.core.reverse.call(null,stack)))));
});
devtools.formatters.templating.pprint_render_path = (function devtools$formatters$templating$pprint_render_path(path){
return devtools.util.pprint_str.call(null,path);
});
devtools.formatters.templating.assert_markup_error = (function devtools$formatters$templating$assert_markup_error(msg){
throw (new Error(["Assert failed: ",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg),"\n","Render path: ",devtools.formatters.templating.pprint_render_path.call(null,devtools.formatters.templating._STAR_current_render_path_STAR_),"\n","Render stack:\n",devtools.formatters.templating.pprint_render_stack.call(null,devtools.formatters.templating._STAR_current_render_stack_STAR_)].join(''),"\n","false"].join('')));

});
devtools.formatters.templating.surrogate_markup_QMARK_ = (function devtools$formatters$templating$surrogate_markup_QMARK_(markup){
return ((cljs.core.sequential_QMARK_.call(null,markup)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,markup),"surrogate")));
});
devtools.formatters.templating.render_special = (function devtools$formatters$templating$render_special(name,args){
var G__47791 = name;
switch (G__47791) {
case "surrogate":
var obj = cljs.core.first.call(null,args);
var converted_args = cljs.core.map.call(null,devtools.formatters.templating.render_json_ml_STAR_,cljs.core.rest.call(null,args));
return cljs.core.apply.call(null,devtools.formatters.templating.make_surrogate,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [obj], null),converted_args));

break;
case "reference":
var obj = cljs.core.first.call(null,args);
var converted_obj = ((devtools.formatters.templating.surrogate_markup_QMARK_.call(null,obj))?devtools.formatters.templating.render_json_ml_STAR_.call(null,obj):obj);
return cljs.core.apply.call(null,devtools.formatters.templating.make_reference,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [converted_obj], null),cljs.core.rest.call(null,args)));

break;
default:
return devtools.formatters.templating.assert_markup_error.call(null,["no matching special tag name: '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"'"].join(''));

}
});
devtools.formatters.templating.emptyish_QMARK_ = (function devtools$formatters$templating$emptyish_QMARK_(v){
if(((cljs.core.seqable_QMARK_.call(null,v)) || (cljs.core.array_QMARK_.call(null,v)) || (typeof v === 'string'))){
return cljs.core.empty_QMARK_.call(null,v);
} else {
return false;
}
});
devtools.formatters.templating.render_subtree = (function devtools$formatters$templating$render_subtree(tag,children){
var vec__47820 = tag;
var html_tag = cljs.core.nth.call(null,vec__47820,(0),null);
var style = cljs.core.nth.call(null,vec__47820,(1),null);
return cljs.core.apply.call(null,devtools.formatters.templating.make_template,html_tag,style,cljs.core.map.call(null,devtools.formatters.templating.render_json_ml_STAR_,cljs.core.remove.call(null,devtools.formatters.templating.emptyish_QMARK_,cljs.core.map.call(null,devtools.formatters.helpers.pref,children))));
});
devtools.formatters.templating.render_json_ml_STAR_ = (function devtools$formatters$templating$render_json_ml_STAR_(markup){
if((!(cljs.core.sequential_QMARK_.call(null,markup)))){
return markup;
} else {
var _STAR_current_render_path_STAR__orig_val__47823 = devtools.formatters.templating._STAR_current_render_path_STAR_;
var _STAR_current_render_path_STAR__temp_val__47824 = cljs.core.conj.call(null,devtools.formatters.templating._STAR_current_render_path_STAR_,cljs.core.first.call(null,markup));
(devtools.formatters.templating._STAR_current_render_path_STAR_ = _STAR_current_render_path_STAR__temp_val__47824);

try{var tag = devtools.formatters.helpers.pref.call(null,cljs.core.first.call(null,markup));
if(typeof tag === 'string'){
return devtools.formatters.templating.render_special.call(null,tag,cljs.core.rest.call(null,markup));
} else {
if(cljs.core.sequential_QMARK_.call(null,tag)){
return devtools.formatters.templating.render_subtree.call(null,tag,cljs.core.rest.call(null,markup));
} else {
return devtools.formatters.templating.assert_markup_error.call(null,["invalid json-ml markup at ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(devtools.formatters.templating.print_preview.call(null,markup)),":"].join(''));

}
}
}finally {(devtools.formatters.templating._STAR_current_render_path_STAR_ = _STAR_current_render_path_STAR__orig_val__47823);
}}
});
devtools.formatters.templating.render_json_ml = (function devtools$formatters$templating$render_json_ml(markup){
var _STAR_current_render_stack_STAR__orig_val__47830 = devtools.formatters.templating._STAR_current_render_stack_STAR_;
var _STAR_current_render_path_STAR__orig_val__47831 = devtools.formatters.templating._STAR_current_render_path_STAR_;
var _STAR_current_render_stack_STAR__temp_val__47832 = cljs.core.conj.call(null,devtools.formatters.templating._STAR_current_render_stack_STAR_,markup);
var _STAR_current_render_path_STAR__temp_val__47833 = cljs.core.conj.call(null,devtools.formatters.templating._STAR_current_render_path_STAR_,"<render-json-ml>");
(devtools.formatters.templating._STAR_current_render_stack_STAR_ = _STAR_current_render_stack_STAR__temp_val__47832);

(devtools.formatters.templating._STAR_current_render_path_STAR_ = _STAR_current_render_path_STAR__temp_val__47833);

try{return devtools.formatters.templating.render_json_ml_STAR_.call(null,markup);
}finally {(devtools.formatters.templating._STAR_current_render_path_STAR_ = _STAR_current_render_path_STAR__orig_val__47831);

(devtools.formatters.templating._STAR_current_render_stack_STAR_ = _STAR_current_render_stack_STAR__orig_val__47830);
}});
devtools.formatters.templating.assert_failed_markup_rendering = (function devtools$formatters$templating$assert_failed_markup_rendering(initial_value,value){
throw (new Error(["Assert failed: ",["result of markup rendering must be a template,\n","resolved to ",devtools.util.pprint_str.call(null,value),"initial value: ",devtools.util.pprint_str.call(null,initial_value)].join(''),"\n","false"].join('')));

});
devtools.formatters.templating.render_markup_STAR_ = (function devtools$formatters$templating$render_markup_STAR_(initial_value,value){
while(true){
if(cljs.core.fn_QMARK_.call(null,value)){
var G__47943 = initial_value;
var G__47944 = value.call(null);
initial_value = G__47943;
value = G__47944;
continue;
} else {
if((value instanceof cljs.core.Keyword)){
var G__47945 = initial_value;
var G__47946 = devtools.formatters.helpers.pref.call(null,value);
initial_value = G__47945;
value = G__47946;
continue;
} else {
if(cljs.core.sequential_QMARK_.call(null,value)){
var G__47947 = initial_value;
var G__47948 = devtools.formatters.templating.render_json_ml.call(null,value);
initial_value = G__47947;
value = G__47948;
continue;
} else {
if(devtools.formatters.templating.template_QMARK_.call(null,value)){
return value;
} else {
if(devtools.formatters.templating.surrogate_QMARK_.call(null,value)){
return value;
} else {
if(devtools.formatters.templating.reference_QMARK_.call(null,value)){
return value;
} else {
return devtools.formatters.templating.assert_failed_markup_rendering.call(null,initial_value,value);

}
}
}
}
}
}
break;
}
});
devtools.formatters.templating.render_markup = (function devtools$formatters$templating$render_markup(value){
return devtools.formatters.templating.render_markup_STAR_.call(null,value,value);
});

//# sourceMappingURL=devtools.formatters.templating.js.map
