goog.provide('shadow.cljs.devtools.client.env');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('cljs.tools.reader');
goog.require('cljs.pprint');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.runtime_id !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.runtime_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
}

/** @define {boolean} */
goog.define("shadow.cljs.devtools.client.env.enabled",false);

/** @define {boolean} */
goog.define("shadow.cljs.devtools.client.env.autoload",true);

/** @define {string} */
goog.define("shadow.cljs.devtools.client.env.module_format","goog");

/** @define {boolean} */
goog.define("shadow.cljs.devtools.client.env.reload_with_state",false);

/** @define {string} */
goog.define("shadow.cljs.devtools.client.env.build_id","");

/** @define {string} */
goog.define("shadow.cljs.devtools.client.env.proc_id","");

/** @define {string} */
goog.define("shadow.cljs.devtools.client.env.server_host","");

/** @define {number} */
goog.define("shadow.cljs.devtools.client.env.server_port",(8200));

/** @define {boolean} */
goog.define("shadow.cljs.devtools.client.env.repl_pprint",false);

/** @define {boolean} */
goog.define("shadow.cljs.devtools.client.env.use_document_host",true);

/** @define {string} */
goog.define("shadow.cljs.devtools.client.env.devtools_url","");

/** @define {boolean} */
goog.define("shadow.cljs.devtools.client.env.ssl",false);

/** @define {boolean} */
goog.define("shadow.cljs.devtools.client.env.ignore_warnings",false);
shadow.cljs.devtools.client.env.devtools_info = (function shadow$cljs$devtools$client$env$devtools_info(){
return ({"server-port": shadow.cljs.devtools.client.env.server_port, "server-host": shadow.cljs.devtools.client.env.server_host, "build-id": shadow.cljs.devtools.client.env.build_id, "proc-id": shadow.cljs.devtools.client.env.proc_id, "runtime-id": shadow.cljs.devtools.client.env.runtime_id});
});
shadow.cljs.devtools.client.env.get_server_host = (function shadow$cljs$devtools$client$env$get_server_host(){
if(cljs.core.truth_((function (){var and__4120__auto__ = shadow.cljs.devtools.client.env.use_document_host;
if(and__4120__auto__){
var and__4120__auto____$1 = goog.global.document;
if(cljs.core.truth_(and__4120__auto____$1)){
var and__4120__auto____$2 = goog.global.document.location;
if(cljs.core.truth_(and__4120__auto____$2)){
return cljs.core.seq.call(null,goog.global.document.location.hostname);
} else {
return and__4120__auto____$2;
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())){
return document.location.hostname;
} else {
if(cljs.core.seq.call(null,shadow.cljs.devtools.client.env.server_host)){
return shadow.cljs.devtools.client.env.server_host;
} else {
return "localhost";

}
}
});
shadow.cljs.devtools.client.env.get_url_base = (function shadow$cljs$devtools$client$env$get_url_base(){
if(cljs.core.seq.call(null,shadow.cljs.devtools.client.env.devtools_url)){
return shadow.cljs.devtools.client.env.devtools_url;
} else {
return ["http",((shadow.cljs.devtools.client.env.ssl)?"s":null),"://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.get_server_host.call(null)),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port)].join('');
}
});
shadow.cljs.devtools.client.env.get_ws_url_base = (function shadow$cljs$devtools$client$env$get_ws_url_base(){
return clojure.string.replace.call(null,shadow.cljs.devtools.client.env.get_url_base.call(null),/^http/,"ws");
});
shadow.cljs.devtools.client.env.ws_url = (function shadow$cljs$devtools$client$env$ws_url(runtime_type){
if((runtime_type instanceof cljs.core.Keyword)){
} else {
throw (new Error("Assert failed: (keyword? runtime-type)"));
}

return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.get_ws_url_base.call(null)),"/ws/worker/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/",shadow.cljs.devtools.client.env.runtime_id,"/",cljs.core.name.call(null,runtime_type)].join('');
});
shadow.cljs.devtools.client.env.ws_listener_url = (function shadow$cljs$devtools$client$env$ws_listener_url(client_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.get_ws_url_base.call(null)),"/ws/listener/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/",shadow.cljs.devtools.client.env.runtime_id].join('');
});
shadow.cljs.devtools.client.env.files_url = (function shadow$cljs$devtools$client$env$files_url(){
return [shadow.cljs.devtools.client.env.get_url_base.call(null),"/worker/files/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/",shadow.cljs.devtools.client.env.runtime_id].join('');
});
shadow.cljs.devtools.client.env.repl_print_fn = (((!(shadow.cljs.devtools.client.env.repl_pprint)))?cljs.core.pr_str:(function shadow$cljs$devtools$client$env$repl_pprint(obj){
var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__43451_43537 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__43452_43538 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__43453_43539 = true;
var _STAR_print_fn_STAR__temp_val__43454_43540 = ((function (_STAR_print_newline_STAR__orig_val__43451_43537,_STAR_print_fn_STAR__orig_val__43452_43538,_STAR_print_newline_STAR__temp_val__43453_43539,sb__4661__auto__){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__43451_43537,_STAR_print_fn_STAR__orig_val__43452_43538,_STAR_print_newline_STAR__temp_val__43453_43539,sb__4661__auto__))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__43453_43539;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__43454_43540;

try{cljs.pprint.pprint.call(null,obj);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__43452_43538;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__43451_43537;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
}));
shadow.cljs.devtools.client.env.repl_error = (function shadow$cljs$devtools$client$env$repl_error(e){
var G__43457 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","invoke-error","repl/invoke-error",839951858),new cljs.core.Keyword(null,"error","error",-978969032),e.message], null);
if(cljs.core.truth_(e.hasOwnProperty("stack"))){
return cljs.core.assoc.call(null,G__43457,new cljs.core.Keyword(null,"stack","stack",-793405930),e.stack);
} else {
return G__43457;
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.repl_results_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.repl_results_ref = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
shadow.cljs.devtools.client.env.repl_call = (function shadow$cljs$devtools$client$env$repl_call(repl_expr,repl_error){
try{var result_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var result = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","result","repl/result",1421065572),new cljs.core.Keyword(null,"result-id","result-id",-2004530966),result_id], null);
var ret = repl_expr.call(null);
cljs.core.swap_BANG_.call(null,shadow.cljs.devtools.client.env.repl_results_ref,cljs.core.assoc,result_id,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"timestamp","timestamp",579478971),Date.now(),new cljs.core.Keyword(null,"result","result",1415092211),ret], null));

cljs.core._STAR_3 = cljs.core._STAR_2;

cljs.core._STAR_2 = cljs.core._STAR_1;

cljs.core._STAR_1 = ret;

try{var printed = shadow.cljs.devtools.client.env.repl_print_fn.call(null,ret);
cljs.core.swap_BANG_.call(null,shadow.cljs.devtools.client.env.repl_results_ref,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result_id,new cljs.core.Keyword(null,"printed","printed",1871492381)], null),printed);

return cljs.core.assoc.call(null,result,new cljs.core.Keyword(null,"value","value",305978217),printed);
}catch (e43459){var e = e43459;
console.log("encoding of result failed",e,ret);

return cljs.core.assoc.call(null,result,new cljs.core.Keyword(null,"error","error",-978969032),"ENCODING FAILED");
}}catch (e43458){var e = e43458;
cljs.core._STAR_e = e;

return repl_error.call(null,e);
}});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.reset_print_fn_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.reset_print_fn_ref = cljs.core.atom.call(null,null);
}
shadow.cljs.devtools.client.env.set_print_fns_BANG_ = (function shadow$cljs$devtools$client$env$set_print_fns_BANG_(msg_fn){
var original_print_fn = cljs.core._STAR_print_fn_STAR_;
var original_print_err_fn = cljs.core._STAR_print_err_fn_STAR_;
cljs.core.reset_BANG_.call(null,shadow.cljs.devtools.client.env.reset_print_fn_ref,((function (original_print_fn,original_print_err_fn){
return (function shadow$cljs$devtools$client$env$set_print_fns_BANG__$_reset_print_fns_BANG_(){
cljs.core.set_print_fn_BANG_.call(null,original_print_fn);

return cljs.core.set_print_err_fn_BANG_.call(null,original_print_err_fn);
});})(original_print_fn,original_print_err_fn))
);

cljs.core.set_print_fn_BANG_.call(null,((function (original_print_fn,original_print_err_fn){
return (function() { 
var shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn__delegate = function (args){
msg_fn.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","out","repl/out",-905715102),new cljs.core.Keyword(null,"text","text",-1790561697),clojure.string.join.call(null,"",args)], null));

if(cljs.core.truth_(original_print_fn)){
return cljs.core.apply.call(null,original_print_fn,args);
} else {
return null;
}
};
var shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__43548__i = 0, G__43548__a = new Array(arguments.length -  0);
while (G__43548__i < G__43548__a.length) {G__43548__a[G__43548__i] = arguments[G__43548__i + 0]; ++G__43548__i;}
  args = new cljs.core.IndexedSeq(G__43548__a,0,null);
} 
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn__delegate.call(this,args);};
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn.cljs$lang$maxFixedArity = 0;
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn.cljs$lang$applyTo = (function (arglist__43550){
var args = cljs.core.seq(arglist__43550);
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn__delegate(args);
});
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn.cljs$core$IFn$_invoke$arity$variadic = shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn__delegate;
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_fn;
})()
;})(original_print_fn,original_print_err_fn))
);

return cljs.core.set_print_err_fn_BANG_.call(null,((function (original_print_fn,original_print_err_fn){
return (function() { 
var shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn__delegate = function (args){
msg_fn.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","err","repl/err",-2086562244),new cljs.core.Keyword(null,"text","text",-1790561697),clojure.string.join.call(null,"",args)], null));

if(cljs.core.truth_(original_print_err_fn)){
return cljs.core.apply.call(null,original_print_err_fn,args);
} else {
return null;
}
};
var shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__43552__i = 0, G__43552__a = new Array(arguments.length -  0);
while (G__43552__i < G__43552__a.length) {G__43552__a[G__43552__i] = arguments[G__43552__i + 0]; ++G__43552__i;}
  args = new cljs.core.IndexedSeq(G__43552__a,0,null);
} 
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn__delegate.call(this,args);};
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn.cljs$lang$maxFixedArity = 0;
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn.cljs$lang$applyTo = (function (arglist__43553){
var args = cljs.core.seq(arglist__43553);
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn__delegate(args);
});
shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn.cljs$core$IFn$_invoke$arity$variadic = shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn__delegate;
return shadow$cljs$devtools$client$env$set_print_fns_BANG__$_repl_print_err_fn;
})()
;})(original_print_fn,original_print_err_fn))
);
});
shadow.cljs.devtools.client.env.reset_print_fns_BANG_ = (function shadow$cljs$devtools$client$env$reset_print_fns_BANG_(){
var temp__5720__auto__ = cljs.core.deref.call(null,shadow.cljs.devtools.client.env.reset_print_fn_ref);
if(cljs.core.truth_(temp__5720__auto__)){
var x = temp__5720__auto__;
x.call(null);

return cljs.core.reset_BANG_.call(null,shadow.cljs.devtools.client.env.reset_print_fn_ref,null);
} else {
return null;
}
});
shadow.cljs.devtools.client.env.process_ws_msg = (function shadow$cljs$devtools$client$env$process_ws_msg(text,handler){
var _STAR_default_data_reader_fn_STAR__orig_val__43460 = cljs.tools.reader._STAR_default_data_reader_fn_STAR_;
var _STAR_default_data_reader_fn_STAR__temp_val__43461 = ((function (_STAR_default_data_reader_fn_STAR__orig_val__43460){
return (function (tag,value){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tagged-literal","tagged-literal",1758013066),tag,value], null);
});})(_STAR_default_data_reader_fn_STAR__orig_val__43460))
;
cljs.tools.reader._STAR_default_data_reader_fn_STAR_ = _STAR_default_data_reader_fn_STAR__temp_val__43461;

try{try{var msg = cljs.tools.reader.read_string.call(null,text);
return handler.call(null,msg);
}catch (e43462){var e = e43462;
console.warn("failed to parse websocket message",text,e);

throw e;
}}finally {cljs.tools.reader._STAR_default_data_reader_fn_STAR_ = _STAR_default_data_reader_fn_STAR__orig_val__43460;
}});
shadow.cljs.devtools.client.env.make_task_fn = (function shadow$cljs$devtools$client$env$make_task_fn(p__43463,p__43464){
var map__43465 = p__43463;
var map__43465__$1 = (((((!((map__43465 == null))))?(((((map__43465.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43465.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43465):map__43465);
var log_missing_fn = cljs.core.get.call(null,map__43465__$1,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765));
var log_call_async = cljs.core.get.call(null,map__43465__$1,new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192));
var log_call = cljs.core.get.call(null,map__43465__$1,new cljs.core.Keyword(null,"log-call","log-call",412404391));
var map__43466 = p__43464;
var map__43466__$1 = (((((!((map__43466 == null))))?(((((map__43466.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43466.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43466):map__43466);
var fn_sym = cljs.core.get.call(null,map__43466__$1,new cljs.core.Keyword(null,"fn-sym","fn-sym",1423988510));
var fn_str = cljs.core.get.call(null,map__43466__$1,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402));
var async = cljs.core.get.call(null,map__43466__$1,new cljs.core.Keyword(null,"async","async",1050769601));
return ((function (map__43465,map__43465__$1,log_missing_fn,log_call_async,log_call,map__43466,map__43466__$1,fn_sym,fn_str,async){
return (function (next){
try{var fn_obj = goog.getObjectByName(fn_str,$CLJS);
if((fn_obj == null)){
if(cljs.core.truth_(log_missing_fn)){
log_missing_fn.call(null,fn_sym);
} else {
}

return next.call(null);
} else {
if(cljs.core.truth_(async)){
if(cljs.core.truth_(log_call_async)){
log_call_async.call(null,fn_sym);
} else {
}

return fn_obj.call(null,next);
} else {
if(cljs.core.truth_(log_call)){
log_call.call(null,fn_sym);
} else {
}

fn_obj.call(null);

return next.call(null);

}
}
}catch (e43469){var ex = e43469;
console.warn("error when calling lifecycle function",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym),ex);

return next.call(null);
}});
;})(map__43465,map__43465__$1,log_missing_fn,log_call_async,log_call,map__43466,map__43466__$1,fn_sym,fn_str,async))
});
shadow.cljs.devtools.client.env.do_js_reload_STAR_ = (function shadow$cljs$devtools$client$env$do_js_reload_STAR_(failure_fn,p__43476){
var vec__43477 = p__43476;
var seq__43478 = cljs.core.seq.call(null,vec__43477);
var first__43479 = cljs.core.first.call(null,seq__43478);
var seq__43478__$1 = cljs.core.next.call(null,seq__43478);
var task = first__43479;
var remaining_tasks = seq__43478__$1;
if(cljs.core.truth_(task)){
try{return task.call(null,((function (vec__43477,seq__43478,first__43479,seq__43478__$1,task,remaining_tasks){
return (function (){
return shadow.cljs.devtools.client.env.do_js_reload_STAR_.call(null,failure_fn,remaining_tasks);
});})(vec__43477,seq__43478,first__43479,seq__43478__$1,task,remaining_tasks))
);
}catch (e43480){var e = e43480;
return failure_fn.call(null,e,task,remaining_tasks);
}} else {
return null;
}
});
/**
 * should pass the :build-complete message and an additional callback
 * which performs the actual loading of the code (sync)
 * will call all before/after callbacks in order
 */
shadow.cljs.devtools.client.env.do_js_reload = (function shadow$cljs$devtools$client$env$do_js_reload(var_args){
var G__43484 = arguments.length;
switch (G__43484) {
case 2:
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$2 = (function (msg,load_code_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,msg,load_code_fn,(function (){
return null;
}));
});

shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$3 = (function (msg,load_code_fn,complete_fn){
return shadow.cljs.devtools.client.env.do_js_reload.call(null,msg,load_code_fn,complete_fn,(function (error,task,remaining){
return console.warn("JS reload failed",error);
}));
});

shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4 = (function (p__43490,load_code_fn,complete_fn,failure_fn){
var map__43491 = p__43490;
var map__43491__$1 = (((((!((map__43491 == null))))?(((((map__43491.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43491.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43491):map__43491);
var msg = map__43491__$1;
var reload_info = cljs.core.get.call(null,map__43491__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var load_tasks = cljs.core.conj.call(null,cljs.core.into.call(null,cljs.core.conj.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.reverse.call(null,cljs.core.map.call(null,((function (map__43491,map__43491__$1,msg,reload_info){
return (function (p1__43481_SHARP_){
return shadow.cljs.devtools.client.env.make_task_fn.call(null,msg,p1__43481_SHARP_);
});})(map__43491,map__43491__$1,msg,reload_info))
,new cljs.core.Keyword(null,"before-load","before-load",-2060117064).cljs$core$IFn$_invoke$arity$1(reload_info)))),((function (map__43491,map__43491__$1,msg,reload_info){
return (function (next){
load_code_fn.call(null);

return next.call(null);
});})(map__43491,map__43491__$1,msg,reload_info))
),cljs.core.map.call(null,((function (map__43491,map__43491__$1,msg,reload_info){
return (function (p1__43482_SHARP_){
return shadow.cljs.devtools.client.env.make_task_fn.call(null,msg,p1__43482_SHARP_);
});})(map__43491,map__43491__$1,msg,reload_info))
),new cljs.core.Keyword(null,"after-load","after-load",-1278503285).cljs$core$IFn$_invoke$arity$1(reload_info)),((function (map__43491,map__43491__$1,msg,reload_info){
return (function (next){
complete_fn.call(null);

return next.call(null);
});})(map__43491,map__43491__$1,msg,reload_info))
);
return shadow.cljs.devtools.client.env.do_js_reload_STAR_.call(null,failure_fn,load_tasks);
});

shadow.cljs.devtools.client.env.do_js_reload.cljs$lang$maxFixedArity = 4;

shadow.cljs.devtools.client.env.before_load_src = (function shadow$cljs$devtools$client$env$before_load_src(p__43494){
var map__43495 = p__43494;
var map__43495__$1 = (((((!((map__43495 == null))))?(((((map__43495.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43495.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__43495):map__43495);
var src = map__43495__$1;
var type = cljs.core.get.call(null,map__43495__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var ns = cljs.core.get.call(null,map__43495__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"cljs","cljs",1492417629),type)){
var seq__43498 = cljs.core.seq.call(null,goog.global.SHADOW_NS_RESET);
var chunk__43499 = null;
var count__43500 = (0);
var i__43501 = (0);
while(true){
if((i__43501 < count__43500)){
var x = cljs.core._nth.call(null,chunk__43499,i__43501);
x.call(null,ns);


var G__43590 = seq__43498;
var G__43591 = chunk__43499;
var G__43592 = count__43500;
var G__43593 = (i__43501 + (1));
seq__43498 = G__43590;
chunk__43499 = G__43591;
count__43500 = G__43592;
i__43501 = G__43593;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__43498);
if(temp__5720__auto__){
var seq__43498__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__43498__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__43498__$1);
var G__43594 = cljs.core.chunk_rest.call(null,seq__43498__$1);
var G__43595 = c__4550__auto__;
var G__43596 = cljs.core.count.call(null,c__4550__auto__);
var G__43597 = (0);
seq__43498 = G__43594;
chunk__43499 = G__43595;
count__43500 = G__43596;
i__43501 = G__43597;
continue;
} else {
var x = cljs.core.first.call(null,seq__43498__$1);
x.call(null,ns);


var G__43598 = cljs.core.next.call(null,seq__43498__$1);
var G__43599 = null;
var G__43600 = (0);
var G__43601 = (0);
seq__43498 = G__43598;
chunk__43499 = G__43599;
count__43500 = G__43600;
i__43501 = G__43601;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.env !== 'undefined') && (typeof shadow.cljs.devtools.client.env.custom_msg_subscribers_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.env.custom_msg_subscribers_ref = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
shadow.cljs.devtools.client.env.subscribe_BANG_ = (function shadow$cljs$devtools$client$env$subscribe_BANG_(sub_id,callback){
return cljs.core.swap_BANG_.call(null,shadow.cljs.devtools.client.env.custom_msg_subscribers_ref,cljs.core.assoc,sub_id,callback);
});
shadow.cljs.devtools.client.env.publish_BANG_ = (function shadow$cljs$devtools$client$env$publish_BANG_(msg){
var seq__43506 = cljs.core.seq.call(null,cljs.core.deref.call(null,shadow.cljs.devtools.client.env.custom_msg_subscribers_ref));
var chunk__43507 = null;
var count__43508 = (0);
var i__43509 = (0);
while(true){
if((i__43509 < count__43508)){
var vec__43518 = cljs.core._nth.call(null,chunk__43507,i__43509);
var id = cljs.core.nth.call(null,vec__43518,(0),null);
var callback = cljs.core.nth.call(null,vec__43518,(1),null);
try{callback.call(null,msg);
}catch (e43521){var e_43602 = e43521;
console.warn("failed to handle custom msg",id,msg);
}

var G__43603 = seq__43506;
var G__43604 = chunk__43507;
var G__43605 = count__43508;
var G__43606 = (i__43509 + (1));
seq__43506 = G__43603;
chunk__43507 = G__43604;
count__43508 = G__43605;
i__43509 = G__43606;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__43506);
if(temp__5720__auto__){
var seq__43506__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__43506__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__43506__$1);
var G__43609 = cljs.core.chunk_rest.call(null,seq__43506__$1);
var G__43610 = c__4550__auto__;
var G__43611 = cljs.core.count.call(null,c__4550__auto__);
var G__43612 = (0);
seq__43506 = G__43609;
chunk__43507 = G__43610;
count__43508 = G__43611;
i__43509 = G__43612;
continue;
} else {
var vec__43523 = cljs.core.first.call(null,seq__43506__$1);
var id = cljs.core.nth.call(null,vec__43523,(0),null);
var callback = cljs.core.nth.call(null,vec__43523,(1),null);
try{callback.call(null,msg);
}catch (e43526){var e_43613 = e43526;
console.warn("failed to handle custom msg",id,msg);
}

var G__43614 = cljs.core.next.call(null,seq__43506__$1);
var G__43615 = null;
var G__43616 = (0);
var G__43617 = (0);
seq__43506 = G__43614;
chunk__43507 = G__43615;
count__43508 = G__43616;
i__43509 = G__43617;
continue;
}
} else {
return null;
}
}
break;
}
});

//# sourceMappingURL=shadow.cljs.devtools.client.env.js.map
