goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$);
} else {
var m__4431__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$);
} else {
var m__4431__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons.call(null,(coll[idx]),shadow.dom.lazy_native_coll_seq.call(null,coll,(idx + (1))));
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4131__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return not_found;
}
});

shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
});

shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq.call(null,self__.coll,(0));
});

shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
});

shadow.dom.NativeColl.cljs$lang$type = true;

shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl";

shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"shadow.dom/NativeColl");
});

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return shadow.dom._to_dom.call(null,el);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__46822 = arguments.length;
switch (G__46822) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node.call(null,root).querySelector(sel);
});

shadow.dom.query_one.cljs$lang$maxFixedArity = 2;

shadow.dom.query = (function shadow$dom$query(var_args){
var G__46828 = arguments.length;
switch (G__46828) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,root).querySelectorAll(sel)));
});

shadow.dom.query.cljs$lang$maxFixedArity = 2;

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__46830 = arguments.length;
switch (G__46830) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node.call(null,el).getElementById(id);
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
});

shadow.dom.by_id.cljs$lang$maxFixedArity = 2;

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__46834 = arguments.length;
switch (G__46834) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
e.cancelBubble = true;

e.returnValue = false;
}

return e;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.call(null,e);

return el;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.call(null,e);

return el;
});

shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4;

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__46843 = arguments.length;
switch (G__46843) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node.call(null,el));
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node.call(null,parent),shadow.dom.dom_node.call(null,el));
});

shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2;

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__46850 = arguments.length;
switch (G__46850) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node.call(null,el),cls);
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class.call(null,el,cls);
} else {
return shadow.dom.remove_class.call(null,el,cls);
}
});

shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3;

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4131__auto__ = (!((typeof document !== 'undefined')));
if(or__4131__auto__){
return or__4131__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return handler.call(null,e,el);
}));
}catch (e46852){if((e46852 instanceof Object)){
var e = e46852;
return console.log("didnt support attachEvent",el,e);
} else {
throw e46852;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4131__auto__ = (!((typeof document !== 'undefined')));
if(or__4131__auto__){
return or__4131__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__46853 = cljs.core.seq.call(null,shadow.dom.query.call(null,selector,root_el));
var chunk__46854 = null;
var count__46855 = (0);
var i__46856 = (0);
while(true){
if((i__46856 < count__46855)){
var el = cljs.core._nth.call(null,chunk__46854,i__46856);
var handler_47323__$1 = ((function (seq__46853,chunk__46854,count__46855,i__46856,el){
return (function (e){
return handler.call(null,e,el);
});})(seq__46853,chunk__46854,count__46855,i__46856,el))
;
shadow.dom.dom_listen.call(null,el,cljs.core.name.call(null,ev),handler_47323__$1);


var G__47324 = seq__46853;
var G__47325 = chunk__46854;
var G__47326 = count__46855;
var G__47327 = (i__46856 + (1));
seq__46853 = G__47324;
chunk__46854 = G__47325;
count__46855 = G__47326;
i__46856 = G__47327;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__46853);
if(temp__5720__auto__){
var seq__46853__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46853__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__46853__$1);
var G__47328 = cljs.core.chunk_rest.call(null,seq__46853__$1);
var G__47329 = c__4550__auto__;
var G__47330 = cljs.core.count.call(null,c__4550__auto__);
var G__47331 = (0);
seq__46853 = G__47328;
chunk__46854 = G__47329;
count__46855 = G__47330;
i__46856 = G__47331;
continue;
} else {
var el = cljs.core.first.call(null,seq__46853__$1);
var handler_47332__$1 = ((function (seq__46853,chunk__46854,count__46855,i__46856,el,seq__46853__$1,temp__5720__auto__){
return (function (e){
return handler.call(null,e,el);
});})(seq__46853,chunk__46854,count__46855,i__46856,el,seq__46853__$1,temp__5720__auto__))
;
shadow.dom.dom_listen.call(null,el,cljs.core.name.call(null,ev),handler_47332__$1);


var G__47334 = cljs.core.next.call(null,seq__46853__$1);
var G__47335 = null;
var G__47336 = (0);
var G__47337 = (0);
seq__46853 = G__47334;
chunk__46854 = G__47335;
count__46855 = G__47336;
i__46856 = G__47337;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__46864 = arguments.length;
switch (G__46864) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.call(null,el,ev,handler,false);
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_.call(null,ev)){
return shadow.dom.on_query.call(null,el,cljs.core.first.call(null,ev),cljs.core.second.call(null,ev),handler);
} else {
var handler__$1 = (function (e){
return handler.call(null,e,el);
});
return shadow.dom.dom_listen.call(null,shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler__$1);
}
});

shadow.dom.on.cljs$lang$maxFixedArity = 4;

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove.call(null,shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__46869 = cljs.core.seq.call(null,events);
var chunk__46870 = null;
var count__46871 = (0);
var i__46872 = (0);
while(true){
if((i__46872 < count__46871)){
var vec__46883 = cljs.core._nth.call(null,chunk__46870,i__46872);
var k = cljs.core.nth.call(null,vec__46883,(0),null);
var v = cljs.core.nth.call(null,vec__46883,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__47346 = seq__46869;
var G__47347 = chunk__46870;
var G__47348 = count__46871;
var G__47349 = (i__46872 + (1));
seq__46869 = G__47346;
chunk__46870 = G__47347;
count__46871 = G__47348;
i__46872 = G__47349;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__46869);
if(temp__5720__auto__){
var seq__46869__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46869__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__46869__$1);
var G__47350 = cljs.core.chunk_rest.call(null,seq__46869__$1);
var G__47351 = c__4550__auto__;
var G__47352 = cljs.core.count.call(null,c__4550__auto__);
var G__47353 = (0);
seq__46869 = G__47350;
chunk__46870 = G__47351;
count__46871 = G__47352;
i__46872 = G__47353;
continue;
} else {
var vec__46888 = cljs.core.first.call(null,seq__46869__$1);
var k = cljs.core.nth.call(null,vec__46888,(0),null);
var v = cljs.core.nth.call(null,vec__46888,(1),null);
shadow.dom.on.call(null,el,k,v);


var G__47354 = cljs.core.next.call(null,seq__46869__$1);
var G__47355 = null;
var G__47356 = (0);
var G__47357 = (0);
seq__46869 = G__47354;
chunk__46870 = G__47355;
count__46871 = G__47356;
i__46872 = G__47357;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node.call(null,el);
var seq__46893 = cljs.core.seq.call(null,styles);
var chunk__46894 = null;
var count__46895 = (0);
var i__46896 = (0);
while(true){
if((i__46896 < count__46895)){
var vec__46905 = cljs.core._nth.call(null,chunk__46894,i__46896);
var k = cljs.core.nth.call(null,vec__46905,(0),null);
var v = cljs.core.nth.call(null,vec__46905,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__47360 = seq__46893;
var G__47361 = chunk__46894;
var G__47362 = count__46895;
var G__47363 = (i__46896 + (1));
seq__46893 = G__47360;
chunk__46894 = G__47361;
count__46895 = G__47362;
i__46896 = G__47363;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__46893);
if(temp__5720__auto__){
var seq__46893__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46893__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__46893__$1);
var G__47365 = cljs.core.chunk_rest.call(null,seq__46893__$1);
var G__47366 = c__4550__auto__;
var G__47367 = cljs.core.count.call(null,c__4550__auto__);
var G__47368 = (0);
seq__46893 = G__47365;
chunk__46894 = G__47366;
count__46895 = G__47367;
i__46896 = G__47368;
continue;
} else {
var vec__46909 = cljs.core.first.call(null,seq__46893__$1);
var k = cljs.core.nth.call(null,vec__46909,(0),null);
var v = cljs.core.nth.call(null,vec__46909,(1),null);
goog.style.setStyle(dom,cljs.core.name.call(null,k),(((v == null))?"":v));


var G__47370 = cljs.core.next.call(null,seq__46893__$1);
var G__47371 = null;
var G__47372 = (0);
var G__47373 = (0);
seq__46893 = G__47370;
chunk__46894 = G__47371;
count__46895 = G__47372;
i__46896 = G__47373;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__46916_47374 = key;
var G__46916_47375__$1 = (((G__46916_47374 instanceof cljs.core.Keyword))?G__46916_47374.fqn:null);
switch (G__46916_47375__$1) {
case "id":
el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value);

break;
case "class":
el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value);

break;
case "for":
el.htmlFor = value;

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners.call(null,el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_.call(null,value)){
shadow.dom.set_style.call(null,el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_47379 = cljs.core.name.call(null,key);
if(cljs.core.truth_((function (){var or__4131__auto__ = goog.string.startsWith(ks_47379,"data-");
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return goog.string.startsWith(ks_47379,"aria-");
}
})())){
el.setAttribute(ks_47379,value);
} else {
(el[ks_47379] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv.call(null,(function (el__$1,key,value){
shadow.dom.set_attr_STAR_.call(null,el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node.call(null,el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_.call(null,shadow.dom.dom_node.call(null,el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq.call(null,current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name.call(null,spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.call(null,(-1),fdot)) && (cljs.core._EQ_.call(null,(-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.call(null,(-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace.call(null,spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__46929){
var map__46930 = p__46929;
var map__46930__$1 = (((((!((map__46930 == null))))?(((((map__46930.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46930.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46930):map__46930);
var props = map__46930__$1;
var class$ = cljs.core.get.call(null,map__46930__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__46934 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__46934,(0),null);
var tag_id = cljs.core.nth.call(null,vec__46934,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__46934,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string.call(null,class$,tag_classes));
} else {
}

var G__46938 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs.call(null,G__46938,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__46938;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__46941 = arguments.length;
switch (G__46941) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node.call(null,node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node.call(null,el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$lang$maxFixedArity = 2;

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__46945){
var vec__46946 = p__46945;
var seq__46947 = cljs.core.seq.call(null,vec__46946);
var first__46948 = cljs.core.first.call(null,seq__46947);
var seq__46947__$1 = cljs.core.next.call(null,seq__46947);
var nn = first__46948;
var first__46948__$1 = cljs.core.first.call(null,seq__46947__$1);
var seq__46947__$2 = cljs.core.next.call(null,seq__46947__$1);
var np = first__46948__$1;
var nc = seq__46947__$2;
var node = vec__46946;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_.call(null,np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,np),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [create_fn.call(null,nn,cljs.core.PersistentArrayMap.EMPTY),cljs.core.conj.call(null,nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__46949 = shadow.dom.destructure_node.call(null,shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.call(null,vec__46949,(0),null);
var node_children = cljs.core.nth.call(null,vec__46949,(1),null);
var seq__46953_47395 = cljs.core.seq.call(null,node_children);
var chunk__46954_47396 = null;
var count__46955_47397 = (0);
var i__46956_47398 = (0);
while(true){
if((i__46956_47398 < count__46955_47397)){
var child_struct_47399 = cljs.core._nth.call(null,chunk__46954_47396,i__46956_47398);
var children_47401 = shadow.dom.dom_node.call(null,child_struct_47399);
if(cljs.core.seq_QMARK_.call(null,children_47401)){
var seq__46982_47403 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_47401));
var chunk__46984_47404 = null;
var count__46985_47405 = (0);
var i__46986_47406 = (0);
while(true){
if((i__46986_47406 < count__46985_47405)){
var child_47410 = cljs.core._nth.call(null,chunk__46984_47404,i__46986_47406);
if(cljs.core.truth_(child_47410)){
shadow.dom.append.call(null,node,child_47410);


var G__47412 = seq__46982_47403;
var G__47413 = chunk__46984_47404;
var G__47414 = count__46985_47405;
var G__47415 = (i__46986_47406 + (1));
seq__46982_47403 = G__47412;
chunk__46984_47404 = G__47413;
count__46985_47405 = G__47414;
i__46986_47406 = G__47415;
continue;
} else {
var G__47417 = seq__46982_47403;
var G__47418 = chunk__46984_47404;
var G__47419 = count__46985_47405;
var G__47420 = (i__46986_47406 + (1));
seq__46982_47403 = G__47417;
chunk__46984_47404 = G__47418;
count__46985_47405 = G__47419;
i__46986_47406 = G__47420;
continue;
}
} else {
var temp__5720__auto___47421 = cljs.core.seq.call(null,seq__46982_47403);
if(temp__5720__auto___47421){
var seq__46982_47422__$1 = temp__5720__auto___47421;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46982_47422__$1)){
var c__4550__auto___47423 = cljs.core.chunk_first.call(null,seq__46982_47422__$1);
var G__47424 = cljs.core.chunk_rest.call(null,seq__46982_47422__$1);
var G__47425 = c__4550__auto___47423;
var G__47426 = cljs.core.count.call(null,c__4550__auto___47423);
var G__47427 = (0);
seq__46982_47403 = G__47424;
chunk__46984_47404 = G__47425;
count__46985_47405 = G__47426;
i__46986_47406 = G__47427;
continue;
} else {
var child_47433 = cljs.core.first.call(null,seq__46982_47422__$1);
if(cljs.core.truth_(child_47433)){
shadow.dom.append.call(null,node,child_47433);


var G__47434 = cljs.core.next.call(null,seq__46982_47422__$1);
var G__47435 = null;
var G__47436 = (0);
var G__47437 = (0);
seq__46982_47403 = G__47434;
chunk__46984_47404 = G__47435;
count__46985_47405 = G__47436;
i__46986_47406 = G__47437;
continue;
} else {
var G__47438 = cljs.core.next.call(null,seq__46982_47422__$1);
var G__47439 = null;
var G__47440 = (0);
var G__47441 = (0);
seq__46982_47403 = G__47438;
chunk__46984_47404 = G__47439;
count__46985_47405 = G__47440;
i__46986_47406 = G__47441;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_47401);
}


var G__47442 = seq__46953_47395;
var G__47443 = chunk__46954_47396;
var G__47444 = count__46955_47397;
var G__47445 = (i__46956_47398 + (1));
seq__46953_47395 = G__47442;
chunk__46954_47396 = G__47443;
count__46955_47397 = G__47444;
i__46956_47398 = G__47445;
continue;
} else {
var temp__5720__auto___47447 = cljs.core.seq.call(null,seq__46953_47395);
if(temp__5720__auto___47447){
var seq__46953_47449__$1 = temp__5720__auto___47447;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46953_47449__$1)){
var c__4550__auto___47450 = cljs.core.chunk_first.call(null,seq__46953_47449__$1);
var G__47451 = cljs.core.chunk_rest.call(null,seq__46953_47449__$1);
var G__47452 = c__4550__auto___47450;
var G__47453 = cljs.core.count.call(null,c__4550__auto___47450);
var G__47454 = (0);
seq__46953_47395 = G__47451;
chunk__46954_47396 = G__47452;
count__46955_47397 = G__47453;
i__46956_47398 = G__47454;
continue;
} else {
var child_struct_47455 = cljs.core.first.call(null,seq__46953_47449__$1);
var children_47456 = shadow.dom.dom_node.call(null,child_struct_47455);
if(cljs.core.seq_QMARK_.call(null,children_47456)){
var seq__46990_47457 = cljs.core.seq.call(null,cljs.core.map.call(null,shadow.dom.dom_node,children_47456));
var chunk__46992_47458 = null;
var count__46993_47459 = (0);
var i__46994_47460 = (0);
while(true){
if((i__46994_47460 < count__46993_47459)){
var child_47461 = cljs.core._nth.call(null,chunk__46992_47458,i__46994_47460);
if(cljs.core.truth_(child_47461)){
shadow.dom.append.call(null,node,child_47461);


var G__47462 = seq__46990_47457;
var G__47463 = chunk__46992_47458;
var G__47464 = count__46993_47459;
var G__47465 = (i__46994_47460 + (1));
seq__46990_47457 = G__47462;
chunk__46992_47458 = G__47463;
count__46993_47459 = G__47464;
i__46994_47460 = G__47465;
continue;
} else {
var G__47466 = seq__46990_47457;
var G__47467 = chunk__46992_47458;
var G__47468 = count__46993_47459;
var G__47469 = (i__46994_47460 + (1));
seq__46990_47457 = G__47466;
chunk__46992_47458 = G__47467;
count__46993_47459 = G__47468;
i__46994_47460 = G__47469;
continue;
}
} else {
var temp__5720__auto___47470__$1 = cljs.core.seq.call(null,seq__46990_47457);
if(temp__5720__auto___47470__$1){
var seq__46990_47471__$1 = temp__5720__auto___47470__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46990_47471__$1)){
var c__4550__auto___47472 = cljs.core.chunk_first.call(null,seq__46990_47471__$1);
var G__47473 = cljs.core.chunk_rest.call(null,seq__46990_47471__$1);
var G__47474 = c__4550__auto___47472;
var G__47475 = cljs.core.count.call(null,c__4550__auto___47472);
var G__47476 = (0);
seq__46990_47457 = G__47473;
chunk__46992_47458 = G__47474;
count__46993_47459 = G__47475;
i__46994_47460 = G__47476;
continue;
} else {
var child_47477 = cljs.core.first.call(null,seq__46990_47471__$1);
if(cljs.core.truth_(child_47477)){
shadow.dom.append.call(null,node,child_47477);


var G__47478 = cljs.core.next.call(null,seq__46990_47471__$1);
var G__47479 = null;
var G__47480 = (0);
var G__47481 = (0);
seq__46990_47457 = G__47478;
chunk__46992_47458 = G__47479;
count__46993_47459 = G__47480;
i__46994_47460 = G__47481;
continue;
} else {
var G__47482 = cljs.core.next.call(null,seq__46990_47471__$1);
var G__47483 = null;
var G__47484 = (0);
var G__47485 = (0);
seq__46990_47457 = G__47482;
chunk__46992_47458 = G__47483;
count__46993_47459 = G__47484;
i__46994_47460 = G__47485;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.call(null,node,children_47456);
}


var G__47487 = cljs.core.next.call(null,seq__46953_47449__$1);
var G__47488 = null;
var G__47489 = (0);
var G__47490 = (0);
seq__46953_47395 = G__47487;
chunk__46954_47396 = G__47488;
count__46955_47397 = G__47489;
i__46956_47398 = G__47490;
continue;
}
} else {
}
}
break;
}

return node;
});
cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
});

cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node.call(null,this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_dom,this$__$1);
});
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node.call(null,node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__47006 = cljs.core.seq.call(null,node);
var chunk__47007 = null;
var count__47008 = (0);
var i__47009 = (0);
while(true){
if((i__47009 < count__47008)){
var n = cljs.core._nth.call(null,chunk__47007,i__47009);
shadow.dom.remove.call(null,n);


var G__47500 = seq__47006;
var G__47501 = chunk__47007;
var G__47502 = count__47008;
var G__47503 = (i__47009 + (1));
seq__47006 = G__47500;
chunk__47007 = G__47501;
count__47008 = G__47502;
i__47009 = G__47503;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__47006);
if(temp__5720__auto__){
var seq__47006__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47006__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__47006__$1);
var G__47504 = cljs.core.chunk_rest.call(null,seq__47006__$1);
var G__47505 = c__4550__auto__;
var G__47506 = cljs.core.count.call(null,c__4550__auto__);
var G__47507 = (0);
seq__47006 = G__47504;
chunk__47007 = G__47505;
count__47008 = G__47506;
i__47009 = G__47507;
continue;
} else {
var n = cljs.core.first.call(null,seq__47006__$1);
shadow.dom.remove.call(null,n);


var G__47508 = cljs.core.next.call(null,seq__47006__$1);
var G__47509 = null;
var G__47510 = (0);
var G__47511 = (0);
seq__47006 = G__47508;
chunk__47007 = G__47509;
count__47008 = G__47510;
i__47009 = G__47511;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node.call(null,new$),shadow.dom.dom_node.call(null,old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__47016 = arguments.length;
switch (G__47016) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return shadow.dom.dom_node.call(null,el).innerText = new_text;
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node.call(null,el).innerText;
});

shadow.dom.text.cljs$lang$maxFixedArity = 2;

shadow.dom.check = (function shadow$dom$check(var_args){
var G__47021 = arguments.length;
switch (G__47021) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.call(null,el,true);
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return shadow.dom.dom_node.call(null,el).checked = checked;
});

shadow.dom.check.cljs$lang$maxFixedArity = 2;

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node.call(null,el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node.call(null,el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__47031 = arguments.length;
switch (G__47031) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4131__auto__ = shadow.dom.dom_node.call(null,el).getAttribute(cljs.core.name.call(null,key));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return default$;
}
});

shadow.dom.attr.cljs$lang$maxFixedArity = 3;

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node.call(null,el).removeAttribute(cljs.core.name.call(null,key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node.call(null,el).getAttribute(["data-",cljs.core.name.call(null,key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node.call(null,el).setAttribute(["data-",cljs.core.name.call(null,key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return shadow.dom.dom_node.call(null,node).innerHTML = text;
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node.call(null,node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4736__auto__ = [];
var len__4730__auto___47528 = arguments.length;
var i__4731__auto___47529 = (0);
while(true){
if((i__4731__auto___47529 < len__4730__auto___47528)){
args__4736__auto__.push((arguments[i__4731__auto___47529]));

var G__47534 = (i__4731__auto___47529 + (1));
i__4731__auto___47529 = G__47534;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__47041_47535 = cljs.core.seq.call(null,nodes);
var chunk__47042_47536 = null;
var count__47043_47537 = (0);
var i__47044_47538 = (0);
while(true){
if((i__47044_47538 < count__47043_47537)){
var node_47539 = cljs.core._nth.call(null,chunk__47042_47536,i__47044_47538);
fragment.appendChild(shadow.dom._to_dom.call(null,node_47539));


var G__47540 = seq__47041_47535;
var G__47541 = chunk__47042_47536;
var G__47542 = count__47043_47537;
var G__47543 = (i__47044_47538 + (1));
seq__47041_47535 = G__47540;
chunk__47042_47536 = G__47541;
count__47043_47537 = G__47542;
i__47044_47538 = G__47543;
continue;
} else {
var temp__5720__auto___47544 = cljs.core.seq.call(null,seq__47041_47535);
if(temp__5720__auto___47544){
var seq__47041_47545__$1 = temp__5720__auto___47544;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47041_47545__$1)){
var c__4550__auto___47547 = cljs.core.chunk_first.call(null,seq__47041_47545__$1);
var G__47549 = cljs.core.chunk_rest.call(null,seq__47041_47545__$1);
var G__47550 = c__4550__auto___47547;
var G__47551 = cljs.core.count.call(null,c__4550__auto___47547);
var G__47552 = (0);
seq__47041_47535 = G__47549;
chunk__47042_47536 = G__47550;
count__47043_47537 = G__47551;
i__47044_47538 = G__47552;
continue;
} else {
var node_47553 = cljs.core.first.call(null,seq__47041_47545__$1);
fragment.appendChild(shadow.dom._to_dom.call(null,node_47553));


var G__47554 = cljs.core.next.call(null,seq__47041_47545__$1);
var G__47555 = null;
var G__47556 = (0);
var G__47557 = (0);
seq__47041_47535 = G__47554;
chunk__47042_47536 = G__47555;
count__47043_47537 = G__47556;
i__47044_47538 = G__47557;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
});

shadow.dom.fragment.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
shadow.dom.fragment.cljs$lang$applyTo = (function (seq47040){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq47040));
});

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq.call(null,/<script[^>]*?>(.+?)<\/script>/,s);
var seq__47045_47559 = cljs.core.seq.call(null,scripts);
var chunk__47046_47560 = null;
var count__47047_47561 = (0);
var i__47048_47562 = (0);
while(true){
if((i__47048_47562 < count__47047_47561)){
var vec__47055_47564 = cljs.core._nth.call(null,chunk__47046_47560,i__47048_47562);
var script_tag_47565 = cljs.core.nth.call(null,vec__47055_47564,(0),null);
var script_body_47566 = cljs.core.nth.call(null,vec__47055_47564,(1),null);
eval(script_body_47566);


var G__47568 = seq__47045_47559;
var G__47569 = chunk__47046_47560;
var G__47570 = count__47047_47561;
var G__47571 = (i__47048_47562 + (1));
seq__47045_47559 = G__47568;
chunk__47046_47560 = G__47569;
count__47047_47561 = G__47570;
i__47048_47562 = G__47571;
continue;
} else {
var temp__5720__auto___47572 = cljs.core.seq.call(null,seq__47045_47559);
if(temp__5720__auto___47572){
var seq__47045_47573__$1 = temp__5720__auto___47572;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47045_47573__$1)){
var c__4550__auto___47574 = cljs.core.chunk_first.call(null,seq__47045_47573__$1);
var G__47575 = cljs.core.chunk_rest.call(null,seq__47045_47573__$1);
var G__47576 = c__4550__auto___47574;
var G__47577 = cljs.core.count.call(null,c__4550__auto___47574);
var G__47578 = (0);
seq__47045_47559 = G__47575;
chunk__47046_47560 = G__47576;
count__47047_47561 = G__47577;
i__47048_47562 = G__47578;
continue;
} else {
var vec__47058_47583 = cljs.core.first.call(null,seq__47045_47573__$1);
var script_tag_47584 = cljs.core.nth.call(null,vec__47058_47583,(0),null);
var script_body_47585 = cljs.core.nth.call(null,vec__47058_47583,(1),null);
eval(script_body_47585);


var G__47586 = cljs.core.next.call(null,seq__47045_47573__$1);
var G__47587 = null;
var G__47588 = (0);
var G__47589 = (0);
seq__47045_47559 = G__47586;
chunk__47046_47560 = G__47587;
count__47047_47561 = G__47588;
i__47048_47562 = G__47589;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.call(null,((function (scripts){
return (function (s__$1,p__47061){
var vec__47063 = p__47061;
var script_tag = cljs.core.nth.call(null,vec__47063,(0),null);
var script_body = cljs.core.nth.call(null,vec__47063,(1),null);
return clojure.string.replace.call(null,s__$1,script_tag,"");
});})(scripts))
,s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
el.innerHTML = s;

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node.call(null,el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node.call(null,el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__47070 = arguments.length;
switch (G__47070) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag));
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,tag),cljs.core.name.call(null,cls));
});

shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3;

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node.call(null,dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node.call(null,dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name.call(null,style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node.call(null,el);
return shadow.dom.remove_style_STAR_.call(null,el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node.call(null,el);
var seq__47081 = cljs.core.seq.call(null,style_keys);
var chunk__47082 = null;
var count__47083 = (0);
var i__47084 = (0);
while(true){
if((i__47084 < count__47083)){
var it = cljs.core._nth.call(null,chunk__47082,i__47084);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__47604 = seq__47081;
var G__47605 = chunk__47082;
var G__47606 = count__47083;
var G__47607 = (i__47084 + (1));
seq__47081 = G__47604;
chunk__47082 = G__47605;
count__47083 = G__47606;
i__47084 = G__47607;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__47081);
if(temp__5720__auto__){
var seq__47081__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47081__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__47081__$1);
var G__47608 = cljs.core.chunk_rest.call(null,seq__47081__$1);
var G__47609 = c__4550__auto__;
var G__47610 = cljs.core.count.call(null,c__4550__auto__);
var G__47611 = (0);
seq__47081 = G__47608;
chunk__47082 = G__47609;
count__47083 = G__47610;
i__47084 = G__47611;
continue;
} else {
var it = cljs.core.first.call(null,seq__47081__$1);
shadow.dom.remove_style_STAR_.call(null,el__$1,it);


var G__47614 = cljs.core.next.call(null,seq__47081__$1);
var G__47615 = null;
var G__47616 = (0);
var G__47617 = (0);
seq__47081 = G__47614;
chunk__47082 = G__47615;
count__47083 = G__47616;
i__47084 = G__47617;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k47090,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__47096 = k47090;
var G__47096__$1 = (((G__47096 instanceof cljs.core.Keyword))?G__47096.fqn:null);
switch (G__47096__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k47090,else__4388__auto__);

}
});

shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__47097){
var vec__47098 = p__47097;
var k__4408__auto__ = cljs.core.nth.call(null,vec__47098,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__47098,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47089){
var self__ = this;
var G__47089__$1 = this;
return (new cljs.core.RecordIter((0),G__47089__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
.call(null,this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47091,other47092){
var self__ = this;
var this47091__$1 = this;
return (((!((other47092 == null)))) && ((this47091__$1.constructor === other47092.constructor)) && (cljs.core._EQ_.call(null,this47091__$1.x,other47092.x)) && (cljs.core._EQ_.call(null,this47091__$1.y,other47092.y)) && (cljs.core._EQ_.call(null,this47091__$1.__extmap,other47092.__extmap)));
});

shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__47089){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__47112 = cljs.core.keyword_identical_QMARK_;
var expr__47113 = k__4393__auto__;
if(cljs.core.truth_(pred__47112.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__47113))){
return (new shadow.dom.Coordinate(G__47089,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47112.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__47113))){
return (new shadow.dom.Coordinate(self__.x,G__47089,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__47089),null));
}
}
});

shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__47089){
var self__ = this;
var this__4384__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__47089,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4391__auto__,(0)),cljs.core._nth.call(null,entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
});

shadow.dom.Coordinate.cljs$lang$type = true;

shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
});

shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"shadow.dom/Coordinate");
});

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__47094){
var extmap__4424__auto__ = (function (){var G__47122 = cljs.core.dissoc.call(null,G__47094,new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776));
if(cljs.core.record_QMARK_.call(null,G__47094)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__47122);
} else {
return G__47122;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__47094),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__47094),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node.call(null,el));
return shadow.dom.__GT_Coordinate.call(null,pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k47130,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__47141 = k47130;
var G__47141__$1 = (((G__47141 instanceof cljs.core.Keyword))?G__47141.fqn:null);
switch (G__47141__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k47130,else__4388__auto__);

}
});

shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__47143){
var vec__47145 = p__47143;
var k__4408__auto__ = cljs.core.nth.call(null,vec__47145,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__47145,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#shadow.dom.Size{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47129){
var self__ = this;
var G__47129__$1 = this;
return (new cljs.core.RecordIter((0),G__47129__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
.call(null,this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47131,other47132){
var self__ = this;
var this47131__$1 = this;
return (((!((other47132 == null)))) && ((this47131__$1.constructor === other47132.constructor)) && (cljs.core._EQ_.call(null,this47131__$1.w,other47132.w)) && (cljs.core._EQ_.call(null,this47131__$1.h,other47132.h)) && (cljs.core._EQ_.call(null,this47131__$1.__extmap,other47132.__extmap)));
});

shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__47129){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__47153 = cljs.core.keyword_identical_QMARK_;
var expr__47154 = k__4393__auto__;
if(cljs.core.truth_(pred__47153.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__47154))){
return (new shadow.dom.Size(G__47129,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47153.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__47154))){
return (new shadow.dom.Size(self__.w,G__47129,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__47129),null));
}
}
});

shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__47129){
var self__ = this;
var this__4384__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__47129,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4391__auto__,(0)),cljs.core._nth.call(null,entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
});

shadow.dom.Size.cljs$lang$type = true;

shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
});

shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"shadow.dom/Size");
});

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__47135){
var extmap__4424__auto__ = (function (){var G__47156 = cljs.core.dissoc.call(null,G__47135,new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740));
if(cljs.core.record_QMARK_.call(null,G__47135)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__47156);
} else {
return G__47156;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__47135),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__47135),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj.call(null,goog.style.getSize(shadow.dom.dom_node.call(null,el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(shadow.dom.get_size.call(null,el));
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj.call(null,goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node.call(null,el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node.call(null,el);
var opts = (native$["options"]);
var a__4604__auto__ = opts;
var l__4605__auto__ = a__4604__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4605__auto__)){
var G__47658 = (i + (1));
var G__47659 = cljs.core.conj.call(null,ret,(opts[i]["value"]));
i = G__47658;
ret = G__47659;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_.call(null,query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p__47167){
var vec__47168 = p__47167;
var k = cljs.core.nth.call(null,vec__47168,(0),null);
var v = cljs.core.nth.call(null,vec__47168,(1),null);
return [cljs.core.name.call(null,k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params)))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__47172 = arguments.length;
switch (G__47172) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.call(null,path,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url.call(null,path,query_params));
});

shadow.dom.redirect.cljs$lang$maxFixedArity = 2;

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return document.location.href = document.location.href;
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node.call(null,el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node.call(null,new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node.call(null,ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node.call(null,ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before.call(null,child,new$);
} else {
return shadow.dom.append.call(null,ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node.call(null,el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__47676 = ps;
var G__47677 = (i + (1));
el__$1 = G__47676;
i = G__47677;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node.call(null,el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent.call(null,el);
if(cljs.core.truth_(parent)){
return cljs.core.cons.call(null,parent,(new cljs.core.LazySeq(null,((function (parent){
return (function (){
return shadow.dom.parents.call(null,parent);
});})(parent))
,null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node.call(null,el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node.call(null,el));
});
shadow.dom.xmlns = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__47179 = shadow.dom.parse_tag.call(null,tag_def);
var tag_name = cljs.core.nth.call(null,vec__47179,(0),null);
var tag_id = cljs.core.nth.call(null,vec__47179,(1),null);
var tag_classes = cljs.core.nth.call(null,vec__47179,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string.call(null,new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__47184_47681 = cljs.core.seq.call(null,props);
var chunk__47185_47682 = null;
var count__47186_47683 = (0);
var i__47187_47684 = (0);
while(true){
if((i__47187_47684 < count__47186_47683)){
var vec__47200_47689 = cljs.core._nth.call(null,chunk__47185_47682,i__47187_47684);
var k_47690 = cljs.core.nth.call(null,vec__47200_47689,(0),null);
var v_47691 = cljs.core.nth.call(null,vec__47200_47689,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace.call(null,k_47690);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_47690),v_47691);


var G__47696 = seq__47184_47681;
var G__47697 = chunk__47185_47682;
var G__47698 = count__47186_47683;
var G__47699 = (i__47187_47684 + (1));
seq__47184_47681 = G__47696;
chunk__47185_47682 = G__47697;
count__47186_47683 = G__47698;
i__47187_47684 = G__47699;
continue;
} else {
var temp__5720__auto___47700 = cljs.core.seq.call(null,seq__47184_47681);
if(temp__5720__auto___47700){
var seq__47184_47701__$1 = temp__5720__auto___47700;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47184_47701__$1)){
var c__4550__auto___47702 = cljs.core.chunk_first.call(null,seq__47184_47701__$1);
var G__47704 = cljs.core.chunk_rest.call(null,seq__47184_47701__$1);
var G__47705 = c__4550__auto___47702;
var G__47706 = cljs.core.count.call(null,c__4550__auto___47702);
var G__47707 = (0);
seq__47184_47681 = G__47704;
chunk__47185_47682 = G__47705;
count__47186_47683 = G__47706;
i__47187_47684 = G__47707;
continue;
} else {
var vec__47204_47711 = cljs.core.first.call(null,seq__47184_47701__$1);
var k_47712 = cljs.core.nth.call(null,vec__47204_47711,(0),null);
var v_47713 = cljs.core.nth.call(null,vec__47204_47711,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace.call(null,k_47712);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name.call(null,k_47712),v_47713);


var G__47715 = cljs.core.next.call(null,seq__47184_47701__$1);
var G__47716 = null;
var G__47717 = (0);
var G__47718 = (0);
seq__47184_47681 = G__47715;
chunk__47185_47682 = G__47716;
count__47186_47683 = G__47717;
i__47187_47684 = G__47718;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return shadow.dom._to_svg.call(null,el);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__47212 = shadow.dom.destructure_node.call(null,shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.call(null,vec__47212,(0),null);
var node_children = cljs.core.nth.call(null,vec__47212,(1),null);
var seq__47216_47734 = cljs.core.seq.call(null,node_children);
var chunk__47218_47735 = null;
var count__47219_47736 = (0);
var i__47220_47737 = (0);
while(true){
if((i__47220_47737 < count__47219_47736)){
var child_struct_47740 = cljs.core._nth.call(null,chunk__47218_47735,i__47220_47737);
if((!((child_struct_47740 == null)))){
if(typeof child_struct_47740 === 'string'){
var text_47742 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47742),child_struct_47740].join(''));
} else {
var children_47743 = shadow.dom.svg_node.call(null,child_struct_47740);
if(cljs.core.seq_QMARK_.call(null,children_47743)){
var seq__47251_47744 = cljs.core.seq.call(null,children_47743);
var chunk__47253_47745 = null;
var count__47254_47746 = (0);
var i__47255_47747 = (0);
while(true){
if((i__47255_47747 < count__47254_47746)){
var child_47749 = cljs.core._nth.call(null,chunk__47253_47745,i__47255_47747);
if(cljs.core.truth_(child_47749)){
node.appendChild(child_47749);


var G__47751 = seq__47251_47744;
var G__47752 = chunk__47253_47745;
var G__47753 = count__47254_47746;
var G__47754 = (i__47255_47747 + (1));
seq__47251_47744 = G__47751;
chunk__47253_47745 = G__47752;
count__47254_47746 = G__47753;
i__47255_47747 = G__47754;
continue;
} else {
var G__47756 = seq__47251_47744;
var G__47757 = chunk__47253_47745;
var G__47758 = count__47254_47746;
var G__47759 = (i__47255_47747 + (1));
seq__47251_47744 = G__47756;
chunk__47253_47745 = G__47757;
count__47254_47746 = G__47758;
i__47255_47747 = G__47759;
continue;
}
} else {
var temp__5720__auto___47760 = cljs.core.seq.call(null,seq__47251_47744);
if(temp__5720__auto___47760){
var seq__47251_47761__$1 = temp__5720__auto___47760;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47251_47761__$1)){
var c__4550__auto___47763 = cljs.core.chunk_first.call(null,seq__47251_47761__$1);
var G__47764 = cljs.core.chunk_rest.call(null,seq__47251_47761__$1);
var G__47765 = c__4550__auto___47763;
var G__47766 = cljs.core.count.call(null,c__4550__auto___47763);
var G__47767 = (0);
seq__47251_47744 = G__47764;
chunk__47253_47745 = G__47765;
count__47254_47746 = G__47766;
i__47255_47747 = G__47767;
continue;
} else {
var child_47768 = cljs.core.first.call(null,seq__47251_47761__$1);
if(cljs.core.truth_(child_47768)){
node.appendChild(child_47768);


var G__47770 = cljs.core.next.call(null,seq__47251_47761__$1);
var G__47771 = null;
var G__47772 = (0);
var G__47773 = (0);
seq__47251_47744 = G__47770;
chunk__47253_47745 = G__47771;
count__47254_47746 = G__47772;
i__47255_47747 = G__47773;
continue;
} else {
var G__47775 = cljs.core.next.call(null,seq__47251_47761__$1);
var G__47776 = null;
var G__47777 = (0);
var G__47778 = (0);
seq__47251_47744 = G__47775;
chunk__47253_47745 = G__47776;
count__47254_47746 = G__47777;
i__47255_47747 = G__47778;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47743);
}
}


var G__47780 = seq__47216_47734;
var G__47781 = chunk__47218_47735;
var G__47782 = count__47219_47736;
var G__47783 = (i__47220_47737 + (1));
seq__47216_47734 = G__47780;
chunk__47218_47735 = G__47781;
count__47219_47736 = G__47782;
i__47220_47737 = G__47783;
continue;
} else {
var G__47784 = seq__47216_47734;
var G__47785 = chunk__47218_47735;
var G__47786 = count__47219_47736;
var G__47787 = (i__47220_47737 + (1));
seq__47216_47734 = G__47784;
chunk__47218_47735 = G__47785;
count__47219_47736 = G__47786;
i__47220_47737 = G__47787;
continue;
}
} else {
var temp__5720__auto___47789 = cljs.core.seq.call(null,seq__47216_47734);
if(temp__5720__auto___47789){
var seq__47216_47790__$1 = temp__5720__auto___47789;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47216_47790__$1)){
var c__4550__auto___47791 = cljs.core.chunk_first.call(null,seq__47216_47790__$1);
var G__47792 = cljs.core.chunk_rest.call(null,seq__47216_47790__$1);
var G__47793 = c__4550__auto___47791;
var G__47794 = cljs.core.count.call(null,c__4550__auto___47791);
var G__47795 = (0);
seq__47216_47734 = G__47792;
chunk__47218_47735 = G__47793;
count__47219_47736 = G__47794;
i__47220_47737 = G__47795;
continue;
} else {
var child_struct_47797 = cljs.core.first.call(null,seq__47216_47790__$1);
if((!((child_struct_47797 == null)))){
if(typeof child_struct_47797 === 'string'){
var text_47799 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47799),child_struct_47797].join(''));
} else {
var children_47800 = shadow.dom.svg_node.call(null,child_struct_47797);
if(cljs.core.seq_QMARK_.call(null,children_47800)){
var seq__47267_47801 = cljs.core.seq.call(null,children_47800);
var chunk__47269_47802 = null;
var count__47270_47803 = (0);
var i__47271_47804 = (0);
while(true){
if((i__47271_47804 < count__47270_47803)){
var child_47805 = cljs.core._nth.call(null,chunk__47269_47802,i__47271_47804);
if(cljs.core.truth_(child_47805)){
node.appendChild(child_47805);


var G__47806 = seq__47267_47801;
var G__47807 = chunk__47269_47802;
var G__47808 = count__47270_47803;
var G__47809 = (i__47271_47804 + (1));
seq__47267_47801 = G__47806;
chunk__47269_47802 = G__47807;
count__47270_47803 = G__47808;
i__47271_47804 = G__47809;
continue;
} else {
var G__47810 = seq__47267_47801;
var G__47811 = chunk__47269_47802;
var G__47812 = count__47270_47803;
var G__47813 = (i__47271_47804 + (1));
seq__47267_47801 = G__47810;
chunk__47269_47802 = G__47811;
count__47270_47803 = G__47812;
i__47271_47804 = G__47813;
continue;
}
} else {
var temp__5720__auto___47814__$1 = cljs.core.seq.call(null,seq__47267_47801);
if(temp__5720__auto___47814__$1){
var seq__47267_47815__$1 = temp__5720__auto___47814__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47267_47815__$1)){
var c__4550__auto___47816 = cljs.core.chunk_first.call(null,seq__47267_47815__$1);
var G__47818 = cljs.core.chunk_rest.call(null,seq__47267_47815__$1);
var G__47819 = c__4550__auto___47816;
var G__47820 = cljs.core.count.call(null,c__4550__auto___47816);
var G__47821 = (0);
seq__47267_47801 = G__47818;
chunk__47269_47802 = G__47819;
count__47270_47803 = G__47820;
i__47271_47804 = G__47821;
continue;
} else {
var child_47822 = cljs.core.first.call(null,seq__47267_47815__$1);
if(cljs.core.truth_(child_47822)){
node.appendChild(child_47822);


var G__47823 = cljs.core.next.call(null,seq__47267_47815__$1);
var G__47824 = null;
var G__47825 = (0);
var G__47826 = (0);
seq__47267_47801 = G__47823;
chunk__47269_47802 = G__47824;
count__47270_47803 = G__47825;
i__47271_47804 = G__47826;
continue;
} else {
var G__47829 = cljs.core.next.call(null,seq__47267_47815__$1);
var G__47830 = null;
var G__47831 = (0);
var G__47832 = (0);
seq__47267_47801 = G__47829;
chunk__47269_47802 = G__47830;
count__47270_47803 = G__47831;
i__47271_47804 = G__47832;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47800);
}
}


var G__47836 = cljs.core.next.call(null,seq__47216_47790__$1);
var G__47837 = null;
var G__47838 = (0);
var G__47839 = (0);
seq__47216_47734 = G__47836;
chunk__47218_47735 = G__47837;
count__47219_47736 = G__47838;
i__47220_47737 = G__47839;
continue;
} else {
var G__47840 = cljs.core.next.call(null,seq__47216_47790__$1);
var G__47841 = null;
var G__47842 = (0);
var G__47843 = (0);
seq__47216_47734 = G__47840;
chunk__47218_47735 = G__47841;
count__47219_47736 = G__47842;
i__47220_47737 = G__47843;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.call(null,"strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node.call(null,this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.call(null,shadow.dom._to_svg,this$__$1);
});

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4736__auto__ = [];
var len__4730__auto___47846 = arguments.length;
var i__4731__auto___47847 = (0);
while(true){
if((i__4731__auto___47847 < len__4730__auto___47846)){
args__4736__auto__.push((arguments[i__4731__auto___47847]));

var G__47848 = (i__4731__auto___47847 + (1));
i__4731__auto___47847 = G__47848;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg.call(null,cljs.core.vec.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
});

shadow.dom.svg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.dom.svg.cljs$lang$applyTo = (function (seq47275){
var G__47276 = cljs.core.first.call(null,seq47275);
var seq47275__$1 = cljs.core.next.call(null,seq47275);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47276,seq47275__$1);
});

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__47279 = arguments.length;
switch (G__47279) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.call(null,el,event,null,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.call(null,el,event,xf,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer.call(null,(1));
var chan = cljs.core.async.chan.call(null,buf,xf);
var event_fn = ((function (buf,chan){
return (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.call(null,chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler.call(null,el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_.call(null,chan);
} else {
return null;
}
});})(buf,chan))
;
shadow.dom.dom_listen.call(null,shadow.dom.dom_node.call(null,el),cljs.core.name.call(null,event),event_fn);

if(cljs.core.truth_((function (){var and__4120__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4120__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4120__auto__;
}
})())){
var c__45200__auto___47859 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___47859,buf,chan,event_fn){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___47859,buf,chan,event_fn){
return (function (state_47285){
var state_val_47286 = (state_47285[(1)]);
if((state_val_47286 === (1))){
var state_47285__$1 = state_47285;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47285__$1,(2),once_or_cleanup);
} else {
if((state_val_47286 === (2))){
var inst_47282 = (state_47285[(2)]);
var inst_47283 = shadow.dom.remove_event_handler.call(null,el,event,event_fn);
var state_47285__$1 = (function (){var statearr_47287 = state_47285;
(statearr_47287[(7)] = inst_47282);

return statearr_47287;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47285__$1,inst_47283);
} else {
return null;
}
}
});})(c__45200__auto___47859,buf,chan,event_fn))
;
return ((function (switch__45112__auto__,c__45200__auto___47859,buf,chan,event_fn){
return (function() {
var shadow$dom$state_machine__45113__auto__ = null;
var shadow$dom$state_machine__45113__auto____0 = (function (){
var statearr_47289 = [null,null,null,null,null,null,null,null];
(statearr_47289[(0)] = shadow$dom$state_machine__45113__auto__);

(statearr_47289[(1)] = (1));

return statearr_47289;
});
var shadow$dom$state_machine__45113__auto____1 = (function (state_47285){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_47285);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e47291){if((e47291 instanceof Object)){
var ex__45116__auto__ = e47291;
var statearr_47292_47869 = state_47285;
(statearr_47292_47869[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47285);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47291;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47874 = state_47285;
state_47285 = G__47874;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
shadow$dom$state_machine__45113__auto__ = function(state_47285){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__45113__auto____0.call(this);
case 1:
return shadow$dom$state_machine__45113__auto____1.call(this,state_47285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__45113__auto____0;
shadow$dom$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__45113__auto____1;
return shadow$dom$state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___47859,buf,chan,event_fn))
})();
var state__45202__auto__ = (function (){var statearr_47295 = f__45201__auto__.call(null);
(statearr_47295[(6)] = c__45200__auto___47859);

return statearr_47295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___47859,buf,chan,event_fn))
);

} else {
}

return chan;
});

shadow.dom.event_chan.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=shadow.dom.js.map
