goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__45261 = arguments.length;
switch (G__45261) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45262 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45262 = (function (f,blockable,meta45263){
this.f = f;
this.blockable = blockable;
this.meta45263 = meta45263;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async45262.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45264,meta45263__$1){
var self__ = this;
var _45264__$1 = this;
return (new cljs.core.async.t_cljs$core$async45262(self__.f,self__.blockable,meta45263__$1));
});

cljs.core.async.t_cljs$core$async45262.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45264){
var self__ = this;
var _45264__$1 = this;
return self__.meta45263;
});

cljs.core.async.t_cljs$core$async45262.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async45262.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async45262.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async45262.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async45262.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta45263","meta45263",-1213527839,null)], null);
});

cljs.core.async.t_cljs$core$async45262.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async45262.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45262";

cljs.core.async.t_cljs$core$async45262.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async45262");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45262.
 */
cljs.core.async.__GT_t_cljs$core$async45262 = (function cljs$core$async$__GT_t_cljs$core$async45262(f__$1,blockable__$1,meta45263){
return (new cljs.core.async.t_cljs$core$async45262(f__$1,blockable__$1,meta45263));
});

}

return (new cljs.core.async.t_cljs$core$async45262(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__45267 = arguments.length;
switch (G__45267) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__45269 = arguments.length;
switch (G__45269) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__45271 = arguments.length;
switch (G__45271) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_46708 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_46708);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_46708,ret){
return (function (){
return fn1.call(null,val_46708);
});})(val_46708,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__45273 = arguments.length;
switch (G__45273) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5718__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5718__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___46733 = n;
var x_46735 = (0);
while(true){
if((x_46735 < n__4607__auto___46733)){
(a[x_46735] = x_46735);

var G__46736 = (x_46735 + (1));
x_46735 = G__46736;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45274 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45274 = (function (flag,meta45275){
this.flag = flag;
this.meta45275 = meta45275;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async45274.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_45276,meta45275__$1){
var self__ = this;
var _45276__$1 = this;
return (new cljs.core.async.t_cljs$core$async45274(self__.flag,meta45275__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async45274.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_45276){
var self__ = this;
var _45276__$1 = this;
return self__.meta45275;
});})(flag))
;

cljs.core.async.t_cljs$core$async45274.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async45274.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async45274.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async45274.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async45274.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta45275","meta45275",-967321289,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async45274.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async45274.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45274";

cljs.core.async.t_cljs$core$async45274.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async45274");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45274.
 */
cljs.core.async.__GT_t_cljs$core$async45274 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async45274(flag__$1,meta45275){
return (new cljs.core.async.t_cljs$core$async45274(flag__$1,meta45275));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async45274(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45277 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45277 = (function (flag,cb,meta45278){
this.flag = flag;
this.cb = cb;
this.meta45278 = meta45278;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async45277.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45279,meta45278__$1){
var self__ = this;
var _45279__$1 = this;
return (new cljs.core.async.t_cljs$core$async45277(self__.flag,self__.cb,meta45278__$1));
});

cljs.core.async.t_cljs$core$async45277.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45279){
var self__ = this;
var _45279__$1 = this;
return self__.meta45278;
});

cljs.core.async.t_cljs$core$async45277.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async45277.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async45277.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async45277.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async45277.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta45278","meta45278",1297532003,null)], null);
});

cljs.core.async.t_cljs$core$async45277.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async45277.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45277";

cljs.core.async.t_cljs$core$async45277.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async45277");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45277.
 */
cljs.core.async.__GT_t_cljs$core$async45277 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async45277(flag__$1,cb__$1,meta45278){
return (new cljs.core.async.t_cljs$core$async45277(flag__$1,cb__$1,meta45278));
});

}

return (new cljs.core.async.t_cljs$core$async45277(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__45280_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__45280_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__45281_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__45281_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__46757 = (i + (1));
i = G__46757;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4120__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___46766 = arguments.length;
var i__4731__auto___46767 = (0);
while(true){
if((i__4731__auto___46767 < len__4730__auto___46766)){
args__4736__auto__.push((arguments[i__4731__auto___46767]));

var G__46768 = (i__4731__auto___46767 + (1));
i__4731__auto___46767 = G__46768;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__45284){
var map__45285 = p__45284;
var map__45285__$1 = (((((!((map__45285 == null))))?(((((map__45285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45285.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45285):map__45285);
var opts = map__45285__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq45282){
var G__45283 = cljs.core.first.call(null,seq45282);
var seq45282__$1 = cljs.core.next.call(null,seq45282);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45283,seq45282__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__45288 = arguments.length;
switch (G__45288) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__45200__auto___46788 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___46788){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___46788){
return (function (state_45312){
var state_val_45313 = (state_45312[(1)]);
if((state_val_45313 === (7))){
var inst_45308 = (state_45312[(2)]);
var state_45312__$1 = state_45312;
var statearr_45314_46791 = state_45312__$1;
(statearr_45314_46791[(2)] = inst_45308);

(statearr_45314_46791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45313 === (1))){
var state_45312__$1 = state_45312;
var statearr_45315_46794 = state_45312__$1;
(statearr_45315_46794[(2)] = null);

(statearr_45315_46794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45313 === (4))){
var inst_45291 = (state_45312[(7)]);
var inst_45291__$1 = (state_45312[(2)]);
var inst_45292 = (inst_45291__$1 == null);
var state_45312__$1 = (function (){var statearr_45316 = state_45312;
(statearr_45316[(7)] = inst_45291__$1);

return statearr_45316;
})();
if(cljs.core.truth_(inst_45292)){
var statearr_45317_46795 = state_45312__$1;
(statearr_45317_46795[(1)] = (5));

} else {
var statearr_45318_46796 = state_45312__$1;
(statearr_45318_46796[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45313 === (13))){
var state_45312__$1 = state_45312;
var statearr_45319_46797 = state_45312__$1;
(statearr_45319_46797[(2)] = null);

(statearr_45319_46797[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45313 === (6))){
var inst_45291 = (state_45312[(7)]);
var state_45312__$1 = state_45312;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45312__$1,(11),to,inst_45291);
} else {
if((state_val_45313 === (3))){
var inst_45310 = (state_45312[(2)]);
var state_45312__$1 = state_45312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45312__$1,inst_45310);
} else {
if((state_val_45313 === (12))){
var state_45312__$1 = state_45312;
var statearr_45320_46798 = state_45312__$1;
(statearr_45320_46798[(2)] = null);

(statearr_45320_46798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45313 === (2))){
var state_45312__$1 = state_45312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45312__$1,(4),from);
} else {
if((state_val_45313 === (11))){
var inst_45301 = (state_45312[(2)]);
var state_45312__$1 = state_45312;
if(cljs.core.truth_(inst_45301)){
var statearr_45321_46799 = state_45312__$1;
(statearr_45321_46799[(1)] = (12));

} else {
var statearr_45322_46800 = state_45312__$1;
(statearr_45322_46800[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45313 === (9))){
var state_45312__$1 = state_45312;
var statearr_45323_46801 = state_45312__$1;
(statearr_45323_46801[(2)] = null);

(statearr_45323_46801[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45313 === (5))){
var state_45312__$1 = state_45312;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45324_46802 = state_45312__$1;
(statearr_45324_46802[(1)] = (8));

} else {
var statearr_45325_46803 = state_45312__$1;
(statearr_45325_46803[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45313 === (14))){
var inst_45306 = (state_45312[(2)]);
var state_45312__$1 = state_45312;
var statearr_45326_46811 = state_45312__$1;
(statearr_45326_46811[(2)] = inst_45306);

(statearr_45326_46811[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45313 === (10))){
var inst_45298 = (state_45312[(2)]);
var state_45312__$1 = state_45312;
var statearr_45327_46812 = state_45312__$1;
(statearr_45327_46812[(2)] = inst_45298);

(statearr_45327_46812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45313 === (8))){
var inst_45295 = cljs.core.async.close_BANG_.call(null,to);
var state_45312__$1 = state_45312;
var statearr_45328_46813 = state_45312__$1;
(statearr_45328_46813[(2)] = inst_45295);

(statearr_45328_46813[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___46788))
;
return ((function (switch__45112__auto__,c__45200__auto___46788){
return (function() {
var cljs$core$async$state_machine__45113__auto__ = null;
var cljs$core$async$state_machine__45113__auto____0 = (function (){
var statearr_45329 = [null,null,null,null,null,null,null,null];
(statearr_45329[(0)] = cljs$core$async$state_machine__45113__auto__);

(statearr_45329[(1)] = (1));

return statearr_45329;
});
var cljs$core$async$state_machine__45113__auto____1 = (function (state_45312){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_45312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e45330){if((e45330 instanceof Object)){
var ex__45116__auto__ = e45330;
var statearr_45331_46818 = state_45312;
(statearr_45331_46818[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45312);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45330;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46820 = state_45312;
state_45312 = G__46820;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$state_machine__45113__auto__ = function(state_45312){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45113__auto____1.call(this,state_45312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45113__auto____0;
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45113__auto____1;
return cljs$core$async$state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___46788))
})();
var state__45202__auto__ = (function (){var statearr_45332 = f__45201__auto__.call(null);
(statearr_45332[(6)] = c__45200__auto___46788);

return statearr_45332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___46788))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__45333){
var vec__45334 = p__45333;
var v = cljs.core.nth.call(null,vec__45334,(0),null);
var p = cljs.core.nth.call(null,vec__45334,(1),null);
var job = vec__45334;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__45200__auto___46826 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___46826,res,vec__45334,v,p,job,jobs,results){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___46826,res,vec__45334,v,p,job,jobs,results){
return (function (state_45341){
var state_val_45342 = (state_45341[(1)]);
if((state_val_45342 === (1))){
var state_45341__$1 = state_45341;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45341__$1,(2),res,v);
} else {
if((state_val_45342 === (2))){
var inst_45338 = (state_45341[(2)]);
var inst_45339 = cljs.core.async.close_BANG_.call(null,res);
var state_45341__$1 = (function (){var statearr_45343 = state_45341;
(statearr_45343[(7)] = inst_45338);

return statearr_45343;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45341__$1,inst_45339);
} else {
return null;
}
}
});})(c__45200__auto___46826,res,vec__45334,v,p,job,jobs,results))
;
return ((function (switch__45112__auto__,c__45200__auto___46826,res,vec__45334,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0 = (function (){
var statearr_45344 = [null,null,null,null,null,null,null,null];
(statearr_45344[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__);

(statearr_45344[(1)] = (1));

return statearr_45344;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1 = (function (state_45341){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_45341);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e45345){if((e45345 instanceof Object)){
var ex__45116__auto__ = e45345;
var statearr_45346_46831 = state_45341;
(statearr_45346_46831[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45341);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45345;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46832 = state_45341;
state_45341 = G__46832;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__ = function(state_45341){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1.call(this,state_45341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___46826,res,vec__45334,v,p,job,jobs,results))
})();
var state__45202__auto__ = (function (){var statearr_45347 = f__45201__auto__.call(null);
(statearr_45347[(6)] = c__45200__auto___46826);

return statearr_45347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___46826,res,vec__45334,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__45348){
var vec__45349 = p__45348;
var v = cljs.core.nth.call(null,vec__45349,(0),null);
var p = cljs.core.nth.call(null,vec__45349,(1),null);
var job = vec__45349;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___46835 = n;
var __46836 = (0);
while(true){
if((__46836 < n__4607__auto___46835)){
var G__45352_46837 = type;
var G__45352_46838__$1 = (((G__45352_46837 instanceof cljs.core.Keyword))?G__45352_46837.fqn:null);
switch (G__45352_46838__$1) {
case "compute":
var c__45200__auto___46840 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__46836,c__45200__auto___46840,G__45352_46837,G__45352_46838__$1,n__4607__auto___46835,jobs,results,process,async){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (__46836,c__45200__auto___46840,G__45352_46837,G__45352_46838__$1,n__4607__auto___46835,jobs,results,process,async){
return (function (state_45365){
var state_val_45366 = (state_45365[(1)]);
if((state_val_45366 === (1))){
var state_45365__$1 = state_45365;
var statearr_45367_46841 = state_45365__$1;
(statearr_45367_46841[(2)] = null);

(statearr_45367_46841[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45366 === (2))){
var state_45365__$1 = state_45365;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45365__$1,(4),jobs);
} else {
if((state_val_45366 === (3))){
var inst_45363 = (state_45365[(2)]);
var state_45365__$1 = state_45365;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45365__$1,inst_45363);
} else {
if((state_val_45366 === (4))){
var inst_45355 = (state_45365[(2)]);
var inst_45356 = process.call(null,inst_45355);
var state_45365__$1 = state_45365;
if(cljs.core.truth_(inst_45356)){
var statearr_45368_46844 = state_45365__$1;
(statearr_45368_46844[(1)] = (5));

} else {
var statearr_45369_46845 = state_45365__$1;
(statearr_45369_46845[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45366 === (5))){
var state_45365__$1 = state_45365;
var statearr_45370_46846 = state_45365__$1;
(statearr_45370_46846[(2)] = null);

(statearr_45370_46846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45366 === (6))){
var state_45365__$1 = state_45365;
var statearr_45371_46847 = state_45365__$1;
(statearr_45371_46847[(2)] = null);

(statearr_45371_46847[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45366 === (7))){
var inst_45361 = (state_45365[(2)]);
var state_45365__$1 = state_45365;
var statearr_45372_46848 = state_45365__$1;
(statearr_45372_46848[(2)] = inst_45361);

(statearr_45372_46848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46836,c__45200__auto___46840,G__45352_46837,G__45352_46838__$1,n__4607__auto___46835,jobs,results,process,async))
;
return ((function (__46836,switch__45112__auto__,c__45200__auto___46840,G__45352_46837,G__45352_46838__$1,n__4607__auto___46835,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0 = (function (){
var statearr_45373 = [null,null,null,null,null,null,null];
(statearr_45373[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__);

(statearr_45373[(1)] = (1));

return statearr_45373;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1 = (function (state_45365){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_45365);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e45374){if((e45374 instanceof Object)){
var ex__45116__auto__ = e45374;
var statearr_45375_46851 = state_45365;
(statearr_45375_46851[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45365);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45374;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46857 = state_45365;
state_45365 = G__46857;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__ = function(state_45365){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1.call(this,state_45365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__;
})()
;})(__46836,switch__45112__auto__,c__45200__auto___46840,G__45352_46837,G__45352_46838__$1,n__4607__auto___46835,jobs,results,process,async))
})();
var state__45202__auto__ = (function (){var statearr_45376 = f__45201__auto__.call(null);
(statearr_45376[(6)] = c__45200__auto___46840);

return statearr_45376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(__46836,c__45200__auto___46840,G__45352_46837,G__45352_46838__$1,n__4607__auto___46835,jobs,results,process,async))
);


break;
case "async":
var c__45200__auto___46858 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__46836,c__45200__auto___46858,G__45352_46837,G__45352_46838__$1,n__4607__auto___46835,jobs,results,process,async){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (__46836,c__45200__auto___46858,G__45352_46837,G__45352_46838__$1,n__4607__auto___46835,jobs,results,process,async){
return (function (state_45389){
var state_val_45390 = (state_45389[(1)]);
if((state_val_45390 === (1))){
var state_45389__$1 = state_45389;
var statearr_45391_46859 = state_45389__$1;
(statearr_45391_46859[(2)] = null);

(statearr_45391_46859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45390 === (2))){
var state_45389__$1 = state_45389;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45389__$1,(4),jobs);
} else {
if((state_val_45390 === (3))){
var inst_45387 = (state_45389[(2)]);
var state_45389__$1 = state_45389;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45389__$1,inst_45387);
} else {
if((state_val_45390 === (4))){
var inst_45379 = (state_45389[(2)]);
var inst_45380 = async.call(null,inst_45379);
var state_45389__$1 = state_45389;
if(cljs.core.truth_(inst_45380)){
var statearr_45392_46860 = state_45389__$1;
(statearr_45392_46860[(1)] = (5));

} else {
var statearr_45393_46861 = state_45389__$1;
(statearr_45393_46861[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45390 === (5))){
var state_45389__$1 = state_45389;
var statearr_45394_46863 = state_45389__$1;
(statearr_45394_46863[(2)] = null);

(statearr_45394_46863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45390 === (6))){
var state_45389__$1 = state_45389;
var statearr_45395_46865 = state_45389__$1;
(statearr_45395_46865[(2)] = null);

(statearr_45395_46865[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45390 === (7))){
var inst_45385 = (state_45389[(2)]);
var state_45389__$1 = state_45389;
var statearr_45396_46866 = state_45389__$1;
(statearr_45396_46866[(2)] = inst_45385);

(statearr_45396_46866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__46836,c__45200__auto___46858,G__45352_46837,G__45352_46838__$1,n__4607__auto___46835,jobs,results,process,async))
;
return ((function (__46836,switch__45112__auto__,c__45200__auto___46858,G__45352_46837,G__45352_46838__$1,n__4607__auto___46835,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0 = (function (){
var statearr_45397 = [null,null,null,null,null,null,null];
(statearr_45397[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__);

(statearr_45397[(1)] = (1));

return statearr_45397;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1 = (function (state_45389){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_45389);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e45398){if((e45398 instanceof Object)){
var ex__45116__auto__ = e45398;
var statearr_45399_46867 = state_45389;
(statearr_45399_46867[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45389);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45398;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46868 = state_45389;
state_45389 = G__46868;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__ = function(state_45389){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1.call(this,state_45389);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__;
})()
;})(__46836,switch__45112__auto__,c__45200__auto___46858,G__45352_46837,G__45352_46838__$1,n__4607__auto___46835,jobs,results,process,async))
})();
var state__45202__auto__ = (function (){var statearr_45400 = f__45201__auto__.call(null);
(statearr_45400[(6)] = c__45200__auto___46858);

return statearr_45400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(__46836,c__45200__auto___46858,G__45352_46837,G__45352_46838__$1,n__4607__auto___46835,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__45352_46838__$1)].join('')));

}

var G__46873 = (__46836 + (1));
__46836 = G__46873;
continue;
} else {
}
break;
}

var c__45200__auto___46874 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___46874,jobs,results,process,async){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___46874,jobs,results,process,async){
return (function (state_45422){
var state_val_45423 = (state_45422[(1)]);
if((state_val_45423 === (7))){
var inst_45418 = (state_45422[(2)]);
var state_45422__$1 = state_45422;
var statearr_45424_46878 = state_45422__$1;
(statearr_45424_46878[(2)] = inst_45418);

(statearr_45424_46878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45423 === (1))){
var state_45422__$1 = state_45422;
var statearr_45425_46879 = state_45422__$1;
(statearr_45425_46879[(2)] = null);

(statearr_45425_46879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45423 === (4))){
var inst_45403 = (state_45422[(7)]);
var inst_45403__$1 = (state_45422[(2)]);
var inst_45404 = (inst_45403__$1 == null);
var state_45422__$1 = (function (){var statearr_45426 = state_45422;
(statearr_45426[(7)] = inst_45403__$1);

return statearr_45426;
})();
if(cljs.core.truth_(inst_45404)){
var statearr_45427_46886 = state_45422__$1;
(statearr_45427_46886[(1)] = (5));

} else {
var statearr_45428_46887 = state_45422__$1;
(statearr_45428_46887[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45423 === (6))){
var inst_45403 = (state_45422[(7)]);
var inst_45408 = (state_45422[(8)]);
var inst_45408__$1 = cljs.core.async.chan.call(null,(1));
var inst_45409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45410 = [inst_45403,inst_45408__$1];
var inst_45411 = (new cljs.core.PersistentVector(null,2,(5),inst_45409,inst_45410,null));
var state_45422__$1 = (function (){var statearr_45429 = state_45422;
(statearr_45429[(8)] = inst_45408__$1);

return statearr_45429;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45422__$1,(8),jobs,inst_45411);
} else {
if((state_val_45423 === (3))){
var inst_45420 = (state_45422[(2)]);
var state_45422__$1 = state_45422;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45422__$1,inst_45420);
} else {
if((state_val_45423 === (2))){
var state_45422__$1 = state_45422;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45422__$1,(4),from);
} else {
if((state_val_45423 === (9))){
var inst_45415 = (state_45422[(2)]);
var state_45422__$1 = (function (){var statearr_45430 = state_45422;
(statearr_45430[(9)] = inst_45415);

return statearr_45430;
})();
var statearr_45431_46891 = state_45422__$1;
(statearr_45431_46891[(2)] = null);

(statearr_45431_46891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45423 === (5))){
var inst_45406 = cljs.core.async.close_BANG_.call(null,jobs);
var state_45422__$1 = state_45422;
var statearr_45432_46892 = state_45422__$1;
(statearr_45432_46892[(2)] = inst_45406);

(statearr_45432_46892[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45423 === (8))){
var inst_45408 = (state_45422[(8)]);
var inst_45413 = (state_45422[(2)]);
var state_45422__$1 = (function (){var statearr_45433 = state_45422;
(statearr_45433[(10)] = inst_45413);

return statearr_45433;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45422__$1,(9),results,inst_45408);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___46874,jobs,results,process,async))
;
return ((function (switch__45112__auto__,c__45200__auto___46874,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0 = (function (){
var statearr_45434 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45434[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__);

(statearr_45434[(1)] = (1));

return statearr_45434;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1 = (function (state_45422){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_45422);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e45435){if((e45435 instanceof Object)){
var ex__45116__auto__ = e45435;
var statearr_45436_46903 = state_45422;
(statearr_45436_46903[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45422);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45435;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46904 = state_45422;
state_45422 = G__46904;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__ = function(state_45422){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1.call(this,state_45422);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___46874,jobs,results,process,async))
})();
var state__45202__auto__ = (function (){var statearr_45437 = f__45201__auto__.call(null);
(statearr_45437[(6)] = c__45200__auto___46874);

return statearr_45437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___46874,jobs,results,process,async))
);


var c__45200__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto__,jobs,results,process,async){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto__,jobs,results,process,async){
return (function (state_45475){
var state_val_45476 = (state_45475[(1)]);
if((state_val_45476 === (7))){
var inst_45471 = (state_45475[(2)]);
var state_45475__$1 = state_45475;
var statearr_45477_46908 = state_45475__$1;
(statearr_45477_46908[(2)] = inst_45471);

(statearr_45477_46908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (20))){
var state_45475__$1 = state_45475;
var statearr_45478_46912 = state_45475__$1;
(statearr_45478_46912[(2)] = null);

(statearr_45478_46912[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (1))){
var state_45475__$1 = state_45475;
var statearr_45479_46913 = state_45475__$1;
(statearr_45479_46913[(2)] = null);

(statearr_45479_46913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (4))){
var inst_45440 = (state_45475[(7)]);
var inst_45440__$1 = (state_45475[(2)]);
var inst_45441 = (inst_45440__$1 == null);
var state_45475__$1 = (function (){var statearr_45480 = state_45475;
(statearr_45480[(7)] = inst_45440__$1);

return statearr_45480;
})();
if(cljs.core.truth_(inst_45441)){
var statearr_45481_46914 = state_45475__$1;
(statearr_45481_46914[(1)] = (5));

} else {
var statearr_45482_46915 = state_45475__$1;
(statearr_45482_46915[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (15))){
var inst_45453 = (state_45475[(8)]);
var state_45475__$1 = state_45475;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45475__$1,(18),to,inst_45453);
} else {
if((state_val_45476 === (21))){
var inst_45466 = (state_45475[(2)]);
var state_45475__$1 = state_45475;
var statearr_45483_46917 = state_45475__$1;
(statearr_45483_46917[(2)] = inst_45466);

(statearr_45483_46917[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (13))){
var inst_45468 = (state_45475[(2)]);
var state_45475__$1 = (function (){var statearr_45484 = state_45475;
(statearr_45484[(9)] = inst_45468);

return statearr_45484;
})();
var statearr_45485_46918 = state_45475__$1;
(statearr_45485_46918[(2)] = null);

(statearr_45485_46918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (6))){
var inst_45440 = (state_45475[(7)]);
var state_45475__$1 = state_45475;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45475__$1,(11),inst_45440);
} else {
if((state_val_45476 === (17))){
var inst_45461 = (state_45475[(2)]);
var state_45475__$1 = state_45475;
if(cljs.core.truth_(inst_45461)){
var statearr_45486_46919 = state_45475__$1;
(statearr_45486_46919[(1)] = (19));

} else {
var statearr_45487_46920 = state_45475__$1;
(statearr_45487_46920[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (3))){
var inst_45473 = (state_45475[(2)]);
var state_45475__$1 = state_45475;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45475__$1,inst_45473);
} else {
if((state_val_45476 === (12))){
var inst_45450 = (state_45475[(10)]);
var state_45475__$1 = state_45475;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45475__$1,(14),inst_45450);
} else {
if((state_val_45476 === (2))){
var state_45475__$1 = state_45475;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45475__$1,(4),results);
} else {
if((state_val_45476 === (19))){
var state_45475__$1 = state_45475;
var statearr_45488_46921 = state_45475__$1;
(statearr_45488_46921[(2)] = null);

(statearr_45488_46921[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (11))){
var inst_45450 = (state_45475[(2)]);
var state_45475__$1 = (function (){var statearr_45489 = state_45475;
(statearr_45489[(10)] = inst_45450);

return statearr_45489;
})();
var statearr_45490_46922 = state_45475__$1;
(statearr_45490_46922[(2)] = null);

(statearr_45490_46922[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (9))){
var state_45475__$1 = state_45475;
var statearr_45491_46923 = state_45475__$1;
(statearr_45491_46923[(2)] = null);

(statearr_45491_46923[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (5))){
var state_45475__$1 = state_45475;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45492_46924 = state_45475__$1;
(statearr_45492_46924[(1)] = (8));

} else {
var statearr_45493_46925 = state_45475__$1;
(statearr_45493_46925[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (14))){
var inst_45455 = (state_45475[(11)]);
var inst_45453 = (state_45475[(8)]);
var inst_45453__$1 = (state_45475[(2)]);
var inst_45454 = (inst_45453__$1 == null);
var inst_45455__$1 = cljs.core.not.call(null,inst_45454);
var state_45475__$1 = (function (){var statearr_45494 = state_45475;
(statearr_45494[(11)] = inst_45455__$1);

(statearr_45494[(8)] = inst_45453__$1);

return statearr_45494;
})();
if(inst_45455__$1){
var statearr_45495_46926 = state_45475__$1;
(statearr_45495_46926[(1)] = (15));

} else {
var statearr_45496_46927 = state_45475__$1;
(statearr_45496_46927[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (16))){
var inst_45455 = (state_45475[(11)]);
var state_45475__$1 = state_45475;
var statearr_45497_46928 = state_45475__$1;
(statearr_45497_46928[(2)] = inst_45455);

(statearr_45497_46928[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (10))){
var inst_45447 = (state_45475[(2)]);
var state_45475__$1 = state_45475;
var statearr_45498_46931 = state_45475__$1;
(statearr_45498_46931[(2)] = inst_45447);

(statearr_45498_46931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (18))){
var inst_45458 = (state_45475[(2)]);
var state_45475__$1 = state_45475;
var statearr_45499_46933 = state_45475__$1;
(statearr_45499_46933[(2)] = inst_45458);

(statearr_45499_46933[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45476 === (8))){
var inst_45444 = cljs.core.async.close_BANG_.call(null,to);
var state_45475__$1 = state_45475;
var statearr_45500_46937 = state_45475__$1;
(statearr_45500_46937[(2)] = inst_45444);

(statearr_45500_46937[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto__,jobs,results,process,async))
;
return ((function (switch__45112__auto__,c__45200__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0 = (function (){
var statearr_45501 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45501[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__);

(statearr_45501[(1)] = (1));

return statearr_45501;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1 = (function (state_45475){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_45475);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e45502){if((e45502 instanceof Object)){
var ex__45116__auto__ = e45502;
var statearr_45503_46940 = state_45475;
(statearr_45503_46940[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45475);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45502;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46942 = state_45475;
state_45475 = G__46942;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__ = function(state_45475){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1.call(this,state_45475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45113__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto__,jobs,results,process,async))
})();
var state__45202__auto__ = (function (){var statearr_45504 = f__45201__auto__.call(null);
(statearr_45504[(6)] = c__45200__auto__);

return statearr_45504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto__,jobs,results,process,async))
);

return c__45200__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__45506 = arguments.length;
switch (G__45506) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__45508 = arguments.length;
switch (G__45508) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__45510 = arguments.length;
switch (G__45510) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__45200__auto___46963 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___46963,tc,fc){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___46963,tc,fc){
return (function (state_45536){
var state_val_45537 = (state_45536[(1)]);
if((state_val_45537 === (7))){
var inst_45532 = (state_45536[(2)]);
var state_45536__$1 = state_45536;
var statearr_45538_46964 = state_45536__$1;
(statearr_45538_46964[(2)] = inst_45532);

(statearr_45538_46964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45537 === (1))){
var state_45536__$1 = state_45536;
var statearr_45539_46965 = state_45536__$1;
(statearr_45539_46965[(2)] = null);

(statearr_45539_46965[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45537 === (4))){
var inst_45513 = (state_45536[(7)]);
var inst_45513__$1 = (state_45536[(2)]);
var inst_45514 = (inst_45513__$1 == null);
var state_45536__$1 = (function (){var statearr_45540 = state_45536;
(statearr_45540[(7)] = inst_45513__$1);

return statearr_45540;
})();
if(cljs.core.truth_(inst_45514)){
var statearr_45541_46966 = state_45536__$1;
(statearr_45541_46966[(1)] = (5));

} else {
var statearr_45542_46967 = state_45536__$1;
(statearr_45542_46967[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45537 === (13))){
var state_45536__$1 = state_45536;
var statearr_45543_46968 = state_45536__$1;
(statearr_45543_46968[(2)] = null);

(statearr_45543_46968[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45537 === (6))){
var inst_45513 = (state_45536[(7)]);
var inst_45519 = p.call(null,inst_45513);
var state_45536__$1 = state_45536;
if(cljs.core.truth_(inst_45519)){
var statearr_45544_46969 = state_45536__$1;
(statearr_45544_46969[(1)] = (9));

} else {
var statearr_45545_46970 = state_45536__$1;
(statearr_45545_46970[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45537 === (3))){
var inst_45534 = (state_45536[(2)]);
var state_45536__$1 = state_45536;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45536__$1,inst_45534);
} else {
if((state_val_45537 === (12))){
var state_45536__$1 = state_45536;
var statearr_45546_46977 = state_45536__$1;
(statearr_45546_46977[(2)] = null);

(statearr_45546_46977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45537 === (2))){
var state_45536__$1 = state_45536;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45536__$1,(4),ch);
} else {
if((state_val_45537 === (11))){
var inst_45513 = (state_45536[(7)]);
var inst_45523 = (state_45536[(2)]);
var state_45536__$1 = state_45536;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45536__$1,(8),inst_45523,inst_45513);
} else {
if((state_val_45537 === (9))){
var state_45536__$1 = state_45536;
var statearr_45547_46978 = state_45536__$1;
(statearr_45547_46978[(2)] = tc);

(statearr_45547_46978[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45537 === (5))){
var inst_45516 = cljs.core.async.close_BANG_.call(null,tc);
var inst_45517 = cljs.core.async.close_BANG_.call(null,fc);
var state_45536__$1 = (function (){var statearr_45548 = state_45536;
(statearr_45548[(8)] = inst_45516);

return statearr_45548;
})();
var statearr_45549_46979 = state_45536__$1;
(statearr_45549_46979[(2)] = inst_45517);

(statearr_45549_46979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45537 === (14))){
var inst_45530 = (state_45536[(2)]);
var state_45536__$1 = state_45536;
var statearr_45550_46980 = state_45536__$1;
(statearr_45550_46980[(2)] = inst_45530);

(statearr_45550_46980[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45537 === (10))){
var state_45536__$1 = state_45536;
var statearr_45551_46981 = state_45536__$1;
(statearr_45551_46981[(2)] = fc);

(statearr_45551_46981[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45537 === (8))){
var inst_45525 = (state_45536[(2)]);
var state_45536__$1 = state_45536;
if(cljs.core.truth_(inst_45525)){
var statearr_45552_46988 = state_45536__$1;
(statearr_45552_46988[(1)] = (12));

} else {
var statearr_45553_46989 = state_45536__$1;
(statearr_45553_46989[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___46963,tc,fc))
;
return ((function (switch__45112__auto__,c__45200__auto___46963,tc,fc){
return (function() {
var cljs$core$async$state_machine__45113__auto__ = null;
var cljs$core$async$state_machine__45113__auto____0 = (function (){
var statearr_45554 = [null,null,null,null,null,null,null,null,null];
(statearr_45554[(0)] = cljs$core$async$state_machine__45113__auto__);

(statearr_45554[(1)] = (1));

return statearr_45554;
});
var cljs$core$async$state_machine__45113__auto____1 = (function (state_45536){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_45536);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e45555){if((e45555 instanceof Object)){
var ex__45116__auto__ = e45555;
var statearr_45556_46996 = state_45536;
(statearr_45556_46996[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45536);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45555;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46997 = state_45536;
state_45536 = G__46997;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$state_machine__45113__auto__ = function(state_45536){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45113__auto____1.call(this,state_45536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45113__auto____0;
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45113__auto____1;
return cljs$core$async$state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___46963,tc,fc))
})();
var state__45202__auto__ = (function (){var statearr_45557 = f__45201__auto__.call(null);
(statearr_45557[(6)] = c__45200__auto___46963);

return statearr_45557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___46963,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__45200__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto__){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto__){
return (function (state_45578){
var state_val_45579 = (state_45578[(1)]);
if((state_val_45579 === (7))){
var inst_45574 = (state_45578[(2)]);
var state_45578__$1 = state_45578;
var statearr_45580_46998 = state_45578__$1;
(statearr_45580_46998[(2)] = inst_45574);

(statearr_45580_46998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45579 === (1))){
var inst_45558 = init;
var state_45578__$1 = (function (){var statearr_45581 = state_45578;
(statearr_45581[(7)] = inst_45558);

return statearr_45581;
})();
var statearr_45582_46999 = state_45578__$1;
(statearr_45582_46999[(2)] = null);

(statearr_45582_46999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45579 === (4))){
var inst_45561 = (state_45578[(8)]);
var inst_45561__$1 = (state_45578[(2)]);
var inst_45562 = (inst_45561__$1 == null);
var state_45578__$1 = (function (){var statearr_45583 = state_45578;
(statearr_45583[(8)] = inst_45561__$1);

return statearr_45583;
})();
if(cljs.core.truth_(inst_45562)){
var statearr_45584_47000 = state_45578__$1;
(statearr_45584_47000[(1)] = (5));

} else {
var statearr_45585_47001 = state_45578__$1;
(statearr_45585_47001[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45579 === (6))){
var inst_45561 = (state_45578[(8)]);
var inst_45565 = (state_45578[(9)]);
var inst_45558 = (state_45578[(7)]);
var inst_45565__$1 = f.call(null,inst_45558,inst_45561);
var inst_45566 = cljs.core.reduced_QMARK_.call(null,inst_45565__$1);
var state_45578__$1 = (function (){var statearr_45586 = state_45578;
(statearr_45586[(9)] = inst_45565__$1);

return statearr_45586;
})();
if(inst_45566){
var statearr_45587_47002 = state_45578__$1;
(statearr_45587_47002[(1)] = (8));

} else {
var statearr_45588_47003 = state_45578__$1;
(statearr_45588_47003[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45579 === (3))){
var inst_45576 = (state_45578[(2)]);
var state_45578__$1 = state_45578;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45578__$1,inst_45576);
} else {
if((state_val_45579 === (2))){
var state_45578__$1 = state_45578;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45578__$1,(4),ch);
} else {
if((state_val_45579 === (9))){
var inst_45565 = (state_45578[(9)]);
var inst_45558 = inst_45565;
var state_45578__$1 = (function (){var statearr_45589 = state_45578;
(statearr_45589[(7)] = inst_45558);

return statearr_45589;
})();
var statearr_45590_47005 = state_45578__$1;
(statearr_45590_47005[(2)] = null);

(statearr_45590_47005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45579 === (5))){
var inst_45558 = (state_45578[(7)]);
var state_45578__$1 = state_45578;
var statearr_45591_47010 = state_45578__$1;
(statearr_45591_47010[(2)] = inst_45558);

(statearr_45591_47010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45579 === (10))){
var inst_45572 = (state_45578[(2)]);
var state_45578__$1 = state_45578;
var statearr_45592_47011 = state_45578__$1;
(statearr_45592_47011[(2)] = inst_45572);

(statearr_45592_47011[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45579 === (8))){
var inst_45565 = (state_45578[(9)]);
var inst_45568 = cljs.core.deref.call(null,inst_45565);
var state_45578__$1 = state_45578;
var statearr_45593_47012 = state_45578__$1;
(statearr_45593_47012[(2)] = inst_45568);

(statearr_45593_47012[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto__))
;
return ((function (switch__45112__auto__,c__45200__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__45113__auto__ = null;
var cljs$core$async$reduce_$_state_machine__45113__auto____0 = (function (){
var statearr_45594 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45594[(0)] = cljs$core$async$reduce_$_state_machine__45113__auto__);

(statearr_45594[(1)] = (1));

return statearr_45594;
});
var cljs$core$async$reduce_$_state_machine__45113__auto____1 = (function (state_45578){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_45578);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e45595){if((e45595 instanceof Object)){
var ex__45116__auto__ = e45595;
var statearr_45596_47013 = state_45578;
(statearr_45596_47013[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45578);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45595;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47014 = state_45578;
state_45578 = G__47014;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__45113__auto__ = function(state_45578){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__45113__auto____1.call(this,state_45578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__45113__auto____0;
cljs$core$async$reduce_$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__45113__auto____1;
return cljs$core$async$reduce_$_state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto__))
})();
var state__45202__auto__ = (function (){var statearr_45597 = f__45201__auto__.call(null);
(statearr_45597[(6)] = c__45200__auto__);

return statearr_45597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto__))
);

return c__45200__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__45200__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto__,f__$1){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto__,f__$1){
return (function (state_45603){
var state_val_45604 = (state_45603[(1)]);
if((state_val_45604 === (1))){
var inst_45598 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_45603__$1 = state_45603;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45603__$1,(2),inst_45598);
} else {
if((state_val_45604 === (2))){
var inst_45600 = (state_45603[(2)]);
var inst_45601 = f__$1.call(null,inst_45600);
var state_45603__$1 = state_45603;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45603__$1,inst_45601);
} else {
return null;
}
}
});})(c__45200__auto__,f__$1))
;
return ((function (switch__45112__auto__,c__45200__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__45113__auto__ = null;
var cljs$core$async$transduce_$_state_machine__45113__auto____0 = (function (){
var statearr_45605 = [null,null,null,null,null,null,null];
(statearr_45605[(0)] = cljs$core$async$transduce_$_state_machine__45113__auto__);

(statearr_45605[(1)] = (1));

return statearr_45605;
});
var cljs$core$async$transduce_$_state_machine__45113__auto____1 = (function (state_45603){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_45603);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e45606){if((e45606 instanceof Object)){
var ex__45116__auto__ = e45606;
var statearr_45607_47017 = state_45603;
(statearr_45607_47017[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45603);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45606;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47018 = state_45603;
state_45603 = G__47018;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__45113__auto__ = function(state_45603){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__45113__auto____1.call(this,state_45603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__45113__auto____0;
cljs$core$async$transduce_$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__45113__auto____1;
return cljs$core$async$transduce_$_state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto__,f__$1))
})();
var state__45202__auto__ = (function (){var statearr_45608 = f__45201__auto__.call(null);
(statearr_45608[(6)] = c__45200__auto__);

return statearr_45608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto__,f__$1))
);

return c__45200__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__45610 = arguments.length;
switch (G__45610) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__45200__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto__){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto__){
return (function (state_45635){
var state_val_45636 = (state_45635[(1)]);
if((state_val_45636 === (7))){
var inst_45617 = (state_45635[(2)]);
var state_45635__$1 = state_45635;
var statearr_45637_47022 = state_45635__$1;
(statearr_45637_47022[(2)] = inst_45617);

(statearr_45637_47022[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45636 === (1))){
var inst_45611 = cljs.core.seq.call(null,coll);
var inst_45612 = inst_45611;
var state_45635__$1 = (function (){var statearr_45638 = state_45635;
(statearr_45638[(7)] = inst_45612);

return statearr_45638;
})();
var statearr_45639_47023 = state_45635__$1;
(statearr_45639_47023[(2)] = null);

(statearr_45639_47023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45636 === (4))){
var inst_45612 = (state_45635[(7)]);
var inst_45615 = cljs.core.first.call(null,inst_45612);
var state_45635__$1 = state_45635;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45635__$1,(7),ch,inst_45615);
} else {
if((state_val_45636 === (13))){
var inst_45629 = (state_45635[(2)]);
var state_45635__$1 = state_45635;
var statearr_45640_47024 = state_45635__$1;
(statearr_45640_47024[(2)] = inst_45629);

(statearr_45640_47024[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45636 === (6))){
var inst_45620 = (state_45635[(2)]);
var state_45635__$1 = state_45635;
if(cljs.core.truth_(inst_45620)){
var statearr_45641_47025 = state_45635__$1;
(statearr_45641_47025[(1)] = (8));

} else {
var statearr_45642_47026 = state_45635__$1;
(statearr_45642_47026[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45636 === (3))){
var inst_45633 = (state_45635[(2)]);
var state_45635__$1 = state_45635;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45635__$1,inst_45633);
} else {
if((state_val_45636 === (12))){
var state_45635__$1 = state_45635;
var statearr_45643_47027 = state_45635__$1;
(statearr_45643_47027[(2)] = null);

(statearr_45643_47027[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45636 === (2))){
var inst_45612 = (state_45635[(7)]);
var state_45635__$1 = state_45635;
if(cljs.core.truth_(inst_45612)){
var statearr_45644_47028 = state_45635__$1;
(statearr_45644_47028[(1)] = (4));

} else {
var statearr_45645_47030 = state_45635__$1;
(statearr_45645_47030[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45636 === (11))){
var inst_45626 = cljs.core.async.close_BANG_.call(null,ch);
var state_45635__$1 = state_45635;
var statearr_45646_47032 = state_45635__$1;
(statearr_45646_47032[(2)] = inst_45626);

(statearr_45646_47032[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45636 === (9))){
var state_45635__$1 = state_45635;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45647_47033 = state_45635__$1;
(statearr_45647_47033[(1)] = (11));

} else {
var statearr_45648_47034 = state_45635__$1;
(statearr_45648_47034[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45636 === (5))){
var inst_45612 = (state_45635[(7)]);
var state_45635__$1 = state_45635;
var statearr_45649_47035 = state_45635__$1;
(statearr_45649_47035[(2)] = inst_45612);

(statearr_45649_47035[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45636 === (10))){
var inst_45631 = (state_45635[(2)]);
var state_45635__$1 = state_45635;
var statearr_45650_47036 = state_45635__$1;
(statearr_45650_47036[(2)] = inst_45631);

(statearr_45650_47036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45636 === (8))){
var inst_45612 = (state_45635[(7)]);
var inst_45622 = cljs.core.next.call(null,inst_45612);
var inst_45612__$1 = inst_45622;
var state_45635__$1 = (function (){var statearr_45651 = state_45635;
(statearr_45651[(7)] = inst_45612__$1);

return statearr_45651;
})();
var statearr_45652_47037 = state_45635__$1;
(statearr_45652_47037[(2)] = null);

(statearr_45652_47037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto__))
;
return ((function (switch__45112__auto__,c__45200__auto__){
return (function() {
var cljs$core$async$state_machine__45113__auto__ = null;
var cljs$core$async$state_machine__45113__auto____0 = (function (){
var statearr_45653 = [null,null,null,null,null,null,null,null];
(statearr_45653[(0)] = cljs$core$async$state_machine__45113__auto__);

(statearr_45653[(1)] = (1));

return statearr_45653;
});
var cljs$core$async$state_machine__45113__auto____1 = (function (state_45635){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_45635);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e45654){if((e45654 instanceof Object)){
var ex__45116__auto__ = e45654;
var statearr_45655_47038 = state_45635;
(statearr_45655_47038[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45635);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45654;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47039 = state_45635;
state_45635 = G__47039;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$state_machine__45113__auto__ = function(state_45635){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45113__auto____1.call(this,state_45635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45113__auto____0;
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45113__auto____1;
return cljs$core$async$state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto__))
})();
var state__45202__auto__ = (function (){var statearr_45656 = f__45201__auto__.call(null);
(statearr_45656[(6)] = c__45200__auto__);

return statearr_45656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto__))
);

return c__45200__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,_);
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45657 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45657 = (function (ch,cs,meta45658){
this.ch = ch;
this.cs = cs;
this.meta45658 = meta45658;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async45657.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_45659,meta45658__$1){
var self__ = this;
var _45659__$1 = this;
return (new cljs.core.async.t_cljs$core$async45657(self__.ch,self__.cs,meta45658__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async45657.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_45659){
var self__ = this;
var _45659__$1 = this;
return self__.meta45658;
});})(cs))
;

cljs.core.async.t_cljs$core$async45657.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async45657.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async45657.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async45657.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async45657.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async45657.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async45657.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta45658","meta45658",-415991375,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async45657.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async45657.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45657";

cljs.core.async.t_cljs$core$async45657.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async45657");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45657.
 */
cljs.core.async.__GT_t_cljs$core$async45657 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async45657(ch__$1,cs__$1,meta45658){
return (new cljs.core.async.t_cljs$core$async45657(ch__$1,cs__$1,meta45658));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async45657(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__45200__auto___47062 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___47062,cs,m,dchan,dctr,done){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___47062,cs,m,dchan,dctr,done){
return (function (state_45794){
var state_val_45795 = (state_45794[(1)]);
if((state_val_45795 === (7))){
var inst_45790 = (state_45794[(2)]);
var state_45794__$1 = state_45794;
var statearr_45796_47066 = state_45794__$1;
(statearr_45796_47066[(2)] = inst_45790);

(statearr_45796_47066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (20))){
var inst_45693 = (state_45794[(7)]);
var inst_45705 = cljs.core.first.call(null,inst_45693);
var inst_45706 = cljs.core.nth.call(null,inst_45705,(0),null);
var inst_45707 = cljs.core.nth.call(null,inst_45705,(1),null);
var state_45794__$1 = (function (){var statearr_45797 = state_45794;
(statearr_45797[(8)] = inst_45706);

return statearr_45797;
})();
if(cljs.core.truth_(inst_45707)){
var statearr_45798_47067 = state_45794__$1;
(statearr_45798_47067[(1)] = (22));

} else {
var statearr_45799_47068 = state_45794__$1;
(statearr_45799_47068[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (27))){
var inst_45742 = (state_45794[(9)]);
var inst_45662 = (state_45794[(10)]);
var inst_45737 = (state_45794[(11)]);
var inst_45735 = (state_45794[(12)]);
var inst_45742__$1 = cljs.core._nth.call(null,inst_45735,inst_45737);
var inst_45743 = cljs.core.async.put_BANG_.call(null,inst_45742__$1,inst_45662,done);
var state_45794__$1 = (function (){var statearr_45800 = state_45794;
(statearr_45800[(9)] = inst_45742__$1);

return statearr_45800;
})();
if(cljs.core.truth_(inst_45743)){
var statearr_45801_47071 = state_45794__$1;
(statearr_45801_47071[(1)] = (30));

} else {
var statearr_45802_47072 = state_45794__$1;
(statearr_45802_47072[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (1))){
var state_45794__$1 = state_45794;
var statearr_45803_47073 = state_45794__$1;
(statearr_45803_47073[(2)] = null);

(statearr_45803_47073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (24))){
var inst_45693 = (state_45794[(7)]);
var inst_45712 = (state_45794[(2)]);
var inst_45713 = cljs.core.next.call(null,inst_45693);
var inst_45671 = inst_45713;
var inst_45672 = null;
var inst_45673 = (0);
var inst_45674 = (0);
var state_45794__$1 = (function (){var statearr_45804 = state_45794;
(statearr_45804[(13)] = inst_45673);

(statearr_45804[(14)] = inst_45672);

(statearr_45804[(15)] = inst_45712);

(statearr_45804[(16)] = inst_45671);

(statearr_45804[(17)] = inst_45674);

return statearr_45804;
})();
var statearr_45805_47074 = state_45794__$1;
(statearr_45805_47074[(2)] = null);

(statearr_45805_47074[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (39))){
var state_45794__$1 = state_45794;
var statearr_45809_47075 = state_45794__$1;
(statearr_45809_47075[(2)] = null);

(statearr_45809_47075[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (4))){
var inst_45662 = (state_45794[(10)]);
var inst_45662__$1 = (state_45794[(2)]);
var inst_45663 = (inst_45662__$1 == null);
var state_45794__$1 = (function (){var statearr_45810 = state_45794;
(statearr_45810[(10)] = inst_45662__$1);

return statearr_45810;
})();
if(cljs.core.truth_(inst_45663)){
var statearr_45811_47076 = state_45794__$1;
(statearr_45811_47076[(1)] = (5));

} else {
var statearr_45812_47077 = state_45794__$1;
(statearr_45812_47077[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (15))){
var inst_45673 = (state_45794[(13)]);
var inst_45672 = (state_45794[(14)]);
var inst_45671 = (state_45794[(16)]);
var inst_45674 = (state_45794[(17)]);
var inst_45689 = (state_45794[(2)]);
var inst_45690 = (inst_45674 + (1));
var tmp45806 = inst_45673;
var tmp45807 = inst_45672;
var tmp45808 = inst_45671;
var inst_45671__$1 = tmp45808;
var inst_45672__$1 = tmp45807;
var inst_45673__$1 = tmp45806;
var inst_45674__$1 = inst_45690;
var state_45794__$1 = (function (){var statearr_45813 = state_45794;
(statearr_45813[(13)] = inst_45673__$1);

(statearr_45813[(18)] = inst_45689);

(statearr_45813[(14)] = inst_45672__$1);

(statearr_45813[(16)] = inst_45671__$1);

(statearr_45813[(17)] = inst_45674__$1);

return statearr_45813;
})();
var statearr_45814_47078 = state_45794__$1;
(statearr_45814_47078[(2)] = null);

(statearr_45814_47078[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (21))){
var inst_45716 = (state_45794[(2)]);
var state_45794__$1 = state_45794;
var statearr_45818_47079 = state_45794__$1;
(statearr_45818_47079[(2)] = inst_45716);

(statearr_45818_47079[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (31))){
var inst_45742 = (state_45794[(9)]);
var inst_45746 = done.call(null,null);
var inst_45747 = cljs.core.async.untap_STAR_.call(null,m,inst_45742);
var state_45794__$1 = (function (){var statearr_45819 = state_45794;
(statearr_45819[(19)] = inst_45746);

return statearr_45819;
})();
var statearr_45820_47080 = state_45794__$1;
(statearr_45820_47080[(2)] = inst_45747);

(statearr_45820_47080[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (32))){
var inst_45734 = (state_45794[(20)]);
var inst_45737 = (state_45794[(11)]);
var inst_45736 = (state_45794[(21)]);
var inst_45735 = (state_45794[(12)]);
var inst_45749 = (state_45794[(2)]);
var inst_45750 = (inst_45737 + (1));
var tmp45815 = inst_45734;
var tmp45816 = inst_45736;
var tmp45817 = inst_45735;
var inst_45734__$1 = tmp45815;
var inst_45735__$1 = tmp45817;
var inst_45736__$1 = tmp45816;
var inst_45737__$1 = inst_45750;
var state_45794__$1 = (function (){var statearr_45821 = state_45794;
(statearr_45821[(20)] = inst_45734__$1);

(statearr_45821[(11)] = inst_45737__$1);

(statearr_45821[(21)] = inst_45736__$1);

(statearr_45821[(22)] = inst_45749);

(statearr_45821[(12)] = inst_45735__$1);

return statearr_45821;
})();
var statearr_45822_47085 = state_45794__$1;
(statearr_45822_47085[(2)] = null);

(statearr_45822_47085[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (40))){
var inst_45762 = (state_45794[(23)]);
var inst_45766 = done.call(null,null);
var inst_45767 = cljs.core.async.untap_STAR_.call(null,m,inst_45762);
var state_45794__$1 = (function (){var statearr_45823 = state_45794;
(statearr_45823[(24)] = inst_45766);

return statearr_45823;
})();
var statearr_45824_47086 = state_45794__$1;
(statearr_45824_47086[(2)] = inst_45767);

(statearr_45824_47086[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (33))){
var inst_45753 = (state_45794[(25)]);
var inst_45755 = cljs.core.chunked_seq_QMARK_.call(null,inst_45753);
var state_45794__$1 = state_45794;
if(inst_45755){
var statearr_45825_47087 = state_45794__$1;
(statearr_45825_47087[(1)] = (36));

} else {
var statearr_45826_47088 = state_45794__$1;
(statearr_45826_47088[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (13))){
var inst_45683 = (state_45794[(26)]);
var inst_45686 = cljs.core.async.close_BANG_.call(null,inst_45683);
var state_45794__$1 = state_45794;
var statearr_45827_47093 = state_45794__$1;
(statearr_45827_47093[(2)] = inst_45686);

(statearr_45827_47093[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (22))){
var inst_45706 = (state_45794[(8)]);
var inst_45709 = cljs.core.async.close_BANG_.call(null,inst_45706);
var state_45794__$1 = state_45794;
var statearr_45828_47095 = state_45794__$1;
(statearr_45828_47095[(2)] = inst_45709);

(statearr_45828_47095[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (36))){
var inst_45753 = (state_45794[(25)]);
var inst_45757 = cljs.core.chunk_first.call(null,inst_45753);
var inst_45758 = cljs.core.chunk_rest.call(null,inst_45753);
var inst_45759 = cljs.core.count.call(null,inst_45757);
var inst_45734 = inst_45758;
var inst_45735 = inst_45757;
var inst_45736 = inst_45759;
var inst_45737 = (0);
var state_45794__$1 = (function (){var statearr_45829 = state_45794;
(statearr_45829[(20)] = inst_45734);

(statearr_45829[(11)] = inst_45737);

(statearr_45829[(21)] = inst_45736);

(statearr_45829[(12)] = inst_45735);

return statearr_45829;
})();
var statearr_45830_47101 = state_45794__$1;
(statearr_45830_47101[(2)] = null);

(statearr_45830_47101[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (41))){
var inst_45753 = (state_45794[(25)]);
var inst_45769 = (state_45794[(2)]);
var inst_45770 = cljs.core.next.call(null,inst_45753);
var inst_45734 = inst_45770;
var inst_45735 = null;
var inst_45736 = (0);
var inst_45737 = (0);
var state_45794__$1 = (function (){var statearr_45831 = state_45794;
(statearr_45831[(27)] = inst_45769);

(statearr_45831[(20)] = inst_45734);

(statearr_45831[(11)] = inst_45737);

(statearr_45831[(21)] = inst_45736);

(statearr_45831[(12)] = inst_45735);

return statearr_45831;
})();
var statearr_45832_47102 = state_45794__$1;
(statearr_45832_47102[(2)] = null);

(statearr_45832_47102[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (43))){
var state_45794__$1 = state_45794;
var statearr_45833_47103 = state_45794__$1;
(statearr_45833_47103[(2)] = null);

(statearr_45833_47103[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (29))){
var inst_45778 = (state_45794[(2)]);
var state_45794__$1 = state_45794;
var statearr_45834_47104 = state_45794__$1;
(statearr_45834_47104[(2)] = inst_45778);

(statearr_45834_47104[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (44))){
var inst_45787 = (state_45794[(2)]);
var state_45794__$1 = (function (){var statearr_45835 = state_45794;
(statearr_45835[(28)] = inst_45787);

return statearr_45835;
})();
var statearr_45836_47105 = state_45794__$1;
(statearr_45836_47105[(2)] = null);

(statearr_45836_47105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (6))){
var inst_45726 = (state_45794[(29)]);
var inst_45725 = cljs.core.deref.call(null,cs);
var inst_45726__$1 = cljs.core.keys.call(null,inst_45725);
var inst_45727 = cljs.core.count.call(null,inst_45726__$1);
var inst_45728 = cljs.core.reset_BANG_.call(null,dctr,inst_45727);
var inst_45733 = cljs.core.seq.call(null,inst_45726__$1);
var inst_45734 = inst_45733;
var inst_45735 = null;
var inst_45736 = (0);
var inst_45737 = (0);
var state_45794__$1 = (function (){var statearr_45837 = state_45794;
(statearr_45837[(20)] = inst_45734);

(statearr_45837[(29)] = inst_45726__$1);

(statearr_45837[(11)] = inst_45737);

(statearr_45837[(30)] = inst_45728);

(statearr_45837[(21)] = inst_45736);

(statearr_45837[(12)] = inst_45735);

return statearr_45837;
})();
var statearr_45838_47106 = state_45794__$1;
(statearr_45838_47106[(2)] = null);

(statearr_45838_47106[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (28))){
var inst_45734 = (state_45794[(20)]);
var inst_45753 = (state_45794[(25)]);
var inst_45753__$1 = cljs.core.seq.call(null,inst_45734);
var state_45794__$1 = (function (){var statearr_45839 = state_45794;
(statearr_45839[(25)] = inst_45753__$1);

return statearr_45839;
})();
if(inst_45753__$1){
var statearr_45840_47107 = state_45794__$1;
(statearr_45840_47107[(1)] = (33));

} else {
var statearr_45841_47108 = state_45794__$1;
(statearr_45841_47108[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (25))){
var inst_45737 = (state_45794[(11)]);
var inst_45736 = (state_45794[(21)]);
var inst_45739 = (inst_45737 < inst_45736);
var inst_45740 = inst_45739;
var state_45794__$1 = state_45794;
if(cljs.core.truth_(inst_45740)){
var statearr_45842_47109 = state_45794__$1;
(statearr_45842_47109[(1)] = (27));

} else {
var statearr_45843_47110 = state_45794__$1;
(statearr_45843_47110[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (34))){
var state_45794__$1 = state_45794;
var statearr_45844_47111 = state_45794__$1;
(statearr_45844_47111[(2)] = null);

(statearr_45844_47111[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (17))){
var state_45794__$1 = state_45794;
var statearr_45845_47115 = state_45794__$1;
(statearr_45845_47115[(2)] = null);

(statearr_45845_47115[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (3))){
var inst_45792 = (state_45794[(2)]);
var state_45794__$1 = state_45794;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45794__$1,inst_45792);
} else {
if((state_val_45795 === (12))){
var inst_45721 = (state_45794[(2)]);
var state_45794__$1 = state_45794;
var statearr_45846_47116 = state_45794__$1;
(statearr_45846_47116[(2)] = inst_45721);

(statearr_45846_47116[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (2))){
var state_45794__$1 = state_45794;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45794__$1,(4),ch);
} else {
if((state_val_45795 === (23))){
var state_45794__$1 = state_45794;
var statearr_45847_47117 = state_45794__$1;
(statearr_45847_47117[(2)] = null);

(statearr_45847_47117[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (35))){
var inst_45776 = (state_45794[(2)]);
var state_45794__$1 = state_45794;
var statearr_45848_47118 = state_45794__$1;
(statearr_45848_47118[(2)] = inst_45776);

(statearr_45848_47118[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (19))){
var inst_45693 = (state_45794[(7)]);
var inst_45697 = cljs.core.chunk_first.call(null,inst_45693);
var inst_45698 = cljs.core.chunk_rest.call(null,inst_45693);
var inst_45699 = cljs.core.count.call(null,inst_45697);
var inst_45671 = inst_45698;
var inst_45672 = inst_45697;
var inst_45673 = inst_45699;
var inst_45674 = (0);
var state_45794__$1 = (function (){var statearr_45849 = state_45794;
(statearr_45849[(13)] = inst_45673);

(statearr_45849[(14)] = inst_45672);

(statearr_45849[(16)] = inst_45671);

(statearr_45849[(17)] = inst_45674);

return statearr_45849;
})();
var statearr_45850_47119 = state_45794__$1;
(statearr_45850_47119[(2)] = null);

(statearr_45850_47119[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (11))){
var inst_45693 = (state_45794[(7)]);
var inst_45671 = (state_45794[(16)]);
var inst_45693__$1 = cljs.core.seq.call(null,inst_45671);
var state_45794__$1 = (function (){var statearr_45851 = state_45794;
(statearr_45851[(7)] = inst_45693__$1);

return statearr_45851;
})();
if(inst_45693__$1){
var statearr_45852_47120 = state_45794__$1;
(statearr_45852_47120[(1)] = (16));

} else {
var statearr_45853_47121 = state_45794__$1;
(statearr_45853_47121[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (9))){
var inst_45723 = (state_45794[(2)]);
var state_45794__$1 = state_45794;
var statearr_45854_47123 = state_45794__$1;
(statearr_45854_47123[(2)] = inst_45723);

(statearr_45854_47123[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (5))){
var inst_45669 = cljs.core.deref.call(null,cs);
var inst_45670 = cljs.core.seq.call(null,inst_45669);
var inst_45671 = inst_45670;
var inst_45672 = null;
var inst_45673 = (0);
var inst_45674 = (0);
var state_45794__$1 = (function (){var statearr_45855 = state_45794;
(statearr_45855[(13)] = inst_45673);

(statearr_45855[(14)] = inst_45672);

(statearr_45855[(16)] = inst_45671);

(statearr_45855[(17)] = inst_45674);

return statearr_45855;
})();
var statearr_45856_47124 = state_45794__$1;
(statearr_45856_47124[(2)] = null);

(statearr_45856_47124[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (14))){
var state_45794__$1 = state_45794;
var statearr_45857_47125 = state_45794__$1;
(statearr_45857_47125[(2)] = null);

(statearr_45857_47125[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (45))){
var inst_45784 = (state_45794[(2)]);
var state_45794__$1 = state_45794;
var statearr_45858_47126 = state_45794__$1;
(statearr_45858_47126[(2)] = inst_45784);

(statearr_45858_47126[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (26))){
var inst_45726 = (state_45794[(29)]);
var inst_45780 = (state_45794[(2)]);
var inst_45781 = cljs.core.seq.call(null,inst_45726);
var state_45794__$1 = (function (){var statearr_45859 = state_45794;
(statearr_45859[(31)] = inst_45780);

return statearr_45859;
})();
if(inst_45781){
var statearr_45860_47127 = state_45794__$1;
(statearr_45860_47127[(1)] = (42));

} else {
var statearr_45861_47128 = state_45794__$1;
(statearr_45861_47128[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (16))){
var inst_45693 = (state_45794[(7)]);
var inst_45695 = cljs.core.chunked_seq_QMARK_.call(null,inst_45693);
var state_45794__$1 = state_45794;
if(inst_45695){
var statearr_45862_47133 = state_45794__$1;
(statearr_45862_47133[(1)] = (19));

} else {
var statearr_45863_47134 = state_45794__$1;
(statearr_45863_47134[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (38))){
var inst_45773 = (state_45794[(2)]);
var state_45794__$1 = state_45794;
var statearr_45864_47136 = state_45794__$1;
(statearr_45864_47136[(2)] = inst_45773);

(statearr_45864_47136[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (30))){
var state_45794__$1 = state_45794;
var statearr_45865_47137 = state_45794__$1;
(statearr_45865_47137[(2)] = null);

(statearr_45865_47137[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (10))){
var inst_45672 = (state_45794[(14)]);
var inst_45674 = (state_45794[(17)]);
var inst_45682 = cljs.core._nth.call(null,inst_45672,inst_45674);
var inst_45683 = cljs.core.nth.call(null,inst_45682,(0),null);
var inst_45684 = cljs.core.nth.call(null,inst_45682,(1),null);
var state_45794__$1 = (function (){var statearr_45866 = state_45794;
(statearr_45866[(26)] = inst_45683);

return statearr_45866;
})();
if(cljs.core.truth_(inst_45684)){
var statearr_45867_47138 = state_45794__$1;
(statearr_45867_47138[(1)] = (13));

} else {
var statearr_45868_47139 = state_45794__$1;
(statearr_45868_47139[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (18))){
var inst_45719 = (state_45794[(2)]);
var state_45794__$1 = state_45794;
var statearr_45869_47140 = state_45794__$1;
(statearr_45869_47140[(2)] = inst_45719);

(statearr_45869_47140[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (42))){
var state_45794__$1 = state_45794;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_45794__$1,(45),dchan);
} else {
if((state_val_45795 === (37))){
var inst_45762 = (state_45794[(23)]);
var inst_45662 = (state_45794[(10)]);
var inst_45753 = (state_45794[(25)]);
var inst_45762__$1 = cljs.core.first.call(null,inst_45753);
var inst_45763 = cljs.core.async.put_BANG_.call(null,inst_45762__$1,inst_45662,done);
var state_45794__$1 = (function (){var statearr_45870 = state_45794;
(statearr_45870[(23)] = inst_45762__$1);

return statearr_45870;
})();
if(cljs.core.truth_(inst_45763)){
var statearr_45871_47142 = state_45794__$1;
(statearr_45871_47142[(1)] = (39));

} else {
var statearr_45872_47144 = state_45794__$1;
(statearr_45872_47144[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (8))){
var inst_45673 = (state_45794[(13)]);
var inst_45674 = (state_45794[(17)]);
var inst_45676 = (inst_45674 < inst_45673);
var inst_45677 = inst_45676;
var state_45794__$1 = state_45794;
if(cljs.core.truth_(inst_45677)){
var statearr_45873_47148 = state_45794__$1;
(statearr_45873_47148[(1)] = (10));

} else {
var statearr_45874_47149 = state_45794__$1;
(statearr_45874_47149[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___47062,cs,m,dchan,dctr,done))
;
return ((function (switch__45112__auto__,c__45200__auto___47062,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__45113__auto__ = null;
var cljs$core$async$mult_$_state_machine__45113__auto____0 = (function (){
var statearr_45875 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45875[(0)] = cljs$core$async$mult_$_state_machine__45113__auto__);

(statearr_45875[(1)] = (1));

return statearr_45875;
});
var cljs$core$async$mult_$_state_machine__45113__auto____1 = (function (state_45794){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_45794);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e45876){if((e45876 instanceof Object)){
var ex__45116__auto__ = e45876;
var statearr_45877_47150 = state_45794;
(statearr_45877_47150[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45794);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45876;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47151 = state_45794;
state_45794 = G__47151;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__45113__auto__ = function(state_45794){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__45113__auto____1.call(this,state_45794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__45113__auto____0;
cljs$core$async$mult_$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__45113__auto____1;
return cljs$core$async$mult_$_state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___47062,cs,m,dchan,dctr,done))
})();
var state__45202__auto__ = (function (){var statearr_45878 = f__45201__auto__.call(null);
(statearr_45878[(6)] = c__45200__auto___47062);

return statearr_45878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___47062,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__45880 = arguments.length;
switch (G__45880) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,state_map);
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,mode);
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___47157 = arguments.length;
var i__4731__auto___47158 = (0);
while(true){
if((i__4731__auto___47158 < len__4730__auto___47157)){
args__4736__auto__.push((arguments[i__4731__auto___47158]));

var G__47159 = (i__4731__auto___47158 + (1));
i__4731__auto___47158 = G__47159;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__45885){
var map__45886 = p__45885;
var map__45886__$1 = (((((!((map__45886 == null))))?(((((map__45886.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45886.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45886):map__45886);
var opts = map__45886__$1;
var statearr_45888_47160 = state;
(statearr_45888_47160[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts.call(null,((function (map__45886,map__45886__$1,opts){
return (function (val){
var statearr_45889_47161 = state;
(statearr_45889_47161[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__45886,map__45886__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_45890_47162 = state;
(statearr_45890_47162[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq45881){
var G__45882 = cljs.core.first.call(null,seq45881);
var seq45881__$1 = cljs.core.next.call(null,seq45881);
var G__45883 = cljs.core.first.call(null,seq45881__$1);
var seq45881__$2 = cljs.core.next.call(null,seq45881__$1);
var G__45884 = cljs.core.first.call(null,seq45881__$2);
var seq45881__$3 = cljs.core.next.call(null,seq45881__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45882,G__45883,G__45884,seq45881__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45891 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45891 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta45892){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta45892 = meta45892;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async45891.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_45893,meta45892__$1){
var self__ = this;
var _45893__$1 = this;
return (new cljs.core.async.t_cljs$core$async45891(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta45892__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async45891.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_45893){
var self__ = this;
var _45893__$1 = this;
return self__.meta45892;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async45891.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async45891.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async45891.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async45891.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async45891.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async45891.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async45891.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async45891.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async45891.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta45892","meta45892",1145044532,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async45891.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async45891.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45891";

cljs.core.async.t_cljs$core$async45891.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async45891");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45891.
 */
cljs.core.async.__GT_t_cljs$core$async45891 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async45891(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45892){
return (new cljs.core.async.t_cljs$core$async45891(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta45892));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async45891(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__45200__auto___47173 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___47173,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___47173,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_45995){
var state_val_45996 = (state_45995[(1)]);
if((state_val_45996 === (7))){
var inst_45910 = (state_45995[(2)]);
var state_45995__$1 = state_45995;
var statearr_45997_47174 = state_45995__$1;
(statearr_45997_47174[(2)] = inst_45910);

(statearr_45997_47174[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (20))){
var inst_45922 = (state_45995[(7)]);
var state_45995__$1 = state_45995;
var statearr_45998_47175 = state_45995__$1;
(statearr_45998_47175[(2)] = inst_45922);

(statearr_45998_47175[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (27))){
var state_45995__$1 = state_45995;
var statearr_45999_47176 = state_45995__$1;
(statearr_45999_47176[(2)] = null);

(statearr_45999_47176[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (1))){
var inst_45897 = (state_45995[(8)]);
var inst_45897__$1 = calc_state.call(null);
var inst_45899 = (inst_45897__$1 == null);
var inst_45900 = cljs.core.not.call(null,inst_45899);
var state_45995__$1 = (function (){var statearr_46000 = state_45995;
(statearr_46000[(8)] = inst_45897__$1);

return statearr_46000;
})();
if(inst_45900){
var statearr_46001_47177 = state_45995__$1;
(statearr_46001_47177[(1)] = (2));

} else {
var statearr_46002_47178 = state_45995__$1;
(statearr_46002_47178[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (24))){
var inst_45946 = (state_45995[(9)]);
var inst_45955 = (state_45995[(10)]);
var inst_45969 = (state_45995[(11)]);
var inst_45969__$1 = inst_45946.call(null,inst_45955);
var state_45995__$1 = (function (){var statearr_46003 = state_45995;
(statearr_46003[(11)] = inst_45969__$1);

return statearr_46003;
})();
if(cljs.core.truth_(inst_45969__$1)){
var statearr_46004_47182 = state_45995__$1;
(statearr_46004_47182[(1)] = (29));

} else {
var statearr_46005_47183 = state_45995__$1;
(statearr_46005_47183[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (4))){
var inst_45913 = (state_45995[(2)]);
var state_45995__$1 = state_45995;
if(cljs.core.truth_(inst_45913)){
var statearr_46006_47191 = state_45995__$1;
(statearr_46006_47191[(1)] = (8));

} else {
var statearr_46007_47192 = state_45995__$1;
(statearr_46007_47192[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (15))){
var inst_45940 = (state_45995[(2)]);
var state_45995__$1 = state_45995;
if(cljs.core.truth_(inst_45940)){
var statearr_46008_47193 = state_45995__$1;
(statearr_46008_47193[(1)] = (19));

} else {
var statearr_46009_47194 = state_45995__$1;
(statearr_46009_47194[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (21))){
var inst_45945 = (state_45995[(12)]);
var inst_45945__$1 = (state_45995[(2)]);
var inst_45946 = cljs.core.get.call(null,inst_45945__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45947 = cljs.core.get.call(null,inst_45945__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45948 = cljs.core.get.call(null,inst_45945__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_45995__$1 = (function (){var statearr_46010 = state_45995;
(statearr_46010[(13)] = inst_45947);

(statearr_46010[(9)] = inst_45946);

(statearr_46010[(12)] = inst_45945__$1);

return statearr_46010;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_45995__$1,(22),inst_45948);
} else {
if((state_val_45996 === (31))){
var inst_45977 = (state_45995[(2)]);
var state_45995__$1 = state_45995;
if(cljs.core.truth_(inst_45977)){
var statearr_46011_47198 = state_45995__$1;
(statearr_46011_47198[(1)] = (32));

} else {
var statearr_46012_47199 = state_45995__$1;
(statearr_46012_47199[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (32))){
var inst_45954 = (state_45995[(14)]);
var state_45995__$1 = state_45995;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45995__$1,(35),out,inst_45954);
} else {
if((state_val_45996 === (33))){
var inst_45945 = (state_45995[(12)]);
var inst_45922 = inst_45945;
var state_45995__$1 = (function (){var statearr_46013 = state_45995;
(statearr_46013[(7)] = inst_45922);

return statearr_46013;
})();
var statearr_46014_47203 = state_45995__$1;
(statearr_46014_47203[(2)] = null);

(statearr_46014_47203[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (13))){
var inst_45922 = (state_45995[(7)]);
var inst_45929 = inst_45922.cljs$lang$protocol_mask$partition0$;
var inst_45930 = (inst_45929 & (64));
var inst_45931 = inst_45922.cljs$core$ISeq$;
var inst_45932 = (cljs.core.PROTOCOL_SENTINEL === inst_45931);
var inst_45933 = ((inst_45930) || (inst_45932));
var state_45995__$1 = state_45995;
if(cljs.core.truth_(inst_45933)){
var statearr_46015_47207 = state_45995__$1;
(statearr_46015_47207[(1)] = (16));

} else {
var statearr_46016_47208 = state_45995__$1;
(statearr_46016_47208[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (22))){
var inst_45954 = (state_45995[(14)]);
var inst_45955 = (state_45995[(10)]);
var inst_45953 = (state_45995[(2)]);
var inst_45954__$1 = cljs.core.nth.call(null,inst_45953,(0),null);
var inst_45955__$1 = cljs.core.nth.call(null,inst_45953,(1),null);
var inst_45956 = (inst_45954__$1 == null);
var inst_45957 = cljs.core._EQ_.call(null,inst_45955__$1,change);
var inst_45958 = ((inst_45956) || (inst_45957));
var state_45995__$1 = (function (){var statearr_46017 = state_45995;
(statearr_46017[(14)] = inst_45954__$1);

(statearr_46017[(10)] = inst_45955__$1);

return statearr_46017;
})();
if(cljs.core.truth_(inst_45958)){
var statearr_46018_47210 = state_45995__$1;
(statearr_46018_47210[(1)] = (23));

} else {
var statearr_46019_47211 = state_45995__$1;
(statearr_46019_47211[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (36))){
var inst_45945 = (state_45995[(12)]);
var inst_45922 = inst_45945;
var state_45995__$1 = (function (){var statearr_46020 = state_45995;
(statearr_46020[(7)] = inst_45922);

return statearr_46020;
})();
var statearr_46021_47215 = state_45995__$1;
(statearr_46021_47215[(2)] = null);

(statearr_46021_47215[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (29))){
var inst_45969 = (state_45995[(11)]);
var state_45995__$1 = state_45995;
var statearr_46022_47222 = state_45995__$1;
(statearr_46022_47222[(2)] = inst_45969);

(statearr_46022_47222[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (6))){
var state_45995__$1 = state_45995;
var statearr_46023_47223 = state_45995__$1;
(statearr_46023_47223[(2)] = false);

(statearr_46023_47223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (28))){
var inst_45965 = (state_45995[(2)]);
var inst_45966 = calc_state.call(null);
var inst_45922 = inst_45966;
var state_45995__$1 = (function (){var statearr_46024 = state_45995;
(statearr_46024[(7)] = inst_45922);

(statearr_46024[(15)] = inst_45965);

return statearr_46024;
})();
var statearr_46025_47230 = state_45995__$1;
(statearr_46025_47230[(2)] = null);

(statearr_46025_47230[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (25))){
var inst_45991 = (state_45995[(2)]);
var state_45995__$1 = state_45995;
var statearr_46026_47231 = state_45995__$1;
(statearr_46026_47231[(2)] = inst_45991);

(statearr_46026_47231[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (34))){
var inst_45989 = (state_45995[(2)]);
var state_45995__$1 = state_45995;
var statearr_46027_47232 = state_45995__$1;
(statearr_46027_47232[(2)] = inst_45989);

(statearr_46027_47232[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (17))){
var state_45995__$1 = state_45995;
var statearr_46028_47233 = state_45995__$1;
(statearr_46028_47233[(2)] = false);

(statearr_46028_47233[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (3))){
var state_45995__$1 = state_45995;
var statearr_46029_47234 = state_45995__$1;
(statearr_46029_47234[(2)] = false);

(statearr_46029_47234[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (12))){
var inst_45993 = (state_45995[(2)]);
var state_45995__$1 = state_45995;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45995__$1,inst_45993);
} else {
if((state_val_45996 === (2))){
var inst_45897 = (state_45995[(8)]);
var inst_45902 = inst_45897.cljs$lang$protocol_mask$partition0$;
var inst_45903 = (inst_45902 & (64));
var inst_45904 = inst_45897.cljs$core$ISeq$;
var inst_45905 = (cljs.core.PROTOCOL_SENTINEL === inst_45904);
var inst_45906 = ((inst_45903) || (inst_45905));
var state_45995__$1 = state_45995;
if(cljs.core.truth_(inst_45906)){
var statearr_46030_47241 = state_45995__$1;
(statearr_46030_47241[(1)] = (5));

} else {
var statearr_46031_47242 = state_45995__$1;
(statearr_46031_47242[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (23))){
var inst_45954 = (state_45995[(14)]);
var inst_45960 = (inst_45954 == null);
var state_45995__$1 = state_45995;
if(cljs.core.truth_(inst_45960)){
var statearr_46032_47243 = state_45995__$1;
(statearr_46032_47243[(1)] = (26));

} else {
var statearr_46033_47244 = state_45995__$1;
(statearr_46033_47244[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (35))){
var inst_45980 = (state_45995[(2)]);
var state_45995__$1 = state_45995;
if(cljs.core.truth_(inst_45980)){
var statearr_46034_47245 = state_45995__$1;
(statearr_46034_47245[(1)] = (36));

} else {
var statearr_46035_47246 = state_45995__$1;
(statearr_46035_47246[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (19))){
var inst_45922 = (state_45995[(7)]);
var inst_45942 = cljs.core.apply.call(null,cljs.core.hash_map,inst_45922);
var state_45995__$1 = state_45995;
var statearr_46036_47247 = state_45995__$1;
(statearr_46036_47247[(2)] = inst_45942);

(statearr_46036_47247[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (11))){
var inst_45922 = (state_45995[(7)]);
var inst_45926 = (inst_45922 == null);
var inst_45927 = cljs.core.not.call(null,inst_45926);
var state_45995__$1 = state_45995;
if(inst_45927){
var statearr_46037_47248 = state_45995__$1;
(statearr_46037_47248[(1)] = (13));

} else {
var statearr_46038_47249 = state_45995__$1;
(statearr_46038_47249[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (9))){
var inst_45897 = (state_45995[(8)]);
var state_45995__$1 = state_45995;
var statearr_46039_47250 = state_45995__$1;
(statearr_46039_47250[(2)] = inst_45897);

(statearr_46039_47250[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (5))){
var state_45995__$1 = state_45995;
var statearr_46040_47257 = state_45995__$1;
(statearr_46040_47257[(2)] = true);

(statearr_46040_47257[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (14))){
var state_45995__$1 = state_45995;
var statearr_46041_47258 = state_45995__$1;
(statearr_46041_47258[(2)] = false);

(statearr_46041_47258[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (26))){
var inst_45955 = (state_45995[(10)]);
var inst_45962 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_45955);
var state_45995__$1 = state_45995;
var statearr_46042_47259 = state_45995__$1;
(statearr_46042_47259[(2)] = inst_45962);

(statearr_46042_47259[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (16))){
var state_45995__$1 = state_45995;
var statearr_46043_47260 = state_45995__$1;
(statearr_46043_47260[(2)] = true);

(statearr_46043_47260[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (38))){
var inst_45985 = (state_45995[(2)]);
var state_45995__$1 = state_45995;
var statearr_46044_47261 = state_45995__$1;
(statearr_46044_47261[(2)] = inst_45985);

(statearr_46044_47261[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (30))){
var inst_45947 = (state_45995[(13)]);
var inst_45946 = (state_45995[(9)]);
var inst_45955 = (state_45995[(10)]);
var inst_45972 = cljs.core.empty_QMARK_.call(null,inst_45946);
var inst_45973 = inst_45947.call(null,inst_45955);
var inst_45974 = cljs.core.not.call(null,inst_45973);
var inst_45975 = ((inst_45972) && (inst_45974));
var state_45995__$1 = state_45995;
var statearr_46045_47262 = state_45995__$1;
(statearr_46045_47262[(2)] = inst_45975);

(statearr_46045_47262[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (10))){
var inst_45897 = (state_45995[(8)]);
var inst_45918 = (state_45995[(2)]);
var inst_45919 = cljs.core.get.call(null,inst_45918,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_45920 = cljs.core.get.call(null,inst_45918,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_45921 = cljs.core.get.call(null,inst_45918,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_45922 = inst_45897;
var state_45995__$1 = (function (){var statearr_46046 = state_45995;
(statearr_46046[(7)] = inst_45922);

(statearr_46046[(16)] = inst_45920);

(statearr_46046[(17)] = inst_45919);

(statearr_46046[(18)] = inst_45921);

return statearr_46046;
})();
var statearr_46047_47263 = state_45995__$1;
(statearr_46047_47263[(2)] = null);

(statearr_46047_47263[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (18))){
var inst_45937 = (state_45995[(2)]);
var state_45995__$1 = state_45995;
var statearr_46048_47264 = state_45995__$1;
(statearr_46048_47264[(2)] = inst_45937);

(statearr_46048_47264[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (37))){
var state_45995__$1 = state_45995;
var statearr_46049_47265 = state_45995__$1;
(statearr_46049_47265[(2)] = null);

(statearr_46049_47265[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45996 === (8))){
var inst_45897 = (state_45995[(8)]);
var inst_45915 = cljs.core.apply.call(null,cljs.core.hash_map,inst_45897);
var state_45995__$1 = state_45995;
var statearr_46050_47266 = state_45995__$1;
(statearr_46050_47266[(2)] = inst_45915);

(statearr_46050_47266[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___47173,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__45112__auto__,c__45200__auto___47173,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__45113__auto__ = null;
var cljs$core$async$mix_$_state_machine__45113__auto____0 = (function (){
var statearr_46051 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46051[(0)] = cljs$core$async$mix_$_state_machine__45113__auto__);

(statearr_46051[(1)] = (1));

return statearr_46051;
});
var cljs$core$async$mix_$_state_machine__45113__auto____1 = (function (state_45995){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_45995);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e46052){if((e46052 instanceof Object)){
var ex__45116__auto__ = e46052;
var statearr_46053_47273 = state_45995;
(statearr_46053_47273[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45995);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46052;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47274 = state_45995;
state_45995 = G__47274;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__45113__auto__ = function(state_45995){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__45113__auto____1.call(this,state_45995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__45113__auto____0;
cljs$core$async$mix_$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__45113__auto____1;
return cljs$core$async$mix_$_state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___47173,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__45202__auto__ = (function (){var statearr_46054 = f__45201__auto__.call(null);
(statearr_46054[(6)] = c__45200__auto___47173);

return statearr_46054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___47173,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__46056 = arguments.length;
switch (G__46056) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__46059 = arguments.length;
switch (G__46059) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4131__auto__,mults){
return (function (p1__46057_SHARP_){
if(cljs.core.truth_(p1__46057_SHARP_.call(null,topic))){
return p1__46057_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__46057_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46060 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46060 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta46061){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta46061 = meta46061;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async46060.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_46062,meta46061__$1){
var self__ = this;
var _46062__$1 = this;
return (new cljs.core.async.t_cljs$core$async46060(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta46061__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async46060.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_46062){
var self__ = this;
var _46062__$1 = this;
return self__.meta46061;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async46060.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46060.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async46060.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46060.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async46060.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async46060.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async46060.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async46060.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta46061","meta46061",-1095530562,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async46060.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46060.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46060";

cljs.core.async.t_cljs$core$async46060.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async46060");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46060.
 */
cljs.core.async.__GT_t_cljs$core$async46060 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async46060(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46061){
return (new cljs.core.async.t_cljs$core$async46060(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46061));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async46060(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__45200__auto___47288 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___47288,mults,ensure_mult,p){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___47288,mults,ensure_mult,p){
return (function (state_46134){
var state_val_46135 = (state_46134[(1)]);
if((state_val_46135 === (7))){
var inst_46130 = (state_46134[(2)]);
var state_46134__$1 = state_46134;
var statearr_46136_47290 = state_46134__$1;
(statearr_46136_47290[(2)] = inst_46130);

(statearr_46136_47290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (20))){
var state_46134__$1 = state_46134;
var statearr_46137_47293 = state_46134__$1;
(statearr_46137_47293[(2)] = null);

(statearr_46137_47293[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (1))){
var state_46134__$1 = state_46134;
var statearr_46138_47294 = state_46134__$1;
(statearr_46138_47294[(2)] = null);

(statearr_46138_47294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (24))){
var inst_46113 = (state_46134[(7)]);
var inst_46122 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_46113);
var state_46134__$1 = state_46134;
var statearr_46139_47296 = state_46134__$1;
(statearr_46139_47296[(2)] = inst_46122);

(statearr_46139_47296[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (4))){
var inst_46065 = (state_46134[(8)]);
var inst_46065__$1 = (state_46134[(2)]);
var inst_46066 = (inst_46065__$1 == null);
var state_46134__$1 = (function (){var statearr_46140 = state_46134;
(statearr_46140[(8)] = inst_46065__$1);

return statearr_46140;
})();
if(cljs.core.truth_(inst_46066)){
var statearr_46141_47297 = state_46134__$1;
(statearr_46141_47297[(1)] = (5));

} else {
var statearr_46142_47298 = state_46134__$1;
(statearr_46142_47298[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (15))){
var inst_46107 = (state_46134[(2)]);
var state_46134__$1 = state_46134;
var statearr_46143_47299 = state_46134__$1;
(statearr_46143_47299[(2)] = inst_46107);

(statearr_46143_47299[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (21))){
var inst_46127 = (state_46134[(2)]);
var state_46134__$1 = (function (){var statearr_46144 = state_46134;
(statearr_46144[(9)] = inst_46127);

return statearr_46144;
})();
var statearr_46145_47300 = state_46134__$1;
(statearr_46145_47300[(2)] = null);

(statearr_46145_47300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (13))){
var inst_46089 = (state_46134[(10)]);
var inst_46091 = cljs.core.chunked_seq_QMARK_.call(null,inst_46089);
var state_46134__$1 = state_46134;
if(inst_46091){
var statearr_46146_47301 = state_46134__$1;
(statearr_46146_47301[(1)] = (16));

} else {
var statearr_46147_47302 = state_46134__$1;
(statearr_46147_47302[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (22))){
var inst_46119 = (state_46134[(2)]);
var state_46134__$1 = state_46134;
if(cljs.core.truth_(inst_46119)){
var statearr_46148_47303 = state_46134__$1;
(statearr_46148_47303[(1)] = (23));

} else {
var statearr_46149_47304 = state_46134__$1;
(statearr_46149_47304[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (6))){
var inst_46065 = (state_46134[(8)]);
var inst_46113 = (state_46134[(7)]);
var inst_46115 = (state_46134[(11)]);
var inst_46113__$1 = topic_fn.call(null,inst_46065);
var inst_46114 = cljs.core.deref.call(null,mults);
var inst_46115__$1 = cljs.core.get.call(null,inst_46114,inst_46113__$1);
var state_46134__$1 = (function (){var statearr_46150 = state_46134;
(statearr_46150[(7)] = inst_46113__$1);

(statearr_46150[(11)] = inst_46115__$1);

return statearr_46150;
})();
if(cljs.core.truth_(inst_46115__$1)){
var statearr_46151_47306 = state_46134__$1;
(statearr_46151_47306[(1)] = (19));

} else {
var statearr_46152_47307 = state_46134__$1;
(statearr_46152_47307[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (25))){
var inst_46124 = (state_46134[(2)]);
var state_46134__$1 = state_46134;
var statearr_46153_47308 = state_46134__$1;
(statearr_46153_47308[(2)] = inst_46124);

(statearr_46153_47308[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (17))){
var inst_46089 = (state_46134[(10)]);
var inst_46098 = cljs.core.first.call(null,inst_46089);
var inst_46099 = cljs.core.async.muxch_STAR_.call(null,inst_46098);
var inst_46100 = cljs.core.async.close_BANG_.call(null,inst_46099);
var inst_46101 = cljs.core.next.call(null,inst_46089);
var inst_46075 = inst_46101;
var inst_46076 = null;
var inst_46077 = (0);
var inst_46078 = (0);
var state_46134__$1 = (function (){var statearr_46154 = state_46134;
(statearr_46154[(12)] = inst_46100);

(statearr_46154[(13)] = inst_46075);

(statearr_46154[(14)] = inst_46076);

(statearr_46154[(15)] = inst_46078);

(statearr_46154[(16)] = inst_46077);

return statearr_46154;
})();
var statearr_46155_47311 = state_46134__$1;
(statearr_46155_47311[(2)] = null);

(statearr_46155_47311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (3))){
var inst_46132 = (state_46134[(2)]);
var state_46134__$1 = state_46134;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46134__$1,inst_46132);
} else {
if((state_val_46135 === (12))){
var inst_46109 = (state_46134[(2)]);
var state_46134__$1 = state_46134;
var statearr_46156_47312 = state_46134__$1;
(statearr_46156_47312[(2)] = inst_46109);

(statearr_46156_47312[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (2))){
var state_46134__$1 = state_46134;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46134__$1,(4),ch);
} else {
if((state_val_46135 === (23))){
var state_46134__$1 = state_46134;
var statearr_46157_47314 = state_46134__$1;
(statearr_46157_47314[(2)] = null);

(statearr_46157_47314[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (19))){
var inst_46065 = (state_46134[(8)]);
var inst_46115 = (state_46134[(11)]);
var inst_46117 = cljs.core.async.muxch_STAR_.call(null,inst_46115);
var state_46134__$1 = state_46134;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46134__$1,(22),inst_46117,inst_46065);
} else {
if((state_val_46135 === (11))){
var inst_46075 = (state_46134[(13)]);
var inst_46089 = (state_46134[(10)]);
var inst_46089__$1 = cljs.core.seq.call(null,inst_46075);
var state_46134__$1 = (function (){var statearr_46158 = state_46134;
(statearr_46158[(10)] = inst_46089__$1);

return statearr_46158;
})();
if(inst_46089__$1){
var statearr_46159_47316 = state_46134__$1;
(statearr_46159_47316[(1)] = (13));

} else {
var statearr_46160_47317 = state_46134__$1;
(statearr_46160_47317[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (9))){
var inst_46111 = (state_46134[(2)]);
var state_46134__$1 = state_46134;
var statearr_46161_47318 = state_46134__$1;
(statearr_46161_47318[(2)] = inst_46111);

(statearr_46161_47318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (5))){
var inst_46072 = cljs.core.deref.call(null,mults);
var inst_46073 = cljs.core.vals.call(null,inst_46072);
var inst_46074 = cljs.core.seq.call(null,inst_46073);
var inst_46075 = inst_46074;
var inst_46076 = null;
var inst_46077 = (0);
var inst_46078 = (0);
var state_46134__$1 = (function (){var statearr_46162 = state_46134;
(statearr_46162[(13)] = inst_46075);

(statearr_46162[(14)] = inst_46076);

(statearr_46162[(15)] = inst_46078);

(statearr_46162[(16)] = inst_46077);

return statearr_46162;
})();
var statearr_46163_47320 = state_46134__$1;
(statearr_46163_47320[(2)] = null);

(statearr_46163_47320[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (14))){
var state_46134__$1 = state_46134;
var statearr_46167_47321 = state_46134__$1;
(statearr_46167_47321[(2)] = null);

(statearr_46167_47321[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (16))){
var inst_46089 = (state_46134[(10)]);
var inst_46093 = cljs.core.chunk_first.call(null,inst_46089);
var inst_46094 = cljs.core.chunk_rest.call(null,inst_46089);
var inst_46095 = cljs.core.count.call(null,inst_46093);
var inst_46075 = inst_46094;
var inst_46076 = inst_46093;
var inst_46077 = inst_46095;
var inst_46078 = (0);
var state_46134__$1 = (function (){var statearr_46168 = state_46134;
(statearr_46168[(13)] = inst_46075);

(statearr_46168[(14)] = inst_46076);

(statearr_46168[(15)] = inst_46078);

(statearr_46168[(16)] = inst_46077);

return statearr_46168;
})();
var statearr_46169_47322 = state_46134__$1;
(statearr_46169_47322[(2)] = null);

(statearr_46169_47322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (10))){
var inst_46075 = (state_46134[(13)]);
var inst_46076 = (state_46134[(14)]);
var inst_46078 = (state_46134[(15)]);
var inst_46077 = (state_46134[(16)]);
var inst_46083 = cljs.core._nth.call(null,inst_46076,inst_46078);
var inst_46084 = cljs.core.async.muxch_STAR_.call(null,inst_46083);
var inst_46085 = cljs.core.async.close_BANG_.call(null,inst_46084);
var inst_46086 = (inst_46078 + (1));
var tmp46164 = inst_46075;
var tmp46165 = inst_46076;
var tmp46166 = inst_46077;
var inst_46075__$1 = tmp46164;
var inst_46076__$1 = tmp46165;
var inst_46077__$1 = tmp46166;
var inst_46078__$1 = inst_46086;
var state_46134__$1 = (function (){var statearr_46170 = state_46134;
(statearr_46170[(13)] = inst_46075__$1);

(statearr_46170[(17)] = inst_46085);

(statearr_46170[(14)] = inst_46076__$1);

(statearr_46170[(15)] = inst_46078__$1);

(statearr_46170[(16)] = inst_46077__$1);

return statearr_46170;
})();
var statearr_46171_47333 = state_46134__$1;
(statearr_46171_47333[(2)] = null);

(statearr_46171_47333[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (18))){
var inst_46104 = (state_46134[(2)]);
var state_46134__$1 = state_46134;
var statearr_46172_47338 = state_46134__$1;
(statearr_46172_47338[(2)] = inst_46104);

(statearr_46172_47338[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46135 === (8))){
var inst_46078 = (state_46134[(15)]);
var inst_46077 = (state_46134[(16)]);
var inst_46080 = (inst_46078 < inst_46077);
var inst_46081 = inst_46080;
var state_46134__$1 = state_46134;
if(cljs.core.truth_(inst_46081)){
var statearr_46173_47342 = state_46134__$1;
(statearr_46173_47342[(1)] = (10));

} else {
var statearr_46174_47343 = state_46134__$1;
(statearr_46174_47343[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___47288,mults,ensure_mult,p))
;
return ((function (switch__45112__auto__,c__45200__auto___47288,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__45113__auto__ = null;
var cljs$core$async$state_machine__45113__auto____0 = (function (){
var statearr_46175 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46175[(0)] = cljs$core$async$state_machine__45113__auto__);

(statearr_46175[(1)] = (1));

return statearr_46175;
});
var cljs$core$async$state_machine__45113__auto____1 = (function (state_46134){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_46134);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e46176){if((e46176 instanceof Object)){
var ex__45116__auto__ = e46176;
var statearr_46177_47344 = state_46134;
(statearr_46177_47344[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46134);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46176;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47345 = state_46134;
state_46134 = G__47345;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$state_machine__45113__auto__ = function(state_46134){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45113__auto____1.call(this,state_46134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45113__auto____0;
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45113__auto____1;
return cljs$core$async$state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___47288,mults,ensure_mult,p))
})();
var state__45202__auto__ = (function (){var statearr_46178 = f__45201__auto__.call(null);
(statearr_46178[(6)] = c__45200__auto___47288);

return statearr_46178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___47288,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__46180 = arguments.length;
switch (G__46180) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__46182 = arguments.length;
switch (G__46182) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__46184 = arguments.length;
switch (G__46184) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__45200__auto___47392 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___47392,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___47392,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_46223){
var state_val_46224 = (state_46223[(1)]);
if((state_val_46224 === (7))){
var state_46223__$1 = state_46223;
var statearr_46225_47393 = state_46223__$1;
(statearr_46225_47393[(2)] = null);

(statearr_46225_47393[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46224 === (1))){
var state_46223__$1 = state_46223;
var statearr_46226_47394 = state_46223__$1;
(statearr_46226_47394[(2)] = null);

(statearr_46226_47394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46224 === (4))){
var inst_46187 = (state_46223[(7)]);
var inst_46189 = (inst_46187 < cnt);
var state_46223__$1 = state_46223;
if(cljs.core.truth_(inst_46189)){
var statearr_46227_47400 = state_46223__$1;
(statearr_46227_47400[(1)] = (6));

} else {
var statearr_46228_47402 = state_46223__$1;
(statearr_46228_47402[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46224 === (15))){
var inst_46219 = (state_46223[(2)]);
var state_46223__$1 = state_46223;
var statearr_46229_47408 = state_46223__$1;
(statearr_46229_47408[(2)] = inst_46219);

(statearr_46229_47408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46224 === (13))){
var inst_46212 = cljs.core.async.close_BANG_.call(null,out);
var state_46223__$1 = state_46223;
var statearr_46230_47416 = state_46223__$1;
(statearr_46230_47416[(2)] = inst_46212);

(statearr_46230_47416[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46224 === (6))){
var state_46223__$1 = state_46223;
var statearr_46231_47432 = state_46223__$1;
(statearr_46231_47432[(2)] = null);

(statearr_46231_47432[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46224 === (3))){
var inst_46221 = (state_46223[(2)]);
var state_46223__$1 = state_46223;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46223__$1,inst_46221);
} else {
if((state_val_46224 === (12))){
var inst_46209 = (state_46223[(8)]);
var inst_46209__$1 = (state_46223[(2)]);
var inst_46210 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_46209__$1);
var state_46223__$1 = (function (){var statearr_46232 = state_46223;
(statearr_46232[(8)] = inst_46209__$1);

return statearr_46232;
})();
if(cljs.core.truth_(inst_46210)){
var statearr_46233_47446 = state_46223__$1;
(statearr_46233_47446[(1)] = (13));

} else {
var statearr_46234_47448 = state_46223__$1;
(statearr_46234_47448[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46224 === (2))){
var inst_46186 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_46187 = (0);
var state_46223__$1 = (function (){var statearr_46235 = state_46223;
(statearr_46235[(7)] = inst_46187);

(statearr_46235[(9)] = inst_46186);

return statearr_46235;
})();
var statearr_46236_47486 = state_46223__$1;
(statearr_46236_47486[(2)] = null);

(statearr_46236_47486[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46224 === (11))){
var inst_46187 = (state_46223[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_46223,(10),Object,null,(9));
var inst_46196 = chs__$1.call(null,inst_46187);
var inst_46197 = done.call(null,inst_46187);
var inst_46198 = cljs.core.async.take_BANG_.call(null,inst_46196,inst_46197);
var state_46223__$1 = state_46223;
var statearr_46237_47495 = state_46223__$1;
(statearr_46237_47495[(2)] = inst_46198);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46223__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46224 === (9))){
var inst_46187 = (state_46223[(7)]);
var inst_46200 = (state_46223[(2)]);
var inst_46201 = (inst_46187 + (1));
var inst_46187__$1 = inst_46201;
var state_46223__$1 = (function (){var statearr_46238 = state_46223;
(statearr_46238[(7)] = inst_46187__$1);

(statearr_46238[(10)] = inst_46200);

return statearr_46238;
})();
var statearr_46239_47496 = state_46223__$1;
(statearr_46239_47496[(2)] = null);

(statearr_46239_47496[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46224 === (5))){
var inst_46207 = (state_46223[(2)]);
var state_46223__$1 = (function (){var statearr_46240 = state_46223;
(statearr_46240[(11)] = inst_46207);

return statearr_46240;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46223__$1,(12),dchan);
} else {
if((state_val_46224 === (14))){
var inst_46209 = (state_46223[(8)]);
var inst_46214 = cljs.core.apply.call(null,f,inst_46209);
var state_46223__$1 = state_46223;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46223__$1,(16),out,inst_46214);
} else {
if((state_val_46224 === (16))){
var inst_46216 = (state_46223[(2)]);
var state_46223__$1 = (function (){var statearr_46241 = state_46223;
(statearr_46241[(12)] = inst_46216);

return statearr_46241;
})();
var statearr_46242_47497 = state_46223__$1;
(statearr_46242_47497[(2)] = null);

(statearr_46242_47497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46224 === (10))){
var inst_46191 = (state_46223[(2)]);
var inst_46192 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_46223__$1 = (function (){var statearr_46243 = state_46223;
(statearr_46243[(13)] = inst_46191);

return statearr_46243;
})();
var statearr_46244_47498 = state_46223__$1;
(statearr_46244_47498[(2)] = inst_46192);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46223__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46224 === (8))){
var inst_46205 = (state_46223[(2)]);
var state_46223__$1 = state_46223;
var statearr_46245_47499 = state_46223__$1;
(statearr_46245_47499[(2)] = inst_46205);

(statearr_46245_47499[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___47392,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__45112__auto__,c__45200__auto___47392,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__45113__auto__ = null;
var cljs$core$async$state_machine__45113__auto____0 = (function (){
var statearr_46246 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46246[(0)] = cljs$core$async$state_machine__45113__auto__);

(statearr_46246[(1)] = (1));

return statearr_46246;
});
var cljs$core$async$state_machine__45113__auto____1 = (function (state_46223){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_46223);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e46247){if((e46247 instanceof Object)){
var ex__45116__auto__ = e46247;
var statearr_46248_47516 = state_46223;
(statearr_46248_47516[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46223);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46247;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47518 = state_46223;
state_46223 = G__47518;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$state_machine__45113__auto__ = function(state_46223){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45113__auto____1.call(this,state_46223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45113__auto____0;
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45113__auto____1;
return cljs$core$async$state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___47392,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__45202__auto__ = (function (){var statearr_46249 = f__45201__auto__.call(null);
(statearr_46249[(6)] = c__45200__auto___47392);

return statearr_46249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___47392,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__46252 = arguments.length;
switch (G__46252) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__45200__auto___47524 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___47524,out){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___47524,out){
return (function (state_46284){
var state_val_46285 = (state_46284[(1)]);
if((state_val_46285 === (7))){
var inst_46264 = (state_46284[(7)]);
var inst_46263 = (state_46284[(8)]);
var inst_46263__$1 = (state_46284[(2)]);
var inst_46264__$1 = cljs.core.nth.call(null,inst_46263__$1,(0),null);
var inst_46265 = cljs.core.nth.call(null,inst_46263__$1,(1),null);
var inst_46266 = (inst_46264__$1 == null);
var state_46284__$1 = (function (){var statearr_46286 = state_46284;
(statearr_46286[(9)] = inst_46265);

(statearr_46286[(7)] = inst_46264__$1);

(statearr_46286[(8)] = inst_46263__$1);

return statearr_46286;
})();
if(cljs.core.truth_(inst_46266)){
var statearr_46287_47525 = state_46284__$1;
(statearr_46287_47525[(1)] = (8));

} else {
var statearr_46288_47526 = state_46284__$1;
(statearr_46288_47526[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46285 === (1))){
var inst_46253 = cljs.core.vec.call(null,chs);
var inst_46254 = inst_46253;
var state_46284__$1 = (function (){var statearr_46289 = state_46284;
(statearr_46289[(10)] = inst_46254);

return statearr_46289;
})();
var statearr_46290_47527 = state_46284__$1;
(statearr_46290_47527[(2)] = null);

(statearr_46290_47527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46285 === (4))){
var inst_46254 = (state_46284[(10)]);
var state_46284__$1 = state_46284;
return cljs.core.async.ioc_alts_BANG_.call(null,state_46284__$1,(7),inst_46254);
} else {
if((state_val_46285 === (6))){
var inst_46280 = (state_46284[(2)]);
var state_46284__$1 = state_46284;
var statearr_46291_47530 = state_46284__$1;
(statearr_46291_47530[(2)] = inst_46280);

(statearr_46291_47530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46285 === (3))){
var inst_46282 = (state_46284[(2)]);
var state_46284__$1 = state_46284;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46284__$1,inst_46282);
} else {
if((state_val_46285 === (2))){
var inst_46254 = (state_46284[(10)]);
var inst_46256 = cljs.core.count.call(null,inst_46254);
var inst_46257 = (inst_46256 > (0));
var state_46284__$1 = state_46284;
if(cljs.core.truth_(inst_46257)){
var statearr_46293_47546 = state_46284__$1;
(statearr_46293_47546[(1)] = (4));

} else {
var statearr_46294_47548 = state_46284__$1;
(statearr_46294_47548[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46285 === (11))){
var inst_46254 = (state_46284[(10)]);
var inst_46273 = (state_46284[(2)]);
var tmp46292 = inst_46254;
var inst_46254__$1 = tmp46292;
var state_46284__$1 = (function (){var statearr_46295 = state_46284;
(statearr_46295[(11)] = inst_46273);

(statearr_46295[(10)] = inst_46254__$1);

return statearr_46295;
})();
var statearr_46296_47558 = state_46284__$1;
(statearr_46296_47558[(2)] = null);

(statearr_46296_47558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46285 === (9))){
var inst_46264 = (state_46284[(7)]);
var state_46284__$1 = state_46284;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46284__$1,(11),out,inst_46264);
} else {
if((state_val_46285 === (5))){
var inst_46278 = cljs.core.async.close_BANG_.call(null,out);
var state_46284__$1 = state_46284;
var statearr_46297_47563 = state_46284__$1;
(statearr_46297_47563[(2)] = inst_46278);

(statearr_46297_47563[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46285 === (10))){
var inst_46276 = (state_46284[(2)]);
var state_46284__$1 = state_46284;
var statearr_46298_47567 = state_46284__$1;
(statearr_46298_47567[(2)] = inst_46276);

(statearr_46298_47567[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46285 === (8))){
var inst_46265 = (state_46284[(9)]);
var inst_46254 = (state_46284[(10)]);
var inst_46264 = (state_46284[(7)]);
var inst_46263 = (state_46284[(8)]);
var inst_46268 = (function (){var cs = inst_46254;
var vec__46259 = inst_46263;
var v = inst_46264;
var c = inst_46265;
return ((function (cs,vec__46259,v,c,inst_46265,inst_46254,inst_46264,inst_46263,state_val_46285,c__45200__auto___47524,out){
return (function (p1__46250_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__46250_SHARP_);
});
;})(cs,vec__46259,v,c,inst_46265,inst_46254,inst_46264,inst_46263,state_val_46285,c__45200__auto___47524,out))
})();
var inst_46269 = cljs.core.filterv.call(null,inst_46268,inst_46254);
var inst_46254__$1 = inst_46269;
var state_46284__$1 = (function (){var statearr_46299 = state_46284;
(statearr_46299[(10)] = inst_46254__$1);

return statearr_46299;
})();
var statearr_46300_47579 = state_46284__$1;
(statearr_46300_47579[(2)] = null);

(statearr_46300_47579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___47524,out))
;
return ((function (switch__45112__auto__,c__45200__auto___47524,out){
return (function() {
var cljs$core$async$state_machine__45113__auto__ = null;
var cljs$core$async$state_machine__45113__auto____0 = (function (){
var statearr_46301 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46301[(0)] = cljs$core$async$state_machine__45113__auto__);

(statearr_46301[(1)] = (1));

return statearr_46301;
});
var cljs$core$async$state_machine__45113__auto____1 = (function (state_46284){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_46284);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e46302){if((e46302 instanceof Object)){
var ex__45116__auto__ = e46302;
var statearr_46303_47581 = state_46284;
(statearr_46303_47581[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46284);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46302;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47598 = state_46284;
state_46284 = G__47598;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$state_machine__45113__auto__ = function(state_46284){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45113__auto____1.call(this,state_46284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45113__auto____0;
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45113__auto____1;
return cljs$core$async$state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___47524,out))
})();
var state__45202__auto__ = (function (){var statearr_46304 = f__45201__auto__.call(null);
(statearr_46304[(6)] = c__45200__auto___47524);

return statearr_46304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___47524,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__46306 = arguments.length;
switch (G__46306) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__45200__auto___47603 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___47603,out){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___47603,out){
return (function (state_46330){
var state_val_46331 = (state_46330[(1)]);
if((state_val_46331 === (7))){
var inst_46312 = (state_46330[(7)]);
var inst_46312__$1 = (state_46330[(2)]);
var inst_46313 = (inst_46312__$1 == null);
var inst_46314 = cljs.core.not.call(null,inst_46313);
var state_46330__$1 = (function (){var statearr_46332 = state_46330;
(statearr_46332[(7)] = inst_46312__$1);

return statearr_46332;
})();
if(inst_46314){
var statearr_46333_47612 = state_46330__$1;
(statearr_46333_47612[(1)] = (8));

} else {
var statearr_46334_47613 = state_46330__$1;
(statearr_46334_47613[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46331 === (1))){
var inst_46307 = (0);
var state_46330__$1 = (function (){var statearr_46335 = state_46330;
(statearr_46335[(8)] = inst_46307);

return statearr_46335;
})();
var statearr_46336_47621 = state_46330__$1;
(statearr_46336_47621[(2)] = null);

(statearr_46336_47621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46331 === (4))){
var state_46330__$1 = state_46330;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46330__$1,(7),ch);
} else {
if((state_val_46331 === (6))){
var inst_46325 = (state_46330[(2)]);
var state_46330__$1 = state_46330;
var statearr_46337_47622 = state_46330__$1;
(statearr_46337_47622[(2)] = inst_46325);

(statearr_46337_47622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46331 === (3))){
var inst_46327 = (state_46330[(2)]);
var inst_46328 = cljs.core.async.close_BANG_.call(null,out);
var state_46330__$1 = (function (){var statearr_46338 = state_46330;
(statearr_46338[(9)] = inst_46327);

return statearr_46338;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46330__$1,inst_46328);
} else {
if((state_val_46331 === (2))){
var inst_46307 = (state_46330[(8)]);
var inst_46309 = (inst_46307 < n);
var state_46330__$1 = state_46330;
if(cljs.core.truth_(inst_46309)){
var statearr_46339_47627 = state_46330__$1;
(statearr_46339_47627[(1)] = (4));

} else {
var statearr_46340_47628 = state_46330__$1;
(statearr_46340_47628[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46331 === (11))){
var inst_46307 = (state_46330[(8)]);
var inst_46317 = (state_46330[(2)]);
var inst_46318 = (inst_46307 + (1));
var inst_46307__$1 = inst_46318;
var state_46330__$1 = (function (){var statearr_46341 = state_46330;
(statearr_46341[(10)] = inst_46317);

(statearr_46341[(8)] = inst_46307__$1);

return statearr_46341;
})();
var statearr_46342_47629 = state_46330__$1;
(statearr_46342_47629[(2)] = null);

(statearr_46342_47629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46331 === (9))){
var state_46330__$1 = state_46330;
var statearr_46343_47630 = state_46330__$1;
(statearr_46343_47630[(2)] = null);

(statearr_46343_47630[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46331 === (5))){
var state_46330__$1 = state_46330;
var statearr_46344_47631 = state_46330__$1;
(statearr_46344_47631[(2)] = null);

(statearr_46344_47631[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46331 === (10))){
var inst_46322 = (state_46330[(2)]);
var state_46330__$1 = state_46330;
var statearr_46345_47633 = state_46330__$1;
(statearr_46345_47633[(2)] = inst_46322);

(statearr_46345_47633[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46331 === (8))){
var inst_46312 = (state_46330[(7)]);
var state_46330__$1 = state_46330;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46330__$1,(11),out,inst_46312);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___47603,out))
;
return ((function (switch__45112__auto__,c__45200__auto___47603,out){
return (function() {
var cljs$core$async$state_machine__45113__auto__ = null;
var cljs$core$async$state_machine__45113__auto____0 = (function (){
var statearr_46346 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46346[(0)] = cljs$core$async$state_machine__45113__auto__);

(statearr_46346[(1)] = (1));

return statearr_46346;
});
var cljs$core$async$state_machine__45113__auto____1 = (function (state_46330){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_46330);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e46347){if((e46347 instanceof Object)){
var ex__45116__auto__ = e46347;
var statearr_46348_47637 = state_46330;
(statearr_46348_47637[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46330);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46347;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47638 = state_46330;
state_46330 = G__47638;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$state_machine__45113__auto__ = function(state_46330){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45113__auto____1.call(this,state_46330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45113__auto____0;
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45113__auto____1;
return cljs$core$async$state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___47603,out))
})();
var state__45202__auto__ = (function (){var statearr_46349 = f__45201__auto__.call(null);
(statearr_46349[(6)] = c__45200__auto___47603);

return statearr_46349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___47603,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46351 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46351 = (function (f,ch,meta46352){
this.f = f;
this.ch = ch;
this.meta46352 = meta46352;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async46351.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46353,meta46352__$1){
var self__ = this;
var _46353__$1 = this;
return (new cljs.core.async.t_cljs$core$async46351(self__.f,self__.ch,meta46352__$1));
});

cljs.core.async.t_cljs$core$async46351.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46353){
var self__ = this;
var _46353__$1 = this;
return self__.meta46352;
});

cljs.core.async.t_cljs$core$async46351.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46351.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async46351.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async46351.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46351.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46354 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46354 = (function (f,ch,meta46352,_,fn1,meta46355){
this.f = f;
this.ch = ch;
this.meta46352 = meta46352;
this._ = _;
this.fn1 = fn1;
this.meta46355 = meta46355;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async46354.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_46356,meta46355__$1){
var self__ = this;
var _46356__$1 = this;
return (new cljs.core.async.t_cljs$core$async46354(self__.f,self__.ch,self__.meta46352,self__._,self__.fn1,meta46355__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async46354.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_46356){
var self__ = this;
var _46356__$1 = this;
return self__.meta46355;
});})(___$1))
;

cljs.core.async.t_cljs$core$async46354.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46354.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async46354.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async46354.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__46350_SHARP_){
return f1.call(null,(((p1__46350_SHARP_ == null))?null:self__.f.call(null,p1__46350_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async46354.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46352","meta46352",-2091206884,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async46351","cljs.core.async/t_cljs$core$async46351",1807450735,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta46355","meta46355",1888499380,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async46354.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46354.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46354";

cljs.core.async.t_cljs$core$async46354.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async46354");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46354.
 */
cljs.core.async.__GT_t_cljs$core$async46354 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async46354(f__$1,ch__$1,meta46352__$1,___$2,fn1__$1,meta46355){
return (new cljs.core.async.t_cljs$core$async46354(f__$1,ch__$1,meta46352__$1,___$2,fn1__$1,meta46355));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async46354(self__.f,self__.ch,self__.meta46352,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async46351.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46351.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async46351.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46352","meta46352",-2091206884,null)], null);
});

cljs.core.async.t_cljs$core$async46351.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46351.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46351";

cljs.core.async.t_cljs$core$async46351.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async46351");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46351.
 */
cljs.core.async.__GT_t_cljs$core$async46351 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async46351(f__$1,ch__$1,meta46352){
return (new cljs.core.async.t_cljs$core$async46351(f__$1,ch__$1,meta46352));
});

}

return (new cljs.core.async.t_cljs$core$async46351(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46357 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46357 = (function (f,ch,meta46358){
this.f = f;
this.ch = ch;
this.meta46358 = meta46358;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async46357.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46359,meta46358__$1){
var self__ = this;
var _46359__$1 = this;
return (new cljs.core.async.t_cljs$core$async46357(self__.f,self__.ch,meta46358__$1));
});

cljs.core.async.t_cljs$core$async46357.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46359){
var self__ = this;
var _46359__$1 = this;
return self__.meta46358;
});

cljs.core.async.t_cljs$core$async46357.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46357.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async46357.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46357.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async46357.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46357.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async46357.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46358","meta46358",1223944948,null)], null);
});

cljs.core.async.t_cljs$core$async46357.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46357.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46357";

cljs.core.async.t_cljs$core$async46357.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async46357");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46357.
 */
cljs.core.async.__GT_t_cljs$core$async46357 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async46357(f__$1,ch__$1,meta46358){
return (new cljs.core.async.t_cljs$core$async46357(f__$1,ch__$1,meta46358));
});

}

return (new cljs.core.async.t_cljs$core$async46357(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46360 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46360 = (function (p,ch,meta46361){
this.p = p;
this.ch = ch;
this.meta46361 = meta46361;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async46360.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46362,meta46361__$1){
var self__ = this;
var _46362__$1 = this;
return (new cljs.core.async.t_cljs$core$async46360(self__.p,self__.ch,meta46361__$1));
});

cljs.core.async.t_cljs$core$async46360.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46362){
var self__ = this;
var _46362__$1 = this;
return self__.meta46361;
});

cljs.core.async.t_cljs$core$async46360.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46360.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async46360.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async46360.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46360.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async46360.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46360.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async46360.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta46361","meta46361",-1661756994,null)], null);
});

cljs.core.async.t_cljs$core$async46360.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46360.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46360";

cljs.core.async.t_cljs$core$async46360.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async46360");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46360.
 */
cljs.core.async.__GT_t_cljs$core$async46360 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async46360(p__$1,ch__$1,meta46361){
return (new cljs.core.async.t_cljs$core$async46360(p__$1,ch__$1,meta46361));
});

}

return (new cljs.core.async.t_cljs$core$async46360(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__46364 = arguments.length;
switch (G__46364) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__45200__auto___47663 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___47663,out){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___47663,out){
return (function (state_46385){
var state_val_46386 = (state_46385[(1)]);
if((state_val_46386 === (7))){
var inst_46381 = (state_46385[(2)]);
var state_46385__$1 = state_46385;
var statearr_46387_47664 = state_46385__$1;
(statearr_46387_47664[(2)] = inst_46381);

(statearr_46387_47664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46386 === (1))){
var state_46385__$1 = state_46385;
var statearr_46388_47666 = state_46385__$1;
(statearr_46388_47666[(2)] = null);

(statearr_46388_47666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46386 === (4))){
var inst_46367 = (state_46385[(7)]);
var inst_46367__$1 = (state_46385[(2)]);
var inst_46368 = (inst_46367__$1 == null);
var state_46385__$1 = (function (){var statearr_46389 = state_46385;
(statearr_46389[(7)] = inst_46367__$1);

return statearr_46389;
})();
if(cljs.core.truth_(inst_46368)){
var statearr_46390_47667 = state_46385__$1;
(statearr_46390_47667[(1)] = (5));

} else {
var statearr_46391_47668 = state_46385__$1;
(statearr_46391_47668[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46386 === (6))){
var inst_46367 = (state_46385[(7)]);
var inst_46372 = p.call(null,inst_46367);
var state_46385__$1 = state_46385;
if(cljs.core.truth_(inst_46372)){
var statearr_46392_47669 = state_46385__$1;
(statearr_46392_47669[(1)] = (8));

} else {
var statearr_46393_47670 = state_46385__$1;
(statearr_46393_47670[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46386 === (3))){
var inst_46383 = (state_46385[(2)]);
var state_46385__$1 = state_46385;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46385__$1,inst_46383);
} else {
if((state_val_46386 === (2))){
var state_46385__$1 = state_46385;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46385__$1,(4),ch);
} else {
if((state_val_46386 === (11))){
var inst_46375 = (state_46385[(2)]);
var state_46385__$1 = state_46385;
var statearr_46394_47671 = state_46385__$1;
(statearr_46394_47671[(2)] = inst_46375);

(statearr_46394_47671[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46386 === (9))){
var state_46385__$1 = state_46385;
var statearr_46395_47672 = state_46385__$1;
(statearr_46395_47672[(2)] = null);

(statearr_46395_47672[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46386 === (5))){
var inst_46370 = cljs.core.async.close_BANG_.call(null,out);
var state_46385__$1 = state_46385;
var statearr_46396_47673 = state_46385__$1;
(statearr_46396_47673[(2)] = inst_46370);

(statearr_46396_47673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46386 === (10))){
var inst_46378 = (state_46385[(2)]);
var state_46385__$1 = (function (){var statearr_46397 = state_46385;
(statearr_46397[(8)] = inst_46378);

return statearr_46397;
})();
var statearr_46398_47674 = state_46385__$1;
(statearr_46398_47674[(2)] = null);

(statearr_46398_47674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46386 === (8))){
var inst_46367 = (state_46385[(7)]);
var state_46385__$1 = state_46385;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46385__$1,(11),out,inst_46367);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___47663,out))
;
return ((function (switch__45112__auto__,c__45200__auto___47663,out){
return (function() {
var cljs$core$async$state_machine__45113__auto__ = null;
var cljs$core$async$state_machine__45113__auto____0 = (function (){
var statearr_46399 = [null,null,null,null,null,null,null,null,null];
(statearr_46399[(0)] = cljs$core$async$state_machine__45113__auto__);

(statearr_46399[(1)] = (1));

return statearr_46399;
});
var cljs$core$async$state_machine__45113__auto____1 = (function (state_46385){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_46385);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e46400){if((e46400 instanceof Object)){
var ex__45116__auto__ = e46400;
var statearr_46401_47675 = state_46385;
(statearr_46401_47675[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46385);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46400;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47678 = state_46385;
state_46385 = G__47678;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$state_machine__45113__auto__ = function(state_46385){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45113__auto____1.call(this,state_46385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45113__auto____0;
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45113__auto____1;
return cljs$core$async$state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___47663,out))
})();
var state__45202__auto__ = (function (){var statearr_46402 = f__45201__auto__.call(null);
(statearr_46402[(6)] = c__45200__auto___47663);

return statearr_46402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___47663,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__46404 = arguments.length;
switch (G__46404) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__45200__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto__){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto__){
return (function (state_46466){
var state_val_46467 = (state_46466[(1)]);
if((state_val_46467 === (7))){
var inst_46462 = (state_46466[(2)]);
var state_46466__$1 = state_46466;
var statearr_46468_47680 = state_46466__$1;
(statearr_46468_47680[(2)] = inst_46462);

(statearr_46468_47680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (20))){
var inst_46432 = (state_46466[(7)]);
var inst_46443 = (state_46466[(2)]);
var inst_46444 = cljs.core.next.call(null,inst_46432);
var inst_46418 = inst_46444;
var inst_46419 = null;
var inst_46420 = (0);
var inst_46421 = (0);
var state_46466__$1 = (function (){var statearr_46469 = state_46466;
(statearr_46469[(8)] = inst_46420);

(statearr_46469[(9)] = inst_46418);

(statearr_46469[(10)] = inst_46443);

(statearr_46469[(11)] = inst_46419);

(statearr_46469[(12)] = inst_46421);

return statearr_46469;
})();
var statearr_46470_47694 = state_46466__$1;
(statearr_46470_47694[(2)] = null);

(statearr_46470_47694[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (1))){
var state_46466__$1 = state_46466;
var statearr_46471_47695 = state_46466__$1;
(statearr_46471_47695[(2)] = null);

(statearr_46471_47695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (4))){
var inst_46407 = (state_46466[(13)]);
var inst_46407__$1 = (state_46466[(2)]);
var inst_46408 = (inst_46407__$1 == null);
var state_46466__$1 = (function (){var statearr_46472 = state_46466;
(statearr_46472[(13)] = inst_46407__$1);

return statearr_46472;
})();
if(cljs.core.truth_(inst_46408)){
var statearr_46473_47703 = state_46466__$1;
(statearr_46473_47703[(1)] = (5));

} else {
var statearr_46474_47709 = state_46466__$1;
(statearr_46474_47709[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (15))){
var state_46466__$1 = state_46466;
var statearr_46478_47714 = state_46466__$1;
(statearr_46478_47714[(2)] = null);

(statearr_46478_47714[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (21))){
var state_46466__$1 = state_46466;
var statearr_46479_47721 = state_46466__$1;
(statearr_46479_47721[(2)] = null);

(statearr_46479_47721[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (13))){
var inst_46420 = (state_46466[(8)]);
var inst_46418 = (state_46466[(9)]);
var inst_46419 = (state_46466[(11)]);
var inst_46421 = (state_46466[(12)]);
var inst_46428 = (state_46466[(2)]);
var inst_46429 = (inst_46421 + (1));
var tmp46475 = inst_46420;
var tmp46476 = inst_46418;
var tmp46477 = inst_46419;
var inst_46418__$1 = tmp46476;
var inst_46419__$1 = tmp46477;
var inst_46420__$1 = tmp46475;
var inst_46421__$1 = inst_46429;
var state_46466__$1 = (function (){var statearr_46480 = state_46466;
(statearr_46480[(8)] = inst_46420__$1);

(statearr_46480[(14)] = inst_46428);

(statearr_46480[(9)] = inst_46418__$1);

(statearr_46480[(11)] = inst_46419__$1);

(statearr_46480[(12)] = inst_46421__$1);

return statearr_46480;
})();
var statearr_46481_47723 = state_46466__$1;
(statearr_46481_47723[(2)] = null);

(statearr_46481_47723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (22))){
var state_46466__$1 = state_46466;
var statearr_46482_47725 = state_46466__$1;
(statearr_46482_47725[(2)] = null);

(statearr_46482_47725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (6))){
var inst_46407 = (state_46466[(13)]);
var inst_46416 = f.call(null,inst_46407);
var inst_46417 = cljs.core.seq.call(null,inst_46416);
var inst_46418 = inst_46417;
var inst_46419 = null;
var inst_46420 = (0);
var inst_46421 = (0);
var state_46466__$1 = (function (){var statearr_46483 = state_46466;
(statearr_46483[(8)] = inst_46420);

(statearr_46483[(9)] = inst_46418);

(statearr_46483[(11)] = inst_46419);

(statearr_46483[(12)] = inst_46421);

return statearr_46483;
})();
var statearr_46484_47726 = state_46466__$1;
(statearr_46484_47726[(2)] = null);

(statearr_46484_47726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (17))){
var inst_46432 = (state_46466[(7)]);
var inst_46436 = cljs.core.chunk_first.call(null,inst_46432);
var inst_46437 = cljs.core.chunk_rest.call(null,inst_46432);
var inst_46438 = cljs.core.count.call(null,inst_46436);
var inst_46418 = inst_46437;
var inst_46419 = inst_46436;
var inst_46420 = inst_46438;
var inst_46421 = (0);
var state_46466__$1 = (function (){var statearr_46485 = state_46466;
(statearr_46485[(8)] = inst_46420);

(statearr_46485[(9)] = inst_46418);

(statearr_46485[(11)] = inst_46419);

(statearr_46485[(12)] = inst_46421);

return statearr_46485;
})();
var statearr_46486_47731 = state_46466__$1;
(statearr_46486_47731[(2)] = null);

(statearr_46486_47731[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (3))){
var inst_46464 = (state_46466[(2)]);
var state_46466__$1 = state_46466;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46466__$1,inst_46464);
} else {
if((state_val_46467 === (12))){
var inst_46452 = (state_46466[(2)]);
var state_46466__$1 = state_46466;
var statearr_46487_47732 = state_46466__$1;
(statearr_46487_47732[(2)] = inst_46452);

(statearr_46487_47732[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (2))){
var state_46466__$1 = state_46466;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46466__$1,(4),in$);
} else {
if((state_val_46467 === (23))){
var inst_46460 = (state_46466[(2)]);
var state_46466__$1 = state_46466;
var statearr_46488_47733 = state_46466__$1;
(statearr_46488_47733[(2)] = inst_46460);

(statearr_46488_47733[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (19))){
var inst_46447 = (state_46466[(2)]);
var state_46466__$1 = state_46466;
var statearr_46489_47738 = state_46466__$1;
(statearr_46489_47738[(2)] = inst_46447);

(statearr_46489_47738[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (11))){
var inst_46418 = (state_46466[(9)]);
var inst_46432 = (state_46466[(7)]);
var inst_46432__$1 = cljs.core.seq.call(null,inst_46418);
var state_46466__$1 = (function (){var statearr_46490 = state_46466;
(statearr_46490[(7)] = inst_46432__$1);

return statearr_46490;
})();
if(inst_46432__$1){
var statearr_46491_47739 = state_46466__$1;
(statearr_46491_47739[(1)] = (14));

} else {
var statearr_46492_47741 = state_46466__$1;
(statearr_46492_47741[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (9))){
var inst_46454 = (state_46466[(2)]);
var inst_46455 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_46466__$1 = (function (){var statearr_46493 = state_46466;
(statearr_46493[(15)] = inst_46454);

return statearr_46493;
})();
if(cljs.core.truth_(inst_46455)){
var statearr_46494_47748 = state_46466__$1;
(statearr_46494_47748[(1)] = (21));

} else {
var statearr_46495_47750 = state_46466__$1;
(statearr_46495_47750[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (5))){
var inst_46410 = cljs.core.async.close_BANG_.call(null,out);
var state_46466__$1 = state_46466;
var statearr_46496_47755 = state_46466__$1;
(statearr_46496_47755[(2)] = inst_46410);

(statearr_46496_47755[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (14))){
var inst_46432 = (state_46466[(7)]);
var inst_46434 = cljs.core.chunked_seq_QMARK_.call(null,inst_46432);
var state_46466__$1 = state_46466;
if(inst_46434){
var statearr_46497_47762 = state_46466__$1;
(statearr_46497_47762[(1)] = (17));

} else {
var statearr_46498_47779 = state_46466__$1;
(statearr_46498_47779[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (16))){
var inst_46450 = (state_46466[(2)]);
var state_46466__$1 = state_46466;
var statearr_46499_47788 = state_46466__$1;
(statearr_46499_47788[(2)] = inst_46450);

(statearr_46499_47788[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46467 === (10))){
var inst_46419 = (state_46466[(11)]);
var inst_46421 = (state_46466[(12)]);
var inst_46426 = cljs.core._nth.call(null,inst_46419,inst_46421);
var state_46466__$1 = state_46466;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46466__$1,(13),out,inst_46426);
} else {
if((state_val_46467 === (18))){
var inst_46432 = (state_46466[(7)]);
var inst_46441 = cljs.core.first.call(null,inst_46432);
var state_46466__$1 = state_46466;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46466__$1,(20),out,inst_46441);
} else {
if((state_val_46467 === (8))){
var inst_46420 = (state_46466[(8)]);
var inst_46421 = (state_46466[(12)]);
var inst_46423 = (inst_46421 < inst_46420);
var inst_46424 = inst_46423;
var state_46466__$1 = state_46466;
if(cljs.core.truth_(inst_46424)){
var statearr_46500_47827 = state_46466__$1;
(statearr_46500_47827[(1)] = (10));

} else {
var statearr_46501_47828 = state_46466__$1;
(statearr_46501_47828[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto__))
;
return ((function (switch__45112__auto__,c__45200__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__45113__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__45113__auto____0 = (function (){
var statearr_46502 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46502[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__45113__auto__);

(statearr_46502[(1)] = (1));

return statearr_46502;
});
var cljs$core$async$mapcat_STAR__$_state_machine__45113__auto____1 = (function (state_46466){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_46466);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e46503){if((e46503 instanceof Object)){
var ex__45116__auto__ = e46503;
var statearr_46504_47844 = state_46466;
(statearr_46504_47844[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46466);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46503;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47845 = state_46466;
state_46466 = G__47845;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__45113__auto__ = function(state_46466){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__45113__auto____1.call(this,state_46466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__45113__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__45113__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto__))
})();
var state__45202__auto__ = (function (){var statearr_46505 = f__45201__auto__.call(null);
(statearr_46505[(6)] = c__45200__auto__);

return statearr_46505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto__))
);

return c__45200__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__46507 = arguments.length;
switch (G__46507) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__46509 = arguments.length;
switch (G__46509) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__46511 = arguments.length;
switch (G__46511) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__45200__auto___47867 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___47867,out){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___47867,out){
return (function (state_46535){
var state_val_46536 = (state_46535[(1)]);
if((state_val_46536 === (7))){
var inst_46530 = (state_46535[(2)]);
var state_46535__$1 = state_46535;
var statearr_46537_47868 = state_46535__$1;
(statearr_46537_47868[(2)] = inst_46530);

(statearr_46537_47868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46536 === (1))){
var inst_46512 = null;
var state_46535__$1 = (function (){var statearr_46538 = state_46535;
(statearr_46538[(7)] = inst_46512);

return statearr_46538;
})();
var statearr_46539_47873 = state_46535__$1;
(statearr_46539_47873[(2)] = null);

(statearr_46539_47873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46536 === (4))){
var inst_46515 = (state_46535[(8)]);
var inst_46515__$1 = (state_46535[(2)]);
var inst_46516 = (inst_46515__$1 == null);
var inst_46517 = cljs.core.not.call(null,inst_46516);
var state_46535__$1 = (function (){var statearr_46540 = state_46535;
(statearr_46540[(8)] = inst_46515__$1);

return statearr_46540;
})();
if(inst_46517){
var statearr_46541_47875 = state_46535__$1;
(statearr_46541_47875[(1)] = (5));

} else {
var statearr_46542_47876 = state_46535__$1;
(statearr_46542_47876[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46536 === (6))){
var state_46535__$1 = state_46535;
var statearr_46543_47877 = state_46535__$1;
(statearr_46543_47877[(2)] = null);

(statearr_46543_47877[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46536 === (3))){
var inst_46532 = (state_46535[(2)]);
var inst_46533 = cljs.core.async.close_BANG_.call(null,out);
var state_46535__$1 = (function (){var statearr_46544 = state_46535;
(statearr_46544[(9)] = inst_46532);

return statearr_46544;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46535__$1,inst_46533);
} else {
if((state_val_46536 === (2))){
var state_46535__$1 = state_46535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46535__$1,(4),ch);
} else {
if((state_val_46536 === (11))){
var inst_46515 = (state_46535[(8)]);
var inst_46524 = (state_46535[(2)]);
var inst_46512 = inst_46515;
var state_46535__$1 = (function (){var statearr_46545 = state_46535;
(statearr_46545[(10)] = inst_46524);

(statearr_46545[(7)] = inst_46512);

return statearr_46545;
})();
var statearr_46546_47881 = state_46535__$1;
(statearr_46546_47881[(2)] = null);

(statearr_46546_47881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46536 === (9))){
var inst_46515 = (state_46535[(8)]);
var state_46535__$1 = state_46535;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46535__$1,(11),out,inst_46515);
} else {
if((state_val_46536 === (5))){
var inst_46512 = (state_46535[(7)]);
var inst_46515 = (state_46535[(8)]);
var inst_46519 = cljs.core._EQ_.call(null,inst_46515,inst_46512);
var state_46535__$1 = state_46535;
if(inst_46519){
var statearr_46548_47882 = state_46535__$1;
(statearr_46548_47882[(1)] = (8));

} else {
var statearr_46549_47883 = state_46535__$1;
(statearr_46549_47883[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46536 === (10))){
var inst_46527 = (state_46535[(2)]);
var state_46535__$1 = state_46535;
var statearr_46550_47884 = state_46535__$1;
(statearr_46550_47884[(2)] = inst_46527);

(statearr_46550_47884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46536 === (8))){
var inst_46512 = (state_46535[(7)]);
var tmp46547 = inst_46512;
var inst_46512__$1 = tmp46547;
var state_46535__$1 = (function (){var statearr_46551 = state_46535;
(statearr_46551[(7)] = inst_46512__$1);

return statearr_46551;
})();
var statearr_46552_47885 = state_46535__$1;
(statearr_46552_47885[(2)] = null);

(statearr_46552_47885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___47867,out))
;
return ((function (switch__45112__auto__,c__45200__auto___47867,out){
return (function() {
var cljs$core$async$state_machine__45113__auto__ = null;
var cljs$core$async$state_machine__45113__auto____0 = (function (){
var statearr_46553 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46553[(0)] = cljs$core$async$state_machine__45113__auto__);

(statearr_46553[(1)] = (1));

return statearr_46553;
});
var cljs$core$async$state_machine__45113__auto____1 = (function (state_46535){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_46535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e46554){if((e46554 instanceof Object)){
var ex__45116__auto__ = e46554;
var statearr_46555_47886 = state_46535;
(statearr_46555_47886[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46535);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46554;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47887 = state_46535;
state_46535 = G__47887;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$state_machine__45113__auto__ = function(state_46535){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45113__auto____1.call(this,state_46535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45113__auto____0;
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45113__auto____1;
return cljs$core$async$state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___47867,out))
})();
var state__45202__auto__ = (function (){var statearr_46556 = f__45201__auto__.call(null);
(statearr_46556[(6)] = c__45200__auto___47867);

return statearr_46556;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___47867,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__46558 = arguments.length;
switch (G__46558) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__45200__auto___47889 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___47889,out){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___47889,out){
return (function (state_46596){
var state_val_46597 = (state_46596[(1)]);
if((state_val_46597 === (7))){
var inst_46592 = (state_46596[(2)]);
var state_46596__$1 = state_46596;
var statearr_46598_47894 = state_46596__$1;
(statearr_46598_47894[(2)] = inst_46592);

(statearr_46598_47894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46597 === (1))){
var inst_46559 = (new Array(n));
var inst_46560 = inst_46559;
var inst_46561 = (0);
var state_46596__$1 = (function (){var statearr_46599 = state_46596;
(statearr_46599[(7)] = inst_46561);

(statearr_46599[(8)] = inst_46560);

return statearr_46599;
})();
var statearr_46600_47895 = state_46596__$1;
(statearr_46600_47895[(2)] = null);

(statearr_46600_47895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46597 === (4))){
var inst_46564 = (state_46596[(9)]);
var inst_46564__$1 = (state_46596[(2)]);
var inst_46565 = (inst_46564__$1 == null);
var inst_46566 = cljs.core.not.call(null,inst_46565);
var state_46596__$1 = (function (){var statearr_46601 = state_46596;
(statearr_46601[(9)] = inst_46564__$1);

return statearr_46601;
})();
if(inst_46566){
var statearr_46602_47896 = state_46596__$1;
(statearr_46602_47896[(1)] = (5));

} else {
var statearr_46603_47897 = state_46596__$1;
(statearr_46603_47897[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46597 === (15))){
var inst_46586 = (state_46596[(2)]);
var state_46596__$1 = state_46596;
var statearr_46604_47898 = state_46596__$1;
(statearr_46604_47898[(2)] = inst_46586);

(statearr_46604_47898[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46597 === (13))){
var state_46596__$1 = state_46596;
var statearr_46605_47899 = state_46596__$1;
(statearr_46605_47899[(2)] = null);

(statearr_46605_47899[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46597 === (6))){
var inst_46561 = (state_46596[(7)]);
var inst_46582 = (inst_46561 > (0));
var state_46596__$1 = state_46596;
if(cljs.core.truth_(inst_46582)){
var statearr_46606_47900 = state_46596__$1;
(statearr_46606_47900[(1)] = (12));

} else {
var statearr_46607_47902 = state_46596__$1;
(statearr_46607_47902[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46597 === (3))){
var inst_46594 = (state_46596[(2)]);
var state_46596__$1 = state_46596;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46596__$1,inst_46594);
} else {
if((state_val_46597 === (12))){
var inst_46560 = (state_46596[(8)]);
var inst_46584 = cljs.core.vec.call(null,inst_46560);
var state_46596__$1 = state_46596;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46596__$1,(15),out,inst_46584);
} else {
if((state_val_46597 === (2))){
var state_46596__$1 = state_46596;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46596__$1,(4),ch);
} else {
if((state_val_46597 === (11))){
var inst_46576 = (state_46596[(2)]);
var inst_46577 = (new Array(n));
var inst_46560 = inst_46577;
var inst_46561 = (0);
var state_46596__$1 = (function (){var statearr_46608 = state_46596;
(statearr_46608[(7)] = inst_46561);

(statearr_46608[(8)] = inst_46560);

(statearr_46608[(10)] = inst_46576);

return statearr_46608;
})();
var statearr_46609_47905 = state_46596__$1;
(statearr_46609_47905[(2)] = null);

(statearr_46609_47905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46597 === (9))){
var inst_46560 = (state_46596[(8)]);
var inst_46574 = cljs.core.vec.call(null,inst_46560);
var state_46596__$1 = state_46596;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46596__$1,(11),out,inst_46574);
} else {
if((state_val_46597 === (5))){
var inst_46561 = (state_46596[(7)]);
var inst_46560 = (state_46596[(8)]);
var inst_46569 = (state_46596[(11)]);
var inst_46564 = (state_46596[(9)]);
var inst_46568 = (inst_46560[inst_46561] = inst_46564);
var inst_46569__$1 = (inst_46561 + (1));
var inst_46570 = (inst_46569__$1 < n);
var state_46596__$1 = (function (){var statearr_46610 = state_46596;
(statearr_46610[(11)] = inst_46569__$1);

(statearr_46610[(12)] = inst_46568);

return statearr_46610;
})();
if(cljs.core.truth_(inst_46570)){
var statearr_46611_47906 = state_46596__$1;
(statearr_46611_47906[(1)] = (8));

} else {
var statearr_46612_47907 = state_46596__$1;
(statearr_46612_47907[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46597 === (14))){
var inst_46589 = (state_46596[(2)]);
var inst_46590 = cljs.core.async.close_BANG_.call(null,out);
var state_46596__$1 = (function (){var statearr_46614 = state_46596;
(statearr_46614[(13)] = inst_46589);

return statearr_46614;
})();
var statearr_46615_47916 = state_46596__$1;
(statearr_46615_47916[(2)] = inst_46590);

(statearr_46615_47916[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46597 === (10))){
var inst_46580 = (state_46596[(2)]);
var state_46596__$1 = state_46596;
var statearr_46616_47917 = state_46596__$1;
(statearr_46616_47917[(2)] = inst_46580);

(statearr_46616_47917[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46597 === (8))){
var inst_46560 = (state_46596[(8)]);
var inst_46569 = (state_46596[(11)]);
var tmp46613 = inst_46560;
var inst_46560__$1 = tmp46613;
var inst_46561 = inst_46569;
var state_46596__$1 = (function (){var statearr_46617 = state_46596;
(statearr_46617[(7)] = inst_46561);

(statearr_46617[(8)] = inst_46560__$1);

return statearr_46617;
})();
var statearr_46618_47918 = state_46596__$1;
(statearr_46618_47918[(2)] = null);

(statearr_46618_47918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___47889,out))
;
return ((function (switch__45112__auto__,c__45200__auto___47889,out){
return (function() {
var cljs$core$async$state_machine__45113__auto__ = null;
var cljs$core$async$state_machine__45113__auto____0 = (function (){
var statearr_46619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46619[(0)] = cljs$core$async$state_machine__45113__auto__);

(statearr_46619[(1)] = (1));

return statearr_46619;
});
var cljs$core$async$state_machine__45113__auto____1 = (function (state_46596){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_46596);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e46620){if((e46620 instanceof Object)){
var ex__45116__auto__ = e46620;
var statearr_46621_47919 = state_46596;
(statearr_46621_47919[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46596);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46620;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47920 = state_46596;
state_46596 = G__47920;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$state_machine__45113__auto__ = function(state_46596){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45113__auto____1.call(this,state_46596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45113__auto____0;
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45113__auto____1;
return cljs$core$async$state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___47889,out))
})();
var state__45202__auto__ = (function (){var statearr_46622 = f__45201__auto__.call(null);
(statearr_46622[(6)] = c__45200__auto___47889);

return statearr_46622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___47889,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__46624 = arguments.length;
switch (G__46624) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__45200__auto___47922 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__45200__auto___47922,out){
return (function (){
var f__45201__auto__ = (function (){var switch__45112__auto__ = ((function (c__45200__auto___47922,out){
return (function (state_46666){
var state_val_46667 = (state_46666[(1)]);
if((state_val_46667 === (7))){
var inst_46662 = (state_46666[(2)]);
var state_46666__$1 = state_46666;
var statearr_46668_47923 = state_46666__$1;
(statearr_46668_47923[(2)] = inst_46662);

(statearr_46668_47923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46667 === (1))){
var inst_46625 = [];
var inst_46626 = inst_46625;
var inst_46627 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_46666__$1 = (function (){var statearr_46669 = state_46666;
(statearr_46669[(7)] = inst_46626);

(statearr_46669[(8)] = inst_46627);

return statearr_46669;
})();
var statearr_46670_47924 = state_46666__$1;
(statearr_46670_47924[(2)] = null);

(statearr_46670_47924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46667 === (4))){
var inst_46630 = (state_46666[(9)]);
var inst_46630__$1 = (state_46666[(2)]);
var inst_46631 = (inst_46630__$1 == null);
var inst_46632 = cljs.core.not.call(null,inst_46631);
var state_46666__$1 = (function (){var statearr_46671 = state_46666;
(statearr_46671[(9)] = inst_46630__$1);

return statearr_46671;
})();
if(inst_46632){
var statearr_46672_47932 = state_46666__$1;
(statearr_46672_47932[(1)] = (5));

} else {
var statearr_46673_47933 = state_46666__$1;
(statearr_46673_47933[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46667 === (15))){
var inst_46656 = (state_46666[(2)]);
var state_46666__$1 = state_46666;
var statearr_46674_47934 = state_46666__$1;
(statearr_46674_47934[(2)] = inst_46656);

(statearr_46674_47934[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46667 === (13))){
var state_46666__$1 = state_46666;
var statearr_46675_47935 = state_46666__$1;
(statearr_46675_47935[(2)] = null);

(statearr_46675_47935[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46667 === (6))){
var inst_46626 = (state_46666[(7)]);
var inst_46651 = inst_46626.length;
var inst_46652 = (inst_46651 > (0));
var state_46666__$1 = state_46666;
if(cljs.core.truth_(inst_46652)){
var statearr_46676_47936 = state_46666__$1;
(statearr_46676_47936[(1)] = (12));

} else {
var statearr_46677_47937 = state_46666__$1;
(statearr_46677_47937[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46667 === (3))){
var inst_46664 = (state_46666[(2)]);
var state_46666__$1 = state_46666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46666__$1,inst_46664);
} else {
if((state_val_46667 === (12))){
var inst_46626 = (state_46666[(7)]);
var inst_46654 = cljs.core.vec.call(null,inst_46626);
var state_46666__$1 = state_46666;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46666__$1,(15),out,inst_46654);
} else {
if((state_val_46667 === (2))){
var state_46666__$1 = state_46666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46666__$1,(4),ch);
} else {
if((state_val_46667 === (11))){
var inst_46630 = (state_46666[(9)]);
var inst_46634 = (state_46666[(10)]);
var inst_46644 = (state_46666[(2)]);
var inst_46645 = [];
var inst_46646 = inst_46645.push(inst_46630);
var inst_46626 = inst_46645;
var inst_46627 = inst_46634;
var state_46666__$1 = (function (){var statearr_46678 = state_46666;
(statearr_46678[(11)] = inst_46644);

(statearr_46678[(7)] = inst_46626);

(statearr_46678[(8)] = inst_46627);

(statearr_46678[(12)] = inst_46646);

return statearr_46678;
})();
var statearr_46679_47938 = state_46666__$1;
(statearr_46679_47938[(2)] = null);

(statearr_46679_47938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46667 === (9))){
var inst_46626 = (state_46666[(7)]);
var inst_46642 = cljs.core.vec.call(null,inst_46626);
var state_46666__$1 = state_46666;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46666__$1,(11),out,inst_46642);
} else {
if((state_val_46667 === (5))){
var inst_46630 = (state_46666[(9)]);
var inst_46634 = (state_46666[(10)]);
var inst_46627 = (state_46666[(8)]);
var inst_46634__$1 = f.call(null,inst_46630);
var inst_46635 = cljs.core._EQ_.call(null,inst_46634__$1,inst_46627);
var inst_46636 = cljs.core.keyword_identical_QMARK_.call(null,inst_46627,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_46637 = ((inst_46635) || (inst_46636));
var state_46666__$1 = (function (){var statearr_46680 = state_46666;
(statearr_46680[(10)] = inst_46634__$1);

return statearr_46680;
})();
if(cljs.core.truth_(inst_46637)){
var statearr_46681_47939 = state_46666__$1;
(statearr_46681_47939[(1)] = (8));

} else {
var statearr_46682_47940 = state_46666__$1;
(statearr_46682_47940[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46667 === (14))){
var inst_46659 = (state_46666[(2)]);
var inst_46660 = cljs.core.async.close_BANG_.call(null,out);
var state_46666__$1 = (function (){var statearr_46684 = state_46666;
(statearr_46684[(13)] = inst_46659);

return statearr_46684;
})();
var statearr_46685_47941 = state_46666__$1;
(statearr_46685_47941[(2)] = inst_46660);

(statearr_46685_47941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46667 === (10))){
var inst_46649 = (state_46666[(2)]);
var state_46666__$1 = state_46666;
var statearr_46686_47942 = state_46666__$1;
(statearr_46686_47942[(2)] = inst_46649);

(statearr_46686_47942[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46667 === (8))){
var inst_46630 = (state_46666[(9)]);
var inst_46626 = (state_46666[(7)]);
var inst_46634 = (state_46666[(10)]);
var inst_46639 = inst_46626.push(inst_46630);
var tmp46683 = inst_46626;
var inst_46626__$1 = tmp46683;
var inst_46627 = inst_46634;
var state_46666__$1 = (function (){var statearr_46687 = state_46666;
(statearr_46687[(7)] = inst_46626__$1);

(statearr_46687[(14)] = inst_46639);

(statearr_46687[(8)] = inst_46627);

return statearr_46687;
})();
var statearr_46688_47947 = state_46666__$1;
(statearr_46688_47947[(2)] = null);

(statearr_46688_47947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__45200__auto___47922,out))
;
return ((function (switch__45112__auto__,c__45200__auto___47922,out){
return (function() {
var cljs$core$async$state_machine__45113__auto__ = null;
var cljs$core$async$state_machine__45113__auto____0 = (function (){
var statearr_46689 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46689[(0)] = cljs$core$async$state_machine__45113__auto__);

(statearr_46689[(1)] = (1));

return statearr_46689;
});
var cljs$core$async$state_machine__45113__auto____1 = (function (state_46666){
while(true){
var ret_value__45114__auto__ = (function (){try{while(true){
var result__45115__auto__ = switch__45112__auto__.call(null,state_46666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__45115__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45115__auto__;
}
break;
}
}catch (e46690){if((e46690 instanceof Object)){
var ex__45116__auto__ = e46690;
var statearr_46691_47954 = state_46666;
(statearr_46691_47954[(5)] = ex__45116__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46666);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46690;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__45114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47958 = state_46666;
state_46666 = G__47958;
continue;
} else {
return ret_value__45114__auto__;
}
break;
}
});
cljs$core$async$state_machine__45113__auto__ = function(state_46666){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45113__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45113__auto____1.call(this,state_46666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45113__auto____0;
cljs$core$async$state_machine__45113__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45113__auto____1;
return cljs$core$async$state_machine__45113__auto__;
})()
;})(switch__45112__auto__,c__45200__auto___47922,out))
})();
var state__45202__auto__ = (function (){var statearr_46692 = f__45201__auto__.call(null);
(statearr_46692[(6)] = c__45200__auto___47922);

return statearr_46692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__45202__auto__);
});})(c__45200__auto___47922,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=cljs.core.async.js.map
