goog.provide('shadow.object');
goog.require('cljs.core');
goog.require('shadow.dom');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('clojure.data');
goog.require('cljs.core.async.impl.protocols');
goog.require('shadow.util');
shadow.object.console_friendly = shadow.util.console_friendly;
shadow.object.log = shadow.util.log;
shadow.object.debug = shadow.util.log;
shadow.object.info = shadow.util.log;
shadow.object.warn = shadow.util.log;
shadow.object.error = shadow.util.log;
shadow.object.obj_id = cljs.core.atom.call(null,(0));
shadow.object.next_id = (function shadow$object$next_id(){
return cljs.core.swap_BANG_.call(null,shadow.object.obj_id,cljs.core.inc);
});
shadow.object.object_defs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.behavior_fns = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instances = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instance_parent = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.instance_children = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.events = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
shadow.object.define_event = (function shadow$object$define_event(event_name,desc,args){
return cljs.core.swap_BANG_.call(null,shadow.object.events,cljs.core.assoc,event_name,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),event_name,new cljs.core.Keyword(null,"description","description",-1428560544),desc,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
});
shadow.object.unmunge = (function shadow$object$unmunge(s){
return clojure.string.replace.call(null,clojure.string.replace.call(null,s,/_DOT_/,"."),/_/,"-");
});
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"init","init",-1875481434),"object initialization",cljs.core.PersistentVector.EMPTY);
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"destroy","destroy",-843660405),"object descruction",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cause","cause",231901252),"cause of destruction, :parent means the parent was destroyed, :direct is default"], null)], null));
shadow.object.define_event.call(null,new cljs.core.Keyword("dom","init","dom/init",-1875647652),"called after the dom was created but has not entered the document yet",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dom","dom",-1236537922),"the dom that was created"], null)], null));
shadow.object.define_event.call(null,new cljs.core.Keyword("dom","entered","dom/entered",506699596),"should be called whenever a dom node is added to the document, since that\n   is not in control of this library its up to you to call this\n   use (so/notify-tree! your-obj :dom/entered) to notify the node and every child you created",cljs.core.PersistentVector.EMPTY);
shadow.object.define_event.call(null,new cljs.core.Keyword(null,"bind-children-update","bind-children-update",-1610690160),"need to rethink this",cljs.core.PersistentVector.EMPTY);

/**
 * @interface
 */
shadow.object.IObject = function(){};

var shadow$object$IObject$_id$dyn_57159 = (function (this$){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (shadow.object._id[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$);
} else {
var m__6344__auto__ = (shadow.object._id["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-id",this$);
}
}
});
shadow.object._id = (function shadow$object$_id(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_id$arity$1 == null)))))){
return this$.shadow$object$IObject$_id$arity$1(this$);
} else {
return shadow$object$IObject$_id$dyn_57159.call(null,this$);
}
});

var shadow$object$IObject$_type$dyn_57160 = (function (this$){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (shadow.object._type[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$);
} else {
var m__6344__auto__ = (shadow.object._type["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-type",this$);
}
}
});
shadow.object._type = (function shadow$object$_type(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_type$arity$1 == null)))))){
return this$.shadow$object$IObject$_type$arity$1(this$);
} else {
return shadow$object$IObject$_type$dyn_57160.call(null,this$);
}
});

var shadow$object$IObject$_data$dyn_57162 = (function (this$){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (shadow.object._data[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$);
} else {
var m__6344__auto__ = (shadow.object._data["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-data",this$);
}
}
});
shadow.object._data = (function shadow$object$_data(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_data$arity$1 == null)))))){
return this$.shadow$object$IObject$_data$arity$1(this$);
} else {
return shadow$object$IObject$_data$dyn_57162.call(null,this$);
}
});

var shadow$object$IObject$_update$dyn_57163 = (function (this$,update_fn){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (shadow.object._update[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,update_fn);
} else {
var m__6344__auto__ = (shadow.object._update["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,update_fn);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-update",this$);
}
}
});
/**
 * update and notify watches
 */
shadow.object._update = (function shadow$object$_update(this$,update_fn){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_update$arity$2 == null)))))){
return this$.shadow$object$IObject$_update$arity$2(this$,update_fn);
} else {
return shadow$object$IObject$_update$dyn_57163.call(null,this$,update_fn);
}
});

var shadow$object$IObject$_destroy_BANG_$dyn_57164 = (function (this$,cause){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (shadow.object._destroy_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$,cause);
} else {
var m__6344__auto__ = (shadow.object._destroy_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$,cause);
} else {
throw cljs.core.missing_protocol.call(null,"IObject.-destroy!",this$);
}
}
});
shadow.object._destroy_BANG_ = (function shadow$object$_destroy_BANG_(this$,cause){
if((((!((this$ == null)))) && ((!((this$.shadow$object$IObject$_destroy_BANG_$arity$2 == null)))))){
return this$.shadow$object$IObject$_destroy_BANG_$arity$2(this$,cause);
} else {
return shadow$object$IObject$_destroy_BANG_$dyn_57164.call(null,this$,cause);
}
});

shadow.object.get_type = (function shadow$object$get_type(this$){
return shadow.object._type.call(null,this$);
});
shadow.object.get_type_attr = (function shadow$object$get_type_attr(var_args){
var G__56570 = arguments.length;
switch (G__56570) {
case 2:
return shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$2 = (function (oref,key){
if((oref == null)){
return null;
} else {
var type_id = (((oref instanceof cljs.core.Keyword))?oref:shadow.object._type.call(null,oref));
return cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_id,key], null));
}
}));

(shadow.object.get_type_attr.cljs$core$IFn$_invoke$arity$3 = (function (oref,key,default$){
if((oref == null)){
return default$;
} else {
var type_id = (((oref instanceof cljs.core.Keyword))?oref:shadow.object._type.call(null,oref));
return cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_id,key], null),default$);
}
}));

(shadow.object.get_type_attr.cljs$lang$maxFixedArity = 3);

shadow.object.get_dom = (function shadow$object$get_dom(oref){
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(oref);
});
goog.exportSymbol('shadow.object.get_dom', shadow.object.get_dom);
shadow.object.get_by_id = (function shadow$object$get_by_id(id){
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instances),id);
});
goog.exportSymbol('shadow.object.get_by_id', shadow.object.get_by_id);
shadow.object.get_from_dom = (function shadow$object$get_from_dom(dom){
var oid = shadow.dom.data.call(null,dom,new cljs.core.Keyword(null,"oid","oid",-768692334));
if(cljs.core.truth_(oid)){
return shadow.object.get_by_id.call(null,parseInt(oid,(10)));
} else {
return null;
}
});
goog.exportSymbol('shadow.object.get_from_dom', shadow.object.get_from_dom);
shadow.object.is_object_QMARK_ = (function shadow$object$is_object_QMARK_(obj_or_dom){
var or__5598__auto__ = (((!((obj_or_dom == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj_or_dom.shadow$object$IObject$))))?true:(((!obj_or_dom.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom));
if(or__5598__auto__){
return or__5598__auto__;
} else {
return shadow.object.get_from_dom.call(null,obj_or_dom);
}
});
shadow.object.equal_QMARK_ = (function shadow$object$equal_QMARK_(obj,obj_or_dom){
if((((!((obj == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj.shadow$object$IObject$))))?true:(((!obj.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj))){
} else {
throw (new Error(["Assert failed: ","can only test objects","\n","(satisfies? IObject obj)"].join('')));
}

if((((!((obj_or_dom == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === obj_or_dom.shadow$object$IObject$))))?true:(((!obj_or_dom.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,obj_or_dom))){
return cljs.core._EQ_.call(null,shadow.object._id.call(null,obj),shadow.object._id.call(null,obj_or_dom));
} else {
return cljs.core._EQ_.call(null,shadow.object._id.call(null,obj),(function (){var temp__5720__auto__ = shadow.dom.data.call(null,obj_or_dom,new cljs.core.Keyword(null,"oid","oid",-768692334));
if(cljs.core.truth_(temp__5720__auto__)){
var oid = temp__5720__auto__;
return parseInt(oid,(10));
} else {
return null;
}
})());
}
});
shadow.object.get_parent = (function shadow$object$get_parent(oref){
var temp__5720__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_parent),shadow.object._id.call(null,oref));
if(cljs.core.truth_(temp__5720__auto__)){
var parent_id = temp__5720__auto__;
return cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instances),parent_id);
} else {
return null;
}
});
goog.exportSymbol('shadow.object.get_parent', shadow.object.get_parent);
shadow.object.get_parent_of_type = (function shadow$object$get_parent_of_type(oref,parent_type){
var parent = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(oref);
while(true){
if(cljs.core.truth_(parent)){
if(cljs.core._EQ_.call(null,shadow.object._type.call(null,parent),parent_type)){
return parent;
} else {
var G__57184 = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(parent);
parent = G__57184;
continue;
}
} else {
return null;
}
break;
}
});
goog.exportSymbol('shadow.object.get_parent_of_type', shadow.object.get_parent_of_type);
shadow.object.get_children = (function shadow$object$get_children(parent){
var parent_id = shadow.object._id.call(null,parent);
var child_ids = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_children),parent_id,cljs.core.PersistentVector.EMPTY);
var instances = cljs.core.deref.call(null,shadow.object.instances);
return cljs.core.vec.call(null,cljs.core.map.call(null,(function (p1__56621_SHARP_){
return cljs.core.get.call(null,instances,p1__56621_SHARP_);
}),child_ids));
});
goog.exportSymbol('shadow.object.get_children', shadow.object.get_children);
shadow.object.tree_seq = (function shadow$object$tree_seq(var_args){
var G__56625 = arguments.length;
switch (G__56625) {
case 1:
return shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('shadow.object.tree_seq', shadow.object.tree_seq);

(shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$1 = (function (root){
return shadow.object.tree_seq.call(null,root,(function (node){
return true;
}));
}));

(shadow.object.tree_seq.cljs$core$IFn$_invoke$arity$2 = (function (root,branch_QMARK_){
return cljs.core.tree_seq.call(null,branch_QMARK_,shadow.object.get_children,root);
}));

(shadow.object.tree_seq.cljs$lang$maxFixedArity = 2);

shadow.object.get_children_of_type = (function shadow$object$get_children_of_type(oref,type){
var type_kw = (((type instanceof cljs.core.Keyword))?type:shadow.object._type.call(null,type));
return cljs.core.filter.call(null,(function (p1__56627_SHARP_){
return cljs.core._EQ_.call(null,type_kw,shadow.object._type.call(null,p1__56627_SHARP_));
}),shadow.object.get_children.call(null,oref));
});
/**
 * basically (get-children (:parent this))
 */
shadow.object.get_siblings = (function shadow$object$get_siblings(p__56628){
var map__56629 = p__56628;
var map__56629__$1 = (((((!((map__56629 == null))))?(((((map__56629.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56629.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56629):map__56629);
var oref = map__56629__$1;
var parent = cljs.core.get.call(null,map__56629__$1,new cljs.core.Keyword(null,"parent","parent",-878878779));
if(cljs.core.truth_(parent)){
} else {
throw cljs.core.ex_info.call(null,"object has no parent, thus has no siblings",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref], null));
}

return shadow.object.get_children.call(null,parent);
});
/**
 * returns set of all siblings of a common type
 */
shadow.object.get_siblings_of_type = (function shadow$object$get_siblings_of_type(var_args){
var G__56634 = arguments.length;
switch (G__56634) {
case 1:
return shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$1 = (function (oref){
return shadow.object.get_siblings_of_type.call(null,oref,oref);
}));

(shadow.object.get_siblings_of_type.cljs$core$IFn$_invoke$arity$2 = (function (oref,type){
var type_kw = (((type instanceof cljs.core.Keyword))?type:shadow.object._type.call(null,type));
return cljs.core.filter.call(null,(function (p1__56631_SHARP_){
return cljs.core._EQ_.call(null,type_kw,shadow.object._type.call(null,p1__56631_SHARP_));
}),shadow.object.get_siblings.call(null,oref));
}));

(shadow.object.get_siblings_of_type.cljs$lang$maxFixedArity = 2);

shadow.object.get_collection_item = (function shadow$object$get_collection_item(oref){
var item_key = new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366).cljs$core$IFn$_invoke$arity$1(oref);
return cljs.core.get.call(null,oref,item_key);
});
/**
 * find the object that contains this dom node
 */
shadow.object.find_containing_object = (function shadow$object$find_containing_object(dom){
while(true){
var temp__5718__auto__ = shadow.object.get_from_dom.call(null,dom);
if(cljs.core.truth_(temp__5718__auto__)){
var obj = temp__5718__auto__;
return obj;
} else {
var temp__5720__auto__ = dom.parentElement;
if(cljs.core.truth_(temp__5720__auto__)){
var parent = temp__5720__auto__;
var G__57193 = parent;
dom = G__57193;
continue;
} else {
return null;
}
}
break;
}
});
shadow.object.notify_BANG_ = (function shadow$object$notify_BANG_(var_args){
var args__6930__auto__ = [];
var len__6920__auto___57194 = arguments.length;
var i__6921__auto___57195 = (0);
while(true){
if((i__6921__auto___57195 < len__6920__auto___57194)){
args__6930__auto__.push((arguments[i__6921__auto___57195]));

var G__57196 = (i__6921__auto___57195 + (1));
i__6921__auto___57195 = G__57196;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((2) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6931__auto__);
});

(shadow.object.notify_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var temp__5720__auto__ = cljs.core.get_in.call(null,oref,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),ev], null));
if(cljs.core.truth_(temp__5720__auto__)){
var reactions_to_trigger = temp__5720__auto__;
var seq__56649 = cljs.core.seq.call(null,reactions_to_trigger);
var chunk__56650 = null;
var count__56651 = (0);
var i__56652 = (0);
while(true){
if((i__56652 < count__56651)){
var rfn = cljs.core._nth.call(null,chunk__56650,i__56652);
cljs.core.apply.call(null,rfn,cljs.core.cons.call(null,oref,args));


var G__57211 = seq__56649;
var G__57212 = chunk__56650;
var G__57213 = count__56651;
var G__57214 = (i__56652 + (1));
seq__56649 = G__57211;
chunk__56650 = G__57212;
count__56651 = G__57213;
i__56652 = G__57214;
continue;
} else {
var temp__5720__auto____$1 = cljs.core.seq.call(null,seq__56649);
if(temp__5720__auto____$1){
var seq__56649__$1 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56649__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__56649__$1);
var G__57221 = cljs.core.chunk_rest.call(null,seq__56649__$1);
var G__57222 = c__6568__auto__;
var G__57223 = cljs.core.count.call(null,c__6568__auto__);
var G__57224 = (0);
seq__56649 = G__57221;
chunk__56650 = G__57222;
count__56651 = G__57223;
i__56652 = G__57224;
continue;
} else {
var rfn = cljs.core.first.call(null,seq__56649__$1);
cljs.core.apply.call(null,rfn,cljs.core.cons.call(null,oref,args));


var G__57228 = cljs.core.next.call(null,seq__56649__$1);
var G__57229 = null;
var G__57230 = (0);
var G__57231 = (0);
seq__56649 = G__57228;
chunk__56650 = G__57229;
count__56651 = G__57230;
i__56652 = G__57231;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
}));

(shadow.object.notify_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.notify_BANG_.cljs$lang$applyTo = (function (seq56635){
var G__56636 = cljs.core.first.call(null,seq56635);
var seq56635__$1 = cljs.core.next.call(null,seq56635);
var G__56637 = cljs.core.first.call(null,seq56635__$1);
var seq56635__$2 = cljs.core.next.call(null,seq56635__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56636,G__56637,seq56635__$2);
}));

shadow.object.do_notify_tree = (function shadow$object$do_notify_tree(current_obj,ev,notify_fn){
var seq__56703_57235 = cljs.core.seq.call(null,shadow.object.get_children.call(null,current_obj));
var chunk__56704_57236 = null;
var count__56705_57237 = (0);
var i__56706_57238 = (0);
while(true){
if((i__56706_57238 < count__56705_57237)){
var child_57239 = cljs.core._nth.call(null,chunk__56704_57236,i__56706_57238);
shadow.object.do_notify_tree.call(null,child_57239,ev,notify_fn);


var G__57240 = seq__56703_57235;
var G__57241 = chunk__56704_57236;
var G__57242 = count__56705_57237;
var G__57243 = (i__56706_57238 + (1));
seq__56703_57235 = G__57240;
chunk__56704_57236 = G__57241;
count__56705_57237 = G__57242;
i__56706_57238 = G__57243;
continue;
} else {
var temp__5720__auto___57247 = cljs.core.seq.call(null,seq__56703_57235);
if(temp__5720__auto___57247){
var seq__56703_57248__$1 = temp__5720__auto___57247;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56703_57248__$1)){
var c__6568__auto___57249 = cljs.core.chunk_first.call(null,seq__56703_57248__$1);
var G__57250 = cljs.core.chunk_rest.call(null,seq__56703_57248__$1);
var G__57251 = c__6568__auto___57249;
var G__57252 = cljs.core.count.call(null,c__6568__auto___57249);
var G__57253 = (0);
seq__56703_57235 = G__57250;
chunk__56704_57236 = G__57251;
count__56705_57237 = G__57252;
i__56706_57238 = G__57253;
continue;
} else {
var child_57258 = cljs.core.first.call(null,seq__56703_57248__$1);
shadow.object.do_notify_tree.call(null,child_57258,ev,notify_fn);


var G__57287 = cljs.core.next.call(null,seq__56703_57248__$1);
var G__57288 = null;
var G__57289 = (0);
var G__57290 = (0);
seq__56703_57235 = G__57287;
chunk__56704_57236 = G__57288;
count__56705_57237 = G__57289;
i__56706_57238 = G__57290;
continue;
}
} else {
}
}
break;
}

return notify_fn.call(null,current_obj);
});
shadow.object.notify_tree_BANG_ = (function shadow$object$notify_tree_BANG_(var_args){
var args__6930__auto__ = [];
var len__6920__auto___57291 = arguments.length;
var i__6921__auto___57292 = (0);
while(true){
if((i__6921__auto___57292 < len__6920__auto___57291)){
args__6930__auto__.push((arguments[i__6921__auto___57292]));

var G__57293 = (i__6921__auto___57292 + (1));
i__6921__auto___57292 = G__57293;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((2) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_tree_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6931__auto__);
});

(shadow.object.notify_tree_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var notify_fn = (function (obj){
return cljs.core.apply.call(null,shadow.object.notify_BANG_,obj,ev,args);
});
return shadow.object.do_notify_tree.call(null,oref,ev,notify_fn);
}));

(shadow.object.notify_tree_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.notify_tree_BANG_.cljs$lang$applyTo = (function (seq56728){
var G__56729 = cljs.core.first.call(null,seq56728);
var seq56728__$1 = cljs.core.next.call(null,seq56728);
var G__56730 = cljs.core.first.call(null,seq56728__$1);
var seq56728__$2 = cljs.core.next.call(null,seq56728__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56729,G__56730,seq56728__$2);
}));

shadow.object.notify_down_BANG_ = shadow.object.notify_tree_BANG_;
shadow.object.notify_up_BANG_ = (function shadow$object$notify_up_BANG_(var_args){
var args__6930__auto__ = [];
var len__6920__auto___57295 = arguments.length;
var i__6921__auto___57296 = (0);
while(true){
if((i__6921__auto___57296 < len__6920__auto___57295)){
args__6930__auto__.push((arguments[i__6921__auto___57296]));

var G__57297 = (i__6921__auto___57296 + (1));
i__6921__auto___57296 = G__57297;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((2) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((2)),(0),null)):null);
return shadow.object.notify_up_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6931__auto__);
});

(shadow.object.notify_up_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,ev,args){
var current = shadow.object.get_parent.call(null,oref);
while(true){
if(cljs.core.truth_(current)){
cljs.core.apply.call(null,shadow.object.notify_BANG_,current,ev,args);

var G__57298 = shadow.object.get_parent.call(null,current);
current = G__57298;
continue;
} else {
return null;
}
break;
}
}));

(shadow.object.notify_up_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.notify_up_BANG_.cljs$lang$applyTo = (function (seq56738){
var G__56739 = cljs.core.first.call(null,seq56738);
var seq56738__$1 = cljs.core.next.call(null,seq56738);
var G__56740 = cljs.core.first.call(null,seq56738__$1);
var seq56738__$2 = cljs.core.next.call(null,seq56738__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56739,G__56740,seq56738__$2);
}));

shadow.object.update_BANG_ = (function shadow$object$update_BANG_(var_args){
var args__6930__auto__ = [];
var len__6920__auto___57299 = arguments.length;
var i__6921__auto___57300 = (0);
while(true){
if((i__6921__auto___57300 < len__6920__auto___57299)){
args__6930__auto__.push((arguments[i__6921__auto___57300]));

var G__57301 = (i__6921__auto___57300 + (1));
i__6921__auto___57300 = G__57301;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((2) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((2)),(0),null)):null);
return shadow.object.update_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6931__auto__);
});

(shadow.object.update_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (oref,update_fn,args){
if(cljs.core.fn_QMARK_.call(null,update_fn)){
} else {
throw ["update! expects a fn as second arg, not ",cljs.core.pr_str.call(null,update_fn)].join('');
}

var id = shadow.object._id.call(null,oref);
var data = shadow.object._data.call(null,oref);
var work_fn = (function (data__$1){
return cljs.core.apply.call(null,update_fn,data__$1,args);
});
return shadow.object._update.call(null,oref,work_fn);
}));

(shadow.object.update_BANG_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.update_BANG_.cljs$lang$applyTo = (function (seq56757){
var G__56758 = cljs.core.first.call(null,seq56757);
var seq56757__$1 = cljs.core.next.call(null,seq56757);
var G__56759 = cljs.core.first.call(null,seq56757__$1);
var seq56757__$2 = cljs.core.next.call(null,seq56757__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56758,G__56759,seq56757__$2);
}));

shadow.object.return_value = (function shadow$object$return_value(oref,return_value){
return shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","return-value","shadow.object/return-value",1397593360),return_value);
});
shadow.object.set_parent_BANG_ = (function shadow$object$set_parent_BANG_(child,parent){
var child_id = shadow.object._id.call(null,child);
var parent_id = shadow.object._id.call(null,parent);
cljs.core.swap_BANG_.call(null,shadow.object.instance_parent,cljs.core.assoc,child_id,parent_id);

cljs.core.swap_BANG_.call(null,shadow.object.instance_children,(function (x){
var current = cljs.core.get.call(null,x,parent_id,cljs.core.PersistentHashSet.EMPTY);
return cljs.core.assoc.call(null,x,parent_id,cljs.core.conj.call(null,current,child_id));
}));

return true;
});
shadow.object.dom_destroy = (function shadow$object$dom_destroy(this$,cause){
if(cljs.core._EQ_.call(null,cause,new cljs.core.Keyword(null,"parent","parent",-878878779))){
return shadow.dom.remove.call(null,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
} else {
var temp__5718__auto__ = shadow.object.get_type_attr.call(null,this$,new cljs.core.Keyword("dom","remove","dom/remove",-131527420));
if(cljs.core.truth_(temp__5718__auto__)){
var custom_remove = temp__5718__auto__;
return custom_remove.call(null,this$,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
} else {
return shadow.dom.remove.call(null,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(this$));
}
}
});
shadow.object.destroy_BANG_ = (function shadow$object$destroy_BANG_(var_args){
var G__56787 = arguments.length;
switch (G__56787) {
case 1:
return shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (oref){
return shadow.object.destroy_BANG_.call(null,oref,new cljs.core.Keyword(null,"direct","direct",-1775717856));
}));

(shadow.object.destroy_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (oref,cause){
return shadow.object._destroy_BANG_.call(null,oref,cause);
}));

(shadow.object.destroy_BANG_.cljs$lang$maxFixedArity = 2);

shadow.object.bind_dom_events = (function shadow$object$bind_dom_events(oref,dom,dom_events){
if((cljs.core.rem.call(null,cljs.core.count.call(null,dom_events),(2)) === (0))){
} else {
throw cljs.core.ex_info.call(null,"object defined invalid event",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"object-type","object-type",-1889869015),shadow.object._type.call(null,oref),new cljs.core.Keyword("dom","events","dom/events",1793437527),dom_events], null));
}

var seq__56799 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),dom_events));
var chunk__56800 = null;
var count__56801 = (0);
var i__56802 = (0);
while(true){
if((i__56802 < count__56801)){
var vec__56831 = cljs.core._nth.call(null,chunk__56800,i__56802);
var ev = cljs.core.nth.call(null,vec__56831,(0),null);
var handler = cljs.core.nth.call(null,vec__56831,(1),null);
var ev_def = vec__56831;
if((handler == null)){
throw ["ev with nil handler ",cljs.core.pr_str.call(null,ev)].join('');
} else {
}

var handler_57305__$1 = (((handler instanceof cljs.core.Keyword))?((function (seq__56799,chunk__56800,count__56801,i__56802,vec__56831,ev,handler,ev_def){
return (function (this$,e,el){
return shadow.object.notify_BANG_.call(null,this$,handler,e,el);
});})(seq__56799,chunk__56800,count__56801,i__56802,vec__56831,ev,handler,ev_def))
:handler);
shadow.dom.on.call(null,dom,ev,((function (seq__56799,chunk__56800,count__56801,i__56802,handler_57305__$1,vec__56831,ev,handler,ev_def){
return (function shadow$object$bind_dom_events_$_dom_event_handler(e,el){
if(cljs.core._EQ_.call(null,"A",el.tagName)){
shadow.dom.ev_stop.call(null,e);
} else {
}

return handler_57305__$1.call(null,oref,e,el);
});})(seq__56799,chunk__56800,count__56801,i__56802,handler_57305__$1,vec__56831,ev,handler,ev_def))
);


var G__57307 = seq__56799;
var G__57308 = chunk__56800;
var G__57309 = count__56801;
var G__57310 = (i__56802 + (1));
seq__56799 = G__57307;
chunk__56800 = G__57308;
count__56801 = G__57309;
i__56802 = G__57310;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__56799);
if(temp__5720__auto__){
var seq__56799__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56799__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__56799__$1);
var G__57312 = cljs.core.chunk_rest.call(null,seq__56799__$1);
var G__57313 = c__6568__auto__;
var G__57314 = cljs.core.count.call(null,c__6568__auto__);
var G__57315 = (0);
seq__56799 = G__57312;
chunk__56800 = G__57313;
count__56801 = G__57314;
i__56802 = G__57315;
continue;
} else {
var vec__56838 = cljs.core.first.call(null,seq__56799__$1);
var ev = cljs.core.nth.call(null,vec__56838,(0),null);
var handler = cljs.core.nth.call(null,vec__56838,(1),null);
var ev_def = vec__56838;
if((handler == null)){
throw ["ev with nil handler ",cljs.core.pr_str.call(null,ev)].join('');
} else {
}

var handler_57328__$1 = (((handler instanceof cljs.core.Keyword))?((function (seq__56799,chunk__56800,count__56801,i__56802,vec__56838,ev,handler,ev_def,seq__56799__$1,temp__5720__auto__){
return (function (this$,e,el){
return shadow.object.notify_BANG_.call(null,this$,handler,e,el);
});})(seq__56799,chunk__56800,count__56801,i__56802,vec__56838,ev,handler,ev_def,seq__56799__$1,temp__5720__auto__))
:handler);
shadow.dom.on.call(null,dom,ev,((function (seq__56799,chunk__56800,count__56801,i__56802,handler_57328__$1,vec__56838,ev,handler,ev_def,seq__56799__$1,temp__5720__auto__){
return (function shadow$object$bind_dom_events_$_dom_event_handler(e,el){
if(cljs.core._EQ_.call(null,"A",el.tagName)){
shadow.dom.ev_stop.call(null,e);
} else {
}

return handler_57328__$1.call(null,oref,e,el);
});})(seq__56799,chunk__56800,count__56801,i__56802,handler_57328__$1,vec__56838,ev,handler,ev_def,seq__56799__$1,temp__5720__auto__))
);


var G__57337 = cljs.core.next.call(null,seq__56799__$1);
var G__57338 = null;
var G__57339 = (0);
var G__57340 = (0);
seq__56799 = G__57337;
chunk__56800 = G__57338;
count__56801 = G__57339;
i__56802 = G__57340;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.object.reaction_merge = (function shadow$object$reaction_merge(result,p__56841){
var vec__56842 = p__56841;
var event = cljs.core.nth.call(null,vec__56842,(0),null);
var handler = cljs.core.nth.call(null,vec__56842,(1),null);
if(cljs.core.truth_((function (){var and__5583__auto__ = event;
if(cljs.core.truth_(and__5583__auto__)){
return handler;
} else {
return and__5583__auto__;
}
})())){
} else {
throw cljs.core.ex_info.call(null,"invalid reaction",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"event","event",301435442),event,new cljs.core.Keyword(null,"handler","handler",-195596612),handler], null));
}

var current = cljs.core.get.call(null,result,event,cljs.core.List.EMPTY);
return cljs.core.assoc.call(null,result,event,cljs.core.conj.call(null,current,handler));
});
shadow.object.merge_reactions = (function shadow$object$merge_reactions(result,behavior){
if(cljs.core.sequential_QMARK_.call(null,behavior)){
} else {
throw cljs.core.ex_info.call(null,"behaviors must be vectors",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,behavior))){
} else {
throw cljs.core.ex_info.call(null,"invalid behavior",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));
}

return cljs.core.reduce.call(null,shadow.object.reaction_merge,result,cljs.core.reverse.call(null,cljs.core.partition.call(null,(2),behavior)));
});
shadow.object.merge_behaviors = (function shadow$object$merge_behaviors(result,behavior){
if(cljs.core.sequential_QMARK_.call(null,behavior)){
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,behavior);
} else {
if(cljs.core.map_QMARK_.call(null,behavior)){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,new cljs.core.Keyword(null,"on","on",173873944).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"watch","watch",380988277)], null),(function (watches){
return cljs.core.concat.call(null,watches,new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY));
})),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("dom","events","dom/events",1793437527)], null),(function (default$){
return cljs.core.vec.call(null,cljs.core.concat.call(null,default$,new cljs.core.Keyword("dom","events","dom/events",1793437527).cljs$core$IFn$_invoke$arity$2(behavior,cljs.core.PersistentVector.EMPTY)));
}));
} else {
throw cljs.core.ex_info.call(null,"behavior not understood",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),behavior], null));

}
}
});
shadow.object.define = (function shadow$object$define(var_args){
var args__6930__auto__ = [];
var len__6920__auto___57353 = arguments.length;
var i__6921__auto___57354 = (0);
while(true){
if((i__6921__auto___57354 < len__6920__auto___57353)){
args__6930__auto__.push((arguments[i__6921__auto___57354]));

var G__57355 = (i__6921__auto___57354 + (1));
i__6921__auto___57354 = G__57355;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((1) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((1)),(0),null)):null);
return shadow.object.define.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__6931__auto__);
});

(shadow.object.define.cljs$core$IFn$_invoke$arity$variadic = (function (id,args){
if((id instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.call(null,"object id needs to be a keyword",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,args))){
} else {
throw ["invalid object definition ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," args: ",cljs.core.pr_str.call(null,args)].join('');
}

if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.object_defs),id)){
console.warn(["object already defined ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join(''));
} else {
}

try{var odef = cljs.core.apply.call(null,cljs.core.hash_map,args);
var reactions = shadow.object.merge_reactions.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"on","on",173873944).cljs$core$IFn$_invoke$arity$2(odef,cljs.core.PersistentVector.EMPTY));
var odef__$1 = cljs.core.assoc.call(null,odef,new cljs.core.Keyword("shadow.object","id","shadow.object/id",-647954841),id,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),reactions);
var odef__$2 = cljs.core.reduce.call(null,shadow.object.merge_behaviors,odef__$1,cljs.core.reverse.call(null,new cljs.core.Keyword(null,"behaviors","behaviors",120724909).cljs$core$IFn$_invoke$arity$2(odef__$1,cljs.core.PersistentVector.EMPTY)));
cljs.core.swap_BANG_.call(null,shadow.object.object_defs,cljs.core.assoc,id,odef__$2);

return odef__$2;
}catch (e56868){if((e56868 instanceof Object)){
var e = e56868;
throw cljs.core.ex_info.call(null,"failed to define object",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
} else {
throw e56868;

}
}}));

(shadow.object.define.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.object.define.cljs$lang$applyTo = (function (seq56862){
var G__56863 = cljs.core.first.call(null,seq56862);
var seq56862__$1 = cljs.core.next.call(null,seq56862);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56863,seq56862__$1);
}));

shadow.object.merge_defaults = (function shadow$object$merge_defaults(data,type){
var defaults = cljs.core.get_in.call(null,cljs.core.deref.call(null,shadow.object.object_defs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type,new cljs.core.Keyword(null,"defaults","defaults",976027214)], null));
if((defaults == null)){
return data;
} else {
if(cljs.core.map_QMARK_.call(null,defaults)){
return cljs.core.merge.call(null,defaults,data);
} else {
if(cljs.core.fn_QMARK_.call(null,defaults)){
return cljs.core.merge.call(null,defaults.call(null),data);
} else {
throw cljs.core.ex_info.call(null,"invalid object defaults",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"defaults","defaults",976027214),defaults,new cljs.core.Keyword(null,"type","type",1174270348),type], null));

}
}
}
});
shadow.object.make_dom = (function shadow$object$make_dom(var_args){
var G__56879 = arguments.length;
switch (G__56879) {
case 3:
return shadow.object.make_dom.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.object.make_dom.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.make_dom.cljs$core$IFn$_invoke$arity$3 = (function (oref,dom_key,events_key){
return shadow.object.make_dom.call(null,oref,dom_key,events_key,null);
}));

(shadow.object.make_dom.cljs$core$IFn$_invoke$arity$4 = (function (oref,dom_key,events_key,value){
var dom_fn = (((dom_key instanceof cljs.core.Keyword))?shadow.object.get_type_attr.call(null,oref,dom_key):dom_key);
var events = (((events_key instanceof cljs.core.Keyword))?shadow.object.get_type_attr.call(null,oref,events_key,cljs.core.PersistentVector.EMPTY):events_key);
var dom = shadow.dom.build.call(null,dom_fn.call(null,oref,value));
shadow.object.bind_dom_events.call(null,oref,dom,events);

return dom;
}));

(shadow.object.make_dom.cljs$lang$maxFixedArity = 4);

shadow.object.alive_QMARK_ = (function shadow$object$alive_QMARK_(obj){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.instances),shadow.object._id.call(null,obj));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.object.Watch = (function (key,handler,__meta,__extmap,__hash){
this.key = key;
this.handler = handler;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.object.Watch.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6292__auto__,k__6293__auto__){
var self__ = this;
var this__6292__auto____$1 = this;
return this__6292__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__6293__auto__,null);
}));

(shadow.object.Watch.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6294__auto__,k56884,else__6295__auto__){
var self__ = this;
var this__6294__auto____$1 = this;
var G__56890 = k56884;
var G__56890__$1 = (((G__56890 instanceof cljs.core.Keyword))?G__56890.fqn:null);
switch (G__56890__$1) {
case "key":
return self__.key;

break;
case "handler":
return self__.handler;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k56884,else__6295__auto__);

}
}));

(shadow.object.Watch.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__6311__auto__,f__6312__auto__,init__6313__auto__){
var self__ = this;
var this__6311__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__6314__auto__,p__56893){
var vec__56894 = p__56893;
var k__6315__auto__ = cljs.core.nth.call(null,vec__56894,(0),null);
var v__6316__auto__ = cljs.core.nth.call(null,vec__56894,(1),null);
return f__6312__auto__.call(null,ret__6314__auto__,k__6315__auto__,v__6316__auto__);
}),init__6313__auto__,this__6311__auto____$1);
}));

(shadow.object.Watch.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6306__auto__,writer__6307__auto__,opts__6308__auto__){
var self__ = this;
var this__6306__auto____$1 = this;
var pr_pair__6309__auto__ = (function (keyval__6310__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6307__auto__,cljs.core.pr_writer,""," ","",opts__6308__auto__,keyval__6310__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__6307__auto__,pr_pair__6309__auto__,"#shadow.object.Watch{",", ","}",opts__6308__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key","key",-1516042587),self__.key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler],null))], null),self__.__extmap));
}));

(shadow.object.Watch.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__56883){
var self__ = this;
var G__56883__$1 = this;
return (new cljs.core.RecordIter((0),G__56883__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"handler","handler",-195596612)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.object.Watch.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6290__auto__){
var self__ = this;
var this__6290__auto____$1 = this;
return self__.__meta;
}));

(shadow.object.Watch.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6287__auto__){
var self__ = this;
var this__6287__auto____$1 = this;
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.object.Watch.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6296__auto__){
var self__ = this;
var this__6296__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.object.Watch.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6288__auto__){
var self__ = this;
var this__6288__auto____$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = (function (coll__6289__auto__){
return (-17677043 ^ cljs.core.hash_unordered_coll.call(null,coll__6289__auto__));
}).call(null,this__6288__auto____$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(shadow.object.Watch.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this56885,other56886){
var self__ = this;
var this56885__$1 = this;
return (((!((other56886 == null)))) && ((this56885__$1.constructor === other56886.constructor)) && (cljs.core._EQ_.call(null,this56885__$1.key,other56886.key)) && (cljs.core._EQ_.call(null,this56885__$1.handler,other56886.handler)) && (cljs.core._EQ_.call(null,this56885__$1.__extmap,other56886.__extmap)));
}));

(shadow.object.Watch.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6301__auto__,k__6302__auto__){
var self__ = this;
var this__6301__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),null,new cljs.core.Keyword(null,"handler","handler",-195596612),null], null), null),k__6302__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6301__auto____$1),self__.__meta),k__6302__auto__);
} else {
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6302__auto__)),null));
}
}));

(shadow.object.Watch.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6299__auto__,k__6300__auto__,G__56883){
var self__ = this;
var this__6299__auto____$1 = this;
var pred__56906 = cljs.core.keyword_identical_QMARK_;
var expr__56907 = k__6300__auto__;
if(cljs.core.truth_(pred__56906.call(null,new cljs.core.Keyword(null,"key","key",-1516042587),expr__56907))){
return (new shadow.object.Watch(G__56883,self__.handler,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__56906.call(null,new cljs.core.Keyword(null,"handler","handler",-195596612),expr__56907))){
return (new shadow.object.Watch(self__.key,G__56883,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.object.Watch(self__.key,self__.handler,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6300__auto__,G__56883),null));
}
}
}));

(shadow.object.Watch.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6304__auto__){
var self__ = this;
var this__6304__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"key","key",-1516042587),self__.key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler,null))], null),self__.__extmap));
}));

(shadow.object.Watch.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6291__auto__,G__56883){
var self__ = this;
var this__6291__auto____$1 = this;
return (new shadow.object.Watch(self__.key,self__.handler,G__56883,self__.__extmap,self__.__hash));
}));

(shadow.object.Watch.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6297__auto__,entry__6298__auto__){
var self__ = this;
var this__6297__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6298__auto__)){
return this__6297__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__6298__auto__,(0)),cljs.core._nth.call(null,entry__6298__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6297__auto____$1,entry__6298__auto__);
}
}));

(shadow.object.Watch.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"handler","handler",1444934915,null)], null);
}));

(shadow.object.Watch.cljs$lang$type = true);

(shadow.object.Watch.cljs$lang$ctorPrSeq = (function (this__6337__auto__){
return (new cljs.core.List(null,"shadow.object/Watch",null,(1),null));
}));

(shadow.object.Watch.cljs$lang$ctorPrWriter = (function (this__6337__auto__,writer__6338__auto__){
return cljs.core._write.call(null,writer__6338__auto__,"shadow.object/Watch");
}));

/**
 * Positional factory function for shadow.object/Watch.
 */
shadow.object.__GT_Watch = (function shadow$object$__GT_Watch(key,handler){
return (new shadow.object.Watch(key,handler,null,null,null));
});

/**
 * Factory function for shadow.object/Watch, taking a map of keywords to field values.
 */
shadow.object.map__GT_Watch = (function shadow$object$map__GT_Watch(G__56888){
var extmap__6333__auto__ = (function (){var G__56913 = cljs.core.dissoc.call(null,G__56888,new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"handler","handler",-195596612));
if(cljs.core.record_QMARK_.call(null,G__56888)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__56913);
} else {
return G__56913;
}
})();
return (new shadow.object.Watch(new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(G__56888),new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(G__56888),null,cljs.core.not_empty.call(null,extmap__6333__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IEquiv}
 * @implements {shadow.object.IObject}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {shadow.dom.SVGElement}
 * @implements {cljs.core.ILookup}
*/
shadow.object.ObjectRef = (function (id,type,data,watches,result_chan){
this.id = id;
this.type = type;
this.data = data;
this.watches = watches;
this.result_chan = result_chan;
this.cljs$lang$protocol_mask$partition0$ = 2149613824;
this.cljs$lang$protocol_mask$partition1$ = 2;
});
(shadow.object.ObjectRef.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (this$,handler){
var self__ = this;
var this$__$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.result_chan,handler);
}));

(shadow.object.ObjectRef.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return cljs.core.pr_str.call(null,this$);
}));

(shadow.object.ObjectRef.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),k)){
return shadow.object.get_parent.call(null,this$__$1);
} else {
return cljs.core.get.call(null,self__.data,k);
}
}));

(shadow.object.ObjectRef.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this$,k,d){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),k)){
return shadow.object.get_parent.call(null,this$__$1);
} else {
return cljs.core.get.call(null,self__.data,k,d);
}
}));

(shadow.object.ObjectRef.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var self__ = this;
var this$__$1 = this;
return cljs.core._write.call(null,writer,["#<ObjectRef {:id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),", :type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.type),"}>"].join(''));
}));

(shadow.object.ObjectRef.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(self__.data);
}));

(shadow.object.ObjectRef.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return (((other instanceof shadow.object.ObjectRef)) && (cljs.core._EQ_.call(null,shadow.object._id.call(null,this$__$1),shadow.object._id.call(null,other))));
}));

(shadow.object.ObjectRef.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311).cljs$core$IFn$_invoke$arity$1(self__.data);
}));

(shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
throw (new Error("who be calling?"));
}));

(shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
return (self__.watches = cljs.core.conj.call(null,self__.watches,(new shadow.object.Watch(key,f,null,null,null))));
}));

(shadow.object.ObjectRef.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return (self__.watches = cljs.core.remove.call(null,(function (p1__56915_SHARP_){
return cljs.core._EQ_.call(null,key,new cljs.core.Keyword(null,"key","key",-1516042587).cljs$core$IFn$_invoke$arity$1(p1__56915_SHARP_));
}),self__.watches));
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_id$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.id;
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_type$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.type;
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_data$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.data;
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_update$arity$2 = (function (this$,update_fn){
var self__ = this;
var this$__$1 = this;
var old = self__.data;
var new$ = update_fn.call(null,self__.data);
(self__.data = new$);

var seq__56930 = cljs.core.seq.call(null,self__.watches);
var chunk__56931 = null;
var count__56932 = (0);
var i__56933 = (0);
while(true){
if((i__56933 < count__56932)){
var map__56967 = cljs.core._nth.call(null,chunk__56931,i__56933);
var map__56967__$1 = (((((!((map__56967 == null))))?(((((map__56967.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56967.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56967):map__56967);
var watch = map__56967__$1;
var key = cljs.core.get.call(null,map__56967__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var handler = cljs.core.get.call(null,map__56967__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(shadow.object.alive_QMARK_.call(null,this$__$1)){
handler.call(null,key,this$__$1,old,new$);
} else {
}


var G__57362 = seq__56930;
var G__57363 = chunk__56931;
var G__57364 = count__56932;
var G__57365 = (i__56933 + (1));
seq__56930 = G__57362;
chunk__56931 = G__57363;
count__56932 = G__57364;
i__56933 = G__57365;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq.call(null,seq__56930);
if(temp__5720__auto__){
var seq__56930__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56930__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__56930__$1);
var G__57368 = cljs.core.chunk_rest.call(null,seq__56930__$1);
var G__57369 = c__6568__auto__;
var G__57370 = cljs.core.count.call(null,c__6568__auto__);
var G__57371 = (0);
seq__56930 = G__57368;
chunk__56931 = G__57369;
count__56932 = G__57370;
i__56933 = G__57371;
continue;
} else {
var map__56982 = cljs.core.first.call(null,seq__56930__$1);
var map__56982__$1 = (((((!((map__56982 == null))))?(((((map__56982.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56982.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56982):map__56982);
var watch = map__56982__$1;
var key = cljs.core.get.call(null,map__56982__$1,new cljs.core.Keyword(null,"key","key",-1516042587));
var handler = cljs.core.get.call(null,map__56982__$1,new cljs.core.Keyword(null,"handler","handler",-195596612));
if(shadow.object.alive_QMARK_.call(null,this$__$1)){
handler.call(null,key,this$__$1,old,new$);
} else {
}


var G__57372 = cljs.core.next.call(null,seq__56930__$1);
var G__57373 = null;
var G__57374 = (0);
var G__57375 = (0);
seq__56930 = G__57372;
chunk__56931 = G__57373;
count__56932 = G__57374;
i__56933 = G__57375;
continue;
}
} else {
return null;
}
}
break;
}
}));

(shadow.object.ObjectRef.prototype.shadow$object$IObject$_destroy_BANG_$arity$2 = (function (this$,cause){
var self__ = this;
var this$__$1 = this;
var parent_id = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.instance_parent),self__.id);
var seq__57006_57376 = cljs.core.seq.call(null,shadow.object.get_children.call(null,this$__$1));
var chunk__57007_57377 = null;
var count__57008_57378 = (0);
var i__57009_57379 = (0);
while(true){
if((i__57009_57379 < count__57008_57378)){
var child_57380 = cljs.core._nth.call(null,chunk__57007_57377,i__57009_57379);
shadow.object._destroy_BANG_.call(null,child_57380,new cljs.core.Keyword(null,"parent","parent",-878878779));


var G__57381 = seq__57006_57376;
var G__57382 = chunk__57007_57377;
var G__57383 = count__57008_57378;
var G__57384 = (i__57009_57379 + (1));
seq__57006_57376 = G__57381;
chunk__57007_57377 = G__57382;
count__57008_57378 = G__57383;
i__57009_57379 = G__57384;
continue;
} else {
var temp__5720__auto___57389 = cljs.core.seq.call(null,seq__57006_57376);
if(temp__5720__auto___57389){
var seq__57006_57390__$1 = temp__5720__auto___57389;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57006_57390__$1)){
var c__6568__auto___57391 = cljs.core.chunk_first.call(null,seq__57006_57390__$1);
var G__57392 = cljs.core.chunk_rest.call(null,seq__57006_57390__$1);
var G__57393 = c__6568__auto___57391;
var G__57394 = cljs.core.count.call(null,c__6568__auto___57391);
var G__57395 = (0);
seq__57006_57376 = G__57392;
chunk__57007_57377 = G__57393;
count__57008_57378 = G__57394;
i__57009_57379 = G__57395;
continue;
} else {
var child_57396 = cljs.core.first.call(null,seq__57006_57390__$1);
shadow.object._destroy_BANG_.call(null,child_57396,new cljs.core.Keyword(null,"parent","parent",-878878779));


var G__57398 = cljs.core.next.call(null,seq__57006_57390__$1);
var G__57399 = null;
var G__57400 = (0);
var G__57401 = (0);
seq__57006_57376 = G__57398;
chunk__57007_57377 = G__57399;
count__57008_57378 = G__57400;
i__57009_57379 = G__57401;
continue;
}
} else {
}
}
break;
}

shadow.object.notify_BANG_.call(null,this$__$1,new cljs.core.Keyword(null,"destroy","destroy",-843660405),cause);

shadow.object.dom_destroy.call(null,this$__$1,cause);

var return_value_57402 = new cljs.core.Keyword("shadow.object","return-value","shadow.object/return-value",1397593360).cljs$core$IFn$_invoke$arity$1(this$__$1);
if((return_value_57402 == null)){
} else {
cljs.core.async.put_BANG_.call(null,self__.result_chan,return_value_57402);
}

cljs.core.async.close_BANG_.call(null,self__.result_chan);

cljs.core.swap_BANG_.call(null,shadow.object.instances,cljs.core.dissoc,self__.id);

cljs.core.swap_BANG_.call(null,shadow.object.instance_parent,cljs.core.dissoc,self__.id);

if(cljs.core.truth_(parent_id)){
return cljs.core.swap_BANG_.call(null,shadow.object.instance_children,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [parent_id], null),cljs.core.disj,self__.id);
} else {
return null;
}
}));

(shadow.object.ObjectRef.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.data;
}));

(shadow.object.ObjectRef.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"type","type",-1480165421,null),cljs.core.with_meta(new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"watches","watches",1367433992,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"result-chan","result-chan",3070926,null)], null);
}));

(shadow.object.ObjectRef.cljs$lang$type = true);

(shadow.object.ObjectRef.cljs$lang$ctorStr = "shadow.object/ObjectRef");

(shadow.object.ObjectRef.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"shadow.object/ObjectRef");
}));

/**
 * Positional factory function for shadow.object/ObjectRef.
 */
shadow.object.__GT_ObjectRef = (function shadow$object$__GT_ObjectRef(id,type,data,watches,result_chan){
return (new shadow.object.ObjectRef(id,type,data,watches,result_chan));
});

shadow.object.add_reaction_BANG_ = (function shadow$object$add_reaction_BANG_(var_args){
var G__57078 = arguments.length;
switch (G__57078) {
case 3:
return shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (oref,ev,handler_fn){
return shadow.object.add_reaction_BANG_.call(null,oref,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev,handler_fn], null));
}));

(shadow.object.add_reaction_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (oref,list){
return shadow.object.update_BANG_.call(null,oref,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633)], null),shadow.object.merge_reactions,list);
}));

(shadow.object.add_reaction_BANG_.cljs$lang$maxFixedArity = 3);

shadow.object.bind_change = (function shadow$object$bind_change(var_args){
var G__57086 = arguments.length;
switch (G__57086) {
case 3:
return shadow.object.bind_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.object.bind_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.bind_change.cljs$core$IFn$_invoke$arity$3 = (function (oref,attr,callback){
return shadow.object.bind_change.call(null,oref,attr,callback,cljs.core.gensym.call(null,"bind-change"));
}));

(shadow.object.bind_change.cljs$core$IFn$_invoke$arity$4 = (function (oref,attr,callback,watch_key){
if((((!((oref == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === oref.shadow$object$IObject$))))?true:(((!oref.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,oref):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.object.IObject,oref))){
} else {
throw cljs.core.ex_info.call(null,"binding currently only supports shadow objects, other atoms might leak, may add later",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref,new cljs.core.Keyword(null,"attr","attr",-604132353),attr], null));
}

var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
return cljs.core.add_watch.call(null,oref,watch_key,(function shadow$object$bind_change_watch(_,___$1,old,new$){
var ov = cljs.core.get_in.call(null,old,attr__$1);
var nv = cljs.core.get_in.call(null,new$,attr__$1);
if(cljs.core._EQ_.call(null,ov,nv)){
return null;
} else {
return callback.call(null,ov,nv);
}
}));
}));

(shadow.object.bind_change.cljs$lang$maxFixedArity = 4);

shadow.object.dom_enter = (function shadow$object$dom_enter(parent,child){
shadow.dom.append.call(null,parent,child);

if(cljs.core.truth_(shadow.dom.contains_QMARK_.call(null,parent))){
return shadow.object.notify_tree_BANG_.call(null,child,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
} else {
return null;
}
});
shadow.object.create = (function shadow$object$create(var_args){
var args__6930__auto__ = [];
var len__6920__auto___57410 = arguments.length;
var i__6921__auto___57411 = (0);
while(true){
if((i__6921__auto___57411 < len__6920__auto___57410)){
args__6930__auto__.push((arguments[i__6921__auto___57411]));

var G__57412 = (i__6921__auto___57411 + (1));
i__6921__auto___57411 = G__57412;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((2) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((2)),(0),null)):null);
return shadow.object.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__6931__auto__);
});

(shadow.object.create.cljs$core$IFn$_invoke$arity$variadic = (function (type,args,node_children){
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,shadow.object.object_defs),type)){
} else {
throw cljs.core.ex_info.call(null,["cannot create unknown child type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

if(cljs.core.map_QMARK_.call(null,args)){
} else {
throw cljs.core.ex_info.call(null,"so/create second arg must be a map",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"args","args",1315556576),args], null));
}

var oid = shadow.object.next_id.call(null);
var parent = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(args);
var result_chan = cljs.core.async.chan.call(null,(1));
var odef = cljs.core.get.call(null,cljs.core.deref.call(null,shadow.object.object_defs),type);
var obj = cljs.core.dissoc.call(null,shadow.object.merge_defaults.call(null,cljs.core.assoc.call(null,args,new cljs.core.Keyword("shadow.object","object-id","shadow.object/object-id",-685993804),oid,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),cljs.core.get.call(null,odef,new cljs.core.Keyword("shadow.object","reactions","shadow.object/reactions",1966199633),cljs.core.PersistentArrayMap.EMPTY)),type),new cljs.core.Keyword(null,"parent","parent",-878878779),new cljs.core.Keyword(null,"dom","dom",-1236537922));
var oref = (new shadow.object.ObjectRef(oid,type,obj,cljs.core.PersistentVector.EMPTY,result_chan));
cljs.core.swap_BANG_.call(null,shadow.object.instances,cljs.core.assoc,oid,oref);

if(cljs.core.truth_(parent)){
shadow.object.set_parent_BANG_.call(null,oref,parent);
} else {
}

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword(null,"init","init",-1875481434));

var dom_events_57413 = new cljs.core.Keyword("dom","events","dom/events",1793437527).cljs$core$IFn$_invoke$arity$2(odef,cljs.core.PersistentVector.EMPTY);
var temp__5718__auto___57414 = new cljs.core.Keyword(null,"dom","dom",-1236537922).cljs$core$IFn$_invoke$arity$1(args);
if(cljs.core.truth_(temp__5718__auto___57414)){
var dom_57415 = temp__5718__auto___57414;
shadow.dom.set_data.call(null,dom_57415,new cljs.core.Keyword(null,"oid","oid",-768692334),oid);

shadow.object.bind_dom_events.call(null,oref,dom_57415,dom_events_57413);

shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311),dom_57415);

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword("dom","init","dom/init",-1875647652),dom_57415);
} else {
var temp__5720__auto___57416 = new cljs.core.Keyword(null,"dom","dom",-1236537922).cljs$core$IFn$_invoke$arity$1(odef);
if(cljs.core.truth_(temp__5720__auto___57416)){
var dom_fn_57417 = temp__5720__auto___57416;
var dom_57418 = shadow.dom.build.call(null,dom_fn_57417.call(null,oref,node_children));
shadow.dom.set_data.call(null,dom_57418,new cljs.core.Keyword(null,"oid","oid",-768692334),oid);

shadow.object.update_BANG_.call(null,oref,cljs.core.assoc,new cljs.core.Keyword("shadow.object","dom","shadow.object/dom",-1238263311),dom_57418);

shadow.object.bind_dom_events.call(null,oref,dom_57418,dom_events_57413);

shadow.object.notify_BANG_.call(null,oref,new cljs.core.Keyword("dom","init","dom/init",-1875647652),dom_57418);
} else {
}
}

var temp__5720__auto___57419 = new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$1(odef);
if(cljs.core.truth_(temp__5720__auto___57419)){
var watches_57420 = temp__5720__auto___57419;
var seq__57102_57424 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),watches_57420));
var chunk__57103_57425 = null;
var count__57104_57426 = (0);
var i__57105_57427 = (0);
while(true){
if((i__57105_57427 < count__57104_57426)){
var vec__57112_57428 = cljs.core._nth.call(null,chunk__57103_57425,i__57105_57427);
var attr_57429 = cljs.core.nth.call(null,vec__57112_57428,(0),null);
var handler_57430 = cljs.core.nth.call(null,vec__57112_57428,(1),null);
shadow.object.bind_change.call(null,oref,attr_57429,((function (seq__57102_57424,chunk__57103_57425,count__57104_57426,i__57105_57427,vec__57112_57428,attr_57429,handler_57430,watches_57420,temp__5720__auto___57419,oid,parent,result_chan,odef,obj,oref){
return (function (old,new$){
return handler_57430.call(null,oref,old,new$);
});})(seq__57102_57424,chunk__57103_57425,count__57104_57426,i__57105_57427,vec__57112_57428,attr_57429,handler_57430,watches_57420,temp__5720__auto___57419,oid,parent,result_chan,odef,obj,oref))
);


var G__57431 = seq__57102_57424;
var G__57432 = chunk__57103_57425;
var G__57433 = count__57104_57426;
var G__57434 = (i__57105_57427 + (1));
seq__57102_57424 = G__57431;
chunk__57103_57425 = G__57432;
count__57104_57426 = G__57433;
i__57105_57427 = G__57434;
continue;
} else {
var temp__5720__auto___57435__$1 = cljs.core.seq.call(null,seq__57102_57424);
if(temp__5720__auto___57435__$1){
var seq__57102_57436__$1 = temp__5720__auto___57435__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57102_57436__$1)){
var c__6568__auto___57437 = cljs.core.chunk_first.call(null,seq__57102_57436__$1);
var G__57438 = cljs.core.chunk_rest.call(null,seq__57102_57436__$1);
var G__57439 = c__6568__auto___57437;
var G__57440 = cljs.core.count.call(null,c__6568__auto___57437);
var G__57441 = (0);
seq__57102_57424 = G__57438;
chunk__57103_57425 = G__57439;
count__57104_57426 = G__57440;
i__57105_57427 = G__57441;
continue;
} else {
var vec__57115_57442 = cljs.core.first.call(null,seq__57102_57436__$1);
var attr_57443 = cljs.core.nth.call(null,vec__57115_57442,(0),null);
var handler_57444 = cljs.core.nth.call(null,vec__57115_57442,(1),null);
shadow.object.bind_change.call(null,oref,attr_57443,((function (seq__57102_57424,chunk__57103_57425,count__57104_57426,i__57105_57427,vec__57115_57442,attr_57443,handler_57444,seq__57102_57436__$1,temp__5720__auto___57435__$1,watches_57420,temp__5720__auto___57419,oid,parent,result_chan,odef,obj,oref){
return (function (old,new$){
return handler_57444.call(null,oref,old,new$);
});})(seq__57102_57424,chunk__57103_57425,count__57104_57426,i__57105_57427,vec__57115_57442,attr_57443,handler_57444,seq__57102_57436__$1,temp__5720__auto___57435__$1,watches_57420,temp__5720__auto___57419,oid,parent,result_chan,odef,obj,oref))
);


var G__57445 = cljs.core.next.call(null,seq__57102_57436__$1);
var G__57446 = null;
var G__57447 = (0);
var G__57448 = (0);
seq__57102_57424 = G__57445;
chunk__57103_57425 = G__57446;
count__57104_57426 = G__57447;
i__57105_57427 = G__57448;
continue;
}
} else {
}
}
break;
}
} else {
}

return oref;
}));

(shadow.object.create.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(shadow.object.create.cljs$lang$applyTo = (function (seq57094){
var G__57095 = cljs.core.first.call(null,seq57094);
var seq57094__$1 = cljs.core.next.call(null,seq57094);
var G__57096 = cljs.core.first.call(null,seq57094__$1);
var seq57094__$2 = cljs.core.next.call(null,seq57094__$1);
var self__6905__auto__ = this;
return self__6905__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57095,G__57096,seq57094__$2);
}));

/**
 * [oref attr node-gen] produces a node via (node-gen new-value)
 * watches obj for changes and replaces the generated node on change (node-gen defaults to str)
 * 
 *   only use if the node has no attached behavior like clicks, use bind with an extra object for those
 */
shadow.object.bind_simple = (function shadow$object$bind_simple(var_args){
var G__57120 = arguments.length;
switch (G__57120) {
case 2:
return shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$2 = (function (oref,attr){
return shadow.object.bind_simple.call(null,oref,attr,cljs.core.str);
}));

(shadow.object.bind_simple.cljs$core$IFn$_invoke$arity$3 = (function (oref,attr,node_gen){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var node_get = (function (p1__57118_SHARP_){
return shadow.dom.build.call(null,node_gen.call(null,p1__57118_SHARP_));
});
var node = cljs.core.atom.call(null,node_get.call(null,cljs.core.get_in.call(null,oref,attr__$1)));
var bind_key = cljs.core.gensym.call(null,"bind");
shadow.object.bind_change.call(null,oref,attr__$1,(function (old,new$){
var new_node = node_get.call(null,new$);
var current_node = cljs.core.deref.call(null,node);
shadow.dom.replace_node.call(null,current_node,new_node);

return cljs.core.reset_BANG_.call(null,node,new_node);
}));

return cljs.core.deref.call(null,node);
}));

(shadow.object.bind_simple.cljs$lang$maxFixedArity = 3);

/**
 * bind the given attribute a child item
 *   the item will be recreated whenever the value changes (old one will be destroyed)
 */
shadow.object.bind = (function shadow$object$bind(oref,attr,item_type,item_key,item_attrs){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var curval = cljs.core.get_in.call(null,oref,attr__$1);
var make_child_fn = (function (value){
return shadow.object.create.call(null,item_type,cljs.core.merge.call(null,item_attrs,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"parent","parent",-878878779),oref,item_key,value])));
});
var child = cljs.core.atom.call(null,make_child_fn.call(null,curval));
shadow.object.bind_change.call(null,oref,attr__$1,(function (old,new$){
var new_child = make_child_fn.call(null,new$);
var current_node = cljs.core.deref.call(null,child);
shadow.dom.replace_node.call(null,current_node,new_child);

shadow.object.destroy_BANG_.call(null,cljs.core.deref.call(null,child));

cljs.core.reset_BANG_.call(null,child,new_child);

return shadow.object.notify_down_BANG_.call(null,new_child,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
}));

return cljs.core.deref.call(null,child);
});
shadow.object.coll_destroy_children = (function shadow$object$coll_destroy_children(children,c,diff){
var seq__57121_57463 = cljs.core.seq.call(null,cljs.core.subvec.call(null,children,(c + diff),c));
var chunk__57122_57464 = null;
var count__57123_57465 = (0);
var i__57124_57466 = (0);
while(true){
if((i__57124_57466 < count__57123_57465)){
var obj_57467 = cljs.core._nth.call(null,chunk__57122_57464,i__57124_57466);
var obj_57468__$1 = shadow.object.get_from_dom.call(null,obj_57467);
shadow.object.destroy_BANG_.call(null,obj_57468__$1);


var G__57469 = seq__57121_57463;
var G__57470 = chunk__57122_57464;
var G__57471 = count__57123_57465;
var G__57472 = (i__57124_57466 + (1));
seq__57121_57463 = G__57469;
chunk__57122_57464 = G__57470;
count__57123_57465 = G__57471;
i__57124_57466 = G__57472;
continue;
} else {
var temp__5720__auto___57473 = cljs.core.seq.call(null,seq__57121_57463);
if(temp__5720__auto___57473){
var seq__57121_57474__$1 = temp__5720__auto___57473;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57121_57474__$1)){
var c__6568__auto___57475 = cljs.core.chunk_first.call(null,seq__57121_57474__$1);
var G__57476 = cljs.core.chunk_rest.call(null,seq__57121_57474__$1);
var G__57477 = c__6568__auto___57475;
var G__57478 = cljs.core.count.call(null,c__6568__auto___57475);
var G__57479 = (0);
seq__57121_57463 = G__57476;
chunk__57122_57464 = G__57477;
count__57123_57465 = G__57478;
i__57124_57466 = G__57479;
continue;
} else {
var obj_57480 = cljs.core.first.call(null,seq__57121_57474__$1);
var obj_57481__$1 = shadow.object.get_from_dom.call(null,obj_57480);
shadow.object.destroy_BANG_.call(null,obj_57481__$1);


var G__57482 = cljs.core.next.call(null,seq__57121_57474__$1);
var G__57483 = null;
var G__57484 = (0);
var G__57485 = (0);
seq__57121_57463 = G__57482;
chunk__57122_57464 = G__57483;
count__57123_57465 = G__57484;
i__57124_57466 = G__57485;
continue;
}
} else {
}
}
break;
}

return cljs.core.subvec.call(null,children,(0),(c + diff));
});
shadow.object.bind_children = (function shadow$object$bind_children(var_args){
var G__57127 = arguments.length;
switch (G__57127) {
case 5:
return shadow.object.bind_children.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return shadow.object.bind_children.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.object.bind_children.cljs$core$IFn$_invoke$arity$5 = (function (node,parent,attr,item_type,item_key){
return shadow.object.bind_children.call(null,node,parent,attr,item_type,item_key,(function (p1__57125_SHARP_){
return cljs.core.map_indexed.call(null,cljs.core.vector,p1__57125_SHARP_);
}));
}));

(shadow.object.bind_children.cljs$core$IFn$_invoke$arity$6 = (function (node,parent,attr,item_type,item_key,coll_transform){
var attr__$1 = ((cljs.core.sequential_QMARK_.call(null,attr))?attr:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attr], null));
var update_children = cljs.core.atom.call(null,true);
var coll_dom = shadow.dom.build.call(null,node);
var make_item_fn = (function (p__57128){
var vec__57129 = p__57128;
var key = cljs.core.nth.call(null,vec__57129,(0),null);
var val = cljs.core.nth.call(null,vec__57129,(1),null);
var obj = shadow.object.create.call(null,item_type,cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"parent","parent",-878878779),parent,new cljs.core.Keyword("shadow.object","coll-path","shadow.object/coll-path",1583850048),attr__$1,new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616),key,new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366),item_key,item_key,val]));
shadow.object.bind_change.call(null,obj,item_key,(function (old,new$){
var parent_key = cljs.core.conj.call(null,attr__$1,new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(obj));
shadow.object.log.call(null,"direct child update",parent,obj,key,parent_key,new$);

cljs.core.reset_BANG_.call(null,update_children,false);

shadow.object.update_BANG_.call(null,parent,cljs.core.assoc_in,parent_key,new$);

return cljs.core.reset_BANG_.call(null,update_children,true);
}));

return obj;
});
var seq__57132_57496 = cljs.core.seq.call(null,coll_transform.call(null,cljs.core.get_in.call(null,parent,attr__$1)));
var chunk__57133_57497 = null;
var count__57134_57498 = (0);
var i__57135_57499 = (0);
while(true){
if((i__57135_57499 < count__57134_57498)){
var item_57501 = cljs.core._nth.call(null,chunk__57133_57497,i__57135_57499);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_57501));


var G__57503 = seq__57132_57496;
var G__57504 = chunk__57133_57497;
var G__57505 = count__57134_57498;
var G__57506 = (i__57135_57499 + (1));
seq__57132_57496 = G__57503;
chunk__57133_57497 = G__57504;
count__57134_57498 = G__57505;
i__57135_57499 = G__57506;
continue;
} else {
var temp__5720__auto___57508 = cljs.core.seq.call(null,seq__57132_57496);
if(temp__5720__auto___57508){
var seq__57132_57509__$1 = temp__5720__auto___57508;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57132_57509__$1)){
var c__6568__auto___57511 = cljs.core.chunk_first.call(null,seq__57132_57509__$1);
var G__57512 = cljs.core.chunk_rest.call(null,seq__57132_57509__$1);
var G__57513 = c__6568__auto___57511;
var G__57514 = cljs.core.count.call(null,c__6568__auto___57511);
var G__57515 = (0);
seq__57132_57496 = G__57512;
chunk__57133_57497 = G__57513;
count__57134_57498 = G__57514;
i__57135_57499 = G__57515;
continue;
} else {
var item_57516 = cljs.core.first.call(null,seq__57132_57509__$1);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_57516));


var G__57517 = cljs.core.next.call(null,seq__57132_57509__$1);
var G__57518 = null;
var G__57519 = (0);
var G__57520 = (0);
seq__57132_57496 = G__57517;
chunk__57133_57497 = G__57518;
count__57134_57498 = G__57519;
i__57135_57499 = G__57520;
continue;
}
} else {
}
}
break;
}

shadow.object.bind_change.call(null,parent,attr__$1,(function shadow$object$bind_children_watch(old,new$){
if(cljs.core.truth_(cljs.core.deref.call(null,update_children))){
var children = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,shadow.dom.children.call(null,coll_dom));
var new_coll = cljs.core.vec.call(null,coll_transform.call(null,new$));
var count_children = cljs.core.count.call(null,children);
var count_new = cljs.core.count.call(null,new$);
var diff = (count_new - count_children);
var children__$1 = (((diff < (0)))?shadow.object.coll_destroy_children.call(null,children,count_children,diff):children);
var count_children__$1 = (function (){var x__5963__auto__ = count_new;
var y__5964__auto__ = count_children;
return ((x__5963__auto__ < y__5964__auto__) ? x__5963__auto__ : y__5964__auto__);
})();
var n__6679__auto___57522 = count_children__$1;
var idx_57523 = (0);
while(true){
if((idx_57523 < n__6679__auto___57522)){
var cn_57524 = cljs.core.nth.call(null,children__$1,idx_57523);
var cc_57525 = shadow.object.get_from_dom.call(null,cn_57524);
var ckey_57526 = new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(cc_57525);
var cval_57527 = cljs.core.get.call(null,cc_57525,item_key);
var vec__57136_57528 = cljs.core.nth.call(null,new_coll,idx_57523);
var nkey_57529 = cljs.core.nth.call(null,vec__57136_57528,(0),null);
var nval_57530 = cljs.core.nth.call(null,vec__57136_57528,(1),null);
if(((cljs.core._EQ_.call(null,ckey_57526,nkey_57529)) && (cljs.core._EQ_.call(null,cval_57527,nval_57530)))){
} else {
var new_obj_57532 = make_item_fn.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nkey_57529,nval_57530], null));
shadow.dom.replace_node.call(null,cn_57524,new_obj_57532);

shadow.object.destroy_BANG_.call(null,cc_57525);

shadow.object.notify_tree_BANG_.call(null,new_obj_57532,new cljs.core.Keyword("dom","entered","dom/entered",506699596));
}

var G__57533 = (idx_57523 + (1));
idx_57523 = G__57533;
continue;
} else {
}
break;
}

if((diff > (0))){
var seq__57139_57534 = cljs.core.seq.call(null,cljs.core.subvec.call(null,new_coll,count_children__$1,count_new));
var chunk__57140_57535 = null;
var count__57141_57536 = (0);
var i__57142_57537 = (0);
while(true){
if((i__57142_57537 < count__57141_57536)){
var item_57538 = cljs.core._nth.call(null,chunk__57140_57535,i__57142_57537);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_57538));


var G__57539 = seq__57139_57534;
var G__57540 = chunk__57140_57535;
var G__57541 = count__57141_57536;
var G__57542 = (i__57142_57537 + (1));
seq__57139_57534 = G__57539;
chunk__57140_57535 = G__57540;
count__57141_57536 = G__57541;
i__57142_57537 = G__57542;
continue;
} else {
var temp__5720__auto___57543 = cljs.core.seq.call(null,seq__57139_57534);
if(temp__5720__auto___57543){
var seq__57139_57544__$1 = temp__5720__auto___57543;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57139_57544__$1)){
var c__6568__auto___57545 = cljs.core.chunk_first.call(null,seq__57139_57544__$1);
var G__57549 = cljs.core.chunk_rest.call(null,seq__57139_57544__$1);
var G__57550 = c__6568__auto___57545;
var G__57551 = cljs.core.count.call(null,c__6568__auto___57545);
var G__57552 = (0);
seq__57139_57534 = G__57549;
chunk__57140_57535 = G__57550;
count__57141_57536 = G__57551;
i__57142_57537 = G__57552;
continue;
} else {
var item_57553 = cljs.core.first.call(null,seq__57139_57544__$1);
shadow.object.dom_enter.call(null,coll_dom,make_item_fn.call(null,item_57553));


var G__57554 = cljs.core.next.call(null,seq__57139_57544__$1);
var G__57555 = null;
var G__57556 = (0);
var G__57557 = (0);
seq__57139_57534 = G__57554;
chunk__57140_57535 = G__57555;
count__57141_57536 = G__57556;
i__57142_57537 = G__57557;
continue;
}
} else {
}
}
break;
}
} else {
}

return shadow.object.notify_BANG_.call(null,parent,new cljs.core.Keyword(null,"bind-children-update","bind-children-update",-1610690160));
} else {
return null;
}
}));

return coll_dom;
}));

(shadow.object.bind_children.cljs$lang$maxFixedArity = 6);

shadow.object.remove_in_parent_BANG_ = (function shadow$object$remove_in_parent_BANG_(oref){
var parent = shadow.object.get_parent.call(null,oref);
var key = new cljs.core.Keyword("shadow.object","coll-key","shadow.object/coll-key",827543616).cljs$core$IFn$_invoke$arity$1(oref);
var value = cljs.core.get.call(null,oref,new cljs.core.Keyword("shadow.object","coll-item-key","shadow.object/coll-item-key",1888444366).cljs$core$IFn$_invoke$arity$1(oref));
var path = new cljs.core.Keyword("shadow.object","coll-path","shadow.object/coll-path",1583850048).cljs$core$IFn$_invoke$arity$1(oref);
if(cljs.core.truth_((function (){var and__5583__auto__ = key;
if(cljs.core.truth_(and__5583__auto__)){
return path;
} else {
return and__5583__auto__;
}
})())){
} else {
throw cljs.core.ex_info.call(null,"remove-in-parent! should only be called from items created via so/bind-children",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"oref","oref",-1547494840),oref], null));
}

var coll = cljs.core.get_in.call(null,parent,path);
var new_coll = shadow.util.remove_item_from_coll.call(null,coll,key,value);
return shadow.object.notify_BANG_.call(null,parent,new cljs.core.Keyword("bind","update","bind/update",1048601733),path,new_coll);
});
shadow.object.inspect_BANG_ = (function shadow$object$inspect_BANG_(oref){
return shadow.object.info.call(null,"inspect!",shadow.object._id.call(null,oref),cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.object._type.call(null,oref)),cljs.core.clj__GT_js.call(null,cljs.core.deref.call(null,shadow.object._data.call(null,oref))));
});
shadow.object.dump_BANG_ = (function shadow$object$dump_BANG_(){
shadow.object.info.call(null,"--------------- LIVE OBJECTS ------------");

var seq__57143_57558 = cljs.core.seq.call(null,cljs.core.seq.call(null,cljs.core.deref.call(null,shadow.object.instances)));
var chunk__57144_57559 = null;
var count__57145_57560 = (0);
var i__57146_57561 = (0);
while(true){
if((i__57146_57561 < count__57145_57560)){
var vec__57153_57562 = cljs.core._nth.call(null,chunk__57144_57559,i__57146_57561);
var id_57563 = cljs.core.nth.call(null,vec__57153_57562,(0),null);
var oref_57564 = cljs.core.nth.call(null,vec__57153_57562,(1),null);
shadow.object.info.call(null,"dump",id_57563,cljs.core.pr_str.call(null,shadow.object._type.call(null,oref_57564)),cljs.core.deref.call(null,shadow.object._data.call(null,oref_57564)));


var G__57565 = seq__57143_57558;
var G__57566 = chunk__57144_57559;
var G__57567 = count__57145_57560;
var G__57568 = (i__57146_57561 + (1));
seq__57143_57558 = G__57565;
chunk__57144_57559 = G__57566;
count__57145_57560 = G__57567;
i__57146_57561 = G__57568;
continue;
} else {
var temp__5720__auto___57569 = cljs.core.seq.call(null,seq__57143_57558);
if(temp__5720__auto___57569){
var seq__57143_57570__$1 = temp__5720__auto___57569;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__57143_57570__$1)){
var c__6568__auto___57571 = cljs.core.chunk_first.call(null,seq__57143_57570__$1);
var G__57572 = cljs.core.chunk_rest.call(null,seq__57143_57570__$1);
var G__57573 = c__6568__auto___57571;
var G__57574 = cljs.core.count.call(null,c__6568__auto___57571);
var G__57575 = (0);
seq__57143_57558 = G__57572;
chunk__57144_57559 = G__57573;
count__57145_57560 = G__57574;
i__57146_57561 = G__57575;
continue;
} else {
var vec__57156_57576 = cljs.core.first.call(null,seq__57143_57570__$1);
var id_57577 = cljs.core.nth.call(null,vec__57156_57576,(0),null);
var oref_57578 = cljs.core.nth.call(null,vec__57156_57576,(1),null);
shadow.object.info.call(null,"dump",id_57577,cljs.core.pr_str.call(null,shadow.object._type.call(null,oref_57578)),cljs.core.deref.call(null,shadow.object._data.call(null,oref_57578)));


var G__57579 = cljs.core.next.call(null,seq__57143_57570__$1);
var G__57580 = null;
var G__57581 = (0);
var G__57582 = (0);
seq__57143_57558 = G__57579;
chunk__57144_57559 = G__57580;
count__57145_57560 = G__57581;
i__57146_57561 = G__57582;
continue;
}
} else {
}
}
break;
}

return shadow.object.info.call(null,"--------------- //LIVE OBJECTS ------------");
});
goog.exportSymbol('shadow.object.dump_BANG_', shadow.object.dump_BANG_);

//# sourceMappingURL=shadow.object.js.map
