goog.provide('shadow.animate');
goog.require('cljs.core');
goog.require('shadow.dom');
goog.require('shadow.object');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('goog.dom.vendor');
goog.require('goog.style');
goog.require('shadow.util');

/**
 * @interface
 */
shadow.animate.Animation = function(){};

var shadow$animate$Animation$_animate_from$dyn_57615 = (function (this$){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (shadow.animate._animate_from[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$);
} else {
var m__6344__auto__ = (shadow.animate._animate_from["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Animation.-animate-from",this$);
}
}
});
/**
 * return a map of {attr initial-value}
 */
shadow.animate._animate_from = (function shadow$animate$_animate_from(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$animate$Animation$_animate_from$arity$1 == null)))))){
return this$.shadow$animate$Animation$_animate_from$arity$1(this$);
} else {
return shadow$animate$Animation$_animate_from$dyn_57615.call(null,this$);
}
});

var shadow$animate$Animation$_animate_to$dyn_57618 = (function (this$){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (shadow.animate._animate_to[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$);
} else {
var m__6344__auto__ = (shadow.animate._animate_to["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Animation.-animate-to",this$);
}
}
});
/**
 * return a map of {attr target-value}
 */
shadow.animate._animate_to = (function shadow$animate$_animate_to(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$animate$Animation$_animate_to$arity$1 == null)))))){
return this$.shadow$animate$Animation$_animate_to$arity$1(this$);
} else {
return shadow$animate$Animation$_animate_to$dyn_57618.call(null,this$);
}
});

var shadow$animate$Animation$_animate_toggles$dyn_57623 = (function (this$){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (shadow.animate._animate_toggles[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$);
} else {
var m__6344__auto__ = (shadow.animate._animate_toggles["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Animation.-animate-toggles",this$);
}
}
});
/**
 * return a map of {attr target-value}
 */
shadow.animate._animate_toggles = (function shadow$animate$_animate_toggles(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$animate$Animation$_animate_toggles$arity$1 == null)))))){
return this$.shadow$animate$Animation$_animate_toggles$arity$1(this$);
} else {
return shadow$animate$Animation$_animate_toggles$dyn_57623.call(null,this$);
}
});

var shadow$animate$Animation$_animate_timings$dyn_57625 = (function (this$){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (shadow.animate._animate_timings[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$);
} else {
var m__6344__auto__ = (shadow.animate._animate_timings["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Animation.-animate-timings",this$);
}
}
});
/**
 * return a map of {attr timing-function}
 */
shadow.animate._animate_timings = (function shadow$animate$_animate_timings(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$animate$Animation$_animate_timings$arity$1 == null)))))){
return this$.shadow$animate$Animation$_animate_timings$arity$1(this$);
} else {
return shadow$animate$Animation$_animate_timings$dyn_57625.call(null,this$);
}
});

var shadow$animate$Animation$_animate_delays$dyn_57630 = (function (this$){
var x__6346__auto__ = (((this$ == null))?null:this$);
var m__6347__auto__ = (shadow.animate._animate_delays[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,this$);
} else {
var m__6344__auto__ = (shadow.animate._animate_delays["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Animation.-animate-delays",this$);
}
}
});
/**
 * return a map of {attr transition-delay}
 */
shadow.animate._animate_delays = (function shadow$animate$_animate_delays(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$animate$Animation$_animate_delays$arity$1 == null)))))){
return this$.shadow$animate$Animation$_animate_delays$arity$1(this$);
} else {
return shadow$animate$Animation$_animate_delays$dyn_57630.call(null,this$);
}
});

shadow.animate.transition_string = (function shadow$animate$transition_string(duration,adef){
var timings = shadow.animate._animate_timings.call(null,adef);
var delays = shadow.animate._animate_delays.call(null,adef);
return clojure.string.join.call(null,", ",cljs.core.map.call(null,(function (p__57317){
var vec__57318 = p__57317;
var attr = cljs.core.nth.call(null,vec__57318,(0),null);
var timing = cljs.core.nth.call(null,vec__57318,(1),null);
return [cljs.core.name.call(null,attr)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(duration),"ms"," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timing),(function (){var delay = cljs.core.get.call(null,delays,attr);
if(cljs.core.truth_((function (){var and__5583__auto__ = delay;
if(cljs.core.truth_(and__5583__auto__)){
return (delay > (0));
} else {
return and__5583__auto__;
}
})())){
return [" ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(delay),"ms"].join('');
} else {
return null;
}
})()].join('');
}),timings));
});

/**
 * @interface
 */
shadow.animate.IAnimator = function(){};

var shadow$animate$IAnimator$get_duration$dyn_57642 = (function (animator){
var x__6346__auto__ = (((animator == null))?null:animator);
var m__6347__auto__ = (shadow.animate.get_duration[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,animator);
} else {
var m__6344__auto__ = (shadow.animate.get_duration["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,animator);
} else {
throw cljs.core.missing_protocol.call(null,"IAnimator.get-duration",animator);
}
}
});
shadow.animate.get_duration = (function shadow$animate$get_duration(animator){
if((((!((animator == null)))) && ((!((animator.shadow$animate$IAnimator$get_duration$arity$1 == null)))))){
return animator.shadow$animate$IAnimator$get_duration$arity$1(animator);
} else {
return shadow$animate$IAnimator$get_duration$dyn_57642.call(null,animator);
}
});

var shadow$animate$IAnimator$init_BANG_$dyn_57645 = (function (animator){
var x__6346__auto__ = (((animator == null))?null:animator);
var m__6347__auto__ = (shadow.animate.init_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,animator);
} else {
var m__6344__auto__ = (shadow.animate.init_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,animator);
} else {
throw cljs.core.missing_protocol.call(null,"IAnimator.init!",animator);
}
}
});
/**
 * apply the initial values
 */
shadow.animate.init_BANG_ = (function shadow$animate$init_BANG_(animator){
if((((!((animator == null)))) && ((!((animator.shadow$animate$IAnimator$init_BANG_$arity$1 == null)))))){
return animator.shadow$animate$IAnimator$init_BANG_$arity$1(animator);
} else {
return shadow$animate$IAnimator$init_BANG_$dyn_57645.call(null,animator);
}
});

var shadow$animate$IAnimator$start_BANG_$dyn_57650 = (function (animator){
var x__6346__auto__ = (((animator == null))?null:animator);
var m__6347__auto__ = (shadow.animate.start_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,animator);
} else {
var m__6344__auto__ = (shadow.animate.start_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,animator);
} else {
throw cljs.core.missing_protocol.call(null,"IAnimator.start!",animator);
}
}
});
/**
 * start the animation, must return a channel that closes once the animation is done
 */
shadow.animate.start_BANG_ = (function shadow$animate$start_BANG_(animator){
if((((!((animator == null)))) && ((!((animator.shadow$animate$IAnimator$start_BANG_$arity$1 == null)))))){
return animator.shadow$animate$IAnimator$start_BANG_$arity$1(animator);
} else {
return shadow$animate$IAnimator$start_BANG_$dyn_57650.call(null,animator);
}
});

var shadow$animate$IAnimator$finish_BANG_$dyn_57651 = (function (animator){
var x__6346__auto__ = (((animator == null))?null:animator);
var m__6347__auto__ = (shadow.animate.finish_BANG_[goog.typeOf(x__6346__auto__)]);
if((!((m__6347__auto__ == null)))){
return m__6347__auto__.call(null,animator);
} else {
var m__6344__auto__ = (shadow.animate.finish_BANG_["_"]);
if((!((m__6344__auto__ == null)))){
return m__6344__auto__.call(null,animator);
} else {
throw cljs.core.missing_protocol.call(null,"IAnimator.finish!",animator);
}
}
});
/**
 * cleanup
 */
shadow.animate.finish_BANG_ = (function shadow$animate$finish_BANG_(animator){
if((((!((animator == null)))) && ((!((animator.shadow$animate$IAnimator$finish_BANG_$arity$1 == null)))))){
return animator.shadow$animate$IAnimator$finish_BANG_$arity$1(animator);
} else {
return shadow$animate$IAnimator$finish_BANG_$dyn_57651.call(null,animator);
}
});


/**
* @constructor
 * @implements {shadow.animate.IAnimator}
*/
shadow.animate.Animator = (function (duration,items){
this.duration = duration;
this.items = items;
});
(shadow.animate.Animator.prototype.shadow$animate$IAnimator$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.animate.Animator.prototype.shadow$animate$IAnimator$get_duration$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.duration;
}));

(shadow.animate.Animator.prototype.shadow$animate$IAnimator$init_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var n__6679__auto__ = self__.items.length;
var i__55918__auto__ = (0);
while(true){
if((i__55918__auto__ < n__6679__auto__)){
var map__57358_57658 = (self__.items[i__55918__auto__]);
var map__57358_57659__$1 = (((((!((map__57358_57658 == null))))?(((((map__57358_57658.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57358_57658.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57358_57658):map__57358_57658);
var el_57660 = cljs.core.get.call(null,map__57358_57659__$1,new cljs.core.Keyword(null,"el","el",-1618201118));
var from_57661 = cljs.core.get.call(null,map__57358_57659__$1,new cljs.core.Keyword(null,"from","from",1815293044));
goog.style.setStyle(el_57660,from_57661);

var G__57687 = (i__55918__auto__ + (1));
i__55918__auto__ = G__57687;
continue;
} else {
return null;
}
break;
}
}));

(shadow.animate.Animator.prototype.shadow$animate$IAnimator$start_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var n__6679__auto__ = self__.items.length;
var i__55918__auto__ = (0);
while(true){
if((i__55918__auto__ < n__6679__auto__)){
var map__57360_57696 = (self__.items[i__55918__auto__]);
var map__57360_57697__$1 = (((((!((map__57360_57696 == null))))?(((((map__57360_57696.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57360_57696.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57360_57696):map__57360_57696);
var el_57698 = cljs.core.get.call(null,map__57360_57697__$1,new cljs.core.Keyword(null,"el","el",-1618201118));
var to_57699 = cljs.core.get.call(null,map__57360_57697__$1,new cljs.core.Keyword(null,"to","to",192099007));
var transition_57700 = cljs.core.get.call(null,map__57360_57697__$1,new cljs.core.Keyword(null,"transition","transition",765692007));
(to_57699["transition"] = transition_57700);

goog.style.setStyle(el_57698,to_57699);

var G__57705 = (i__55918__auto__ + (1));
i__55918__auto__ = G__57705;
continue;
} else {
return null;
}
break;
}
}));

(shadow.animate.Animator.prototype.shadow$animate$IAnimator$finish_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var n__6679__auto__ = self__.items.length;
var i__55918__auto__ = (0);
while(true){
if((i__55918__auto__ < n__6679__auto__)){
var map__57366_57707 = (self__.items[i__55918__auto__]);
var map__57366_57708__$1 = (((((!((map__57366_57707 == null))))?(((((map__57366_57707.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57366_57707.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57366_57707):map__57366_57707);
var el_57709 = cljs.core.get.call(null,map__57366_57708__$1,new cljs.core.Keyword(null,"el","el",-1618201118));
var toggles_57710 = cljs.core.get.call(null,map__57366_57708__$1,new cljs.core.Keyword(null,"toggles","toggles",1077909479));
(toggles_57710["transition"] = null);

goog.style.setStyle(el_57709,toggles_57710);

var G__57714 = (i__55918__auto__ + (1));
i__55918__auto__ = G__57714;
continue;
} else {
return null;
}
break;
}
}));

(shadow.animate.Animator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"duration","duration",-1210334701,null),new cljs.core.Symbol(null,"items","items",-1622480831,null)], null);
}));

(shadow.animate.Animator.cljs$lang$type = true);

(shadow.animate.Animator.cljs$lang$ctorStr = "shadow.animate/Animator");

(shadow.animate.Animator.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"shadow.animate/Animator");
}));

/**
 * Positional factory function for shadow.animate/Animator.
 */
shadow.animate.__GT_Animator = (function shadow$animate$__GT_Animator(duration,items){
return (new shadow.animate.Animator(duration,items));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.animate.AnimationStep = (function (el,from,to,toggles,transition,__meta,__extmap,__hash){
this.el = el;
this.from = from;
this.to = to;
this.toggles = toggles;
this.transition = transition;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.animate.AnimationStep.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6292__auto__,k__6293__auto__){
var self__ = this;
var this__6292__auto____$1 = this;
return this__6292__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__6293__auto__,null);
}));

(shadow.animate.AnimationStep.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6294__auto__,k57386,else__6295__auto__){
var self__ = this;
var this__6294__auto____$1 = this;
var G__57403 = k57386;
var G__57403__$1 = (((G__57403 instanceof cljs.core.Keyword))?G__57403.fqn:null);
switch (G__57403__$1) {
case "el":
return self__.el;

break;
case "from":
return self__.from;

break;
case "to":
return self__.to;

break;
case "toggles":
return self__.toggles;

break;
case "transition":
return self__.transition;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k57386,else__6295__auto__);

}
}));

(shadow.animate.AnimationStep.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__6311__auto__,f__6312__auto__,init__6313__auto__){
var self__ = this;
var this__6311__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__6314__auto__,p__57405){
var vec__57407 = p__57405;
var k__6315__auto__ = cljs.core.nth.call(null,vec__57407,(0),null);
var v__6316__auto__ = cljs.core.nth.call(null,vec__57407,(1),null);
return f__6312__auto__.call(null,ret__6314__auto__,k__6315__auto__,v__6316__auto__);
}),init__6313__auto__,this__6311__auto____$1);
}));

(shadow.animate.AnimationStep.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6306__auto__,writer__6307__auto__,opts__6308__auto__){
var self__ = this;
var this__6306__auto____$1 = this;
var pr_pair__6309__auto__ = (function (keyval__6310__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6307__auto__,cljs.core.pr_writer,""," ","",opts__6308__auto__,keyval__6310__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__6307__auto__,pr_pair__6309__auto__,"#shadow.animate.AnimationStep{",", ","}",opts__6308__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"el","el",-1618201118),self__.el],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"from","from",1815293044),self__.from],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"to","to",192099007),self__.to],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"toggles","toggles",1077909479),self__.toggles],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transition","transition",765692007),self__.transition],null))], null),self__.__extmap));
}));

(shadow.animate.AnimationStep.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__57385){
var self__ = this;
var G__57385__$1 = this;
return (new cljs.core.RecordIter((0),G__57385__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"el","el",-1618201118),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"to","to",192099007),new cljs.core.Keyword(null,"toggles","toggles",1077909479),new cljs.core.Keyword(null,"transition","transition",765692007)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(shadow.animate.AnimationStep.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6290__auto__){
var self__ = this;
var this__6290__auto____$1 = this;
return self__.__meta;
}));

(shadow.animate.AnimationStep.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6287__auto__){
var self__ = this;
var this__6287__auto____$1 = this;
return (new shadow.animate.AnimationStep(self__.el,self__.from,self__.to,self__.toggles,self__.transition,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.animate.AnimationStep.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6296__auto__){
var self__ = this;
var this__6296__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
}));

(shadow.animate.AnimationStep.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6288__auto__){
var self__ = this;
var this__6288__auto____$1 = this;
var h__6060__auto__ = self__.__hash;
if((!((h__6060__auto__ == null)))){
return h__6060__auto__;
} else {
var h__6060__auto____$1 = (function (coll__6289__auto__){
return (630436239 ^ cljs.core.hash_unordered_coll.call(null,coll__6289__auto__));
}).call(null,this__6288__auto____$1);
(self__.__hash = h__6060__auto____$1);

return h__6060__auto____$1;
}
}));

(shadow.animate.AnimationStep.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this57387,other57388){
var self__ = this;
var this57387__$1 = this;
return (((!((other57388 == null)))) && ((this57387__$1.constructor === other57388.constructor)) && (cljs.core._EQ_.call(null,this57387__$1.el,other57388.el)) && (cljs.core._EQ_.call(null,this57387__$1.from,other57388.from)) && (cljs.core._EQ_.call(null,this57387__$1.to,other57388.to)) && (cljs.core._EQ_.call(null,this57387__$1.toggles,other57388.toggles)) && (cljs.core._EQ_.call(null,this57387__$1.transition,other57388.transition)) && (cljs.core._EQ_.call(null,this57387__$1.__extmap,other57388.__extmap)));
}));

(shadow.animate.AnimationStep.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6301__auto__,k__6302__auto__){
var self__ = this;
var this__6301__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"el","el",-1618201118),null,new cljs.core.Keyword(null,"transition","transition",765692007),null,new cljs.core.Keyword(null,"toggles","toggles",1077909479),null,new cljs.core.Keyword(null,"from","from",1815293044),null,new cljs.core.Keyword(null,"to","to",192099007),null], null), null),k__6302__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6301__auto____$1),self__.__meta),k__6302__auto__);
} else {
return (new shadow.animate.AnimationStep(self__.el,self__.from,self__.to,self__.toggles,self__.transition,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6302__auto__)),null));
}
}));

(shadow.animate.AnimationStep.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6299__auto__,k__6300__auto__,G__57385){
var self__ = this;
var this__6299__auto____$1 = this;
var pred__57421 = cljs.core.keyword_identical_QMARK_;
var expr__57422 = k__6300__auto__;
if(cljs.core.truth_(pred__57421.call(null,new cljs.core.Keyword(null,"el","el",-1618201118),expr__57422))){
return (new shadow.animate.AnimationStep(G__57385,self__.from,self__.to,self__.toggles,self__.transition,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__57421.call(null,new cljs.core.Keyword(null,"from","from",1815293044),expr__57422))){
return (new shadow.animate.AnimationStep(self__.el,G__57385,self__.to,self__.toggles,self__.transition,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__57421.call(null,new cljs.core.Keyword(null,"to","to",192099007),expr__57422))){
return (new shadow.animate.AnimationStep(self__.el,self__.from,G__57385,self__.toggles,self__.transition,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__57421.call(null,new cljs.core.Keyword(null,"toggles","toggles",1077909479),expr__57422))){
return (new shadow.animate.AnimationStep(self__.el,self__.from,self__.to,G__57385,self__.transition,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__57421.call(null,new cljs.core.Keyword(null,"transition","transition",765692007),expr__57422))){
return (new shadow.animate.AnimationStep(self__.el,self__.from,self__.to,self__.toggles,G__57385,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.animate.AnimationStep(self__.el,self__.from,self__.to,self__.toggles,self__.transition,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6300__auto__,G__57385),null));
}
}
}
}
}
}));

(shadow.animate.AnimationStep.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6304__auto__){
var self__ = this;
var this__6304__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"el","el",-1618201118),self__.el,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"from","from",1815293044),self__.from,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"to","to",192099007),self__.to,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"toggles","toggles",1077909479),self__.toggles,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transition","transition",765692007),self__.transition,null))], null),self__.__extmap));
}));

(shadow.animate.AnimationStep.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6291__auto__,G__57385){
var self__ = this;
var this__6291__auto____$1 = this;
return (new shadow.animate.AnimationStep(self__.el,self__.from,self__.to,self__.toggles,self__.transition,G__57385,self__.__extmap,self__.__hash));
}));

(shadow.animate.AnimationStep.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6297__auto__,entry__6298__auto__){
var self__ = this;
var this__6297__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6298__auto__)){
return this__6297__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__6298__auto__,(0)),cljs.core._nth.call(null,entry__6298__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6297__auto____$1,entry__6298__auto__);
}
}));

(shadow.animate.AnimationStep.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"el","el",22330409,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"to","to",1832630534,null),new cljs.core.Symbol(null,"toggles","toggles",-1576526290,null),new cljs.core.Symbol(null,"transition","transition",-1888743762,null)], null);
}));

(shadow.animate.AnimationStep.cljs$lang$type = true);

(shadow.animate.AnimationStep.cljs$lang$ctorPrSeq = (function (this__6337__auto__){
return (new cljs.core.List(null,"shadow.animate/AnimationStep",null,(1),null));
}));

(shadow.animate.AnimationStep.cljs$lang$ctorPrWriter = (function (this__6337__auto__,writer__6338__auto__){
return cljs.core._write.call(null,writer__6338__auto__,"shadow.animate/AnimationStep");
}));

/**
 * Positional factory function for shadow.animate/AnimationStep.
 */
shadow.animate.__GT_AnimationStep = (function shadow$animate$__GT_AnimationStep(el,from,to,toggles,transition){
return (new shadow.animate.AnimationStep(el,from,to,toggles,transition,null,null,null));
});

/**
 * Factory function for shadow.animate/AnimationStep, taking a map of keywords to field values.
 */
shadow.animate.map__GT_AnimationStep = (function shadow$animate$map__GT_AnimationStep(G__57397){
var extmap__6333__auto__ = (function (){var G__57449 = cljs.core.dissoc.call(null,G__57397,new cljs.core.Keyword(null,"el","el",-1618201118),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"to","to",192099007),new cljs.core.Keyword(null,"toggles","toggles",1077909479),new cljs.core.Keyword(null,"transition","transition",765692007));
if(cljs.core.record_QMARK_.call(null,G__57397)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__57449);
} else {
return G__57449;
}
})();
return (new shadow.animate.AnimationStep(new cljs.core.Keyword(null,"el","el",-1618201118).cljs$core$IFn$_invoke$arity$1(G__57397),new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(G__57397),new cljs.core.Keyword(null,"to","to",192099007).cljs$core$IFn$_invoke$arity$1(G__57397),new cljs.core.Keyword(null,"toggles","toggles",1077909479).cljs$core$IFn$_invoke$arity$1(G__57397),new cljs.core.Keyword(null,"transition","transition",765692007).cljs$core$IFn$_invoke$arity$1(G__57397),null,cljs.core.not_empty.call(null,extmap__6333__auto__),null));
});

shadow.animate.setup = (function shadow$animate$setup(duration,elements){
var items = cljs.core.into_array.call(null,(function (){var iter__6519__auto__ = (function shadow$animate$setup_$_iter__57451(s__57452){
return (new cljs.core.LazySeq(null,(function (){
var s__57452__$1 = s__57452;
while(true){
var temp__5720__auto__ = cljs.core.seq.call(null,s__57452__$1);
if(temp__5720__auto__){
var s__57452__$2 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__57452__$2)){
var c__6517__auto__ = cljs.core.chunk_first.call(null,s__57452__$2);
var size__6518__auto__ = cljs.core.count.call(null,c__6517__auto__);
var b__57454 = cljs.core.chunk_buffer.call(null,size__6518__auto__);
if((function (){var i__57453 = (0);
while(true){
if((i__57453 < size__6518__auto__)){
var vec__57455 = cljs.core._nth.call(null,c__6517__auto__,i__57453);
var el = cljs.core.nth.call(null,vec__57455,(0),null);
var adef = cljs.core.nth.call(null,vec__57455,(1),null);
cljs.core.chunk_append.call(null,b__57454,(function (){
if((((!((adef == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === adef.shadow$animate$Animation$))))?true:(((!adef.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.animate.Animation,adef):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.animate.Animation,adef))){
} else {
throw cljs.core.ex_info.call(null,"invalid animation",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"el","el",-1618201118),el,new cljs.core.Keyword(null,"animation","animation",-1248293244),adef], null));
}

var from = shadow.animate._animate_from.call(null,adef);
var to = shadow.animate._animate_to.call(null,adef);
var toggles = shadow.animate._animate_toggles.call(null,adef);
return (new shadow.animate.AnimationStep(shadow.dom.dom_node.call(null,el),cljs.core.clj__GT_js.call(null,from),cljs.core.clj__GT_js.call(null,to),cljs.core.clj__GT_js.call(null,toggles),shadow.animate.transition_string.call(null,duration,adef),null,null,null));
})()
);

var G__57759 = (i__57453 + (1));
i__57453 = G__57759;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__57454),shadow$animate$setup_$_iter__57451.call(null,cljs.core.chunk_rest.call(null,s__57452__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__57454),null);
}
} else {
var vec__57459 = cljs.core.first.call(null,s__57452__$2);
var el = cljs.core.nth.call(null,vec__57459,(0),null);
var adef = cljs.core.nth.call(null,vec__57459,(1),null);
return cljs.core.cons.call(null,(function (){
if((((!((adef == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === adef.shadow$animate$Animation$))))?true:(((!adef.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,shadow.animate.Animation,adef):false)):cljs.core.native_satisfies_QMARK_.call(null,shadow.animate.Animation,adef))){
} else {
throw cljs.core.ex_info.call(null,"invalid animation",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"el","el",-1618201118),el,new cljs.core.Keyword(null,"animation","animation",-1248293244),adef], null));
}

var from = shadow.animate._animate_from.call(null,adef);
var to = shadow.animate._animate_to.call(null,adef);
var toggles = shadow.animate._animate_toggles.call(null,adef);
return (new shadow.animate.AnimationStep(shadow.dom.dom_node.call(null,el),cljs.core.clj__GT_js.call(null,from),cljs.core.clj__GT_js.call(null,to),cljs.core.clj__GT_js.call(null,toggles),shadow.animate.transition_string.call(null,duration,adef),null,null,null));
})()
,shadow$animate$setup_$_iter__57451.call(null,cljs.core.rest.call(null,s__57452__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6519__auto__.call(null,elements);
})());
return (new shadow.animate.Animator(duration,items));
});
shadow.animate.continue_BANG_ = (function shadow$animate$continue_BANG_(animator){
shadow.animate.start_BANG_.call(null,animator);

var c__54378__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__54379__auto__ = (function (){var switch__54294__auto__ = (function (state_57493){
var state_val_57494 = (state_57493[(1)]);
if((state_val_57494 === (1))){
var inst_57487 = shadow.animate.get_duration.call(null,animator);
var inst_57488 = cljs.core.async.timeout.call(null,inst_57487);
var state_57493__$1 = state_57493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57493__$1,(2),inst_57488);
} else {
if((state_val_57494 === (2))){
var inst_57490 = (state_57493[(2)]);
var inst_57491 = shadow.animate.finish_BANG_.call(null,animator);
var state_57493__$1 = (function (){var statearr_57495 = state_57493;
(statearr_57495[(7)] = inst_57490);

(statearr_57495[(8)] = inst_57491);

return statearr_57495;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57493__$1,new cljs.core.Keyword(null,"done","done",-889844188));
} else {
return null;
}
}
});
return (function() {
var shadow$animate$continue_BANG__$_state_machine__54295__auto__ = null;
var shadow$animate$continue_BANG__$_state_machine__54295__auto____0 = (function (){
var statearr_57500 = [null,null,null,null,null,null,null,null,null];
(statearr_57500[(0)] = shadow$animate$continue_BANG__$_state_machine__54295__auto__);

(statearr_57500[(1)] = (1));

return statearr_57500;
});
var shadow$animate$continue_BANG__$_state_machine__54295__auto____1 = (function (state_57493){
while(true){
var ret_value__54296__auto__ = (function (){try{while(true){
var result__54297__auto__ = switch__54294__auto__.call(null,state_57493);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54297__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54297__auto__;
}
break;
}
}catch (e57502){if((e57502 instanceof Object)){
var ex__54298__auto__ = e57502;
var statearr_57507_57766 = state_57493;
(statearr_57507_57766[(5)] = ex__54298__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57493);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57502;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54296__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57767 = state_57493;
state_57493 = G__57767;
continue;
} else {
return ret_value__54296__auto__;
}
break;
}
});
shadow$animate$continue_BANG__$_state_machine__54295__auto__ = function(state_57493){
switch(arguments.length){
case 0:
return shadow$animate$continue_BANG__$_state_machine__54295__auto____0.call(this);
case 1:
return shadow$animate$continue_BANG__$_state_machine__54295__auto____1.call(this,state_57493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$animate$continue_BANG__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$animate$continue_BANG__$_state_machine__54295__auto____0;
shadow$animate$continue_BANG__$_state_machine__54295__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$animate$continue_BANG__$_state_machine__54295__auto____1;
return shadow$animate$continue_BANG__$_state_machine__54295__auto__;
})()
})();
var state__54380__auto__ = (function (){var statearr_57510 = f__54379__auto__.call(null);
(statearr_57510[(6)] = c__54378__auto__);

return statearr_57510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54380__auto__);
}));

return c__54378__auto__;
});
shadow.animate.start = (function shadow$animate$start(duration,elements){
var animator = shadow.animate.setup.call(null,duration,elements);
shadow.animate.init_BANG_.call(null,animator);

return shadow.animate.continue_BANG_.call(null,animator);
});
/**
 * transition the given attr from -> to using timing function and delay
 * timing defaults to ease, delay to 0
 */
shadow.animate.transition = (function shadow$animate$transition(var_args){
var G__57531 = arguments.length;
switch (G__57531) {
case 3:
return shadow.animate.transition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.animate.transition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return shadow.animate.transition.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.animate.transition.cljs$core$IFn$_invoke$arity$3 = (function (attr,from,to){
return shadow.animate.transition.call(null,attr,from,to,"ease",(0));
}));

(shadow.animate.transition.cljs$core$IFn$_invoke$arity$4 = (function (attr,from,to,timing){
return shadow.animate.transition.call(null,attr,from,to,timing,(0));
}));

(shadow.animate.transition.cljs$core$IFn$_invoke$arity$5 = (function (attr,from,to,timing,delay){
if((typeof shadow !== 'undefined') && (typeof shadow.animate !== 'undefined') && (typeof shadow.animate.t_shadow$animate57546 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {shadow.animate.Animation}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
shadow.animate.t_shadow$animate57546 = (function (attr,from,to,timing,delay,meta57547){
this.attr = attr;
this.from = from;
this.to = to;
this.timing = timing;
this.delay = delay;
this.meta57547 = meta57547;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.animate.t_shadow$animate57546.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57548,meta57547__$1){
var self__ = this;
var _57548__$1 = this;
return (new shadow.animate.t_shadow$animate57546(self__.attr,self__.from,self__.to,self__.timing,self__.delay,meta57547__$1));
}));

(shadow.animate.t_shadow$animate57546.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57548){
var self__ = this;
var _57548__$1 = this;
return self__.meta57547;
}));

(shadow.animate.t_shadow$animate57546.prototype.shadow$animate$Animation$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.animate.t_shadow$animate57546.prototype.shadow$animate$Animation$_animate_from$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.createAsIfByAssoc([self__.attr,self__.from]);
}));

(shadow.animate.t_shadow$animate57546.prototype.shadow$animate$Animation$_animate_to$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.createAsIfByAssoc([self__.attr,self__.to]);
}));

(shadow.animate.t_shadow$animate57546.prototype.shadow$animate$Animation$_animate_toggles$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57546.prototype.shadow$animate$Animation$_animate_timings$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.createAsIfByAssoc([self__.attr,self__.timing]);
}));

(shadow.animate.t_shadow$animate57546.prototype.shadow$animate$Animation$_animate_delays$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.createAsIfByAssoc([self__.attr,self__.delay]);
}));

(shadow.animate.t_shadow$animate57546.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"attr","attr",1036399174,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"to","to",1832630534,null),new cljs.core.Symbol(null,"timing","timing",-208693668,null),new cljs.core.Symbol(null,"delay","delay",1066306308,null),new cljs.core.Symbol(null,"meta57547","meta57547",-2099638914,null)], null);
}));

(shadow.animate.t_shadow$animate57546.cljs$lang$type = true);

(shadow.animate.t_shadow$animate57546.cljs$lang$ctorStr = "shadow.animate/t_shadow$animate57546");

(shadow.animate.t_shadow$animate57546.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"shadow.animate/t_shadow$animate57546");
}));

/**
 * Positional factory function for shadow.animate/t_shadow$animate57546.
 */
shadow.animate.__GT_t_shadow$animate57546 = (function shadow$animate$__GT_t_shadow$animate57546(attr__$1,from__$1,to__$1,timing__$1,delay__$1,meta57547){
return (new shadow.animate.t_shadow$animate57546(attr__$1,from__$1,to__$1,timing__$1,delay__$1,meta57547));
});

}

return (new shadow.animate.t_shadow$animate57546(attr,from,to,timing,delay,cljs.core.PersistentArrayMap.EMPTY));
}));

(shadow.animate.transition.cljs$lang$maxFixedArity = 5);

shadow.animate.toggle = (function shadow$animate$toggle(attr,from,to){
if((typeof shadow !== 'undefined') && (typeof shadow.animate !== 'undefined') && (typeof shadow.animate.t_shadow$animate57583 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {shadow.animate.Animation}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
shadow.animate.t_shadow$animate57583 = (function (attr,from,to,meta57584){
this.attr = attr;
this.from = from;
this.to = to;
this.meta57584 = meta57584;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.animate.t_shadow$animate57583.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57585,meta57584__$1){
var self__ = this;
var _57585__$1 = this;
return (new shadow.animate.t_shadow$animate57583(self__.attr,self__.from,self__.to,meta57584__$1));
}));

(shadow.animate.t_shadow$animate57583.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57585){
var self__ = this;
var _57585__$1 = this;
return self__.meta57584;
}));

(shadow.animate.t_shadow$animate57583.prototype.shadow$animate$Animation$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.animate.t_shadow$animate57583.prototype.shadow$animate$Animation$_animate_to$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57583.prototype.shadow$animate$Animation$_animate_from$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.createAsIfByAssoc([self__.attr,self__.from]);
}));

(shadow.animate.t_shadow$animate57583.prototype.shadow$animate$Animation$_animate_toggles$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.createAsIfByAssoc([self__.attr,self__.to]);
}));

(shadow.animate.t_shadow$animate57583.prototype.shadow$animate$Animation$_animate_timings$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57583.prototype.shadow$animate$Animation$_animate_delays$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57583.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"attr","attr",1036399174,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"to","to",1832630534,null),new cljs.core.Symbol(null,"meta57584","meta57584",-435972011,null)], null);
}));

(shadow.animate.t_shadow$animate57583.cljs$lang$type = true);

(shadow.animate.t_shadow$animate57583.cljs$lang$ctorStr = "shadow.animate/t_shadow$animate57583");

(shadow.animate.t_shadow$animate57583.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"shadow.animate/t_shadow$animate57583");
}));

/**
 * Positional factory function for shadow.animate/t_shadow$animate57583.
 */
shadow.animate.__GT_t_shadow$animate57583 = (function shadow$animate$toggle_$___GT_t_shadow$animate57583(attr__$1,from__$1,to__$1,meta57584){
return (new shadow.animate.t_shadow$animate57583(attr__$1,from__$1,to__$1,meta57584));
});

}

return (new shadow.animate.t_shadow$animate57583(attr,from,to,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * set attr to value when the animation starts
 */
shadow.animate.set_attr = (function shadow$animate$set_attr(var_args){
var G__57587 = arguments.length;
switch (G__57587) {
case 1:
return shadow.animate.set_attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.animate.set_attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.animate.set_attr.cljs$core$IFn$_invoke$arity$1 = (function (attrs){
if((typeof shadow !== 'undefined') && (typeof shadow.animate !== 'undefined') && (typeof shadow.animate.t_shadow$animate57588 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {shadow.animate.Animation}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
shadow.animate.t_shadow$animate57588 = (function (attrs,meta57589){
this.attrs = attrs;
this.meta57589 = meta57589;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.animate.t_shadow$animate57588.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57590,meta57589__$1){
var self__ = this;
var _57590__$1 = this;
return (new shadow.animate.t_shadow$animate57588(self__.attrs,meta57589__$1));
}));

(shadow.animate.t_shadow$animate57588.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57590){
var self__ = this;
var _57590__$1 = this;
return self__.meta57589;
}));

(shadow.animate.t_shadow$animate57588.prototype.shadow$animate$Animation$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.animate.t_shadow$animate57588.prototype.shadow$animate$Animation$_animate_to$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57588.prototype.shadow$animate$Animation$_animate_from$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.attrs;
}));

(shadow.animate.t_shadow$animate57588.prototype.shadow$animate$Animation$_animate_toggles$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57588.prototype.shadow$animate$Animation$_animate_timings$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57588.prototype.shadow$animate$Animation$_animate_delays$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57588.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta57589","meta57589",103719693,null)], null);
}));

(shadow.animate.t_shadow$animate57588.cljs$lang$type = true);

(shadow.animate.t_shadow$animate57588.cljs$lang$ctorStr = "shadow.animate/t_shadow$animate57588");

(shadow.animate.t_shadow$animate57588.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"shadow.animate/t_shadow$animate57588");
}));

/**
 * Positional factory function for shadow.animate/t_shadow$animate57588.
 */
shadow.animate.__GT_t_shadow$animate57588 = (function shadow$animate$__GT_t_shadow$animate57588(attrs__$1,meta57589){
return (new shadow.animate.t_shadow$animate57588(attrs__$1,meta57589));
});

}

return (new shadow.animate.t_shadow$animate57588(attrs,cljs.core.PersistentArrayMap.EMPTY));
}));

(shadow.animate.set_attr.cljs$core$IFn$_invoke$arity$2 = (function (attr,value){
return shadow.animate.set_attr.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([attr,value]));
}));

(shadow.animate.set_attr.cljs$lang$maxFixedArity = 2);

/**
 * use to remove a given attribute style when the animation is finished
 * usually only needed to remove attributes we no longer need since they are probably
 * inherited and we only used for previous transitions
 */
shadow.animate.delete_attr = (function shadow$animate$delete_attr(attr){
if((typeof shadow !== 'undefined') && (typeof shadow.animate !== 'undefined') && (typeof shadow.animate.t_shadow$animate57591 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {shadow.animate.Animation}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
shadow.animate.t_shadow$animate57591 = (function (attr,meta57592){
this.attr = attr;
this.meta57592 = meta57592;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.animate.t_shadow$animate57591.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57593,meta57592__$1){
var self__ = this;
var _57593__$1 = this;
return (new shadow.animate.t_shadow$animate57591(self__.attr,meta57592__$1));
}));

(shadow.animate.t_shadow$animate57591.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57593){
var self__ = this;
var _57593__$1 = this;
return self__.meta57592;
}));

(shadow.animate.t_shadow$animate57591.prototype.shadow$animate$Animation$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.animate.t_shadow$animate57591.prototype.shadow$animate$Animation$_animate_to$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57591.prototype.shadow$animate$Animation$_animate_from$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57591.prototype.shadow$animate$Animation$_animate_toggles$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.createAsIfByAssoc([self__.attr,null]);
}));

(shadow.animate.t_shadow$animate57591.prototype.shadow$animate$Animation$_animate_timings$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57591.prototype.shadow$animate$Animation$_animate_delays$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57591.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"attr","attr",1036399174,null),new cljs.core.Symbol(null,"meta57592","meta57592",876687372,null)], null);
}));

(shadow.animate.t_shadow$animate57591.cljs$lang$type = true);

(shadow.animate.t_shadow$animate57591.cljs$lang$ctorStr = "shadow.animate/t_shadow$animate57591");

(shadow.animate.t_shadow$animate57591.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"shadow.animate/t_shadow$animate57591");
}));

/**
 * Positional factory function for shadow.animate/t_shadow$animate57591.
 */
shadow.animate.__GT_t_shadow$animate57591 = (function shadow$animate$delete_attr_$___GT_t_shadow$animate57591(attr__$1,meta57592){
return (new shadow.animate.t_shadow$animate57591(attr__$1,meta57592));
});

}

return (new shadow.animate.t_shadow$animate57591(attr,cljs.core.PersistentArrayMap.EMPTY));
});
shadow.animate.combine = (function shadow$animate$combine(var_args){
var args__6930__auto__ = [];
var len__6920__auto___57816 = arguments.length;
var i__6921__auto___57820 = (0);
while(true){
if((i__6921__auto___57820 < len__6920__auto___57816)){
args__6930__auto__.push((arguments[i__6921__auto___57820]));

var G__57823 = (i__6921__auto___57820 + (1));
i__6921__auto___57820 = G__57823;
continue;
} else {
}
break;
}

var argseq__6931__auto__ = ((((0) < args__6930__auto__.length))?(new cljs.core.IndexedSeq(args__6930__auto__.slice((0)),(0),null)):null);
return shadow.animate.combine.cljs$core$IFn$_invoke$arity$variadic(argseq__6931__auto__);
});

(shadow.animate.combine.cljs$core$IFn$_invoke$arity$variadic = (function (transitions){
var to = cljs.core.PersistentArrayMap.EMPTY;
var from = cljs.core.PersistentArrayMap.EMPTY;
var toggles = cljs.core.PersistentArrayMap.EMPTY;
var timings = cljs.core.PersistentArrayMap.EMPTY;
var delays = cljs.core.PersistentArrayMap.EMPTY;
var transitions__$1 = transitions;
while(true){
var temp__5718__auto__ = cljs.core.first.call(null,transitions__$1);
if(cljs.core.truth_(temp__5718__auto__)){
var adef = temp__5718__auto__;
var G__57829 = cljs.core.merge.call(null,to,shadow.animate._animate_to.call(null,adef));
var G__57830 = cljs.core.merge.call(null,from,shadow.animate._animate_from.call(null,adef));
var G__57831 = cljs.core.merge.call(null,toggles,shadow.animate._animate_toggles.call(null,adef));
var G__57832 = cljs.core.merge.call(null,timings,shadow.animate._animate_timings.call(null,adef));
var G__57833 = cljs.core.merge.call(null,delays,shadow.animate._animate_delays.call(null,adef));
var G__57834 = cljs.core.rest.call(null,transitions__$1);
to = G__57829;
from = G__57830;
toggles = G__57831;
timings = G__57832;
delays = G__57833;
transitions__$1 = G__57834;
continue;
} else {
if((typeof shadow !== 'undefined') && (typeof shadow.animate !== 'undefined') && (typeof shadow.animate.t_shadow$animate57598 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {shadow.animate.Animation}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
shadow.animate.t_shadow$animate57598 = (function (transitions,to,from,toggles,timings,delays,temp__5718__auto__,meta57599){
this.transitions = transitions;
this.to = to;
this.from = from;
this.toggles = toggles;
this.timings = timings;
this.delays = delays;
this.temp__5718__auto__ = temp__5718__auto__;
this.meta57599 = meta57599;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.animate.t_shadow$animate57598.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__){
return (function (_57600,meta57599__$1){
var self__ = this;
var _57600__$1 = this;
return (new shadow.animate.t_shadow$animate57598(self__.transitions,self__.to,self__.from,self__.toggles,self__.timings,self__.delays,self__.temp__5718__auto__,meta57599__$1));
});})(to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__))
);

(shadow.animate.t_shadow$animate57598.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__){
return (function (_57600){
var self__ = this;
var _57600__$1 = this;
return self__.meta57599;
});})(to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__))
);

(shadow.animate.t_shadow$animate57598.prototype.shadow$animate$Animation$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.animate.t_shadow$animate57598.prototype.shadow$animate$Animation$_animate_from$arity$1 = ((function (to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.from;
});})(to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__))
);

(shadow.animate.t_shadow$animate57598.prototype.shadow$animate$Animation$_animate_to$arity$1 = ((function (to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.to;
});})(to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__))
);

(shadow.animate.t_shadow$animate57598.prototype.shadow$animate$Animation$_animate_toggles$arity$1 = ((function (to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.toggles;
});})(to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__))
);

(shadow.animate.t_shadow$animate57598.prototype.shadow$animate$Animation$_animate_timings$arity$1 = ((function (to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.timings;
});})(to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__))
);

(shadow.animate.t_shadow$animate57598.prototype.shadow$animate$Animation$_animate_delays$arity$1 = ((function (to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.delays;
});})(to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__))
);

(shadow.animate.t_shadow$animate57598.getBasis = ((function (to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"transitions","transitions",-405684594,null),cljs.core.with_meta(new cljs.core.Symbol(null,"to","to",1832630534,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"toggles","toggles",-1576526290,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"timings","timings",-569636600,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"delays","delays",-873843187,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)),new cljs.core.Symbol(null,"temp__5718__auto__","temp__5718__auto__",1260893202,null),new cljs.core.Symbol(null,"meta57599","meta57599",-781533021,null)], null);
});})(to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__))
);

(shadow.animate.t_shadow$animate57598.cljs$lang$type = true);

(shadow.animate.t_shadow$animate57598.cljs$lang$ctorStr = "shadow.animate/t_shadow$animate57598");

(shadow.animate.t_shadow$animate57598.cljs$lang$ctorPrWriter = ((function (to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__){
return (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"shadow.animate/t_shadow$animate57598");
});})(to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__))
);

/**
 * Positional factory function for shadow.animate/t_shadow$animate57598.
 */
shadow.animate.__GT_t_shadow$animate57598 = ((function (to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__){
return (function shadow$animate$__GT_t_shadow$animate57598(transitions__$2,to__$1,from__$1,toggles__$1,timings__$1,delays__$1,temp__5718__auto____$1,meta57599){
return (new shadow.animate.t_shadow$animate57598(transitions__$2,to__$1,from__$1,toggles__$1,timings__$1,delays__$1,temp__5718__auto____$1,meta57599));
});})(to,from,toggles,timings,delays,transitions__$1,temp__5718__auto__))
;

}

return (new shadow.animate.t_shadow$animate57598(transitions__$1,to,from,toggles,timings,delays,temp__5718__auto__,cljs.core.PersistentArrayMap.EMPTY));
}
break;
}
}));

(shadow.animate.combine.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.animate.combine.cljs$lang$applyTo = (function (seq57594){
var self__6906__auto__ = this;
return self__6906__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq57594));
}));

shadow.animate.fade_in = (function shadow$animate$fade_in(var_args){
var G__57602 = arguments.length;
switch (G__57602) {
case 0:
return shadow.animate.fade_in.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.animate.fade_in.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.animate.fade_in.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.animate.fade_in.call(null,"ease-in");
}));

(shadow.animate.fade_in.cljs$core$IFn$_invoke$arity$1 = (function (timing_function){
return shadow.animate.transition.call(null,new cljs.core.Keyword(null,"opacity","opacity",397153780),"0","1",timing_function);
}));

(shadow.animate.fade_in.cljs$lang$maxFixedArity = 1);

shadow.animate.fade_out = (function shadow$animate$fade_out(var_args){
var G__57604 = arguments.length;
switch (G__57604) {
case 0:
return shadow.animate.fade_out.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.animate.fade_out.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.animate.fade_out.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.animate.fade_in.call(null,"ease-out");
}));

(shadow.animate.fade_out.cljs$core$IFn$_invoke$arity$1 = (function (timing_function){
return shadow.animate.transition.call(null,new cljs.core.Keyword(null,"opacity","opacity",397153780),"1","0",timing_function);
}));

(shadow.animate.fade_out.cljs$lang$maxFixedArity = 1);

shadow.animate.vendor_prefix = goog.dom.vendor.getVendorPrefix();
shadow.animate.vendor_transform = cljs.core.keyword.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.animate.vendor_prefix),"-transform"].join(''));
shadow.animate.translate_y = (function shadow$animate$translate_y(var_args){
var G__57606 = arguments.length;
switch (G__57606) {
case 3:
return shadow.animate.translate_y.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.animate.translate_y.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.animate.translate_y.cljs$core$IFn$_invoke$arity$3 = (function (from,to,timing){
return shadow.animate.translate_y.call(null,from,to,timing,(0));
}));

(shadow.animate.translate_y.cljs$core$IFn$_invoke$arity$4 = (function (from,to,timing,delay){
if((typeof shadow !== 'undefined') && (typeof shadow.animate !== 'undefined') && (typeof shadow.animate.t_shadow$animate57607 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {shadow.animate.Animation}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
shadow.animate.t_shadow$animate57607 = (function (from,to,timing,delay,meta57608){
this.from = from;
this.to = to;
this.timing = timing;
this.delay = delay;
this.meta57608 = meta57608;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.animate.t_shadow$animate57607.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57609,meta57608__$1){
var self__ = this;
var _57609__$1 = this;
return (new shadow.animate.t_shadow$animate57607(self__.from,self__.to,self__.timing,self__.delay,meta57608__$1));
}));

(shadow.animate.t_shadow$animate57607.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57609){
var self__ = this;
var _57609__$1 = this;
return self__.meta57608;
}));

(shadow.animate.t_shadow$animate57607.prototype.shadow$animate$Animation$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.animate.t_shadow$animate57607.prototype.shadow$animate$Animation$_animate_from$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),["translateY(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.from),")"].join('')], null);
}));

(shadow.animate.t_shadow$animate57607.prototype.shadow$animate$Animation$_animate_to$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),["translateY(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.to),")"].join('')], null);
}));

(shadow.animate.t_shadow$animate57607.prototype.shadow$animate$Animation$_animate_timings$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.createAsIfByAssoc([shadow.animate.vendor_transform,self__.timing]);
}));

(shadow.animate.t_shadow$animate57607.prototype.shadow$animate$Animation$_animate_toggles$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57607.prototype.shadow$animate$Animation$_animate_delays$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.createAsIfByAssoc([shadow.animate.vendor_transform,self__.delay]);
}));

(shadow.animate.t_shadow$animate57607.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"to","to",1832630534,null),new cljs.core.Symbol(null,"timing","timing",-208693668,null),new cljs.core.Symbol(null,"delay","delay",1066306308,null),new cljs.core.Symbol(null,"meta57608","meta57608",1862200995,null)], null);
}));

(shadow.animate.t_shadow$animate57607.cljs$lang$type = true);

(shadow.animate.t_shadow$animate57607.cljs$lang$ctorStr = "shadow.animate/t_shadow$animate57607");

(shadow.animate.t_shadow$animate57607.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"shadow.animate/t_shadow$animate57607");
}));

/**
 * Positional factory function for shadow.animate/t_shadow$animate57607.
 */
shadow.animate.__GT_t_shadow$animate57607 = (function shadow$animate$__GT_t_shadow$animate57607(from__$1,to__$1,timing__$1,delay__$1,meta57608){
return (new shadow.animate.t_shadow$animate57607(from__$1,to__$1,timing__$1,delay__$1,meta57608));
});

}

return (new shadow.animate.t_shadow$animate57607(from,to,timing,delay,cljs.core.PersistentArrayMap.EMPTY));
}));

(shadow.animate.translate_y.cljs$lang$maxFixedArity = 4);

shadow.animate.translate_x = (function shadow$animate$translate_x(var_args){
var G__57611 = arguments.length;
switch (G__57611) {
case 3:
return shadow.animate.translate_x.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.animate.translate_x.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.animate.translate_x.cljs$core$IFn$_invoke$arity$3 = (function (from,to,timing){
return shadow.animate.translate_x.call(null,from,to,timing,(0));
}));

(shadow.animate.translate_x.cljs$core$IFn$_invoke$arity$4 = (function (from,to,timing,delay){
if((typeof shadow !== 'undefined') && (typeof shadow.animate !== 'undefined') && (typeof shadow.animate.t_shadow$animate57612 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {shadow.animate.Animation}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
shadow.animate.t_shadow$animate57612 = (function (from,to,timing,delay,meta57613){
this.from = from;
this.to = to;
this.timing = timing;
this.delay = delay;
this.meta57613 = meta57613;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.animate.t_shadow$animate57612.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57614,meta57613__$1){
var self__ = this;
var _57614__$1 = this;
return (new shadow.animate.t_shadow$animate57612(self__.from,self__.to,self__.timing,self__.delay,meta57613__$1));
}));

(shadow.animate.t_shadow$animate57612.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57614){
var self__ = this;
var _57614__$1 = this;
return self__.meta57613;
}));

(shadow.animate.t_shadow$animate57612.prototype.shadow$animate$Animation$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.animate.t_shadow$animate57612.prototype.shadow$animate$Animation$_animate_from$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),["translateX(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.from),")"].join('')], null);
}));

(shadow.animate.t_shadow$animate57612.prototype.shadow$animate$Animation$_animate_to$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform","transform",1381301764),["translateX(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.to),")"].join('')], null);
}));

(shadow.animate.t_shadow$animate57612.prototype.shadow$animate$Animation$_animate_timings$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.createAsIfByAssoc([shadow.animate.vendor_transform,self__.timing]);
}));

(shadow.animate.t_shadow$animate57612.prototype.shadow$animate$Animation$_animate_toggles$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.EMPTY;
}));

(shadow.animate.t_shadow$animate57612.prototype.shadow$animate$Animation$_animate_delays$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.PersistentArrayMap.createAsIfByAssoc([shadow.animate.vendor_transform,self__.delay]);
}));

(shadow.animate.t_shadow$animate57612.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"to","to",1832630534,null),new cljs.core.Symbol(null,"timing","timing",-208693668,null),new cljs.core.Symbol(null,"delay","delay",1066306308,null),new cljs.core.Symbol(null,"meta57613","meta57613",-1618368853,null)], null);
}));

(shadow.animate.t_shadow$animate57612.cljs$lang$type = true);

(shadow.animate.t_shadow$animate57612.cljs$lang$ctorStr = "shadow.animate/t_shadow$animate57612");

(shadow.animate.t_shadow$animate57612.cljs$lang$ctorPrWriter = (function (this__6275__auto__,writer__6276__auto__,opt__6277__auto__){
return cljs.core._write.call(null,writer__6276__auto__,"shadow.animate/t_shadow$animate57612");
}));

/**
 * Positional factory function for shadow.animate/t_shadow$animate57612.
 */
shadow.animate.__GT_t_shadow$animate57612 = (function shadow$animate$__GT_t_shadow$animate57612(from__$1,to__$1,timing__$1,delay__$1,meta57613){
return (new shadow.animate.t_shadow$animate57612(from__$1,to__$1,timing__$1,delay__$1,meta57613));
});

}

return (new shadow.animate.t_shadow$animate57612(from,to,timing,delay,cljs.core.PersistentArrayMap.EMPTY));
}));

(shadow.animate.translate_x.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.animate.js.map
