goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__52233){
var map__52234 = p__52233;
var map__52234__$1 = (((((!((map__52234 == null))))?(((((map__52234.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52234.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52234):map__52234);
var m = map__52234__$1;
var n = cljs.core.get.call(null,map__52234__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__52234__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__5598__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return [(function (){var temp__5720__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__52241_52335 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__52242_52336 = null;
var count__52243_52337 = (0);
var i__52244_52338 = (0);
while(true){
if((i__52244_52338 < count__52243_52337)){
var f_52339 = cljs.core._nth.call(null,chunk__52242_52336,i__52244_52338);
cljs.core.println.call(null,"  ",f_52339);


var G__52340 = seq__52241_52335;
var G__52341 = chunk__52242_52336;
var G__52342 = count__52243_52337;
var G__52343 = (i__52244_52338 + (1));
seq__52241_52335 = G__52340;
chunk__52242_52336 = G__52341;
count__52243_52337 = G__52342;
i__52244_52338 = G__52343;
continue;
} else {
var temp__5720__auto___52344 = cljs.core.seq.call(null,seq__52241_52335);
if(temp__5720__auto___52344){
var seq__52241_52345__$1 = temp__5720__auto___52344;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__52241_52345__$1)){
var c__6568__auto___52346 = cljs.core.chunk_first.call(null,seq__52241_52345__$1);
var G__52347 = cljs.core.chunk_rest.call(null,seq__52241_52345__$1);
var G__52348 = c__6568__auto___52346;
var G__52349 = cljs.core.count.call(null,c__6568__auto___52346);
var G__52350 = (0);
seq__52241_52335 = G__52347;
chunk__52242_52336 = G__52348;
count__52243_52337 = G__52349;
i__52244_52338 = G__52350;
continue;
} else {
var f_52351 = cljs.core.first.call(null,seq__52241_52345__$1);
cljs.core.println.call(null,"  ",f_52351);


var G__52352 = cljs.core.next.call(null,seq__52241_52345__$1);
var G__52353 = null;
var G__52354 = (0);
var G__52355 = (0);
seq__52241_52335 = G__52352;
chunk__52242_52336 = G__52353;
count__52243_52337 = G__52354;
i__52244_52338 = G__52355;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_52356 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__5598__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_52356);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_52356)))?cljs.core.second.call(null,arglists_52356):arglists_52356));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__52250_52357 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__52251_52358 = null;
var count__52252_52359 = (0);
var i__52253_52360 = (0);
while(true){
if((i__52253_52360 < count__52252_52359)){
var vec__52264_52361 = cljs.core._nth.call(null,chunk__52251_52358,i__52253_52360);
var name_52362 = cljs.core.nth.call(null,vec__52264_52361,(0),null);
var map__52267_52363 = cljs.core.nth.call(null,vec__52264_52361,(1),null);
var map__52267_52364__$1 = (((((!((map__52267_52363 == null))))?(((((map__52267_52363.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52267_52363.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52267_52363):map__52267_52363);
var doc_52365 = cljs.core.get.call(null,map__52267_52364__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_52366 = cljs.core.get.call(null,map__52267_52364__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_52362);

cljs.core.println.call(null," ",arglists_52366);

if(cljs.core.truth_(doc_52365)){
cljs.core.println.call(null," ",doc_52365);
} else {
}


var G__52367 = seq__52250_52357;
var G__52368 = chunk__52251_52358;
var G__52369 = count__52252_52359;
var G__52370 = (i__52253_52360 + (1));
seq__52250_52357 = G__52367;
chunk__52251_52358 = G__52368;
count__52252_52359 = G__52369;
i__52253_52360 = G__52370;
continue;
} else {
var temp__5720__auto___52371 = cljs.core.seq.call(null,seq__52250_52357);
if(temp__5720__auto___52371){
var seq__52250_52372__$1 = temp__5720__auto___52371;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__52250_52372__$1)){
var c__6568__auto___52373 = cljs.core.chunk_first.call(null,seq__52250_52372__$1);
var G__52374 = cljs.core.chunk_rest.call(null,seq__52250_52372__$1);
var G__52375 = c__6568__auto___52373;
var G__52376 = cljs.core.count.call(null,c__6568__auto___52373);
var G__52377 = (0);
seq__52250_52357 = G__52374;
chunk__52251_52358 = G__52375;
count__52252_52359 = G__52376;
i__52253_52360 = G__52377;
continue;
} else {
var vec__52272_52378 = cljs.core.first.call(null,seq__52250_52372__$1);
var name_52379 = cljs.core.nth.call(null,vec__52272_52378,(0),null);
var map__52275_52380 = cljs.core.nth.call(null,vec__52272_52378,(1),null);
var map__52275_52381__$1 = (((((!((map__52275_52380 == null))))?(((((map__52275_52380.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52275_52380.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52275_52380):map__52275_52380);
var doc_52382 = cljs.core.get.call(null,map__52275_52381__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_52383 = cljs.core.get.call(null,map__52275_52381__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_52379);

cljs.core.println.call(null," ",arglists_52383);

if(cljs.core.truth_(doc_52382)){
cljs.core.println.call(null," ",doc_52382);
} else {
}


var G__52384 = cljs.core.next.call(null,seq__52250_52372__$1);
var G__52385 = null;
var G__52386 = (0);
var G__52387 = (0);
seq__52250_52357 = G__52384;
chunk__52251_52358 = G__52385;
count__52252_52359 = G__52386;
i__52253_52360 = G__52387;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5720__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5720__auto__)){
var fnspec = temp__5720__auto__;
cljs.core.print.call(null,"Spec");

var seq__52277 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__52278 = null;
var count__52279 = (0);
var i__52280 = (0);
while(true){
if((i__52280 < count__52279)){
var role = cljs.core._nth.call(null,chunk__52278,i__52280);
var temp__5720__auto___52390__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5720__auto___52390__$1)){
var spec_52391 = temp__5720__auto___52390__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_52391));
} else {
}


var G__52392 = seq__52277;
var G__52393 = chunk__52278;
var G__52394 = count__52279;
var G__52395 = (i__52280 + (1));
seq__52277 = G__52392;
chunk__52278 = G__52393;
count__52279 = G__52394;
i__52280 = G__52395;
continue;
} else {
var temp__5720__auto____$1 = cljs.core.seq.call(null,seq__52277);
if(temp__5720__auto____$1){
var seq__52277__$1 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__52277__$1)){
var c__6568__auto__ = cljs.core.chunk_first.call(null,seq__52277__$1);
var G__52396 = cljs.core.chunk_rest.call(null,seq__52277__$1);
var G__52397 = c__6568__auto__;
var G__52398 = cljs.core.count.call(null,c__6568__auto__);
var G__52399 = (0);
seq__52277 = G__52396;
chunk__52278 = G__52397;
count__52279 = G__52398;
i__52280 = G__52399;
continue;
} else {
var role = cljs.core.first.call(null,seq__52277__$1);
var temp__5720__auto___52400__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5720__auto___52400__$2)){
var spec_52401 = temp__5720__auto___52400__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_52401));
} else {
}


var G__52402 = cljs.core.next.call(null,seq__52277__$1);
var G__52403 = null;
var G__52404 = (0);
var G__52405 = (0);
seq__52277 = G__52402;
chunk__52278 = G__52403;
count__52279 = G__52404;
i__52280 = G__52405;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof Error))?cljs.core.symbol.call(null,"js",t.name):null
))], null),(function (){var temp__5720__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5720__auto__)){
var msg = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5720__auto__)){
var ed = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__52406 = cljs.core.conj.call(null,via,t);
var G__52407 = cljs.core.ex_cause.call(null,t);
via = G__52406;
t = G__52407;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5720__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5720__auto__)){
var root_msg = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5720__auto__)){
var data = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5720__auto__)){
var phase = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__52291 = datafied_throwable;
var map__52291__$1 = (((((!((map__52291 == null))))?(((((map__52291.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52291.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52291):map__52291);
var via = cljs.core.get.call(null,map__52291__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__52291__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__52291__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__52292 = cljs.core.last.call(null,via);
var map__52292__$1 = (((((!((map__52292 == null))))?(((((map__52292.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52292.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52292):map__52292);
var type = cljs.core.get.call(null,map__52292__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__52292__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__52292__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__52293 = data;
var map__52293__$1 = (((((!((map__52293 == null))))?(((((map__52293.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52293.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52293):map__52293);
var problems = cljs.core.get.call(null,map__52293__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__52293__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__52293__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__52294 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__52294__$1 = (((((!((map__52294 == null))))?(((((map__52294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52294.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52294):map__52294);
var top_data = map__52294__$1;
var source = cljs.core.get.call(null,map__52294__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__52306 = phase;
var G__52306__$1 = (((G__52306 instanceof cljs.core.Keyword))?G__52306.fqn:null);
switch (G__52306__$1) {
case "read-source":
var map__52307 = data;
var map__52307__$1 = (((((!((map__52307 == null))))?(((((map__52307.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52307.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52307):map__52307);
var line = cljs.core.get.call(null,map__52307__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__52307__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__52309 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__52309__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__52309,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__52309);
var G__52309__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__52309__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__52309__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__52309__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__52309__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__52310 = top_data;
var G__52310__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__52310,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__52310);
var G__52310__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__52310__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__52310__$1);
var G__52310__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__52310__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__52310__$2);
var G__52310__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__52310__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__52310__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__52310__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__52310__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__52312 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__52312,(0),null);
var method = cljs.core.nth.call(null,vec__52312,(1),null);
var file = cljs.core.nth.call(null,vec__52312,(2),null);
var line = cljs.core.nth.call(null,vec__52312,(3),null);
var G__52315 = top_data;
var G__52315__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__52315,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__52315);
var G__52315__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__52315__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__52315__$1);
var G__52315__$3 = (cljs.core.truth_((function (){var and__5583__auto__ = source__$1;
if(cljs.core.truth_(and__5583__auto__)){
return method;
} else {
return and__5583__auto__;
}
})())?cljs.core.assoc.call(null,G__52315__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__52315__$2);
var G__52315__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__52315__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__52315__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__52315__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__52315__$4;
}

break;
case "execution":
var vec__52316 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__52316,(0),null);
var method = cljs.core.nth.call(null,vec__52316,(1),null);
var file = cljs.core.nth.call(null,vec__52316,(2),null);
var line = cljs.core.nth.call(null,vec__52316,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,(function (p1__52287_SHARP_){
var or__5598__auto__ = (p1__52287_SHARP_ == null);
if(or__5598__auto__){
return or__5598__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__52287_SHARP_);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__5598__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return line;
}
})();
var G__52319 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__52319__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__52319,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__52319);
var G__52319__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__52319__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__52319__$1);
var G__52319__$3 = (cljs.core.truth_((function (){var or__5598__auto__ = fn;
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
var and__5583__auto__ = source__$1;
if(cljs.core.truth_(and__5583__auto__)){
return method;
} else {
return and__5583__auto__;
}
}
})())?cljs.core.assoc.call(null,G__52319__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__5598__auto__ = fn;
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__52319__$2);
var G__52319__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__52319__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__52319__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__52319__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__52319__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__52306__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__52322){
var map__52323 = p__52322;
var map__52323__$1 = (((((!((map__52323 == null))))?(((((map__52323.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52323.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__52323):map__52323);
var triage_data = map__52323__$1;
var phase = cljs.core.get.call(null,map__52323__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__52323__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__52323__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__52323__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__52323__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__52323__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__52323__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__52323__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5598__auto__ = source;
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5598__auto__ = line;
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__5598__auto__ = class$;
if(cljs.core.truth_(or__5598__auto__)){
return or__5598__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__52325 = phase;
var G__52325__$1 = (((G__52325 instanceof cljs.core.Keyword))?G__52325.fqn:null);
switch (G__52325__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__6761__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__52326_52432 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__52327_52433 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__52328_52434 = true;
var _STAR_print_fn_STAR__temp_val__52329_52435 = (function (x__6762__auto__){
return sb__6761__auto__.append(x__6762__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__52328_52434);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__52329_52435);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__52320_SHARP_){
return cljs.core.dissoc.call(null,p1__52320_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__52327_52433);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__52326_52432);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__6761__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__6761__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__52331_52438 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__52332_52439 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__52333_52440 = true;
var _STAR_print_fn_STAR__temp_val__52334_52441 = (function (x__6762__auto__){
return sb__6761__auto__.append(x__6762__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__52333_52440);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__52334_52441);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__52321_SHARP_){
return cljs.core.dissoc.call(null,p1__52321_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__52332_52439);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__52331_52438);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__6761__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__52325__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=cljs.repl.js.map
